/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DiskInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class InstanceStorageInfo
implements Serializable,
Cloneable {
    private Long totalSizeInGB;
    private SdkInternalList<DiskInfo> disks;

    public void setTotalSizeInGB(Long totalSizeInGB) {
        this.totalSizeInGB = totalSizeInGB;
    }

    public Long getTotalSizeInGB() {
        return this.totalSizeInGB;
    }

    public InstanceStorageInfo withTotalSizeInGB(Long totalSizeInGB) {
        this.setTotalSizeInGB(totalSizeInGB);
        return this;
    }

    public List<DiskInfo> getDisks() {
        if (this.disks == null) {
            this.disks = new SdkInternalList();
        }
        return this.disks;
    }

    public void setDisks(Collection<DiskInfo> disks) {
        if (disks == null) {
            this.disks = null;
            return;
        }
        this.disks = new SdkInternalList(disks);
    }

    public InstanceStorageInfo withDisks(DiskInfo ... disks) {
        if (this.disks == null) {
            this.setDisks((Collection<DiskInfo>)new SdkInternalList(disks.length));
        }
        for (DiskInfo ele : disks) {
            this.disks.add((Object)ele);
        }
        return this;
    }

    public InstanceStorageInfo withDisks(Collection<DiskInfo> disks) {
        this.setDisks(disks);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTotalSizeInGB() != null) {
            sb.append("TotalSizeInGB: ").append(this.getTotalSizeInGB()).append(",");
        }
        if (this.getDisks() != null) {
            sb.append("Disks: ").append(this.getDisks());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStorageInfo)) {
            return false;
        }
        InstanceStorageInfo other = (InstanceStorageInfo)obj;
        if (other.getTotalSizeInGB() == null ^ this.getTotalSizeInGB() == null) {
            return false;
        }
        if (other.getTotalSizeInGB() != null && !other.getTotalSizeInGB().equals(this.getTotalSizeInGB())) {
            return false;
        }
        if (other.getDisks() == null ^ this.getDisks() == null) {
            return false;
        }
        return other.getDisks() == null || other.getDisks().equals(this.getDisks());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTotalSizeInGB() == null ? 0 : this.getTotalSizeInGB().hashCode());
        hashCode = 31 * hashCode + (this.getDisks() == null ? 0 : this.getDisks().hashCode());
        return hashCode;
    }

    public InstanceStorageInfo clone() {
        try {
            return (InstanceStorageInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

