/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.CreateRouteRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateRouteRequestMarshaller
implements Marshaller<Request<CreateRouteRequest>, CreateRouteRequest> {
    public Request<CreateRouteRequest> marshall(CreateRouteRequest createRouteRequest) {
        if (createRouteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createRouteRequest, "AmazonEC2");
        request.addParameter("Action", "CreateRoute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createRouteRequest.getDestinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringUtils.fromString((String)createRouteRequest.getDestinationCidrBlock()));
        }
        if (createRouteRequest.getDestinationIpv6CidrBlock() != null) {
            request.addParameter("DestinationIpv6CidrBlock", StringUtils.fromString((String)createRouteRequest.getDestinationIpv6CidrBlock()));
        }
        if (createRouteRequest.getDestinationPrefixListId() != null) {
            request.addParameter("DestinationPrefixListId", StringUtils.fromString((String)createRouteRequest.getDestinationPrefixListId()));
        }
        if (createRouteRequest.getEgressOnlyInternetGatewayId() != null) {
            request.addParameter("EgressOnlyInternetGatewayId", StringUtils.fromString((String)createRouteRequest.getEgressOnlyInternetGatewayId()));
        }
        if (createRouteRequest.getGatewayId() != null) {
            request.addParameter("GatewayId", StringUtils.fromString((String)createRouteRequest.getGatewayId()));
        }
        if (createRouteRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)createRouteRequest.getInstanceId()));
        }
        if (createRouteRequest.getNatGatewayId() != null) {
            request.addParameter("NatGatewayId", StringUtils.fromString((String)createRouteRequest.getNatGatewayId()));
        }
        if (createRouteRequest.getTransitGatewayId() != null) {
            request.addParameter("TransitGatewayId", StringUtils.fromString((String)createRouteRequest.getTransitGatewayId()));
        }
        if (createRouteRequest.getLocalGatewayId() != null) {
            request.addParameter("LocalGatewayId", StringUtils.fromString((String)createRouteRequest.getLocalGatewayId()));
        }
        if (createRouteRequest.getCarrierGatewayId() != null) {
            request.addParameter("CarrierGatewayId", StringUtils.fromString((String)createRouteRequest.getCarrierGatewayId()));
        }
        if (createRouteRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)createRouteRequest.getNetworkInterfaceId()));
        }
        if (createRouteRequest.getRouteTableId() != null) {
            request.addParameter("RouteTableId", StringUtils.fromString((String)createRouteRequest.getRouteTableId()));
        }
        if (createRouteRequest.getVpcPeeringConnectionId() != null) {
            request.addParameter("VpcPeeringConnectionId", StringUtils.fromString((String)createRouteRequest.getVpcPeeringConnectionId()));
        }
        return request;
    }
}

