/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class KeyPairInfo
implements Serializable,
Cloneable {
    private String keyPairId;
    private String keyFingerprint;
    private String keyName;
    private SdkInternalList<Tag> tags;

    public void setKeyPairId(String keyPairId) {
        this.keyPairId = keyPairId;
    }

    public String getKeyPairId() {
        return this.keyPairId;
    }

    public KeyPairInfo withKeyPairId(String keyPairId) {
        this.setKeyPairId(keyPairId);
        return this;
    }

    public void setKeyFingerprint(String keyFingerprint) {
        this.keyFingerprint = keyFingerprint;
    }

    public String getKeyFingerprint() {
        return this.keyFingerprint;
    }

    public KeyPairInfo withKeyFingerprint(String keyFingerprint) {
        this.setKeyFingerprint(keyFingerprint);
        return this;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public KeyPairInfo withKeyName(String keyName) {
        this.setKeyName(keyName);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public KeyPairInfo withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public KeyPairInfo withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyPairId() != null) {
            sb.append("KeyPairId: ").append(this.getKeyPairId()).append(",");
        }
        if (this.getKeyFingerprint() != null) {
            sb.append("KeyFingerprint: ").append(this.getKeyFingerprint()).append(",");
        }
        if (this.getKeyName() != null) {
            sb.append("KeyName: ").append(this.getKeyName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyPairInfo)) {
            return false;
        }
        KeyPairInfo other = (KeyPairInfo)obj;
        if (other.getKeyPairId() == null ^ this.getKeyPairId() == null) {
            return false;
        }
        if (other.getKeyPairId() != null && !other.getKeyPairId().equals(this.getKeyPairId())) {
            return false;
        }
        if (other.getKeyFingerprint() == null ^ this.getKeyFingerprint() == null) {
            return false;
        }
        if (other.getKeyFingerprint() != null && !other.getKeyFingerprint().equals(this.getKeyFingerprint())) {
            return false;
        }
        if (other.getKeyName() == null ^ this.getKeyName() == null) {
            return false;
        }
        if (other.getKeyName() != null && !other.getKeyName().equals(this.getKeyName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyPairId() == null ? 0 : this.getKeyPairId().hashCode());
        hashCode = 31 * hashCode + (this.getKeyFingerprint() == null ? 0 : this.getKeyFingerprint().hashCode());
        hashCode = 31 * hashCode + (this.getKeyName() == null ? 0 : this.getKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public KeyPairInfo clone() {
        try {
            return (KeyPairInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

