/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.Subnet;
import com.amazonaws.services.ec2.model.SubnetIpv6CidrBlockAssociation;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.transform.SubnetIpv6CidrBlockAssociationStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class SubnetStaxUnmarshaller
implements Unmarshaller<Subnet, StaxUnmarshallerContext> {
    private static SubnetStaxUnmarshaller instance;

    public Subnet unmarshall(StaxUnmarshallerContext context) throws Exception {
        Subnet subnet = new Subnet();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return subnet;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("availabilityZone", targetDepth)) {
                    subnet.setAvailabilityZone(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("availabilityZoneId", targetDepth)) {
                    subnet.setAvailabilityZoneId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("availableIpAddressCount", targetDepth)) {
                    subnet.setAvailableIpAddressCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("cidrBlock", targetDepth)) {
                    subnet.setCidrBlock(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("defaultForAz", targetDepth)) {
                    subnet.setDefaultForAz(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("mapPublicIpOnLaunch", targetDepth)) {
                    subnet.setMapPublicIpOnLaunch(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("mapCustomerOwnedIpOnLaunch", targetDepth)) {
                    subnet.setMapCustomerOwnedIpOnLaunch(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("customerOwnedIpv4Pool", targetDepth)) {
                    subnet.setCustomerOwnedIpv4Pool(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("state", targetDepth)) {
                    subnet.setState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("subnetId", targetDepth)) {
                    subnet.setSubnetId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("vpcId", targetDepth)) {
                    subnet.setVpcId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ownerId", targetDepth)) {
                    subnet.setOwnerId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("assignIpv6AddressOnCreation", targetDepth)) {
                    subnet.setAssignIpv6AddressOnCreation(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ipv6CidrBlockAssociationSet", targetDepth)) {
                    subnet.withIpv6CidrBlockAssociationSet(new ArrayList<SubnetIpv6CidrBlockAssociation>());
                    continue;
                }
                if (context.testExpression("ipv6CidrBlockAssociationSet/item", targetDepth)) {
                    subnet.withIpv6CidrBlockAssociationSet(SubnetIpv6CidrBlockAssociationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    subnet.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("tagSet/item", targetDepth)) {
                    subnet.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("subnetArn", targetDepth)) {
                    subnet.setSubnetArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("outpostArn", targetDepth)) continue;
                subnet.setOutpostArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return subnet;
    }

    public static SubnetStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SubnetStaxUnmarshaller();
        }
        return instance;
    }
}

