/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.Volume;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeVolumesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<Volume> volumes;
    private String nextToken;

    public List<Volume> getVolumes() {
        if (this.volumes == null) {
            this.volumes = new SdkInternalList();
        }
        return this.volumes;
    }

    public void setVolumes(Collection<Volume> volumes) {
        if (volumes == null) {
            this.volumes = null;
            return;
        }
        this.volumes = new SdkInternalList(volumes);
    }

    public DescribeVolumesResult withVolumes(Volume ... volumes) {
        if (this.volumes == null) {
            this.setVolumes((Collection<Volume>)new SdkInternalList(volumes.length));
        }
        for (Volume ele : volumes) {
            this.volumes.add((Object)ele);
        }
        return this;
    }

    public DescribeVolumesResult withVolumes(Collection<Volume> volumes) {
        this.setVolumes(volumes);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeVolumesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVolumes() != null) {
            sb.append("Volumes: ").append(this.getVolumes()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesResult)) {
            return false;
        }
        DescribeVolumesResult other = (DescribeVolumesResult)obj;
        if (other.getVolumes() == null ^ this.getVolumes() == null) {
            return false;
        }
        if (other.getVolumes() != null && !other.getVolumes().equals(this.getVolumes())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVolumes() == null ? 0 : this.getVolumes().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeVolumesResult clone() {
        try {
            return (DescribeVolumesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

