/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.StopInstancesRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class StopInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<StopInstancesRequest> {
    private SdkInternalList<String> instanceIds;
    private Boolean force;

    public StopInstancesRequest() {
    }

    public StopInstancesRequest(List<String> instanceIds) {
        this.setInstanceIds(instanceIds);
    }

    public List<String> getInstanceIds() {
        if (this.instanceIds == null) {
            this.instanceIds = new SdkInternalList();
        }
        return this.instanceIds;
    }

    public void setInstanceIds(Collection<String> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
            return;
        }
        this.instanceIds = new SdkInternalList(instanceIds);
    }

    public StopInstancesRequest withInstanceIds(String ... instanceIds) {
        if (this.instanceIds == null) {
            this.setInstanceIds((Collection<String>)new SdkInternalList(instanceIds.length));
        }
        for (String ele : instanceIds) {
            this.instanceIds.add((Object)ele);
        }
        return this;
    }

    public StopInstancesRequest withInstanceIds(Collection<String> instanceIds) {
        this.setInstanceIds(instanceIds);
        return this;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public Boolean getForce() {
        return this.force;
    }

    public StopInstancesRequest withForce(Boolean force) {
        this.setForce(force);
        return this;
    }

    public Boolean isForce() {
        return this.force;
    }

    @Override
    public Request<StopInstancesRequest> getDryRunRequest() {
        Request<StopInstancesRequest> request = new StopInstancesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceIds() != null) {
            sb.append("InstanceIds: ").append(this.getInstanceIds()).append(",");
        }
        if (this.getForce() != null) {
            sb.append("Force: ").append(this.getForce());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopInstancesRequest)) {
            return false;
        }
        StopInstancesRequest other = (StopInstancesRequest)obj;
        if (other.getInstanceIds() == null ^ this.getInstanceIds() == null) {
            return false;
        }
        if (other.getInstanceIds() != null && !other.getInstanceIds().equals(this.getInstanceIds())) {
            return false;
        }
        if (other.getForce() == null ^ this.getForce() == null) {
            return false;
        }
        return other.getForce() == null || other.getForce().equals(this.getForce());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceIds() == null ? 0 : this.getInstanceIds().hashCode());
        hashCode = 31 * hashCode + (this.getForce() == null ? 0 : this.getForce().hashCode());
        return hashCode;
    }

    public StopInstancesRequest clone() {
        return (StopInstancesRequest)super.clone();
    }
}

