/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.ModifyVpcPeeringConnectionOptionsRequest;
import com.amazonaws.services.ec2.model.PeeringConnectionOptionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyVpcPeeringConnectionOptionsRequestMarshaller
implements Marshaller<Request<ModifyVpcPeeringConnectionOptionsRequest>, ModifyVpcPeeringConnectionOptionsRequest> {
    public Request<ModifyVpcPeeringConnectionOptionsRequest> marshall(ModifyVpcPeeringConnectionOptionsRequest modifyVpcPeeringConnectionOptionsRequest) {
        PeeringConnectionOptionsRequest requesterPeeringConnectionOptions;
        if (modifyVpcPeeringConnectionOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyVpcPeeringConnectionOptionsRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVpcPeeringConnectionOptions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        PeeringConnectionOptionsRequest accepterPeeringConnectionOptions = modifyVpcPeeringConnectionOptionsRequest.getAccepterPeeringConnectionOptions();
        if (accepterPeeringConnectionOptions != null) {
            if (accepterPeeringConnectionOptions.getAllowDnsResolutionFromRemoteVpc() != null) {
                request.addParameter("AccepterPeeringConnectionOptions.AllowDnsResolutionFromRemoteVpc", StringUtils.fromBoolean((Boolean)accepterPeeringConnectionOptions.getAllowDnsResolutionFromRemoteVpc()));
            }
            if (accepterPeeringConnectionOptions.getAllowEgressFromLocalClassicLinkToRemoteVpc() != null) {
                request.addParameter("AccepterPeeringConnectionOptions.AllowEgressFromLocalClassicLinkToRemoteVpc", StringUtils.fromBoolean((Boolean)accepterPeeringConnectionOptions.getAllowEgressFromLocalClassicLinkToRemoteVpc()));
            }
            if (accepterPeeringConnectionOptions.getAllowEgressFromLocalVpcToRemoteClassicLink() != null) {
                request.addParameter("AccepterPeeringConnectionOptions.AllowEgressFromLocalVpcToRemoteClassicLink", StringUtils.fromBoolean((Boolean)accepterPeeringConnectionOptions.getAllowEgressFromLocalVpcToRemoteClassicLink()));
            }
        }
        if ((requesterPeeringConnectionOptions = modifyVpcPeeringConnectionOptionsRequest.getRequesterPeeringConnectionOptions()) != null) {
            if (requesterPeeringConnectionOptions.getAllowDnsResolutionFromRemoteVpc() != null) {
                request.addParameter("RequesterPeeringConnectionOptions.AllowDnsResolutionFromRemoteVpc", StringUtils.fromBoolean((Boolean)requesterPeeringConnectionOptions.getAllowDnsResolutionFromRemoteVpc()));
            }
            if (requesterPeeringConnectionOptions.getAllowEgressFromLocalClassicLinkToRemoteVpc() != null) {
                request.addParameter("RequesterPeeringConnectionOptions.AllowEgressFromLocalClassicLinkToRemoteVpc", StringUtils.fromBoolean((Boolean)requesterPeeringConnectionOptions.getAllowEgressFromLocalClassicLinkToRemoteVpc()));
            }
            if (requesterPeeringConnectionOptions.getAllowEgressFromLocalVpcToRemoteClassicLink() != null) {
                request.addParameter("RequesterPeeringConnectionOptions.AllowEgressFromLocalVpcToRemoteClassicLink", StringUtils.fromBoolean((Boolean)requesterPeeringConnectionOptions.getAllowEgressFromLocalVpcToRemoteClassicLink()));
            }
        }
        if (modifyVpcPeeringConnectionOptionsRequest.getVpcPeeringConnectionId() != null) {
            request.addParameter("VpcPeeringConnectionId", StringUtils.fromString((String)modifyVpcPeeringConnectionOptionsRequest.getVpcPeeringConnectionId()));
        }
        return request;
    }
}

