/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.KeyType;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.CreateKeyPairRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateKeyPairRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateKeyPairRequest> {
    private String keyName;
    private String keyType;
    private SdkInternalList<TagSpecification> tagSpecifications;

    public CreateKeyPairRequest() {
    }

    public CreateKeyPairRequest(String keyName) {
        this.setKeyName(keyName);
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public CreateKeyPairRequest withKeyName(String keyName) {
        this.setKeyName(keyName);
        return this;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public CreateKeyPairRequest withKeyType(String keyType) {
        this.setKeyType(keyType);
        return this;
    }

    public CreateKeyPairRequest withKeyType(KeyType keyType) {
        this.keyType = keyType.toString();
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public CreateKeyPairRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<TagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public CreateKeyPairRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    @Override
    public Request<CreateKeyPairRequest> getDryRunRequest() {
        Request<CreateKeyPairRequest> request = new CreateKeyPairRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyName() != null) {
            sb.append("KeyName: ").append(this.getKeyName()).append(",");
        }
        if (this.getKeyType() != null) {
            sb.append("KeyType: ").append(this.getKeyType()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyPairRequest)) {
            return false;
        }
        CreateKeyPairRequest other = (CreateKeyPairRequest)obj;
        if (other.getKeyName() == null ^ this.getKeyName() == null) {
            return false;
        }
        if (other.getKeyName() != null && !other.getKeyName().equals(this.getKeyName())) {
            return false;
        }
        if (other.getKeyType() == null ^ this.getKeyType() == null) {
            return false;
        }
        if (other.getKeyType() != null && !other.getKeyType().equals(this.getKeyType())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        return other.getTagSpecifications() == null || other.getTagSpecifications().equals(this.getTagSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyName() == null ? 0 : this.getKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getKeyType() == null ? 0 : this.getKeyType().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        return hashCode;
    }

    public CreateKeyPairRequest clone() {
        return (CreateKeyPairRequest)super.clone();
    }
}

