/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AcceleratorCountRequest;
import com.amazonaws.services.ec2.model.AcceleratorTotalMemoryMiBRequest;
import com.amazonaws.services.ec2.model.BaselineEbsBandwidthMbpsRequest;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateConfigRequest;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateOverridesRequest;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateSpecificationRequest;
import com.amazonaws.services.ec2.model.InstanceRequirementsRequest;
import com.amazonaws.services.ec2.model.MemoryGiBPerVCpuRequest;
import com.amazonaws.services.ec2.model.MemoryMiBRequest;
import com.amazonaws.services.ec2.model.ModifyFleetRequest;
import com.amazonaws.services.ec2.model.NetworkInterfaceCountRequest;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.TargetCapacitySpecificationRequest;
import com.amazonaws.services.ec2.model.TotalLocalStorageGBRequest;
import com.amazonaws.services.ec2.model.VCpuCountRangeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyFleetRequestMarshaller
implements Marshaller<Request<ModifyFleetRequest>, ModifyFleetRequest> {
    public Request<ModifyFleetRequest> marshall(ModifyFleetRequest modifyFleetRequest) {
        TargetCapacitySpecificationRequest targetCapacitySpecification;
        SdkInternalList modifyFleetRequestLaunchTemplateConfigsList;
        if (modifyFleetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyFleetRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyFleet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyFleetRequest.getExcessCapacityTerminationPolicy() != null) {
            request.addParameter("ExcessCapacityTerminationPolicy", StringUtils.fromString((String)modifyFleetRequest.getExcessCapacityTerminationPolicy()));
        }
        if (!(modifyFleetRequestLaunchTemplateConfigsList = (SdkInternalList)modifyFleetRequest.getLaunchTemplateConfigs()).isEmpty() || !modifyFleetRequestLaunchTemplateConfigsList.isAutoConstruct()) {
            int launchTemplateConfigsListIndex = 1;
            for (FleetLaunchTemplateConfigRequest modifyFleetRequestLaunchTemplateConfigsListValue : modifyFleetRequestLaunchTemplateConfigsList) {
                SdkInternalList fleetLaunchTemplateConfigRequestOverridesList;
                FleetLaunchTemplateSpecificationRequest launchTemplateSpecification = modifyFleetRequestLaunchTemplateConfigsListValue.getLaunchTemplateSpecification();
                if (launchTemplateSpecification != null) {
                    if (launchTemplateSpecification.getLaunchTemplateId() != null) {
                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateId", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateId()));
                    }
                    if (launchTemplateSpecification.getLaunchTemplateName() != null) {
                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateName", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateName()));
                    }
                    if (launchTemplateSpecification.getVersion() != null) {
                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.Version", StringUtils.fromString((String)launchTemplateSpecification.getVersion()));
                    }
                }
                if (!(fleetLaunchTemplateConfigRequestOverridesList = (SdkInternalList)modifyFleetRequestLaunchTemplateConfigsListValue.getOverrides()).isEmpty() || !fleetLaunchTemplateConfigRequestOverridesList.isAutoConstruct()) {
                    int overridesListIndex = 1;
                    for (FleetLaunchTemplateOverridesRequest fleetLaunchTemplateConfigRequestOverridesListValue : fleetLaunchTemplateConfigRequestOverridesList) {
                        InstanceRequirementsRequest instanceRequirements;
                        Placement placement;
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getInstanceType() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceType", StringUtils.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.getInstanceType()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getMaxPrice() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".MaxPrice", StringUtils.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.getMaxPrice()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getSubnetId() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".SubnetId", StringUtils.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.getSubnetId()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getAvailabilityZone() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".AvailabilityZone", StringUtils.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.getAvailabilityZone()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getWeightedCapacity() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".WeightedCapacity", StringUtils.fromDouble((Double)fleetLaunchTemplateConfigRequestOverridesListValue.getWeightedCapacity()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getPriority() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Priority", StringUtils.fromDouble((Double)fleetLaunchTemplateConfigRequestOverridesListValue.getPriority()));
                        }
                        if ((placement = fleetLaunchTemplateConfigRequestOverridesListValue.getPlacement()) != null) {
                            if (placement.getAvailabilityZone() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.AvailabilityZone", StringUtils.fromString((String)placement.getAvailabilityZone()));
                            }
                            if (placement.getAffinity() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.Affinity", StringUtils.fromString((String)placement.getAffinity()));
                            }
                            if (placement.getGroupName() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.GroupName", StringUtils.fromString((String)placement.getGroupName()));
                            }
                            if (placement.getPartitionNumber() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.PartitionNumber", StringUtils.fromInteger((Integer)placement.getPartitionNumber()));
                            }
                            if (placement.getHostId() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.HostId", StringUtils.fromString((String)placement.getHostId()));
                            }
                            if (placement.getTenancy() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.Tenancy", StringUtils.fromString((String)placement.getTenancy()));
                            }
                            if (placement.getSpreadDomain() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.SpreadDomain", StringUtils.fromString((String)placement.getSpreadDomain()));
                            }
                            if (placement.getHostResourceGroupArn() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.HostResourceGroupArn", StringUtils.fromString((String)placement.getHostResourceGroupArn()));
                            }
                        }
                        if ((instanceRequirements = fleetLaunchTemplateConfigRequestOverridesListValue.getInstanceRequirements()) != null) {
                            AcceleratorTotalMemoryMiBRequest acceleratorTotalMemoryMiB;
                            SdkInternalList instanceRequirementsRequestAcceleratorNamesList;
                            SdkInternalList instanceRequirementsRequestAcceleratorManufacturersList;
                            AcceleratorCountRequest acceleratorCount;
                            SdkInternalList instanceRequirementsRequestAcceleratorTypesList;
                            BaselineEbsBandwidthMbpsRequest baselineEbsBandwidthMbps;
                            TotalLocalStorageGBRequest totalLocalStorageGB;
                            SdkInternalList instanceRequirementsRequestLocalStorageTypesList;
                            NetworkInterfaceCountRequest networkInterfaceCount;
                            SdkInternalList instanceRequirementsRequestInstanceGenerationsList;
                            SdkInternalList instanceRequirementsRequestExcludedInstanceTypesList;
                            MemoryGiBPerVCpuRequest memoryGiBPerVCpu;
                            SdkInternalList instanceRequirementsRequestCpuManufacturersList;
                            MemoryMiBRequest memoryMiB;
                            VCpuCountRangeRequest vCpuCount = instanceRequirements.getVCpuCount();
                            if (vCpuCount != null) {
                                if (vCpuCount.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.VCpuCount.Min", StringUtils.fromInteger((Integer)vCpuCount.getMin()));
                                }
                                if (vCpuCount.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.VCpuCount.Max", StringUtils.fromInteger((Integer)vCpuCount.getMax()));
                                }
                            }
                            if ((memoryMiB = instanceRequirements.getMemoryMiB()) != null) {
                                if (memoryMiB.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryMiB.Min", StringUtils.fromInteger((Integer)memoryMiB.getMin()));
                                }
                                if (memoryMiB.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryMiB.Max", StringUtils.fromInteger((Integer)memoryMiB.getMax()));
                                }
                            }
                            if (!(instanceRequirementsRequestCpuManufacturersList = (SdkInternalList)instanceRequirements.getCpuManufacturers()).isEmpty() || !instanceRequirementsRequestCpuManufacturersList.isAutoConstruct()) {
                                int cpuManufacturersListIndex = 1;
                                for (String instanceRequirementsRequestCpuManufacturersListValue : instanceRequirementsRequestCpuManufacturersList) {
                                    if (instanceRequirementsRequestCpuManufacturersListValue != null) {
                                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.CpuManufacturer." + cpuManufacturersListIndex, StringUtils.fromString((String)instanceRequirementsRequestCpuManufacturersListValue));
                                    }
                                    ++cpuManufacturersListIndex;
                                }
                            }
                            if ((memoryGiBPerVCpu = instanceRequirements.getMemoryGiBPerVCpu()) != null) {
                                if (memoryGiBPerVCpu.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryGiBPerVCpu.Min", StringUtils.fromDouble((Double)memoryGiBPerVCpu.getMin()));
                                }
                                if (memoryGiBPerVCpu.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.MemoryGiBPerVCpu.Max", StringUtils.fromDouble((Double)memoryGiBPerVCpu.getMax()));
                                }
                            }
                            if (!(instanceRequirementsRequestExcludedInstanceTypesList = (SdkInternalList)instanceRequirements.getExcludedInstanceTypes()).isEmpty() || !instanceRequirementsRequestExcludedInstanceTypesList.isAutoConstruct()) {
                                int excludedInstanceTypesListIndex = 1;
                                for (Object instanceRequirementsRequestExcludedInstanceTypesListValue : instanceRequirementsRequestExcludedInstanceTypesList) {
                                    if (instanceRequirementsRequestExcludedInstanceTypesListValue != null) {
                                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.ExcludedInstanceType." + excludedInstanceTypesListIndex, StringUtils.fromString((String)instanceRequirementsRequestExcludedInstanceTypesListValue));
                                    }
                                    ++excludedInstanceTypesListIndex;
                                }
                            }
                            if (!(instanceRequirementsRequestInstanceGenerationsList = (SdkInternalList)instanceRequirements.getInstanceGenerations()).isEmpty() || !instanceRequirementsRequestInstanceGenerationsList.isAutoConstruct()) {
                                Object instanceRequirementsRequestExcludedInstanceTypesListValue;
                                int instanceGenerationsListIndex = 1;
                                instanceRequirementsRequestExcludedInstanceTypesListValue = instanceRequirementsRequestInstanceGenerationsList.iterator();
                                while (instanceRequirementsRequestExcludedInstanceTypesListValue.hasNext()) {
                                    String instanceRequirementsRequestInstanceGenerationsListValue = (String)instanceRequirementsRequestExcludedInstanceTypesListValue.next();
                                    if (instanceRequirementsRequestInstanceGenerationsListValue != null) {
                                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.InstanceGeneration." + instanceGenerationsListIndex, StringUtils.fromString((String)instanceRequirementsRequestInstanceGenerationsListValue));
                                    }
                                    ++instanceGenerationsListIndex;
                                }
                            }
                            if (instanceRequirements.getSpotMaxPricePercentageOverLowestPrice() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.SpotMaxPricePercentageOverLowestPrice", StringUtils.fromInteger((Integer)instanceRequirements.getSpotMaxPricePercentageOverLowestPrice()));
                            }
                            if (instanceRequirements.getOnDemandMaxPricePercentageOverLowestPrice() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.OnDemandMaxPricePercentageOverLowestPrice", StringUtils.fromInteger((Integer)instanceRequirements.getOnDemandMaxPricePercentageOverLowestPrice()));
                            }
                            if (instanceRequirements.getBareMetal() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BareMetal", StringUtils.fromString((String)instanceRequirements.getBareMetal()));
                            }
                            if (instanceRequirements.getBurstablePerformance() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BurstablePerformance", StringUtils.fromString((String)instanceRequirements.getBurstablePerformance()));
                            }
                            if (instanceRequirements.getRequireHibernateSupport() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.RequireHibernateSupport", StringUtils.fromBoolean((Boolean)instanceRequirements.getRequireHibernateSupport()));
                            }
                            if ((networkInterfaceCount = instanceRequirements.getNetworkInterfaceCount()) != null) {
                                if (networkInterfaceCount.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.NetworkInterfaceCount.Min", StringUtils.fromInteger((Integer)networkInterfaceCount.getMin()));
                                }
                                if (networkInterfaceCount.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.NetworkInterfaceCount.Max", StringUtils.fromInteger((Integer)networkInterfaceCount.getMax()));
                                }
                            }
                            if (instanceRequirements.getLocalStorage() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.LocalStorage", StringUtils.fromString((String)instanceRequirements.getLocalStorage()));
                            }
                            if (!(instanceRequirementsRequestLocalStorageTypesList = (SdkInternalList)instanceRequirements.getLocalStorageTypes()).isEmpty() || !instanceRequirementsRequestLocalStorageTypesList.isAutoConstruct()) {
                                int localStorageTypesListIndex = 1;
                                for (String instanceRequirementsRequestLocalStorageTypesListValue : instanceRequirementsRequestLocalStorageTypesList) {
                                    if (instanceRequirementsRequestLocalStorageTypesListValue != null) {
                                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.LocalStorageType." + localStorageTypesListIndex, StringUtils.fromString((String)instanceRequirementsRequestLocalStorageTypesListValue));
                                    }
                                    ++localStorageTypesListIndex;
                                }
                            }
                            if ((totalLocalStorageGB = instanceRequirements.getTotalLocalStorageGB()) != null) {
                                if (totalLocalStorageGB.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.TotalLocalStorageGB.Min", StringUtils.fromDouble((Double)totalLocalStorageGB.getMin()));
                                }
                                if (totalLocalStorageGB.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.TotalLocalStorageGB.Max", StringUtils.fromDouble((Double)totalLocalStorageGB.getMax()));
                                }
                            }
                            if ((baselineEbsBandwidthMbps = instanceRequirements.getBaselineEbsBandwidthMbps()) != null) {
                                if (baselineEbsBandwidthMbps.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BaselineEbsBandwidthMbps.Min", StringUtils.fromInteger((Integer)baselineEbsBandwidthMbps.getMin()));
                                }
                                if (baselineEbsBandwidthMbps.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.BaselineEbsBandwidthMbps.Max", StringUtils.fromInteger((Integer)baselineEbsBandwidthMbps.getMax()));
                                }
                            }
                            if (!(instanceRequirementsRequestAcceleratorTypesList = (SdkInternalList)instanceRequirements.getAcceleratorTypes()).isEmpty() || !instanceRequirementsRequestAcceleratorTypesList.isAutoConstruct()) {
                                int acceleratorTypesListIndex = 1;
                                for (String instanceRequirementsRequestAcceleratorTypesListValue : instanceRequirementsRequestAcceleratorTypesList) {
                                    if (instanceRequirementsRequestAcceleratorTypesListValue != null) {
                                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorType." + acceleratorTypesListIndex, StringUtils.fromString((String)instanceRequirementsRequestAcceleratorTypesListValue));
                                    }
                                    ++acceleratorTypesListIndex;
                                }
                            }
                            if ((acceleratorCount = instanceRequirements.getAcceleratorCount()) != null) {
                                if (acceleratorCount.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorCount.Min", StringUtils.fromInteger((Integer)acceleratorCount.getMin()));
                                }
                                if (acceleratorCount.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorCount.Max", StringUtils.fromInteger((Integer)acceleratorCount.getMax()));
                                }
                            }
                            if (!(instanceRequirementsRequestAcceleratorManufacturersList = (SdkInternalList)instanceRequirements.getAcceleratorManufacturers()).isEmpty() || !instanceRequirementsRequestAcceleratorManufacturersList.isAutoConstruct()) {
                                int acceleratorManufacturersListIndex = 1;
                                for (String instanceRequirementsRequestAcceleratorManufacturersListValue : instanceRequirementsRequestAcceleratorManufacturersList) {
                                    if (instanceRequirementsRequestAcceleratorManufacturersListValue != null) {
                                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorManufacturer." + acceleratorManufacturersListIndex, StringUtils.fromString((String)instanceRequirementsRequestAcceleratorManufacturersListValue));
                                    }
                                    ++acceleratorManufacturersListIndex;
                                }
                            }
                            if (!(instanceRequirementsRequestAcceleratorNamesList = (SdkInternalList)instanceRequirements.getAcceleratorNames()).isEmpty() || !instanceRequirementsRequestAcceleratorNamesList.isAutoConstruct()) {
                                int acceleratorNamesListIndex = 1;
                                for (String instanceRequirementsRequestAcceleratorNamesListValue : instanceRequirementsRequestAcceleratorNamesList) {
                                    if (instanceRequirementsRequestAcceleratorNamesListValue != null) {
                                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorName." + acceleratorNamesListIndex, StringUtils.fromString((String)instanceRequirementsRequestAcceleratorNamesListValue));
                                    }
                                    ++acceleratorNamesListIndex;
                                }
                            }
                            if ((acceleratorTotalMemoryMiB = instanceRequirements.getAcceleratorTotalMemoryMiB()) != null) {
                                if (acceleratorTotalMemoryMiB.getMin() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorTotalMemoryMiB.Min", StringUtils.fromInteger((Integer)acceleratorTotalMemoryMiB.getMin()));
                                }
                                if (acceleratorTotalMemoryMiB.getMax() != null) {
                                    request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceRequirements.AcceleratorTotalMemoryMiB.Max", StringUtils.fromInteger((Integer)acceleratorTotalMemoryMiB.getMax()));
                                }
                            }
                        }
                        ++overridesListIndex;
                    }
                }
                ++launchTemplateConfigsListIndex;
            }
        }
        if (modifyFleetRequest.getFleetId() != null) {
            request.addParameter("FleetId", StringUtils.fromString((String)modifyFleetRequest.getFleetId()));
        }
        if ((targetCapacitySpecification = modifyFleetRequest.getTargetCapacitySpecification()) != null) {
            if (targetCapacitySpecification.getTotalTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.TotalTargetCapacity", StringUtils.fromInteger((Integer)targetCapacitySpecification.getTotalTargetCapacity()));
            }
            if (targetCapacitySpecification.getOnDemandTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.OnDemandTargetCapacity", StringUtils.fromInteger((Integer)targetCapacitySpecification.getOnDemandTargetCapacity()));
            }
            if (targetCapacitySpecification.getSpotTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.SpotTargetCapacity", StringUtils.fromInteger((Integer)targetCapacitySpecification.getSpotTargetCapacity()));
            }
            if (targetCapacitySpecification.getDefaultTargetCapacityType() != null) {
                request.addParameter("TargetCapacitySpecification.DefaultTargetCapacityType", StringUtils.fromString((String)targetCapacitySpecification.getDefaultTargetCapacityType()));
            }
            if (targetCapacitySpecification.getTargetCapacityUnitType() != null) {
                request.addParameter("TargetCapacitySpecification.TargetCapacityUnitType", StringUtils.fromString((String)targetCapacitySpecification.getTargetCapacityUnitType()));
            }
        }
        if (modifyFleetRequest.getContext() != null) {
            request.addParameter("Context", StringUtils.fromString((String)modifyFleetRequest.getContext()));
        }
        return request;
    }
}

