/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.transform.CreateNatGatewayRequestMarshaller;

/**
 * 
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateNatGatewayRequest extends AmazonWebServiceRequest implements Serializable, Cloneable, DryRunSupportedRequest<CreateNatGatewayRequest> {

    /**
     * <p>
     * [Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT gateway. You
     * cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is associated with
     * another resource, you must first disassociate it.
     * </p>
     */
    private String allocationId;
    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure
     * idempotency</a>.
     * </p>
     * <p>
     * Constraint: Maximum 64 ASCII characters.
     * </p>
     */
    private String clientToken;
    /**
     * <p>
     * The subnet in which to create the NAT gateway.
     * </p>
     */
    private String subnetId;
    /**
     * <p>
     * The tags to assign to the NAT gateway.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<TagSpecification> tagSpecifications;
    /**
     * <p>
     * Indicates whether the NAT gateway supports public or private connectivity. The default is public connectivity.
     * </p>
     */
    private String connectivityType;
    /**
     * <p>
     * The private IPv4 address to assign to the NAT gateway. If you don't provide an address, a private IPv4 address
     * will be automatically assigned.
     * </p>
     */
    private String privateIpAddress;

    /**
     * <p>
     * [Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT gateway. You
     * cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is associated with
     * another resource, you must first disassociate it.
     * </p>
     * 
     * @param allocationId
     *        [Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT gateway.
     *        You cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is
     *        associated with another resource, you must first disassociate it.
     */

    public void setAllocationId(String allocationId) {
        this.allocationId = allocationId;
    }

    /**
     * <p>
     * [Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT gateway. You
     * cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is associated with
     * another resource, you must first disassociate it.
     * </p>
     * 
     * @return [Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT gateway.
     *         You cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is
     *         associated with another resource, you must first disassociate it.
     */

    public String getAllocationId() {
        return this.allocationId;
    }

    /**
     * <p>
     * [Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT gateway. You
     * cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is associated with
     * another resource, you must first disassociate it.
     * </p>
     * 
     * @param allocationId
     *        [Public NAT gateways only] The allocation ID of an Elastic IP address to associate with the NAT gateway.
     *        You cannot specify an Elastic IP address with a private NAT gateway. If the Elastic IP address is
     *        associated with another resource, you must first disassociate it.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateNatGatewayRequest withAllocationId(String allocationId) {
        setAllocationId(allocationId);
        return this;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure
     * idempotency</a>.
     * </p>
     * <p>
     * Constraint: Maximum 64 ASCII characters.
     * </p>
     * 
     * @param clientToken
     *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *        information, see <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure
     *        idempotency</a>.</p>
     *        <p>
     *        Constraint: Maximum 64 ASCII characters.
     */

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure
     * idempotency</a>.
     * </p>
     * <p>
     * Constraint: Maximum 64 ASCII characters.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure
     *         idempotency</a>.</p>
     *         <p>
     *         Constraint: Maximum 64 ASCII characters.
     */

    public String getClientToken() {
        return this.clientToken;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure
     * idempotency</a>.
     * </p>
     * <p>
     * Constraint: Maximum 64 ASCII characters.
     * </p>
     * 
     * @param clientToken
     *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *        information, see <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure
     *        idempotency</a>.</p>
     *        <p>
     *        Constraint: Maximum 64 ASCII characters.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateNatGatewayRequest withClientToken(String clientToken) {
        setClientToken(clientToken);
        return this;
    }

    /**
     * <p>
     * The subnet in which to create the NAT gateway.
     * </p>
     * 
     * @param subnetId
     *        The subnet in which to create the NAT gateway.
     */

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    /**
     * <p>
     * The subnet in which to create the NAT gateway.
     * </p>
     * 
     * @return The subnet in which to create the NAT gateway.
     */

    public String getSubnetId() {
        return this.subnetId;
    }

    /**
     * <p>
     * The subnet in which to create the NAT gateway.
     * </p>
     * 
     * @param subnetId
     *        The subnet in which to create the NAT gateway.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateNatGatewayRequest withSubnetId(String subnetId) {
        setSubnetId(subnetId);
        return this;
    }

    /**
     * <p>
     * The tags to assign to the NAT gateway.
     * </p>
     * 
     * @return The tags to assign to the NAT gateway.
     */

    public java.util.List<TagSpecification> getTagSpecifications() {
        if (tagSpecifications == null) {
            tagSpecifications = new com.amazonaws.internal.SdkInternalList<TagSpecification>();
        }
        return tagSpecifications;
    }

    /**
     * <p>
     * The tags to assign to the NAT gateway.
     * </p>
     * 
     * @param tagSpecifications
     *        The tags to assign to the NAT gateway.
     */

    public void setTagSpecifications(java.util.Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }

        this.tagSpecifications = new com.amazonaws.internal.SdkInternalList<TagSpecification>(tagSpecifications);
    }

    /**
     * <p>
     * The tags to assign to the NAT gateway.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTagSpecifications(java.util.Collection)} or {@link #withTagSpecifications(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param tagSpecifications
     *        The tags to assign to the NAT gateway.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateNatGatewayRequest withTagSpecifications(TagSpecification... tagSpecifications) {
        if (this.tagSpecifications == null) {
            setTagSpecifications(new com.amazonaws.internal.SdkInternalList<TagSpecification>(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The tags to assign to the NAT gateway.
     * </p>
     * 
     * @param tagSpecifications
     *        The tags to assign to the NAT gateway.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateNatGatewayRequest withTagSpecifications(java.util.Collection<TagSpecification> tagSpecifications) {
        setTagSpecifications(tagSpecifications);
        return this;
    }

    /**
     * <p>
     * Indicates whether the NAT gateway supports public or private connectivity. The default is public connectivity.
     * </p>
     * 
     * @param connectivityType
     *        Indicates whether the NAT gateway supports public or private connectivity. The default is public
     *        connectivity.
     * @see ConnectivityType
     */

    public void setConnectivityType(String connectivityType) {
        this.connectivityType = connectivityType;
    }

    /**
     * <p>
     * Indicates whether the NAT gateway supports public or private connectivity. The default is public connectivity.
     * </p>
     * 
     * @return Indicates whether the NAT gateway supports public or private connectivity. The default is public
     *         connectivity.
     * @see ConnectivityType
     */

    public String getConnectivityType() {
        return this.connectivityType;
    }

    /**
     * <p>
     * Indicates whether the NAT gateway supports public or private connectivity. The default is public connectivity.
     * </p>
     * 
     * @param connectivityType
     *        Indicates whether the NAT gateway supports public or private connectivity. The default is public
     *        connectivity.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ConnectivityType
     */

    public CreateNatGatewayRequest withConnectivityType(String connectivityType) {
        setConnectivityType(connectivityType);
        return this;
    }

    /**
     * <p>
     * Indicates whether the NAT gateway supports public or private connectivity. The default is public connectivity.
     * </p>
     * 
     * @param connectivityType
     *        Indicates whether the NAT gateway supports public or private connectivity. The default is public
     *        connectivity.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ConnectivityType
     */

    public CreateNatGatewayRequest withConnectivityType(ConnectivityType connectivityType) {
        this.connectivityType = connectivityType.toString();
        return this;
    }

    /**
     * <p>
     * The private IPv4 address to assign to the NAT gateway. If you don't provide an address, a private IPv4 address
     * will be automatically assigned.
     * </p>
     * 
     * @param privateIpAddress
     *        The private IPv4 address to assign to the NAT gateway. If you don't provide an address, a private IPv4
     *        address will be automatically assigned.
     */

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    /**
     * <p>
     * The private IPv4 address to assign to the NAT gateway. If you don't provide an address, a private IPv4 address
     * will be automatically assigned.
     * </p>
     * 
     * @return The private IPv4 address to assign to the NAT gateway. If you don't provide an address, a private IPv4
     *         address will be automatically assigned.
     */

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    /**
     * <p>
     * The private IPv4 address to assign to the NAT gateway. If you don't provide an address, a private IPv4 address
     * will be automatically assigned.
     * </p>
     * 
     * @param privateIpAddress
     *        The private IPv4 address to assign to the NAT gateway. If you don't provide an address, a private IPv4
     *        address will be automatically assigned.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateNatGatewayRequest withPrivateIpAddress(String privateIpAddress) {
        setPrivateIpAddress(privateIpAddress);
        return this;
    }

    /**
     * This method is intended for internal use only. Returns the marshaled request configured with additional
     * parameters to enable operation dry-run.
     */
    @Override
    public Request<CreateNatGatewayRequest> getDryRunRequest() {
        Request<CreateNatGatewayRequest> request = new CreateNatGatewayRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAllocationId() != null)
            sb.append("AllocationId: ").append(getAllocationId()).append(",");
        if (getClientToken() != null)
            sb.append("ClientToken: ").append(getClientToken()).append(",");
        if (getSubnetId() != null)
            sb.append("SubnetId: ").append(getSubnetId()).append(",");
        if (getTagSpecifications() != null)
            sb.append("TagSpecifications: ").append(getTagSpecifications()).append(",");
        if (getConnectivityType() != null)
            sb.append("ConnectivityType: ").append(getConnectivityType()).append(",");
        if (getPrivateIpAddress() != null)
            sb.append("PrivateIpAddress: ").append(getPrivateIpAddress());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateNatGatewayRequest == false)
            return false;
        CreateNatGatewayRequest other = (CreateNatGatewayRequest) obj;
        if (other.getAllocationId() == null ^ this.getAllocationId() == null)
            return false;
        if (other.getAllocationId() != null && other.getAllocationId().equals(this.getAllocationId()) == false)
            return false;
        if (other.getClientToken() == null ^ this.getClientToken() == null)
            return false;
        if (other.getClientToken() != null && other.getClientToken().equals(this.getClientToken()) == false)
            return false;
        if (other.getSubnetId() == null ^ this.getSubnetId() == null)
            return false;
        if (other.getSubnetId() != null && other.getSubnetId().equals(this.getSubnetId()) == false)
            return false;
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null)
            return false;
        if (other.getTagSpecifications() != null && other.getTagSpecifications().equals(this.getTagSpecifications()) == false)
            return false;
        if (other.getConnectivityType() == null ^ this.getConnectivityType() == null)
            return false;
        if (other.getConnectivityType() != null && other.getConnectivityType().equals(this.getConnectivityType()) == false)
            return false;
        if (other.getPrivateIpAddress() == null ^ this.getPrivateIpAddress() == null)
            return false;
        if (other.getPrivateIpAddress() != null && other.getPrivateIpAddress().equals(this.getPrivateIpAddress()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAllocationId() == null) ? 0 : getAllocationId().hashCode());
        hashCode = prime * hashCode + ((getClientToken() == null) ? 0 : getClientToken().hashCode());
        hashCode = prime * hashCode + ((getSubnetId() == null) ? 0 : getSubnetId().hashCode());
        hashCode = prime * hashCode + ((getTagSpecifications() == null) ? 0 : getTagSpecifications().hashCode());
        hashCode = prime * hashCode + ((getConnectivityType() == null) ? 0 : getConnectivityType().hashCode());
        hashCode = prime * hashCode + ((getPrivateIpAddress() == null) ? 0 : getPrivateIpAddress().hashCode());
        return hashCode;
    }

    @Override
    public CreateNatGatewayRequest clone() {
        return (CreateNatGatewayRequest) super.clone();
    }
}
