/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.DeleteIpamRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteIpamRequestMarshaller
implements Marshaller<Request<DeleteIpamRequest>, DeleteIpamRequest> {
    public Request<DeleteIpamRequest> marshall(DeleteIpamRequest deleteIpamRequest) {
        if (deleteIpamRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteIpamRequest, "AmazonEC2");
        request.addParameter("Action", "DeleteIpam");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteIpamRequest.getIpamId() != null) {
            request.addParameter("IpamId", StringUtils.fromString((String)deleteIpamRequest.getIpamId()));
        }
        if (deleteIpamRequest.getCascade() != null) {
            request.addParameter("Cascade", StringUtils.fromBoolean((Boolean)deleteIpamRequest.getCascade()));
        }
        return request;
    }
}

