/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeVerifiedAccessInstancesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeVerifiedAccessInstancesRequestMarshaller
implements Marshaller<Request<DescribeVerifiedAccessInstancesRequest>, DescribeVerifiedAccessInstancesRequest> {
    public Request<DescribeVerifiedAccessInstancesRequest> marshall(DescribeVerifiedAccessInstancesRequest describeVerifiedAccessInstancesRequest) {
        SdkInternalList describeVerifiedAccessInstancesRequestFiltersList;
        if (describeVerifiedAccessInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVerifiedAccessInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeVerifiedAccessInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeVerifiedAccessInstancesRequestVerifiedAccessInstanceIdsList = (SdkInternalList)describeVerifiedAccessInstancesRequest.getVerifiedAccessInstanceIds();
        if (!describeVerifiedAccessInstancesRequestVerifiedAccessInstanceIdsList.isEmpty() || !describeVerifiedAccessInstancesRequestVerifiedAccessInstanceIdsList.isAutoConstruct()) {
            int verifiedAccessInstanceIdsListIndex = 1;
            for (String describeVerifiedAccessInstancesRequestVerifiedAccessInstanceIdsListValue : describeVerifiedAccessInstancesRequestVerifiedAccessInstanceIdsList) {
                if (describeVerifiedAccessInstancesRequestVerifiedAccessInstanceIdsListValue != null) {
                    request.addParameter("VerifiedAccessInstanceId." + verifiedAccessInstanceIdsListIndex, StringUtils.fromString((String)describeVerifiedAccessInstancesRequestVerifiedAccessInstanceIdsListValue));
                }
                ++verifiedAccessInstanceIdsListIndex;
            }
        }
        if (describeVerifiedAccessInstancesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeVerifiedAccessInstancesRequest.getMaxResults()));
        }
        if (describeVerifiedAccessInstancesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeVerifiedAccessInstancesRequest.getNextToken()));
        }
        if (!(describeVerifiedAccessInstancesRequestFiltersList = (SdkInternalList)describeVerifiedAccessInstancesRequest.getFilters()).isEmpty() || !describeVerifiedAccessInstancesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeVerifiedAccessInstancesRequestFiltersListValue : describeVerifiedAccessInstancesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeVerifiedAccessInstancesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVerifiedAccessInstancesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeVerifiedAccessInstancesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

