/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateFlowLogsRequest;
import com.amazonaws.services.ec2.model.DestinationOptionsRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateFlowLogsRequestMarshaller
implements Marshaller<Request<CreateFlowLogsRequest>, CreateFlowLogsRequest> {
    public Request<CreateFlowLogsRequest> marshall(CreateFlowLogsRequest createFlowLogsRequest) {
        DestinationOptionsRequest destinationOptions;
        SdkInternalList createFlowLogsRequestTagSpecificationsList;
        SdkInternalList createFlowLogsRequestResourceIdsList;
        if (createFlowLogsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createFlowLogsRequest, "AmazonEC2");
        request.addParameter("Action", "CreateFlowLogs");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createFlowLogsRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createFlowLogsRequest.getClientToken()));
        }
        if (createFlowLogsRequest.getDeliverLogsPermissionArn() != null) {
            request.addParameter("DeliverLogsPermissionArn", StringUtils.fromString((String)createFlowLogsRequest.getDeliverLogsPermissionArn()));
        }
        if (createFlowLogsRequest.getDeliverCrossAccountRole() != null) {
            request.addParameter("DeliverCrossAccountRole", StringUtils.fromString((String)createFlowLogsRequest.getDeliverCrossAccountRole()));
        }
        if (createFlowLogsRequest.getLogGroupName() != null) {
            request.addParameter("LogGroupName", StringUtils.fromString((String)createFlowLogsRequest.getLogGroupName()));
        }
        if (!(createFlowLogsRequestResourceIdsList = (SdkInternalList)createFlowLogsRequest.getResourceIds()).isEmpty() || !createFlowLogsRequestResourceIdsList.isAutoConstruct()) {
            int resourceIdsListIndex = 1;
            for (String createFlowLogsRequestResourceIdsListValue : createFlowLogsRequestResourceIdsList) {
                if (createFlowLogsRequestResourceIdsListValue != null) {
                    request.addParameter("ResourceId." + resourceIdsListIndex, StringUtils.fromString((String)createFlowLogsRequestResourceIdsListValue));
                }
                ++resourceIdsListIndex;
            }
        }
        if (createFlowLogsRequest.getResourceType() != null) {
            request.addParameter("ResourceType", StringUtils.fromString((String)createFlowLogsRequest.getResourceType()));
        }
        if (createFlowLogsRequest.getTrafficType() != null) {
            request.addParameter("TrafficType", StringUtils.fromString((String)createFlowLogsRequest.getTrafficType()));
        }
        if (createFlowLogsRequest.getLogDestinationType() != null) {
            request.addParameter("LogDestinationType", StringUtils.fromString((String)createFlowLogsRequest.getLogDestinationType()));
        }
        if (createFlowLogsRequest.getLogDestination() != null) {
            request.addParameter("LogDestination", StringUtils.fromString((String)createFlowLogsRequest.getLogDestination()));
        }
        if (createFlowLogsRequest.getLogFormat() != null) {
            request.addParameter("LogFormat", StringUtils.fromString((String)createFlowLogsRequest.getLogFormat()));
        }
        if (!(createFlowLogsRequestTagSpecificationsList = (SdkInternalList)createFlowLogsRequest.getTagSpecifications()).isEmpty() || !createFlowLogsRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createFlowLogsRequestTagSpecificationsListValue : createFlowLogsRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createFlowLogsRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createFlowLogsRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createFlowLogsRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createFlowLogsRequest.getMaxAggregationInterval() != null) {
            request.addParameter("MaxAggregationInterval", StringUtils.fromInteger((Integer)createFlowLogsRequest.getMaxAggregationInterval()));
        }
        if ((destinationOptions = createFlowLogsRequest.getDestinationOptions()) != null) {
            if (destinationOptions.getFileFormat() != null) {
                request.addParameter("DestinationOptions.FileFormat", StringUtils.fromString((String)destinationOptions.getFileFormat()));
            }
            if (destinationOptions.getHiveCompatiblePartitions() != null) {
                request.addParameter("DestinationOptions.HiveCompatiblePartitions", StringUtils.fromBoolean((Boolean)destinationOptions.getHiveCompatiblePartitions()));
            }
            if (destinationOptions.getPerHourPartition() != null) {
                request.addParameter("DestinationOptions.PerHourPartition", StringUtils.fromBoolean((Boolean)destinationOptions.getPerHourPartition()));
            }
        }
        return request;
    }
}

