/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * The discovery failure reason.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/IpamDiscoveryFailureReason" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class IpamDiscoveryFailureReason implements Serializable, Cloneable {

    /**
     * <p>
     * The discovery failure code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>assume-role-failure</code> - IPAM could not assume the Amazon Web Services IAM service-linked role. This
     * could be because of any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SLR has not been created yet and IPAM is still creating it.
     * </p>
     * </li>
     * <li>
     * <p>
     * You have opted-out of the IPAM home Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * Account you are using as your IPAM account has been suspended.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>throttling-failure</code> - IPAM account is already using the allotted transactions per second and IPAM is
     * receiving a throttling error when assuming the Amazon Web Services IAM SLR.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unauthorized-failure</code> - Amazon Web Services account making the request is not authorized. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">AuthFailure</a> in the
     * <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </li>
     * </ul>
     */
    private String code;
    /**
     * <p>
     * The discovery failure message.
     * </p>
     */
    private String message;

    /**
     * <p>
     * The discovery failure code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>assume-role-failure</code> - IPAM could not assume the Amazon Web Services IAM service-linked role. This
     * could be because of any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SLR has not been created yet and IPAM is still creating it.
     * </p>
     * </li>
     * <li>
     * <p>
     * You have opted-out of the IPAM home Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * Account you are using as your IPAM account has been suspended.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>throttling-failure</code> - IPAM account is already using the allotted transactions per second and IPAM is
     * receiving a throttling error when assuming the Amazon Web Services IAM SLR.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unauthorized-failure</code> - Amazon Web Services account making the request is not authorized. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">AuthFailure</a> in the
     * <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param code
     *        The discovery failure code.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>assume-role-failure</code> - IPAM could not assume the Amazon Web Services IAM service-linked role.
     *        This could be because of any of the following:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        SLR has not been created yet and IPAM is still creating it.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        You have opted-out of the IPAM home Region.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Account you are using as your IPAM account has been suspended.
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        <code>throttling-failure</code> - IPAM account is already using the allotted transactions per second and
     *        IPAM is receiving a throttling error when assuming the Amazon Web Services IAM SLR.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>unauthorized-failure</code> - Amazon Web Services account making the request is not authorized. For
     *        more information, see <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">AuthFailure</a> in the
     *        <i>Amazon Elastic Compute Cloud API Reference</i>.
     *        </p>
     *        </li>
     * @see IpamDiscoveryFailureCode
     */

    public void setCode(String code) {
        this.code = code;
    }

    /**
     * <p>
     * The discovery failure code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>assume-role-failure</code> - IPAM could not assume the Amazon Web Services IAM service-linked role. This
     * could be because of any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SLR has not been created yet and IPAM is still creating it.
     * </p>
     * </li>
     * <li>
     * <p>
     * You have opted-out of the IPAM home Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * Account you are using as your IPAM account has been suspended.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>throttling-failure</code> - IPAM account is already using the allotted transactions per second and IPAM is
     * receiving a throttling error when assuming the Amazon Web Services IAM SLR.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unauthorized-failure</code> - Amazon Web Services account making the request is not authorized. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">AuthFailure</a> in the
     * <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The discovery failure code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>assume-role-failure</code> - IPAM could not assume the Amazon Web Services IAM service-linked role.
     *         This could be because of any of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SLR has not been created yet and IPAM is still creating it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have opted-out of the IPAM home Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Account you are using as your IPAM account has been suspended.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>throttling-failure</code> - IPAM account is already using the allotted transactions per second and
     *         IPAM is receiving a throttling error when assuming the Amazon Web Services IAM SLR.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unauthorized-failure</code> - Amazon Web Services account making the request is not authorized. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">AuthFailure</a> in the
     *         <i>Amazon Elastic Compute Cloud API Reference</i>.
     *         </p>
     *         </li>
     * @see IpamDiscoveryFailureCode
     */

    public String getCode() {
        return this.code;
    }

    /**
     * <p>
     * The discovery failure code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>assume-role-failure</code> - IPAM could not assume the Amazon Web Services IAM service-linked role. This
     * could be because of any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SLR has not been created yet and IPAM is still creating it.
     * </p>
     * </li>
     * <li>
     * <p>
     * You have opted-out of the IPAM home Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * Account you are using as your IPAM account has been suspended.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>throttling-failure</code> - IPAM account is already using the allotted transactions per second and IPAM is
     * receiving a throttling error when assuming the Amazon Web Services IAM SLR.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unauthorized-failure</code> - Amazon Web Services account making the request is not authorized. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">AuthFailure</a> in the
     * <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param code
     *        The discovery failure code.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>assume-role-failure</code> - IPAM could not assume the Amazon Web Services IAM service-linked role.
     *        This could be because of any of the following:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        SLR has not been created yet and IPAM is still creating it.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        You have opted-out of the IPAM home Region.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Account you are using as your IPAM account has been suspended.
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        <code>throttling-failure</code> - IPAM account is already using the allotted transactions per second and
     *        IPAM is receiving a throttling error when assuming the Amazon Web Services IAM SLR.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>unauthorized-failure</code> - Amazon Web Services account making the request is not authorized. For
     *        more information, see <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">AuthFailure</a> in the
     *        <i>Amazon Elastic Compute Cloud API Reference</i>.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see IpamDiscoveryFailureCode
     */

    public IpamDiscoveryFailureReason withCode(String code) {
        setCode(code);
        return this;
    }

    /**
     * <p>
     * The discovery failure code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>assume-role-failure</code> - IPAM could not assume the Amazon Web Services IAM service-linked role. This
     * could be because of any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SLR has not been created yet and IPAM is still creating it.
     * </p>
     * </li>
     * <li>
     * <p>
     * You have opted-out of the IPAM home Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * Account you are using as your IPAM account has been suspended.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>throttling-failure</code> - IPAM account is already using the allotted transactions per second and IPAM is
     * receiving a throttling error when assuming the Amazon Web Services IAM SLR.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unauthorized-failure</code> - Amazon Web Services account making the request is not authorized. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">AuthFailure</a> in the
     * <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param code
     *        The discovery failure code.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>assume-role-failure</code> - IPAM could not assume the Amazon Web Services IAM service-linked role.
     *        This could be because of any of the following:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        SLR has not been created yet and IPAM is still creating it.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        You have opted-out of the IPAM home Region.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Account you are using as your IPAM account has been suspended.
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        <code>throttling-failure</code> - IPAM account is already using the allotted transactions per second and
     *        IPAM is receiving a throttling error when assuming the Amazon Web Services IAM SLR.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>unauthorized-failure</code> - Amazon Web Services account making the request is not authorized. For
     *        more information, see <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html">AuthFailure</a> in the
     *        <i>Amazon Elastic Compute Cloud API Reference</i>.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see IpamDiscoveryFailureCode
     */

    public IpamDiscoveryFailureReason withCode(IpamDiscoveryFailureCode code) {
        this.code = code.toString();
        return this;
    }

    /**
     * <p>
     * The discovery failure message.
     * </p>
     * 
     * @param message
     *        The discovery failure message.
     */

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * <p>
     * The discovery failure message.
     * </p>
     * 
     * @return The discovery failure message.
     */

    public String getMessage() {
        return this.message;
    }

    /**
     * <p>
     * The discovery failure message.
     * </p>
     * 
     * @param message
     *        The discovery failure message.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IpamDiscoveryFailureReason withMessage(String message) {
        setMessage(message);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCode() != null)
            sb.append("Code: ").append(getCode()).append(",");
        if (getMessage() != null)
            sb.append("Message: ").append(getMessage());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof IpamDiscoveryFailureReason == false)
            return false;
        IpamDiscoveryFailureReason other = (IpamDiscoveryFailureReason) obj;
        if (other.getCode() == null ^ this.getCode() == null)
            return false;
        if (other.getCode() != null && other.getCode().equals(this.getCode()) == false)
            return false;
        if (other.getMessage() == null ^ this.getMessage() == null)
            return false;
        if (other.getMessage() != null && other.getMessage().equals(this.getMessage()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCode() == null) ? 0 : getCode().hashCode());
        hashCode = prime * hashCode + ((getMessage() == null) ? 0 : getMessage().hashCode());
        return hashCode;
    }

    @Override
    public IpamDiscoveryFailureReason clone() {
        try {
            return (IpamDiscoveryFailureReason) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
