/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model;

import javax.annotation.Generated;

/**
 * 
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public enum InstanceType {

    T1Micro("t1.micro"),
    T2Nano("t2.nano"),
    T2Micro("t2.micro"),
    T2Small("t2.small"),
    T2Medium("t2.medium"),
    T2Large("t2.large"),
    T2Xlarge("t2.xlarge"),
    T22xlarge("t2.2xlarge"),
    T3Nano("t3.nano"),
    T3Micro("t3.micro"),
    T3Small("t3.small"),
    T3Medium("t3.medium"),
    T3Large("t3.large"),
    T3Xlarge("t3.xlarge"),
    T32xlarge("t3.2xlarge"),
    T3aNano("t3a.nano"),
    T3aMicro("t3a.micro"),
    T3aSmall("t3a.small"),
    T3aMedium("t3a.medium"),
    T3aLarge("t3a.large"),
    T3aXlarge("t3a.xlarge"),
    T3a2xlarge("t3a.2xlarge"),
    T4gNano("t4g.nano"),
    T4gMicro("t4g.micro"),
    T4gSmall("t4g.small"),
    T4gMedium("t4g.medium"),
    T4gLarge("t4g.large"),
    T4gXlarge("t4g.xlarge"),
    T4g2xlarge("t4g.2xlarge"),
    M1Small("m1.small"),
    M1Medium("m1.medium"),
    M1Large("m1.large"),
    M1Xlarge("m1.xlarge"),
    M3Medium("m3.medium"),
    M3Large("m3.large"),
    M3Xlarge("m3.xlarge"),
    M32xlarge("m3.2xlarge"),
    M4Large("m4.large"),
    M4Xlarge("m4.xlarge"),
    M42xlarge("m4.2xlarge"),
    M44xlarge("m4.4xlarge"),
    M410xlarge("m4.10xlarge"),
    M416xlarge("m4.16xlarge"),
    M2Xlarge("m2.xlarge"),
    M22xlarge("m2.2xlarge"),
    M24xlarge("m2.4xlarge"),
    Cr18xlarge("cr1.8xlarge"),
    R3Large("r3.large"),
    R3Xlarge("r3.xlarge"),
    R32xlarge("r3.2xlarge"),
    R34xlarge("r3.4xlarge"),
    R38xlarge("r3.8xlarge"),
    R4Large("r4.large"),
    R4Xlarge("r4.xlarge"),
    R42xlarge("r4.2xlarge"),
    R44xlarge("r4.4xlarge"),
    R48xlarge("r4.8xlarge"),
    R416xlarge("r4.16xlarge"),
    R5Large("r5.large"),
    R5Xlarge("r5.xlarge"),
    R52xlarge("r5.2xlarge"),
    R54xlarge("r5.4xlarge"),
    R58xlarge("r5.8xlarge"),
    R512xlarge("r5.12xlarge"),
    R516xlarge("r5.16xlarge"),
    R524xlarge("r5.24xlarge"),
    R5Metal("r5.metal"),
    R5aLarge("r5a.large"),
    R5aXlarge("r5a.xlarge"),
    R5a2xlarge("r5a.2xlarge"),
    R5a4xlarge("r5a.4xlarge"),
    R5a8xlarge("r5a.8xlarge"),
    R5a12xlarge("r5a.12xlarge"),
    R5a16xlarge("r5a.16xlarge"),
    R5a24xlarge("r5a.24xlarge"),
    R5bLarge("r5b.large"),
    R5bXlarge("r5b.xlarge"),
    R5b2xlarge("r5b.2xlarge"),
    R5b4xlarge("r5b.4xlarge"),
    R5b8xlarge("r5b.8xlarge"),
    R5b12xlarge("r5b.12xlarge"),
    R5b16xlarge("r5b.16xlarge"),
    R5b24xlarge("r5b.24xlarge"),
    R5bMetal("r5b.metal"),
    R5dLarge("r5d.large"),
    R5dXlarge("r5d.xlarge"),
    R5d2xlarge("r5d.2xlarge"),
    R5d4xlarge("r5d.4xlarge"),
    R5d8xlarge("r5d.8xlarge"),
    R5d12xlarge("r5d.12xlarge"),
    R5d16xlarge("r5d.16xlarge"),
    R5d24xlarge("r5d.24xlarge"),
    R5dMetal("r5d.metal"),
    R5adLarge("r5ad.large"),
    R5adXlarge("r5ad.xlarge"),
    R5ad2xlarge("r5ad.2xlarge"),
    R5ad4xlarge("r5ad.4xlarge"),
    R5ad8xlarge("r5ad.8xlarge"),
    R5ad12xlarge("r5ad.12xlarge"),
    R5ad16xlarge("r5ad.16xlarge"),
    R5ad24xlarge("r5ad.24xlarge"),
    R6gMetal("r6g.metal"),
    R6gMedium("r6g.medium"),
    R6gLarge("r6g.large"),
    R6gXlarge("r6g.xlarge"),
    R6g2xlarge("r6g.2xlarge"),
    R6g4xlarge("r6g.4xlarge"),
    R6g8xlarge("r6g.8xlarge"),
    R6g12xlarge("r6g.12xlarge"),
    R6g16xlarge("r6g.16xlarge"),
    R6gdMetal("r6gd.metal"),
    R6gdMedium("r6gd.medium"),
    R6gdLarge("r6gd.large"),
    R6gdXlarge("r6gd.xlarge"),
    R6gd2xlarge("r6gd.2xlarge"),
    R6gd4xlarge("r6gd.4xlarge"),
    R6gd8xlarge("r6gd.8xlarge"),
    R6gd12xlarge("r6gd.12xlarge"),
    R6gd16xlarge("r6gd.16xlarge"),
    X116xlarge("x1.16xlarge"),
    X132xlarge("x1.32xlarge"),
    X1eXlarge("x1e.xlarge"),
    X1e2xlarge("x1e.2xlarge"),
    X1e4xlarge("x1e.4xlarge"),
    X1e8xlarge("x1e.8xlarge"),
    X1e16xlarge("x1e.16xlarge"),
    X1e32xlarge("x1e.32xlarge"),
    I2Xlarge("i2.xlarge"),
    I22xlarge("i2.2xlarge"),
    I24xlarge("i2.4xlarge"),
    I28xlarge("i2.8xlarge"),
    I3Large("i3.large"),
    I3Xlarge("i3.xlarge"),
    I32xlarge("i3.2xlarge"),
    I34xlarge("i3.4xlarge"),
    I38xlarge("i3.8xlarge"),
    I316xlarge("i3.16xlarge"),
    I3Metal("i3.metal"),
    I3enLarge("i3en.large"),
    I3enXlarge("i3en.xlarge"),
    I3en2xlarge("i3en.2xlarge"),
    I3en3xlarge("i3en.3xlarge"),
    I3en6xlarge("i3en.6xlarge"),
    I3en12xlarge("i3en.12xlarge"),
    I3en24xlarge("i3en.24xlarge"),
    I3enMetal("i3en.metal"),
    Hi14xlarge("hi1.4xlarge"),
    Hs18xlarge("hs1.8xlarge"),
    C1Medium("c1.medium"),
    C1Xlarge("c1.xlarge"),
    C3Large("c3.large"),
    C3Xlarge("c3.xlarge"),
    C32xlarge("c3.2xlarge"),
    C34xlarge("c3.4xlarge"),
    C38xlarge("c3.8xlarge"),
    C4Large("c4.large"),
    C4Xlarge("c4.xlarge"),
    C42xlarge("c4.2xlarge"),
    C44xlarge("c4.4xlarge"),
    C48xlarge("c4.8xlarge"),
    C5Large("c5.large"),
    C5Xlarge("c5.xlarge"),
    C52xlarge("c5.2xlarge"),
    C54xlarge("c5.4xlarge"),
    C59xlarge("c5.9xlarge"),
    C512xlarge("c5.12xlarge"),
    C518xlarge("c5.18xlarge"),
    C524xlarge("c5.24xlarge"),
    C5Metal("c5.metal"),
    C5aLarge("c5a.large"),
    C5aXlarge("c5a.xlarge"),
    C5a2xlarge("c5a.2xlarge"),
    C5a4xlarge("c5a.4xlarge"),
    C5a8xlarge("c5a.8xlarge"),
    C5a12xlarge("c5a.12xlarge"),
    C5a16xlarge("c5a.16xlarge"),
    C5a24xlarge("c5a.24xlarge"),
    C5adLarge("c5ad.large"),
    C5adXlarge("c5ad.xlarge"),
    C5ad2xlarge("c5ad.2xlarge"),
    C5ad4xlarge("c5ad.4xlarge"),
    C5ad8xlarge("c5ad.8xlarge"),
    C5ad12xlarge("c5ad.12xlarge"),
    C5ad16xlarge("c5ad.16xlarge"),
    C5ad24xlarge("c5ad.24xlarge"),
    C5dLarge("c5d.large"),
    C5dXlarge("c5d.xlarge"),
    C5d2xlarge("c5d.2xlarge"),
    C5d4xlarge("c5d.4xlarge"),
    C5d9xlarge("c5d.9xlarge"),
    C5d12xlarge("c5d.12xlarge"),
    C5d18xlarge("c5d.18xlarge"),
    C5d24xlarge("c5d.24xlarge"),
    C5dMetal("c5d.metal"),
    C5nLarge("c5n.large"),
    C5nXlarge("c5n.xlarge"),
    C5n2xlarge("c5n.2xlarge"),
    C5n4xlarge("c5n.4xlarge"),
    C5n9xlarge("c5n.9xlarge"),
    C5n18xlarge("c5n.18xlarge"),
    C5nMetal("c5n.metal"),
    C6gMetal("c6g.metal"),
    C6gMedium("c6g.medium"),
    C6gLarge("c6g.large"),
    C6gXlarge("c6g.xlarge"),
    C6g2xlarge("c6g.2xlarge"),
    C6g4xlarge("c6g.4xlarge"),
    C6g8xlarge("c6g.8xlarge"),
    C6g12xlarge("c6g.12xlarge"),
    C6g16xlarge("c6g.16xlarge"),
    C6gdMetal("c6gd.metal"),
    C6gdMedium("c6gd.medium"),
    C6gdLarge("c6gd.large"),
    C6gdXlarge("c6gd.xlarge"),
    C6gd2xlarge("c6gd.2xlarge"),
    C6gd4xlarge("c6gd.4xlarge"),
    C6gd8xlarge("c6gd.8xlarge"),
    C6gd12xlarge("c6gd.12xlarge"),
    C6gd16xlarge("c6gd.16xlarge"),
    C6gnMedium("c6gn.medium"),
    C6gnLarge("c6gn.large"),
    C6gnXlarge("c6gn.xlarge"),
    C6gn2xlarge("c6gn.2xlarge"),
    C6gn4xlarge("c6gn.4xlarge"),
    C6gn8xlarge("c6gn.8xlarge"),
    C6gn12xlarge("c6gn.12xlarge"),
    C6gn16xlarge("c6gn.16xlarge"),
    Cc14xlarge("cc1.4xlarge"),
    Cc28xlarge("cc2.8xlarge"),
    G22xlarge("g2.2xlarge"),
    G28xlarge("g2.8xlarge"),
    G34xlarge("g3.4xlarge"),
    G38xlarge("g3.8xlarge"),
    G316xlarge("g3.16xlarge"),
    G3sXlarge("g3s.xlarge"),
    G4adXlarge("g4ad.xlarge"),
    G4ad2xlarge("g4ad.2xlarge"),
    G4ad4xlarge("g4ad.4xlarge"),
    G4ad8xlarge("g4ad.8xlarge"),
    G4ad16xlarge("g4ad.16xlarge"),
    G4dnXlarge("g4dn.xlarge"),
    G4dn2xlarge("g4dn.2xlarge"),
    G4dn4xlarge("g4dn.4xlarge"),
    G4dn8xlarge("g4dn.8xlarge"),
    G4dn12xlarge("g4dn.12xlarge"),
    G4dn16xlarge("g4dn.16xlarge"),
    G4dnMetal("g4dn.metal"),
    Cg14xlarge("cg1.4xlarge"),
    P2Xlarge("p2.xlarge"),
    P28xlarge("p2.8xlarge"),
    P216xlarge("p2.16xlarge"),
    P32xlarge("p3.2xlarge"),
    P38xlarge("p3.8xlarge"),
    P316xlarge("p3.16xlarge"),
    P3dn24xlarge("p3dn.24xlarge"),
    P4d24xlarge("p4d.24xlarge"),
    D2Xlarge("d2.xlarge"),
    D22xlarge("d2.2xlarge"),
    D24xlarge("d2.4xlarge"),
    D28xlarge("d2.8xlarge"),
    D3Xlarge("d3.xlarge"),
    D32xlarge("d3.2xlarge"),
    D34xlarge("d3.4xlarge"),
    D38xlarge("d3.8xlarge"),
    D3enXlarge("d3en.xlarge"),
    D3en2xlarge("d3en.2xlarge"),
    D3en4xlarge("d3en.4xlarge"),
    D3en6xlarge("d3en.6xlarge"),
    D3en8xlarge("d3en.8xlarge"),
    D3en12xlarge("d3en.12xlarge"),
    F12xlarge("f1.2xlarge"),
    F14xlarge("f1.4xlarge"),
    F116xlarge("f1.16xlarge"),
    M5Large("m5.large"),
    M5Xlarge("m5.xlarge"),
    M52xlarge("m5.2xlarge"),
    M54xlarge("m5.4xlarge"),
    M58xlarge("m5.8xlarge"),
    M512xlarge("m5.12xlarge"),
    M516xlarge("m5.16xlarge"),
    M524xlarge("m5.24xlarge"),
    M5Metal("m5.metal"),
    M5aLarge("m5a.large"),
    M5aXlarge("m5a.xlarge"),
    M5a2xlarge("m5a.2xlarge"),
    M5a4xlarge("m5a.4xlarge"),
    M5a8xlarge("m5a.8xlarge"),
    M5a12xlarge("m5a.12xlarge"),
    M5a16xlarge("m5a.16xlarge"),
    M5a24xlarge("m5a.24xlarge"),
    M5dLarge("m5d.large"),
    M5dXlarge("m5d.xlarge"),
    M5d2xlarge("m5d.2xlarge"),
    M5d4xlarge("m5d.4xlarge"),
    M5d8xlarge("m5d.8xlarge"),
    M5d12xlarge("m5d.12xlarge"),
    M5d16xlarge("m5d.16xlarge"),
    M5d24xlarge("m5d.24xlarge"),
    M5dMetal("m5d.metal"),
    M5adLarge("m5ad.large"),
    M5adXlarge("m5ad.xlarge"),
    M5ad2xlarge("m5ad.2xlarge"),
    M5ad4xlarge("m5ad.4xlarge"),
    M5ad8xlarge("m5ad.8xlarge"),
    M5ad12xlarge("m5ad.12xlarge"),
    M5ad16xlarge("m5ad.16xlarge"),
    M5ad24xlarge("m5ad.24xlarge"),
    M5znLarge("m5zn.large"),
    M5znXlarge("m5zn.xlarge"),
    M5zn2xlarge("m5zn.2xlarge"),
    M5zn3xlarge("m5zn.3xlarge"),
    M5zn6xlarge("m5zn.6xlarge"),
    M5zn12xlarge("m5zn.12xlarge"),
    M5znMetal("m5zn.metal"),
    H12xlarge("h1.2xlarge"),
    H14xlarge("h1.4xlarge"),
    H18xlarge("h1.8xlarge"),
    H116xlarge("h1.16xlarge"),
    Z1dLarge("z1d.large"),
    Z1dXlarge("z1d.xlarge"),
    Z1d2xlarge("z1d.2xlarge"),
    Z1d3xlarge("z1d.3xlarge"),
    Z1d6xlarge("z1d.6xlarge"),
    Z1d12xlarge("z1d.12xlarge"),
    Z1dMetal("z1d.metal"),
    U6tb156xlarge("u-6tb1.56xlarge"),
    U6tb1112xlarge("u-6tb1.112xlarge"),
    U9tb1112xlarge("u-9tb1.112xlarge"),
    U12tb1112xlarge("u-12tb1.112xlarge"),
    U6tb1Metal("u-6tb1.metal"),
    U9tb1Metal("u-9tb1.metal"),
    U12tb1Metal("u-12tb1.metal"),
    U18tb1Metal("u-18tb1.metal"),
    U24tb1Metal("u-24tb1.metal"),
    A1Medium("a1.medium"),
    A1Large("a1.large"),
    A1Xlarge("a1.xlarge"),
    A12xlarge("a1.2xlarge"),
    A14xlarge("a1.4xlarge"),
    A1Metal("a1.metal"),
    M5dnLarge("m5dn.large"),
    M5dnXlarge("m5dn.xlarge"),
    M5dn2xlarge("m5dn.2xlarge"),
    M5dn4xlarge("m5dn.4xlarge"),
    M5dn8xlarge("m5dn.8xlarge"),
    M5dn12xlarge("m5dn.12xlarge"),
    M5dn16xlarge("m5dn.16xlarge"),
    M5dn24xlarge("m5dn.24xlarge"),
    M5dnMetal("m5dn.metal"),
    M5nLarge("m5n.large"),
    M5nXlarge("m5n.xlarge"),
    M5n2xlarge("m5n.2xlarge"),
    M5n4xlarge("m5n.4xlarge"),
    M5n8xlarge("m5n.8xlarge"),
    M5n12xlarge("m5n.12xlarge"),
    M5n16xlarge("m5n.16xlarge"),
    M5n24xlarge("m5n.24xlarge"),
    M5nMetal("m5n.metal"),
    R5dnLarge("r5dn.large"),
    R5dnXlarge("r5dn.xlarge"),
    R5dn2xlarge("r5dn.2xlarge"),
    R5dn4xlarge("r5dn.4xlarge"),
    R5dn8xlarge("r5dn.8xlarge"),
    R5dn12xlarge("r5dn.12xlarge"),
    R5dn16xlarge("r5dn.16xlarge"),
    R5dn24xlarge("r5dn.24xlarge"),
    R5dnMetal("r5dn.metal"),
    R5nLarge("r5n.large"),
    R5nXlarge("r5n.xlarge"),
    R5n2xlarge("r5n.2xlarge"),
    R5n4xlarge("r5n.4xlarge"),
    R5n8xlarge("r5n.8xlarge"),
    R5n12xlarge("r5n.12xlarge"),
    R5n16xlarge("r5n.16xlarge"),
    R5n24xlarge("r5n.24xlarge"),
    R5nMetal("r5n.metal"),
    Inf1Xlarge("inf1.xlarge"),
    Inf12xlarge("inf1.2xlarge"),
    Inf16xlarge("inf1.6xlarge"),
    Inf124xlarge("inf1.24xlarge"),
    M6gMetal("m6g.metal"),
    M6gMedium("m6g.medium"),
    M6gLarge("m6g.large"),
    M6gXlarge("m6g.xlarge"),
    M6g2xlarge("m6g.2xlarge"),
    M6g4xlarge("m6g.4xlarge"),
    M6g8xlarge("m6g.8xlarge"),
    M6g12xlarge("m6g.12xlarge"),
    M6g16xlarge("m6g.16xlarge"),
    M6gdMetal("m6gd.metal"),
    M6gdMedium("m6gd.medium"),
    M6gdLarge("m6gd.large"),
    M6gdXlarge("m6gd.xlarge"),
    M6gd2xlarge("m6gd.2xlarge"),
    M6gd4xlarge("m6gd.4xlarge"),
    M6gd8xlarge("m6gd.8xlarge"),
    M6gd12xlarge("m6gd.12xlarge"),
    M6gd16xlarge("m6gd.16xlarge"),
    Mac1Metal("mac1.metal"),
    X2gdMedium("x2gd.medium"),
    X2gdLarge("x2gd.large"),
    X2gdXlarge("x2gd.xlarge"),
    X2gd2xlarge("x2gd.2xlarge"),
    X2gd4xlarge("x2gd.4xlarge"),
    X2gd8xlarge("x2gd.8xlarge"),
    X2gd12xlarge("x2gd.12xlarge"),
    X2gd16xlarge("x2gd.16xlarge"),
    X2gdMetal("x2gd.metal");

    private String value;

    private InstanceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return InstanceType corresponding to the value
     *
     * @throws IllegalArgumentException
     *         If the specified value does not map to one of the known values in this enum.
     */
    public static InstanceType fromValue(String value) {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }

        for (InstanceType enumEntry : InstanceType.values()) {
            if (enumEntry.toString().equals(value)) {
                return enumEntry;
            }
        }

        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }
}
