/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.EnableFastLaunchRequest;
import com.amazonaws.services.ec2.model.FastLaunchLaunchTemplateSpecificationRequest;
import com.amazonaws.services.ec2.model.FastLaunchSnapshotConfigurationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class EnableFastLaunchRequestMarshaller
implements Marshaller<Request<EnableFastLaunchRequest>, EnableFastLaunchRequest> {
    public Request<EnableFastLaunchRequest> marshall(EnableFastLaunchRequest enableFastLaunchRequest) {
        FastLaunchLaunchTemplateSpecificationRequest launchTemplate;
        FastLaunchSnapshotConfigurationRequest snapshotConfiguration;
        if (enableFastLaunchRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)enableFastLaunchRequest, "AmazonEC2");
        request.addParameter("Action", "EnableFastLaunch");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (enableFastLaunchRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString((String)enableFastLaunchRequest.getImageId()));
        }
        if (enableFastLaunchRequest.getResourceType() != null) {
            request.addParameter("ResourceType", StringUtils.fromString((String)enableFastLaunchRequest.getResourceType()));
        }
        if ((snapshotConfiguration = enableFastLaunchRequest.getSnapshotConfiguration()) != null && snapshotConfiguration.getTargetResourceCount() != null) {
            request.addParameter("SnapshotConfiguration.TargetResourceCount", StringUtils.fromInteger((Integer)snapshotConfiguration.getTargetResourceCount()));
        }
        if ((launchTemplate = enableFastLaunchRequest.getLaunchTemplate()) != null) {
            if (launchTemplate.getLaunchTemplateId() != null) {
                request.addParameter("LaunchTemplate.LaunchTemplateId", StringUtils.fromString((String)launchTemplate.getLaunchTemplateId()));
            }
            if (launchTemplate.getLaunchTemplateName() != null) {
                request.addParameter("LaunchTemplate.LaunchTemplateName", StringUtils.fromString((String)launchTemplate.getLaunchTemplateName()));
            }
            if (launchTemplate.getVersion() != null) {
                request.addParameter("LaunchTemplate.Version", StringUtils.fromString((String)launchTemplate.getVersion()));
            }
        }
        if (enableFastLaunchRequest.getMaxParallelLaunches() != null) {
            request.addParameter("MaxParallelLaunches", StringUtils.fromInteger((Integer)enableFastLaunchRequest.getMaxParallelLaunches()));
        }
        return request;
    }
}

