/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.GetIpamResourceCidrsRequest;
import com.amazonaws.services.ec2.model.RequestIpamResourceTag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetIpamResourceCidrsRequestMarshaller
implements Marshaller<Request<GetIpamResourceCidrsRequest>, GetIpamResourceCidrsRequest> {
    public Request<GetIpamResourceCidrsRequest> marshall(GetIpamResourceCidrsRequest getIpamResourceCidrsRequest) {
        RequestIpamResourceTag resourceTag;
        if (getIpamResourceCidrsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getIpamResourceCidrsRequest, "AmazonEC2");
        request.addParameter("Action", "GetIpamResourceCidrs");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList getIpamResourceCidrsRequestFiltersList = (SdkInternalList)getIpamResourceCidrsRequest.getFilters();
        if (!getIpamResourceCidrsRequestFiltersList.isEmpty() || !getIpamResourceCidrsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter getIpamResourceCidrsRequestFiltersListValue : getIpamResourceCidrsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (getIpamResourceCidrsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)getIpamResourceCidrsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)getIpamResourceCidrsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (getIpamResourceCidrsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)getIpamResourceCidrsRequest.getMaxResults()));
        }
        if (getIpamResourceCidrsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)getIpamResourceCidrsRequest.getNextToken()));
        }
        if (getIpamResourceCidrsRequest.getIpamScopeId() != null) {
            request.addParameter("IpamScopeId", StringUtils.fromString((String)getIpamResourceCidrsRequest.getIpamScopeId()));
        }
        if (getIpamResourceCidrsRequest.getIpamPoolId() != null) {
            request.addParameter("IpamPoolId", StringUtils.fromString((String)getIpamResourceCidrsRequest.getIpamPoolId()));
        }
        if (getIpamResourceCidrsRequest.getResourceId() != null) {
            request.addParameter("ResourceId", StringUtils.fromString((String)getIpamResourceCidrsRequest.getResourceId()));
        }
        if (getIpamResourceCidrsRequest.getResourceType() != null) {
            request.addParameter("ResourceType", StringUtils.fromString((String)getIpamResourceCidrsRequest.getResourceType()));
        }
        if ((resourceTag = getIpamResourceCidrsRequest.getResourceTag()) != null) {
            if (resourceTag.getKey() != null) {
                request.addParameter("ResourceTag.Key", StringUtils.fromString((String)resourceTag.getKey()));
            }
            if (resourceTag.getValue() != null) {
                request.addParameter("ResourceTag.Value", StringUtils.fromString((String)resourceTag.getValue()));
            }
        }
        if (getIpamResourceCidrsRequest.getResourceOwner() != null) {
            request.addParameter("ResourceOwner", StringUtils.fromString((String)getIpamResourceCidrsRequest.getResourceOwner()));
        }
        return request;
    }
}

