/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.EnaSrdSpecification;
import com.amazonaws.services.ec2.model.EnaSrdUdpSpecification;
import com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest;
import com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyNetworkInterfaceAttributeRequestMarshaller
implements Marshaller<Request<ModifyNetworkInterfaceAttributeRequest>, ModifyNetworkInterfaceAttributeRequest> {
    public Request<ModifyNetworkInterfaceAttributeRequest> marshall(ModifyNetworkInterfaceAttributeRequest modifyNetworkInterfaceAttributeRequest) {
        EnaSrdSpecification enaSrdSpecification;
        SdkInternalList modifyNetworkInterfaceAttributeRequestGroupsList;
        if (modifyNetworkInterfaceAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyNetworkInterfaceAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyNetworkInterfaceAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        NetworkInterfaceAttachmentChanges attachment = modifyNetworkInterfaceAttributeRequest.getAttachment();
        if (attachment != null) {
            if (attachment.getAttachmentId() != null) {
                request.addParameter("Attachment.AttachmentId", StringUtils.fromString((String)attachment.getAttachmentId()));
            }
            if (attachment.getDeleteOnTermination() != null) {
                request.addParameter("Attachment.DeleteOnTermination", StringUtils.fromBoolean((Boolean)attachment.getDeleteOnTermination()));
            }
        }
        if (modifyNetworkInterfaceAttributeRequest.getDescription() != null) {
            request.addParameter("Description.Value", StringUtils.fromString((String)modifyNetworkInterfaceAttributeRequest.getDescription()));
        }
        if (!(modifyNetworkInterfaceAttributeRequestGroupsList = (SdkInternalList)modifyNetworkInterfaceAttributeRequest.getGroups()).isEmpty() || !modifyNetworkInterfaceAttributeRequestGroupsList.isAutoConstruct()) {
            int groupsListIndex = 1;
            for (String modifyNetworkInterfaceAttributeRequestGroupsListValue : modifyNetworkInterfaceAttributeRequestGroupsList) {
                if (modifyNetworkInterfaceAttributeRequestGroupsListValue != null) {
                    request.addParameter("SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)modifyNetworkInterfaceAttributeRequestGroupsListValue));
                }
                ++groupsListIndex;
            }
        }
        if (modifyNetworkInterfaceAttributeRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)modifyNetworkInterfaceAttributeRequest.getNetworkInterfaceId()));
        }
        if (modifyNetworkInterfaceAttributeRequest.getSourceDestCheck() != null) {
            request.addParameter("SourceDestCheck.Value", StringUtils.fromBoolean((Boolean)modifyNetworkInterfaceAttributeRequest.getSourceDestCheck()));
        }
        if ((enaSrdSpecification = modifyNetworkInterfaceAttributeRequest.getEnaSrdSpecification()) != null) {
            EnaSrdUdpSpecification enaSrdUdpSpecification;
            if (enaSrdSpecification.getEnaSrdEnabled() != null) {
                request.addParameter("EnaSrdSpecification.EnaSrdEnabled", StringUtils.fromBoolean((Boolean)enaSrdSpecification.getEnaSrdEnabled()));
            }
            if ((enaSrdUdpSpecification = enaSrdSpecification.getEnaSrdUdpSpecification()) != null && enaSrdUdpSpecification.getEnaSrdUdpEnabled() != null) {
                request.addParameter("EnaSrdSpecification.EnaSrdUdpSpecification.EnaSrdUdpEnabled", StringUtils.fromBoolean((Boolean)enaSrdUdpSpecification.getEnaSrdUdpEnabled()));
            }
        }
        if (modifyNetworkInterfaceAttributeRequest.getEnablePrimaryIpv6() != null) {
            request.addParameter("EnablePrimaryIpv6", StringUtils.fromBoolean((Boolean)modifyNetworkInterfaceAttributeRequest.getEnablePrimaryIpv6()));
        }
        return request;
    }
}

