/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeIpamsRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeIpamsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeIpamsRequest> {
    private SdkInternalList<Filter> filters;
    private Integer maxResults;
    private String nextToken;
    private SdkInternalList<String> ipamIds;

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList(filters);
    }

    public DescribeIpamsRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters((Collection<Filter>)new SdkInternalList(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add((Object)ele);
        }
        return this;
    }

    public DescribeIpamsRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public DescribeIpamsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeIpamsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<String> getIpamIds() {
        if (this.ipamIds == null) {
            this.ipamIds = new SdkInternalList();
        }
        return this.ipamIds;
    }

    public void setIpamIds(Collection<String> ipamIds) {
        if (ipamIds == null) {
            this.ipamIds = null;
            return;
        }
        this.ipamIds = new SdkInternalList(ipamIds);
    }

    public DescribeIpamsRequest withIpamIds(String ... ipamIds) {
        if (this.ipamIds == null) {
            this.setIpamIds((Collection<String>)new SdkInternalList(ipamIds.length));
        }
        for (String ele : ipamIds) {
            this.ipamIds.add((Object)ele);
        }
        return this;
    }

    public DescribeIpamsRequest withIpamIds(Collection<String> ipamIds) {
        this.setIpamIds(ipamIds);
        return this;
    }

    @Override
    public Request<DescribeIpamsRequest> getDryRunRequest() {
        Request<DescribeIpamsRequest> request = new DescribeIpamsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getIpamIds() != null) {
            sb.append("IpamIds: ").append(this.getIpamIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpamsRequest)) {
            return false;
        }
        DescribeIpamsRequest other = (DescribeIpamsRequest)obj;
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getIpamIds() == null ^ this.getIpamIds() == null) {
            return false;
        }
        return other.getIpamIds() == null || other.getIpamIds().equals(this.getIpamIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getIpamIds() == null ? 0 : this.getIpamIds().hashCode());
        return hashCode;
    }

    public DescribeIpamsRequest clone() {
        return (DescribeIpamsRequest)super.clone();
    }
}

