/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CapacityReservationInstancePlatform;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.PurchaseCapacityBlockRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PurchaseCapacityBlockRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<PurchaseCapacityBlockRequest> {
    private SdkInternalList<TagSpecification> tagSpecifications;
    private String capacityBlockOfferingId;
    private String instancePlatform;

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public PurchaseCapacityBlockRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<TagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public PurchaseCapacityBlockRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    public void setCapacityBlockOfferingId(String capacityBlockOfferingId) {
        this.capacityBlockOfferingId = capacityBlockOfferingId;
    }

    public String getCapacityBlockOfferingId() {
        return this.capacityBlockOfferingId;
    }

    public PurchaseCapacityBlockRequest withCapacityBlockOfferingId(String capacityBlockOfferingId) {
        this.setCapacityBlockOfferingId(capacityBlockOfferingId);
        return this;
    }

    public void setInstancePlatform(String instancePlatform) {
        this.instancePlatform = instancePlatform;
    }

    public String getInstancePlatform() {
        return this.instancePlatform;
    }

    public PurchaseCapacityBlockRequest withInstancePlatform(String instancePlatform) {
        this.setInstancePlatform(instancePlatform);
        return this;
    }

    public PurchaseCapacityBlockRequest withInstancePlatform(CapacityReservationInstancePlatform instancePlatform) {
        this.instancePlatform = instancePlatform.toString();
        return this;
    }

    @Override
    public Request<PurchaseCapacityBlockRequest> getDryRunRequest() {
        Request<PurchaseCapacityBlockRequest> request = new PurchaseCapacityBlockRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications()).append(",");
        }
        if (this.getCapacityBlockOfferingId() != null) {
            sb.append("CapacityBlockOfferingId: ").append(this.getCapacityBlockOfferingId()).append(",");
        }
        if (this.getInstancePlatform() != null) {
            sb.append("InstancePlatform: ").append(this.getInstancePlatform());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseCapacityBlockRequest)) {
            return false;
        }
        PurchaseCapacityBlockRequest other = (PurchaseCapacityBlockRequest)obj;
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        if (other.getTagSpecifications() != null && !other.getTagSpecifications().equals(this.getTagSpecifications())) {
            return false;
        }
        if (other.getCapacityBlockOfferingId() == null ^ this.getCapacityBlockOfferingId() == null) {
            return false;
        }
        if (other.getCapacityBlockOfferingId() != null && !other.getCapacityBlockOfferingId().equals(this.getCapacityBlockOfferingId())) {
            return false;
        }
        if (other.getInstancePlatform() == null ^ this.getInstancePlatform() == null) {
            return false;
        }
        return other.getInstancePlatform() == null || other.getInstancePlatform().equals(this.getInstancePlatform());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getCapacityBlockOfferingId() == null ? 0 : this.getCapacityBlockOfferingId().hashCode());
        hashCode = 31 * hashCode + (this.getInstancePlatform() == null ? 0 : this.getInstancePlatform().hashCode());
        return hashCode;
    }

    public PurchaseCapacityBlockRequest clone() {
        return (PurchaseCapacityBlockRequest)super.clone();
    }
}

