/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2;

import javax.annotation.Generated;

import com.amazonaws.services.ec2.model.*;

/**
 * Interface for accessing Amazon EC2 asynchronously. Each asynchronous method will return a Java Future object
 * representing the asynchronous operation; overloads which accept an {@code AsyncHandler} can be used to receive
 * notification when an asynchronous operation completes.
 * <p>
 * <b>Note:</b> Do not directly implement this interface, new methods are added to it regularly. Extend from
 * {@link com.amazonaws.services.ec2.AbstractAmazonEC2Async} instead.
 * </p>
 * <p>
 * <fullname>Amazon Elastic Compute Cloud</fullname>
 * <p>
 * You can access the features of Amazon Elastic Compute Cloud (Amazon EC2) programmatically. For more information, see
 * the <a href="https://docs.aws.amazon.com/ec2/latest/devguide">Amazon EC2 Developer Guide</a>.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public interface AmazonEC2Async extends AmazonEC2 {

    /**
     * <p>
     * Accepts an Elastic IP address transfer. For more information, see <a href=
     * "https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#using-instance-addressing-eips-transfer-accept"
     * >Accept a transferred Elastic IP address</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * 
     * @param acceptAddressTransferRequest
     * @return A Java Future containing the result of the AcceptAddressTransfer operation returned by the service.
     * @sample AmazonEC2Async.AcceptAddressTransfer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptAddressTransfer" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AcceptAddressTransferResult> acceptAddressTransferAsync(AcceptAddressTransferRequest acceptAddressTransferRequest);

    /**
     * <p>
     * Accepts an Elastic IP address transfer. For more information, see <a href=
     * "https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#using-instance-addressing-eips-transfer-accept"
     * >Accept a transferred Elastic IP address</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * 
     * @param acceptAddressTransferRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AcceptAddressTransfer operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AcceptAddressTransfer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptAddressTransfer" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AcceptAddressTransferResult> acceptAddressTransferAsync(AcceptAddressTransferRequest acceptAddressTransferRequest,
            com.amazonaws.handlers.AsyncHandler<AcceptAddressTransferRequest, AcceptAddressTransferResult> asyncHandler);

    /**
     * <p>
     * Accepts the Convertible Reserved Instance exchange quote described in the
     * <a>GetReservedInstancesExchangeQuote</a> call.
     * </p>
     * 
     * @param acceptReservedInstancesExchangeQuoteRequest
     *        Contains the parameters for accepting the quote.
     * @return A Java Future containing the result of the AcceptReservedInstancesExchangeQuote operation returned by the
     *         service.
     * @sample AmazonEC2Async.AcceptReservedInstancesExchangeQuote
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuote"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AcceptReservedInstancesExchangeQuoteResult> acceptReservedInstancesExchangeQuoteAsync(
            AcceptReservedInstancesExchangeQuoteRequest acceptReservedInstancesExchangeQuoteRequest);

    /**
     * <p>
     * Accepts the Convertible Reserved Instance exchange quote described in the
     * <a>GetReservedInstancesExchangeQuote</a> call.
     * </p>
     * 
     * @param acceptReservedInstancesExchangeQuoteRequest
     *        Contains the parameters for accepting the quote.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AcceptReservedInstancesExchangeQuote operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.AcceptReservedInstancesExchangeQuote
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuote"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AcceptReservedInstancesExchangeQuoteResult> acceptReservedInstancesExchangeQuoteAsync(
            AcceptReservedInstancesExchangeQuoteRequest acceptReservedInstancesExchangeQuoteRequest,
            com.amazonaws.handlers.AsyncHandler<AcceptReservedInstancesExchangeQuoteRequest, AcceptReservedInstancesExchangeQuoteResult> asyncHandler);

    /**
     * <p>
     * Accepts a request to associate subnets with a transit gateway multicast domain.
     * </p>
     * 
     * @param acceptTransitGatewayMulticastDomainAssociationsRequest
     * @return A Java Future containing the result of the AcceptTransitGatewayMulticastDomainAssociations operation
     *         returned by the service.
     * @sample AmazonEC2Async.AcceptTransitGatewayMulticastDomainAssociations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayMulticastDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AcceptTransitGatewayMulticastDomainAssociationsResult> acceptTransitGatewayMulticastDomainAssociationsAsync(
            AcceptTransitGatewayMulticastDomainAssociationsRequest acceptTransitGatewayMulticastDomainAssociationsRequest);

    /**
     * <p>
     * Accepts a request to associate subnets with a transit gateway multicast domain.
     * </p>
     * 
     * @param acceptTransitGatewayMulticastDomainAssociationsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AcceptTransitGatewayMulticastDomainAssociations operation
     *         returned by the service.
     * @sample AmazonEC2AsyncHandler.AcceptTransitGatewayMulticastDomainAssociations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayMulticastDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AcceptTransitGatewayMulticastDomainAssociationsResult> acceptTransitGatewayMulticastDomainAssociationsAsync(
            AcceptTransitGatewayMulticastDomainAssociationsRequest acceptTransitGatewayMulticastDomainAssociationsRequest,
            com.amazonaws.handlers.AsyncHandler<AcceptTransitGatewayMulticastDomainAssociationsRequest, AcceptTransitGatewayMulticastDomainAssociationsResult> asyncHandler);

    /**
     * <p>
     * Accepts a transit gateway peering attachment request. The peering attachment must be in the
     * <code>pendingAcceptance</code> state.
     * </p>
     * 
     * @param acceptTransitGatewayPeeringAttachmentRequest
     * @return A Java Future containing the result of the AcceptTransitGatewayPeeringAttachment operation returned by
     *         the service.
     * @sample AmazonEC2Async.AcceptTransitGatewayPeeringAttachment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AcceptTransitGatewayPeeringAttachmentResult> acceptTransitGatewayPeeringAttachmentAsync(
            AcceptTransitGatewayPeeringAttachmentRequest acceptTransitGatewayPeeringAttachmentRequest);

    /**
     * <p>
     * Accepts a transit gateway peering attachment request. The peering attachment must be in the
     * <code>pendingAcceptance</code> state.
     * </p>
     * 
     * @param acceptTransitGatewayPeeringAttachmentRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AcceptTransitGatewayPeeringAttachment operation returned by
     *         the service.
     * @sample AmazonEC2AsyncHandler.AcceptTransitGatewayPeeringAttachment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AcceptTransitGatewayPeeringAttachmentResult> acceptTransitGatewayPeeringAttachmentAsync(
            AcceptTransitGatewayPeeringAttachmentRequest acceptTransitGatewayPeeringAttachmentRequest,
            com.amazonaws.handlers.AsyncHandler<AcceptTransitGatewayPeeringAttachmentRequest, AcceptTransitGatewayPeeringAttachmentResult> asyncHandler);

    /**
     * <p>
     * Accepts a request to attach a VPC to a transit gateway.
     * </p>
     * <p>
     * The VPC attachment must be in the <code>pendingAcceptance</code> state. Use
     * <a>DescribeTransitGatewayVpcAttachments</a> to view your pending VPC attachment requests. Use
     * <a>RejectTransitGatewayVpcAttachment</a> to reject a VPC attachment request.
     * </p>
     * 
     * @param acceptTransitGatewayVpcAttachmentRequest
     * @return A Java Future containing the result of the AcceptTransitGatewayVpcAttachment operation returned by the
     *         service.
     * @sample AmazonEC2Async.AcceptTransitGatewayVpcAttachment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AcceptTransitGatewayVpcAttachmentResult> acceptTransitGatewayVpcAttachmentAsync(
            AcceptTransitGatewayVpcAttachmentRequest acceptTransitGatewayVpcAttachmentRequest);

    /**
     * <p>
     * Accepts a request to attach a VPC to a transit gateway.
     * </p>
     * <p>
     * The VPC attachment must be in the <code>pendingAcceptance</code> state. Use
     * <a>DescribeTransitGatewayVpcAttachments</a> to view your pending VPC attachment requests. Use
     * <a>RejectTransitGatewayVpcAttachment</a> to reject a VPC attachment request.
     * </p>
     * 
     * @param acceptTransitGatewayVpcAttachmentRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AcceptTransitGatewayVpcAttachment operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.AcceptTransitGatewayVpcAttachment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AcceptTransitGatewayVpcAttachmentResult> acceptTransitGatewayVpcAttachmentAsync(
            AcceptTransitGatewayVpcAttachmentRequest acceptTransitGatewayVpcAttachmentRequest,
            com.amazonaws.handlers.AsyncHandler<AcceptTransitGatewayVpcAttachmentRequest, AcceptTransitGatewayVpcAttachmentResult> asyncHandler);

    /**
     * <p>
     * Accepts connection requests to your VPC endpoint service.
     * </p>
     * 
     * @param acceptVpcEndpointConnectionsRequest
     * @return A Java Future containing the result of the AcceptVpcEndpointConnections operation returned by the
     *         service.
     * @sample AmazonEC2Async.AcceptVpcEndpointConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnections"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AcceptVpcEndpointConnectionsResult> acceptVpcEndpointConnectionsAsync(
            AcceptVpcEndpointConnectionsRequest acceptVpcEndpointConnectionsRequest);

    /**
     * <p>
     * Accepts connection requests to your VPC endpoint service.
     * </p>
     * 
     * @param acceptVpcEndpointConnectionsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AcceptVpcEndpointConnections operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.AcceptVpcEndpointConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnections"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AcceptVpcEndpointConnectionsResult> acceptVpcEndpointConnectionsAsync(
            AcceptVpcEndpointConnectionsRequest acceptVpcEndpointConnectionsRequest,
            com.amazonaws.handlers.AsyncHandler<AcceptVpcEndpointConnectionsRequest, AcceptVpcEndpointConnectionsResult> asyncHandler);

    /**
     * <p>
     * Accept a VPC peering connection request. To accept a request, the VPC peering connection must be in the
     * <code>pending-acceptance</code> state, and you must be the owner of the peer VPC. Use
     * <a>DescribeVpcPeeringConnections</a> to view your outstanding VPC peering connection requests.
     * </p>
     * <p>
     * For an inter-Region VPC peering connection request, you must accept the VPC peering connection in the Region of
     * the accepter VPC.
     * </p>
     * 
     * @param acceptVpcPeeringConnectionRequest
     * @return A Java Future containing the result of the AcceptVpcPeeringConnection operation returned by the service.
     * @sample AmazonEC2Async.AcceptVpcPeeringConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnection" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<AcceptVpcPeeringConnectionResult> acceptVpcPeeringConnectionAsync(
            AcceptVpcPeeringConnectionRequest acceptVpcPeeringConnectionRequest);

    /**
     * <p>
     * Accept a VPC peering connection request. To accept a request, the VPC peering connection must be in the
     * <code>pending-acceptance</code> state, and you must be the owner of the peer VPC. Use
     * <a>DescribeVpcPeeringConnections</a> to view your outstanding VPC peering connection requests.
     * </p>
     * <p>
     * For an inter-Region VPC peering connection request, you must accept the VPC peering connection in the Region of
     * the accepter VPC.
     * </p>
     * 
     * @param acceptVpcPeeringConnectionRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AcceptVpcPeeringConnection operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AcceptVpcPeeringConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnection" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<AcceptVpcPeeringConnectionResult> acceptVpcPeeringConnectionAsync(
            AcceptVpcPeeringConnectionRequest acceptVpcPeeringConnectionRequest,
            com.amazonaws.handlers.AsyncHandler<AcceptVpcPeeringConnectionRequest, AcceptVpcPeeringConnectionResult> asyncHandler);

    /**
     * Simplified method form for invoking the AcceptVpcPeeringConnection operation.
     *
     * @see #acceptVpcPeeringConnectionAsync(AcceptVpcPeeringConnectionRequest)
     */
    java.util.concurrent.Future<AcceptVpcPeeringConnectionResult> acceptVpcPeeringConnectionAsync();

    /**
     * Simplified method form for invoking the AcceptVpcPeeringConnection operation with an AsyncHandler.
     *
     * @see #acceptVpcPeeringConnectionAsync(AcceptVpcPeeringConnectionRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<AcceptVpcPeeringConnectionResult> acceptVpcPeeringConnectionAsync(
            com.amazonaws.handlers.AsyncHandler<AcceptVpcPeeringConnectionRequest, AcceptVpcPeeringConnectionResult> asyncHandler);

    /**
     * <p>
     * Advertises an IPv4 or IPv6 address range that is provisioned for use with your Amazon Web Services resources
     * through bring your own IP addresses (BYOIP).
     * </p>
     * <p>
     * You can perform this operation at most once every 10 seconds, even if you specify different address ranges each
     * time.
     * </p>
     * <p>
     * We recommend that you stop advertising the BYOIP CIDR from other locations when you advertise it from Amazon Web
     * Services. To minimize down time, you can configure your Amazon Web Services resources to use an address from a
     * BYOIP CIDR before it is advertised, and then simultaneously stop advertising it from the current location and
     * start advertising it through Amazon Web Services.
     * </p>
     * <p>
     * It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services because
     * of BGP propagation delays.
     * </p>
     * <p>
     * To stop advertising the BYOIP CIDR, use <a>WithdrawByoipCidr</a>.
     * </p>
     * 
     * @param advertiseByoipCidrRequest
     * @return A Java Future containing the result of the AdvertiseByoipCidr operation returned by the service.
     * @sample AmazonEC2Async.AdvertiseByoipCidr
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AdvertiseByoipCidrResult> advertiseByoipCidrAsync(AdvertiseByoipCidrRequest advertiseByoipCidrRequest);

    /**
     * <p>
     * Advertises an IPv4 or IPv6 address range that is provisioned for use with your Amazon Web Services resources
     * through bring your own IP addresses (BYOIP).
     * </p>
     * <p>
     * You can perform this operation at most once every 10 seconds, even if you specify different address ranges each
     * time.
     * </p>
     * <p>
     * We recommend that you stop advertising the BYOIP CIDR from other locations when you advertise it from Amazon Web
     * Services. To minimize down time, you can configure your Amazon Web Services resources to use an address from a
     * BYOIP CIDR before it is advertised, and then simultaneously stop advertising it from the current location and
     * start advertising it through Amazon Web Services.
     * </p>
     * <p>
     * It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services because
     * of BGP propagation delays.
     * </p>
     * <p>
     * To stop advertising the BYOIP CIDR, use <a>WithdrawByoipCidr</a>.
     * </p>
     * 
     * @param advertiseByoipCidrRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AdvertiseByoipCidr operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AdvertiseByoipCidr
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AdvertiseByoipCidrResult> advertiseByoipCidrAsync(AdvertiseByoipCidrRequest advertiseByoipCidrRequest,
            com.amazonaws.handlers.AsyncHandler<AdvertiseByoipCidrRequest, AdvertiseByoipCidrResult> asyncHandler);

    /**
     * <p>
     * Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address
     * you can associate it with an instance or network interface. After you release an Elastic IP address, it is
     * released to the IP address pool and can be allocated to a different Amazon Web Services account.
     * </p>
     * <p>
     * You can allocate an Elastic IP address from an address pool owned by Amazon Web Services or from an address pool
     * created from a public IPv4 address range that you have brought to Amazon Web Services for use with your Amazon
     * Web Services resources using bring your own IP addresses (BYOIP). For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring Your Own IP Addresses (BYOIP)</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * If you release an Elastic IP address, you might be able to recover it. You cannot recover an Elastic IP address
     * that you released after it is allocated to another Amazon Web Services account. To attempt to recover an Elastic
     * IP address that you released, specify it in this operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * You can allocate a carrier IP address which is a public IP address from a telecommunication carrier, to a network
     * interface which resides in a subnet in a Wavelength Zone (for example an EC2 instance).
     * </p>
     * 
     * @param allocateAddressRequest
     * @return A Java Future containing the result of the AllocateAddress operation returned by the service.
     * @sample AmazonEC2Async.AllocateAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AllocateAddressResult> allocateAddressAsync(AllocateAddressRequest allocateAddressRequest);

    /**
     * <p>
     * Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the Elastic IP address
     * you can associate it with an instance or network interface. After you release an Elastic IP address, it is
     * released to the IP address pool and can be allocated to a different Amazon Web Services account.
     * </p>
     * <p>
     * You can allocate an Elastic IP address from an address pool owned by Amazon Web Services or from an address pool
     * created from a public IPv4 address range that you have brought to Amazon Web Services for use with your Amazon
     * Web Services resources using bring your own IP addresses (BYOIP). For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">Bring Your Own IP Addresses (BYOIP)</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * If you release an Elastic IP address, you might be able to recover it. You cannot recover an Elastic IP address
     * that you released after it is allocated to another Amazon Web Services account. To attempt to recover an Elastic
     * IP address that you released, specify it in this operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * You can allocate a carrier IP address which is a public IP address from a telecommunication carrier, to a network
     * interface which resides in a subnet in a Wavelength Zone (for example an EC2 instance).
     * </p>
     * 
     * @param allocateAddressRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AllocateAddress operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AllocateAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AllocateAddressResult> allocateAddressAsync(AllocateAddressRequest allocateAddressRequest,
            com.amazonaws.handlers.AsyncHandler<AllocateAddressRequest, AllocateAddressResult> asyncHandler);

    /**
     * Simplified method form for invoking the AllocateAddress operation.
     *
     * @see #allocateAddressAsync(AllocateAddressRequest)
     */
    java.util.concurrent.Future<AllocateAddressResult> allocateAddressAsync();

    /**
     * Simplified method form for invoking the AllocateAddress operation with an AsyncHandler.
     *
     * @see #allocateAddressAsync(AllocateAddressRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<AllocateAddressResult> allocateAddressAsync(
            com.amazonaws.handlers.AsyncHandler<AllocateAddressRequest, AllocateAddressResult> asyncHandler);

    /**
     * <p>
     * Allocates a Dedicated Host to your account. At a minimum, specify the supported instance type or instance family,
     * the Availability Zone in which to allocate the host, and the number of hosts to allocate.
     * </p>
     * 
     * @param allocateHostsRequest
     * @return A Java Future containing the result of the AllocateHosts operation returned by the service.
     * @sample AmazonEC2Async.AllocateHosts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHosts" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AllocateHostsResult> allocateHostsAsync(AllocateHostsRequest allocateHostsRequest);

    /**
     * <p>
     * Allocates a Dedicated Host to your account. At a minimum, specify the supported instance type or instance family,
     * the Availability Zone in which to allocate the host, and the number of hosts to allocate.
     * </p>
     * 
     * @param allocateHostsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AllocateHosts operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AllocateHosts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHosts" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AllocateHostsResult> allocateHostsAsync(AllocateHostsRequest allocateHostsRequest,
            com.amazonaws.handlers.AsyncHandler<AllocateHostsRequest, AllocateHostsResult> asyncHandler);

    /**
     * <p>
     * Allocate a CIDR from an IPAM pool. The Region you use should be the IPAM pool locale. The locale is the Amazon
     * Web Services Region where this IPAM pool is available for allocations.
     * </p>
     * <p>
     * In IPAM, an allocation is a CIDR assignment from an IPAM pool to another IPAM pool or to a resource. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/allocate-cidrs-ipam.html">Allocate
     * CIDRs</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action creates an allocation with strong consistency. The returned CIDR will not overlap with any other
     * allocations from the same pool.
     * </p>
     * </note>
     * 
     * @param allocateIpamPoolCidrRequest
     * @return A Java Future containing the result of the AllocateIpamPoolCidr operation returned by the service.
     * @sample AmazonEC2Async.AllocateIpamPoolCidr
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateIpamPoolCidr" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AllocateIpamPoolCidrResult> allocateIpamPoolCidrAsync(AllocateIpamPoolCidrRequest allocateIpamPoolCidrRequest);

    /**
     * <p>
     * Allocate a CIDR from an IPAM pool. The Region you use should be the IPAM pool locale. The locale is the Amazon
     * Web Services Region where this IPAM pool is available for allocations.
     * </p>
     * <p>
     * In IPAM, an allocation is a CIDR assignment from an IPAM pool to another IPAM pool or to a resource. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/allocate-cidrs-ipam.html">Allocate
     * CIDRs</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action creates an allocation with strong consistency. The returned CIDR will not overlap with any other
     * allocations from the same pool.
     * </p>
     * </note>
     * 
     * @param allocateIpamPoolCidrRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AllocateIpamPoolCidr operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AllocateIpamPoolCidr
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateIpamPoolCidr" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AllocateIpamPoolCidrResult> allocateIpamPoolCidrAsync(AllocateIpamPoolCidrRequest allocateIpamPoolCidrRequest,
            com.amazonaws.handlers.AsyncHandler<AllocateIpamPoolCidrRequest, AllocateIpamPoolCidrResult> asyncHandler);

    /**
     * <p>
     * Applies a security group to the association between the target network and the Client VPN endpoint. This action
     * replaces the existing security groups with the specified security groups.
     * </p>
     * 
     * @param applySecurityGroupsToClientVpnTargetNetworkRequest
     * @return A Java Future containing the result of the ApplySecurityGroupsToClientVpnTargetNetwork operation returned
     *         by the service.
     * @sample AmazonEC2Async.ApplySecurityGroupsToClientVpnTargetNetwork
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<ApplySecurityGroupsToClientVpnTargetNetworkResult> applySecurityGroupsToClientVpnTargetNetworkAsync(
            ApplySecurityGroupsToClientVpnTargetNetworkRequest applySecurityGroupsToClientVpnTargetNetworkRequest);

    /**
     * <p>
     * Applies a security group to the association between the target network and the Client VPN endpoint. This action
     * replaces the existing security groups with the specified security groups.
     * </p>
     * 
     * @param applySecurityGroupsToClientVpnTargetNetworkRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the ApplySecurityGroupsToClientVpnTargetNetwork operation returned
     *         by the service.
     * @sample AmazonEC2AsyncHandler.ApplySecurityGroupsToClientVpnTargetNetwork
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<ApplySecurityGroupsToClientVpnTargetNetworkResult> applySecurityGroupsToClientVpnTargetNetworkAsync(
            ApplySecurityGroupsToClientVpnTargetNetworkRequest applySecurityGroupsToClientVpnTargetNetworkRequest,
            com.amazonaws.handlers.AsyncHandler<ApplySecurityGroupsToClientVpnTargetNetworkRequest, ApplySecurityGroupsToClientVpnTargetNetworkResult> asyncHandler);

    /**
     * <p>
     * Assigns one or more IPv6 addresses to the specified network interface. You can specify one or more specific IPv6
     * addresses, or you can specify the number of IPv6 addresses to be automatically assigned from within the subnet's
     * IPv6 CIDR block range. You can assign as many IPv6 addresses to a network interface as you can assign private
     * IPv4 addresses, and the limit varies per instance type. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per
     * Network Interface Per Instance Type</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * You must specify either the IPv6 addresses or the IPv6 address count in the request.
     * </p>
     * <p>
     * You can optionally use Prefix Delegation on the network interface. You must specify either the IPV6 Prefix
     * Delegation prefixes, or the IPv6 Prefix Delegation count. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to Amazon EC2
     * network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param assignIpv6AddressesRequest
     * @return A Java Future containing the result of the AssignIpv6Addresses operation returned by the service.
     * @sample AmazonEC2Async.AssignIpv6Addresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6Addresses" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AssignIpv6AddressesResult> assignIpv6AddressesAsync(AssignIpv6AddressesRequest assignIpv6AddressesRequest);

    /**
     * <p>
     * Assigns one or more IPv6 addresses to the specified network interface. You can specify one or more specific IPv6
     * addresses, or you can specify the number of IPv6 addresses to be automatically assigned from within the subnet's
     * IPv6 CIDR block range. You can assign as many IPv6 addresses to a network interface as you can assign private
     * IPv4 addresses, and the limit varies per instance type. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per
     * Network Interface Per Instance Type</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * You must specify either the IPv6 addresses or the IPv6 address count in the request.
     * </p>
     * <p>
     * You can optionally use Prefix Delegation on the network interface. You must specify either the IPV6 Prefix
     * Delegation prefixes, or the IPv6 Prefix Delegation count. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to Amazon EC2
     * network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param assignIpv6AddressesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssignIpv6Addresses operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AssignIpv6Addresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6Addresses" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AssignIpv6AddressesResult> assignIpv6AddressesAsync(AssignIpv6AddressesRequest assignIpv6AddressesRequest,
            com.amazonaws.handlers.AsyncHandler<AssignIpv6AddressesRequest, AssignIpv6AddressesResult> asyncHandler);

    /**
     * <p>
     * Assigns one or more secondary private IP addresses to the specified network interface.
     * </p>
     * <p>
     * You can specify one or more specific secondary IP addresses, or you can specify the number of secondary IP
     * addresses to be automatically assigned within the subnet's CIDR block range. The number of secondary IP addresses
     * that you can assign to an instance varies by instance type. For information about instance types, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about Elastic IP addresses, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * When you move a secondary private IP address to another network interface, any Elastic IP address that is
     * associated with the IP address is also moved.
     * </p>
     * <p>
     * Remapping an IP address is an asynchronous operation. When you move an IP address from one network interface to
     * another, check <code>network/interfaces/macs/mac/local-ipv4s</code> in the instance metadata to confirm that the
     * remapping is complete.
     * </p>
     * <p>
     * You must specify either the IP addresses or the IP address count in the request.
     * </p>
     * <p>
     * You can optionally use Prefix Delegation on the network interface. You must specify either the IPv4 Prefix
     * Delegation prefixes, or the IPv4 Prefix Delegation count. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to Amazon EC2
     * network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param assignPrivateIpAddressesRequest
     *        Contains the parameters for AssignPrivateIpAddresses.
     * @return A Java Future containing the result of the AssignPrivateIpAddresses operation returned by the service.
     * @sample AmazonEC2Async.AssignPrivateIpAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<AssignPrivateIpAddressesResult> assignPrivateIpAddressesAsync(AssignPrivateIpAddressesRequest assignPrivateIpAddressesRequest);

    /**
     * <p>
     * Assigns one or more secondary private IP addresses to the specified network interface.
     * </p>
     * <p>
     * You can specify one or more specific secondary IP addresses, or you can specify the number of secondary IP
     * addresses to be automatically assigned within the subnet's CIDR block range. The number of secondary IP addresses
     * that you can assign to an instance varies by instance type. For information about instance types, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about Elastic IP addresses, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP Addresses</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * When you move a secondary private IP address to another network interface, any Elastic IP address that is
     * associated with the IP address is also moved.
     * </p>
     * <p>
     * Remapping an IP address is an asynchronous operation. When you move an IP address from one network interface to
     * another, check <code>network/interfaces/macs/mac/local-ipv4s</code> in the instance metadata to confirm that the
     * remapping is complete.
     * </p>
     * <p>
     * You must specify either the IP addresses or the IP address count in the request.
     * </p>
     * <p>
     * You can optionally use Prefix Delegation on the network interface. You must specify either the IPv4 Prefix
     * Delegation prefixes, or the IPv4 Prefix Delegation count. For information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html"> Assigning prefixes to Amazon EC2
     * network interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param assignPrivateIpAddressesRequest
     *        Contains the parameters for AssignPrivateIpAddresses.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssignPrivateIpAddresses operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AssignPrivateIpAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<AssignPrivateIpAddressesResult> assignPrivateIpAddressesAsync(AssignPrivateIpAddressesRequest assignPrivateIpAddressesRequest,
            com.amazonaws.handlers.AsyncHandler<AssignPrivateIpAddressesRequest, AssignPrivateIpAddressesResult> asyncHandler);

    /**
     * <p>
     * Assigns one or more private IPv4 addresses to a private NAT gateway. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-working-with">Work with
     * NAT gateways</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param assignPrivateNatGatewayAddressRequest
     * @return A Java Future containing the result of the AssignPrivateNatGatewayAddress operation returned by the
     *         service.
     * @sample AmazonEC2Async.AssignPrivateNatGatewayAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateNatGatewayAddress"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssignPrivateNatGatewayAddressResult> assignPrivateNatGatewayAddressAsync(
            AssignPrivateNatGatewayAddressRequest assignPrivateNatGatewayAddressRequest);

    /**
     * <p>
     * Assigns one or more private IPv4 addresses to a private NAT gateway. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-working-with">Work with
     * NAT gateways</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param assignPrivateNatGatewayAddressRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssignPrivateNatGatewayAddress operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.AssignPrivateNatGatewayAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateNatGatewayAddress"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssignPrivateNatGatewayAddressResult> assignPrivateNatGatewayAddressAsync(
            AssignPrivateNatGatewayAddressRequest assignPrivateNatGatewayAddressRequest,
            com.amazonaws.handlers.AsyncHandler<AssignPrivateNatGatewayAddressRequest, AssignPrivateNatGatewayAddressResult> asyncHandler);

    /**
     * <p>
     * Associates an Elastic IP address, or carrier IP address (for instances that are in subnets in Wavelength Zones)
     * with an instance or a network interface. Before you can use an Elastic IP address, you must allocate it to your
     * account.
     * </p>
     * <p>
     * If the Elastic IP address is already associated with a different instance, it is disassociated from that instance
     * and associated with the specified instance. If you associate an Elastic IP address with an instance that has an
     * existing Elastic IP address, the existing address is disassociated from the instance, but remains allocated to
     * your account.
     * </p>
     * <p>
     * [Subnets in Wavelength Zones] You can associate an IP address from the telecommunication carrier to the instance
     * or network interface.
     * </p>
     * <p>
     * You cannot associate an Elastic IP address with an interface in a different network border group.
     * </p>
     * <important>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error,
     * and you may be charged for each time the Elastic IP address is remapped to the same instance. For more
     * information, see the <i>Elastic IP Addresses</i> section of <a href="http://aws.amazon.com/ec2/pricing/">Amazon
     * EC2 Pricing</a>.
     * </p>
     * </important>
     * 
     * @param associateAddressRequest
     * @return A Java Future containing the result of the AssociateAddress operation returned by the service.
     * @sample AmazonEC2Async.AssociateAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AssociateAddressResult> associateAddressAsync(AssociateAddressRequest associateAddressRequest);

    /**
     * <p>
     * Associates an Elastic IP address, or carrier IP address (for instances that are in subnets in Wavelength Zones)
     * with an instance or a network interface. Before you can use an Elastic IP address, you must allocate it to your
     * account.
     * </p>
     * <p>
     * If the Elastic IP address is already associated with a different instance, it is disassociated from that instance
     * and associated with the specified instance. If you associate an Elastic IP address with an instance that has an
     * existing Elastic IP address, the existing address is disassociated from the instance, but remains allocated to
     * your account.
     * </p>
     * <p>
     * [Subnets in Wavelength Zones] You can associate an IP address from the telecommunication carrier to the instance
     * or network interface.
     * </p>
     * <p>
     * You cannot associate an Elastic IP address with an interface in a different network border group.
     * </p>
     * <important>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error,
     * and you may be charged for each time the Elastic IP address is remapped to the same instance. For more
     * information, see the <i>Elastic IP Addresses</i> section of <a href="http://aws.amazon.com/ec2/pricing/">Amazon
     * EC2 Pricing</a>.
     * </p>
     * </important>
     * 
     * @param associateAddressRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssociateAddress operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AssociateAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AssociateAddressResult> associateAddressAsync(AssociateAddressRequest associateAddressRequest,
            com.amazonaws.handlers.AsyncHandler<AssociateAddressRequest, AssociateAddressResult> asyncHandler);

    /**
     * <p>
     * Associates a target network with a Client VPN endpoint. A target network is a subnet in a VPC. You can associate
     * multiple subnets from the same VPC with a Client VPN endpoint. You can associate only one subnet in each
     * Availability Zone. We recommend that you associate at least two subnets to provide Availability Zone redundancy.
     * </p>
     * <p>
     * If you specified a VPC when you created the Client VPN endpoint or if you have previous subnet associations, the
     * specified subnet must be in the same VPC. To specify a subnet that's in a different VPC, you must first modify
     * the Client VPN endpoint (<a>ModifyClientVpnEndpoint</a>) and change the VPC that's associated with it.
     * </p>
     * 
     * @param associateClientVpnTargetNetworkRequest
     * @return A Java Future containing the result of the AssociateClientVpnTargetNetwork operation returned by the
     *         service.
     * @sample AmazonEC2Async.AssociateClientVpnTargetNetwork
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssociateClientVpnTargetNetworkResult> associateClientVpnTargetNetworkAsync(
            AssociateClientVpnTargetNetworkRequest associateClientVpnTargetNetworkRequest);

    /**
     * <p>
     * Associates a target network with a Client VPN endpoint. A target network is a subnet in a VPC. You can associate
     * multiple subnets from the same VPC with a Client VPN endpoint. You can associate only one subnet in each
     * Availability Zone. We recommend that you associate at least two subnets to provide Availability Zone redundancy.
     * </p>
     * <p>
     * If you specified a VPC when you created the Client VPN endpoint or if you have previous subnet associations, the
     * specified subnet must be in the same VPC. To specify a subnet that's in a different VPC, you must first modify
     * the Client VPN endpoint (<a>ModifyClientVpnEndpoint</a>) and change the VPC that's associated with it.
     * </p>
     * 
     * @param associateClientVpnTargetNetworkRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssociateClientVpnTargetNetwork operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.AssociateClientVpnTargetNetwork
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssociateClientVpnTargetNetworkResult> associateClientVpnTargetNetworkAsync(
            AssociateClientVpnTargetNetworkRequest associateClientVpnTargetNetworkRequest,
            com.amazonaws.handlers.AsyncHandler<AssociateClientVpnTargetNetworkRequest, AssociateClientVpnTargetNetworkResult> asyncHandler);

    /**
     * <p>
     * Associates a set of DHCP options (that you've previously created) with the specified VPC, or associates no DHCP
     * options with the VPC.
     * </p>
     * <p>
     * After you associate the options with the VPC, any existing instances and all new instances that you launch in
     * that VPC use the options. You don't need to restart or relaunch the instances. They automatically pick up the
     * changes within a few hours, depending on how frequently the instance renews its DHCP lease. You can explicitly
     * renew the lease using the operating system on the instance.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP
     * options sets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param associateDhcpOptionsRequest
     * @return A Java Future containing the result of the AssociateDhcpOptions operation returned by the service.
     * @sample AmazonEC2Async.AssociateDhcpOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AssociateDhcpOptionsResult> associateDhcpOptionsAsync(AssociateDhcpOptionsRequest associateDhcpOptionsRequest);

    /**
     * <p>
     * Associates a set of DHCP options (that you've previously created) with the specified VPC, or associates no DHCP
     * options with the VPC.
     * </p>
     * <p>
     * After you associate the options with the VPC, any existing instances and all new instances that you launch in
     * that VPC use the options. You don't need to restart or relaunch the instances. They automatically pick up the
     * changes within a few hours, depending on how frequently the instance renews its DHCP lease. You can explicitly
     * renew the lease using the operating system on the instance.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP
     * options sets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param associateDhcpOptionsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssociateDhcpOptions operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AssociateDhcpOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AssociateDhcpOptionsResult> associateDhcpOptionsAsync(AssociateDhcpOptionsRequest associateDhcpOptionsRequest,
            com.amazonaws.handlers.AsyncHandler<AssociateDhcpOptionsRequest, AssociateDhcpOptionsResult> asyncHandler);

    /**
     * <p>
     * Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM) certificate. This
     * enables the certificate to be used by the ACM for Nitro Enclaves application inside an enclave. For more
     * information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html">Certificate
     * Manager for Nitro Enclaves</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.
     * </p>
     * <p>
     * When the IAM role is associated with the ACM certificate, the certificate, certificate chain, and encrypted
     * private key are placed in an Amazon S3 location that only the associated IAM role can access. The private key of
     * the certificate is encrypted with an Amazon Web Services managed key that has an attached attestation-based key
     * policy.
     * </p>
     * <p>
     * To enable the IAM role to access the Amazon S3 object, you must grant it permission to call
     * <code>s3:GetObject</code> on the Amazon S3 bucket returned by the command. To enable the IAM role to access the
     * KMS key, you must grant it permission to call <code>kms:Decrypt</code> on the KMS key returned by the command.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy"> Grant the role
     * permission to access the certificate and encryption key</a> in the <i>Amazon Web Services Nitro Enclaves User
     * Guide</i>.
     * </p>
     * 
     * @param associateEnclaveCertificateIamRoleRequest
     * @return A Java Future containing the result of the AssociateEnclaveCertificateIamRole operation returned by the
     *         service.
     * @sample AmazonEC2Async.AssociateEnclaveCertificateIamRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateEnclaveCertificateIamRole"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssociateEnclaveCertificateIamRoleResult> associateEnclaveCertificateIamRoleAsync(
            AssociateEnclaveCertificateIamRoleRequest associateEnclaveCertificateIamRoleRequest);

    /**
     * <p>
     * Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM) certificate. This
     * enables the certificate to be used by the ACM for Nitro Enclaves application inside an enclave. For more
     * information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html">Certificate
     * Manager for Nitro Enclaves</a> in the <i>Amazon Web Services Nitro Enclaves User Guide</i>.
     * </p>
     * <p>
     * When the IAM role is associated with the ACM certificate, the certificate, certificate chain, and encrypted
     * private key are placed in an Amazon S3 location that only the associated IAM role can access. The private key of
     * the certificate is encrypted with an Amazon Web Services managed key that has an attached attestation-based key
     * policy.
     * </p>
     * <p>
     * To enable the IAM role to access the Amazon S3 object, you must grant it permission to call
     * <code>s3:GetObject</code> on the Amazon S3 bucket returned by the command. To enable the IAM role to access the
     * KMS key, you must grant it permission to call <code>kms:Decrypt</code> on the KMS key returned by the command.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy"> Grant the role
     * permission to access the certificate and encryption key</a> in the <i>Amazon Web Services Nitro Enclaves User
     * Guide</i>.
     * </p>
     * 
     * @param associateEnclaveCertificateIamRoleRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssociateEnclaveCertificateIamRole operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.AssociateEnclaveCertificateIamRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateEnclaveCertificateIamRole"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssociateEnclaveCertificateIamRoleResult> associateEnclaveCertificateIamRoleAsync(
            AssociateEnclaveCertificateIamRoleRequest associateEnclaveCertificateIamRoleRequest,
            com.amazonaws.handlers.AsyncHandler<AssociateEnclaveCertificateIamRoleRequest, AssociateEnclaveCertificateIamRoleResult> asyncHandler);

    /**
     * <p>
     * Associates an IAM instance profile with a running or stopped instance. You cannot associate more than one IAM
     * instance profile with an instance.
     * </p>
     * 
     * @param associateIamInstanceProfileRequest
     * @return A Java Future containing the result of the AssociateIamInstanceProfile operation returned by the service.
     * @sample AmazonEC2Async.AssociateIamInstanceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssociateIamInstanceProfileResult> associateIamInstanceProfileAsync(
            AssociateIamInstanceProfileRequest associateIamInstanceProfileRequest);

    /**
     * <p>
     * Associates an IAM instance profile with a running or stopped instance. You cannot associate more than one IAM
     * instance profile with an instance.
     * </p>
     * 
     * @param associateIamInstanceProfileRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssociateIamInstanceProfile operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AssociateIamInstanceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssociateIamInstanceProfileResult> associateIamInstanceProfileAsync(
            AssociateIamInstanceProfileRequest associateIamInstanceProfileRequest,
            com.amazonaws.handlers.AsyncHandler<AssociateIamInstanceProfileRequest, AssociateIamInstanceProfileResult> asyncHandler);

    /**
     * <p>
     * Associates one or more targets with an event window. Only one type of target (instance IDs, Dedicated Host IDs,
     * or tags) can be specified with an event window.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param associateInstanceEventWindowRequest
     * @return A Java Future containing the result of the AssociateInstanceEventWindow operation returned by the
     *         service.
     * @sample AmazonEC2Async.AssociateInstanceEventWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateInstanceEventWindow"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssociateInstanceEventWindowResult> associateInstanceEventWindowAsync(
            AssociateInstanceEventWindowRequest associateInstanceEventWindowRequest);

    /**
     * <p>
     * Associates one or more targets with an event window. Only one type of target (instance IDs, Dedicated Host IDs,
     * or tags) can be specified with an event window.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param associateInstanceEventWindowRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssociateInstanceEventWindow operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.AssociateInstanceEventWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateInstanceEventWindow"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssociateInstanceEventWindowResult> associateInstanceEventWindowAsync(
            AssociateInstanceEventWindowRequest associateInstanceEventWindowRequest,
            com.amazonaws.handlers.AsyncHandler<AssociateInstanceEventWindowRequest, AssociateInstanceEventWindowResult> asyncHandler);

    /**
     * <p>
     * Associates your Autonomous System Number (ASN) with a BYOIP CIDR that you own in the same Amazon Web Services
     * Region. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in
     * the <i>Amazon VPC IPAM guide</i>.
     * </p>
     * <p>
     * After the association succeeds, the ASN is eligible for advertisement. You can view the association with <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeByoipCidrs.html">DescribeByoipCidrs</a>.
     * You can advertise the CIDR with <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AdvertiseByoipCidr.html">AdvertiseByoipCidr</a>.
     * </p>
     * 
     * @param associateIpamByoasnRequest
     * @return A Java Future containing the result of the AssociateIpamByoasn operation returned by the service.
     * @sample AmazonEC2Async.AssociateIpamByoasn
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamByoasn" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AssociateIpamByoasnResult> associateIpamByoasnAsync(AssociateIpamByoasnRequest associateIpamByoasnRequest);

    /**
     * <p>
     * Associates your Autonomous System Number (ASN) with a BYOIP CIDR that you own in the same Amazon Web Services
     * Region. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in
     * the <i>Amazon VPC IPAM guide</i>.
     * </p>
     * <p>
     * After the association succeeds, the ASN is eligible for advertisement. You can view the association with <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeByoipCidrs.html">DescribeByoipCidrs</a>.
     * You can advertise the CIDR with <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AdvertiseByoipCidr.html">AdvertiseByoipCidr</a>.
     * </p>
     * 
     * @param associateIpamByoasnRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssociateIpamByoasn operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AssociateIpamByoasn
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamByoasn" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AssociateIpamByoasnResult> associateIpamByoasnAsync(AssociateIpamByoasnRequest associateIpamByoasnRequest,
            com.amazonaws.handlers.AsyncHandler<AssociateIpamByoasnRequest, AssociateIpamByoasnResult> asyncHandler);

    /**
     * <p>
     * Associates an IPAM resource discovery with an Amazon VPC IPAM. A resource discovery is an IPAM component that
     * enables IPAM to manage and monitor resources that belong to the owning account.
     * </p>
     * 
     * @param associateIpamResourceDiscoveryRequest
     * @return A Java Future containing the result of the AssociateIpamResourceDiscovery operation returned by the
     *         service.
     * @sample AmazonEC2Async.AssociateIpamResourceDiscovery
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamResourceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssociateIpamResourceDiscoveryResult> associateIpamResourceDiscoveryAsync(
            AssociateIpamResourceDiscoveryRequest associateIpamResourceDiscoveryRequest);

    /**
     * <p>
     * Associates an IPAM resource discovery with an Amazon VPC IPAM. A resource discovery is an IPAM component that
     * enables IPAM to manage and monitor resources that belong to the owning account.
     * </p>
     * 
     * @param associateIpamResourceDiscoveryRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssociateIpamResourceDiscovery operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.AssociateIpamResourceDiscovery
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamResourceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssociateIpamResourceDiscoveryResult> associateIpamResourceDiscoveryAsync(
            AssociateIpamResourceDiscoveryRequest associateIpamResourceDiscoveryRequest,
            com.amazonaws.handlers.AsyncHandler<AssociateIpamResourceDiscoveryRequest, AssociateIpamResourceDiscoveryResult> asyncHandler);

    /**
     * <p>
     * Associates Elastic IP addresses (EIPs) and private IPv4 addresses with a public NAT gateway. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-working-with">Work with
     * NAT gateways</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * By default, you can associate up to 2 Elastic IP addresses per public NAT gateway. You can increase the limit by
     * requesting a quota adjustment. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-eips">Elastic IP address
     * quotas</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <important>
     * <p>
     * When you associate an EIP or secondary EIPs with a public NAT gateway, the network border group of the EIPs must
     * match the network border group of the Availability Zone (AZ) that the public NAT gateway is in. If it's not the
     * same, the EIP will fail to associate. You can see the network border group for the subnet's AZ by viewing the
     * details of the subnet. Similarly, you can view the network border group of an EIP by viewing the details of the
     * EIP address. For more information about network border groups and EIPs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#allocate-eip">Allocate an Elastic IP
     * address</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * </important>
     * 
     * @param associateNatGatewayAddressRequest
     * @return A Java Future containing the result of the AssociateNatGatewayAddress operation returned by the service.
     * @sample AmazonEC2Async.AssociateNatGatewayAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateNatGatewayAddress" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<AssociateNatGatewayAddressResult> associateNatGatewayAddressAsync(
            AssociateNatGatewayAddressRequest associateNatGatewayAddressRequest);

    /**
     * <p>
     * Associates Elastic IP addresses (EIPs) and private IPv4 addresses with a public NAT gateway. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-working-with">Work with
     * NAT gateways</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * By default, you can associate up to 2 Elastic IP addresses per public NAT gateway. You can increase the limit by
     * requesting a quota adjustment. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-eips">Elastic IP address
     * quotas</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <important>
     * <p>
     * When you associate an EIP or secondary EIPs with a public NAT gateway, the network border group of the EIPs must
     * match the network border group of the Availability Zone (AZ) that the public NAT gateway is in. If it's not the
     * same, the EIP will fail to associate. You can see the network border group for the subnet's AZ by viewing the
     * details of the subnet. Similarly, you can view the network border group of an EIP by viewing the details of the
     * EIP address. For more information about network border groups and EIPs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#allocate-eip">Allocate an Elastic IP
     * address</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * </important>
     * 
     * @param associateNatGatewayAddressRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssociateNatGatewayAddress operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AssociateNatGatewayAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateNatGatewayAddress" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<AssociateNatGatewayAddressResult> associateNatGatewayAddressAsync(
            AssociateNatGatewayAddressRequest associateNatGatewayAddressRequest,
            com.amazonaws.handlers.AsyncHandler<AssociateNatGatewayAddressRequest, AssociateNatGatewayAddressResult> asyncHandler);

    /**
     * <p>
     * Associates a subnet in your VPC or an internet gateway or virtual private gateway attached to your VPC with a
     * route table in your VPC. This association causes traffic from the subnet or gateway to be routed according to the
     * routes in the route table. The action returns an association ID, which you need in order to disassociate the
     * route table later. A route table can be associated with multiple subnets.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param associateRouteTableRequest
     * @return A Java Future containing the result of the AssociateRouteTable operation returned by the service.
     * @sample AmazonEC2Async.AssociateRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AssociateRouteTableResult> associateRouteTableAsync(AssociateRouteTableRequest associateRouteTableRequest);

    /**
     * <p>
     * Associates a subnet in your VPC or an internet gateway or virtual private gateway attached to your VPC with a
     * route table in your VPC. This association causes traffic from the subnet or gateway to be routed according to the
     * routes in the route table. The action returns an association ID, which you need in order to disassociate the
     * route table later. A route table can be associated with multiple subnets.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param associateRouteTableRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssociateRouteTable operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AssociateRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AssociateRouteTableResult> associateRouteTableAsync(AssociateRouteTableRequest associateRouteTableRequest,
            com.amazonaws.handlers.AsyncHandler<AssociateRouteTableRequest, AssociateRouteTableResult> asyncHandler);

    /**
     * <p>
     * Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR block with your subnet.
     * </p>
     * 
     * @param associateSubnetCidrBlockRequest
     * @return A Java Future containing the result of the AssociateSubnetCidrBlock operation returned by the service.
     * @sample AmazonEC2Async.AssociateSubnetCidrBlock
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlock" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<AssociateSubnetCidrBlockResult> associateSubnetCidrBlockAsync(AssociateSubnetCidrBlockRequest associateSubnetCidrBlockRequest);

    /**
     * <p>
     * Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR block with your subnet.
     * </p>
     * 
     * @param associateSubnetCidrBlockRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssociateSubnetCidrBlock operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AssociateSubnetCidrBlock
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlock" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<AssociateSubnetCidrBlockResult> associateSubnetCidrBlockAsync(AssociateSubnetCidrBlockRequest associateSubnetCidrBlockRequest,
            com.amazonaws.handlers.AsyncHandler<AssociateSubnetCidrBlockRequest, AssociateSubnetCidrBlockResult> asyncHandler);

    /**
     * <p>
     * Associates the specified subnets and transit gateway attachments with the specified transit gateway multicast
     * domain.
     * </p>
     * <p>
     * The transit gateway attachment must be in the available state before you can add a resource. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html"
     * >DescribeTransitGatewayAttachments</a> to see the state of the attachment.
     * </p>
     * 
     * @param associateTransitGatewayMulticastDomainRequest
     * @return A Java Future containing the result of the AssociateTransitGatewayMulticastDomain operation returned by
     *         the service.
     * @sample AmazonEC2Async.AssociateTransitGatewayMulticastDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssociateTransitGatewayMulticastDomainResult> associateTransitGatewayMulticastDomainAsync(
            AssociateTransitGatewayMulticastDomainRequest associateTransitGatewayMulticastDomainRequest);

    /**
     * <p>
     * Associates the specified subnets and transit gateway attachments with the specified transit gateway multicast
     * domain.
     * </p>
     * <p>
     * The transit gateway attachment must be in the available state before you can add a resource. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html"
     * >DescribeTransitGatewayAttachments</a> to see the state of the attachment.
     * </p>
     * 
     * @param associateTransitGatewayMulticastDomainRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssociateTransitGatewayMulticastDomain operation returned by
     *         the service.
     * @sample AmazonEC2AsyncHandler.AssociateTransitGatewayMulticastDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssociateTransitGatewayMulticastDomainResult> associateTransitGatewayMulticastDomainAsync(
            AssociateTransitGatewayMulticastDomainRequest associateTransitGatewayMulticastDomainRequest,
            com.amazonaws.handlers.AsyncHandler<AssociateTransitGatewayMulticastDomainRequest, AssociateTransitGatewayMulticastDomainResult> asyncHandler);

    /**
     * <p>
     * Associates the specified transit gateway attachment with a transit gateway policy table.
     * </p>
     * 
     * @param associateTransitGatewayPolicyTableRequest
     * @return A Java Future containing the result of the AssociateTransitGatewayPolicyTable operation returned by the
     *         service.
     * @sample AmazonEC2Async.AssociateTransitGatewayPolicyTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayPolicyTable"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssociateTransitGatewayPolicyTableResult> associateTransitGatewayPolicyTableAsync(
            AssociateTransitGatewayPolicyTableRequest associateTransitGatewayPolicyTableRequest);

    /**
     * <p>
     * Associates the specified transit gateway attachment with a transit gateway policy table.
     * </p>
     * 
     * @param associateTransitGatewayPolicyTableRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssociateTransitGatewayPolicyTable operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.AssociateTransitGatewayPolicyTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayPolicyTable"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssociateTransitGatewayPolicyTableResult> associateTransitGatewayPolicyTableAsync(
            AssociateTransitGatewayPolicyTableRequest associateTransitGatewayPolicyTableRequest,
            com.amazonaws.handlers.AsyncHandler<AssociateTransitGatewayPolicyTableRequest, AssociateTransitGatewayPolicyTableResult> asyncHandler);

    /**
     * <p>
     * Associates the specified attachment with the specified transit gateway route table. You can associate only one
     * route table with an attachment.
     * </p>
     * 
     * @param associateTransitGatewayRouteTableRequest
     * @return A Java Future containing the result of the AssociateTransitGatewayRouteTable operation returned by the
     *         service.
     * @sample AmazonEC2Async.AssociateTransitGatewayRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssociateTransitGatewayRouteTableResult> associateTransitGatewayRouteTableAsync(
            AssociateTransitGatewayRouteTableRequest associateTransitGatewayRouteTableRequest);

    /**
     * <p>
     * Associates the specified attachment with the specified transit gateway route table. You can associate only one
     * route table with an attachment.
     * </p>
     * 
     * @param associateTransitGatewayRouteTableRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssociateTransitGatewayRouteTable operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.AssociateTransitGatewayRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssociateTransitGatewayRouteTableResult> associateTransitGatewayRouteTableAsync(
            AssociateTransitGatewayRouteTableRequest associateTransitGatewayRouteTableRequest,
            com.amazonaws.handlers.AsyncHandler<AssociateTransitGatewayRouteTableRequest, AssociateTransitGatewayRouteTableResult> asyncHandler);

    /**
     * <p>
     * Associates a branch network interface with a trunk network interface.
     * </p>
     * <p>
     * Before you create the association, run the <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html"
     * >create-network-interface</a> command and set <code>--interface-type</code> to <code>trunk</code>. You must also
     * create a network interface for each branch network interface that you want to associate with the trunk network
     * interface.
     * </p>
     * 
     * @param associateTrunkInterfaceRequest
     * @return A Java Future containing the result of the AssociateTrunkInterface operation returned by the service.
     * @sample AmazonEC2Async.AssociateTrunkInterface
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTrunkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<AssociateTrunkInterfaceResult> associateTrunkInterfaceAsync(AssociateTrunkInterfaceRequest associateTrunkInterfaceRequest);

    /**
     * <p>
     * Associates a branch network interface with a trunk network interface.
     * </p>
     * <p>
     * Before you create the association, run the <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html"
     * >create-network-interface</a> command and set <code>--interface-type</code> to <code>trunk</code>. You must also
     * create a network interface for each branch network interface that you want to associate with the trunk network
     * interface.
     * </p>
     * 
     * @param associateTrunkInterfaceRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssociateTrunkInterface operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AssociateTrunkInterface
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTrunkInterface" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<AssociateTrunkInterfaceResult> associateTrunkInterfaceAsync(AssociateTrunkInterfaceRequest associateTrunkInterfaceRequest,
            com.amazonaws.handlers.AsyncHandler<AssociateTrunkInterfaceRequest, AssociateTrunkInterfaceResult> asyncHandler);

    /**
     * <p>
     * Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block, an Amazon-provided IPv6
     * CIDR block, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP
     * addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>).
     * </p>
     * <p>
     * You must specify one of the following in the request: an IPv4 CIDR block, an IPv6 pool, or an Amazon-provided
     * IPv6 CIDR block.
     * </p>
     * <p>
     * For more information about associating CIDR blocks with your VPC and applicable restrictions, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html">IP addressing for your VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param associateVpcCidrBlockRequest
     * @return A Java Future containing the result of the AssociateVpcCidrBlock operation returned by the service.
     * @sample AmazonEC2Async.AssociateVpcCidrBlock
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlock" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AssociateVpcCidrBlockResult> associateVpcCidrBlockAsync(AssociateVpcCidrBlockRequest associateVpcCidrBlockRequest);

    /**
     * <p>
     * Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block, an Amazon-provided IPv6
     * CIDR block, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP
     * addresses (<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>).
     * </p>
     * <p>
     * You must specify one of the following in the request: an IPv4 CIDR block, an IPv6 pool, or an Amazon-provided
     * IPv6 CIDR block.
     * </p>
     * <p>
     * For more information about associating CIDR blocks with your VPC and applicable restrictions, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html">IP addressing for your VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param associateVpcCidrBlockRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssociateVpcCidrBlock operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AssociateVpcCidrBlock
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlock" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AssociateVpcCidrBlockResult> associateVpcCidrBlockAsync(AssociateVpcCidrBlockRequest associateVpcCidrBlockRequest,
            com.amazonaws.handlers.AsyncHandler<AssociateVpcCidrBlockRequest, AssociateVpcCidrBlockResult> asyncHandler);

    /**
     * <note>
     * <p>
     * This action is deprecated.
     * </p>
     * </note>
     * <p>
     * Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC security groups. You
     * cannot link an EC2-Classic instance to more than one VPC at a time. You can only link an instance that's in the
     * <code>running</code> state. An instance is automatically unlinked from a VPC when it's stopped - you can link it
     * to the VPC again when you restart it.
     * </p>
     * <p>
     * After you've linked an instance, you cannot change the VPC security groups that are associated with it. To change
     * the security groups, you must first unlink the instance, and then link it again.
     * </p>
     * <p>
     * Linking your instance to a VPC is sometimes referred to as <i>attaching</i> your instance.
     * </p>
     * 
     * @param attachClassicLinkVpcRequest
     * @return A Java Future containing the result of the AttachClassicLinkVpc operation returned by the service.
     * @sample AmazonEC2Async.AttachClassicLinkVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AttachClassicLinkVpcResult> attachClassicLinkVpcAsync(AttachClassicLinkVpcRequest attachClassicLinkVpcRequest);

    /**
     * <note>
     * <p>
     * This action is deprecated.
     * </p>
     * </note>
     * <p>
     * Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC security groups. You
     * cannot link an EC2-Classic instance to more than one VPC at a time. You can only link an instance that's in the
     * <code>running</code> state. An instance is automatically unlinked from a VPC when it's stopped - you can link it
     * to the VPC again when you restart it.
     * </p>
     * <p>
     * After you've linked an instance, you cannot change the VPC security groups that are associated with it. To change
     * the security groups, you must first unlink the instance, and then link it again.
     * </p>
     * <p>
     * Linking your instance to a VPC is sometimes referred to as <i>attaching</i> your instance.
     * </p>
     * 
     * @param attachClassicLinkVpcRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AttachClassicLinkVpc operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AttachClassicLinkVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AttachClassicLinkVpcResult> attachClassicLinkVpcAsync(AttachClassicLinkVpcRequest attachClassicLinkVpcRequest,
            com.amazonaws.handlers.AsyncHandler<AttachClassicLinkVpcRequest, AttachClassicLinkVpcResult> asyncHandler);

    /**
     * <p>
     * Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity between the internet
     * and the VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html">Internet gateways</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param attachInternetGatewayRequest
     * @return A Java Future containing the result of the AttachInternetGateway operation returned by the service.
     * @sample AmazonEC2Async.AttachInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AttachInternetGatewayResult> attachInternetGatewayAsync(AttachInternetGatewayRequest attachInternetGatewayRequest);

    /**
     * <p>
     * Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity between the internet
     * and the VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html">Internet gateways</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param attachInternetGatewayRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AttachInternetGateway operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AttachInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AttachInternetGatewayResult> attachInternetGatewayAsync(AttachInternetGatewayRequest attachInternetGatewayRequest,
            com.amazonaws.handlers.AsyncHandler<AttachInternetGatewayRequest, AttachInternetGatewayResult> asyncHandler);

    /**
     * <p>
     * Attaches a network interface to an instance.
     * </p>
     * 
     * @param attachNetworkInterfaceRequest
     *        Contains the parameters for AttachNetworkInterface.
     * @return A Java Future containing the result of the AttachNetworkInterface operation returned by the service.
     * @sample AmazonEC2Async.AttachNetworkInterface
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterface" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AttachNetworkInterfaceResult> attachNetworkInterfaceAsync(AttachNetworkInterfaceRequest attachNetworkInterfaceRequest);

    /**
     * <p>
     * Attaches a network interface to an instance.
     * </p>
     * 
     * @param attachNetworkInterfaceRequest
     *        Contains the parameters for AttachNetworkInterface.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AttachNetworkInterface operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AttachNetworkInterface
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterface" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AttachNetworkInterfaceResult> attachNetworkInterfaceAsync(AttachNetworkInterfaceRequest attachNetworkInterfaceRequest,
            com.amazonaws.handlers.AsyncHandler<AttachNetworkInterfaceRequest, AttachNetworkInterfaceResult> asyncHandler);

    /**
     * <p>
     * Attaches the specified Amazon Web Services Verified Access trust provider to the specified Amazon Web Services
     * Verified Access instance.
     * </p>
     * 
     * @param attachVerifiedAccessTrustProviderRequest
     * @return A Java Future containing the result of the AttachVerifiedAccessTrustProvider operation returned by the
     *         service.
     * @sample AmazonEC2Async.AttachVerifiedAccessTrustProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVerifiedAccessTrustProvider"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AttachVerifiedAccessTrustProviderResult> attachVerifiedAccessTrustProviderAsync(
            AttachVerifiedAccessTrustProviderRequest attachVerifiedAccessTrustProviderRequest);

    /**
     * <p>
     * Attaches the specified Amazon Web Services Verified Access trust provider to the specified Amazon Web Services
     * Verified Access instance.
     * </p>
     * 
     * @param attachVerifiedAccessTrustProviderRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AttachVerifiedAccessTrustProvider operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.AttachVerifiedAccessTrustProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVerifiedAccessTrustProvider"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AttachVerifiedAccessTrustProviderResult> attachVerifiedAccessTrustProviderAsync(
            AttachVerifiedAccessTrustProviderRequest attachVerifiedAccessTrustProviderRequest,
            com.amazonaws.handlers.AsyncHandler<AttachVerifiedAccessTrustProviderRequest, AttachVerifiedAccessTrustProviderResult> asyncHandler);

    /**
     * <p>
     * Attaches an EBS volume to a running or stopped instance and exposes it to the instance with the specified device
     * name.
     * </p>
     * <p>
     * Encrypted EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see
     * <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in the
     * <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * After you attach an EBS volume, you must make it available. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-using-volumes.html">Make an EBS volume available for
     * use</a>.
     * </p>
     * <p>
     * If a volume has an Amazon Web Services Marketplace product code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The volume can be attached only to a stopped instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Marketplace product codes are copied from the volume to the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must be subscribed to the product.
     * </p>
     * </li>
     * <li>
     * <p>
     * The instance type and operating system of the instance must support the product. For example, you can't detach a
     * volume from a Windows instance and attach it to a Linux instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-attaching-volume.html">Attach an Amazon EBS volume to
     * an instance</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param attachVolumeRequest
     * @return A Java Future containing the result of the AttachVolume operation returned by the service.
     * @sample AmazonEC2Async.AttachVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolume" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AttachVolumeResult> attachVolumeAsync(AttachVolumeRequest attachVolumeRequest);

    /**
     * <p>
     * Attaches an EBS volume to a running or stopped instance and exposes it to the instance with the specified device
     * name.
     * </p>
     * <p>
     * Encrypted EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see
     * <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS encryption</a> in the
     * <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * After you attach an EBS volume, you must make it available. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-using-volumes.html">Make an EBS volume available for
     * use</a>.
     * </p>
     * <p>
     * If a volume has an Amazon Web Services Marketplace product code:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The volume can be attached only to a stopped instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Marketplace product codes are copied from the volume to the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must be subscribed to the product.
     * </p>
     * </li>
     * <li>
     * <p>
     * The instance type and operating system of the instance must support the product. For example, you can't detach a
     * volume from a Windows instance and attach it to a Linux instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-attaching-volume.html">Attach an Amazon EBS volume to
     * an instance</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param attachVolumeRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AttachVolume operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AttachVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolume" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AttachVolumeResult> attachVolumeAsync(AttachVolumeRequest attachVolumeRequest,
            com.amazonaws.handlers.AsyncHandler<AttachVolumeRequest, AttachVolumeResult> asyncHandler);

    /**
     * <p>
     * Attaches a virtual private gateway to a VPC. You can attach one virtual private gateway to one VPC at a time.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * 
     * @param attachVpnGatewayRequest
     *        Contains the parameters for AttachVpnGateway.
     * @return A Java Future containing the result of the AttachVpnGateway operation returned by the service.
     * @sample AmazonEC2Async.AttachVpnGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AttachVpnGatewayResult> attachVpnGatewayAsync(AttachVpnGatewayRequest attachVpnGatewayRequest);

    /**
     * <p>
     * Attaches a virtual private gateway to a VPC. You can attach one virtual private gateway to one VPC at a time.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * 
     * @param attachVpnGatewayRequest
     *        Contains the parameters for AttachVpnGateway.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AttachVpnGateway operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AttachVpnGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<AttachVpnGatewayResult> attachVpnGatewayAsync(AttachVpnGatewayRequest attachVpnGatewayRequest,
            com.amazonaws.handlers.AsyncHandler<AttachVpnGatewayRequest, AttachVpnGatewayResult> asyncHandler);

    /**
     * <p>
     * Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules act as firewall rules
     * that grant access to networks. You must configure ingress authorization rules to enable clients to access
     * resources in Amazon Web Services or on-premises networks.
     * </p>
     * 
     * @param authorizeClientVpnIngressRequest
     * @return A Java Future containing the result of the AuthorizeClientVpnIngress operation returned by the service.
     * @sample AmazonEC2Async.AuthorizeClientVpnIngress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngress" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<AuthorizeClientVpnIngressResult> authorizeClientVpnIngressAsync(
            AuthorizeClientVpnIngressRequest authorizeClientVpnIngressRequest);

    /**
     * <p>
     * Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules act as firewall rules
     * that grant access to networks. You must configure ingress authorization rules to enable clients to access
     * resources in Amazon Web Services or on-premises networks.
     * </p>
     * 
     * @param authorizeClientVpnIngressRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AuthorizeClientVpnIngress operation returned by the service.
     * @sample AmazonEC2AsyncHandler.AuthorizeClientVpnIngress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngress" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<AuthorizeClientVpnIngressResult> authorizeClientVpnIngressAsync(
            AuthorizeClientVpnIngressRequest authorizeClientVpnIngressRequest,
            com.amazonaws.handlers.AsyncHandler<AuthorizeClientVpnIngressRequest, AuthorizeClientVpnIngressResult> asyncHandler);

    /**
     * <p>
     * Adds the specified outbound (egress) rules to a security group.
     * </p>
     * <p>
     * An outbound rule permits instances to send traffic to the specified IPv4 or IPv6 address ranges, the IP address
     * ranges specified by a prefix list, or the instances that are associated with a source security group. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html">Security
     * group rules</a>.
     * </p>
     * <p>
     * You must specify exactly one of the following destinations: an IPv4 or IPv6 address range, a prefix list, or a
     * security group. You must specify a protocol for each rule (for example, TCP). If the protocol is TCP or UDP, you
     * must also specify a port or port range. If the protocol is ICMP or ICMPv6, you must also specify the ICMP type
     * and code.
     * </p>
     * <p>
     * Rule changes are propagated to instances associated with the security group as quickly as possible. However, a
     * small delay might occur.
     * </p>
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group
     * rules for different use cases</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For information about security group quotas, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param authorizeSecurityGroupEgressRequest
     * @return A Java Future containing the result of the AuthorizeSecurityGroupEgress operation returned by the
     *         service.
     * @sample AmazonEC2Async.AuthorizeSecurityGroupEgress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AuthorizeSecurityGroupEgressResult> authorizeSecurityGroupEgressAsync(
            AuthorizeSecurityGroupEgressRequest authorizeSecurityGroupEgressRequest);

    /**
     * <p>
     * Adds the specified outbound (egress) rules to a security group.
     * </p>
     * <p>
     * An outbound rule permits instances to send traffic to the specified IPv4 or IPv6 address ranges, the IP address
     * ranges specified by a prefix list, or the instances that are associated with a source security group. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html">Security
     * group rules</a>.
     * </p>
     * <p>
     * You must specify exactly one of the following destinations: an IPv4 or IPv6 address range, a prefix list, or a
     * security group. You must specify a protocol for each rule (for example, TCP). If the protocol is TCP or UDP, you
     * must also specify a port or port range. If the protocol is ICMP or ICMPv6, you must also specify the ICMP type
     * and code.
     * </p>
     * <p>
     * Rule changes are propagated to instances associated with the security group as quickly as possible. However, a
     * small delay might occur.
     * </p>
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group
     * rules for different use cases</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For information about security group quotas, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param authorizeSecurityGroupEgressRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AuthorizeSecurityGroupEgress operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.AuthorizeSecurityGroupEgress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AuthorizeSecurityGroupEgressResult> authorizeSecurityGroupEgressAsync(
            AuthorizeSecurityGroupEgressRequest authorizeSecurityGroupEgressRequest,
            com.amazonaws.handlers.AsyncHandler<AuthorizeSecurityGroupEgressRequest, AuthorizeSecurityGroupEgressResult> asyncHandler);

    /**
     * <p>
     * Adds the specified inbound (ingress) rules to a security group.
     * </p>
     * <p>
     * An inbound rule permits instances to receive traffic from the specified IPv4 or IPv6 address range, the IP
     * address ranges that are specified by a prefix list, or the instances that are associated with a destination
     * security group. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html">Security group rules</a>.
     * </p>
     * <p>
     * You must specify exactly one of the following sources: an IPv4 or IPv6 address range, a prefix list, or a
     * security group. You must specify a protocol for each rule (for example, TCP). If the protocol is TCP or UDP, you
     * must also specify a port or port range. If the protocol is ICMP or ICMPv6, you must also specify the ICMP/ICMPv6
     * type and code.
     * </p>
     * <p>
     * Rule changes are propagated to instances associated with the security group as quickly as possible. However, a
     * small delay might occur.
     * </p>
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group
     * rules for different use cases</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information about security group quotas, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param authorizeSecurityGroupIngressRequest
     * @return A Java Future containing the result of the AuthorizeSecurityGroupIngress operation returned by the
     *         service.
     * @sample AmazonEC2Async.AuthorizeSecurityGroupIngress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AuthorizeSecurityGroupIngressResult> authorizeSecurityGroupIngressAsync(
            AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest);

    /**
     * <p>
     * Adds the specified inbound (ingress) rules to a security group.
     * </p>
     * <p>
     * An inbound rule permits instances to receive traffic from the specified IPv4 or IPv6 address range, the IP
     * address ranges that are specified by a prefix list, or the instances that are associated with a destination
     * security group. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html">Security group rules</a>.
     * </p>
     * <p>
     * You must specify exactly one of the following sources: an IPv4 or IPv6 address range, a prefix list, or a
     * security group. You must specify a protocol for each rule (for example, TCP). If the protocol is TCP or UDP, you
     * must also specify a port or port range. If the protocol is ICMP or ICMPv6, you must also specify the ICMP/ICMPv6
     * type and code.
     * </p>
     * <p>
     * Rule changes are propagated to instances associated with the security group as quickly as possible. However, a
     * small delay might occur.
     * </p>
     * <p>
     * For examples of rules that you can add to security groups for specific access scenarios, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html">Security group
     * rules for different use cases</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information about security group quotas, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC quotas</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param authorizeSecurityGroupIngressRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AuthorizeSecurityGroupIngress operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.AuthorizeSecurityGroupIngress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AuthorizeSecurityGroupIngressResult> authorizeSecurityGroupIngressAsync(
            AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest,
            com.amazonaws.handlers.AsyncHandler<AuthorizeSecurityGroupIngressRequest, AuthorizeSecurityGroupIngressResult> asyncHandler);

    /**
     * <p>
     * Bundles an Amazon instance store-backed Windows instance.
     * </p>
     * <p>
     * During bundling, only the root device volume (C:\) is bundled. Data on other instance store volumes is not
     * preserved.
     * </p>
     * <note>
     * <p>
     * This action is not applicable for Linux/Unix instances or Windows instances that are backed by Amazon EBS.
     * </p>
     * </note>
     * 
     * @param bundleInstanceRequest
     *        Contains the parameters for BundleInstance.
     * @return A Java Future containing the result of the BundleInstance operation returned by the service.
     * @sample AmazonEC2Async.BundleInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<BundleInstanceResult> bundleInstanceAsync(BundleInstanceRequest bundleInstanceRequest);

    /**
     * <p>
     * Bundles an Amazon instance store-backed Windows instance.
     * </p>
     * <p>
     * During bundling, only the root device volume (C:\) is bundled. Data on other instance store volumes is not
     * preserved.
     * </p>
     * <note>
     * <p>
     * This action is not applicable for Linux/Unix instances or Windows instances that are backed by Amazon EBS.
     * </p>
     * </note>
     * 
     * @param bundleInstanceRequest
     *        Contains the parameters for BundleInstance.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the BundleInstance operation returned by the service.
     * @sample AmazonEC2AsyncHandler.BundleInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<BundleInstanceResult> bundleInstanceAsync(BundleInstanceRequest bundleInstanceRequest,
            com.amazonaws.handlers.AsyncHandler<BundleInstanceRequest, BundleInstanceResult> asyncHandler);

    /**
     * <p>
     * Cancels a bundling operation for an instance store-backed Windows instance.
     * </p>
     * 
     * @param cancelBundleTaskRequest
     *        Contains the parameters for CancelBundleTask.
     * @return A Java Future containing the result of the CancelBundleTask operation returned by the service.
     * @sample AmazonEC2Async.CancelBundleTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CancelBundleTaskResult> cancelBundleTaskAsync(CancelBundleTaskRequest cancelBundleTaskRequest);

    /**
     * <p>
     * Cancels a bundling operation for an instance store-backed Windows instance.
     * </p>
     * 
     * @param cancelBundleTaskRequest
     *        Contains the parameters for CancelBundleTask.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CancelBundleTask operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CancelBundleTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CancelBundleTaskResult> cancelBundleTaskAsync(CancelBundleTaskRequest cancelBundleTaskRequest,
            com.amazonaws.handlers.AsyncHandler<CancelBundleTaskRequest, CancelBundleTaskResult> asyncHandler);

    /**
     * <p>
     * Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the Capacity
     * Reservation's state to <code>cancelled</code>.
     * </p>
     * <p>
     * Instances running in the reserved capacity continue running until you stop them. Stopped instances that target
     * the Capacity Reservation can no longer launch. Modify these instances to either target a different Capacity
     * Reservation, launch On-Demand Instance capacity, or run in any open Capacity Reservation that has matching
     * attributes and sufficient capacity.
     * </p>
     * 
     * @param cancelCapacityReservationRequest
     * @return A Java Future containing the result of the CancelCapacityReservation operation returned by the service.
     * @sample AmazonEC2Async.CancelCapacityReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CancelCapacityReservationResult> cancelCapacityReservationAsync(
            CancelCapacityReservationRequest cancelCapacityReservationRequest);

    /**
     * <p>
     * Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the Capacity
     * Reservation's state to <code>cancelled</code>.
     * </p>
     * <p>
     * Instances running in the reserved capacity continue running until you stop them. Stopped instances that target
     * the Capacity Reservation can no longer launch. Modify these instances to either target a different Capacity
     * Reservation, launch On-Demand Instance capacity, or run in any open Capacity Reservation that has matching
     * attributes and sufficient capacity.
     * </p>
     * 
     * @param cancelCapacityReservationRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CancelCapacityReservation operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CancelCapacityReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CancelCapacityReservationResult> cancelCapacityReservationAsync(
            CancelCapacityReservationRequest cancelCapacityReservationRequest,
            com.amazonaws.handlers.AsyncHandler<CancelCapacityReservationRequest, CancelCapacityReservationResult> asyncHandler);

    /**
     * <p>
     * Cancels one or more Capacity Reservation Fleets. When you cancel a Capacity Reservation Fleet, the following
     * happens:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The Capacity Reservation Fleet's status changes to <code>cancelled</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The individual Capacity Reservations in the Fleet are cancelled. Instances running in the Capacity Reservations
     * at the time of cancelling the Fleet continue to run in shared capacity.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Fleet stops creating new Capacity Reservations.
     * </p>
     * </li>
     * </ul>
     * 
     * @param cancelCapacityReservationFleetsRequest
     * @return A Java Future containing the result of the CancelCapacityReservationFleets operation returned by the
     *         service.
     * @sample AmazonEC2Async.CancelCapacityReservationFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservationFleets"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CancelCapacityReservationFleetsResult> cancelCapacityReservationFleetsAsync(
            CancelCapacityReservationFleetsRequest cancelCapacityReservationFleetsRequest);

    /**
     * <p>
     * Cancels one or more Capacity Reservation Fleets. When you cancel a Capacity Reservation Fleet, the following
     * happens:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The Capacity Reservation Fleet's status changes to <code>cancelled</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The individual Capacity Reservations in the Fleet are cancelled. Instances running in the Capacity Reservations
     * at the time of cancelling the Fleet continue to run in shared capacity.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Fleet stops creating new Capacity Reservations.
     * </p>
     * </li>
     * </ul>
     * 
     * @param cancelCapacityReservationFleetsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CancelCapacityReservationFleets operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.CancelCapacityReservationFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservationFleets"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CancelCapacityReservationFleetsResult> cancelCapacityReservationFleetsAsync(
            CancelCapacityReservationFleetsRequest cancelCapacityReservationFleetsRequest,
            com.amazonaws.handlers.AsyncHandler<CancelCapacityReservationFleetsRequest, CancelCapacityReservationFleetsResult> asyncHandler);

    /**
     * <p>
     * Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all
     * artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or
     * is in the process of transferring the final disk image, the command fails and returns an exception.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html">Importing a
     * Virtual Machine Using the Amazon EC2 CLI</a>.
     * </p>
     * 
     * @param cancelConversionTaskRequest
     * @return A Java Future containing the result of the CancelConversionTask operation returned by the service.
     * @sample AmazonEC2Async.CancelConversionTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTask" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CancelConversionTaskResult> cancelConversionTaskAsync(CancelConversionTaskRequest cancelConversionTaskRequest);

    /**
     * <p>
     * Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all
     * artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or
     * is in the process of transferring the final disk image, the command fails and returns an exception.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html">Importing a
     * Virtual Machine Using the Amazon EC2 CLI</a>.
     * </p>
     * 
     * @param cancelConversionTaskRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CancelConversionTask operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CancelConversionTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTask" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CancelConversionTaskResult> cancelConversionTaskAsync(CancelConversionTaskRequest cancelConversionTaskRequest,
            com.amazonaws.handlers.AsyncHandler<CancelConversionTaskRequest, CancelConversionTaskResult> asyncHandler);

    /**
     * <p>
     * Cancels an active export task. The request removes all artifacts of the export, including any partially-created
     * Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the
     * command fails and returns an error.
     * </p>
     * 
     * @param cancelExportTaskRequest
     * @return A Java Future containing the result of the CancelExportTask operation returned by the service.
     * @sample AmazonEC2Async.CancelExportTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CancelExportTaskResult> cancelExportTaskAsync(CancelExportTaskRequest cancelExportTaskRequest);

    /**
     * <p>
     * Cancels an active export task. The request removes all artifacts of the export, including any partially-created
     * Amazon S3 objects. If the export task is complete or is in the process of transferring the final disk image, the
     * command fails and returns an error.
     * </p>
     * 
     * @param cancelExportTaskRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CancelExportTask operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CancelExportTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CancelExportTaskResult> cancelExportTaskAsync(CancelExportTaskRequest cancelExportTaskRequest,
            com.amazonaws.handlers.AsyncHandler<CancelExportTaskRequest, CancelExportTaskResult> asyncHandler);

    /**
     * <p>
     * Removes your Amazon Web Services account from the launch permissions for the specified AMI. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cancel-sharing-an-AMI.html"> Cancel having an
     * AMI shared with your Amazon Web Services account</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param cancelImageLaunchPermissionRequest
     * @return A Java Future containing the result of the CancelImageLaunchPermission operation returned by the service.
     * @sample AmazonEC2Async.CancelImageLaunchPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImageLaunchPermission"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CancelImageLaunchPermissionResult> cancelImageLaunchPermissionAsync(
            CancelImageLaunchPermissionRequest cancelImageLaunchPermissionRequest);

    /**
     * <p>
     * Removes your Amazon Web Services account from the launch permissions for the specified AMI. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cancel-sharing-an-AMI.html"> Cancel having an
     * AMI shared with your Amazon Web Services account</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param cancelImageLaunchPermissionRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CancelImageLaunchPermission operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CancelImageLaunchPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImageLaunchPermission"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CancelImageLaunchPermissionResult> cancelImageLaunchPermissionAsync(
            CancelImageLaunchPermissionRequest cancelImageLaunchPermissionRequest,
            com.amazonaws.handlers.AsyncHandler<CancelImageLaunchPermissionRequest, CancelImageLaunchPermissionResult> asyncHandler);

    /**
     * <p>
     * Cancels an in-process import virtual machine or import snapshot task.
     * </p>
     * 
     * @param cancelImportTaskRequest
     * @return A Java Future containing the result of the CancelImportTask operation returned by the service.
     * @sample AmazonEC2Async.CancelImportTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CancelImportTaskResult> cancelImportTaskAsync(CancelImportTaskRequest cancelImportTaskRequest);

    /**
     * <p>
     * Cancels an in-process import virtual machine or import snapshot task.
     * </p>
     * 
     * @param cancelImportTaskRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CancelImportTask operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CancelImportTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CancelImportTaskResult> cancelImportTaskAsync(CancelImportTaskRequest cancelImportTaskRequest,
            com.amazonaws.handlers.AsyncHandler<CancelImportTaskRequest, CancelImportTaskResult> asyncHandler);

    /**
     * Simplified method form for invoking the CancelImportTask operation.
     *
     * @see #cancelImportTaskAsync(CancelImportTaskRequest)
     */
    java.util.concurrent.Future<CancelImportTaskResult> cancelImportTaskAsync();

    /**
     * Simplified method form for invoking the CancelImportTask operation with an AsyncHandler.
     *
     * @see #cancelImportTaskAsync(CancelImportTaskRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<CancelImportTaskResult> cancelImportTaskAsync(
            com.amazonaws.handlers.AsyncHandler<CancelImportTaskRequest, CancelImportTaskResult> asyncHandler);

    /**
     * <p>
     * Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param cancelReservedInstancesListingRequest
     *        Contains the parameters for CancelReservedInstancesListing.
     * @return A Java Future containing the result of the CancelReservedInstancesListing operation returned by the
     *         service.
     * @sample AmazonEC2Async.CancelReservedInstancesListing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CancelReservedInstancesListingResult> cancelReservedInstancesListingAsync(
            CancelReservedInstancesListingRequest cancelReservedInstancesListingRequest);

    /**
     * <p>
     * Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param cancelReservedInstancesListingRequest
     *        Contains the parameters for CancelReservedInstancesListing.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CancelReservedInstancesListing operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.CancelReservedInstancesListing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CancelReservedInstancesListingResult> cancelReservedInstancesListingAsync(
            CancelReservedInstancesListingRequest cancelReservedInstancesListingRequest,
            com.amazonaws.handlers.AsyncHandler<CancelReservedInstancesListingRequest, CancelReservedInstancesListingResult> asyncHandler);

    /**
     * <p>
     * Cancels the specified Spot Fleet requests.
     * </p>
     * <p>
     * After you cancel a Spot Fleet request, the Spot Fleet launches no new instances.
     * </p>
     * <p>
     * You must also specify whether a canceled Spot Fleet request should terminate its instances. If you choose to
     * terminate the instances, the Spot Fleet request enters the <code>cancelled_terminating</code> state. Otherwise,
     * the Spot Fleet request enters the <code>cancelled_running</code> state and the instances continue to run until
     * they are interrupted or you terminate them manually.
     * </p>
     * <p class="title">
     * <b>Restrictions</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can delete up to 100 fleets in a single request. If you exceed the specified number, no fleets are deleted.
     * </p>
     * </li>
     * </ul>
     * 
     * @param cancelSpotFleetRequestsRequest
     *        Contains the parameters for CancelSpotFleetRequests.
     * @return A Java Future containing the result of the CancelSpotFleetRequests operation returned by the service.
     * @sample AmazonEC2Async.CancelSpotFleetRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequests" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CancelSpotFleetRequestsResult> cancelSpotFleetRequestsAsync(CancelSpotFleetRequestsRequest cancelSpotFleetRequestsRequest);

    /**
     * <p>
     * Cancels the specified Spot Fleet requests.
     * </p>
     * <p>
     * After you cancel a Spot Fleet request, the Spot Fleet launches no new instances.
     * </p>
     * <p>
     * You must also specify whether a canceled Spot Fleet request should terminate its instances. If you choose to
     * terminate the instances, the Spot Fleet request enters the <code>cancelled_terminating</code> state. Otherwise,
     * the Spot Fleet request enters the <code>cancelled_running</code> state and the instances continue to run until
     * they are interrupted or you terminate them manually.
     * </p>
     * <p class="title">
     * <b>Restrictions</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can delete up to 100 fleets in a single request. If you exceed the specified number, no fleets are deleted.
     * </p>
     * </li>
     * </ul>
     * 
     * @param cancelSpotFleetRequestsRequest
     *        Contains the parameters for CancelSpotFleetRequests.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CancelSpotFleetRequests operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CancelSpotFleetRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequests" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CancelSpotFleetRequestsResult> cancelSpotFleetRequestsAsync(CancelSpotFleetRequestsRequest cancelSpotFleetRequestsRequest,
            com.amazonaws.handlers.AsyncHandler<CancelSpotFleetRequestsRequest, CancelSpotFleetRequestsResult> asyncHandler);

    /**
     * <p>
     * Cancels one or more Spot Instance requests.
     * </p>
     * <important>
     * <p>
     * Canceling a Spot Instance request does not terminate running Spot Instances associated with the request.
     * </p>
     * </important>
     * 
     * @param cancelSpotInstanceRequestsRequest
     *        Contains the parameters for CancelSpotInstanceRequests.
     * @return A Java Future containing the result of the CancelSpotInstanceRequests operation returned by the service.
     * @sample AmazonEC2Async.CancelSpotInstanceRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequests" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CancelSpotInstanceRequestsResult> cancelSpotInstanceRequestsAsync(
            CancelSpotInstanceRequestsRequest cancelSpotInstanceRequestsRequest);

    /**
     * <p>
     * Cancels one or more Spot Instance requests.
     * </p>
     * <important>
     * <p>
     * Canceling a Spot Instance request does not terminate running Spot Instances associated with the request.
     * </p>
     * </important>
     * 
     * @param cancelSpotInstanceRequestsRequest
     *        Contains the parameters for CancelSpotInstanceRequests.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CancelSpotInstanceRequests operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CancelSpotInstanceRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequests" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CancelSpotInstanceRequestsResult> cancelSpotInstanceRequestsAsync(
            CancelSpotInstanceRequestsRequest cancelSpotInstanceRequestsRequest,
            com.amazonaws.handlers.AsyncHandler<CancelSpotInstanceRequestsRequest, CancelSpotInstanceRequestsResult> asyncHandler);

    /**
     * <p>
     * Determines whether a product code is associated with an instance. This action can only be used by the owner of
     * the product code. It is useful when a product code owner must verify whether another user's instance is eligible
     * for support.
     * </p>
     * 
     * @param confirmProductInstanceRequest
     * @return A Java Future containing the result of the ConfirmProductInstance operation returned by the service.
     * @sample AmazonEC2Async.ConfirmProductInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstance" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<ConfirmProductInstanceResult> confirmProductInstanceAsync(ConfirmProductInstanceRequest confirmProductInstanceRequest);

    /**
     * <p>
     * Determines whether a product code is associated with an instance. This action can only be used by the owner of
     * the product code. It is useful when a product code owner must verify whether another user's instance is eligible
     * for support.
     * </p>
     * 
     * @param confirmProductInstanceRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the ConfirmProductInstance operation returned by the service.
     * @sample AmazonEC2AsyncHandler.ConfirmProductInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstance" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<ConfirmProductInstanceResult> confirmProductInstanceAsync(ConfirmProductInstanceRequest confirmProductInstanceRequest,
            com.amazonaws.handlers.AsyncHandler<ConfirmProductInstanceRequest, ConfirmProductInstanceResult> asyncHandler);

    /**
     * <p>
     * Copies the specified Amazon FPGA Image (AFI) to the current Region.
     * </p>
     * 
     * @param copyFpgaImageRequest
     * @return A Java Future containing the result of the CopyFpgaImage operation returned by the service.
     * @sample AmazonEC2Async.CopyFpgaImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CopyFpgaImageResult> copyFpgaImageAsync(CopyFpgaImageRequest copyFpgaImageRequest);

    /**
     * <p>
     * Copies the specified Amazon FPGA Image (AFI) to the current Region.
     * </p>
     * 
     * @param copyFpgaImageRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CopyFpgaImage operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CopyFpgaImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CopyFpgaImageResult> copyFpgaImageAsync(CopyFpgaImageRequest copyFpgaImageRequest,
            com.amazonaws.handlers.AsyncHandler<CopyFpgaImageRequest, CopyFpgaImageResult> asyncHandler);

    /**
     * <p>
     * Initiates the copy of an AMI. You can copy an AMI from one Region to another, or from a Region to an Outpost. You
     * can't copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost. To copy
     * an AMI to another partition, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html"
     * >CreateStoreImageTask</a>.
     * </p>
     * <p>
     * To copy an AMI from one Region to another, specify the source Region using the <b>SourceRegion</b> parameter, and
     * specify the destination Region using its endpoint. Copies of encrypted backing snapshots for the AMI are
     * encrypted. Copies of unencrypted backing snapshots remain unencrypted, unless you set <code>Encrypted</code>
     * during the copy operation. You cannot create an unencrypted copy of an encrypted backing snapshot.
     * </p>
     * <p>
     * To copy an AMI from a Region to an Outpost, specify the source Region using the <b>SourceRegion</b> parameter,
     * and specify the ARN of the destination Outpost using <b>DestinationOutpostArn</b>. Backing snapshots copied to an
     * Outpost are encrypted by default using the default encryption key for the Region, or a different key that you
     * specify in the request using <b>KmsKeyId</b>. Outposts do not support unencrypted snapshots. For more
     * information, <a href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#ami"> Amazon EBS
     * local snapshots on Outposts</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * For more information about the prerequisites and limits when copying an AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html">Copy an AMI</a> in the <i>Amazon EC2
     * User Guide</i>.
     * </p>
     * 
     * @param copyImageRequest
     *        Contains the parameters for CopyImage.
     * @return A Java Future containing the result of the CopyImage operation returned by the service.
     * @sample AmazonEC2Async.CopyImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImage" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CopyImageResult> copyImageAsync(CopyImageRequest copyImageRequest);

    /**
     * <p>
     * Initiates the copy of an AMI. You can copy an AMI from one Region to another, or from a Region to an Outpost. You
     * can't copy an AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost. To copy
     * an AMI to another partition, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html"
     * >CreateStoreImageTask</a>.
     * </p>
     * <p>
     * To copy an AMI from one Region to another, specify the source Region using the <b>SourceRegion</b> parameter, and
     * specify the destination Region using its endpoint. Copies of encrypted backing snapshots for the AMI are
     * encrypted. Copies of unencrypted backing snapshots remain unencrypted, unless you set <code>Encrypted</code>
     * during the copy operation. You cannot create an unencrypted copy of an encrypted backing snapshot.
     * </p>
     * <p>
     * To copy an AMI from a Region to an Outpost, specify the source Region using the <b>SourceRegion</b> parameter,
     * and specify the ARN of the destination Outpost using <b>DestinationOutpostArn</b>. Backing snapshots copied to an
     * Outpost are encrypted by default using the default encryption key for the Region, or a different key that you
     * specify in the request using <b>KmsKeyId</b>. Outposts do not support unencrypted snapshots. For more
     * information, <a href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#ami"> Amazon EBS
     * local snapshots on Outposts</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * For more information about the prerequisites and limits when copying an AMI, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html">Copy an AMI</a> in the <i>Amazon EC2
     * User Guide</i>.
     * </p>
     * 
     * @param copyImageRequest
     *        Contains the parameters for CopyImage.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CopyImage operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CopyImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImage" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CopyImageResult> copyImageAsync(CopyImageRequest copyImageRequest,
            com.amazonaws.handlers.AsyncHandler<CopyImageRequest, CopyImageResult> asyncHandler);

    /**
     * <p>
     * Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy a snapshot within the
     * same Region, from one Region to another, or from a Region to an Outpost. You can't copy a snapshot from an
     * Outpost to a Region, from one Outpost to another, or within the same Outpost.
     * </p>
     * <p>
     * You can use the snapshot to create EBS volumes or Amazon Machine Images (AMIs).
     * </p>
     * <p>
     * When copying snapshots to a Region, copies of encrypted EBS snapshots remain encrypted. Copies of unencrypted
     * snapshots remain unencrypted, unless you enable encryption for the snapshot copy operation. By default, encrypted
     * snapshot copies use the default Key Management Service (KMS) KMS key; however, you can specify a different KMS
     * key. To copy an encrypted snapshot that has been shared from another account, you must have permissions for the
     * KMS key used to encrypt the snapshot.
     * </p>
     * <p>
     * Snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region, or a
     * different key that you specify in the request using <b>KmsKeyId</b>. Outposts do not support unencrypted
     * snapshots. For more information, <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#ami"> Amazon EBS local snapshots
     * on Outposts</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * Snapshots created by copying another snapshot have an arbitrary volume ID that should not be used for any
     * purpose.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-copy-snapshot.html">Copy
     * an Amazon EBS snapshot</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param copySnapshotRequest
     * @return A Java Future containing the result of the CopySnapshot operation returned by the service.
     * @sample AmazonEC2Async.CopySnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CopySnapshotResult> copySnapshotAsync(CopySnapshotRequest copySnapshotRequest);

    /**
     * <p>
     * Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy a snapshot within the
     * same Region, from one Region to another, or from a Region to an Outpost. You can't copy a snapshot from an
     * Outpost to a Region, from one Outpost to another, or within the same Outpost.
     * </p>
     * <p>
     * You can use the snapshot to create EBS volumes or Amazon Machine Images (AMIs).
     * </p>
     * <p>
     * When copying snapshots to a Region, copies of encrypted EBS snapshots remain encrypted. Copies of unencrypted
     * snapshots remain unencrypted, unless you enable encryption for the snapshot copy operation. By default, encrypted
     * snapshot copies use the default Key Management Service (KMS) KMS key; however, you can specify a different KMS
     * key. To copy an encrypted snapshot that has been shared from another account, you must have permissions for the
     * KMS key used to encrypt the snapshot.
     * </p>
     * <p>
     * Snapshots copied to an Outpost are encrypted by default using the default encryption key for the Region, or a
     * different key that you specify in the request using <b>KmsKeyId</b>. Outposts do not support unencrypted
     * snapshots. For more information, <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#ami"> Amazon EBS local snapshots
     * on Outposts</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * Snapshots created by copying another snapshot have an arbitrary volume ID that should not be used for any
     * purpose.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-copy-snapshot.html">Copy
     * an Amazon EBS snapshot</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param copySnapshotRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CopySnapshot operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CopySnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CopySnapshotResult> copySnapshotAsync(CopySnapshotRequest copySnapshotRequest,
            com.amazonaws.handlers.AsyncHandler<CopySnapshotRequest, CopySnapshotResult> asyncHandler);

    /**
     * <p>
     * Creates a new Capacity Reservation with the specified attributes.
     * </p>
     * <p>
     * Capacity Reservations enable you to reserve capacity for your Amazon EC2 instances in a specific Availability
     * Zone for any duration. This gives you the flexibility to selectively add capacity reservations and still get the
     * Regional RI discounts for that usage. By creating Capacity Reservations, you ensure that you always have access
     * to Amazon EC2 capacity when you need it, for as long as you need it. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">Capacity
     * Reservations</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * Your request to create a Capacity Reservation could fail if Amazon EC2 does not have sufficient capacity to
     * fulfill the request. If your request fails due to Amazon EC2 capacity constraints, either try again at a later
     * time, try in a different Availability Zone, or request a smaller capacity reservation. If your application is
     * flexible across instance types and sizes, try to create a Capacity Reservation with different instance
     * attributes.
     * </p>
     * <p>
     * Your request could also fail if the requested quantity exceeds your On-Demand Instance limit for the selected
     * instance type. If your request fails due to limit constraints, increase your On-Demand Instance limit for the
     * required instance type and try again. For more information about increasing your instance limits, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 Service Quotas</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param createCapacityReservationRequest
     * @return A Java Future containing the result of the CreateCapacityReservation operation returned by the service.
     * @sample AmazonEC2Async.CreateCapacityReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateCapacityReservationResult> createCapacityReservationAsync(
            CreateCapacityReservationRequest createCapacityReservationRequest);

    /**
     * <p>
     * Creates a new Capacity Reservation with the specified attributes.
     * </p>
     * <p>
     * Capacity Reservations enable you to reserve capacity for your Amazon EC2 instances in a specific Availability
     * Zone for any duration. This gives you the flexibility to selectively add capacity reservations and still get the
     * Regional RI discounts for that usage. By creating Capacity Reservations, you ensure that you always have access
     * to Amazon EC2 capacity when you need it, for as long as you need it. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html">Capacity
     * Reservations</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * Your request to create a Capacity Reservation could fail if Amazon EC2 does not have sufficient capacity to
     * fulfill the request. If your request fails due to Amazon EC2 capacity constraints, either try again at a later
     * time, try in a different Availability Zone, or request a smaller capacity reservation. If your application is
     * flexible across instance types and sizes, try to create a Capacity Reservation with different instance
     * attributes.
     * </p>
     * <p>
     * Your request could also fail if the requested quantity exceeds your On-Demand Instance limit for the selected
     * instance type. If your request fails due to limit constraints, increase your On-Demand Instance limit for the
     * required instance type and try again. For more information about increasing your instance limits, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 Service Quotas</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param createCapacityReservationRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateCapacityReservation operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateCapacityReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservation" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateCapacityReservationResult> createCapacityReservationAsync(
            CreateCapacityReservationRequest createCapacityReservationRequest,
            com.amazonaws.handlers.AsyncHandler<CreateCapacityReservationRequest, CreateCapacityReservationResult> asyncHandler);

    /**
     * <p>
     * Creates a Capacity Reservation Fleet. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-cr-fleets.html#create-crfleet">Create a
     * Capacity Reservation Fleet</a> in the Amazon EC2 User Guide.
     * </p>
     * 
     * @param createCapacityReservationFleetRequest
     * @return A Java Future containing the result of the CreateCapacityReservationFleet operation returned by the
     *         service.
     * @sample AmazonEC2Async.CreateCapacityReservationFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationFleet"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateCapacityReservationFleetResult> createCapacityReservationFleetAsync(
            CreateCapacityReservationFleetRequest createCapacityReservationFleetRequest);

    /**
     * <p>
     * Creates a Capacity Reservation Fleet. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-cr-fleets.html#create-crfleet">Create a
     * Capacity Reservation Fleet</a> in the Amazon EC2 User Guide.
     * </p>
     * 
     * @param createCapacityReservationFleetRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateCapacityReservationFleet operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.CreateCapacityReservationFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationFleet"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateCapacityReservationFleetResult> createCapacityReservationFleetAsync(
            CreateCapacityReservationFleetRequest createCapacityReservationFleetRequest,
            com.amazonaws.handlers.AsyncHandler<CreateCapacityReservationFleetRequest, CreateCapacityReservationFleetResult> asyncHandler);

    /**
     * <p>
     * Creates a carrier gateway. For more information about carrier gateways, see <a href=
     * "https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway"
     * >Carrier gateways</a> in the <i>Amazon Web Services Wavelength Developer Guide</i>.
     * </p>
     * 
     * @param createCarrierGatewayRequest
     * @return A Java Future containing the result of the CreateCarrierGateway operation returned by the service.
     * @sample AmazonEC2Async.CreateCarrierGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCarrierGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateCarrierGatewayResult> createCarrierGatewayAsync(CreateCarrierGatewayRequest createCarrierGatewayRequest);

    /**
     * <p>
     * Creates a carrier gateway. For more information about carrier gateways, see <a href=
     * "https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway"
     * >Carrier gateways</a> in the <i>Amazon Web Services Wavelength Developer Guide</i>.
     * </p>
     * 
     * @param createCarrierGatewayRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateCarrierGateway operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateCarrierGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCarrierGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateCarrierGatewayResult> createCarrierGatewayAsync(CreateCarrierGatewayRequest createCarrierGatewayRequest,
            com.amazonaws.handlers.AsyncHandler<CreateCarrierGatewayRequest, CreateCarrierGatewayResult> asyncHandler);

    /**
     * <p>
     * Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to enable and
     * manage client VPN sessions. It is the destination endpoint at which all client VPN sessions are terminated.
     * </p>
     * 
     * @param createClientVpnEndpointRequest
     * @return A Java Future containing the result of the CreateClientVpnEndpoint operation returned by the service.
     * @sample AmazonEC2Async.CreateClientVpnEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateClientVpnEndpointResult> createClientVpnEndpointAsync(CreateClientVpnEndpointRequest createClientVpnEndpointRequest);

    /**
     * <p>
     * Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and configure to enable and
     * manage client VPN sessions. It is the destination endpoint at which all client VPN sessions are terminated.
     * </p>
     * 
     * @param createClientVpnEndpointRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateClientVpnEndpoint operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateClientVpnEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateClientVpnEndpointResult> createClientVpnEndpointAsync(CreateClientVpnEndpointRequest createClientVpnEndpointRequest,
            com.amazonaws.handlers.AsyncHandler<CreateClientVpnEndpointRequest, CreateClientVpnEndpointResult> asyncHandler);

    /**
     * <p>
     * Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route table that describes the
     * available destination network routes. Each route in the route table specifies the path for traﬃc to speciﬁc
     * resources or networks.
     * </p>
     * 
     * @param createClientVpnRouteRequest
     * @return A Java Future containing the result of the CreateClientVpnRoute operation returned by the service.
     * @sample AmazonEC2Async.CreateClientVpnRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRoute" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateClientVpnRouteResult> createClientVpnRouteAsync(CreateClientVpnRouteRequest createClientVpnRouteRequest);

    /**
     * <p>
     * Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route table that describes the
     * available destination network routes. Each route in the route table specifies the path for traﬃc to speciﬁc
     * resources or networks.
     * </p>
     * 
     * @param createClientVpnRouteRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateClientVpnRoute operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateClientVpnRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRoute" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateClientVpnRouteResult> createClientVpnRouteAsync(CreateClientVpnRouteRequest createClientVpnRouteRequest,
            com.amazonaws.handlers.AsyncHandler<CreateClientVpnRouteRequest, CreateClientVpnRouteResult> asyncHandler);

    /**
     * <p>
     * Creates a range of customer-owned IP addresses.
     * </p>
     * 
     * @param createCoipCidrRequest
     * @return A Java Future containing the result of the CreateCoipCidr operation returned by the service.
     * @sample AmazonEC2Async.CreateCoipCidr
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateCoipCidrResult> createCoipCidrAsync(CreateCoipCidrRequest createCoipCidrRequest);

    /**
     * <p>
     * Creates a range of customer-owned IP addresses.
     * </p>
     * 
     * @param createCoipCidrRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateCoipCidr operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateCoipCidr
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateCoipCidrResult> createCoipCidrAsync(CreateCoipCidrRequest createCoipCidrRequest,
            com.amazonaws.handlers.AsyncHandler<CreateCoipCidrRequest, CreateCoipCidrResult> asyncHandler);

    /**
     * <p>
     * Creates a pool of customer-owned IP (CoIP) addresses.
     * </p>
     * 
     * @param createCoipPoolRequest
     * @return A Java Future containing the result of the CreateCoipPool operation returned by the service.
     * @sample AmazonEC2Async.CreateCoipPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipPool" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateCoipPoolResult> createCoipPoolAsync(CreateCoipPoolRequest createCoipPoolRequest);

    /**
     * <p>
     * Creates a pool of customer-owned IP (CoIP) addresses.
     * </p>
     * 
     * @param createCoipPoolRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateCoipPool operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateCoipPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipPool" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateCoipPoolResult> createCoipPoolAsync(CreateCoipPoolRequest createCoipPoolRequest,
            com.amazonaws.handlers.AsyncHandler<CreateCoipPoolRequest, CreateCoipPoolResult> asyncHandler);

    /**
     * <p>
     * Provides information to Amazon Web Services about your customer gateway device. The customer gateway device is
     * the appliance at your end of the VPN connection. You must provide the IP address of the customer gateway device’s
     * external interface. The IP address must be static and can be behind a device performing network address
     * translation (NAT).
     * </p>
     * <p>
     * For devices that use Border Gateway Protocol (BGP), you can also provide the device's BGP Autonomous System
     * Number (ASN). You can use an existing ASN assigned to your network. If you don't have an ASN already, you can use
     * a private ASN. For more information, see <a
     * href="https://docs.aws.amazon.com/vpn/latest/s2svpn/cgw-options.html">Customer gateway options for your
     * Site-to-Site VPN connection</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * <p>
     * To create more than one customer gateway with the same VPN type, IP address, and BGP ASN, specify a unique device
     * name for each customer gateway. An identical request returns information about the existing customer gateway; it
     * doesn't create a new customer gateway.
     * </p>
     * 
     * @param createCustomerGatewayRequest
     *        Contains the parameters for CreateCustomerGateway.
     * @return A Java Future containing the result of the CreateCustomerGateway operation returned by the service.
     * @sample AmazonEC2Async.CreateCustomerGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateCustomerGatewayResult> createCustomerGatewayAsync(CreateCustomerGatewayRequest createCustomerGatewayRequest);

    /**
     * <p>
     * Provides information to Amazon Web Services about your customer gateway device. The customer gateway device is
     * the appliance at your end of the VPN connection. You must provide the IP address of the customer gateway device’s
     * external interface. The IP address must be static and can be behind a device performing network address
     * translation (NAT).
     * </p>
     * <p>
     * For devices that use Border Gateway Protocol (BGP), you can also provide the device's BGP Autonomous System
     * Number (ASN). You can use an existing ASN assigned to your network. If you don't have an ASN already, you can use
     * a private ASN. For more information, see <a
     * href="https://docs.aws.amazon.com/vpn/latest/s2svpn/cgw-options.html">Customer gateway options for your
     * Site-to-Site VPN connection</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * <p>
     * To create more than one customer gateway with the same VPN type, IP address, and BGP ASN, specify a unique device
     * name for each customer gateway. An identical request returns information about the existing customer gateway; it
     * doesn't create a new customer gateway.
     * </p>
     * 
     * @param createCustomerGatewayRequest
     *        Contains the parameters for CreateCustomerGateway.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateCustomerGateway operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateCustomerGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateCustomerGatewayResult> createCustomerGatewayAsync(CreateCustomerGatewayRequest createCustomerGatewayRequest,
            com.amazonaws.handlers.AsyncHandler<CreateCustomerGatewayRequest, CreateCustomerGatewayResult> asyncHandler);

    /**
     * <p>
     * Creates a default subnet with a size <code>/20</code> IPv4 CIDR block in the specified Availability Zone in your
     * default VPC. You can have only one default subnet per Availability Zone. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet">Create a default
     * subnet</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param createDefaultSubnetRequest
     * @return A Java Future containing the result of the CreateDefaultSubnet operation returned by the service.
     * @sample AmazonEC2Async.CreateDefaultSubnet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateDefaultSubnetResult> createDefaultSubnetAsync(CreateDefaultSubnetRequest createDefaultSubnetRequest);

    /**
     * <p>
     * Creates a default subnet with a size <code>/20</code> IPv4 CIDR block in the specified Availability Zone in your
     * default VPC. You can have only one default subnet per Availability Zone. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet">Create a default
     * subnet</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param createDefaultSubnetRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateDefaultSubnet operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateDefaultSubnet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateDefaultSubnetResult> createDefaultSubnetAsync(CreateDefaultSubnetRequest createDefaultSubnetRequest,
            com.amazonaws.handlers.AsyncHandler<CreateDefaultSubnetRequest, CreateDefaultSubnetResult> asyncHandler);

    /**
     * <p>
     * Creates a default VPC with a size <code>/16</code> IPv4 CIDR block and a default subnet in each Availability
     * Zone. For more information about the components of a default VPC, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html">Default VPCs</a> in the <i>Amazon VPC
     * User Guide</i>. You cannot specify the components of the default VPC yourself.
     * </p>
     * <p>
     * If you deleted your previous default VPC, you can create a default VPC. You cannot have more than one default VPC
     * per Region.
     * </p>
     * 
     * @param createDefaultVpcRequest
     * @return A Java Future containing the result of the CreateDefaultVpc operation returned by the service.
     * @sample AmazonEC2Async.CreateDefaultVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpc" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateDefaultVpcResult> createDefaultVpcAsync(CreateDefaultVpcRequest createDefaultVpcRequest);

    /**
     * <p>
     * Creates a default VPC with a size <code>/16</code> IPv4 CIDR block and a default subnet in each Availability
     * Zone. For more information about the components of a default VPC, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html">Default VPCs</a> in the <i>Amazon VPC
     * User Guide</i>. You cannot specify the components of the default VPC yourself.
     * </p>
     * <p>
     * If you deleted your previous default VPC, you can create a default VPC. You cannot have more than one default VPC
     * per Region.
     * </p>
     * 
     * @param createDefaultVpcRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateDefaultVpc operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateDefaultVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpc" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateDefaultVpcResult> createDefaultVpcAsync(CreateDefaultVpcRequest createDefaultVpcRequest,
            com.amazonaws.handlers.AsyncHandler<CreateDefaultVpcRequest, CreateDefaultVpcResult> asyncHandler);

    /**
     * <p>
     * Creates a custom set of DHCP options. After you create a DHCP option set, you associate it with a VPC. After you
     * associate a DHCP option set with a VPC, all existing and newly launched instances in the VPC use this set of DHCP
     * options.
     * </p>
     * <p>
     * The following are the individual DHCP options you can specify. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>domain-name</code> - If you're using AmazonProvidedDNS in <code>us-east-1</code>, specify
     * <code>ec2.internal</code>. If you're using AmazonProvidedDNS in any other Region, specify
     * <code>region.compute.internal</code>. Otherwise, specify a custom domain name. This value is used to complete
     * unqualified DNS hostnames.
     * </p>
     * <p>
     * Some Linux operating systems accept multiple domain names separated by spaces. However, Windows and other Linux
     * operating systems treat the value as a single domain, which results in unexpected behavior. If your DHCP option
     * set is associated with a VPC that has instances running operating systems that treat the value as a single
     * domain, specify only one domain name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>domain-name-servers</code> - The IP addresses of up to four DNS servers, or AmazonProvidedDNS. To specify
     * multiple domain name servers in a single parameter, separate the IP addresses using commas. To have your
     * instances receive custom DNS hostnames as specified in <code>domain-name</code>, you must specify a custom DNS
     * server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ntp-servers</code> - The IP addresses of up to eight Network Time Protocol (NTP) servers (four IPv4
     * addresses and four IPv6 addresses).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-name-servers</code> - The IP addresses of up to four NetBIOS name servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-node-type</code> - The NetBIOS node type (1, 2, 4, or 8). We recommend that you specify 2.
     * Broadcast and multicast are not supported. For more information about NetBIOS node types, see <a
     * href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-address-preferred-lease-time</code> - A value (in seconds, minutes, hours, or years) for how
     * frequently a running instance with an IPv6 assigned to it goes through DHCPv6 lease renewal. Acceptable values
     * are between 140 and 2147483647 seconds (approximately 68 years). If no value is entered, the default lease time
     * is 140 seconds. If you use long-term addressing for EC2 instances, you can increase the lease time and avoid
     * frequent lease renewal requests. Lease renewal typically occurs when half of the lease time has elapsed.
     * </p>
     * </li>
     * </ul>
     * 
     * @param createDhcpOptionsRequest
     * @return A Java Future containing the result of the CreateDhcpOptions operation returned by the service.
     * @sample AmazonEC2Async.CreateDhcpOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateDhcpOptionsResult> createDhcpOptionsAsync(CreateDhcpOptionsRequest createDhcpOptionsRequest);

    /**
     * <p>
     * Creates a custom set of DHCP options. After you create a DHCP option set, you associate it with a VPC. After you
     * associate a DHCP option set with a VPC, all existing and newly launched instances in the VPC use this set of DHCP
     * options.
     * </p>
     * <p>
     * The following are the individual DHCP options you can specify. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP options sets</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>domain-name</code> - If you're using AmazonProvidedDNS in <code>us-east-1</code>, specify
     * <code>ec2.internal</code>. If you're using AmazonProvidedDNS in any other Region, specify
     * <code>region.compute.internal</code>. Otherwise, specify a custom domain name. This value is used to complete
     * unqualified DNS hostnames.
     * </p>
     * <p>
     * Some Linux operating systems accept multiple domain names separated by spaces. However, Windows and other Linux
     * operating systems treat the value as a single domain, which results in unexpected behavior. If your DHCP option
     * set is associated with a VPC that has instances running operating systems that treat the value as a single
     * domain, specify only one domain name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>domain-name-servers</code> - The IP addresses of up to four DNS servers, or AmazonProvidedDNS. To specify
     * multiple domain name servers in a single parameter, separate the IP addresses using commas. To have your
     * instances receive custom DNS hostnames as specified in <code>domain-name</code>, you must specify a custom DNS
     * server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ntp-servers</code> - The IP addresses of up to eight Network Time Protocol (NTP) servers (four IPv4
     * addresses and four IPv6 addresses).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-name-servers</code> - The IP addresses of up to four NetBIOS name servers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>netbios-node-type</code> - The NetBIOS node type (1, 2, 4, or 8). We recommend that you specify 2.
     * Broadcast and multicast are not supported. For more information about NetBIOS node types, see <a
     * href="http://www.ietf.org/rfc/rfc2132.txt">RFC 2132</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-address-preferred-lease-time</code> - A value (in seconds, minutes, hours, or years) for how
     * frequently a running instance with an IPv6 assigned to it goes through DHCPv6 lease renewal. Acceptable values
     * are between 140 and 2147483647 seconds (approximately 68 years). If no value is entered, the default lease time
     * is 140 seconds. If you use long-term addressing for EC2 instances, you can increase the lease time and avoid
     * frequent lease renewal requests. Lease renewal typically occurs when half of the lease time has elapsed.
     * </p>
     * </li>
     * </ul>
     * 
     * @param createDhcpOptionsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateDhcpOptions operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateDhcpOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateDhcpOptionsResult> createDhcpOptionsAsync(CreateDhcpOptionsRequest createDhcpOptionsRequest,
            com.amazonaws.handlers.AsyncHandler<CreateDhcpOptionsRequest, CreateDhcpOptionsResult> asyncHandler);

    /**
     * <p>
     * [IPv6 only] Creates an egress-only internet gateway for your VPC. An egress-only internet gateway is used to
     * enable outbound communication over IPv6 from instances in your VPC to the internet, and prevents hosts outside of
     * your VPC from initiating an IPv6 connection with your instance.
     * </p>
     * 
     * @param createEgressOnlyInternetGatewayRequest
     * @return A Java Future containing the result of the CreateEgressOnlyInternetGateway operation returned by the
     *         service.
     * @sample AmazonEC2Async.CreateEgressOnlyInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateEgressOnlyInternetGatewayResult> createEgressOnlyInternetGatewayAsync(
            CreateEgressOnlyInternetGatewayRequest createEgressOnlyInternetGatewayRequest);

    /**
     * <p>
     * [IPv6 only] Creates an egress-only internet gateway for your VPC. An egress-only internet gateway is used to
     * enable outbound communication over IPv6 from instances in your VPC to the internet, and prevents hosts outside of
     * your VPC from initiating an IPv6 connection with your instance.
     * </p>
     * 
     * @param createEgressOnlyInternetGatewayRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateEgressOnlyInternetGateway operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.CreateEgressOnlyInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateEgressOnlyInternetGatewayResult> createEgressOnlyInternetGatewayAsync(
            CreateEgressOnlyInternetGatewayRequest createEgressOnlyInternetGatewayRequest,
            com.amazonaws.handlers.AsyncHandler<CreateEgressOnlyInternetGatewayRequest, CreateEgressOnlyInternetGatewayResult> asyncHandler);

    /**
     * <p>
     * Creates an EC2 Fleet that contains the configuration information for On-Demand Instances and Spot Instances.
     * Instances are launched immediately if there is available capacity.
     * </p>
     * <p>
     * A single EC2 Fleet can include multiple launch specifications that vary by instance type, AMI, Availability Zone,
     * or subnet.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html">EC2
     * Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param createFleetRequest
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.
     * @sample AmazonEC2Async.CreateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateFleetResult> createFleetAsync(CreateFleetRequest createFleetRequest);

    /**
     * <p>
     * Creates an EC2 Fleet that contains the configuration information for On-Demand Instances and Spot Instances.
     * Instances are launched immediately if there is available capacity.
     * </p>
     * <p>
     * A single EC2 Fleet can include multiple launch specifications that vary by instance type, AMI, Availability Zone,
     * or subnet.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html">EC2
     * Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param createFleetRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateFleetResult> createFleetAsync(CreateFleetRequest createFleetRequest,
            com.amazonaws.handlers.AsyncHandler<CreateFleetRequest, CreateFleetResult> asyncHandler);

    /**
     * <p>
     * Creates one or more flow logs to capture information about IP traffic for a specific network interface, subnet,
     * or VPC.
     * </p>
     * <p>
     * Flow log data for a monitored network interface is recorded as flow log records, which are log events consisting
     * of fields that describe the traffic flow. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records</a> in
     * the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * When publishing to CloudWatch Logs, flow log records are published to a log group, and each network interface has
     * a unique log stream in the log group. When publishing to Amazon S3, flow log records for all of the monitored
     * network interfaces are published to a single log file object that is stored in the specified bucket.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html">VPC Flow
     * Logs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * 
     * @param createFlowLogsRequest
     * @return A Java Future containing the result of the CreateFlowLogs operation returned by the service.
     * @sample AmazonEC2Async.CreateFlowLogs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateFlowLogsResult> createFlowLogsAsync(CreateFlowLogsRequest createFlowLogsRequest);

    /**
     * <p>
     * Creates one or more flow logs to capture information about IP traffic for a specific network interface, subnet,
     * or VPC.
     * </p>
     * <p>
     * Flow log data for a monitored network interface is recorded as flow log records, which are log events consisting
     * of fields that describe the traffic flow. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records">Flow log records</a> in
     * the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * When publishing to CloudWatch Logs, flow log records are published to a log group, and each network interface has
     * a unique log stream in the log group. When publishing to Amazon S3, flow log records for all of the monitored
     * network interfaces are published to a single log file object that is stored in the specified bucket.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html">VPC Flow
     * Logs</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * 
     * @param createFlowLogsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateFlowLogs operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateFlowLogs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateFlowLogsResult> createFlowLogsAsync(CreateFlowLogsRequest createFlowLogsRequest,
            com.amazonaws.handlers.AsyncHandler<CreateFlowLogsRequest, CreateFlowLogsResult> asyncHandler);

    /**
     * <p>
     * Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).
     * </p>
     * <p>
     * The create operation is asynchronous. To verify that the AFI is ready for use, check the output logs.
     * </p>
     * <p>
     * An AFI contains the FPGA bitstream that is ready to download to an FPGA. You can securely deploy an AFI on
     * multiple FPGA-accelerated instances. For more information, see the <a
     * href="https://github.com/aws/aws-fpga/">Amazon Web Services FPGA Hardware Development Kit</a>.
     * </p>
     * 
     * @param createFpgaImageRequest
     * @return A Java Future containing the result of the CreateFpgaImage operation returned by the service.
     * @sample AmazonEC2Async.CreateFpgaImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateFpgaImageResult> createFpgaImageAsync(CreateFpgaImageRequest createFpgaImageRequest);

    /**
     * <p>
     * Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).
     * </p>
     * <p>
     * The create operation is asynchronous. To verify that the AFI is ready for use, check the output logs.
     * </p>
     * <p>
     * An AFI contains the FPGA bitstream that is ready to download to an FPGA. You can securely deploy an AFI on
     * multiple FPGA-accelerated instances. For more information, see the <a
     * href="https://github.com/aws/aws-fpga/">Amazon Web Services FPGA Hardware Development Kit</a>.
     * </p>
     * 
     * @param createFpgaImageRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateFpgaImage operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateFpgaImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateFpgaImageResult> createFpgaImageAsync(CreateFpgaImageRequest createFpgaImageRequest,
            com.amazonaws.handlers.AsyncHandler<CreateFpgaImageRequest, CreateFpgaImageResult> asyncHandler);

    /**
     * <p>
     * Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running or stopped.
     * </p>
     * <p>
     * If you customized your instance with instance store volumes or Amazon EBS volumes in addition to the root device
     * volume, the new AMI contains block device mapping information for those volumes. When you launch an instance from
     * this new AMI, the instance automatically launches with those additional volumes.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Create an Amazon EBS-backed
     * Linux AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param createImageRequest
     * @return A Java Future containing the result of the CreateImage operation returned by the service.
     * @sample AmazonEC2Async.CreateImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateImageResult> createImageAsync(CreateImageRequest createImageRequest);

    /**
     * <p>
     * Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running or stopped.
     * </p>
     * <p>
     * If you customized your instance with instance store volumes or Amazon EBS volumes in addition to the root device
     * volume, the new AMI contains block device mapping information for those volumes. When you launch an instance from
     * this new AMI, the instance automatically launches with those additional volumes.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Create an Amazon EBS-backed
     * Linux AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param createImageRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateImage operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateImageResult> createImageAsync(CreateImageRequest createImageRequest,
            com.amazonaws.handlers.AsyncHandler<CreateImageRequest, CreateImageResult> asyncHandler);

    /**
     * <p>
     * Creates an EC2 Instance Connect Endpoint.
     * </p>
     * <p>
     * An EC2 Instance Connect Endpoint allows you to connect to an instance, without requiring the instance to have a
     * public IPv4 address. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Connect-using-EC2-Instance-Connect-Endpoint.html"
     * >Connect to your instances without requiring a public IPv4 address using EC2 Instance Connect Endpoint</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param createInstanceConnectEndpointRequest
     * @return A Java Future containing the result of the CreateInstanceConnectEndpoint operation returned by the
     *         service.
     * @sample AmazonEC2Async.CreateInstanceConnectEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceConnectEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateInstanceConnectEndpointResult> createInstanceConnectEndpointAsync(
            CreateInstanceConnectEndpointRequest createInstanceConnectEndpointRequest);

    /**
     * <p>
     * Creates an EC2 Instance Connect Endpoint.
     * </p>
     * <p>
     * An EC2 Instance Connect Endpoint allows you to connect to an instance, without requiring the instance to have a
     * public IPv4 address. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Connect-using-EC2-Instance-Connect-Endpoint.html"
     * >Connect to your instances without requiring a public IPv4 address using EC2 Instance Connect Endpoint</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param createInstanceConnectEndpointRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateInstanceConnectEndpoint operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.CreateInstanceConnectEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceConnectEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateInstanceConnectEndpointResult> createInstanceConnectEndpointAsync(
            CreateInstanceConnectEndpointRequest createInstanceConnectEndpointRequest,
            com.amazonaws.handlers.AsyncHandler<CreateInstanceConnectEndpointRequest, CreateInstanceConnectEndpointResult> asyncHandler);

    /**
     * <p>
     * Creates an event window in which scheduled events for the associated Amazon EC2 instances can run.
     * </p>
     * <p>
     * You can define either a set of time ranges or a cron expression when creating the event window, but not both. All
     * event window times are in UTC.
     * </p>
     * <p>
     * You can create up to 200 event windows per Amazon Web Services Region.
     * </p>
     * <p>
     * When you create the event window, targets (instance IDs, Dedicated Host IDs, or tags) are not yet associated with
     * it. To ensure that the event window can be used, you must associate one or more targets with it by using the
     * <a>AssociateInstanceEventWindow</a> API.
     * </p>
     * <important>
     * <p>
     * Event windows are applicable only for scheduled events that stop, reboot, or terminate instances.
     * </p>
     * <p>
     * Event windows are <i>not</i> applicable for:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Expedited scheduled events and network maintenance events.
     * </p>
     * </li>
     * <li>
     * <p>
     * Unscheduled maintenance such as AutoRecovery and unplanned reboots.
     * </p>
     * </li>
     * </ul>
     * </important>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param createInstanceEventWindowRequest
     * @return A Java Future containing the result of the CreateInstanceEventWindow operation returned by the service.
     * @sample AmazonEC2Async.CreateInstanceEventWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceEventWindow" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateInstanceEventWindowResult> createInstanceEventWindowAsync(
            CreateInstanceEventWindowRequest createInstanceEventWindowRequest);

    /**
     * <p>
     * Creates an event window in which scheduled events for the associated Amazon EC2 instances can run.
     * </p>
     * <p>
     * You can define either a set of time ranges or a cron expression when creating the event window, but not both. All
     * event window times are in UTC.
     * </p>
     * <p>
     * You can create up to 200 event windows per Amazon Web Services Region.
     * </p>
     * <p>
     * When you create the event window, targets (instance IDs, Dedicated Host IDs, or tags) are not yet associated with
     * it. To ensure that the event window can be used, you must associate one or more targets with it by using the
     * <a>AssociateInstanceEventWindow</a> API.
     * </p>
     * <important>
     * <p>
     * Event windows are applicable only for scheduled events that stop, reboot, or terminate instances.
     * </p>
     * <p>
     * Event windows are <i>not</i> applicable for:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Expedited scheduled events and network maintenance events.
     * </p>
     * </li>
     * <li>
     * <p>
     * Unscheduled maintenance such as AutoRecovery and unplanned reboots.
     * </p>
     * </li>
     * </ul>
     * </important>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param createInstanceEventWindowRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateInstanceEventWindow operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateInstanceEventWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceEventWindow" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateInstanceEventWindowResult> createInstanceEventWindowAsync(
            CreateInstanceEventWindowRequest createInstanceEventWindowRequest,
            com.amazonaws.handlers.AsyncHandler<CreateInstanceEventWindowRequest, CreateInstanceEventWindowResult> asyncHandler);

    /**
     * <p>
     * Exports a running or stopped instance to an Amazon S3 bucket.
     * </p>
     * <p>
     * For information about the prerequisites for your Amazon S3 bucket, supported operating systems, image formats,
     * and known limitations for the types of instances you can export, see <a
     * href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html">Exporting an instance as a VM Using
     * VM Import/Export</a> in the <i>VM Import/Export User Guide</i>.
     * </p>
     * 
     * @param createInstanceExportTaskRequest
     * @return A Java Future containing the result of the CreateInstanceExportTask operation returned by the service.
     * @sample AmazonEC2Async.CreateInstanceExportTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTask" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateInstanceExportTaskResult> createInstanceExportTaskAsync(CreateInstanceExportTaskRequest createInstanceExportTaskRequest);

    /**
     * <p>
     * Exports a running or stopped instance to an Amazon S3 bucket.
     * </p>
     * <p>
     * For information about the prerequisites for your Amazon S3 bucket, supported operating systems, image formats,
     * and known limitations for the types of instances you can export, see <a
     * href="https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html">Exporting an instance as a VM Using
     * VM Import/Export</a> in the <i>VM Import/Export User Guide</i>.
     * </p>
     * 
     * @param createInstanceExportTaskRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateInstanceExportTask operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateInstanceExportTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTask" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateInstanceExportTaskResult> createInstanceExportTaskAsync(CreateInstanceExportTaskRequest createInstanceExportTaskRequest,
            com.amazonaws.handlers.AsyncHandler<CreateInstanceExportTaskRequest, CreateInstanceExportTaskResult> asyncHandler);

    /**
     * <p>
     * Creates an internet gateway for use with a VPC. After creating the internet gateway, you attach it to a VPC using
     * <a>AttachInternetGateway</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html">Internet gateways</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param createInternetGatewayRequest
     * @return A Java Future containing the result of the CreateInternetGateway operation returned by the service.
     * @sample AmazonEC2Async.CreateInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateInternetGatewayResult> createInternetGatewayAsync(CreateInternetGatewayRequest createInternetGatewayRequest);

    /**
     * <p>
     * Creates an internet gateway for use with a VPC. After creating the internet gateway, you attach it to a VPC using
     * <a>AttachInternetGateway</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html">Internet gateways</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param createInternetGatewayRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateInternetGateway operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateInternetGatewayResult> createInternetGatewayAsync(CreateInternetGatewayRequest createInternetGatewayRequest,
            com.amazonaws.handlers.AsyncHandler<CreateInternetGatewayRequest, CreateInternetGatewayResult> asyncHandler);

    /**
     * Simplified method form for invoking the CreateInternetGateway operation.
     *
     * @see #createInternetGatewayAsync(CreateInternetGatewayRequest)
     */
    java.util.concurrent.Future<CreateInternetGatewayResult> createInternetGatewayAsync();

    /**
     * Simplified method form for invoking the CreateInternetGateway operation with an AsyncHandler.
     *
     * @see #createInternetGatewayAsync(CreateInternetGatewayRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<CreateInternetGatewayResult> createInternetGatewayAsync(
            com.amazonaws.handlers.AsyncHandler<CreateInternetGatewayRequest, CreateInternetGatewayResult> asyncHandler);

    /**
     * <p>
     * Create an IPAM. Amazon VPC IP Address Manager (IPAM) is a VPC feature that you can use to automate your IP
     * address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across
     * Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html">Create an
     * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * 
     * @param createIpamRequest
     * @return A Java Future containing the result of the CreateIpam operation returned by the service.
     * @sample AmazonEC2Async.CreateIpam
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpam" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateIpamResult> createIpamAsync(CreateIpamRequest createIpamRequest);

    /**
     * <p>
     * Create an IPAM. Amazon VPC IP Address Manager (IPAM) is a VPC feature that you can use to automate your IP
     * address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across
     * Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html">Create an
     * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * 
     * @param createIpamRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateIpam operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateIpam
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpam" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateIpamResult> createIpamAsync(CreateIpamRequest createIpamRequest,
            com.amazonaws.handlers.AsyncHandler<CreateIpamRequest, CreateIpamResult> asyncHandler);

    /**
     * <p>
     * Create an IP address pool for Amazon VPC IP Address Manager (IPAM). In IPAM, a pool is a collection of contiguous
     * IP addresses CIDRs. Pools enable you to organize your IP addresses according to your routing and security needs.
     * For example, if you have separate routing and security needs for development and production applications, you can
     * create a pool for each.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/create-top-ipam.html">Create a
     * top-level pool</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * 
     * @param createIpamPoolRequest
     * @return A Java Future containing the result of the CreateIpamPool operation returned by the service.
     * @sample AmazonEC2Async.CreateIpamPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamPool" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateIpamPoolResult> createIpamPoolAsync(CreateIpamPoolRequest createIpamPoolRequest);

    /**
     * <p>
     * Create an IP address pool for Amazon VPC IP Address Manager (IPAM). In IPAM, a pool is a collection of contiguous
     * IP addresses CIDRs. Pools enable you to organize your IP addresses according to your routing and security needs.
     * For example, if you have separate routing and security needs for development and production applications, you can
     * create a pool for each.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/create-top-ipam.html">Create a
     * top-level pool</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * 
     * @param createIpamPoolRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateIpamPool operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateIpamPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamPool" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateIpamPoolResult> createIpamPoolAsync(CreateIpamPoolRequest createIpamPoolRequest,
            com.amazonaws.handlers.AsyncHandler<CreateIpamPoolRequest, CreateIpamPoolResult> asyncHandler);

    /**
     * <p>
     * Creates an IPAM resource discovery. A resource discovery is an IPAM component that enables IPAM to manage and
     * monitor resources that belong to the owning account.
     * </p>
     * 
     * @param createIpamResourceDiscoveryRequest
     * @return A Java Future containing the result of the CreateIpamResourceDiscovery operation returned by the service.
     * @sample AmazonEC2Async.CreateIpamResourceDiscovery
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamResourceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateIpamResourceDiscoveryResult> createIpamResourceDiscoveryAsync(
            CreateIpamResourceDiscoveryRequest createIpamResourceDiscoveryRequest);

    /**
     * <p>
     * Creates an IPAM resource discovery. A resource discovery is an IPAM component that enables IPAM to manage and
     * monitor resources that belong to the owning account.
     * </p>
     * 
     * @param createIpamResourceDiscoveryRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateIpamResourceDiscovery operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateIpamResourceDiscovery
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamResourceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateIpamResourceDiscoveryResult> createIpamResourceDiscoveryAsync(
            CreateIpamResourceDiscoveryRequest createIpamResourceDiscoveryRequest,
            com.amazonaws.handlers.AsyncHandler<CreateIpamResourceDiscoveryRequest, CreateIpamResourceDiscoveryResult> asyncHandler);

    /**
     * <p>
     * Create an IPAM scope. In IPAM, a scope is the highest-level container within IPAM. An IPAM contains two default
     * scopes. Each scope represents the IP space for a single network. The private scope is intended for all private IP
     * address space. The public scope is intended for all public IP address space. Scopes enable you to reuse IP
     * addresses across multiple unconnected networks without causing IP address overlap or conflict.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/add-scope-ipam.html">Add a
     * scope</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * 
     * @param createIpamScopeRequest
     * @return A Java Future containing the result of the CreateIpamScope operation returned by the service.
     * @sample AmazonEC2Async.CreateIpamScope
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamScope" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateIpamScopeResult> createIpamScopeAsync(CreateIpamScopeRequest createIpamScopeRequest);

    /**
     * <p>
     * Create an IPAM scope. In IPAM, a scope is the highest-level container within IPAM. An IPAM contains two default
     * scopes. Each scope represents the IP space for a single network. The private scope is intended for all private IP
     * address space. The public scope is intended for all public IP address space. Scopes enable you to reuse IP
     * addresses across multiple unconnected networks without causing IP address overlap or conflict.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/add-scope-ipam.html">Add a
     * scope</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * 
     * @param createIpamScopeRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateIpamScope operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateIpamScope
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamScope" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateIpamScopeResult> createIpamScopeAsync(CreateIpamScopeRequest createIpamScopeRequest,
            com.amazonaws.handlers.AsyncHandler<CreateIpamScopeRequest, CreateIpamScopeResult> asyncHandler);

    /**
     * <p>
     * Creates an ED25519 or 2048-bit RSA key pair with the specified name and in the specified PEM or PPK format.
     * Amazon EC2 stores the public key and displays the private key for you to save to a file. The private key is
     * returned as an unencrypted PEM encoded PKCS#1 private key or an unencrypted PPK formatted private key for use
     * with PuTTY. If a key with the specified name already exists, Amazon EC2 returns an error.
     * </p>
     * <p>
     * The key pair returned to you is available only in the Amazon Web Services Region in which you create it. If you
     * prefer, you can create your own key pair using a third-party tool and upload it to any Region using
     * <a>ImportKeyPair</a>.
     * </p>
     * <p>
     * You can have up to 5,000 key pairs per Amazon Web Services Region.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon
     * EC2 key pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param createKeyPairRequest
     * @return A Java Future containing the result of the CreateKeyPair operation returned by the service.
     * @sample AmazonEC2Async.CreateKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateKeyPairResult> createKeyPairAsync(CreateKeyPairRequest createKeyPairRequest);

    /**
     * <p>
     * Creates an ED25519 or 2048-bit RSA key pair with the specified name and in the specified PEM or PPK format.
     * Amazon EC2 stores the public key and displays the private key for you to save to a file. The private key is
     * returned as an unencrypted PEM encoded PKCS#1 private key or an unencrypted PPK formatted private key for use
     * with PuTTY. If a key with the specified name already exists, Amazon EC2 returns an error.
     * </p>
     * <p>
     * The key pair returned to you is available only in the Amazon Web Services Region in which you create it. If you
     * prefer, you can create your own key pair using a third-party tool and upload it to any Region using
     * <a>ImportKeyPair</a>.
     * </p>
     * <p>
     * You can have up to 5,000 key pairs per Amazon Web Services Region.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon
     * EC2 key pairs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param createKeyPairRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateKeyPair operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateKeyPairResult> createKeyPairAsync(CreateKeyPairRequest createKeyPairRequest,
            com.amazonaws.handlers.AsyncHandler<CreateKeyPairRequest, CreateKeyPairResult> asyncHandler);

    /**
     * <p>
     * Creates a launch template.
     * </p>
     * <p>
     * A launch template contains the parameters to launch an instance. When you launch an instance using
     * <a>RunInstances</a>, you can specify a launch template instead of providing the launch parameters in the request.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launch an instance from a
     * launch template</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * To clone an existing launch template as the basis for a new launch template, use the Amazon EC2 console. The API,
     * SDKs, and CLI do not support cloning a template. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template-from-existing-launch-template"
     * >Create a launch template from an existing launch template</a> in the <i>Amazon Elastic Compute Cloud User
     * Guide</i>.
     * </p>
     * 
     * @param createLaunchTemplateRequest
     * @return A Java Future containing the result of the CreateLaunchTemplate operation returned by the service.
     * @sample AmazonEC2Async.CreateLaunchTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateLaunchTemplateResult> createLaunchTemplateAsync(CreateLaunchTemplateRequest createLaunchTemplateRequest);

    /**
     * <p>
     * Creates a launch template.
     * </p>
     * <p>
     * A launch template contains the parameters to launch an instance. When you launch an instance using
     * <a>RunInstances</a>, you can specify a launch template instead of providing the launch parameters in the request.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Launch an instance from a
     * launch template</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * To clone an existing launch template as the basis for a new launch template, use the Amazon EC2 console. The API,
     * SDKs, and CLI do not support cloning a template. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template-from-existing-launch-template"
     * >Create a launch template from an existing launch template</a> in the <i>Amazon Elastic Compute Cloud User
     * Guide</i>.
     * </p>
     * 
     * @param createLaunchTemplateRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateLaunchTemplate operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateLaunchTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateLaunchTemplateResult> createLaunchTemplateAsync(CreateLaunchTemplateRequest createLaunchTemplateRequest,
            com.amazonaws.handlers.AsyncHandler<CreateLaunchTemplateRequest, CreateLaunchTemplateResult> asyncHandler);

    /**
     * <p>
     * Creates a new version of a launch template. You must specify an existing launch template, either by name or ID.
     * You can determine whether the new version inherits parameters from a source version, and add or overwrite
     * parameters as needed.
     * </p>
     * <p>
     * Launch template versions are numbered in the order in which they are created. You can't specify, change, or
     * replace the numbering of launch template versions.
     * </p>
     * <p>
     * Launch templates are immutable; after you create a launch template, you can't modify it. Instead, you can create
     * a new version of the launch template that includes the changes that you require.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#manage-launch-template-versions"
     * >Modify a launch template (manage launch template versions)</a> in the <i>Amazon Elastic Compute Cloud User
     * Guide</i>.
     * </p>
     * 
     * @param createLaunchTemplateVersionRequest
     * @return A Java Future containing the result of the CreateLaunchTemplateVersion operation returned by the service.
     * @sample AmazonEC2Async.CreateLaunchTemplateVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateLaunchTemplateVersionResult> createLaunchTemplateVersionAsync(
            CreateLaunchTemplateVersionRequest createLaunchTemplateVersionRequest);

    /**
     * <p>
     * Creates a new version of a launch template. You must specify an existing launch template, either by name or ID.
     * You can determine whether the new version inherits parameters from a source version, and add or overwrite
     * parameters as needed.
     * </p>
     * <p>
     * Launch template versions are numbered in the order in which they are created. You can't specify, change, or
     * replace the numbering of launch template versions.
     * </p>
     * <p>
     * Launch templates are immutable; after you create a launch template, you can't modify it. Instead, you can create
     * a new version of the launch template that includes the changes that you require.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#manage-launch-template-versions"
     * >Modify a launch template (manage launch template versions)</a> in the <i>Amazon Elastic Compute Cloud User
     * Guide</i>.
     * </p>
     * 
     * @param createLaunchTemplateVersionRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateLaunchTemplateVersion operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateLaunchTemplateVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersion"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateLaunchTemplateVersionResult> createLaunchTemplateVersionAsync(
            CreateLaunchTemplateVersionRequest createLaunchTemplateVersionRequest,
            com.amazonaws.handlers.AsyncHandler<CreateLaunchTemplateVersionRequest, CreateLaunchTemplateVersionResult> asyncHandler);

    /**
     * <p>
     * Creates a static route for the specified local gateway route table. You must specify one of the following
     * targets:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LocalGatewayVirtualInterfaceGroupId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NetworkInterfaceId</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @param createLocalGatewayRouteRequest
     * @return A Java Future containing the result of the CreateLocalGatewayRoute operation returned by the service.
     * @sample AmazonEC2Async.CreateLocalGatewayRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateLocalGatewayRouteResult> createLocalGatewayRouteAsync(CreateLocalGatewayRouteRequest createLocalGatewayRouteRequest);

    /**
     * <p>
     * Creates a static route for the specified local gateway route table. You must specify one of the following
     * targets:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LocalGatewayVirtualInterfaceGroupId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NetworkInterfaceId</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @param createLocalGatewayRouteRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateLocalGatewayRoute operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateLocalGatewayRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateLocalGatewayRouteResult> createLocalGatewayRouteAsync(CreateLocalGatewayRouteRequest createLocalGatewayRouteRequest,
            com.amazonaws.handlers.AsyncHandler<CreateLocalGatewayRouteRequest, CreateLocalGatewayRouteResult> asyncHandler);

    /**
     * <p>
     * Creates a local gateway route table.
     * </p>
     * 
     * @param createLocalGatewayRouteTableRequest
     * @return A Java Future containing the result of the CreateLocalGatewayRouteTable operation returned by the
     *         service.
     * @sample AmazonEC2Async.CreateLocalGatewayRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateLocalGatewayRouteTableResult> createLocalGatewayRouteTableAsync(
            CreateLocalGatewayRouteTableRequest createLocalGatewayRouteTableRequest);

    /**
     * <p>
     * Creates a local gateway route table.
     * </p>
     * 
     * @param createLocalGatewayRouteTableRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateLocalGatewayRouteTable operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.CreateLocalGatewayRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateLocalGatewayRouteTableResult> createLocalGatewayRouteTableAsync(
            CreateLocalGatewayRouteTableRequest createLocalGatewayRouteTableRequest,
            com.amazonaws.handlers.AsyncHandler<CreateLocalGatewayRouteTableRequest, CreateLocalGatewayRouteTableResult> asyncHandler);

    /**
     * <p>
     * Creates a local gateway route table virtual interface group association.
     * </p>
     * 
     * @param createLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
     * @return A Java Future containing the result of the CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation
     *         operation returned by the service.
     * @sample AmazonEC2Async.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult> createLocalGatewayRouteTableVirtualInterfaceGroupAssociationAsync(
            CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest createLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest);

    /**
     * <p>
     * Creates a local gateway route table virtual interface group association.
     * </p>
     * 
     * @param createLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation
     *         operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult> createLocalGatewayRouteTableVirtualInterfaceGroupAssociationAsync(
            CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest createLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest,
            com.amazonaws.handlers.AsyncHandler<CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest, CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult> asyncHandler);

    /**
     * <p>
     * Associates the specified VPC with the specified local gateway route table.
     * </p>
     * 
     * @param createLocalGatewayRouteTableVpcAssociationRequest
     * @return A Java Future containing the result of the CreateLocalGatewayRouteTableVpcAssociation operation returned
     *         by the service.
     * @sample AmazonEC2Async.CreateLocalGatewayRouteTableVpcAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateLocalGatewayRouteTableVpcAssociationResult> createLocalGatewayRouteTableVpcAssociationAsync(
            CreateLocalGatewayRouteTableVpcAssociationRequest createLocalGatewayRouteTableVpcAssociationRequest);

    /**
     * <p>
     * Associates the specified VPC with the specified local gateway route table.
     * </p>
     * 
     * @param createLocalGatewayRouteTableVpcAssociationRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateLocalGatewayRouteTableVpcAssociation operation returned
     *         by the service.
     * @sample AmazonEC2AsyncHandler.CreateLocalGatewayRouteTableVpcAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateLocalGatewayRouteTableVpcAssociationResult> createLocalGatewayRouteTableVpcAssociationAsync(
            CreateLocalGatewayRouteTableVpcAssociationRequest createLocalGatewayRouteTableVpcAssociationRequest,
            com.amazonaws.handlers.AsyncHandler<CreateLocalGatewayRouteTableVpcAssociationRequest, CreateLocalGatewayRouteTableVpcAssociationResult> asyncHandler);

    /**
     * <p>
     * Creates a managed prefix list. You can specify one or more entries for the prefix list. Each entry consists of a
     * CIDR block and an optional description.
     * </p>
     * 
     * @param createManagedPrefixListRequest
     * @return A Java Future containing the result of the CreateManagedPrefixList operation returned by the service.
     * @sample AmazonEC2Async.CreateManagedPrefixList
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateManagedPrefixList" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateManagedPrefixListResult> createManagedPrefixListAsync(CreateManagedPrefixListRequest createManagedPrefixListRequest);

    /**
     * <p>
     * Creates a managed prefix list. You can specify one or more entries for the prefix list. Each entry consists of a
     * CIDR block and an optional description.
     * </p>
     * 
     * @param createManagedPrefixListRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateManagedPrefixList operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateManagedPrefixList
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateManagedPrefixList" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateManagedPrefixListResult> createManagedPrefixListAsync(CreateManagedPrefixListRequest createManagedPrefixListRequest,
            com.amazonaws.handlers.AsyncHandler<CreateManagedPrefixListRequest, CreateManagedPrefixListResult> asyncHandler);

    /**
     * <p>
     * Creates a NAT gateway in the specified subnet. This action creates a network interface in the specified subnet
     * with a private IP address from the IP address range of the subnet. You can create either a public NAT gateway or
     * a private NAT gateway.
     * </p>
     * <p>
     * With a public NAT gateway, internet-bound traffic from a private subnet can be routed to the NAT gateway, so that
     * instances in a private subnet can connect to the internet.
     * </p>
     * <p>
     * With a private NAT gateway, private communication is routed across VPCs and on-premises networks through a
     * transit gateway or virtual private gateway. Common use cases include running large workloads behind a small pool
     * of allowlisted IPv4 addresses, preserving private IPv4 addresses, and communicating between overlapping networks.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">NAT
     * gateways</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <important>
     * <p>
     * When you create a public NAT gateway and assign it an EIP or secondary EIPs, the network border group of the EIPs
     * must match the network border group of the Availability Zone (AZ) that the public NAT gateway is in. If it's not
     * the same, the NAT gateway will fail to launch. You can see the network border group for the subnet's AZ by
     * viewing the details of the subnet. Similarly, you can view the network border group of an EIP by viewing the
     * details of the EIP address. For more information about network border groups and EIPs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#allocate-eip">Allocate an Elastic IP
     * address</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * </important>
     * 
     * @param createNatGatewayRequest
     * @return A Java Future containing the result of the CreateNatGateway operation returned by the service.
     * @sample AmazonEC2Async.CreateNatGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateNatGatewayResult> createNatGatewayAsync(CreateNatGatewayRequest createNatGatewayRequest);

    /**
     * <p>
     * Creates a NAT gateway in the specified subnet. This action creates a network interface in the specified subnet
     * with a private IP address from the IP address range of the subnet. You can create either a public NAT gateway or
     * a private NAT gateway.
     * </p>
     * <p>
     * With a public NAT gateway, internet-bound traffic from a private subnet can be routed to the NAT gateway, so that
     * instances in a private subnet can connect to the internet.
     * </p>
     * <p>
     * With a private NAT gateway, private communication is routed across VPCs and on-premises networks through a
     * transit gateway or virtual private gateway. Common use cases include running large workloads behind a small pool
     * of allowlisted IPv4 addresses, preserving private IPv4 addresses, and communicating between overlapping networks.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html">NAT
     * gateways</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <important>
     * <p>
     * When you create a public NAT gateway and assign it an EIP or secondary EIPs, the network border group of the EIPs
     * must match the network border group of the Availability Zone (AZ) that the public NAT gateway is in. If it's not
     * the same, the NAT gateway will fail to launch. You can see the network border group for the subnet's AZ by
     * viewing the details of the subnet. Similarly, you can view the network border group of an EIP by viewing the
     * details of the EIP address. For more information about network border groups and EIPs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#allocate-eip">Allocate an Elastic IP
     * address</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * </important>
     * 
     * @param createNatGatewayRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateNatGateway operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateNatGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateNatGatewayResult> createNatGatewayAsync(CreateNatGatewayRequest createNatGatewayRequest,
            com.amazonaws.handlers.AsyncHandler<CreateNatGatewayRequest, CreateNatGatewayResult> asyncHandler);

    /**
     * <p>
     * Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security
     * groups) for the instances in your VPC.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Network ACLs</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     * 
     * @param createNetworkAclRequest
     * @return A Java Future containing the result of the CreateNetworkAcl operation returned by the service.
     * @sample AmazonEC2Async.CreateNetworkAcl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateNetworkAclResult> createNetworkAclAsync(CreateNetworkAclRequest createNetworkAclRequest);

    /**
     * <p>
     * Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in addition to security
     * groups) for the instances in your VPC.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Network ACLs</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     * 
     * @param createNetworkAclRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateNetworkAcl operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateNetworkAcl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateNetworkAclResult> createNetworkAclAsync(CreateNetworkAclRequest createNetworkAclRequest,
            com.amazonaws.handlers.AsyncHandler<CreateNetworkAclRequest, CreateNetworkAclResult> asyncHandler);

    /**
     * <p>
     * Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered
     * ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in
     * or out of a subnet associated with the ACL, we process the entries in the ACL according to the rule numbers, in
     * ascending order. Each network ACL has a set of ingress rules and a separate set of egress rules.
     * </p>
     * <p>
     * We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them
     * one right after the other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing
     * ones without having to renumber the rules.
     * </p>
     * <p>
     * After you add an entry, you can't modify it; you must either replace it, or create an entry and delete the old
     * one.
     * </p>
     * <p>
     * For more information about network ACLs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Network ACLs</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     * 
     * @param createNetworkAclEntryRequest
     * @return A Java Future containing the result of the CreateNetworkAclEntry operation returned by the service.
     * @sample AmazonEC2Async.CreateNetworkAclEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateNetworkAclEntryResult> createNetworkAclEntryAsync(CreateNetworkAclEntryRequest createNetworkAclEntryRequest);

    /**
     * <p>
     * Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL has a set of numbered
     * ingress rules and a separate set of numbered egress rules. When determining whether a packet should be allowed in
     * or out of a subnet associated with the ACL, we process the entries in the ACL according to the rule numbers, in
     * ascending order. Each network ACL has a set of ingress rules and a separate set of egress rules.
     * </p>
     * <p>
     * We recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...), and not number them
     * one right after the other (for example, 101, 102, 103, ...). This makes it easier to add a rule between existing
     * ones without having to renumber the rules.
     * </p>
     * <p>
     * After you add an entry, you can't modify it; you must either replace it, or create an entry and delete the old
     * one.
     * </p>
     * <p>
     * For more information about network ACLs, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Network ACLs</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     * 
     * @param createNetworkAclEntryRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateNetworkAclEntry operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateNetworkAclEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateNetworkAclEntryResult> createNetworkAclEntryAsync(CreateNetworkAclEntryRequest createNetworkAclEntryRequest,
            com.amazonaws.handlers.AsyncHandler<CreateNetworkAclEntryRequest, CreateNetworkAclEntryResult> asyncHandler);

    /**
     * <p>
     * Creates a Network Access Scope.
     * </p>
     * <p>
     * Amazon Web Services Network Access Analyzer enables cloud networking and cloud operations teams to verify that
     * their networks on Amazon Web Services conform to their network security and governance objectives. For more
     * information, see the <a href="https://docs.aws.amazon.com/vpc/latest/network-access-analyzer/">Amazon Web
     * Services Network Access Analyzer Guide</a>.
     * </p>
     * 
     * @param createNetworkInsightsAccessScopeRequest
     * @return A Java Future containing the result of the CreateNetworkInsightsAccessScope operation returned by the
     *         service.
     * @sample AmazonEC2Async.CreateNetworkInsightsAccessScope
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateNetworkInsightsAccessScopeResult> createNetworkInsightsAccessScopeAsync(
            CreateNetworkInsightsAccessScopeRequest createNetworkInsightsAccessScopeRequest);

    /**
     * <p>
     * Creates a Network Access Scope.
     * </p>
     * <p>
     * Amazon Web Services Network Access Analyzer enables cloud networking and cloud operations teams to verify that
     * their networks on Amazon Web Services conform to their network security and governance objectives. For more
     * information, see the <a href="https://docs.aws.amazon.com/vpc/latest/network-access-analyzer/">Amazon Web
     * Services Network Access Analyzer Guide</a>.
     * </p>
     * 
     * @param createNetworkInsightsAccessScopeRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateNetworkInsightsAccessScope operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.CreateNetworkInsightsAccessScope
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateNetworkInsightsAccessScopeResult> createNetworkInsightsAccessScopeAsync(
            CreateNetworkInsightsAccessScopeRequest createNetworkInsightsAccessScopeRequest,
            com.amazonaws.handlers.AsyncHandler<CreateNetworkInsightsAccessScopeRequest, CreateNetworkInsightsAccessScopeResult> asyncHandler);

    /**
     * <p>
     * Creates a path to analyze for reachability.
     * </p>
     * <p>
     * Reachability Analyzer enables you to analyze and debug network reachability between two resources in your virtual
     * private cloud (VPC). For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/reachability/">Reachability Analyzer Guide</a>.
     * </p>
     * 
     * @param createNetworkInsightsPathRequest
     * @return A Java Future containing the result of the CreateNetworkInsightsPath operation returned by the service.
     * @sample AmazonEC2Async.CreateNetworkInsightsPath
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsPath" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateNetworkInsightsPathResult> createNetworkInsightsPathAsync(
            CreateNetworkInsightsPathRequest createNetworkInsightsPathRequest);

    /**
     * <p>
     * Creates a path to analyze for reachability.
     * </p>
     * <p>
     * Reachability Analyzer enables you to analyze and debug network reachability between two resources in your virtual
     * private cloud (VPC). For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/reachability/">Reachability Analyzer Guide</a>.
     * </p>
     * 
     * @param createNetworkInsightsPathRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateNetworkInsightsPath operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateNetworkInsightsPath
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsPath" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateNetworkInsightsPathResult> createNetworkInsightsPathAsync(
            CreateNetworkInsightsPathRequest createNetworkInsightsPathRequest,
            com.amazonaws.handlers.AsyncHandler<CreateNetworkInsightsPathRequest, CreateNetworkInsightsPathResult> asyncHandler);

    /**
     * <p>
     * Creates a network interface in the specified subnet.
     * </p>
     * <p>
     * The number of IP addresses you can assign to a network interface varies by instance type. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses
     * Per ENI Per Instance Type</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information about network interfaces, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic network interfaces</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param createNetworkInterfaceRequest
     * @return A Java Future containing the result of the CreateNetworkInterface operation returned by the service.
     * @sample AmazonEC2Async.CreateNetworkInterface
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterface" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateNetworkInterfaceResult> createNetworkInterfaceAsync(CreateNetworkInterfaceRequest createNetworkInterfaceRequest);

    /**
     * <p>
     * Creates a network interface in the specified subnet.
     * </p>
     * <p>
     * The number of IP addresses you can assign to a network interface varies by instance type. For more information,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses
     * Per ENI Per Instance Type</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information about network interfaces, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic network interfaces</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param createNetworkInterfaceRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateNetworkInterface operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateNetworkInterface
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterface" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateNetworkInterfaceResult> createNetworkInterfaceAsync(CreateNetworkInterfaceRequest createNetworkInterfaceRequest,
            com.amazonaws.handlers.AsyncHandler<CreateNetworkInterfaceRequest, CreateNetworkInterfaceResult> asyncHandler);

    /**
     * <p>
     * Grants an Amazon Web Services-authorized account permission to attach the specified network interface to an
     * instance in their account.
     * </p>
     * <p>
     * You can grant permission to a single Amazon Web Services account only, and only one account at a time.
     * </p>
     * 
     * @param createNetworkInterfacePermissionRequest
     *        Contains the parameters for CreateNetworkInterfacePermission.
     * @return A Java Future containing the result of the CreateNetworkInterfacePermission operation returned by the
     *         service.
     * @sample AmazonEC2Async.CreateNetworkInterfacePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateNetworkInterfacePermissionResult> createNetworkInterfacePermissionAsync(
            CreateNetworkInterfacePermissionRequest createNetworkInterfacePermissionRequest);

    /**
     * <p>
     * Grants an Amazon Web Services-authorized account permission to attach the specified network interface to an
     * instance in their account.
     * </p>
     * <p>
     * You can grant permission to a single Amazon Web Services account only, and only one account at a time.
     * </p>
     * 
     * @param createNetworkInterfacePermissionRequest
     *        Contains the parameters for CreateNetworkInterfacePermission.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateNetworkInterfacePermission operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.CreateNetworkInterfacePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateNetworkInterfacePermissionResult> createNetworkInterfacePermissionAsync(
            CreateNetworkInterfacePermissionRequest createNetworkInterfacePermissionRequest,
            com.amazonaws.handlers.AsyncHandler<CreateNetworkInterfacePermissionRequest, CreateNetworkInterfacePermissionResult> asyncHandler);

    /**
     * <p>
     * Creates a placement group in which to launch instances. The strategy of the placement group determines how the
     * instances are organized within the group.
     * </p>
     * <p>
     * A <code>cluster</code> placement group is a logical grouping of instances within a single Availability Zone that
     * benefit from low network latency, high network throughput. A <code>spread</code> placement group places instances
     * on distinct hardware. A <code>partition</code> placement group places groups of instances in different
     * partitions, where instances in one partition do not share the same hardware with instances in another partition.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param createPlacementGroupRequest
     * @return A Java Future containing the result of the CreatePlacementGroup operation returned by the service.
     * @sample AmazonEC2Async.CreatePlacementGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreatePlacementGroupResult> createPlacementGroupAsync(CreatePlacementGroupRequest createPlacementGroupRequest);

    /**
     * <p>
     * Creates a placement group in which to launch instances. The strategy of the placement group determines how the
     * instances are organized within the group.
     * </p>
     * <p>
     * A <code>cluster</code> placement group is a logical grouping of instances within a single Availability Zone that
     * benefit from low network latency, high network throughput. A <code>spread</code> placement group places instances
     * on distinct hardware. A <code>partition</code> placement group places groups of instances in different
     * partitions, where instances in one partition do not share the same hardware with instances in another partition.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param createPlacementGroupRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreatePlacementGroup operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreatePlacementGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreatePlacementGroupResult> createPlacementGroupAsync(CreatePlacementGroupRequest createPlacementGroupRequest,
            com.amazonaws.handlers.AsyncHandler<CreatePlacementGroupRequest, CreatePlacementGroupResult> asyncHandler);

    /**
     * <p>
     * Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4
     * CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web
     * Services, however, use IPAM pools only. To monitor the status of pool creation, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePublicIpv4Pools.html"
     * >DescribePublicIpv4Pools</a>.
     * </p>
     * 
     * @param createPublicIpv4PoolRequest
     * @return A Java Future containing the result of the CreatePublicIpv4Pool operation returned by the service.
     * @sample AmazonEC2Async.CreatePublicIpv4Pool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePublicIpv4Pool" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreatePublicIpv4PoolResult> createPublicIpv4PoolAsync(CreatePublicIpv4PoolRequest createPublicIpv4PoolRequest);

    /**
     * <p>
     * Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4
     * CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web
     * Services, however, use IPAM pools only. To monitor the status of pool creation, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePublicIpv4Pools.html"
     * >DescribePublicIpv4Pools</a>.
     * </p>
     * 
     * @param createPublicIpv4PoolRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreatePublicIpv4Pool operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreatePublicIpv4Pool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePublicIpv4Pool" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreatePublicIpv4PoolResult> createPublicIpv4PoolAsync(CreatePublicIpv4PoolRequest createPublicIpv4PoolRequest,
            com.amazonaws.handlers.AsyncHandler<CreatePublicIpv4PoolRequest, CreatePublicIpv4PoolResult> asyncHandler);

    /**
     * <p>
     * Replaces the EBS-backed root volume for a <code>running</code> instance with a new volume that is restored to the
     * original root volume's launch state, that is restored to a specific snapshot taken from the original root volume,
     * or that is restored from an AMI that has the same key characteristics as that of the instance.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/replace-root.html">Replace
     * a root volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param createReplaceRootVolumeTaskRequest
     * @return A Java Future containing the result of the CreateReplaceRootVolumeTask operation returned by the service.
     * @sample AmazonEC2Async.CreateReplaceRootVolumeTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReplaceRootVolumeTask"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateReplaceRootVolumeTaskResult> createReplaceRootVolumeTaskAsync(
            CreateReplaceRootVolumeTaskRequest createReplaceRootVolumeTaskRequest);

    /**
     * <p>
     * Replaces the EBS-backed root volume for a <code>running</code> instance with a new volume that is restored to the
     * original root volume's launch state, that is restored to a specific snapshot taken from the original root volume,
     * or that is restored from an AMI that has the same key characteristics as that of the instance.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/replace-root.html">Replace
     * a root volume</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param createReplaceRootVolumeTaskRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateReplaceRootVolumeTask operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateReplaceRootVolumeTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReplaceRootVolumeTask"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateReplaceRootVolumeTaskResult> createReplaceRootVolumeTaskAsync(
            CreateReplaceRootVolumeTaskRequest createReplaceRootVolumeTaskRequest,
            com.amazonaws.handlers.AsyncHandler<CreateReplaceRootVolumeTaskRequest, CreateReplaceRootVolumeTaskResult> asyncHandler);

    /**
     * <p>
     * Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance Marketplace. You
     * can submit one Standard Reserved Instance listing at a time. To get a list of your Standard Reserved Instances,
     * you can use the <a>DescribeReservedInstances</a> operation.
     * </p>
     * <note>
     * <p>
     * Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace. Convertible Reserved Instances
     * cannot be sold.
     * </p>
     * </note>
     * <p>
     * The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that
     * they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold
     * through the Reserved Instance Marketplace work like any other Reserved Instances.
     * </p>
     * <p>
     * To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance
     * Marketplace. After completing the registration process, you can create a Reserved Instance Marketplace listing of
     * some or all of your Standard Reserved Instances, and specify the upfront price to receive for them. Your Standard
     * Reserved Instance listings then become available for purchase. To view the details of your Standard Reserved
     * Instance listing, you can use the <a>DescribeReservedInstancesListings</a> operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param createReservedInstancesListingRequest
     *        Contains the parameters for CreateReservedInstancesListing.
     * @return A Java Future containing the result of the CreateReservedInstancesListing operation returned by the
     *         service.
     * @sample AmazonEC2Async.CreateReservedInstancesListing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateReservedInstancesListingResult> createReservedInstancesListingAsync(
            CreateReservedInstancesListingRequest createReservedInstancesListingRequest);

    /**
     * <p>
     * Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance Marketplace. You
     * can submit one Standard Reserved Instance listing at a time. To get a list of your Standard Reserved Instances,
     * you can use the <a>DescribeReservedInstances</a> operation.
     * </p>
     * <note>
     * <p>
     * Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace. Convertible Reserved Instances
     * cannot be sold.
     * </p>
     * </note>
     * <p>
     * The Reserved Instance Marketplace matches sellers who want to resell Standard Reserved Instance capacity that
     * they no longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold
     * through the Reserved Instance Marketplace work like any other Reserved Instances.
     * </p>
     * <p>
     * To sell your Standard Reserved Instances, you must first register as a seller in the Reserved Instance
     * Marketplace. After completing the registration process, you can create a Reserved Instance Marketplace listing of
     * some or all of your Standard Reserved Instances, and specify the upfront price to receive for them. Your Standard
     * Reserved Instance listings then become available for purchase. To view the details of your Standard Reserved
     * Instance listing, you can use the <a>DescribeReservedInstancesListings</a> operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param createReservedInstancesListingRequest
     *        Contains the parameters for CreateReservedInstancesListing.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateReservedInstancesListing operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.CreateReservedInstancesListing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListing"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateReservedInstancesListingResult> createReservedInstancesListingAsync(
            CreateReservedInstancesListingRequest createReservedInstancesListingRequest,
            com.amazonaws.handlers.AsyncHandler<CreateReservedInstancesListingRequest, CreateReservedInstancesListingResult> asyncHandler);

    /**
     * <p>
     * Starts a task that restores an AMI from an Amazon S3 object that was previously created by using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html"
     * >CreateStoreImageTask</a>.
     * </p>
     * <p>
     * To use this API, you must have the required permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions
     * for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param createRestoreImageTaskRequest
     * @return A Java Future containing the result of the CreateRestoreImageTask operation returned by the service.
     * @sample AmazonEC2Async.CreateRestoreImageTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRestoreImageTask" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateRestoreImageTaskResult> createRestoreImageTaskAsync(CreateRestoreImageTaskRequest createRestoreImageTaskRequest);

    /**
     * <p>
     * Starts a task that restores an AMI from an Amazon S3 object that was previously created by using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html"
     * >CreateStoreImageTask</a>.
     * </p>
     * <p>
     * To use this API, you must have the required permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions
     * for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param createRestoreImageTaskRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateRestoreImageTask operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateRestoreImageTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRestoreImageTask" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateRestoreImageTaskResult> createRestoreImageTaskAsync(CreateRestoreImageTaskRequest createRestoreImageTaskRequest,
            com.amazonaws.handlers.AsyncHandler<CreateRestoreImageTaskRequest, CreateRestoreImageTaskResult> asyncHandler);

    /**
     * <p>
     * Creates a route in a route table within a VPC.
     * </p>
     * <p>
     * You must specify either a destination CIDR block or a prefix list ID. You must also specify exactly one of the
     * resources from the parameter list.
     * </p>
     * <p>
     * When determining how to route traffic, we use the route with the most specific match. For example, traffic is
     * destined for the IPv4 address <code>192.0.2.3</code>, and the route table includes the following two IPv4 routes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>192.0.2.0/24</code> (goes to some target A)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>192.0.2.0/28</code> (goes to some target B)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Both routes apply to the traffic destined for <code>192.0.2.3</code>. However, the second route in the list
     * covers a smaller number of IP addresses and is therefore more specific, so we use that route to determine where
     * to target the traffic.
     * </p>
     * <p>
     * For more information about route tables, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     * 
     * @param createRouteRequest
     * @return A Java Future containing the result of the CreateRoute operation returned by the service.
     * @sample AmazonEC2Async.CreateRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateRouteResult> createRouteAsync(CreateRouteRequest createRouteRequest);

    /**
     * <p>
     * Creates a route in a route table within a VPC.
     * </p>
     * <p>
     * You must specify either a destination CIDR block or a prefix list ID. You must also specify exactly one of the
     * resources from the parameter list.
     * </p>
     * <p>
     * When determining how to route traffic, we use the route with the most specific match. For example, traffic is
     * destined for the IPv4 address <code>192.0.2.3</code>, and the route table includes the following two IPv4 routes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>192.0.2.0/24</code> (goes to some target A)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>192.0.2.0/28</code> (goes to some target B)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Both routes apply to the traffic destined for <code>192.0.2.3</code>. However, the second route in the list
     * covers a smaller number of IP addresses and is therefore more specific, so we use that route to determine where
     * to target the traffic.
     * </p>
     * <p>
     * For more information about route tables, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route tables</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     * 
     * @param createRouteRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateRoute operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateRouteResult> createRouteAsync(CreateRouteRequest createRouteRequest,
            com.amazonaws.handlers.AsyncHandler<CreateRouteRequest, CreateRouteResult> asyncHandler);

    /**
     * <p>
     * Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the
     * table with a subnet.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param createRouteTableRequest
     * @return A Java Future containing the result of the CreateRouteTable operation returned by the service.
     * @sample AmazonEC2Async.CreateRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateRouteTableResult> createRouteTableAsync(CreateRouteTableRequest createRouteTableRequest);

    /**
     * <p>
     * Creates a route table for the specified VPC. After you create a route table, you can add routes and associate the
     * table with a subnet.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param createRouteTableRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateRouteTable operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateRouteTableResult> createRouteTableAsync(CreateRouteTableRequest createRouteTableRequest,
            com.amazonaws.handlers.AsyncHandler<CreateRouteTableRequest, CreateRouteTableResult> asyncHandler);

    /**
     * <p>
     * Creates a security group.
     * </p>
     * <p>
     * A security group acts as a virtual firewall for your instance to control inbound and outbound traffic. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon
     * EC2 security groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security groups for your
     * VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * When you create a security group, you specify a friendly name of your choice. You can't have two security groups
     * for the same VPC with the same name.
     * </p>
     * <p>
     * You have a default security group for use in your VPC. If you don't specify a security group when you launch an
     * instance, the instance is launched into the appropriate default security group. A default security group includes
     * a default rule that grants instances unrestricted network access to each other.
     * </p>
     * <p>
     * You can add or remove rules from your security groups using <a>AuthorizeSecurityGroupIngress</a>,
     * <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupIngress</a>, and <a>RevokeSecurityGroupEgress</a>.
     * </p>
     * <p>
     * For more information about VPC security group limits, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits</a>.
     * </p>
     * 
     * @param createSecurityGroupRequest
     * @return A Java Future containing the result of the CreateSecurityGroup operation returned by the service.
     * @sample AmazonEC2Async.CreateSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateSecurityGroupResult> createSecurityGroupAsync(CreateSecurityGroupRequest createSecurityGroupRequest);

    /**
     * <p>
     * Creates a security group.
     * </p>
     * <p>
     * A security group acts as a virtual firewall for your instance to control inbound and outbound traffic. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon
     * EC2 security groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security groups for your
     * VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * When you create a security group, you specify a friendly name of your choice. You can't have two security groups
     * for the same VPC with the same name.
     * </p>
     * <p>
     * You have a default security group for use in your VPC. If you don't specify a security group when you launch an
     * instance, the instance is launched into the appropriate default security group. A default security group includes
     * a default rule that grants instances unrestricted network access to each other.
     * </p>
     * <p>
     * You can add or remove rules from your security groups using <a>AuthorizeSecurityGroupIngress</a>,
     * <a>AuthorizeSecurityGroupEgress</a>, <a>RevokeSecurityGroupIngress</a>, and <a>RevokeSecurityGroupEgress</a>.
     * </p>
     * <p>
     * For more information about VPC security group limits, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html">Amazon VPC Limits</a>.
     * </p>
     * 
     * @param createSecurityGroupRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateSecurityGroup operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateSecurityGroupResult> createSecurityGroupAsync(CreateSecurityGroupRequest createSecurityGroupRequest,
            com.amazonaws.handlers.AsyncHandler<CreateSecurityGroupRequest, CreateSecurityGroupResult> asyncHandler);

    /**
     * <p>
     * Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for backups, to make copies
     * of EBS volumes, and to save data before shutting down an instance.
     * </p>
     * <p>
     * You can create snapshots of volumes in a Region and volumes on an Outpost. If you create a snapshot of a volume
     * in a Region, the snapshot must be stored in the same Region as the volume. If you create a snapshot of a volume
     * on an Outpost, the snapshot can be stored on the same Outpost as the volume, or in the Region for that Outpost.
     * </p>
     * <p>
     * When a snapshot is created, any Amazon Web Services Marketplace product codes that are associated with the source
     * volume are propagated to the snapshot.
     * </p>
     * <p>
     * You can take a snapshot of an attached volume that is in use. However, snapshots only capture data that has been
     * written to your Amazon EBS volume at the time the snapshot command is issued; this might exclude any data that
     * has been cached by any applications or the operating system. If you can pause any file systems on the volume long
     * enough to take a snapshot, your snapshot should be complete. However, if you cannot pause all file writes to the
     * volume, you should unmount the volume from within the instance, issue the snapshot command, and then remount the
     * volume to ensure a consistent and complete snapshot. You may remount and use your volume while the snapshot
     * status is <code>pending</code>.
     * </p>
     * <p>
     * When you create a snapshot for an EBS volume that serves as a root device, we recommend that you stop the
     * instance before taking the snapshot.
     * </p>
     * <p>
     * Snapshots that are taken from encrypted volumes are automatically encrypted. Volumes that are created from
     * encrypted snapshots are also automatically encrypted. Your encrypted volumes and any associated snapshots always
     * remain protected.
     * </p>
     * <p>
     * You can tag your snapshots during creation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/what-is-ebs.html">Amazon
     * Elastic Block Store</a> and <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon
     * EBS encryption</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param createSnapshotRequest
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.
     * @sample AmazonEC2Async.CreateSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateSnapshotResult> createSnapshotAsync(CreateSnapshotRequest createSnapshotRequest);

    /**
     * <p>
     * Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for backups, to make copies
     * of EBS volumes, and to save data before shutting down an instance.
     * </p>
     * <p>
     * You can create snapshots of volumes in a Region and volumes on an Outpost. If you create a snapshot of a volume
     * in a Region, the snapshot must be stored in the same Region as the volume. If you create a snapshot of a volume
     * on an Outpost, the snapshot can be stored on the same Outpost as the volume, or in the Region for that Outpost.
     * </p>
     * <p>
     * When a snapshot is created, any Amazon Web Services Marketplace product codes that are associated with the source
     * volume are propagated to the snapshot.
     * </p>
     * <p>
     * You can take a snapshot of an attached volume that is in use. However, snapshots only capture data that has been
     * written to your Amazon EBS volume at the time the snapshot command is issued; this might exclude any data that
     * has been cached by any applications or the operating system. If you can pause any file systems on the volume long
     * enough to take a snapshot, your snapshot should be complete. However, if you cannot pause all file writes to the
     * volume, you should unmount the volume from within the instance, issue the snapshot command, and then remount the
     * volume to ensure a consistent and complete snapshot. You may remount and use your volume while the snapshot
     * status is <code>pending</code>.
     * </p>
     * <p>
     * When you create a snapshot for an EBS volume that serves as a root device, we recommend that you stop the
     * instance before taking the snapshot.
     * </p>
     * <p>
     * Snapshots that are taken from encrypted volumes are automatically encrypted. Volumes that are created from
     * encrypted snapshots are also automatically encrypted. Your encrypted volumes and any associated snapshots always
     * remain protected.
     * </p>
     * <p>
     * You can tag your snapshots during creation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/what-is-ebs.html">Amazon
     * Elastic Block Store</a> and <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon
     * EBS encryption</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param createSnapshotRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateSnapshotResult> createSnapshotAsync(CreateSnapshotRequest createSnapshotRequest,
            com.amazonaws.handlers.AsyncHandler<CreateSnapshotRequest, CreateSnapshotResult> asyncHandler);

    /**
     * <p>
     * Creates crash-consistent snapshots of multiple EBS volumes and stores the data in S3. Volumes are chosen by
     * specifying an instance. Any attached volumes will produce one snapshot each that is crash-consistent across the
     * instance.
     * </p>
     * <p>
     * You can include all of the volumes currently attached to the instance, or you can exclude the root volume or
     * specific data (non-root) volumes from the multi-volume snapshot set.
     * </p>
     * <p>
     * You can create multi-volume snapshots of instances in a Region and instances on an Outpost. If you create
     * snapshots from an instance in a Region, the snapshots must be stored in the same Region as the instance. If you
     * create snapshots from an instance on an Outpost, the snapshots can be stored on the same Outpost as the instance,
     * or in the Region for that Outpost.
     * </p>
     * 
     * @param createSnapshotsRequest
     * @return A Java Future containing the result of the CreateSnapshots operation returned by the service.
     * @sample AmazonEC2Async.CreateSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateSnapshotsResult> createSnapshotsAsync(CreateSnapshotsRequest createSnapshotsRequest);

    /**
     * <p>
     * Creates crash-consistent snapshots of multiple EBS volumes and stores the data in S3. Volumes are chosen by
     * specifying an instance. Any attached volumes will produce one snapshot each that is crash-consistent across the
     * instance.
     * </p>
     * <p>
     * You can include all of the volumes currently attached to the instance, or you can exclude the root volume or
     * specific data (non-root) volumes from the multi-volume snapshot set.
     * </p>
     * <p>
     * You can create multi-volume snapshots of instances in a Region and instances on an Outpost. If you create
     * snapshots from an instance in a Region, the snapshots must be stored in the same Region as the instance. If you
     * create snapshots from an instance on an Outpost, the snapshots can be stored on the same Outpost as the instance,
     * or in the Region for that Outpost.
     * </p>
     * 
     * @param createSnapshotsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateSnapshots operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateSnapshotsResult> createSnapshotsAsync(CreateSnapshotsRequest createSnapshotsRequest,
            com.amazonaws.handlers.AsyncHandler<CreateSnapshotsRequest, CreateSnapshotsResult> asyncHandler);

    /**
     * <p>
     * Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs. You can create one data
     * feed per Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance data feed</a> in
     * the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * 
     * @param createSpotDatafeedSubscriptionRequest
     *        Contains the parameters for CreateSpotDatafeedSubscription.
     * @return A Java Future containing the result of the CreateSpotDatafeedSubscription operation returned by the
     *         service.
     * @sample AmazonEC2Async.CreateSpotDatafeedSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateSpotDatafeedSubscriptionResult> createSpotDatafeedSubscriptionAsync(
            CreateSpotDatafeedSubscriptionRequest createSpotDatafeedSubscriptionRequest);

    /**
     * <p>
     * Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs. You can create one data
     * feed per Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance data feed</a> in
     * the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * 
     * @param createSpotDatafeedSubscriptionRequest
     *        Contains the parameters for CreateSpotDatafeedSubscription.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateSpotDatafeedSubscription operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.CreateSpotDatafeedSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateSpotDatafeedSubscriptionResult> createSpotDatafeedSubscriptionAsync(
            CreateSpotDatafeedSubscriptionRequest createSpotDatafeedSubscriptionRequest,
            com.amazonaws.handlers.AsyncHandler<CreateSpotDatafeedSubscriptionRequest, CreateSpotDatafeedSubscriptionResult> asyncHandler);

    /**
     * <p>
     * Stores an AMI as a single object in an Amazon S3 bucket.
     * </p>
     * <p>
     * To use this API, you must have the required permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions
     * for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param createStoreImageTaskRequest
     * @return A Java Future containing the result of the CreateStoreImageTask operation returned by the service.
     * @sample AmazonEC2Async.CreateStoreImageTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateStoreImageTask" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateStoreImageTaskResult> createStoreImageTaskAsync(CreateStoreImageTaskRequest createStoreImageTaskRequest);

    /**
     * <p>
     * Stores an AMI as a single object in an Amazon S3 bucket.
     * </p>
     * <p>
     * To use this API, you must have the required permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions
     * for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param createStoreImageTaskRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateStoreImageTask operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateStoreImageTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateStoreImageTask" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateStoreImageTaskResult> createStoreImageTaskAsync(CreateStoreImageTaskRequest createStoreImageTaskRequest,
            com.amazonaws.handlers.AsyncHandler<CreateStoreImageTaskRequest, CreateStoreImageTaskResult> asyncHandler);

    /**
     * <p>
     * Creates a subnet in the specified VPC. For an IPv4 only subnet, specify an IPv4 CIDR block. If the VPC has an
     * IPv6 CIDR block, you can create an IPv6 only subnet or a dual stack subnet instead. For an IPv6 only subnet,
     * specify an IPv6 CIDR block. For a dual stack subnet, specify both an IPv4 CIDR block and an IPv6 CIDR block.
     * </p>
     * <p>
     * A subnet CIDR block must not overlap the CIDR block of an existing subnet in the VPC. After you create a subnet,
     * you can't change its CIDR block.
     * </p>
     * <p>
     * The allowed size for an IPv4 subnet is between a /28 netmask (16 IP addresses) and a /16 netmask (65,536 IP
     * addresses). Amazon Web Services reserves both the first four and the last IPv4 address in each subnet's CIDR
     * block. They're not available for your use.
     * </p>
     * <p>
     * If you've associated an IPv6 CIDR block with your VPC, you can associate an IPv6 CIDR block with a subnet when
     * you create it.
     * </p>
     * <p>
     * If you add more than one subnet to a VPC, they're set up in a star topology with a logical router in the middle.
     * </p>
     * <p>
     * When you stop an instance in a subnet, it retains its private IPv4 address. It's therefore possible to have a
     * subnet with no running instances (they're all stopped), but no remaining IP addresses available.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/configure-subnets.html">Subnets</a> in the <i>Amazon VPC
     * User Guide</i>.
     * </p>
     * 
     * @param createSubnetRequest
     * @return A Java Future containing the result of the CreateSubnet operation returned by the service.
     * @sample AmazonEC2Async.CreateSubnet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateSubnetResult> createSubnetAsync(CreateSubnetRequest createSubnetRequest);

    /**
     * <p>
     * Creates a subnet in the specified VPC. For an IPv4 only subnet, specify an IPv4 CIDR block. If the VPC has an
     * IPv6 CIDR block, you can create an IPv6 only subnet or a dual stack subnet instead. For an IPv6 only subnet,
     * specify an IPv6 CIDR block. For a dual stack subnet, specify both an IPv4 CIDR block and an IPv6 CIDR block.
     * </p>
     * <p>
     * A subnet CIDR block must not overlap the CIDR block of an existing subnet in the VPC. After you create a subnet,
     * you can't change its CIDR block.
     * </p>
     * <p>
     * The allowed size for an IPv4 subnet is between a /28 netmask (16 IP addresses) and a /16 netmask (65,536 IP
     * addresses). Amazon Web Services reserves both the first four and the last IPv4 address in each subnet's CIDR
     * block. They're not available for your use.
     * </p>
     * <p>
     * If you've associated an IPv6 CIDR block with your VPC, you can associate an IPv6 CIDR block with a subnet when
     * you create it.
     * </p>
     * <p>
     * If you add more than one subnet to a VPC, they're set up in a star topology with a logical router in the middle.
     * </p>
     * <p>
     * When you stop an instance in a subnet, it retains its private IPv4 address. It's therefore possible to have a
     * subnet with no running instances (they're all stopped), but no remaining IP addresses available.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/configure-subnets.html">Subnets</a> in the <i>Amazon VPC
     * User Guide</i>.
     * </p>
     * 
     * @param createSubnetRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateSubnet operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateSubnet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateSubnetResult> createSubnetAsync(CreateSubnetRequest createSubnetRequest,
            com.amazonaws.handlers.AsyncHandler<CreateSubnetRequest, CreateSubnetResult> asyncHandler);

    /**
     * <p>
     * Creates a subnet CIDR reservation. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/subnet-cidr-reservation.html">Subnet CIDR reservations</a>
     * in the <i>Amazon Virtual Private Cloud User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html">Assign prefixes to network
     * interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param createSubnetCidrReservationRequest
     * @return A Java Future containing the result of the CreateSubnetCidrReservation operation returned by the service.
     * @sample AmazonEC2Async.CreateSubnetCidrReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnetCidrReservation"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateSubnetCidrReservationResult> createSubnetCidrReservationAsync(
            CreateSubnetCidrReservationRequest createSubnetCidrReservationRequest);

    /**
     * <p>
     * Creates a subnet CIDR reservation. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/subnet-cidr-reservation.html">Subnet CIDR reservations</a>
     * in the <i>Amazon Virtual Private Cloud User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html">Assign prefixes to network
     * interfaces</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param createSubnetCidrReservationRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateSubnetCidrReservation operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateSubnetCidrReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnetCidrReservation"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateSubnetCidrReservationResult> createSubnetCidrReservationAsync(
            CreateSubnetCidrReservationRequest createSubnetCidrReservationRequest,
            com.amazonaws.handlers.AsyncHandler<CreateSubnetCidrReservationRequest, CreateSubnetCidrReservationResult> asyncHandler);

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Amazon EC2 resource or resources. When you specify
     * an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags.
     * Each tag consists of a key and optional value. Tag keys must be unique per resource.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about creating IAM policies that control
     * users' access to resources based on tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html">Supported
     * resource-level permissions for Amazon EC2 API actions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param createTagsRequest
     * @return A Java Future containing the result of the CreateTags operation returned by the service.
     * @sample AmazonEC2Async.CreateTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateTagsResult> createTagsAsync(CreateTagsRequest createTagsRequest);

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Amazon EC2 resource or resources. When you specify
     * an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags.
     * Each tag consists of a key and optional value. Tag keys must be unique per resource.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about creating IAM policies that control
     * users' access to resources based on tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html">Supported
     * resource-level permissions for Amazon EC2 API actions</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param createTagsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateTags operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateTagsResult> createTagsAsync(CreateTagsRequest createTagsRequest,
            com.amazonaws.handlers.AsyncHandler<CreateTagsRequest, CreateTagsResult> asyncHandler);

    /**
     * <p>
     * Creates a Traffic Mirror filter.
     * </p>
     * <p>
     * A Traffic Mirror filter is a set of rules that defines the traffic to mirror.
     * </p>
     * <p>
     * By default, no traffic is mirrored. To mirror traffic, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm"
     * >CreateTrafficMirrorFilterRule</a> to add Traffic Mirror rules to the filter. The rules you add define what
     * traffic gets mirrored. You can also use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html"
     * >ModifyTrafficMirrorFilterNetworkServices</a> to mirror supported network services.
     * </p>
     * 
     * @param createTrafficMirrorFilterRequest
     * @return A Java Future containing the result of the CreateTrafficMirrorFilter operation returned by the service.
     * @sample AmazonEC2Async.CreateTrafficMirrorFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilter" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateTrafficMirrorFilterResult> createTrafficMirrorFilterAsync(
            CreateTrafficMirrorFilterRequest createTrafficMirrorFilterRequest);

    /**
     * <p>
     * Creates a Traffic Mirror filter.
     * </p>
     * <p>
     * A Traffic Mirror filter is a set of rules that defines the traffic to mirror.
     * </p>
     * <p>
     * By default, no traffic is mirrored. To mirror traffic, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm"
     * >CreateTrafficMirrorFilterRule</a> to add Traffic Mirror rules to the filter. The rules you add define what
     * traffic gets mirrored. You can also use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html"
     * >ModifyTrafficMirrorFilterNetworkServices</a> to mirror supported network services.
     * </p>
     * 
     * @param createTrafficMirrorFilterRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateTrafficMirrorFilter operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateTrafficMirrorFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilter" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateTrafficMirrorFilterResult> createTrafficMirrorFilterAsync(
            CreateTrafficMirrorFilterRequest createTrafficMirrorFilterRequest,
            com.amazonaws.handlers.AsyncHandler<CreateTrafficMirrorFilterRequest, CreateTrafficMirrorFilterResult> asyncHandler);

    /**
     * <p>
     * Creates a Traffic Mirror filter rule.
     * </p>
     * <p>
     * A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror.
     * </p>
     * <p>
     * You need the Traffic Mirror filter ID when you create the rule.
     * </p>
     * 
     * @param createTrafficMirrorFilterRuleRequest
     * @return A Java Future containing the result of the CreateTrafficMirrorFilterRule operation returned by the
     *         service.
     * @sample AmazonEC2Async.CreateTrafficMirrorFilterRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRule"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTrafficMirrorFilterRuleResult> createTrafficMirrorFilterRuleAsync(
            CreateTrafficMirrorFilterRuleRequest createTrafficMirrorFilterRuleRequest);

    /**
     * <p>
     * Creates a Traffic Mirror filter rule.
     * </p>
     * <p>
     * A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror.
     * </p>
     * <p>
     * You need the Traffic Mirror filter ID when you create the rule.
     * </p>
     * 
     * @param createTrafficMirrorFilterRuleRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateTrafficMirrorFilterRule operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.CreateTrafficMirrorFilterRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRule"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTrafficMirrorFilterRuleResult> createTrafficMirrorFilterRuleAsync(
            CreateTrafficMirrorFilterRuleRequest createTrafficMirrorFilterRuleRequest,
            com.amazonaws.handlers.AsyncHandler<CreateTrafficMirrorFilterRuleRequest, CreateTrafficMirrorFilterRuleResult> asyncHandler);

    /**
     * <p>
     * Creates a Traffic Mirror session.
     * </p>
     * <p>
     * A Traffic Mirror session actively copies packets from a Traffic Mirror source to a Traffic Mirror target. Create
     * a filter, and then assign it to the session to define a subset of the traffic to mirror, for example all TCP
     * traffic.
     * </p>
     * <p>
     * The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in a
     * different VPC connected via VPC peering or a transit gateway.
     * </p>
     * <p>
     * By default, no traffic is mirrored. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.htm"
     * >CreateTrafficMirrorFilter</a> to create filter rules that specify the traffic to mirror.
     * </p>
     * 
     * @param createTrafficMirrorSessionRequest
     * @return A Java Future containing the result of the CreateTrafficMirrorSession operation returned by the service.
     * @sample AmazonEC2Async.CreateTrafficMirrorSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSession" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateTrafficMirrorSessionResult> createTrafficMirrorSessionAsync(
            CreateTrafficMirrorSessionRequest createTrafficMirrorSessionRequest);

    /**
     * <p>
     * Creates a Traffic Mirror session.
     * </p>
     * <p>
     * A Traffic Mirror session actively copies packets from a Traffic Mirror source to a Traffic Mirror target. Create
     * a filter, and then assign it to the session to define a subset of the traffic to mirror, for example all TCP
     * traffic.
     * </p>
     * <p>
     * The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in a
     * different VPC connected via VPC peering or a transit gateway.
     * </p>
     * <p>
     * By default, no traffic is mirrored. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.htm"
     * >CreateTrafficMirrorFilter</a> to create filter rules that specify the traffic to mirror.
     * </p>
     * 
     * @param createTrafficMirrorSessionRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateTrafficMirrorSession operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateTrafficMirrorSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSession" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateTrafficMirrorSessionResult> createTrafficMirrorSessionAsync(
            CreateTrafficMirrorSessionRequest createTrafficMirrorSessionRequest,
            com.amazonaws.handlers.AsyncHandler<CreateTrafficMirrorSessionRequest, CreateTrafficMirrorSessionResult> asyncHandler);

    /**
     * <p>
     * Creates a target for your Traffic Mirror session.
     * </p>
     * <p>
     * A Traffic Mirror target is the destination for mirrored traffic. The Traffic Mirror source and the Traffic Mirror
     * target (monitoring appliances) can be in the same VPC, or in different VPCs connected via VPC peering or a
     * transit gateway.
     * </p>
     * <p>
     * A Traffic Mirror target can be a network interface, a Network Load Balancer, or a Gateway Load Balancer endpoint.
     * </p>
     * <p>
     * To use the target in a Traffic Mirror session, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm"
     * >CreateTrafficMirrorSession</a>.
     * </p>
     * 
     * @param createTrafficMirrorTargetRequest
     * @return A Java Future containing the result of the CreateTrafficMirrorTarget operation returned by the service.
     * @sample AmazonEC2Async.CreateTrafficMirrorTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTarget" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateTrafficMirrorTargetResult> createTrafficMirrorTargetAsync(
            CreateTrafficMirrorTargetRequest createTrafficMirrorTargetRequest);

    /**
     * <p>
     * Creates a target for your Traffic Mirror session.
     * </p>
     * <p>
     * A Traffic Mirror target is the destination for mirrored traffic. The Traffic Mirror source and the Traffic Mirror
     * target (monitoring appliances) can be in the same VPC, or in different VPCs connected via VPC peering or a
     * transit gateway.
     * </p>
     * <p>
     * A Traffic Mirror target can be a network interface, a Network Load Balancer, or a Gateway Load Balancer endpoint.
     * </p>
     * <p>
     * To use the target in a Traffic Mirror session, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm"
     * >CreateTrafficMirrorSession</a>.
     * </p>
     * 
     * @param createTrafficMirrorTargetRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateTrafficMirrorTarget operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateTrafficMirrorTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTarget" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateTrafficMirrorTargetResult> createTrafficMirrorTargetAsync(
            CreateTrafficMirrorTargetRequest createTrafficMirrorTargetRequest,
            com.amazonaws.handlers.AsyncHandler<CreateTrafficMirrorTargetRequest, CreateTrafficMirrorTargetResult> asyncHandler);

    /**
     * <p>
     * Creates a transit gateway.
     * </p>
     * <p>
     * You can use a transit gateway to interconnect your virtual private clouds (VPC) and on-premises networks. After
     * the transit gateway enters the <code>available</code> state, you can attach your VPCs and VPN connections to the
     * transit gateway.
     * </p>
     * <p>
     * To attach your VPCs, use <a>CreateTransitGatewayVpcAttachment</a>.
     * </p>
     * <p>
     * To attach a VPN connection, use <a>CreateCustomerGateway</a> to create a customer gateway and specify the ID of
     * the customer gateway and the ID of the transit gateway in a call to <a>CreateVpnConnection</a>.
     * </p>
     * <p>
     * When you create a transit gateway, we create a default transit gateway route table and use it as the default
     * association route table and the default propagation route table. You can use
     * <a>CreateTransitGatewayRouteTable</a> to create additional transit gateway route tables. If you disable automatic
     * route propagation, we do not create a default transit gateway route table. You can use
     * <a>EnableTransitGatewayRouteTablePropagation</a> to propagate routes from a resource attachment to a transit
     * gateway route table. If you disable automatic associations, you can use <a>AssociateTransitGatewayRouteTable</a>
     * to associate a resource attachment with a transit gateway route table.
     * </p>
     * 
     * @param createTransitGatewayRequest
     * @return A Java Future containing the result of the CreateTransitGateway operation returned by the service.
     * @sample AmazonEC2Async.CreateTransitGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayResult> createTransitGatewayAsync(CreateTransitGatewayRequest createTransitGatewayRequest);

    /**
     * <p>
     * Creates a transit gateway.
     * </p>
     * <p>
     * You can use a transit gateway to interconnect your virtual private clouds (VPC) and on-premises networks. After
     * the transit gateway enters the <code>available</code> state, you can attach your VPCs and VPN connections to the
     * transit gateway.
     * </p>
     * <p>
     * To attach your VPCs, use <a>CreateTransitGatewayVpcAttachment</a>.
     * </p>
     * <p>
     * To attach a VPN connection, use <a>CreateCustomerGateway</a> to create a customer gateway and specify the ID of
     * the customer gateway and the ID of the transit gateway in a call to <a>CreateVpnConnection</a>.
     * </p>
     * <p>
     * When you create a transit gateway, we create a default transit gateway route table and use it as the default
     * association route table and the default propagation route table. You can use
     * <a>CreateTransitGatewayRouteTable</a> to create additional transit gateway route tables. If you disable automatic
     * route propagation, we do not create a default transit gateway route table. You can use
     * <a>EnableTransitGatewayRouteTablePropagation</a> to propagate routes from a resource attachment to a transit
     * gateway route table. If you disable automatic associations, you can use <a>AssociateTransitGatewayRouteTable</a>
     * to associate a resource attachment with a transit gateway route table.
     * </p>
     * 
     * @param createTransitGatewayRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateTransitGateway operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateTransitGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayResult> createTransitGatewayAsync(CreateTransitGatewayRequest createTransitGatewayRequest,
            com.amazonaws.handlers.AsyncHandler<CreateTransitGatewayRequest, CreateTransitGatewayResult> asyncHandler);

    /**
     * <p>
     * Creates a Connect attachment from a specified transit gateway attachment. A Connect attachment is a GRE-based
     * tunnel attachment that you can use to establish a connection between a transit gateway and an appliance.
     * </p>
     * <p>
     * A Connect attachment uses an existing VPC or Amazon Web Services Direct Connect attachment as the underlying
     * transport mechanism.
     * </p>
     * 
     * @param createTransitGatewayConnectRequest
     * @return A Java Future containing the result of the CreateTransitGatewayConnect operation returned by the service.
     * @sample AmazonEC2Async.CreateTransitGatewayConnect
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnect"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayConnectResult> createTransitGatewayConnectAsync(
            CreateTransitGatewayConnectRequest createTransitGatewayConnectRequest);

    /**
     * <p>
     * Creates a Connect attachment from a specified transit gateway attachment. A Connect attachment is a GRE-based
     * tunnel attachment that you can use to establish a connection between a transit gateway and an appliance.
     * </p>
     * <p>
     * A Connect attachment uses an existing VPC or Amazon Web Services Direct Connect attachment as the underlying
     * transport mechanism.
     * </p>
     * 
     * @param createTransitGatewayConnectRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateTransitGatewayConnect operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateTransitGatewayConnect
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnect"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayConnectResult> createTransitGatewayConnectAsync(
            CreateTransitGatewayConnectRequest createTransitGatewayConnectRequest,
            com.amazonaws.handlers.AsyncHandler<CreateTransitGatewayConnectRequest, CreateTransitGatewayConnectResult> asyncHandler);

    /**
     * <p>
     * Creates a Connect peer for a specified transit gateway Connect attachment between a transit gateway and an
     * appliance.
     * </p>
     * <p>
     * The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html#tgw-connect-peer">Connect peers</a> in the
     * <i>Transit Gateways Guide</i>.
     * </p>
     * 
     * @param createTransitGatewayConnectPeerRequest
     * @return A Java Future containing the result of the CreateTransitGatewayConnectPeer operation returned by the
     *         service.
     * @sample AmazonEC2Async.CreateTransitGatewayConnectPeer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayConnectPeerResult> createTransitGatewayConnectPeerAsync(
            CreateTransitGatewayConnectPeerRequest createTransitGatewayConnectPeerRequest);

    /**
     * <p>
     * Creates a Connect peer for a specified transit gateway Connect attachment between a transit gateway and an
     * appliance.
     * </p>
     * <p>
     * The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html#tgw-connect-peer">Connect peers</a> in the
     * <i>Transit Gateways Guide</i>.
     * </p>
     * 
     * @param createTransitGatewayConnectPeerRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateTransitGatewayConnectPeer operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.CreateTransitGatewayConnectPeer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayConnectPeerResult> createTransitGatewayConnectPeerAsync(
            CreateTransitGatewayConnectPeerRequest createTransitGatewayConnectPeerRequest,
            com.amazonaws.handlers.AsyncHandler<CreateTransitGatewayConnectPeerRequest, CreateTransitGatewayConnectPeerResult> asyncHandler);

    /**
     * <p>
     * Creates a multicast domain using the specified transit gateway.
     * </p>
     * <p>
     * The transit gateway must be in the available state before you create a domain. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html"
     * >DescribeTransitGateways</a> to see the state of transit gateway.
     * </p>
     * 
     * @param createTransitGatewayMulticastDomainRequest
     * @return A Java Future containing the result of the CreateTransitGatewayMulticastDomain operation returned by the
     *         service.
     * @sample AmazonEC2Async.CreateTransitGatewayMulticastDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayMulticastDomainResult> createTransitGatewayMulticastDomainAsync(
            CreateTransitGatewayMulticastDomainRequest createTransitGatewayMulticastDomainRequest);

    /**
     * <p>
     * Creates a multicast domain using the specified transit gateway.
     * </p>
     * <p>
     * The transit gateway must be in the available state before you create a domain. Use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html"
     * >DescribeTransitGateways</a> to see the state of transit gateway.
     * </p>
     * 
     * @param createTransitGatewayMulticastDomainRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateTransitGatewayMulticastDomain operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.CreateTransitGatewayMulticastDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayMulticastDomainResult> createTransitGatewayMulticastDomainAsync(
            CreateTransitGatewayMulticastDomainRequest createTransitGatewayMulticastDomainRequest,
            com.amazonaws.handlers.AsyncHandler<CreateTransitGatewayMulticastDomainRequest, CreateTransitGatewayMulticastDomainResult> asyncHandler);

    /**
     * <p>
     * Requests a transit gateway peering attachment between the specified transit gateway (requester) and a peer
     * transit gateway (accepter). The peer transit gateway can be in your account or a different Amazon Web Services
     * account.
     * </p>
     * <p>
     * After you create the peering attachment, the owner of the accepter transit gateway must accept the attachment
     * request.
     * </p>
     * 
     * @param createTransitGatewayPeeringAttachmentRequest
     * @return A Java Future containing the result of the CreateTransitGatewayPeeringAttachment operation returned by
     *         the service.
     * @sample AmazonEC2Async.CreateTransitGatewayPeeringAttachment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayPeeringAttachmentResult> createTransitGatewayPeeringAttachmentAsync(
            CreateTransitGatewayPeeringAttachmentRequest createTransitGatewayPeeringAttachmentRequest);

    /**
     * <p>
     * Requests a transit gateway peering attachment between the specified transit gateway (requester) and a peer
     * transit gateway (accepter). The peer transit gateway can be in your account or a different Amazon Web Services
     * account.
     * </p>
     * <p>
     * After you create the peering attachment, the owner of the accepter transit gateway must accept the attachment
     * request.
     * </p>
     * 
     * @param createTransitGatewayPeeringAttachmentRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateTransitGatewayPeeringAttachment operation returned by
     *         the service.
     * @sample AmazonEC2AsyncHandler.CreateTransitGatewayPeeringAttachment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayPeeringAttachmentResult> createTransitGatewayPeeringAttachmentAsync(
            CreateTransitGatewayPeeringAttachmentRequest createTransitGatewayPeeringAttachmentRequest,
            com.amazonaws.handlers.AsyncHandler<CreateTransitGatewayPeeringAttachmentRequest, CreateTransitGatewayPeeringAttachmentResult> asyncHandler);

    /**
     * <p>
     * Creates a transit gateway policy table.
     * </p>
     * 
     * @param createTransitGatewayPolicyTableRequest
     * @return A Java Future containing the result of the CreateTransitGatewayPolicyTable operation returned by the
     *         service.
     * @sample AmazonEC2Async.CreateTransitGatewayPolicyTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPolicyTable"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayPolicyTableResult> createTransitGatewayPolicyTableAsync(
            CreateTransitGatewayPolicyTableRequest createTransitGatewayPolicyTableRequest);

    /**
     * <p>
     * Creates a transit gateway policy table.
     * </p>
     * 
     * @param createTransitGatewayPolicyTableRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateTransitGatewayPolicyTable operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.CreateTransitGatewayPolicyTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPolicyTable"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayPolicyTableResult> createTransitGatewayPolicyTableAsync(
            CreateTransitGatewayPolicyTableRequest createTransitGatewayPolicyTableRequest,
            com.amazonaws.handlers.AsyncHandler<CreateTransitGatewayPolicyTableRequest, CreateTransitGatewayPolicyTableResult> asyncHandler);

    /**
     * <p>
     * Creates a reference (route) to a prefix list in a specified transit gateway route table.
     * </p>
     * 
     * @param createTransitGatewayPrefixListReferenceRequest
     * @return A Java Future containing the result of the CreateTransitGatewayPrefixListReference operation returned by
     *         the service.
     * @sample AmazonEC2Async.CreateTransitGatewayPrefixListReference
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPrefixListReference"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayPrefixListReferenceResult> createTransitGatewayPrefixListReferenceAsync(
            CreateTransitGatewayPrefixListReferenceRequest createTransitGatewayPrefixListReferenceRequest);

    /**
     * <p>
     * Creates a reference (route) to a prefix list in a specified transit gateway route table.
     * </p>
     * 
     * @param createTransitGatewayPrefixListReferenceRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateTransitGatewayPrefixListReference operation returned by
     *         the service.
     * @sample AmazonEC2AsyncHandler.CreateTransitGatewayPrefixListReference
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPrefixListReference"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayPrefixListReferenceResult> createTransitGatewayPrefixListReferenceAsync(
            CreateTransitGatewayPrefixListReferenceRequest createTransitGatewayPrefixListReferenceRequest,
            com.amazonaws.handlers.AsyncHandler<CreateTransitGatewayPrefixListReferenceRequest, CreateTransitGatewayPrefixListReferenceResult> asyncHandler);

    /**
     * <p>
     * Creates a static route for the specified transit gateway route table.
     * </p>
     * 
     * @param createTransitGatewayRouteRequest
     * @return A Java Future containing the result of the CreateTransitGatewayRoute operation returned by the service.
     * @sample AmazonEC2Async.CreateTransitGatewayRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayRouteResult> createTransitGatewayRouteAsync(
            CreateTransitGatewayRouteRequest createTransitGatewayRouteRequest);

    /**
     * <p>
     * Creates a static route for the specified transit gateway route table.
     * </p>
     * 
     * @param createTransitGatewayRouteRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateTransitGatewayRoute operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateTransitGatewayRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayRouteResult> createTransitGatewayRouteAsync(
            CreateTransitGatewayRouteRequest createTransitGatewayRouteRequest,
            com.amazonaws.handlers.AsyncHandler<CreateTransitGatewayRouteRequest, CreateTransitGatewayRouteResult> asyncHandler);

    /**
     * <p>
     * Creates a route table for the specified transit gateway.
     * </p>
     * 
     * @param createTransitGatewayRouteTableRequest
     * @return A Java Future containing the result of the CreateTransitGatewayRouteTable operation returned by the
     *         service.
     * @sample AmazonEC2Async.CreateTransitGatewayRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayRouteTableResult> createTransitGatewayRouteTableAsync(
            CreateTransitGatewayRouteTableRequest createTransitGatewayRouteTableRequest);

    /**
     * <p>
     * Creates a route table for the specified transit gateway.
     * </p>
     * 
     * @param createTransitGatewayRouteTableRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateTransitGatewayRouteTable operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.CreateTransitGatewayRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayRouteTableResult> createTransitGatewayRouteTableAsync(
            CreateTransitGatewayRouteTableRequest createTransitGatewayRouteTableRequest,
            com.amazonaws.handlers.AsyncHandler<CreateTransitGatewayRouteTableRequest, CreateTransitGatewayRouteTableResult> asyncHandler);

    /**
     * <p>
     * Advertises a new transit gateway route table.
     * </p>
     * 
     * @param createTransitGatewayRouteTableAnnouncementRequest
     * @return A Java Future containing the result of the CreateTransitGatewayRouteTableAnnouncement operation returned
     *         by the service.
     * @sample AmazonEC2Async.CreateTransitGatewayRouteTableAnnouncement
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTableAnnouncement"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayRouteTableAnnouncementResult> createTransitGatewayRouteTableAnnouncementAsync(
            CreateTransitGatewayRouteTableAnnouncementRequest createTransitGatewayRouteTableAnnouncementRequest);

    /**
     * <p>
     * Advertises a new transit gateway route table.
     * </p>
     * 
     * @param createTransitGatewayRouteTableAnnouncementRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateTransitGatewayRouteTableAnnouncement operation returned
     *         by the service.
     * @sample AmazonEC2AsyncHandler.CreateTransitGatewayRouteTableAnnouncement
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTableAnnouncement"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayRouteTableAnnouncementResult> createTransitGatewayRouteTableAnnouncementAsync(
            CreateTransitGatewayRouteTableAnnouncementRequest createTransitGatewayRouteTableAnnouncementRequest,
            com.amazonaws.handlers.AsyncHandler<CreateTransitGatewayRouteTableAnnouncementRequest, CreateTransitGatewayRouteTableAnnouncementResult> asyncHandler);

    /**
     * <p>
     * Attaches the specified VPC to the specified transit gateway.
     * </p>
     * <p>
     * If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC that is already attached, the new VPC
     * CIDR range is not propagated to the default propagation route table.
     * </p>
     * <p>
     * To send VPC traffic to an attached transit gateway, add a route to the VPC route table using <a>CreateRoute</a>.
     * </p>
     * 
     * @param createTransitGatewayVpcAttachmentRequest
     * @return A Java Future containing the result of the CreateTransitGatewayVpcAttachment operation returned by the
     *         service.
     * @sample AmazonEC2Async.CreateTransitGatewayVpcAttachment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayVpcAttachmentResult> createTransitGatewayVpcAttachmentAsync(
            CreateTransitGatewayVpcAttachmentRequest createTransitGatewayVpcAttachmentRequest);

    /**
     * <p>
     * Attaches the specified VPC to the specified transit gateway.
     * </p>
     * <p>
     * If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC that is already attached, the new VPC
     * CIDR range is not propagated to the default propagation route table.
     * </p>
     * <p>
     * To send VPC traffic to an attached transit gateway, add a route to the VPC route table using <a>CreateRoute</a>.
     * </p>
     * 
     * @param createTransitGatewayVpcAttachmentRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateTransitGatewayVpcAttachment operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.CreateTransitGatewayVpcAttachment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateTransitGatewayVpcAttachmentResult> createTransitGatewayVpcAttachmentAsync(
            CreateTransitGatewayVpcAttachmentRequest createTransitGatewayVpcAttachmentRequest,
            com.amazonaws.handlers.AsyncHandler<CreateTransitGatewayVpcAttachmentRequest, CreateTransitGatewayVpcAttachmentResult> asyncHandler);

    /**
     * <p>
     * An Amazon Web Services Verified Access endpoint is where you define your application along with an optional
     * endpoint-level access policy.
     * </p>
     * 
     * @param createVerifiedAccessEndpointRequest
     * @return A Java Future containing the result of the CreateVerifiedAccessEndpoint operation returned by the
     *         service.
     * @sample AmazonEC2Async.CreateVerifiedAccessEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateVerifiedAccessEndpointResult> createVerifiedAccessEndpointAsync(
            CreateVerifiedAccessEndpointRequest createVerifiedAccessEndpointRequest);

    /**
     * <p>
     * An Amazon Web Services Verified Access endpoint is where you define your application along with an optional
     * endpoint-level access policy.
     * </p>
     * 
     * @param createVerifiedAccessEndpointRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateVerifiedAccessEndpoint operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.CreateVerifiedAccessEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateVerifiedAccessEndpointResult> createVerifiedAccessEndpointAsync(
            CreateVerifiedAccessEndpointRequest createVerifiedAccessEndpointRequest,
            com.amazonaws.handlers.AsyncHandler<CreateVerifiedAccessEndpointRequest, CreateVerifiedAccessEndpointResult> asyncHandler);

    /**
     * <p>
     * An Amazon Web Services Verified Access group is a collection of Amazon Web Services Verified Access endpoints
     * who's associated applications have similar security requirements. Each instance within a Verified Access group
     * shares an Verified Access policy. For example, you can group all Verified Access instances associated with
     * "sales" applications together and use one common Verified Access policy.
     * </p>
     * 
     * @param createVerifiedAccessGroupRequest
     * @return A Java Future containing the result of the CreateVerifiedAccessGroup operation returned by the service.
     * @sample AmazonEC2Async.CreateVerifiedAccessGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessGroup" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateVerifiedAccessGroupResult> createVerifiedAccessGroupAsync(
            CreateVerifiedAccessGroupRequest createVerifiedAccessGroupRequest);

    /**
     * <p>
     * An Amazon Web Services Verified Access group is a collection of Amazon Web Services Verified Access endpoints
     * who's associated applications have similar security requirements. Each instance within a Verified Access group
     * shares an Verified Access policy. For example, you can group all Verified Access instances associated with
     * "sales" applications together and use one common Verified Access policy.
     * </p>
     * 
     * @param createVerifiedAccessGroupRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateVerifiedAccessGroup operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateVerifiedAccessGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessGroup" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateVerifiedAccessGroupResult> createVerifiedAccessGroupAsync(
            CreateVerifiedAccessGroupRequest createVerifiedAccessGroupRequest,
            com.amazonaws.handlers.AsyncHandler<CreateVerifiedAccessGroupRequest, CreateVerifiedAccessGroupResult> asyncHandler);

    /**
     * <p>
     * An Amazon Web Services Verified Access instance is a regional entity that evaluates application requests and
     * grants access only when your security requirements are met.
     * </p>
     * 
     * @param createVerifiedAccessInstanceRequest
     * @return A Java Future containing the result of the CreateVerifiedAccessInstance operation returned by the
     *         service.
     * @sample AmazonEC2Async.CreateVerifiedAccessInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessInstance"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateVerifiedAccessInstanceResult> createVerifiedAccessInstanceAsync(
            CreateVerifiedAccessInstanceRequest createVerifiedAccessInstanceRequest);

    /**
     * <p>
     * An Amazon Web Services Verified Access instance is a regional entity that evaluates application requests and
     * grants access only when your security requirements are met.
     * </p>
     * 
     * @param createVerifiedAccessInstanceRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateVerifiedAccessInstance operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.CreateVerifiedAccessInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessInstance"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateVerifiedAccessInstanceResult> createVerifiedAccessInstanceAsync(
            CreateVerifiedAccessInstanceRequest createVerifiedAccessInstanceRequest,
            com.amazonaws.handlers.AsyncHandler<CreateVerifiedAccessInstanceRequest, CreateVerifiedAccessInstanceResult> asyncHandler);

    /**
     * <p>
     * A trust provider is a third-party entity that creates, maintains, and manages identity information for users and
     * devices. When an application request is made, the identity information sent by the trust provider is evaluated by
     * Verified Access before allowing or denying the application request.
     * </p>
     * 
     * @param createVerifiedAccessTrustProviderRequest
     * @return A Java Future containing the result of the CreateVerifiedAccessTrustProvider operation returned by the
     *         service.
     * @sample AmazonEC2Async.CreateVerifiedAccessTrustProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessTrustProvider"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateVerifiedAccessTrustProviderResult> createVerifiedAccessTrustProviderAsync(
            CreateVerifiedAccessTrustProviderRequest createVerifiedAccessTrustProviderRequest);

    /**
     * <p>
     * A trust provider is a third-party entity that creates, maintains, and manages identity information for users and
     * devices. When an application request is made, the identity information sent by the trust provider is evaluated by
     * Verified Access before allowing or denying the application request.
     * </p>
     * 
     * @param createVerifiedAccessTrustProviderRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateVerifiedAccessTrustProvider operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.CreateVerifiedAccessTrustProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessTrustProvider"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateVerifiedAccessTrustProviderResult> createVerifiedAccessTrustProviderAsync(
            CreateVerifiedAccessTrustProviderRequest createVerifiedAccessTrustProviderRequest,
            com.amazonaws.handlers.AsyncHandler<CreateVerifiedAccessTrustProviderRequest, CreateVerifiedAccessTrustProviderResult> asyncHandler);

    /**
     * <p>
     * Creates an EBS volume that can be attached to an instance in the same Availability Zone.
     * </p>
     * <p>
     * You can create a new empty volume or restore a volume from an EBS snapshot. Any Amazon Web Services Marketplace
     * product codes from the snapshot are propagated to the volume.
     * </p>
     * <p>
     * You can create encrypted volumes. Encrypted volumes must be attached to instances that support Amazon EBS
     * encryption. Volumes that are created from encrypted snapshots are also automatically encrypted. For more
     * information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS
     * encryption</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * You can tag your volumes during creation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-creating-volume.html">Create an Amazon EBS volume</a>
     * in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param createVolumeRequest
     * @return A Java Future containing the result of the CreateVolume operation returned by the service.
     * @sample AmazonEC2Async.CreateVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolume" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateVolumeResult> createVolumeAsync(CreateVolumeRequest createVolumeRequest);

    /**
     * <p>
     * Creates an EBS volume that can be attached to an instance in the same Availability Zone.
     * </p>
     * <p>
     * You can create a new empty volume or restore a volume from an EBS snapshot. Any Amazon Web Services Marketplace
     * product codes from the snapshot are propagated to the volume.
     * </p>
     * <p>
     * You can create encrypted volumes. Encrypted volumes must be attached to instances that support Amazon EBS
     * encryption. Volumes that are created from encrypted snapshots are also automatically encrypted. For more
     * information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html">Amazon EBS
     * encryption</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * You can tag your volumes during creation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-creating-volume.html">Create an Amazon EBS volume</a>
     * in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param createVolumeRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateVolume operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolume" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateVolumeResult> createVolumeAsync(CreateVolumeRequest createVolumeRequest,
            com.amazonaws.handlers.AsyncHandler<CreateVolumeRequest, CreateVolumeResult> asyncHandler);

    /**
     * <p>
     * Creates a VPC with the specified CIDR blocks. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html">IP addressing for your VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * You can optionally request an IPv6 CIDR block for the VPC. You can request an Amazon-provided IPv6 CIDR block
     * from Amazon's pool of IPv6 addresses or an IPv6 CIDR block from an IPv6 address pool that you provisioned through
     * bring your own IP addresses (<a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>).
     * </p>
     * <p>
     * By default, each instance that you launch in the VPC has the default DHCP options, which include only a default
     * DNS server that we provide (AmazonProvidedDNS). For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP option sets</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * You can specify the instance tenancy value for the VPC when you create it. You can't change this value for the
     * VPC after you create it. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param createVpcRequest
     * @return A Java Future containing the result of the CreateVpc operation returned by the service.
     * @sample AmazonEC2Async.CreateVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpc" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateVpcResult> createVpcAsync(CreateVpcRequest createVpcRequest);

    /**
     * <p>
     * Creates a VPC with the specified CIDR blocks. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html">IP addressing for your VPCs and
     * subnets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * You can optionally request an IPv6 CIDR block for the VPC. You can request an Amazon-provided IPv6 CIDR block
     * from Amazon's pool of IPv6 addresses or an IPv6 CIDR block from an IPv6 address pool that you provisioned through
     * bring your own IP addresses (<a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html">BYOIP</a>).
     * </p>
     * <p>
     * By default, each instance that you launch in the VPC has the default DHCP options, which include only a default
     * DNS server that we provide (AmazonProvidedDNS). For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP option sets</a> in the
     * <i>Amazon VPC User Guide</i>.
     * </p>
     * <p>
     * You can specify the instance tenancy value for the VPC when you create it. You can't change this value for the
     * VPC after you create it. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param createVpcRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateVpc operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpc" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateVpcResult> createVpcAsync(CreateVpcRequest createVpcRequest,
            com.amazonaws.handlers.AsyncHandler<CreateVpcRequest, CreateVpcResult> asyncHandler);

    /**
     * <p>
     * Creates a VPC endpoint. A VPC endpoint provides a private connection between the specified VPC and the specified
     * endpoint service. You can use an endpoint service provided by Amazon Web Services, an Amazon Web Services
     * Marketplace Partner, or another Amazon Web Services account. For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services PrivateLink User Guide</a>.
     * </p>
     * 
     * @param createVpcEndpointRequest
     * @return A Java Future containing the result of the CreateVpcEndpoint operation returned by the service.
     * @sample AmazonEC2Async.CreateVpcEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateVpcEndpointResult> createVpcEndpointAsync(CreateVpcEndpointRequest createVpcEndpointRequest);

    /**
     * <p>
     * Creates a VPC endpoint. A VPC endpoint provides a private connection between the specified VPC and the specified
     * endpoint service. You can use an endpoint service provided by Amazon Web Services, an Amazon Web Services
     * Marketplace Partner, or another Amazon Web Services account. For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services PrivateLink User Guide</a>.
     * </p>
     * 
     * @param createVpcEndpointRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateVpcEndpoint operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateVpcEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateVpcEndpointResult> createVpcEndpointAsync(CreateVpcEndpointRequest createVpcEndpointRequest,
            com.amazonaws.handlers.AsyncHandler<CreateVpcEndpointRequest, CreateVpcEndpointResult> asyncHandler);

    /**
     * <p>
     * Creates a connection notification for a specified VPC endpoint or VPC endpoint service. A connection notification
     * notifies you of specific endpoint events. You must create an SNS topic to receive notifications. For more
     * information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Create a Topic</a> in the
     * <i>Amazon Simple Notification Service Developer Guide</i>.
     * </p>
     * <p>
     * You can create a connection notification for interface endpoints only.
     * </p>
     * 
     * @param createVpcEndpointConnectionNotificationRequest
     * @return A Java Future containing the result of the CreateVpcEndpointConnectionNotification operation returned by
     *         the service.
     * @sample AmazonEC2Async.CreateVpcEndpointConnectionNotification
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointConnectionNotification"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateVpcEndpointConnectionNotificationResult> createVpcEndpointConnectionNotificationAsync(
            CreateVpcEndpointConnectionNotificationRequest createVpcEndpointConnectionNotificationRequest);

    /**
     * <p>
     * Creates a connection notification for a specified VPC endpoint or VPC endpoint service. A connection notification
     * notifies you of specific endpoint events. You must create an SNS topic to receive notifications. For more
     * information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Create a Topic</a> in the
     * <i>Amazon Simple Notification Service Developer Guide</i>.
     * </p>
     * <p>
     * You can create a connection notification for interface endpoints only.
     * </p>
     * 
     * @param createVpcEndpointConnectionNotificationRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateVpcEndpointConnectionNotification operation returned by
     *         the service.
     * @sample AmazonEC2AsyncHandler.CreateVpcEndpointConnectionNotification
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointConnectionNotification"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateVpcEndpointConnectionNotificationResult> createVpcEndpointConnectionNotificationAsync(
            CreateVpcEndpointConnectionNotificationRequest createVpcEndpointConnectionNotificationRequest,
            com.amazonaws.handlers.AsyncHandler<CreateVpcEndpointConnectionNotificationRequest, CreateVpcEndpointConnectionNotificationResult> asyncHandler);

    /**
     * <p>
     * Creates a VPC endpoint service to which service consumers (Amazon Web Services accounts, users, and IAM roles)
     * can connect.
     * </p>
     * <p>
     * Before you create an endpoint service, you must create one of the following for your service:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/">Network Load Balancer</a>. Service
     * consumers connect to your service using an interface endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/">Gateway Load Balancer</a>. Service
     * consumers connect to your service using a Gateway Load Balancer endpoint.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set the private DNS name, you must prove that you own the private DNS domain name.
     * </p>
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services
     * PrivateLink Guide</a>.
     * </p>
     * 
     * @param createVpcEndpointServiceConfigurationRequest
     * @return A Java Future containing the result of the CreateVpcEndpointServiceConfiguration operation returned by
     *         the service.
     * @sample AmazonEC2Async.CreateVpcEndpointServiceConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointServiceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateVpcEndpointServiceConfigurationResult> createVpcEndpointServiceConfigurationAsync(
            CreateVpcEndpointServiceConfigurationRequest createVpcEndpointServiceConfigurationRequest);

    /**
     * <p>
     * Creates a VPC endpoint service to which service consumers (Amazon Web Services accounts, users, and IAM roles)
     * can connect.
     * </p>
     * <p>
     * Before you create an endpoint service, you must create one of the following for your service:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/">Network Load Balancer</a>. Service
     * consumers connect to your service using an interface endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/">Gateway Load Balancer</a>. Service
     * consumers connect to your service using a Gateway Load Balancer endpoint.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set the private DNS name, you must prove that you own the private DNS domain name.
     * </p>
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/vpc/latest/privatelink/">Amazon Web Services
     * PrivateLink Guide</a>.
     * </p>
     * 
     * @param createVpcEndpointServiceConfigurationRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateVpcEndpointServiceConfiguration operation returned by
     *         the service.
     * @sample AmazonEC2AsyncHandler.CreateVpcEndpointServiceConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointServiceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<CreateVpcEndpointServiceConfigurationResult> createVpcEndpointServiceConfigurationAsync(
            CreateVpcEndpointServiceConfigurationRequest createVpcEndpointServiceConfigurationRequest,
            com.amazonaws.handlers.AsyncHandler<CreateVpcEndpointServiceConfigurationRequest, CreateVpcEndpointServiceConfigurationResult> asyncHandler);

    /**
     * <p>
     * Requests a VPC peering connection between two VPCs: a requester VPC that you own and an accepter VPC with which
     * to create the connection. The accepter VPC can belong to another Amazon Web Services account and can be in a
     * different Region to the requester VPC. The requester VPC and accepter VPC cannot have overlapping CIDR blocks.
     * </p>
     * <note>
     * <p>
     * Limitations and rules apply to a VPC peering connection. For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations"
     * >limitations</a> section in the <i>VPC Peering Guide</i>.
     * </p>
     * </note>
     * <p>
     * The owner of the accepter VPC must accept the peering request to activate the peering connection. The VPC peering
     * connection request expires after 7 days, after which it cannot be accepted or rejected.
     * </p>
     * <p>
     * If you create a VPC peering connection request between VPCs with overlapping CIDR blocks, the VPC peering
     * connection has a status of <code>failed</code>.
     * </p>
     * 
     * @param createVpcPeeringConnectionRequest
     * @return A Java Future containing the result of the CreateVpcPeeringConnection operation returned by the service.
     * @sample AmazonEC2Async.CreateVpcPeeringConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnection" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateVpcPeeringConnectionResult> createVpcPeeringConnectionAsync(
            CreateVpcPeeringConnectionRequest createVpcPeeringConnectionRequest);

    /**
     * <p>
     * Requests a VPC peering connection between two VPCs: a requester VPC that you own and an accepter VPC with which
     * to create the connection. The accepter VPC can belong to another Amazon Web Services account and can be in a
     * different Region to the requester VPC. The requester VPC and accepter VPC cannot have overlapping CIDR blocks.
     * </p>
     * <note>
     * <p>
     * Limitations and rules apply to a VPC peering connection. For more information, see the <a
     * href="https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations"
     * >limitations</a> section in the <i>VPC Peering Guide</i>.
     * </p>
     * </note>
     * <p>
     * The owner of the accepter VPC must accept the peering request to activate the peering connection. The VPC peering
     * connection request expires after 7 days, after which it cannot be accepted or rejected.
     * </p>
     * <p>
     * If you create a VPC peering connection request between VPCs with overlapping CIDR blocks, the VPC peering
     * connection has a status of <code>failed</code>.
     * </p>
     * 
     * @param createVpcPeeringConnectionRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateVpcPeeringConnection operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateVpcPeeringConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnection" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateVpcPeeringConnectionResult> createVpcPeeringConnectionAsync(
            CreateVpcPeeringConnectionRequest createVpcPeeringConnectionRequest,
            com.amazonaws.handlers.AsyncHandler<CreateVpcPeeringConnectionRequest, CreateVpcPeeringConnectionResult> asyncHandler);

    /**
     * Simplified method form for invoking the CreateVpcPeeringConnection operation.
     *
     * @see #createVpcPeeringConnectionAsync(CreateVpcPeeringConnectionRequest)
     */
    java.util.concurrent.Future<CreateVpcPeeringConnectionResult> createVpcPeeringConnectionAsync();

    /**
     * Simplified method form for invoking the CreateVpcPeeringConnection operation with an AsyncHandler.
     *
     * @see #createVpcPeeringConnectionAsync(CreateVpcPeeringConnectionRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<CreateVpcPeeringConnectionResult> createVpcPeeringConnectionAsync(
            com.amazonaws.handlers.AsyncHandler<CreateVpcPeeringConnectionRequest, CreateVpcPeeringConnectionResult> asyncHandler);

    /**
     * <p>
     * Creates a VPN connection between an existing virtual private gateway or transit gateway and a customer gateway.
     * The supported connection type is <code>ipsec.1</code>.
     * </p>
     * <p>
     * The response includes information that you need to give to your network administrator to configure your customer
     * gateway.
     * </p>
     * <important>
     * <p>
     * We strongly recommend that you use HTTPS when calling this operation because the response contains sensitive
     * cryptographic information for configuring your customer gateway device.
     * </p>
     * </important>
     * <p>
     * If you decide to shut down your VPN connection for any reason and later create a new VPN connection, you must
     * reconfigure your customer gateway with the new information returned from this call.
     * </p>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * 
     * @param createVpnConnectionRequest
     *        Contains the parameters for CreateVpnConnection.
     * @return A Java Future containing the result of the CreateVpnConnection operation returned by the service.
     * @sample AmazonEC2Async.CreateVpnConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnection" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateVpnConnectionResult> createVpnConnectionAsync(CreateVpnConnectionRequest createVpnConnectionRequest);

    /**
     * <p>
     * Creates a VPN connection between an existing virtual private gateway or transit gateway and a customer gateway.
     * The supported connection type is <code>ipsec.1</code>.
     * </p>
     * <p>
     * The response includes information that you need to give to your network administrator to configure your customer
     * gateway.
     * </p>
     * <important>
     * <p>
     * We strongly recommend that you use HTTPS when calling this operation because the response contains sensitive
     * cryptographic information for configuring your customer gateway device.
     * </p>
     * </important>
     * <p>
     * If you decide to shut down your VPN connection for any reason and later create a new VPN connection, you must
     * reconfigure your customer gateway with the new information returned from this call.
     * </p>
     * <p>
     * This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * 
     * @param createVpnConnectionRequest
     *        Contains the parameters for CreateVpnConnection.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateVpnConnection operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateVpnConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnection" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateVpnConnectionResult> createVpnConnectionAsync(CreateVpnConnectionRequest createVpnConnectionRequest,
            com.amazonaws.handlers.AsyncHandler<CreateVpnConnectionRequest, CreateVpnConnectionResult> asyncHandler);

    /**
     * <p>
     * Creates a static route associated with a VPN connection between an existing virtual private gateway and a VPN
     * customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN
     * customer gateway.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * 
     * @param createVpnConnectionRouteRequest
     *        Contains the parameters for CreateVpnConnectionRoute.
     * @return A Java Future containing the result of the CreateVpnConnectionRoute operation returned by the service.
     * @sample AmazonEC2Async.CreateVpnConnectionRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRoute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateVpnConnectionRouteResult> createVpnConnectionRouteAsync(CreateVpnConnectionRouteRequest createVpnConnectionRouteRequest);

    /**
     * <p>
     * Creates a static route associated with a VPN connection between an existing virtual private gateway and a VPN
     * customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN
     * customer gateway.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * 
     * @param createVpnConnectionRouteRequest
     *        Contains the parameters for CreateVpnConnectionRoute.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateVpnConnectionRoute operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateVpnConnectionRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRoute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<CreateVpnConnectionRouteResult> createVpnConnectionRouteAsync(CreateVpnConnectionRouteRequest createVpnConnectionRouteRequest,
            com.amazonaws.handlers.AsyncHandler<CreateVpnConnectionRouteRequest, CreateVpnConnectionRouteResult> asyncHandler);

    /**
     * <p>
     * Creates a virtual private gateway. A virtual private gateway is the endpoint on the VPC side of your VPN
     * connection. You can create a virtual private gateway before creating the VPC itself.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * 
     * @param createVpnGatewayRequest
     *        Contains the parameters for CreateVpnGateway.
     * @return A Java Future containing the result of the CreateVpnGateway operation returned by the service.
     * @sample AmazonEC2Async.CreateVpnGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateVpnGatewayResult> createVpnGatewayAsync(CreateVpnGatewayRequest createVpnGatewayRequest);

    /**
     * <p>
     * Creates a virtual private gateway. A virtual private gateway is the endpoint on the VPC side of your VPN
     * connection. You can create a virtual private gateway before creating the VPC itself.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * 
     * @param createVpnGatewayRequest
     *        Contains the parameters for CreateVpnGateway.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the CreateVpnGateway operation returned by the service.
     * @sample AmazonEC2AsyncHandler.CreateVpnGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<CreateVpnGatewayResult> createVpnGatewayAsync(CreateVpnGatewayRequest createVpnGatewayRequest,
            com.amazonaws.handlers.AsyncHandler<CreateVpnGatewayRequest, CreateVpnGatewayResult> asyncHandler);

    /**
     * <p>
     * Deletes a carrier gateway.
     * </p>
     * <important>
     * <p>
     * If you do not delete the route that contains the carrier gateway as the Target, the route is a blackhole route.
     * For information about how to delete a route, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html">DeleteRoute</a>.
     * </p>
     * </important>
     * 
     * @param deleteCarrierGatewayRequest
     * @return A Java Future containing the result of the DeleteCarrierGateway operation returned by the service.
     * @sample AmazonEC2Async.DeleteCarrierGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCarrierGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteCarrierGatewayResult> deleteCarrierGatewayAsync(DeleteCarrierGatewayRequest deleteCarrierGatewayRequest);

    /**
     * <p>
     * Deletes a carrier gateway.
     * </p>
     * <important>
     * <p>
     * If you do not delete the route that contains the carrier gateway as the Target, the route is a blackhole route.
     * For information about how to delete a route, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html">DeleteRoute</a>.
     * </p>
     * </important>
     * 
     * @param deleteCarrierGatewayRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteCarrierGateway operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteCarrierGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCarrierGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteCarrierGatewayResult> deleteCarrierGatewayAsync(DeleteCarrierGatewayRequest deleteCarrierGatewayRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteCarrierGatewayRequest, DeleteCarrierGatewayResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified Client VPN endpoint. You must disassociate all target networks before you can delete a
     * Client VPN endpoint.
     * </p>
     * 
     * @param deleteClientVpnEndpointRequest
     * @return A Java Future containing the result of the DeleteClientVpnEndpoint operation returned by the service.
     * @sample AmazonEC2Async.DeleteClientVpnEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteClientVpnEndpointResult> deleteClientVpnEndpointAsync(DeleteClientVpnEndpointRequest deleteClientVpnEndpointRequest);

    /**
     * <p>
     * Deletes the specified Client VPN endpoint. You must disassociate all target networks before you can delete a
     * Client VPN endpoint.
     * </p>
     * 
     * @param deleteClientVpnEndpointRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteClientVpnEndpoint operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteClientVpnEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteClientVpnEndpointResult> deleteClientVpnEndpointAsync(DeleteClientVpnEndpointRequest deleteClientVpnEndpointRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteClientVpnEndpointRequest, DeleteClientVpnEndpointResult> asyncHandler);

    /**
     * <p>
     * Deletes a route from a Client VPN endpoint. You can only delete routes that you manually added using the
     * <b>CreateClientVpnRoute</b> action. You cannot delete routes that were automatically added when associating a
     * subnet. To remove routes that have been automatically added, disassociate the target subnet from the Client VPN
     * endpoint.
     * </p>
     * 
     * @param deleteClientVpnRouteRequest
     * @return A Java Future containing the result of the DeleteClientVpnRoute operation returned by the service.
     * @sample AmazonEC2Async.DeleteClientVpnRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRoute" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteClientVpnRouteResult> deleteClientVpnRouteAsync(DeleteClientVpnRouteRequest deleteClientVpnRouteRequest);

    /**
     * <p>
     * Deletes a route from a Client VPN endpoint. You can only delete routes that you manually added using the
     * <b>CreateClientVpnRoute</b> action. You cannot delete routes that were automatically added when associating a
     * subnet. To remove routes that have been automatically added, disassociate the target subnet from the Client VPN
     * endpoint.
     * </p>
     * 
     * @param deleteClientVpnRouteRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteClientVpnRoute operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteClientVpnRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRoute" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteClientVpnRouteResult> deleteClientVpnRouteAsync(DeleteClientVpnRouteRequest deleteClientVpnRouteRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteClientVpnRouteRequest, DeleteClientVpnRouteResult> asyncHandler);

    /**
     * <p>
     * Deletes a range of customer-owned IP addresses.
     * </p>
     * 
     * @param deleteCoipCidrRequest
     * @return A Java Future containing the result of the DeleteCoipCidr operation returned by the service.
     * @sample AmazonEC2Async.DeleteCoipCidr
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteCoipCidrResult> deleteCoipCidrAsync(DeleteCoipCidrRequest deleteCoipCidrRequest);

    /**
     * <p>
     * Deletes a range of customer-owned IP addresses.
     * </p>
     * 
     * @param deleteCoipCidrRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteCoipCidr operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteCoipCidr
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteCoipCidrResult> deleteCoipCidrAsync(DeleteCoipCidrRequest deleteCoipCidrRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteCoipCidrRequest, DeleteCoipCidrResult> asyncHandler);

    /**
     * <p>
     * Deletes a pool of customer-owned IP (CoIP) addresses.
     * </p>
     * 
     * @param deleteCoipPoolRequest
     * @return A Java Future containing the result of the DeleteCoipPool operation returned by the service.
     * @sample AmazonEC2Async.DeleteCoipPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipPool" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteCoipPoolResult> deleteCoipPoolAsync(DeleteCoipPoolRequest deleteCoipPoolRequest);

    /**
     * <p>
     * Deletes a pool of customer-owned IP (CoIP) addresses.
     * </p>
     * 
     * @param deleteCoipPoolRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteCoipPool operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteCoipPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipPool" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteCoipPoolResult> deleteCoipPoolAsync(DeleteCoipPoolRequest deleteCoipPoolRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteCoipPoolRequest, DeleteCoipPoolResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified customer gateway. You must delete the VPN connection before you can delete the customer
     * gateway.
     * </p>
     * 
     * @param deleteCustomerGatewayRequest
     *        Contains the parameters for DeleteCustomerGateway.
     * @return A Java Future containing the result of the DeleteCustomerGateway operation returned by the service.
     * @sample AmazonEC2Async.DeleteCustomerGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteCustomerGatewayResult> deleteCustomerGatewayAsync(DeleteCustomerGatewayRequest deleteCustomerGatewayRequest);

    /**
     * <p>
     * Deletes the specified customer gateway. You must delete the VPN connection before you can delete the customer
     * gateway.
     * </p>
     * 
     * @param deleteCustomerGatewayRequest
     *        Contains the parameters for DeleteCustomerGateway.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteCustomerGateway operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteCustomerGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteCustomerGatewayResult> deleteCustomerGatewayAsync(DeleteCustomerGatewayRequest deleteCustomerGatewayRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteCustomerGatewayRequest, DeleteCustomerGatewayResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete
     * it. You can disassociate the set of DHCP options by associating either a new set of options or the default set of
     * options with the VPC.
     * </p>
     * 
     * @param deleteDhcpOptionsRequest
     * @return A Java Future containing the result of the DeleteDhcpOptions operation returned by the service.
     * @sample AmazonEC2Async.DeleteDhcpOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteDhcpOptionsResult> deleteDhcpOptionsAsync(DeleteDhcpOptionsRequest deleteDhcpOptionsRequest);

    /**
     * <p>
     * Deletes the specified set of DHCP options. You must disassociate the set of DHCP options before you can delete
     * it. You can disassociate the set of DHCP options by associating either a new set of options or the default set of
     * options with the VPC.
     * </p>
     * 
     * @param deleteDhcpOptionsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteDhcpOptions operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteDhcpOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteDhcpOptionsResult> deleteDhcpOptionsAsync(DeleteDhcpOptionsRequest deleteDhcpOptionsRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteDhcpOptionsRequest, DeleteDhcpOptionsResult> asyncHandler);

    /**
     * <p>
     * Deletes an egress-only internet gateway.
     * </p>
     * 
     * @param deleteEgressOnlyInternetGatewayRequest
     * @return A Java Future containing the result of the DeleteEgressOnlyInternetGateway operation returned by the
     *         service.
     * @sample AmazonEC2Async.DeleteEgressOnlyInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteEgressOnlyInternetGatewayResult> deleteEgressOnlyInternetGatewayAsync(
            DeleteEgressOnlyInternetGatewayRequest deleteEgressOnlyInternetGatewayRequest);

    /**
     * <p>
     * Deletes an egress-only internet gateway.
     * </p>
     * 
     * @param deleteEgressOnlyInternetGatewayRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteEgressOnlyInternetGateway operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DeleteEgressOnlyInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGateway"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteEgressOnlyInternetGatewayResult> deleteEgressOnlyInternetGatewayAsync(
            DeleteEgressOnlyInternetGatewayRequest deleteEgressOnlyInternetGatewayRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteEgressOnlyInternetGatewayRequest, DeleteEgressOnlyInternetGatewayResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified EC2 Fleets.
     * </p>
     * <p>
     * After you delete an EC2 Fleet, it launches no new instances.
     * </p>
     * <p>
     * You must also specify whether a deleted EC2 Fleet should terminate its instances. If you choose to terminate the
     * instances, the EC2 Fleet enters the <code>deleted_terminating</code> state. Otherwise, the EC2 Fleet enters the
     * <code>deleted_running</code> state, and the instances continue to run until they are interrupted or you terminate
     * them manually.
     * </p>
     * <p>
     * For <code>instant</code> fleets, EC2 Fleet must terminate the instances when the fleet is deleted. Up to 1000
     * instances can be terminated in a single request to delete <code>instant</code> fleets. A deleted
     * <code>instant</code> fleet with running instances is not supported.
     * </p>
     * <p class="title">
     * <b>Restrictions</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can delete up to 25 fleets of type <code>instant</code> in a single request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can delete up to 100 fleets of type <code>maintain</code> or <code>request</code> in a single request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can delete up to 125 fleets in a single request, provided you do not exceed the quota for each fleet type, as
     * specified above.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you exceed the specified number of fleets to delete, no fleets are deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#delete-fleet">Delete an EC2
     * Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param deleteFleetsRequest
     * @return A Java Future containing the result of the DeleteFleets operation returned by the service.
     * @sample AmazonEC2Async.DeleteFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleets" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteFleetsResult> deleteFleetsAsync(DeleteFleetsRequest deleteFleetsRequest);

    /**
     * <p>
     * Deletes the specified EC2 Fleets.
     * </p>
     * <p>
     * After you delete an EC2 Fleet, it launches no new instances.
     * </p>
     * <p>
     * You must also specify whether a deleted EC2 Fleet should terminate its instances. If you choose to terminate the
     * instances, the EC2 Fleet enters the <code>deleted_terminating</code> state. Otherwise, the EC2 Fleet enters the
     * <code>deleted_running</code> state, and the instances continue to run until they are interrupted or you terminate
     * them manually.
     * </p>
     * <p>
     * For <code>instant</code> fleets, EC2 Fleet must terminate the instances when the fleet is deleted. Up to 1000
     * instances can be terminated in a single request to delete <code>instant</code> fleets. A deleted
     * <code>instant</code> fleet with running instances is not supported.
     * </p>
     * <p class="title">
     * <b>Restrictions</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can delete up to 25 fleets of type <code>instant</code> in a single request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can delete up to 100 fleets of type <code>maintain</code> or <code>request</code> in a single request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can delete up to 125 fleets in a single request, provided you do not exceed the quota for each fleet type, as
     * specified above.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you exceed the specified number of fleets to delete, no fleets are deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#delete-fleet">Delete an EC2
     * Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param deleteFleetsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteFleets operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleets" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteFleetsResult> deleteFleetsAsync(DeleteFleetsRequest deleteFleetsRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteFleetsRequest, DeleteFleetsResult> asyncHandler);

    /**
     * <p>
     * Deletes one or more flow logs.
     * </p>
     * 
     * @param deleteFlowLogsRequest
     * @return A Java Future containing the result of the DeleteFlowLogs operation returned by the service.
     * @sample AmazonEC2Async.DeleteFlowLogs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteFlowLogsResult> deleteFlowLogsAsync(DeleteFlowLogsRequest deleteFlowLogsRequest);

    /**
     * <p>
     * Deletes one or more flow logs.
     * </p>
     * 
     * @param deleteFlowLogsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteFlowLogs operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteFlowLogs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteFlowLogsResult> deleteFlowLogsAsync(DeleteFlowLogsRequest deleteFlowLogsRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteFlowLogsRequest, DeleteFlowLogsResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified Amazon FPGA Image (AFI).
     * </p>
     * 
     * @param deleteFpgaImageRequest
     * @return A Java Future containing the result of the DeleteFpgaImage operation returned by the service.
     * @sample AmazonEC2Async.DeleteFpgaImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteFpgaImageResult> deleteFpgaImageAsync(DeleteFpgaImageRequest deleteFpgaImageRequest);

    /**
     * <p>
     * Deletes the specified Amazon FPGA Image (AFI).
     * </p>
     * 
     * @param deleteFpgaImageRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteFpgaImage operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteFpgaImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImage" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteFpgaImageResult> deleteFpgaImageAsync(DeleteFpgaImageRequest deleteFpgaImageRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteFpgaImageRequest, DeleteFpgaImageResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified EC2 Instance Connect Endpoint.
     * </p>
     * 
     * @param deleteInstanceConnectEndpointRequest
     * @return A Java Future containing the result of the DeleteInstanceConnectEndpoint operation returned by the
     *         service.
     * @sample AmazonEC2Async.DeleteInstanceConnectEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceConnectEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteInstanceConnectEndpointResult> deleteInstanceConnectEndpointAsync(
            DeleteInstanceConnectEndpointRequest deleteInstanceConnectEndpointRequest);

    /**
     * <p>
     * Deletes the specified EC2 Instance Connect Endpoint.
     * </p>
     * 
     * @param deleteInstanceConnectEndpointRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteInstanceConnectEndpoint operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DeleteInstanceConnectEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceConnectEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteInstanceConnectEndpointResult> deleteInstanceConnectEndpointAsync(
            DeleteInstanceConnectEndpointRequest deleteInstanceConnectEndpointRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteInstanceConnectEndpointRequest, DeleteInstanceConnectEndpointResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified event window.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param deleteInstanceEventWindowRequest
     * @return A Java Future containing the result of the DeleteInstanceEventWindow operation returned by the service.
     * @sample AmazonEC2Async.DeleteInstanceEventWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceEventWindow" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteInstanceEventWindowResult> deleteInstanceEventWindowAsync(
            DeleteInstanceEventWindowRequest deleteInstanceEventWindowRequest);

    /**
     * <p>
     * Deletes the specified event window.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param deleteInstanceEventWindowRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteInstanceEventWindow operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteInstanceEventWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceEventWindow" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteInstanceEventWindowResult> deleteInstanceEventWindowAsync(
            DeleteInstanceEventWindowRequest deleteInstanceEventWindowRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteInstanceEventWindowRequest, DeleteInstanceEventWindowResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified internet gateway. You must detach the internet gateway from the VPC before you can delete
     * it.
     * </p>
     * 
     * @param deleteInternetGatewayRequest
     * @return A Java Future containing the result of the DeleteInternetGateway operation returned by the service.
     * @sample AmazonEC2Async.DeleteInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteInternetGatewayResult> deleteInternetGatewayAsync(DeleteInternetGatewayRequest deleteInternetGatewayRequest);

    /**
     * <p>
     * Deletes the specified internet gateway. You must detach the internet gateway from the VPC before you can delete
     * it.
     * </p>
     * 
     * @param deleteInternetGatewayRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteInternetGateway operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteInternetGatewayResult> deleteInternetGatewayAsync(DeleteInternetGatewayRequest deleteInternetGatewayRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteInternetGatewayRequest, DeleteInternetGatewayResult> asyncHandler);

    /**
     * <p>
     * Delete an IPAM. Deleting an IPAM removes all monitored data associated with the IPAM including the historical
     * data for CIDRs.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-ipam.html">Delete an
     * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * 
     * @param deleteIpamRequest
     * @return A Java Future containing the result of the DeleteIpam operation returned by the service.
     * @sample AmazonEC2Async.DeleteIpam
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpam" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteIpamResult> deleteIpamAsync(DeleteIpamRequest deleteIpamRequest);

    /**
     * <p>
     * Delete an IPAM. Deleting an IPAM removes all monitored data associated with the IPAM including the historical
     * data for CIDRs.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-ipam.html">Delete an
     * IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * 
     * @param deleteIpamRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteIpam operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteIpam
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpam" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteIpamResult> deleteIpamAsync(DeleteIpamRequest deleteIpamRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteIpamRequest, DeleteIpamResult> asyncHandler);

    /**
     * <p>
     * Delete an IPAM pool.
     * </p>
     * <note>
     * <p>
     * You cannot delete an IPAM pool if there are allocations in it or CIDRs provisioned to it. To release allocations,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseIpamPoolAllocation.html">
     * ReleaseIpamPoolAllocation</a>. To deprovision pool CIDRs, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionIpamPoolCidr.html"
     * >DeprovisionIpamPoolCidr</a>.
     * </p>
     * </note>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-pool-ipam.html">Delete a
     * pool</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * 
     * @param deleteIpamPoolRequest
     * @return A Java Future containing the result of the DeleteIpamPool operation returned by the service.
     * @sample AmazonEC2Async.DeleteIpamPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamPool" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteIpamPoolResult> deleteIpamPoolAsync(DeleteIpamPoolRequest deleteIpamPoolRequest);

    /**
     * <p>
     * Delete an IPAM pool.
     * </p>
     * <note>
     * <p>
     * You cannot delete an IPAM pool if there are allocations in it or CIDRs provisioned to it. To release allocations,
     * see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseIpamPoolAllocation.html">
     * ReleaseIpamPoolAllocation</a>. To deprovision pool CIDRs, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionIpamPoolCidr.html"
     * >DeprovisionIpamPoolCidr</a>.
     * </p>
     * </note>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-pool-ipam.html">Delete a
     * pool</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * 
     * @param deleteIpamPoolRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteIpamPool operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteIpamPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamPool" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteIpamPoolResult> deleteIpamPoolAsync(DeleteIpamPoolRequest deleteIpamPoolRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteIpamPoolRequest, DeleteIpamPoolResult> asyncHandler);

    /**
     * <p>
     * Deletes an IPAM resource discovery. A resource discovery is an IPAM component that enables IPAM to manage and
     * monitor resources that belong to the owning account.
     * </p>
     * 
     * @param deleteIpamResourceDiscoveryRequest
     * @return A Java Future containing the result of the DeleteIpamResourceDiscovery operation returned by the service.
     * @sample AmazonEC2Async.DeleteIpamResourceDiscovery
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamResourceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteIpamResourceDiscoveryResult> deleteIpamResourceDiscoveryAsync(
            DeleteIpamResourceDiscoveryRequest deleteIpamResourceDiscoveryRequest);

    /**
     * <p>
     * Deletes an IPAM resource discovery. A resource discovery is an IPAM component that enables IPAM to manage and
     * monitor resources that belong to the owning account.
     * </p>
     * 
     * @param deleteIpamResourceDiscoveryRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteIpamResourceDiscovery operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteIpamResourceDiscovery
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamResourceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteIpamResourceDiscoveryResult> deleteIpamResourceDiscoveryAsync(
            DeleteIpamResourceDiscoveryRequest deleteIpamResourceDiscoveryRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteIpamResourceDiscoveryRequest, DeleteIpamResourceDiscoveryResult> asyncHandler);

    /**
     * <p>
     * Delete the scope for an IPAM. You cannot delete the default scopes.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-scope-ipam.html">Delete a
     * scope</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * 
     * @param deleteIpamScopeRequest
     * @return A Java Future containing the result of the DeleteIpamScope operation returned by the service.
     * @sample AmazonEC2Async.DeleteIpamScope
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamScope" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteIpamScopeResult> deleteIpamScopeAsync(DeleteIpamScopeRequest deleteIpamScopeRequest);

    /**
     * <p>
     * Delete the scope for an IPAM. You cannot delete the default scopes.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-scope-ipam.html">Delete a
     * scope</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * 
     * @param deleteIpamScopeRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteIpamScope operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteIpamScope
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamScope" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteIpamScopeResult> deleteIpamScopeAsync(DeleteIpamScopeRequest deleteIpamScopeRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteIpamScopeRequest, DeleteIpamScopeResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified key pair, by removing the public key from Amazon EC2.
     * </p>
     * 
     * @param deleteKeyPairRequest
     * @return A Java Future containing the result of the DeleteKeyPair operation returned by the service.
     * @sample AmazonEC2Async.DeleteKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteKeyPairResult> deleteKeyPairAsync(DeleteKeyPairRequest deleteKeyPairRequest);

    /**
     * <p>
     * Deletes the specified key pair, by removing the public key from Amazon EC2.
     * </p>
     * 
     * @param deleteKeyPairRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteKeyPair operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteKeyPairResult> deleteKeyPairAsync(DeleteKeyPairRequest deleteKeyPairRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteKeyPairRequest, DeleteKeyPairResult> asyncHandler);

    /**
     * <p>
     * Deletes a launch template. Deleting a launch template deletes all of its versions.
     * </p>
     * 
     * @param deleteLaunchTemplateRequest
     * @return A Java Future containing the result of the DeleteLaunchTemplate operation returned by the service.
     * @sample AmazonEC2Async.DeleteLaunchTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteLaunchTemplateResult> deleteLaunchTemplateAsync(DeleteLaunchTemplateRequest deleteLaunchTemplateRequest);

    /**
     * <p>
     * Deletes a launch template. Deleting a launch template deletes all of its versions.
     * </p>
     * 
     * @param deleteLaunchTemplateRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteLaunchTemplate operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteLaunchTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteLaunchTemplateResult> deleteLaunchTemplateAsync(DeleteLaunchTemplateRequest deleteLaunchTemplateRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteLaunchTemplateRequest, DeleteLaunchTemplateResult> asyncHandler);

    /**
     * <p>
     * Deletes one or more versions of a launch template.
     * </p>
     * <p>
     * You can't delete the default version of a launch template; you must first assign a different version as the
     * default. If the default version is the only version for the launch template, you must delete the entire launch
     * template using <a>DeleteLaunchTemplate</a>.
     * </p>
     * <p>
     * You can delete up to 200 launch template versions in a single request. To delete more than 200 versions in a
     * single request, use <a>DeleteLaunchTemplate</a>, which deletes the launch template and all of its versions.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-launch-template-versions.html#delete-launch-template-version"
     * >Delete a launch template version</a> in the <i>EC2 User Guide</i>.
     * </p>
     * 
     * @param deleteLaunchTemplateVersionsRequest
     * @return A Java Future containing the result of the DeleteLaunchTemplateVersions operation returned by the
     *         service.
     * @sample AmazonEC2Async.DeleteLaunchTemplateVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteLaunchTemplateVersionsResult> deleteLaunchTemplateVersionsAsync(
            DeleteLaunchTemplateVersionsRequest deleteLaunchTemplateVersionsRequest);

    /**
     * <p>
     * Deletes one or more versions of a launch template.
     * </p>
     * <p>
     * You can't delete the default version of a launch template; you must first assign a different version as the
     * default. If the default version is the only version for the launch template, you must delete the entire launch
     * template using <a>DeleteLaunchTemplate</a>.
     * </p>
     * <p>
     * You can delete up to 200 launch template versions in a single request. To delete more than 200 versions in a
     * single request, use <a>DeleteLaunchTemplate</a>, which deletes the launch template and all of its versions.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-launch-template-versions.html#delete-launch-template-version"
     * >Delete a launch template version</a> in the <i>EC2 User Guide</i>.
     * </p>
     * 
     * @param deleteLaunchTemplateVersionsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteLaunchTemplateVersions operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DeleteLaunchTemplateVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteLaunchTemplateVersionsResult> deleteLaunchTemplateVersionsAsync(
            DeleteLaunchTemplateVersionsRequest deleteLaunchTemplateVersionsRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteLaunchTemplateVersionsRequest, DeleteLaunchTemplateVersionsResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified route from the specified local gateway route table.
     * </p>
     * 
     * @param deleteLocalGatewayRouteRequest
     * @return A Java Future containing the result of the DeleteLocalGatewayRoute operation returned by the service.
     * @sample AmazonEC2Async.DeleteLocalGatewayRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteLocalGatewayRouteResult> deleteLocalGatewayRouteAsync(DeleteLocalGatewayRouteRequest deleteLocalGatewayRouteRequest);

    /**
     * <p>
     * Deletes the specified route from the specified local gateway route table.
     * </p>
     * 
     * @param deleteLocalGatewayRouteRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteLocalGatewayRoute operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteLocalGatewayRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteLocalGatewayRouteResult> deleteLocalGatewayRouteAsync(DeleteLocalGatewayRouteRequest deleteLocalGatewayRouteRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteLocalGatewayRouteRequest, DeleteLocalGatewayRouteResult> asyncHandler);

    /**
     * <p>
     * Deletes a local gateway route table.
     * </p>
     * 
     * @param deleteLocalGatewayRouteTableRequest
     * @return A Java Future containing the result of the DeleteLocalGatewayRouteTable operation returned by the
     *         service.
     * @sample AmazonEC2Async.DeleteLocalGatewayRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteLocalGatewayRouteTableResult> deleteLocalGatewayRouteTableAsync(
            DeleteLocalGatewayRouteTableRequest deleteLocalGatewayRouteTableRequest);

    /**
     * <p>
     * Deletes a local gateway route table.
     * </p>
     * 
     * @param deleteLocalGatewayRouteTableRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteLocalGatewayRouteTable operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DeleteLocalGatewayRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteLocalGatewayRouteTableResult> deleteLocalGatewayRouteTableAsync(
            DeleteLocalGatewayRouteTableRequest deleteLocalGatewayRouteTableRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteLocalGatewayRouteTableRequest, DeleteLocalGatewayRouteTableResult> asyncHandler);

    /**
     * <p>
     * Deletes a local gateway route table virtual interface group association.
     * </p>
     * 
     * @param deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
     * @return A Java Future containing the result of the DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation
     *         operation returned by the service.
     * @sample AmazonEC2Async.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult> deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationAsync(
            DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest);

    /**
     * <p>
     * Deletes a local gateway route table virtual interface group association.
     * </p>
     * 
     * @param deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation
     *         operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult> deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationAsync(
            DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest deleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest, DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified association between a VPC and local gateway route table.
     * </p>
     * 
     * @param deleteLocalGatewayRouteTableVpcAssociationRequest
     * @return A Java Future containing the result of the DeleteLocalGatewayRouteTableVpcAssociation operation returned
     *         by the service.
     * @sample AmazonEC2Async.DeleteLocalGatewayRouteTableVpcAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteLocalGatewayRouteTableVpcAssociationResult> deleteLocalGatewayRouteTableVpcAssociationAsync(
            DeleteLocalGatewayRouteTableVpcAssociationRequest deleteLocalGatewayRouteTableVpcAssociationRequest);

    /**
     * <p>
     * Deletes the specified association between a VPC and local gateway route table.
     * </p>
     * 
     * @param deleteLocalGatewayRouteTableVpcAssociationRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteLocalGatewayRouteTableVpcAssociation operation returned
     *         by the service.
     * @sample AmazonEC2AsyncHandler.DeleteLocalGatewayRouteTableVpcAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteLocalGatewayRouteTableVpcAssociationResult> deleteLocalGatewayRouteTableVpcAssociationAsync(
            DeleteLocalGatewayRouteTableVpcAssociationRequest deleteLocalGatewayRouteTableVpcAssociationRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteLocalGatewayRouteTableVpcAssociationRequest, DeleteLocalGatewayRouteTableVpcAssociationResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified managed prefix list. You must first remove all references to the prefix list in your
     * resources.
     * </p>
     * 
     * @param deleteManagedPrefixListRequest
     * @return A Java Future containing the result of the DeleteManagedPrefixList operation returned by the service.
     * @sample AmazonEC2Async.DeleteManagedPrefixList
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteManagedPrefixList" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteManagedPrefixListResult> deleteManagedPrefixListAsync(DeleteManagedPrefixListRequest deleteManagedPrefixListRequest);

    /**
     * <p>
     * Deletes the specified managed prefix list. You must first remove all references to the prefix list in your
     * resources.
     * </p>
     * 
     * @param deleteManagedPrefixListRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteManagedPrefixList operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteManagedPrefixList
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteManagedPrefixList" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteManagedPrefixListResult> deleteManagedPrefixListAsync(DeleteManagedPrefixListRequest deleteManagedPrefixListRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteManagedPrefixListRequest, DeleteManagedPrefixListResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified NAT gateway. Deleting a public NAT gateway disassociates its Elastic IP address, but does
     * not release the address from your account. Deleting a NAT gateway does not delete any NAT gateway routes in your
     * route tables.
     * </p>
     * 
     * @param deleteNatGatewayRequest
     * @return A Java Future containing the result of the DeleteNatGateway operation returned by the service.
     * @sample AmazonEC2Async.DeleteNatGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteNatGatewayResult> deleteNatGatewayAsync(DeleteNatGatewayRequest deleteNatGatewayRequest);

    /**
     * <p>
     * Deletes the specified NAT gateway. Deleting a public NAT gateway disassociates its Elastic IP address, but does
     * not release the address from your account. Deleting a NAT gateway does not delete any NAT gateway routes in your
     * route tables.
     * </p>
     * 
     * @param deleteNatGatewayRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteNatGateway operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteNatGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteNatGatewayResult> deleteNatGatewayAsync(DeleteNatGatewayRequest deleteNatGatewayRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteNatGatewayRequest, DeleteNatGatewayResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified network ACL. You can't delete the ACL if it's associated with any subnets. You can't delete
     * the default network ACL.
     * </p>
     * 
     * @param deleteNetworkAclRequest
     * @return A Java Future containing the result of the DeleteNetworkAcl operation returned by the service.
     * @sample AmazonEC2Async.DeleteNetworkAcl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteNetworkAclResult> deleteNetworkAclAsync(DeleteNetworkAclRequest deleteNetworkAclRequest);

    /**
     * <p>
     * Deletes the specified network ACL. You can't delete the ACL if it's associated with any subnets. You can't delete
     * the default network ACL.
     * </p>
     * 
     * @param deleteNetworkAclRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteNetworkAcl operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteNetworkAcl
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAcl" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteNetworkAclResult> deleteNetworkAclAsync(DeleteNetworkAclRequest deleteNetworkAclRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteNetworkAclRequest, DeleteNetworkAclResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified ingress or egress entry (rule) from the specified network ACL.
     * </p>
     * 
     * @param deleteNetworkAclEntryRequest
     * @return A Java Future containing the result of the DeleteNetworkAclEntry operation returned by the service.
     * @sample AmazonEC2Async.DeleteNetworkAclEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteNetworkAclEntryResult> deleteNetworkAclEntryAsync(DeleteNetworkAclEntryRequest deleteNetworkAclEntryRequest);

    /**
     * <p>
     * Deletes the specified ingress or egress entry (rule) from the specified network ACL.
     * </p>
     * 
     * @param deleteNetworkAclEntryRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteNetworkAclEntry operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteNetworkAclEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntry" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteNetworkAclEntryResult> deleteNetworkAclEntryAsync(DeleteNetworkAclEntryRequest deleteNetworkAclEntryRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteNetworkAclEntryRequest, DeleteNetworkAclEntryResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified Network Access Scope.
     * </p>
     * 
     * @param deleteNetworkInsightsAccessScopeRequest
     * @return A Java Future containing the result of the DeleteNetworkInsightsAccessScope operation returned by the
     *         service.
     * @sample AmazonEC2Async.DeleteNetworkInsightsAccessScope
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteNetworkInsightsAccessScopeResult> deleteNetworkInsightsAccessScopeAsync(
            DeleteNetworkInsightsAccessScopeRequest deleteNetworkInsightsAccessScopeRequest);

    /**
     * <p>
     * Deletes the specified Network Access Scope.
     * </p>
     * 
     * @param deleteNetworkInsightsAccessScopeRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteNetworkInsightsAccessScope operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DeleteNetworkInsightsAccessScope
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScope"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteNetworkInsightsAccessScopeResult> deleteNetworkInsightsAccessScopeAsync(
            DeleteNetworkInsightsAccessScopeRequest deleteNetworkInsightsAccessScopeRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteNetworkInsightsAccessScopeRequest, DeleteNetworkInsightsAccessScopeResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified Network Access Scope analysis.
     * </p>
     * 
     * @param deleteNetworkInsightsAccessScopeAnalysisRequest
     * @return A Java Future containing the result of the DeleteNetworkInsightsAccessScopeAnalysis operation returned by
     *         the service.
     * @sample AmazonEC2Async.DeleteNetworkInsightsAccessScopeAnalysis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScopeAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteNetworkInsightsAccessScopeAnalysisResult> deleteNetworkInsightsAccessScopeAnalysisAsync(
            DeleteNetworkInsightsAccessScopeAnalysisRequest deleteNetworkInsightsAccessScopeAnalysisRequest);

    /**
     * <p>
     * Deletes the specified Network Access Scope analysis.
     * </p>
     * 
     * @param deleteNetworkInsightsAccessScopeAnalysisRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteNetworkInsightsAccessScopeAnalysis operation returned by
     *         the service.
     * @sample AmazonEC2AsyncHandler.DeleteNetworkInsightsAccessScopeAnalysis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScopeAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteNetworkInsightsAccessScopeAnalysisResult> deleteNetworkInsightsAccessScopeAnalysisAsync(
            DeleteNetworkInsightsAccessScopeAnalysisRequest deleteNetworkInsightsAccessScopeAnalysisRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteNetworkInsightsAccessScopeAnalysisRequest, DeleteNetworkInsightsAccessScopeAnalysisResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified network insights analysis.
     * </p>
     * 
     * @param deleteNetworkInsightsAnalysisRequest
     * @return A Java Future containing the result of the DeleteNetworkInsightsAnalysis operation returned by the
     *         service.
     * @sample AmazonEC2Async.DeleteNetworkInsightsAnalysis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteNetworkInsightsAnalysisResult> deleteNetworkInsightsAnalysisAsync(
            DeleteNetworkInsightsAnalysisRequest deleteNetworkInsightsAnalysisRequest);

    /**
     * <p>
     * Deletes the specified network insights analysis.
     * </p>
     * 
     * @param deleteNetworkInsightsAnalysisRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteNetworkInsightsAnalysis operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DeleteNetworkInsightsAnalysis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteNetworkInsightsAnalysisResult> deleteNetworkInsightsAnalysisAsync(
            DeleteNetworkInsightsAnalysisRequest deleteNetworkInsightsAnalysisRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteNetworkInsightsAnalysisRequest, DeleteNetworkInsightsAnalysisResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified path.
     * </p>
     * 
     * @param deleteNetworkInsightsPathRequest
     * @return A Java Future containing the result of the DeleteNetworkInsightsPath operation returned by the service.
     * @sample AmazonEC2Async.DeleteNetworkInsightsPath
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsPath" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteNetworkInsightsPathResult> deleteNetworkInsightsPathAsync(
            DeleteNetworkInsightsPathRequest deleteNetworkInsightsPathRequest);

    /**
     * <p>
     * Deletes the specified path.
     * </p>
     * 
     * @param deleteNetworkInsightsPathRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteNetworkInsightsPath operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteNetworkInsightsPath
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsPath" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteNetworkInsightsPathResult> deleteNetworkInsightsPathAsync(
            DeleteNetworkInsightsPathRequest deleteNetworkInsightsPathRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteNetworkInsightsPathRequest, DeleteNetworkInsightsPathResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified network interface. You must detach the network interface before you can delete it.
     * </p>
     * 
     * @param deleteNetworkInterfaceRequest
     *        Contains the parameters for DeleteNetworkInterface.
     * @return A Java Future containing the result of the DeleteNetworkInterface operation returned by the service.
     * @sample AmazonEC2Async.DeleteNetworkInterface
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterface" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteNetworkInterfaceResult> deleteNetworkInterfaceAsync(DeleteNetworkInterfaceRequest deleteNetworkInterfaceRequest);

    /**
     * <p>
     * Deletes the specified network interface. You must detach the network interface before you can delete it.
     * </p>
     * 
     * @param deleteNetworkInterfaceRequest
     *        Contains the parameters for DeleteNetworkInterface.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteNetworkInterface operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteNetworkInterface
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterface" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteNetworkInterfaceResult> deleteNetworkInterfaceAsync(DeleteNetworkInterfaceRequest deleteNetworkInterfaceRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteNetworkInterfaceRequest, DeleteNetworkInterfaceResult> asyncHandler);

    /**
     * <p>
     * Deletes a permission for a network interface. By default, you cannot delete the permission if the account for
     * which you're removing the permission has attached the network interface to an instance. However, you can force
     * delete the permission, regardless of any attachment.
     * </p>
     * 
     * @param deleteNetworkInterfacePermissionRequest
     *        Contains the parameters for DeleteNetworkInterfacePermission.
     * @return A Java Future containing the result of the DeleteNetworkInterfacePermission operation returned by the
     *         service.
     * @sample AmazonEC2Async.DeleteNetworkInterfacePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteNetworkInterfacePermissionResult> deleteNetworkInterfacePermissionAsync(
            DeleteNetworkInterfacePermissionRequest deleteNetworkInterfacePermissionRequest);

    /**
     * <p>
     * Deletes a permission for a network interface. By default, you cannot delete the permission if the account for
     * which you're removing the permission has attached the network interface to an instance. However, you can force
     * delete the permission, regardless of any attachment.
     * </p>
     * 
     * @param deleteNetworkInterfacePermissionRequest
     *        Contains the parameters for DeleteNetworkInterfacePermission.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteNetworkInterfacePermission operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DeleteNetworkInterfacePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermission"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteNetworkInterfacePermissionResult> deleteNetworkInterfacePermissionAsync(
            DeleteNetworkInterfacePermissionRequest deleteNetworkInterfacePermissionRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteNetworkInterfacePermissionRequest, DeleteNetworkInterfacePermissionResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified placement group. You must terminate all instances in the placement group before you can
     * delete the placement group. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param deletePlacementGroupRequest
     * @return A Java Future containing the result of the DeletePlacementGroup operation returned by the service.
     * @sample AmazonEC2Async.DeletePlacementGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeletePlacementGroupResult> deletePlacementGroupAsync(DeletePlacementGroupRequest deletePlacementGroupRequest);

    /**
     * <p>
     * Deletes the specified placement group. You must terminate all instances in the placement group before you can
     * delete the placement group. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param deletePlacementGroupRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeletePlacementGroup operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeletePlacementGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroup" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeletePlacementGroupResult> deletePlacementGroupAsync(DeletePlacementGroupRequest deletePlacementGroupRequest,
            com.amazonaws.handlers.AsyncHandler<DeletePlacementGroupRequest, DeletePlacementGroupResult> asyncHandler);

    /**
     * <p>
     * Delete a public IPv4 pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that
     * you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services,
     * however, use IPAM pools only.
     * </p>
     * 
     * @param deletePublicIpv4PoolRequest
     * @return A Java Future containing the result of the DeletePublicIpv4Pool operation returned by the service.
     * @sample AmazonEC2Async.DeletePublicIpv4Pool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePublicIpv4Pool" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeletePublicIpv4PoolResult> deletePublicIpv4PoolAsync(DeletePublicIpv4PoolRequest deletePublicIpv4PoolRequest);

    /**
     * <p>
     * Delete a public IPv4 pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that
     * you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services,
     * however, use IPAM pools only.
     * </p>
     * 
     * @param deletePublicIpv4PoolRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeletePublicIpv4Pool operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeletePublicIpv4Pool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePublicIpv4Pool" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeletePublicIpv4PoolResult> deletePublicIpv4PoolAsync(DeletePublicIpv4PoolRequest deletePublicIpv4PoolRequest,
            com.amazonaws.handlers.AsyncHandler<DeletePublicIpv4PoolRequest, DeletePublicIpv4PoolResult> asyncHandler);

    /**
     * <p>
     * Deletes the queued purchases for the specified Reserved Instances.
     * </p>
     * 
     * @param deleteQueuedReservedInstancesRequest
     * @return A Java Future containing the result of the DeleteQueuedReservedInstances operation returned by the
     *         service.
     * @sample AmazonEC2Async.DeleteQueuedReservedInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstances"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteQueuedReservedInstancesResult> deleteQueuedReservedInstancesAsync(
            DeleteQueuedReservedInstancesRequest deleteQueuedReservedInstancesRequest);

    /**
     * <p>
     * Deletes the queued purchases for the specified Reserved Instances.
     * </p>
     * 
     * @param deleteQueuedReservedInstancesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteQueuedReservedInstances operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DeleteQueuedReservedInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstances"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteQueuedReservedInstancesResult> deleteQueuedReservedInstancesAsync(
            DeleteQueuedReservedInstancesRequest deleteQueuedReservedInstancesRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteQueuedReservedInstancesRequest, DeleteQueuedReservedInstancesResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified route from the specified route table.
     * </p>
     * 
     * @param deleteRouteRequest
     * @return A Java Future containing the result of the DeleteRoute operation returned by the service.
     * @sample AmazonEC2Async.DeleteRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRoute" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteRouteResult> deleteRouteAsync(DeleteRouteRequest deleteRouteRequest);

    /**
     * <p>
     * Deletes the specified route from the specified route table.
     * </p>
     * 
     * @param deleteRouteRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteRoute operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRoute" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteRouteResult> deleteRouteAsync(DeleteRouteRequest deleteRouteRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteRouteRequest, DeleteRouteResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified route table. You must disassociate the route table from any subnets before you can delete
     * it. You can't delete the main route table.
     * </p>
     * 
     * @param deleteRouteTableRequest
     * @return A Java Future containing the result of the DeleteRouteTable operation returned by the service.
     * @sample AmazonEC2Async.DeleteRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteRouteTableResult> deleteRouteTableAsync(DeleteRouteTableRequest deleteRouteTableRequest);

    /**
     * <p>
     * Deletes the specified route table. You must disassociate the route table from any subnets before you can delete
     * it. You can't delete the main route table.
     * </p>
     * 
     * @param deleteRouteTableRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteRouteTable operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTable" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteRouteTableResult> deleteRouteTableAsync(DeleteRouteTableRequest deleteRouteTableRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteRouteTableRequest, DeleteRouteTableResult> asyncHandler);

    /**
     * <p>
     * Deletes a security group.
     * </p>
     * <p>
     * If you attempt to delete a security group that is associated with an instance or network interface or is
     * referenced by another security group, the operation fails with <code>DependencyViolation</code>.
     * </p>
     * 
     * @param deleteSecurityGroupRequest
     * @return A Java Future containing the result of the DeleteSecurityGroup operation returned by the service.
     * @sample AmazonEC2Async.DeleteSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteSecurityGroupResult> deleteSecurityGroupAsync(DeleteSecurityGroupRequest deleteSecurityGroupRequest);

    /**
     * <p>
     * Deletes a security group.
     * </p>
     * <p>
     * If you attempt to delete a security group that is associated with an instance or network interface or is
     * referenced by another security group, the operation fails with <code>DependencyViolation</code>.
     * </p>
     * 
     * @param deleteSecurityGroupRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteSecurityGroup operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteSecurityGroupResult> deleteSecurityGroupAsync(DeleteSecurityGroupRequest deleteSecurityGroupRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteSecurityGroupRequest, DeleteSecurityGroupResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified snapshot.
     * </p>
     * <p>
     * When you make periodic snapshots of a volume, the snapshots are incremental, and only the blocks on the device
     * that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the
     * data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all
     * active snapshots will have access to all the information needed to restore the volume.
     * </p>
     * <p>
     * You cannot delete a snapshot of the root device of an EBS volume used by a registered AMI. You must first
     * de-register the AMI before you can delete the snapshot.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-deleting-snapshot.html">Delete an Amazon EBS
     * snapshot</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param deleteSnapshotRequest
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.
     * @sample AmazonEC2Async.DeleteSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteSnapshotResult> deleteSnapshotAsync(DeleteSnapshotRequest deleteSnapshotRequest);

    /**
     * <p>
     * Deletes the specified snapshot.
     * </p>
     * <p>
     * When you make periodic snapshots of a volume, the snapshots are incremental, and only the blocks on the device
     * that have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the
     * data not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all
     * active snapshots will have access to all the information needed to restore the volume.
     * </p>
     * <p>
     * You cannot delete a snapshot of the root device of an EBS volume used by a registered AMI. You must first
     * de-register the AMI before you can delete the snapshot.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-deleting-snapshot.html">Delete an Amazon EBS
     * snapshot</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param deleteSnapshotRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteSnapshotResult> deleteSnapshotAsync(DeleteSnapshotRequest deleteSnapshotRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteSnapshotRequest, DeleteSnapshotResult> asyncHandler);

    /**
     * <p>
     * Deletes the data feed for Spot Instances.
     * </p>
     * 
     * @param deleteSpotDatafeedSubscriptionRequest
     *        Contains the parameters for DeleteSpotDatafeedSubscription.
     * @return A Java Future containing the result of the DeleteSpotDatafeedSubscription operation returned by the
     *         service.
     * @sample AmazonEC2Async.DeleteSpotDatafeedSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteSpotDatafeedSubscriptionResult> deleteSpotDatafeedSubscriptionAsync(
            DeleteSpotDatafeedSubscriptionRequest deleteSpotDatafeedSubscriptionRequest);

    /**
     * <p>
     * Deletes the data feed for Spot Instances.
     * </p>
     * 
     * @param deleteSpotDatafeedSubscriptionRequest
     *        Contains the parameters for DeleteSpotDatafeedSubscription.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteSpotDatafeedSubscription operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DeleteSpotDatafeedSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteSpotDatafeedSubscriptionResult> deleteSpotDatafeedSubscriptionAsync(
            DeleteSpotDatafeedSubscriptionRequest deleteSpotDatafeedSubscriptionRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteSpotDatafeedSubscriptionRequest, DeleteSpotDatafeedSubscriptionResult> asyncHandler);

    /**
     * Simplified method form for invoking the DeleteSpotDatafeedSubscription operation.
     *
     * @see #deleteSpotDatafeedSubscriptionAsync(DeleteSpotDatafeedSubscriptionRequest)
     */
    java.util.concurrent.Future<DeleteSpotDatafeedSubscriptionResult> deleteSpotDatafeedSubscriptionAsync();

    /**
     * Simplified method form for invoking the DeleteSpotDatafeedSubscription operation with an AsyncHandler.
     *
     * @see #deleteSpotDatafeedSubscriptionAsync(DeleteSpotDatafeedSubscriptionRequest,
     *      com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DeleteSpotDatafeedSubscriptionResult> deleteSpotDatafeedSubscriptionAsync(
            com.amazonaws.handlers.AsyncHandler<DeleteSpotDatafeedSubscriptionRequest, DeleteSpotDatafeedSubscriptionResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified subnet. You must terminate all running instances in the subnet before you can delete the
     * subnet.
     * </p>
     * 
     * @param deleteSubnetRequest
     * @return A Java Future containing the result of the DeleteSubnet operation returned by the service.
     * @sample AmazonEC2Async.DeleteSubnet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteSubnetResult> deleteSubnetAsync(DeleteSubnetRequest deleteSubnetRequest);

    /**
     * <p>
     * Deletes the specified subnet. You must terminate all running instances in the subnet before you can delete the
     * subnet.
     * </p>
     * 
     * @param deleteSubnetRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteSubnet operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteSubnet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnet" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteSubnetResult> deleteSubnetAsync(DeleteSubnetRequest deleteSubnetRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteSubnetRequest, DeleteSubnetResult> asyncHandler);

    /**
     * <p>
     * Deletes a subnet CIDR reservation.
     * </p>
     * 
     * @param deleteSubnetCidrReservationRequest
     * @return A Java Future containing the result of the DeleteSubnetCidrReservation operation returned by the service.
     * @sample AmazonEC2Async.DeleteSubnetCidrReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnetCidrReservation"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteSubnetCidrReservationResult> deleteSubnetCidrReservationAsync(
            DeleteSubnetCidrReservationRequest deleteSubnetCidrReservationRequest);

    /**
     * <p>
     * Deletes a subnet CIDR reservation.
     * </p>
     * 
     * @param deleteSubnetCidrReservationRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteSubnetCidrReservation operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteSubnetCidrReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnetCidrReservation"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteSubnetCidrReservationResult> deleteSubnetCidrReservationAsync(
            DeleteSubnetCidrReservationRequest deleteSubnetCidrReservationRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteSubnetCidrReservationRequest, DeleteSubnetCidrReservationResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified set of tags from the specified set of resources.
     * </p>
     * <p>
     * To list the current tags, use <a>DescribeTags</a>. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param deleteTagsRequest
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.
     * @sample AmazonEC2Async.DeleteTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest deleteTagsRequest);

    /**
     * <p>
     * Deletes the specified set of tags from the specified set of resources.
     * </p>
     * <p>
     * To list the current tags, use <a>DescribeTags</a>. For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param deleteTagsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest deleteTagsRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteTagsRequest, DeleteTagsResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified Traffic Mirror filter.
     * </p>
     * <p>
     * You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror session.
     * </p>
     * 
     * @param deleteTrafficMirrorFilterRequest
     * @return A Java Future containing the result of the DeleteTrafficMirrorFilter operation returned by the service.
     * @sample AmazonEC2Async.DeleteTrafficMirrorFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilter" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTrafficMirrorFilterResult> deleteTrafficMirrorFilterAsync(
            DeleteTrafficMirrorFilterRequest deleteTrafficMirrorFilterRequest);

    /**
     * <p>
     * Deletes the specified Traffic Mirror filter.
     * </p>
     * <p>
     * You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror session.
     * </p>
     * 
     * @param deleteTrafficMirrorFilterRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteTrafficMirrorFilter operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteTrafficMirrorFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilter" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTrafficMirrorFilterResult> deleteTrafficMirrorFilterAsync(
            DeleteTrafficMirrorFilterRequest deleteTrafficMirrorFilterRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteTrafficMirrorFilterRequest, DeleteTrafficMirrorFilterResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified Traffic Mirror rule.
     * </p>
     * 
     * @param deleteTrafficMirrorFilterRuleRequest
     * @return A Java Future containing the result of the DeleteTrafficMirrorFilterRule operation returned by the
     *         service.
     * @sample AmazonEC2Async.DeleteTrafficMirrorFilterRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRule"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTrafficMirrorFilterRuleResult> deleteTrafficMirrorFilterRuleAsync(
            DeleteTrafficMirrorFilterRuleRequest deleteTrafficMirrorFilterRuleRequest);

    /**
     * <p>
     * Deletes the specified Traffic Mirror rule.
     * </p>
     * 
     * @param deleteTrafficMirrorFilterRuleRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteTrafficMirrorFilterRule operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DeleteTrafficMirrorFilterRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRule"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTrafficMirrorFilterRuleResult> deleteTrafficMirrorFilterRuleAsync(
            DeleteTrafficMirrorFilterRuleRequest deleteTrafficMirrorFilterRuleRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteTrafficMirrorFilterRuleRequest, DeleteTrafficMirrorFilterRuleResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified Traffic Mirror session.
     * </p>
     * 
     * @param deleteTrafficMirrorSessionRequest
     * @return A Java Future containing the result of the DeleteTrafficMirrorSession operation returned by the service.
     * @sample AmazonEC2Async.DeleteTrafficMirrorSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorSession" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTrafficMirrorSessionResult> deleteTrafficMirrorSessionAsync(
            DeleteTrafficMirrorSessionRequest deleteTrafficMirrorSessionRequest);

    /**
     * <p>
     * Deletes the specified Traffic Mirror session.
     * </p>
     * 
     * @param deleteTrafficMirrorSessionRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteTrafficMirrorSession operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteTrafficMirrorSession
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorSession" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTrafficMirrorSessionResult> deleteTrafficMirrorSessionAsync(
            DeleteTrafficMirrorSessionRequest deleteTrafficMirrorSessionRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteTrafficMirrorSessionRequest, DeleteTrafficMirrorSessionResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified Traffic Mirror target.
     * </p>
     * <p>
     * You cannot delete a Traffic Mirror target that is in use by a Traffic Mirror session.
     * </p>
     * 
     * @param deleteTrafficMirrorTargetRequest
     * @return A Java Future containing the result of the DeleteTrafficMirrorTarget operation returned by the service.
     * @sample AmazonEC2Async.DeleteTrafficMirrorTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorTarget" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTrafficMirrorTargetResult> deleteTrafficMirrorTargetAsync(
            DeleteTrafficMirrorTargetRequest deleteTrafficMirrorTargetRequest);

    /**
     * <p>
     * Deletes the specified Traffic Mirror target.
     * </p>
     * <p>
     * You cannot delete a Traffic Mirror target that is in use by a Traffic Mirror session.
     * </p>
     * 
     * @param deleteTrafficMirrorTargetRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteTrafficMirrorTarget operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteTrafficMirrorTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorTarget" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTrafficMirrorTargetResult> deleteTrafficMirrorTargetAsync(
            DeleteTrafficMirrorTargetRequest deleteTrafficMirrorTargetRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteTrafficMirrorTargetRequest, DeleteTrafficMirrorTargetResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified transit gateway.
     * </p>
     * 
     * @param deleteTransitGatewayRequest
     * @return A Java Future containing the result of the DeleteTransitGateway operation returned by the service.
     * @sample AmazonEC2Async.DeleteTransitGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayResult> deleteTransitGatewayAsync(DeleteTransitGatewayRequest deleteTransitGatewayRequest);

    /**
     * <p>
     * Deletes the specified transit gateway.
     * </p>
     * 
     * @param deleteTransitGatewayRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteTransitGateway operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteTransitGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayResult> deleteTransitGatewayAsync(DeleteTransitGatewayRequest deleteTransitGatewayRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteTransitGatewayRequest, DeleteTransitGatewayResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified Connect attachment. You must first delete any Connect peers for the attachment.
     * </p>
     * 
     * @param deleteTransitGatewayConnectRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayConnect operation returned by the service.
     * @sample AmazonEC2Async.DeleteTransitGatewayConnect
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnect"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayConnectResult> deleteTransitGatewayConnectAsync(
            DeleteTransitGatewayConnectRequest deleteTransitGatewayConnectRequest);

    /**
     * <p>
     * Deletes the specified Connect attachment. You must first delete any Connect peers for the attachment.
     * </p>
     * 
     * @param deleteTransitGatewayConnectRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteTransitGatewayConnect operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteTransitGatewayConnect
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnect"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayConnectResult> deleteTransitGatewayConnectAsync(
            DeleteTransitGatewayConnectRequest deleteTransitGatewayConnectRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteTransitGatewayConnectRequest, DeleteTransitGatewayConnectResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified Connect peer.
     * </p>
     * 
     * @param deleteTransitGatewayConnectPeerRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayConnectPeer operation returned by the
     *         service.
     * @sample AmazonEC2Async.DeleteTransitGatewayConnectPeer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayConnectPeerResult> deleteTransitGatewayConnectPeerAsync(
            DeleteTransitGatewayConnectPeerRequest deleteTransitGatewayConnectPeerRequest);

    /**
     * <p>
     * Deletes the specified Connect peer.
     * </p>
     * 
     * @param deleteTransitGatewayConnectPeerRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteTransitGatewayConnectPeer operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DeleteTransitGatewayConnectPeer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectPeer"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayConnectPeerResult> deleteTransitGatewayConnectPeerAsync(
            DeleteTransitGatewayConnectPeerRequest deleteTransitGatewayConnectPeerRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteTransitGatewayConnectPeerRequest, DeleteTransitGatewayConnectPeerResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified transit gateway multicast domain.
     * </p>
     * 
     * @param deleteTransitGatewayMulticastDomainRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayMulticastDomain operation returned by the
     *         service.
     * @sample AmazonEC2Async.DeleteTransitGatewayMulticastDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayMulticastDomainResult> deleteTransitGatewayMulticastDomainAsync(
            DeleteTransitGatewayMulticastDomainRequest deleteTransitGatewayMulticastDomainRequest);

    /**
     * <p>
     * Deletes the specified transit gateway multicast domain.
     * </p>
     * 
     * @param deleteTransitGatewayMulticastDomainRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteTransitGatewayMulticastDomain operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DeleteTransitGatewayMulticastDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMulticastDomain"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayMulticastDomainResult> deleteTransitGatewayMulticastDomainAsync(
            DeleteTransitGatewayMulticastDomainRequest deleteTransitGatewayMulticastDomainRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteTransitGatewayMulticastDomainRequest, DeleteTransitGatewayMulticastDomainResult> asyncHandler);

    /**
     * <p>
     * Deletes a transit gateway peering attachment.
     * </p>
     * 
     * @param deleteTransitGatewayPeeringAttachmentRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayPeeringAttachment operation returned by
     *         the service.
     * @sample AmazonEC2Async.DeleteTransitGatewayPeeringAttachment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayPeeringAttachmentResult> deleteTransitGatewayPeeringAttachmentAsync(
            DeleteTransitGatewayPeeringAttachmentRequest deleteTransitGatewayPeeringAttachmentRequest);

    /**
     * <p>
     * Deletes a transit gateway peering attachment.
     * </p>
     * 
     * @param deleteTransitGatewayPeeringAttachmentRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteTransitGatewayPeeringAttachment operation returned by
     *         the service.
     * @sample AmazonEC2AsyncHandler.DeleteTransitGatewayPeeringAttachment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPeeringAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayPeeringAttachmentResult> deleteTransitGatewayPeeringAttachmentAsync(
            DeleteTransitGatewayPeeringAttachmentRequest deleteTransitGatewayPeeringAttachmentRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteTransitGatewayPeeringAttachmentRequest, DeleteTransitGatewayPeeringAttachmentResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified transit gateway policy table.
     * </p>
     * 
     * @param deleteTransitGatewayPolicyTableRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayPolicyTable operation returned by the
     *         service.
     * @sample AmazonEC2Async.DeleteTransitGatewayPolicyTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPolicyTable"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayPolicyTableResult> deleteTransitGatewayPolicyTableAsync(
            DeleteTransitGatewayPolicyTableRequest deleteTransitGatewayPolicyTableRequest);

    /**
     * <p>
     * Deletes the specified transit gateway policy table.
     * </p>
     * 
     * @param deleteTransitGatewayPolicyTableRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteTransitGatewayPolicyTable operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DeleteTransitGatewayPolicyTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPolicyTable"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayPolicyTableResult> deleteTransitGatewayPolicyTableAsync(
            DeleteTransitGatewayPolicyTableRequest deleteTransitGatewayPolicyTableRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteTransitGatewayPolicyTableRequest, DeleteTransitGatewayPolicyTableResult> asyncHandler);

    /**
     * <p>
     * Deletes a reference (route) to a prefix list in a specified transit gateway route table.
     * </p>
     * 
     * @param deleteTransitGatewayPrefixListReferenceRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayPrefixListReference operation returned by
     *         the service.
     * @sample AmazonEC2Async.DeleteTransitGatewayPrefixListReference
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPrefixListReference"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayPrefixListReferenceResult> deleteTransitGatewayPrefixListReferenceAsync(
            DeleteTransitGatewayPrefixListReferenceRequest deleteTransitGatewayPrefixListReferenceRequest);

    /**
     * <p>
     * Deletes a reference (route) to a prefix list in a specified transit gateway route table.
     * </p>
     * 
     * @param deleteTransitGatewayPrefixListReferenceRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteTransitGatewayPrefixListReference operation returned by
     *         the service.
     * @sample AmazonEC2AsyncHandler.DeleteTransitGatewayPrefixListReference
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPrefixListReference"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayPrefixListReferenceResult> deleteTransitGatewayPrefixListReferenceAsync(
            DeleteTransitGatewayPrefixListReferenceRequest deleteTransitGatewayPrefixListReferenceRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteTransitGatewayPrefixListReferenceRequest, DeleteTransitGatewayPrefixListReferenceResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified route from the specified transit gateway route table.
     * </p>
     * 
     * @param deleteTransitGatewayRouteRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayRoute operation returned by the service.
     * @sample AmazonEC2Async.DeleteTransitGatewayRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayRouteResult> deleteTransitGatewayRouteAsync(
            DeleteTransitGatewayRouteRequest deleteTransitGatewayRouteRequest);

    /**
     * <p>
     * Deletes the specified route from the specified transit gateway route table.
     * </p>
     * 
     * @param deleteTransitGatewayRouteRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteTransitGatewayRoute operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteTransitGatewayRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRoute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayRouteResult> deleteTransitGatewayRouteAsync(
            DeleteTransitGatewayRouteRequest deleteTransitGatewayRouteRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteTransitGatewayRouteRequest, DeleteTransitGatewayRouteResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified transit gateway route table. You must disassociate the route table from any transit gateway
     * route tables before you can delete it.
     * </p>
     * 
     * @param deleteTransitGatewayRouteTableRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayRouteTable operation returned by the
     *         service.
     * @sample AmazonEC2Async.DeleteTransitGatewayRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayRouteTableResult> deleteTransitGatewayRouteTableAsync(
            DeleteTransitGatewayRouteTableRequest deleteTransitGatewayRouteTableRequest);

    /**
     * <p>
     * Deletes the specified transit gateway route table. You must disassociate the route table from any transit gateway
     * route tables before you can delete it.
     * </p>
     * 
     * @param deleteTransitGatewayRouteTableRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteTransitGatewayRouteTable operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DeleteTransitGatewayRouteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTable"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayRouteTableResult> deleteTransitGatewayRouteTableAsync(
            DeleteTransitGatewayRouteTableRequest deleteTransitGatewayRouteTableRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteTransitGatewayRouteTableRequest, DeleteTransitGatewayRouteTableResult> asyncHandler);

    /**
     * <p>
     * Advertises to the transit gateway that a transit gateway route table is deleted.
     * </p>
     * 
     * @param deleteTransitGatewayRouteTableAnnouncementRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayRouteTableAnnouncement operation returned
     *         by the service.
     * @sample AmazonEC2Async.DeleteTransitGatewayRouteTableAnnouncement
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTableAnnouncement"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayRouteTableAnnouncementResult> deleteTransitGatewayRouteTableAnnouncementAsync(
            DeleteTransitGatewayRouteTableAnnouncementRequest deleteTransitGatewayRouteTableAnnouncementRequest);

    /**
     * <p>
     * Advertises to the transit gateway that a transit gateway route table is deleted.
     * </p>
     * 
     * @param deleteTransitGatewayRouteTableAnnouncementRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteTransitGatewayRouteTableAnnouncement operation returned
     *         by the service.
     * @sample AmazonEC2AsyncHandler.DeleteTransitGatewayRouteTableAnnouncement
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTableAnnouncement"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayRouteTableAnnouncementResult> deleteTransitGatewayRouteTableAnnouncementAsync(
            DeleteTransitGatewayRouteTableAnnouncementRequest deleteTransitGatewayRouteTableAnnouncementRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteTransitGatewayRouteTableAnnouncementRequest, DeleteTransitGatewayRouteTableAnnouncementResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified VPC attachment.
     * </p>
     * 
     * @param deleteTransitGatewayVpcAttachmentRequest
     * @return A Java Future containing the result of the DeleteTransitGatewayVpcAttachment operation returned by the
     *         service.
     * @sample AmazonEC2Async.DeleteTransitGatewayVpcAttachment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayVpcAttachmentResult> deleteTransitGatewayVpcAttachmentAsync(
            DeleteTransitGatewayVpcAttachmentRequest deleteTransitGatewayVpcAttachmentRequest);

    /**
     * <p>
     * Deletes the specified VPC attachment.
     * </p>
     * 
     * @param deleteTransitGatewayVpcAttachmentRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteTransitGatewayVpcAttachment operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DeleteTransitGatewayVpcAttachment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayVpcAttachment"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteTransitGatewayVpcAttachmentResult> deleteTransitGatewayVpcAttachmentAsync(
            DeleteTransitGatewayVpcAttachmentRequest deleteTransitGatewayVpcAttachmentRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteTransitGatewayVpcAttachmentRequest, DeleteTransitGatewayVpcAttachmentResult> asyncHandler);

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access endpoint.
     * </p>
     * 
     * @param deleteVerifiedAccessEndpointRequest
     * @return A Java Future containing the result of the DeleteVerifiedAccessEndpoint operation returned by the
     *         service.
     * @sample AmazonEC2Async.DeleteVerifiedAccessEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteVerifiedAccessEndpointResult> deleteVerifiedAccessEndpointAsync(
            DeleteVerifiedAccessEndpointRequest deleteVerifiedAccessEndpointRequest);

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access endpoint.
     * </p>
     * 
     * @param deleteVerifiedAccessEndpointRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteVerifiedAccessEndpoint operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DeleteVerifiedAccessEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteVerifiedAccessEndpointResult> deleteVerifiedAccessEndpointAsync(
            DeleteVerifiedAccessEndpointRequest deleteVerifiedAccessEndpointRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteVerifiedAccessEndpointRequest, DeleteVerifiedAccessEndpointResult> asyncHandler);

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access group.
     * </p>
     * 
     * @param deleteVerifiedAccessGroupRequest
     * @return A Java Future containing the result of the DeleteVerifiedAccessGroup operation returned by the service.
     * @sample AmazonEC2Async.DeleteVerifiedAccessGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessGroup" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteVerifiedAccessGroupResult> deleteVerifiedAccessGroupAsync(
            DeleteVerifiedAccessGroupRequest deleteVerifiedAccessGroupRequest);

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access group.
     * </p>
     * 
     * @param deleteVerifiedAccessGroupRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteVerifiedAccessGroup operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteVerifiedAccessGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessGroup" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteVerifiedAccessGroupResult> deleteVerifiedAccessGroupAsync(
            DeleteVerifiedAccessGroupRequest deleteVerifiedAccessGroupRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteVerifiedAccessGroupRequest, DeleteVerifiedAccessGroupResult> asyncHandler);

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access instance.
     * </p>
     * 
     * @param deleteVerifiedAccessInstanceRequest
     * @return A Java Future containing the result of the DeleteVerifiedAccessInstance operation returned by the
     *         service.
     * @sample AmazonEC2Async.DeleteVerifiedAccessInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessInstance"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteVerifiedAccessInstanceResult> deleteVerifiedAccessInstanceAsync(
            DeleteVerifiedAccessInstanceRequest deleteVerifiedAccessInstanceRequest);

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access instance.
     * </p>
     * 
     * @param deleteVerifiedAccessInstanceRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteVerifiedAccessInstance operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DeleteVerifiedAccessInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessInstance"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteVerifiedAccessInstanceResult> deleteVerifiedAccessInstanceAsync(
            DeleteVerifiedAccessInstanceRequest deleteVerifiedAccessInstanceRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteVerifiedAccessInstanceRequest, DeleteVerifiedAccessInstanceResult> asyncHandler);

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access trust provider.
     * </p>
     * 
     * @param deleteVerifiedAccessTrustProviderRequest
     * @return A Java Future containing the result of the DeleteVerifiedAccessTrustProvider operation returned by the
     *         service.
     * @sample AmazonEC2Async.DeleteVerifiedAccessTrustProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessTrustProvider"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteVerifiedAccessTrustProviderResult> deleteVerifiedAccessTrustProviderAsync(
            DeleteVerifiedAccessTrustProviderRequest deleteVerifiedAccessTrustProviderRequest);

    /**
     * <p>
     * Delete an Amazon Web Services Verified Access trust provider.
     * </p>
     * 
     * @param deleteVerifiedAccessTrustProviderRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteVerifiedAccessTrustProvider operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DeleteVerifiedAccessTrustProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessTrustProvider"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteVerifiedAccessTrustProviderResult> deleteVerifiedAccessTrustProviderAsync(
            DeleteVerifiedAccessTrustProviderRequest deleteVerifiedAccessTrustProviderRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteVerifiedAccessTrustProviderRequest, DeleteVerifiedAccessTrustProviderResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified EBS volume. The volume must be in the <code>available</code> state (not attached to an
     * instance).
     * </p>
     * <p>
     * The volume can remain in the <code>deleting</code> state for several minutes.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-deleting-volume.html">Delete an Amazon EBS volume</a>
     * in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param deleteVolumeRequest
     * @return A Java Future containing the result of the DeleteVolume operation returned by the service.
     * @sample AmazonEC2Async.DeleteVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolume" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteVolumeResult> deleteVolumeAsync(DeleteVolumeRequest deleteVolumeRequest);

    /**
     * <p>
     * Deletes the specified EBS volume. The volume must be in the <code>available</code> state (not attached to an
     * instance).
     * </p>
     * <p>
     * The volume can remain in the <code>deleting</code> state for several minutes.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-deleting-volume.html">Delete an Amazon EBS volume</a>
     * in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param deleteVolumeRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteVolume operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolume" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteVolumeResult> deleteVolumeAsync(DeleteVolumeRequest deleteVolumeRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteVolumeRequest, DeleteVolumeResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC
     * before you can delete it. For example, you must terminate all instances running in the VPC, delete all security
     * groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except
     * the default one), and so on. When you delete the VPC, it deletes the VPC's default security group, network ACL,
     * and route table.
     * </p>
     * 
     * @param deleteVpcRequest
     * @return A Java Future containing the result of the DeleteVpc operation returned by the service.
     * @sample AmazonEC2Async.DeleteVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpc" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteVpcResult> deleteVpcAsync(DeleteVpcRequest deleteVpcRequest);

    /**
     * <p>
     * Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC
     * before you can delete it. For example, you must terminate all instances running in the VPC, delete all security
     * groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except
     * the default one), and so on. When you delete the VPC, it deletes the VPC's default security group, network ACL,
     * and route table.
     * </p>
     * 
     * @param deleteVpcRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteVpc operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpc" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteVpcResult> deleteVpcAsync(DeleteVpcRequest deleteVpcRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteVpcRequest, DeleteVpcResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified VPC endpoint connection notifications.
     * </p>
     * 
     * @param deleteVpcEndpointConnectionNotificationsRequest
     * @return A Java Future containing the result of the DeleteVpcEndpointConnectionNotifications operation returned by
     *         the service.
     * @sample AmazonEC2Async.DeleteVpcEndpointConnectionNotifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointConnectionNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteVpcEndpointConnectionNotificationsResult> deleteVpcEndpointConnectionNotificationsAsync(
            DeleteVpcEndpointConnectionNotificationsRequest deleteVpcEndpointConnectionNotificationsRequest);

    /**
     * <p>
     * Deletes the specified VPC endpoint connection notifications.
     * </p>
     * 
     * @param deleteVpcEndpointConnectionNotificationsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteVpcEndpointConnectionNotifications operation returned by
     *         the service.
     * @sample AmazonEC2AsyncHandler.DeleteVpcEndpointConnectionNotifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointConnectionNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteVpcEndpointConnectionNotificationsResult> deleteVpcEndpointConnectionNotificationsAsync(
            DeleteVpcEndpointConnectionNotificationsRequest deleteVpcEndpointConnectionNotificationsRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteVpcEndpointConnectionNotificationsRequest, DeleteVpcEndpointConnectionNotificationsResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified VPC endpoint service configurations. Before you can delete an endpoint service
     * configuration, you must reject any <code>Available</code> or <code>PendingAcceptance</code> interface endpoint
     * connections that are attached to the service.
     * </p>
     * 
     * @param deleteVpcEndpointServiceConfigurationsRequest
     * @return A Java Future containing the result of the DeleteVpcEndpointServiceConfigurations operation returned by
     *         the service.
     * @sample AmazonEC2Async.DeleteVpcEndpointServiceConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteVpcEndpointServiceConfigurationsResult> deleteVpcEndpointServiceConfigurationsAsync(
            DeleteVpcEndpointServiceConfigurationsRequest deleteVpcEndpointServiceConfigurationsRequest);

    /**
     * <p>
     * Deletes the specified VPC endpoint service configurations. Before you can delete an endpoint service
     * configuration, you must reject any <code>Available</code> or <code>PendingAcceptance</code> interface endpoint
     * connections that are attached to the service.
     * </p>
     * 
     * @param deleteVpcEndpointServiceConfigurationsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteVpcEndpointServiceConfigurations operation returned by
     *         the service.
     * @sample AmazonEC2AsyncHandler.DeleteVpcEndpointServiceConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeleteVpcEndpointServiceConfigurationsResult> deleteVpcEndpointServiceConfigurationsAsync(
            DeleteVpcEndpointServiceConfigurationsRequest deleteVpcEndpointServiceConfigurationsRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteVpcEndpointServiceConfigurationsRequest, DeleteVpcEndpointServiceConfigurationsResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified VPC endpoints.
     * </p>
     * <p>
     * When you delete a gateway endpoint, we delete the endpoint routes in the route tables for the endpoint.
     * </p>
     * <p>
     * When you delete a Gateway Load Balancer endpoint, we delete its endpoint network interfaces. You can only delete
     * Gateway Load Balancer endpoints when the routes that are associated with the endpoint are deleted.
     * </p>
     * <p>
     * When you delete an interface endpoint, we delete its endpoint network interfaces.
     * </p>
     * 
     * @param deleteVpcEndpointsRequest
     * @return A Java Future containing the result of the DeleteVpcEndpoints operation returned by the service.
     * @sample AmazonEC2Async.DeleteVpcEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteVpcEndpointsResult> deleteVpcEndpointsAsync(DeleteVpcEndpointsRequest deleteVpcEndpointsRequest);

    /**
     * <p>
     * Deletes the specified VPC endpoints.
     * </p>
     * <p>
     * When you delete a gateway endpoint, we delete the endpoint routes in the route tables for the endpoint.
     * </p>
     * <p>
     * When you delete a Gateway Load Balancer endpoint, we delete its endpoint network interfaces. You can only delete
     * Gateway Load Balancer endpoints when the routes that are associated with the endpoint are deleted.
     * </p>
     * <p>
     * When you delete an interface endpoint, we delete its endpoint network interfaces.
     * </p>
     * 
     * @param deleteVpcEndpointsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteVpcEndpoints operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteVpcEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteVpcEndpointsResult> deleteVpcEndpointsAsync(DeleteVpcEndpointsRequest deleteVpcEndpointsRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteVpcEndpointsRequest, DeleteVpcEndpointsResult> asyncHandler);

    /**
     * <p>
     * Deletes a VPC peering connection. Either the owner of the requester VPC or the owner of the accepter VPC can
     * delete the VPC peering connection if it's in the <code>active</code> state. The owner of the requester VPC can
     * delete a VPC peering connection in the <code>pending-acceptance</code> state. You cannot delete a VPC peering
     * connection that's in the <code>failed</code> or <code>rejected</code> state.
     * </p>
     * 
     * @param deleteVpcPeeringConnectionRequest
     * @return A Java Future containing the result of the DeleteVpcPeeringConnection operation returned by the service.
     * @sample AmazonEC2Async.DeleteVpcPeeringConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnection" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteVpcPeeringConnectionResult> deleteVpcPeeringConnectionAsync(
            DeleteVpcPeeringConnectionRequest deleteVpcPeeringConnectionRequest);

    /**
     * <p>
     * Deletes a VPC peering connection. Either the owner of the requester VPC or the owner of the accepter VPC can
     * delete the VPC peering connection if it's in the <code>active</code> state. The owner of the requester VPC can
     * delete a VPC peering connection in the <code>pending-acceptance</code> state. You cannot delete a VPC peering
     * connection that's in the <code>failed</code> or <code>rejected</code> state.
     * </p>
     * 
     * @param deleteVpcPeeringConnectionRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteVpcPeeringConnection operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteVpcPeeringConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnection" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteVpcPeeringConnectionResult> deleteVpcPeeringConnectionAsync(
            DeleteVpcPeeringConnectionRequest deleteVpcPeeringConnectionRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteVpcPeeringConnectionRequest, DeleteVpcPeeringConnectionResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified VPN connection.
     * </p>
     * <p>
     * If you're deleting the VPC and its associated components, we recommend that you detach the virtual private
     * gateway from the VPC and delete the VPC before deleting the VPN connection. If you believe that the tunnel
     * credentials for your VPN connection have been compromised, you can delete the VPN connection and create a new one
     * that has new keys, without needing to delete the VPC or virtual private gateway. If you create a new VPN
     * connection, you must reconfigure the customer gateway device using the new configuration information returned
     * with the new VPN connection ID.
     * </p>
     * <p>
     * For certificate-based authentication, delete all Certificate Manager (ACM) private certificates used for the
     * Amazon Web Services-side tunnel endpoints for the VPN connection before deleting the VPN connection.
     * </p>
     * 
     * @param deleteVpnConnectionRequest
     *        Contains the parameters for DeleteVpnConnection.
     * @return A Java Future containing the result of the DeleteVpnConnection operation returned by the service.
     * @sample AmazonEC2Async.DeleteVpnConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnection" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteVpnConnectionResult> deleteVpnConnectionAsync(DeleteVpnConnectionRequest deleteVpnConnectionRequest);

    /**
     * <p>
     * Deletes the specified VPN connection.
     * </p>
     * <p>
     * If you're deleting the VPC and its associated components, we recommend that you detach the virtual private
     * gateway from the VPC and delete the VPC before deleting the VPN connection. If you believe that the tunnel
     * credentials for your VPN connection have been compromised, you can delete the VPN connection and create a new one
     * that has new keys, without needing to delete the VPC or virtual private gateway. If you create a new VPN
     * connection, you must reconfigure the customer gateway device using the new configuration information returned
     * with the new VPN connection ID.
     * </p>
     * <p>
     * For certificate-based authentication, delete all Certificate Manager (ACM) private certificates used for the
     * Amazon Web Services-side tunnel endpoints for the VPN connection before deleting the VPN connection.
     * </p>
     * 
     * @param deleteVpnConnectionRequest
     *        Contains the parameters for DeleteVpnConnection.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteVpnConnection operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteVpnConnection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnection" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteVpnConnectionResult> deleteVpnConnectionAsync(DeleteVpnConnectionRequest deleteVpnConnectionRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteVpnConnectionRequest, DeleteVpnConnectionResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified static route associated with a VPN connection between an existing virtual private gateway
     * and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the
     * VPN customer gateway.
     * </p>
     * 
     * @param deleteVpnConnectionRouteRequest
     *        Contains the parameters for DeleteVpnConnectionRoute.
     * @return A Java Future containing the result of the DeleteVpnConnectionRoute operation returned by the service.
     * @sample AmazonEC2Async.DeleteVpnConnectionRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRoute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteVpnConnectionRouteResult> deleteVpnConnectionRouteAsync(DeleteVpnConnectionRouteRequest deleteVpnConnectionRouteRequest);

    /**
     * <p>
     * Deletes the specified static route associated with a VPN connection between an existing virtual private gateway
     * and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the
     * VPN customer gateway.
     * </p>
     * 
     * @param deleteVpnConnectionRouteRequest
     *        Contains the parameters for DeleteVpnConnectionRoute.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteVpnConnectionRoute operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteVpnConnectionRoute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRoute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeleteVpnConnectionRouteResult> deleteVpnConnectionRouteAsync(DeleteVpnConnectionRouteRequest deleteVpnConnectionRouteRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteVpnConnectionRouteRequest, DeleteVpnConnectionRouteResult> asyncHandler);

    /**
     * <p>
     * Deletes the specified virtual private gateway. You must first detach the virtual private gateway from the VPC.
     * Note that you don't need to delete the virtual private gateway if you plan to delete and recreate the VPN
     * connection between your VPC and your network.
     * </p>
     * 
     * @param deleteVpnGatewayRequest
     *        Contains the parameters for DeleteVpnGateway.
     * @return A Java Future containing the result of the DeleteVpnGateway operation returned by the service.
     * @sample AmazonEC2Async.DeleteVpnGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteVpnGatewayResult> deleteVpnGatewayAsync(DeleteVpnGatewayRequest deleteVpnGatewayRequest);

    /**
     * <p>
     * Deletes the specified virtual private gateway. You must first detach the virtual private gateway from the VPC.
     * Note that you don't need to delete the virtual private gateway if you plan to delete and recreate the VPN
     * connection between your VPC and your network.
     * </p>
     * 
     * @param deleteVpnGatewayRequest
     *        Contains the parameters for DeleteVpnGateway.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeleteVpnGateway operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeleteVpnGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeleteVpnGatewayResult> deleteVpnGatewayAsync(DeleteVpnGatewayRequest deleteVpnGatewayRequest,
            com.amazonaws.handlers.AsyncHandler<DeleteVpnGatewayRequest, DeleteVpnGatewayResult> asyncHandler);

    /**
     * <p>
     * Releases the specified address range that you provisioned for use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     * </p>
     * <p>
     * Before you can release an address range, you must stop advertising it using <a>WithdrawByoipCidr</a> and you must
     * not have any IP addresses allocated from its address range.
     * </p>
     * 
     * @param deprovisionByoipCidrRequest
     * @return A Java Future containing the result of the DeprovisionByoipCidr operation returned by the service.
     * @sample AmazonEC2Async.DeprovisionByoipCidr
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionByoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeprovisionByoipCidrResult> deprovisionByoipCidrAsync(DeprovisionByoipCidrRequest deprovisionByoipCidrRequest);

    /**
     * <p>
     * Releases the specified address range that you provisioned for use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     * </p>
     * <p>
     * Before you can release an address range, you must stop advertising it using <a>WithdrawByoipCidr</a> and you must
     * not have any IP addresses allocated from its address range.
     * </p>
     * 
     * @param deprovisionByoipCidrRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeprovisionByoipCidr operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeprovisionByoipCidr
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionByoipCidr" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeprovisionByoipCidrResult> deprovisionByoipCidrAsync(DeprovisionByoipCidrRequest deprovisionByoipCidrRequest,
            com.amazonaws.handlers.AsyncHandler<DeprovisionByoipCidrRequest, DeprovisionByoipCidrResult> asyncHandler);

    /**
     * <p>
     * Deprovisions your Autonomous System Number (ASN) from your Amazon Web Services account. This action can only be
     * called after any BYOIP CIDR associations are removed from your Amazon Web Services account with <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIpamByoasn.html"
     * >DisassociateIpamByoasn</a>. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in
     * the <i>Amazon VPC IPAM guide</i>.
     * </p>
     * 
     * @param deprovisionIpamByoasnRequest
     * @return A Java Future containing the result of the DeprovisionIpamByoasn operation returned by the service.
     * @sample AmazonEC2Async.DeprovisionIpamByoasn
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamByoasn" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeprovisionIpamByoasnResult> deprovisionIpamByoasnAsync(DeprovisionIpamByoasnRequest deprovisionIpamByoasnRequest);

    /**
     * <p>
     * Deprovisions your Autonomous System Number (ASN) from your Amazon Web Services account. This action can only be
     * called after any BYOIP CIDR associations are removed from your Amazon Web Services account with <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIpamByoasn.html"
     * >DisassociateIpamByoasn</a>. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in
     * the <i>Amazon VPC IPAM guide</i>.
     * </p>
     * 
     * @param deprovisionIpamByoasnRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeprovisionIpamByoasn operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeprovisionIpamByoasn
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamByoasn" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeprovisionIpamByoasnResult> deprovisionIpamByoasnAsync(DeprovisionIpamByoasnRequest deprovisionIpamByoasnRequest,
            com.amazonaws.handlers.AsyncHandler<DeprovisionIpamByoasnRequest, DeprovisionIpamByoasnResult> asyncHandler);

    /**
     * <p>
     * Deprovision a CIDR provisioned from an IPAM pool. If you deprovision a CIDR from a pool that has a source pool,
     * the CIDR is recycled back into the source pool. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/depro-pool-cidr-ipam.html">Deprovision pool CIDRs</a> in the
     * <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * 
     * @param deprovisionIpamPoolCidrRequest
     * @return A Java Future containing the result of the DeprovisionIpamPoolCidr operation returned by the service.
     * @sample AmazonEC2Async.DeprovisionIpamPoolCidr
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamPoolCidr" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeprovisionIpamPoolCidrResult> deprovisionIpamPoolCidrAsync(DeprovisionIpamPoolCidrRequest deprovisionIpamPoolCidrRequest);

    /**
     * <p>
     * Deprovision a CIDR provisioned from an IPAM pool. If you deprovision a CIDR from a pool that has a source pool,
     * the CIDR is recycled back into the source pool. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/depro-pool-cidr-ipam.html">Deprovision pool CIDRs</a> in the
     * <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * 
     * @param deprovisionIpamPoolCidrRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeprovisionIpamPoolCidr operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeprovisionIpamPoolCidr
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamPoolCidr" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DeprovisionIpamPoolCidrResult> deprovisionIpamPoolCidrAsync(DeprovisionIpamPoolCidrRequest deprovisionIpamPoolCidrRequest,
            com.amazonaws.handlers.AsyncHandler<DeprovisionIpamPoolCidrRequest, DeprovisionIpamPoolCidrResult> asyncHandler);

    /**
     * <p>
     * Deprovision a CIDR from a public IPv4 pool.
     * </p>
     * 
     * @param deprovisionPublicIpv4PoolCidrRequest
     * @return A Java Future containing the result of the DeprovisionPublicIpv4PoolCidr operation returned by the
     *         service.
     * @sample AmazonEC2Async.DeprovisionPublicIpv4PoolCidr
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionPublicIpv4PoolCidr"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeprovisionPublicIpv4PoolCidrResult> deprovisionPublicIpv4PoolCidrAsync(
            DeprovisionPublicIpv4PoolCidrRequest deprovisionPublicIpv4PoolCidrRequest);

    /**
     * <p>
     * Deprovision a CIDR from a public IPv4 pool.
     * </p>
     * 
     * @param deprovisionPublicIpv4PoolCidrRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeprovisionPublicIpv4PoolCidr operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DeprovisionPublicIpv4PoolCidr
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionPublicIpv4PoolCidr"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeprovisionPublicIpv4PoolCidrResult> deprovisionPublicIpv4PoolCidrAsync(
            DeprovisionPublicIpv4PoolCidrRequest deprovisionPublicIpv4PoolCidrRequest,
            com.amazonaws.handlers.AsyncHandler<DeprovisionPublicIpv4PoolCidrRequest, DeprovisionPublicIpv4PoolCidrResult> asyncHandler);

    /**
     * <p>
     * Deregisters the specified AMI. After you deregister an AMI, it can't be used to launch new instances.
     * </p>
     * <p>
     * If you deregister an AMI that matches a Recycle Bin retention rule, the AMI is retained in the Recycle Bin for
     * the specified retention period. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin.html">Recycle Bin</a> in the <i>Amazon EC2
     * User Guide</i>.
     * </p>
     * <p>
     * When you deregister an AMI, it doesn't affect any instances that you've already launched from the AMI. You'll
     * continue to incur usage costs for those instances until you terminate them.
     * </p>
     * <p>
     * When you deregister an Amazon EBS-backed AMI, it doesn't affect the snapshot that was created for the root volume
     * of the instance during the AMI creation process. When you deregister an instance store-backed AMI, it doesn't
     * affect the files that you uploaded to Amazon S3 when you created the AMI.
     * </p>
     * 
     * @param deregisterImageRequest
     *        Contains the parameters for DeregisterImage.
     * @return A Java Future containing the result of the DeregisterImage operation returned by the service.
     * @sample AmazonEC2Async.DeregisterImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImage" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeregisterImageResult> deregisterImageAsync(DeregisterImageRequest deregisterImageRequest);

    /**
     * <p>
     * Deregisters the specified AMI. After you deregister an AMI, it can't be used to launch new instances.
     * </p>
     * <p>
     * If you deregister an AMI that matches a Recycle Bin retention rule, the AMI is retained in the Recycle Bin for
     * the specified retention period. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin.html">Recycle Bin</a> in the <i>Amazon EC2
     * User Guide</i>.
     * </p>
     * <p>
     * When you deregister an AMI, it doesn't affect any instances that you've already launched from the AMI. You'll
     * continue to incur usage costs for those instances until you terminate them.
     * </p>
     * <p>
     * When you deregister an Amazon EBS-backed AMI, it doesn't affect the snapshot that was created for the root volume
     * of the instance during the AMI creation process. When you deregister an instance store-backed AMI, it doesn't
     * affect the files that you uploaded to Amazon S3 when you created the AMI.
     * </p>
     * 
     * @param deregisterImageRequest
     *        Contains the parameters for DeregisterImage.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeregisterImage operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DeregisterImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImage" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DeregisterImageResult> deregisterImageAsync(DeregisterImageRequest deregisterImageRequest,
            com.amazonaws.handlers.AsyncHandler<DeregisterImageRequest, DeregisterImageResult> asyncHandler);

    /**
     * <p>
     * Deregisters tag keys to prevent tags that have the specified tag keys from being included in scheduled event
     * notifications for resources in the Region.
     * </p>
     * 
     * @param deregisterInstanceEventNotificationAttributesRequest
     * @return A Java Future containing the result of the DeregisterInstanceEventNotificationAttributes operation
     *         returned by the service.
     * @sample AmazonEC2Async.DeregisterInstanceEventNotificationAttributes
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterInstanceEventNotificationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeregisterInstanceEventNotificationAttributesResult> deregisterInstanceEventNotificationAttributesAsync(
            DeregisterInstanceEventNotificationAttributesRequest deregisterInstanceEventNotificationAttributesRequest);

    /**
     * <p>
     * Deregisters tag keys to prevent tags that have the specified tag keys from being included in scheduled event
     * notifications for resources in the Region.
     * </p>
     * 
     * @param deregisterInstanceEventNotificationAttributesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeregisterInstanceEventNotificationAttributes operation
     *         returned by the service.
     * @sample AmazonEC2AsyncHandler.DeregisterInstanceEventNotificationAttributes
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterInstanceEventNotificationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeregisterInstanceEventNotificationAttributesResult> deregisterInstanceEventNotificationAttributesAsync(
            DeregisterInstanceEventNotificationAttributesRequest deregisterInstanceEventNotificationAttributesRequest,
            com.amazonaws.handlers.AsyncHandler<DeregisterInstanceEventNotificationAttributesRequest, DeregisterInstanceEventNotificationAttributesResult> asyncHandler);

    /**
     * <p>
     * Deregisters the specified members (network interfaces) from the transit gateway multicast group.
     * </p>
     * 
     * @param deregisterTransitGatewayMulticastGroupMembersRequest
     * @return A Java Future containing the result of the DeregisterTransitGatewayMulticastGroupMembers operation
     *         returned by the service.
     * @sample AmazonEC2Async.DeregisterTransitGatewayMulticastGroupMembers
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupMembers"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeregisterTransitGatewayMulticastGroupMembersResult> deregisterTransitGatewayMulticastGroupMembersAsync(
            DeregisterTransitGatewayMulticastGroupMembersRequest deregisterTransitGatewayMulticastGroupMembersRequest);

    /**
     * <p>
     * Deregisters the specified members (network interfaces) from the transit gateway multicast group.
     * </p>
     * 
     * @param deregisterTransitGatewayMulticastGroupMembersRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeregisterTransitGatewayMulticastGroupMembers operation
     *         returned by the service.
     * @sample AmazonEC2AsyncHandler.DeregisterTransitGatewayMulticastGroupMembers
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupMembers"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeregisterTransitGatewayMulticastGroupMembersResult> deregisterTransitGatewayMulticastGroupMembersAsync(
            DeregisterTransitGatewayMulticastGroupMembersRequest deregisterTransitGatewayMulticastGroupMembersRequest,
            com.amazonaws.handlers.AsyncHandler<DeregisterTransitGatewayMulticastGroupMembersRequest, DeregisterTransitGatewayMulticastGroupMembersResult> asyncHandler);

    /**
     * <p>
     * Deregisters the specified sources (network interfaces) from the transit gateway multicast group.
     * </p>
     * 
     * @param deregisterTransitGatewayMulticastGroupSourcesRequest
     * @return A Java Future containing the result of the DeregisterTransitGatewayMulticastGroupSources operation
     *         returned by the service.
     * @sample AmazonEC2Async.DeregisterTransitGatewayMulticastGroupSources
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupSources"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeregisterTransitGatewayMulticastGroupSourcesResult> deregisterTransitGatewayMulticastGroupSourcesAsync(
            DeregisterTransitGatewayMulticastGroupSourcesRequest deregisterTransitGatewayMulticastGroupSourcesRequest);

    /**
     * <p>
     * Deregisters the specified sources (network interfaces) from the transit gateway multicast group.
     * </p>
     * 
     * @param deregisterTransitGatewayMulticastGroupSourcesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DeregisterTransitGatewayMulticastGroupSources operation
     *         returned by the service.
     * @sample AmazonEC2AsyncHandler.DeregisterTransitGatewayMulticastGroupSources
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupSources"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DeregisterTransitGatewayMulticastGroupSourcesResult> deregisterTransitGatewayMulticastGroupSourcesAsync(
            DeregisterTransitGatewayMulticastGroupSourcesRequest deregisterTransitGatewayMulticastGroupSourcesRequest,
            com.amazonaws.handlers.AsyncHandler<DeregisterTransitGatewayMulticastGroupSourcesRequest, DeregisterTransitGatewayMulticastGroupSourcesResult> asyncHandler);

    /**
     * <p>
     * Describes attributes of your Amazon Web Services account. The following are the supported account attributes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>default-vpc</code>: The ID of the default VPC for your account, or <code>none</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>max-instances</code>: This attribute is no longer supported. The returned value does not reflect your
     * actual vCPU limit for running On-Demand Instances. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-on-demand-instances.html#ec2-on-demand-instances-limits"
     * >On-Demand Instance Limits</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>supported-platforms</code>: This attribute is deprecated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-max-security-groups-per-interface</code>: The maximum number of security groups that you can assign to
     * a network interface.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeAccountAttributesRequest
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.
     * @sample AmazonEC2Async.DescribeAccountAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeAccountAttributesResult> describeAccountAttributesAsync(
            DescribeAccountAttributesRequest describeAccountAttributesRequest);

    /**
     * <p>
     * Describes attributes of your Amazon Web Services account. The following are the supported account attributes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>default-vpc</code>: The ID of the default VPC for your account, or <code>none</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>max-instances</code>: This attribute is no longer supported. The returned value does not reflect your
     * actual vCPU limit for running On-Demand Instances. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-on-demand-instances.html#ec2-on-demand-instances-limits"
     * >On-Demand Instance Limits</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>supported-platforms</code>: This attribute is deprecated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-max-elastic-ips</code>: The maximum number of Elastic IP addresses that you can allocate.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-max-security-groups-per-interface</code>: The maximum number of security groups that you can assign to
     * a network interface.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeAccountAttributesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeAccountAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeAccountAttributesResult> describeAccountAttributesAsync(
            DescribeAccountAttributesRequest describeAccountAttributesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeAccountAttributesRequest, DescribeAccountAttributesResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeAccountAttributes operation.
     *
     * @see #describeAccountAttributesAsync(DescribeAccountAttributesRequest)
     */
    java.util.concurrent.Future<DescribeAccountAttributesResult> describeAccountAttributesAsync();

    /**
     * Simplified method form for invoking the DescribeAccountAttributes operation with an AsyncHandler.
     *
     * @see #describeAccountAttributesAsync(DescribeAccountAttributesRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeAccountAttributesResult> describeAccountAttributesAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeAccountAttributesRequest, DescribeAccountAttributesResult> asyncHandler);

    /**
     * <p>
     * Describes an Elastic IP address transfer. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#transfer-EIPs-intro">Transfer Elastic IP
     * addresses</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * When you transfer an Elastic IP address, there is a two-step handshake between the source and transfer Amazon Web
     * Services accounts. When the source account starts the transfer, the transfer account has seven days to accept the
     * Elastic IP address transfer. During those seven days, the source account can view the pending transfer by using
     * this action. After seven days, the transfer expires and ownership of the Elastic IP address returns to the source
     * account. Accepted transfers are visible to the source account for three days after the transfers have been
     * accepted.
     * </p>
     * 
     * @param describeAddressTransfersRequest
     * @return A Java Future containing the result of the DescribeAddressTransfers operation returned by the service.
     * @sample AmazonEC2Async.DescribeAddressTransfers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressTransfers" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeAddressTransfersResult> describeAddressTransfersAsync(DescribeAddressTransfersRequest describeAddressTransfersRequest);

    /**
     * <p>
     * Describes an Elastic IP address transfer. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#transfer-EIPs-intro">Transfer Elastic IP
     * addresses</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.
     * </p>
     * <p>
     * When you transfer an Elastic IP address, there is a two-step handshake between the source and transfer Amazon Web
     * Services accounts. When the source account starts the transfer, the transfer account has seven days to accept the
     * Elastic IP address transfer. During those seven days, the source account can view the pending transfer by using
     * this action. After seven days, the transfer expires and ownership of the Elastic IP address returns to the source
     * account. Accepted transfers are visible to the source account for three days after the transfers have been
     * accepted.
     * </p>
     * 
     * @param describeAddressTransfersRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeAddressTransfers operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeAddressTransfers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressTransfers" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeAddressTransfersResult> describeAddressTransfersAsync(DescribeAddressTransfersRequest describeAddressTransfersRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeAddressTransfersRequest, DescribeAddressTransfersResult> asyncHandler);

    /**
     * <p>
     * Describes the specified Elastic IP addresses or all of your Elastic IP addresses.
     * </p>
     * 
     * @param describeAddressesRequest
     * @return A Java Future containing the result of the DescribeAddresses operation returned by the service.
     * @sample AmazonEC2Async.DescribeAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddresses" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeAddressesResult> describeAddressesAsync(DescribeAddressesRequest describeAddressesRequest);

    /**
     * <p>
     * Describes the specified Elastic IP addresses or all of your Elastic IP addresses.
     * </p>
     * 
     * @param describeAddressesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeAddresses operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddresses" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeAddressesResult> describeAddressesAsync(DescribeAddressesRequest describeAddressesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeAddressesRequest, DescribeAddressesResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeAddresses operation.
     *
     * @see #describeAddressesAsync(DescribeAddressesRequest)
     */
    java.util.concurrent.Future<DescribeAddressesResult> describeAddressesAsync();

    /**
     * Simplified method form for invoking the DescribeAddresses operation with an AsyncHandler.
     *
     * @see #describeAddressesAsync(DescribeAddressesRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeAddressesResult> describeAddressesAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeAddressesRequest, DescribeAddressesResult> asyncHandler);

    /**
     * <p>
     * Describes the attributes of the specified Elastic IP addresses. For requirements, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS"
     * >Using reverse DNS for email applications</a>.
     * </p>
     * 
     * @param describeAddressesAttributeRequest
     * @return A Java Future containing the result of the DescribeAddressesAttribute operation returned by the service.
     * @sample AmazonEC2Async.DescribeAddressesAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeAddressesAttributeResult> describeAddressesAttributeAsync(
            DescribeAddressesAttributeRequest describeAddressesAttributeRequest);

    /**
     * <p>
     * Describes the attributes of the specified Elastic IP addresses. For requirements, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS"
     * >Using reverse DNS for email applications</a>.
     * </p>
     * 
     * @param describeAddressesAttributeRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeAddressesAttribute operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeAddressesAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeAddressesAttributeResult> describeAddressesAttributeAsync(
            DescribeAddressesAttributeRequest describeAddressesAttributeRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeAddressesAttributeRequest, DescribeAddressesAttributeResult> asyncHandler);

    /**
     * <p>
     * Describes the longer ID format settings for all resource types in a specific Region. This request is useful for
     * performing a quick audit to determine whether a specific Region is fully opted in for longer IDs (17-character
     * IDs).
     * </p>
     * <p>
     * This request only returns information about resource types that support longer IDs.
     * </p>
     * <p>
     * The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> |
     * <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> |
     * <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     * <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     * <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code>
     * | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> |
     * <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code>
     * | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> |
     * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
     * <code>vpn-connection</code> | <code>vpn-gateway</code>.
     * </p>
     * 
     * @param describeAggregateIdFormatRequest
     * @return A Java Future containing the result of the DescribeAggregateIdFormat operation returned by the service.
     * @sample AmazonEC2Async.DescribeAggregateIdFormat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAggregateIdFormat" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeAggregateIdFormatResult> describeAggregateIdFormatAsync(
            DescribeAggregateIdFormatRequest describeAggregateIdFormatRequest);

    /**
     * <p>
     * Describes the longer ID format settings for all resource types in a specific Region. This request is useful for
     * performing a quick audit to determine whether a specific Region is fully opted in for longer IDs (17-character
     * IDs).
     * </p>
     * <p>
     * This request only returns information about resource types that support longer IDs.
     * </p>
     * <p>
     * The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> |
     * <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> |
     * <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     * <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     * <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code>
     * | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> |
     * <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code>
     * | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> |
     * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
     * <code>vpn-connection</code> | <code>vpn-gateway</code>.
     * </p>
     * 
     * @param describeAggregateIdFormatRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeAggregateIdFormat operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeAggregateIdFormat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAggregateIdFormat" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeAggregateIdFormatResult> describeAggregateIdFormatAsync(
            DescribeAggregateIdFormatRequest describeAggregateIdFormatRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeAggregateIdFormatRequest, DescribeAggregateIdFormatResult> asyncHandler);

    /**
     * <p>
     * Describes the Availability Zones, Local Zones, and Wavelength Zones that are available to you. If there is an
     * event impacting a zone, you can use this request to view the state and any provided messages for that zone.
     * </p>
     * <p>
     * For more information about Availability Zones, Local Zones, and Wavelength Zones, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html">Regions and
     * zones</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeAvailabilityZonesRequest
     * @return A Java Future containing the result of the DescribeAvailabilityZones operation returned by the service.
     * @sample AmazonEC2Async.DescribeAvailabilityZones
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZones" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeAvailabilityZonesResult> describeAvailabilityZonesAsync(
            DescribeAvailabilityZonesRequest describeAvailabilityZonesRequest);

    /**
     * <p>
     * Describes the Availability Zones, Local Zones, and Wavelength Zones that are available to you. If there is an
     * event impacting a zone, you can use this request to view the state and any provided messages for that zone.
     * </p>
     * <p>
     * For more information about Availability Zones, Local Zones, and Wavelength Zones, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html">Regions and
     * zones</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeAvailabilityZonesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeAvailabilityZones operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeAvailabilityZones
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZones" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeAvailabilityZonesResult> describeAvailabilityZonesAsync(
            DescribeAvailabilityZonesRequest describeAvailabilityZonesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeAvailabilityZonesRequest, DescribeAvailabilityZonesResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeAvailabilityZones operation.
     *
     * @see #describeAvailabilityZonesAsync(DescribeAvailabilityZonesRequest)
     */
    java.util.concurrent.Future<DescribeAvailabilityZonesResult> describeAvailabilityZonesAsync();

    /**
     * Simplified method form for invoking the DescribeAvailabilityZones operation with an AsyncHandler.
     *
     * @see #describeAvailabilityZonesAsync(DescribeAvailabilityZonesRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeAvailabilityZonesResult> describeAvailabilityZonesAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeAvailabilityZonesRequest, DescribeAvailabilityZonesResult> asyncHandler);

    /**
     * <p>
     * Describes the current Infrastructure Performance metric subscriptions.
     * </p>
     * 
     * @param describeAwsNetworkPerformanceMetricSubscriptionsRequest
     * @return A Java Future containing the result of the DescribeAwsNetworkPerformanceMetricSubscriptions operation
     *         returned by the service.
     * @sample AmazonEC2Async.DescribeAwsNetworkPerformanceMetricSubscriptions
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAwsNetworkPerformanceMetricSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeAwsNetworkPerformanceMetricSubscriptionsResult> describeAwsNetworkPerformanceMetricSubscriptionsAsync(
            DescribeAwsNetworkPerformanceMetricSubscriptionsRequest describeAwsNetworkPerformanceMetricSubscriptionsRequest);

    /**
     * <p>
     * Describes the current Infrastructure Performance metric subscriptions.
     * </p>
     * 
     * @param describeAwsNetworkPerformanceMetricSubscriptionsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeAwsNetworkPerformanceMetricSubscriptions operation
     *         returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeAwsNetworkPerformanceMetricSubscriptions
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAwsNetworkPerformanceMetricSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeAwsNetworkPerformanceMetricSubscriptionsResult> describeAwsNetworkPerformanceMetricSubscriptionsAsync(
            DescribeAwsNetworkPerformanceMetricSubscriptionsRequest describeAwsNetworkPerformanceMetricSubscriptionsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeAwsNetworkPerformanceMetricSubscriptionsRequest, DescribeAwsNetworkPerformanceMetricSubscriptionsResult> asyncHandler);

    /**
     * <p>
     * Describes the specified bundle tasks or all of your bundle tasks.
     * </p>
     * <note>
     * <p>
     * Completed bundle tasks are listed for only a limited time. If your bundle task is no longer in the list, you can
     * still register an AMI from it. Just use <code>RegisterImage</code> with the Amazon S3 bucket name and image
     * manifest name you provided to the bundle task.
     * </p>
     * </note> <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeBundleTasksRequest
     * @return A Java Future containing the result of the DescribeBundleTasks operation returned by the service.
     * @sample AmazonEC2Async.DescribeBundleTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasks" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeBundleTasksResult> describeBundleTasksAsync(DescribeBundleTasksRequest describeBundleTasksRequest);

    /**
     * <p>
     * Describes the specified bundle tasks or all of your bundle tasks.
     * </p>
     * <note>
     * <p>
     * Completed bundle tasks are listed for only a limited time. If your bundle task is no longer in the list, you can
     * still register an AMI from it. Just use <code>RegisterImage</code> with the Amazon S3 bucket name and image
     * manifest name you provided to the bundle task.
     * </p>
     * </note> <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeBundleTasksRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeBundleTasks operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeBundleTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasks" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeBundleTasksResult> describeBundleTasksAsync(DescribeBundleTasksRequest describeBundleTasksRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeBundleTasksRequest, DescribeBundleTasksResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeBundleTasks operation.
     *
     * @see #describeBundleTasksAsync(DescribeBundleTasksRequest)
     */
    java.util.concurrent.Future<DescribeBundleTasksResult> describeBundleTasksAsync();

    /**
     * Simplified method form for invoking the DescribeBundleTasks operation with an AsyncHandler.
     *
     * @see #describeBundleTasksAsync(DescribeBundleTasksRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeBundleTasksResult> describeBundleTasksAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeBundleTasksRequest, DescribeBundleTasksResult> asyncHandler);

    /**
     * <p>
     * Describes the IP address ranges that were specified in calls to <a>ProvisionByoipCidr</a>.
     * </p>
     * <p>
     * To describe the address pools that were created when you provisioned the address ranges, use
     * <a>DescribePublicIpv4Pools</a> or <a>DescribeIpv6Pools</a>.
     * </p>
     * 
     * @param describeByoipCidrsRequest
     * @return A Java Future containing the result of the DescribeByoipCidrs operation returned by the service.
     * @sample AmazonEC2Async.DescribeByoipCidrs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeByoipCidrs" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeByoipCidrsResult> describeByoipCidrsAsync(DescribeByoipCidrsRequest describeByoipCidrsRequest);

    /**
     * <p>
     * Describes the IP address ranges that were specified in calls to <a>ProvisionByoipCidr</a>.
     * </p>
     * <p>
     * To describe the address pools that were created when you provisioned the address ranges, use
     * <a>DescribePublicIpv4Pools</a> or <a>DescribeIpv6Pools</a>.
     * </p>
     * 
     * @param describeByoipCidrsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeByoipCidrs operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeByoipCidrs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeByoipCidrs" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeByoipCidrsResult> describeByoipCidrsAsync(DescribeByoipCidrsRequest describeByoipCidrsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeByoipCidrsRequest, DescribeByoipCidrsResult> asyncHandler);

    /**
     * <p>
     * Describes Capacity Block offerings available for purchase in the Amazon Web Services Region that you're currently
     * using. With Capacity Blocks, you purchase a specific instance type for a period of time.
     * </p>
     * 
     * @param describeCapacityBlockOfferingsRequest
     * @return A Java Future containing the result of the DescribeCapacityBlockOfferings operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeCapacityBlockOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityBlockOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeCapacityBlockOfferingsResult> describeCapacityBlockOfferingsAsync(
            DescribeCapacityBlockOfferingsRequest describeCapacityBlockOfferingsRequest);

    /**
     * <p>
     * Describes Capacity Block offerings available for purchase in the Amazon Web Services Region that you're currently
     * using. With Capacity Blocks, you purchase a specific instance type for a period of time.
     * </p>
     * 
     * @param describeCapacityBlockOfferingsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeCapacityBlockOfferings operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeCapacityBlockOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityBlockOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeCapacityBlockOfferingsResult> describeCapacityBlockOfferingsAsync(
            DescribeCapacityBlockOfferingsRequest describeCapacityBlockOfferingsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeCapacityBlockOfferingsRequest, DescribeCapacityBlockOfferingsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more Capacity Reservation Fleets.
     * </p>
     * 
     * @param describeCapacityReservationFleetsRequest
     * @return A Java Future containing the result of the DescribeCapacityReservationFleets operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeCapacityReservationFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservationFleets"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeCapacityReservationFleetsResult> describeCapacityReservationFleetsAsync(
            DescribeCapacityReservationFleetsRequest describeCapacityReservationFleetsRequest);

    /**
     * <p>
     * Describes one or more Capacity Reservation Fleets.
     * </p>
     * 
     * @param describeCapacityReservationFleetsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeCapacityReservationFleets operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeCapacityReservationFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservationFleets"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeCapacityReservationFleetsResult> describeCapacityReservationFleetsAsync(
            DescribeCapacityReservationFleetsRequest describeCapacityReservationFleetsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeCapacityReservationFleetsRequest, DescribeCapacityReservationFleetsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the
     * Amazon Web Services Region that you're currently using.
     * </p>
     * 
     * @param describeCapacityReservationsRequest
     * @return A Java Future containing the result of the DescribeCapacityReservations operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeCapacityReservations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeCapacityReservationsResult> describeCapacityReservationsAsync(
            DescribeCapacityReservationsRequest describeCapacityReservationsRequest);

    /**
     * <p>
     * Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the
     * Amazon Web Services Region that you're currently using.
     * </p>
     * 
     * @param describeCapacityReservationsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeCapacityReservations operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeCapacityReservations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeCapacityReservationsResult> describeCapacityReservationsAsync(
            DescribeCapacityReservationsRequest describeCapacityReservationsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeCapacityReservationsRequest, DescribeCapacityReservationsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more of your carrier gateways.
     * </p>
     * 
     * @param describeCarrierGatewaysRequest
     * @return A Java Future containing the result of the DescribeCarrierGateways operation returned by the service.
     * @sample AmazonEC2Async.DescribeCarrierGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCarrierGateways" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeCarrierGatewaysResult> describeCarrierGatewaysAsync(DescribeCarrierGatewaysRequest describeCarrierGatewaysRequest);

    /**
     * <p>
     * Describes one or more of your carrier gateways.
     * </p>
     * 
     * @param describeCarrierGatewaysRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeCarrierGateways operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeCarrierGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCarrierGateways" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeCarrierGatewaysResult> describeCarrierGatewaysAsync(DescribeCarrierGatewaysRequest describeCarrierGatewaysRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeCarrierGatewaysRequest, DescribeCarrierGatewaysResult> asyncHandler);

    /**
     * <note>
     * <p>
     * This action is deprecated.
     * </p>
     * </note>
     * <p>
     * Describes one or more of your linked EC2-Classic instances. This request only returns information about
     * EC2-Classic instances linked to a VPC through ClassicLink. You cannot use this request to return information
     * about other instances.
     * </p>
     * 
     * @param describeClassicLinkInstancesRequest
     * @return A Java Future containing the result of the DescribeClassicLinkInstances operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeClassicLinkInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClassicLinkInstances"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeClassicLinkInstancesResult> describeClassicLinkInstancesAsync(
            DescribeClassicLinkInstancesRequest describeClassicLinkInstancesRequest);

    /**
     * <note>
     * <p>
     * This action is deprecated.
     * </p>
     * </note>
     * <p>
     * Describes one or more of your linked EC2-Classic instances. This request only returns information about
     * EC2-Classic instances linked to a VPC through ClassicLink. You cannot use this request to return information
     * about other instances.
     * </p>
     * 
     * @param describeClassicLinkInstancesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeClassicLinkInstances operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeClassicLinkInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClassicLinkInstances"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeClassicLinkInstancesResult> describeClassicLinkInstancesAsync(
            DescribeClassicLinkInstancesRequest describeClassicLinkInstancesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeClassicLinkInstancesRequest, DescribeClassicLinkInstancesResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeClassicLinkInstances operation.
     *
     * @see #describeClassicLinkInstancesAsync(DescribeClassicLinkInstancesRequest)
     */
    java.util.concurrent.Future<DescribeClassicLinkInstancesResult> describeClassicLinkInstancesAsync();

    /**
     * Simplified method form for invoking the DescribeClassicLinkInstances operation with an AsyncHandler.
     *
     * @see #describeClassicLinkInstancesAsync(DescribeClassicLinkInstancesRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeClassicLinkInstancesResult> describeClassicLinkInstancesAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeClassicLinkInstancesRequest, DescribeClassicLinkInstancesResult> asyncHandler);

    /**
     * <p>
     * Describes the authorization rules for a specified Client VPN endpoint.
     * </p>
     * 
     * @param describeClientVpnAuthorizationRulesRequest
     * @return A Java Future containing the result of the DescribeClientVpnAuthorizationRules operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeClientVpnAuthorizationRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnAuthorizationRules"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeClientVpnAuthorizationRulesResult> describeClientVpnAuthorizationRulesAsync(
            DescribeClientVpnAuthorizationRulesRequest describeClientVpnAuthorizationRulesRequest);

    /**
     * <p>
     * Describes the authorization rules for a specified Client VPN endpoint.
     * </p>
     * 
     * @param describeClientVpnAuthorizationRulesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeClientVpnAuthorizationRules operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeClientVpnAuthorizationRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnAuthorizationRules"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeClientVpnAuthorizationRulesResult> describeClientVpnAuthorizationRulesAsync(
            DescribeClientVpnAuthorizationRulesRequest describeClientVpnAuthorizationRulesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeClientVpnAuthorizationRulesRequest, DescribeClientVpnAuthorizationRulesResult> asyncHandler);

    /**
     * <p>
     * Describes active client connections and connections that have been terminated within the last 60 minutes for the
     * specified Client VPN endpoint.
     * </p>
     * 
     * @param describeClientVpnConnectionsRequest
     * @return A Java Future containing the result of the DescribeClientVpnConnections operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeClientVpnConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnConnections"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeClientVpnConnectionsResult> describeClientVpnConnectionsAsync(
            DescribeClientVpnConnectionsRequest describeClientVpnConnectionsRequest);

    /**
     * <p>
     * Describes active client connections and connections that have been terminated within the last 60 minutes for the
     * specified Client VPN endpoint.
     * </p>
     * 
     * @param describeClientVpnConnectionsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeClientVpnConnections operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeClientVpnConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnConnections"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeClientVpnConnectionsResult> describeClientVpnConnectionsAsync(
            DescribeClientVpnConnectionsRequest describeClientVpnConnectionsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeClientVpnConnectionsRequest, DescribeClientVpnConnectionsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more Client VPN endpoints in the account.
     * </p>
     * 
     * @param describeClientVpnEndpointsRequest
     * @return A Java Future containing the result of the DescribeClientVpnEndpoints operation returned by the service.
     * @sample AmazonEC2Async.DescribeClientVpnEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeClientVpnEndpointsResult> describeClientVpnEndpointsAsync(
            DescribeClientVpnEndpointsRequest describeClientVpnEndpointsRequest);

    /**
     * <p>
     * Describes one or more Client VPN endpoints in the account.
     * </p>
     * 
     * @param describeClientVpnEndpointsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeClientVpnEndpoints operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeClientVpnEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeClientVpnEndpointsResult> describeClientVpnEndpointsAsync(
            DescribeClientVpnEndpointsRequest describeClientVpnEndpointsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeClientVpnEndpointsRequest, DescribeClientVpnEndpointsResult> asyncHandler);

    /**
     * <p>
     * Describes the routes for the specified Client VPN endpoint.
     * </p>
     * 
     * @param describeClientVpnRoutesRequest
     * @return A Java Future containing the result of the DescribeClientVpnRoutes operation returned by the service.
     * @sample AmazonEC2Async.DescribeClientVpnRoutes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnRoutes" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeClientVpnRoutesResult> describeClientVpnRoutesAsync(DescribeClientVpnRoutesRequest describeClientVpnRoutesRequest);

    /**
     * <p>
     * Describes the routes for the specified Client VPN endpoint.
     * </p>
     * 
     * @param describeClientVpnRoutesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeClientVpnRoutes operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeClientVpnRoutes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnRoutes" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeClientVpnRoutesResult> describeClientVpnRoutesAsync(DescribeClientVpnRoutesRequest describeClientVpnRoutesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeClientVpnRoutesRequest, DescribeClientVpnRoutesResult> asyncHandler);

    /**
     * <p>
     * Describes the target networks associated with the specified Client VPN endpoint.
     * </p>
     * 
     * @param describeClientVpnTargetNetworksRequest
     * @return A Java Future containing the result of the DescribeClientVpnTargetNetworks operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeClientVpnTargetNetworks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnTargetNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeClientVpnTargetNetworksResult> describeClientVpnTargetNetworksAsync(
            DescribeClientVpnTargetNetworksRequest describeClientVpnTargetNetworksRequest);

    /**
     * <p>
     * Describes the target networks associated with the specified Client VPN endpoint.
     * </p>
     * 
     * @param describeClientVpnTargetNetworksRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeClientVpnTargetNetworks operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeClientVpnTargetNetworks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnTargetNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeClientVpnTargetNetworksResult> describeClientVpnTargetNetworksAsync(
            DescribeClientVpnTargetNetworksRequest describeClientVpnTargetNetworksRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeClientVpnTargetNetworksRequest, DescribeClientVpnTargetNetworksResult> asyncHandler);

    /**
     * <p>
     * Describes the specified customer-owned address pools or all of your customer-owned address pools.
     * </p>
     * 
     * @param describeCoipPoolsRequest
     * @return A Java Future containing the result of the DescribeCoipPools operation returned by the service.
     * @sample AmazonEC2Async.DescribeCoipPools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCoipPools" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeCoipPoolsResult> describeCoipPoolsAsync(DescribeCoipPoolsRequest describeCoipPoolsRequest);

    /**
     * <p>
     * Describes the specified customer-owned address pools or all of your customer-owned address pools.
     * </p>
     * 
     * @param describeCoipPoolsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeCoipPools operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeCoipPools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCoipPools" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeCoipPoolsResult> describeCoipPoolsAsync(DescribeCoipPoolsRequest describeCoipPoolsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeCoipPoolsRequest, DescribeCoipPoolsResult> asyncHandler);

    /**
     * <p>
     * Describes the specified conversion tasks or all your conversion tasks. For more information, see the <a
     * href="https://docs.aws.amazon.com/vm-import/latest/userguide/">VM Import/Export User Guide</a>.
     * </p>
     * <p>
     * For information about the import manifest referenced by this API action, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.
     * </p>
     * 
     * @param describeConversionTasksRequest
     * @return A Java Future containing the result of the DescribeConversionTasks operation returned by the service.
     * @sample AmazonEC2Async.DescribeConversionTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeConversionTasks" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeConversionTasksResult> describeConversionTasksAsync(DescribeConversionTasksRequest describeConversionTasksRequest);

    /**
     * <p>
     * Describes the specified conversion tasks or all your conversion tasks. For more information, see the <a
     * href="https://docs.aws.amazon.com/vm-import/latest/userguide/">VM Import/Export User Guide</a>.
     * </p>
     * <p>
     * For information about the import manifest referenced by this API action, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.
     * </p>
     * 
     * @param describeConversionTasksRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeConversionTasks operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeConversionTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeConversionTasks" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeConversionTasksResult> describeConversionTasksAsync(DescribeConversionTasksRequest describeConversionTasksRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeConversionTasksRequest, DescribeConversionTasksResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeConversionTasks operation.
     *
     * @see #describeConversionTasksAsync(DescribeConversionTasksRequest)
     */
    java.util.concurrent.Future<DescribeConversionTasksResult> describeConversionTasksAsync();

    /**
     * Simplified method form for invoking the DescribeConversionTasks operation with an AsyncHandler.
     *
     * @see #describeConversionTasksAsync(DescribeConversionTasksRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeConversionTasksResult> describeConversionTasksAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeConversionTasksRequest, DescribeConversionTasksResult> asyncHandler);

    /**
     * <p>
     * Describes one or more of your VPN customer gateways.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * 
     * @param describeCustomerGatewaysRequest
     *        Contains the parameters for DescribeCustomerGateways.
     * @return A Java Future containing the result of the DescribeCustomerGateways operation returned by the service.
     * @sample AmazonEC2Async.DescribeCustomerGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCustomerGateways" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeCustomerGatewaysResult> describeCustomerGatewaysAsync(DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest);

    /**
     * <p>
     * Describes one or more of your VPN customer gateways.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * 
     * @param describeCustomerGatewaysRequest
     *        Contains the parameters for DescribeCustomerGateways.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeCustomerGateways operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeCustomerGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCustomerGateways" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeCustomerGatewaysResult> describeCustomerGatewaysAsync(DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeCustomerGatewaysRequest, DescribeCustomerGatewaysResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeCustomerGateways operation.
     *
     * @see #describeCustomerGatewaysAsync(DescribeCustomerGatewaysRequest)
     */
    java.util.concurrent.Future<DescribeCustomerGatewaysResult> describeCustomerGatewaysAsync();

    /**
     * Simplified method form for invoking the DescribeCustomerGateways operation with an AsyncHandler.
     *
     * @see #describeCustomerGatewaysAsync(DescribeCustomerGatewaysRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeCustomerGatewaysResult> describeCustomerGatewaysAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeCustomerGatewaysRequest, DescribeCustomerGatewaysResult> asyncHandler);

    /**
     * <p>
     * Describes one or more of your DHCP options sets.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP
     * options sets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param describeDhcpOptionsRequest
     * @return A Java Future containing the result of the DescribeDhcpOptions operation returned by the service.
     * @sample AmazonEC2Async.DescribeDhcpOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeDhcpOptionsResult> describeDhcpOptionsAsync(DescribeDhcpOptionsRequest describeDhcpOptionsRequest);

    /**
     * <p>
     * Describes one or more of your DHCP options sets.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html">DHCP
     * options sets</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param describeDhcpOptionsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeDhcpOptions operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeDhcpOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDhcpOptions" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeDhcpOptionsResult> describeDhcpOptionsAsync(DescribeDhcpOptionsRequest describeDhcpOptionsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeDhcpOptionsRequest, DescribeDhcpOptionsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeDhcpOptions operation.
     *
     * @see #describeDhcpOptionsAsync(DescribeDhcpOptionsRequest)
     */
    java.util.concurrent.Future<DescribeDhcpOptionsResult> describeDhcpOptionsAsync();

    /**
     * Simplified method form for invoking the DescribeDhcpOptions operation with an AsyncHandler.
     *
     * @see #describeDhcpOptionsAsync(DescribeDhcpOptionsRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeDhcpOptionsResult> describeDhcpOptionsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeDhcpOptionsRequest, DescribeDhcpOptionsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more of your egress-only internet gateways.
     * </p>
     * 
     * @param describeEgressOnlyInternetGatewaysRequest
     * @return A Java Future containing the result of the DescribeEgressOnlyInternetGateways operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeEgressOnlyInternetGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeEgressOnlyInternetGateways"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeEgressOnlyInternetGatewaysResult> describeEgressOnlyInternetGatewaysAsync(
            DescribeEgressOnlyInternetGatewaysRequest describeEgressOnlyInternetGatewaysRequest);

    /**
     * <p>
     * Describes one or more of your egress-only internet gateways.
     * </p>
     * 
     * @param describeEgressOnlyInternetGatewaysRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeEgressOnlyInternetGateways operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeEgressOnlyInternetGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeEgressOnlyInternetGateways"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeEgressOnlyInternetGatewaysResult> describeEgressOnlyInternetGatewaysAsync(
            DescribeEgressOnlyInternetGatewaysRequest describeEgressOnlyInternetGatewaysRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeEgressOnlyInternetGatewaysRequest, DescribeEgressOnlyInternetGatewaysResult> asyncHandler);

    /**
     * <note>
     * <p>
     * Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads that require graphics acceleration,
     * we recommend that you use Amazon EC2 G4ad, G4dn, or G5 instances.
     * </p>
     * </note>
     * <p>
     * Describes the Elastic Graphics accelerator associated with your instances. For more information about Elastic
     * Graphics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon
     * Elastic Graphics</a>.
     * </p>
     * 
     * @param describeElasticGpusRequest
     * @return A Java Future containing the result of the DescribeElasticGpus operation returned by the service.
     * @sample AmazonEC2Async.DescribeElasticGpus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeElasticGpus" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeElasticGpusResult> describeElasticGpusAsync(DescribeElasticGpusRequest describeElasticGpusRequest);

    /**
     * <note>
     * <p>
     * Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads that require graphics acceleration,
     * we recommend that you use Amazon EC2 G4ad, G4dn, or G5 instances.
     * </p>
     * </note>
     * <p>
     * Describes the Elastic Graphics accelerator associated with your instances. For more information about Elastic
     * Graphics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html">Amazon
     * Elastic Graphics</a>.
     * </p>
     * 
     * @param describeElasticGpusRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeElasticGpus operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeElasticGpus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeElasticGpus" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeElasticGpusResult> describeElasticGpusAsync(DescribeElasticGpusRequest describeElasticGpusRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeElasticGpusRequest, DescribeElasticGpusResult> asyncHandler);

    /**
     * <p>
     * Describes the specified export image tasks or all of your export image tasks.
     * </p>
     * 
     * @param describeExportImageTasksRequest
     * @return A Java Future containing the result of the DescribeExportImageTasks operation returned by the service.
     * @sample AmazonEC2Async.DescribeExportImageTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportImageTasks" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeExportImageTasksResult> describeExportImageTasksAsync(DescribeExportImageTasksRequest describeExportImageTasksRequest);

    /**
     * <p>
     * Describes the specified export image tasks or all of your export image tasks.
     * </p>
     * 
     * @param describeExportImageTasksRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeExportImageTasks operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeExportImageTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportImageTasks" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeExportImageTasksResult> describeExportImageTasksAsync(DescribeExportImageTasksRequest describeExportImageTasksRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeExportImageTasksRequest, DescribeExportImageTasksResult> asyncHandler);

    /**
     * <p>
     * Describes the specified export instance tasks or all of your export instance tasks.
     * </p>
     * 
     * @param describeExportTasksRequest
     * @return A Java Future containing the result of the DescribeExportTasks operation returned by the service.
     * @sample AmazonEC2Async.DescribeExportTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportTasks" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeExportTasksResult> describeExportTasksAsync(DescribeExportTasksRequest describeExportTasksRequest);

    /**
     * <p>
     * Describes the specified export instance tasks or all of your export instance tasks.
     * </p>
     * 
     * @param describeExportTasksRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeExportTasks operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeExportTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportTasks" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeExportTasksResult> describeExportTasksAsync(DescribeExportTasksRequest describeExportTasksRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeExportTasksRequest, DescribeExportTasksResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeExportTasks operation.
     *
     * @see #describeExportTasksAsync(DescribeExportTasksRequest)
     */
    java.util.concurrent.Future<DescribeExportTasksResult> describeExportTasksAsync();

    /**
     * Simplified method form for invoking the DescribeExportTasks operation with an AsyncHandler.
     *
     * @see #describeExportTasksAsync(DescribeExportTasksRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeExportTasksResult> describeExportTasksAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeExportTasksRequest, DescribeExportTasksResult> asyncHandler);

    /**
     * <p>
     * Describe details for Windows AMIs that are configured for Windows fast launch.
     * </p>
     * 
     * @param describeFastLaunchImagesRequest
     * @return A Java Future containing the result of the DescribeFastLaunchImages operation returned by the service.
     * @sample AmazonEC2Async.DescribeFastLaunchImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastLaunchImages" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeFastLaunchImagesResult> describeFastLaunchImagesAsync(DescribeFastLaunchImagesRequest describeFastLaunchImagesRequest);

    /**
     * <p>
     * Describe details for Windows AMIs that are configured for Windows fast launch.
     * </p>
     * 
     * @param describeFastLaunchImagesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeFastLaunchImages operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeFastLaunchImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastLaunchImages" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeFastLaunchImagesResult> describeFastLaunchImagesAsync(DescribeFastLaunchImagesRequest describeFastLaunchImagesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeFastLaunchImagesRequest, DescribeFastLaunchImagesResult> asyncHandler);

    /**
     * <p>
     * Describes the state of fast snapshot restores for your snapshots.
     * </p>
     * 
     * @param describeFastSnapshotRestoresRequest
     * @return A Java Future containing the result of the DescribeFastSnapshotRestores operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeFastSnapshotRestores
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastSnapshotRestores"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeFastSnapshotRestoresResult> describeFastSnapshotRestoresAsync(
            DescribeFastSnapshotRestoresRequest describeFastSnapshotRestoresRequest);

    /**
     * <p>
     * Describes the state of fast snapshot restores for your snapshots.
     * </p>
     * 
     * @param describeFastSnapshotRestoresRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeFastSnapshotRestores operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeFastSnapshotRestores
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastSnapshotRestores"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeFastSnapshotRestoresResult> describeFastSnapshotRestoresAsync(
            DescribeFastSnapshotRestoresRequest describeFastSnapshotRestoresRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeFastSnapshotRestoresRequest, DescribeFastSnapshotRestoresResult> asyncHandler);

    /**
     * <p>
     * Describes the events for the specified EC2 Fleet during the specified time.
     * </p>
     * <p>
     * EC2 Fleet events are delayed by up to 30 seconds before they can be described. This ensures that you can query by
     * the last evaluated time and not miss a recorded event. EC2 Fleet events are available for 48 hours.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/fleet-monitor.html">Monitor fleet events using Amazon
     * EventBridge</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describeFleetHistoryRequest
     * @return A Java Future containing the result of the DescribeFleetHistory operation returned by the service.
     * @sample AmazonEC2Async.DescribeFleetHistory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetHistory" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeFleetHistoryResult> describeFleetHistoryAsync(DescribeFleetHistoryRequest describeFleetHistoryRequest);

    /**
     * <p>
     * Describes the events for the specified EC2 Fleet during the specified time.
     * </p>
     * <p>
     * EC2 Fleet events are delayed by up to 30 seconds before they can be described. This ensures that you can query by
     * the last evaluated time and not miss a recorded event. EC2 Fleet events are available for 48 hours.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/fleet-monitor.html">Monitor fleet events using Amazon
     * EventBridge</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describeFleetHistoryRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeFleetHistory operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeFleetHistory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetHistory" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeFleetHistoryResult> describeFleetHistoryAsync(DescribeFleetHistoryRequest describeFleetHistoryRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeFleetHistoryRequest, DescribeFleetHistoryResult> asyncHandler);

    /**
     * <p>
     * Describes the running instances for the specified EC2 Fleet.
     * </p>
     * <note>
     * <p>
     * Currently, <code>DescribeFleetInstances</code> does not support fleets of type <code>instant</code>. Instead, use
     * <code>DescribeFleets</code>, specifying the <code>instant</code> fleet ID in the request.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#monitor-ec2-fleet">Describe your
     * EC2 Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describeFleetInstancesRequest
     * @return A Java Future containing the result of the DescribeFleetInstances operation returned by the service.
     * @sample AmazonEC2Async.DescribeFleetInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetInstances" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeFleetInstancesResult> describeFleetInstancesAsync(DescribeFleetInstancesRequest describeFleetInstancesRequest);

    /**
     * <p>
     * Describes the running instances for the specified EC2 Fleet.
     * </p>
     * <note>
     * <p>
     * Currently, <code>DescribeFleetInstances</code> does not support fleets of type <code>instant</code>. Instead, use
     * <code>DescribeFleets</code>, specifying the <code>instant</code> fleet ID in the request.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#monitor-ec2-fleet">Describe your
     * EC2 Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describeFleetInstancesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeFleetInstances operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeFleetInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetInstances" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeFleetInstancesResult> describeFleetInstancesAsync(DescribeFleetInstancesRequest describeFleetInstancesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeFleetInstancesRequest, DescribeFleetInstancesResult> asyncHandler);

    /**
     * <p>
     * Describes the specified EC2 Fleet or all of your EC2 Fleets.
     * </p>
     * <important>
     * <p>
     * If a fleet is of type <code>instant</code>, you must specify the fleet ID in the request, otherwise the fleet
     * does not appear in the response.
     * </p>
     * </important>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#monitor-ec2-fleet">Describe your
     * EC2 Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describeFleetsRequest
     * @return A Java Future containing the result of the DescribeFleets operation returned by the service.
     * @sample AmazonEC2Async.DescribeFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleets" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeFleetsResult> describeFleetsAsync(DescribeFleetsRequest describeFleetsRequest);

    /**
     * <p>
     * Describes the specified EC2 Fleet or all of your EC2 Fleets.
     * </p>
     * <important>
     * <p>
     * If a fleet is of type <code>instant</code>, you must specify the fleet ID in the request, otherwise the fleet
     * does not appear in the response.
     * </p>
     * </important>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#monitor-ec2-fleet">Describe your
     * EC2 Fleet</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describeFleetsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeFleets operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleets" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeFleetsResult> describeFleetsAsync(DescribeFleetsRequest describeFleetsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeFleetsRequest, DescribeFleetsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more flow logs.
     * </p>
     * <p>
     * To view the published flow log records, you must view the log destination. For example, the CloudWatch Logs log
     * group, the Amazon S3 bucket, or the Kinesis Data Firehose delivery stream.
     * </p>
     * 
     * @param describeFlowLogsRequest
     * @return A Java Future containing the result of the DescribeFlowLogs operation returned by the service.
     * @sample AmazonEC2Async.DescribeFlowLogs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeFlowLogsResult> describeFlowLogsAsync(DescribeFlowLogsRequest describeFlowLogsRequest);

    /**
     * <p>
     * Describes one or more flow logs.
     * </p>
     * <p>
     * To view the published flow log records, you must view the log destination. For example, the CloudWatch Logs log
     * group, the Amazon S3 bucket, or the Kinesis Data Firehose delivery stream.
     * </p>
     * 
     * @param describeFlowLogsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeFlowLogs operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeFlowLogs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFlowLogs" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeFlowLogsResult> describeFlowLogsAsync(DescribeFlowLogsRequest describeFlowLogsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeFlowLogsRequest, DescribeFlowLogsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeFlowLogs operation.
     *
     * @see #describeFlowLogsAsync(DescribeFlowLogsRequest)
     */
    java.util.concurrent.Future<DescribeFlowLogsResult> describeFlowLogsAsync();

    /**
     * Simplified method form for invoking the DescribeFlowLogs operation with an AsyncHandler.
     *
     * @see #describeFlowLogsAsync(DescribeFlowLogsRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeFlowLogsResult> describeFlowLogsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeFlowLogsRequest, DescribeFlowLogsResult> asyncHandler);

    /**
     * <p>
     * Describes the specified attribute of the specified Amazon FPGA Image (AFI).
     * </p>
     * 
     * @param describeFpgaImageAttributeRequest
     * @return A Java Future containing the result of the DescribeFpgaImageAttribute operation returned by the service.
     * @sample AmazonEC2Async.DescribeFpgaImageAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImageAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeFpgaImageAttributeResult> describeFpgaImageAttributeAsync(
            DescribeFpgaImageAttributeRequest describeFpgaImageAttributeRequest);

    /**
     * <p>
     * Describes the specified attribute of the specified Amazon FPGA Image (AFI).
     * </p>
     * 
     * @param describeFpgaImageAttributeRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeFpgaImageAttribute operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeFpgaImageAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImageAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeFpgaImageAttributeResult> describeFpgaImageAttributeAsync(
            DescribeFpgaImageAttributeRequest describeFpgaImageAttributeRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeFpgaImageAttributeRequest, DescribeFpgaImageAttributeResult> asyncHandler);

    /**
     * <p>
     * Describes the Amazon FPGA Images (AFIs) available to you. These include public AFIs, private AFIs that you own,
     * and AFIs owned by other Amazon Web Services accounts for which you have load permissions.
     * </p>
     * 
     * @param describeFpgaImagesRequest
     * @return A Java Future containing the result of the DescribeFpgaImages operation returned by the service.
     * @sample AmazonEC2Async.DescribeFpgaImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImages" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeFpgaImagesResult> describeFpgaImagesAsync(DescribeFpgaImagesRequest describeFpgaImagesRequest);

    /**
     * <p>
     * Describes the Amazon FPGA Images (AFIs) available to you. These include public AFIs, private AFIs that you own,
     * and AFIs owned by other Amazon Web Services accounts for which you have load permissions.
     * </p>
     * 
     * @param describeFpgaImagesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeFpgaImages operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeFpgaImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImages" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeFpgaImagesResult> describeFpgaImagesAsync(DescribeFpgaImagesRequest describeFpgaImagesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeFpgaImagesRequest, DescribeFpgaImagesResult> asyncHandler);

    /**
     * <p>
     * Describes the Dedicated Host reservations that are available to purchase.
     * </p>
     * <p>
     * The results describe all of the Dedicated Host reservation offerings, including offerings that might not match
     * the instance family and Region of your Dedicated Hosts. When purchasing an offering, ensure that the instance
     * family and Region of the offering matches that of the Dedicated Hosts with which it is to be associated. For more
     * information about supported instance types, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html">Dedicated Hosts</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describeHostReservationOfferingsRequest
     * @return A Java Future containing the result of the DescribeHostReservationOfferings operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeHostReservationOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeHostReservationOfferingsResult> describeHostReservationOfferingsAsync(
            DescribeHostReservationOfferingsRequest describeHostReservationOfferingsRequest);

    /**
     * <p>
     * Describes the Dedicated Host reservations that are available to purchase.
     * </p>
     * <p>
     * The results describe all of the Dedicated Host reservation offerings, including offerings that might not match
     * the instance family and Region of your Dedicated Hosts. When purchasing an offering, ensure that the instance
     * family and Region of the offering matches that of the Dedicated Hosts with which it is to be associated. For more
     * information about supported instance types, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html">Dedicated Hosts</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describeHostReservationOfferingsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeHostReservationOfferings operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeHostReservationOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeHostReservationOfferingsResult> describeHostReservationOfferingsAsync(
            DescribeHostReservationOfferingsRequest describeHostReservationOfferingsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeHostReservationOfferingsRequest, DescribeHostReservationOfferingsResult> asyncHandler);

    /**
     * <p>
     * Describes reservations that are associated with Dedicated Hosts in your account.
     * </p>
     * 
     * @param describeHostReservationsRequest
     * @return A Java Future containing the result of the DescribeHostReservations operation returned by the service.
     * @sample AmazonEC2Async.DescribeHostReservations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservations" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeHostReservationsResult> describeHostReservationsAsync(DescribeHostReservationsRequest describeHostReservationsRequest);

    /**
     * <p>
     * Describes reservations that are associated with Dedicated Hosts in your account.
     * </p>
     * 
     * @param describeHostReservationsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeHostReservations operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeHostReservations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservations" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeHostReservationsResult> describeHostReservationsAsync(DescribeHostReservationsRequest describeHostReservationsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeHostReservationsRequest, DescribeHostReservationsResult> asyncHandler);

    /**
     * <p>
     * Describes the specified Dedicated Hosts or all your Dedicated Hosts.
     * </p>
     * <p>
     * The results describe only the Dedicated Hosts in the Region you're currently using. All listed instances consume
     * capacity on your Dedicated Host. Dedicated Hosts that have recently been released are listed with the state
     * <code>released</code>.
     * </p>
     * 
     * @param describeHostsRequest
     * @return A Java Future containing the result of the DescribeHosts operation returned by the service.
     * @sample AmazonEC2Async.DescribeHosts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHosts" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeHostsResult> describeHostsAsync(DescribeHostsRequest describeHostsRequest);

    /**
     * <p>
     * Describes the specified Dedicated Hosts or all your Dedicated Hosts.
     * </p>
     * <p>
     * The results describe only the Dedicated Hosts in the Region you're currently using. All listed instances consume
     * capacity on your Dedicated Host. Dedicated Hosts that have recently been released are listed with the state
     * <code>released</code>.
     * </p>
     * 
     * @param describeHostsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeHosts operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeHosts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHosts" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeHostsResult> describeHostsAsync(DescribeHostsRequest describeHostsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeHostsRequest, DescribeHostsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeHosts operation.
     *
     * @see #describeHostsAsync(DescribeHostsRequest)
     */
    java.util.concurrent.Future<DescribeHostsResult> describeHostsAsync();

    /**
     * Simplified method form for invoking the DescribeHosts operation with an AsyncHandler.
     *
     * @see #describeHostsAsync(DescribeHostsRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeHostsResult> describeHostsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeHostsRequest, DescribeHostsResult> asyncHandler);

    /**
     * <p>
     * Describes your IAM instance profile associations.
     * </p>
     * 
     * @param describeIamInstanceProfileAssociationsRequest
     * @return A Java Future containing the result of the DescribeIamInstanceProfileAssociations operation returned by
     *         the service.
     * @sample AmazonEC2Async.DescribeIamInstanceProfileAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIamInstanceProfileAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeIamInstanceProfileAssociationsResult> describeIamInstanceProfileAssociationsAsync(
            DescribeIamInstanceProfileAssociationsRequest describeIamInstanceProfileAssociationsRequest);

    /**
     * <p>
     * Describes your IAM instance profile associations.
     * </p>
     * 
     * @param describeIamInstanceProfileAssociationsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeIamInstanceProfileAssociations operation returned by
     *         the service.
     * @sample AmazonEC2AsyncHandler.DescribeIamInstanceProfileAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIamInstanceProfileAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeIamInstanceProfileAssociationsResult> describeIamInstanceProfileAssociationsAsync(
            DescribeIamInstanceProfileAssociationsRequest describeIamInstanceProfileAssociationsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeIamInstanceProfileAssociationsRequest, DescribeIamInstanceProfileAssociationsResult> asyncHandler);

    /**
     * <p>
     * Describes the ID format settings for your resources on a per-Region basis, for example, to view which resource
     * types are enabled for longer IDs. This request only returns information about resource types whose ID formats can
     * be modified; it does not return information about other resource types.
     * </p>
     * <p>
     * The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> |
     * <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> |
     * <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     * <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     * <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code>
     * | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> |
     * <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code>
     * | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> |
     * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
     * <code>vpn-connection</code> | <code>vpn-gateway</code>.
     * </p>
     * <p>
     * These settings apply to the IAM user who makes the request; they do not apply to the entire Amazon Web Services
     * account. By default, an IAM user defaults to the same settings as the root user, unless they explicitly override
     * the settings by running the <a>ModifyIdFormat</a> command. Resources created with longer IDs are visible to all
     * IAM users, regardless of these settings and provided that they have permission to use the relevant
     * <code>Describe</code> command for the resource type.
     * </p>
     * 
     * @param describeIdFormatRequest
     * @return A Java Future containing the result of the DescribeIdFormat operation returned by the service.
     * @sample AmazonEC2Async.DescribeIdFormat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdFormat" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeIdFormatResult> describeIdFormatAsync(DescribeIdFormatRequest describeIdFormatRequest);

    /**
     * <p>
     * Describes the ID format settings for your resources on a per-Region basis, for example, to view which resource
     * types are enabled for longer IDs. This request only returns information about resource types whose ID formats can
     * be modified; it does not return information about other resource types.
     * </p>
     * <p>
     * The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> |
     * <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> |
     * <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     * <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     * <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code>
     * | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> |
     * <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code>
     * | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> |
     * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
     * <code>vpn-connection</code> | <code>vpn-gateway</code>.
     * </p>
     * <p>
     * These settings apply to the IAM user who makes the request; they do not apply to the entire Amazon Web Services
     * account. By default, an IAM user defaults to the same settings as the root user, unless they explicitly override
     * the settings by running the <a>ModifyIdFormat</a> command. Resources created with longer IDs are visible to all
     * IAM users, regardless of these settings and provided that they have permission to use the relevant
     * <code>Describe</code> command for the resource type.
     * </p>
     * 
     * @param describeIdFormatRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeIdFormat operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeIdFormat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdFormat" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeIdFormatResult> describeIdFormatAsync(DescribeIdFormatRequest describeIdFormatRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeIdFormatRequest, DescribeIdFormatResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeIdFormat operation.
     *
     * @see #describeIdFormatAsync(DescribeIdFormatRequest)
     */
    java.util.concurrent.Future<DescribeIdFormatResult> describeIdFormatAsync();

    /**
     * Simplified method form for invoking the DescribeIdFormat operation with an AsyncHandler.
     *
     * @see #describeIdFormatAsync(DescribeIdFormatRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeIdFormatResult> describeIdFormatAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeIdFormatRequest, DescribeIdFormatResult> asyncHandler);

    /**
     * <p>
     * Describes the ID format settings for resources for the specified IAM user, IAM role, or root user. For example,
     * you can view the resource types that are enabled for longer IDs. This request only returns information about
     * resource types whose ID formats can be modified; it does not return information about other resource types. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource
     * IDs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> |
     * <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> |
     * <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     * <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     * <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code>
     * | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> |
     * <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code>
     * | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> |
     * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
     * <code>vpn-connection</code> | <code>vpn-gateway</code>.
     * </p>
     * <p>
     * These settings apply to the principal specified in the request. They do not apply to the principal that makes the
     * request.
     * </p>
     * 
     * @param describeIdentityIdFormatRequest
     * @return A Java Future containing the result of the DescribeIdentityIdFormat operation returned by the service.
     * @sample AmazonEC2Async.DescribeIdentityIdFormat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdentityIdFormat" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeIdentityIdFormatResult> describeIdentityIdFormatAsync(DescribeIdentityIdFormatRequest describeIdentityIdFormatRequest);

    /**
     * <p>
     * Describes the ID format settings for resources for the specified IAM user, IAM role, or root user. For example,
     * you can view the resource types that are enabled for longer IDs. This request only returns information about
     * resource types whose ID formats can be modified; it does not return information about other resource types. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html">Resource
     * IDs</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> |
     * <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> |
     * <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     * <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     * <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code>
     * | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> |
     * <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code>
     * | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> |
     * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
     * <code>vpn-connection</code> | <code>vpn-gateway</code>.
     * </p>
     * <p>
     * These settings apply to the principal specified in the request. They do not apply to the principal that makes the
     * request.
     * </p>
     * 
     * @param describeIdentityIdFormatRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeIdentityIdFormat operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeIdentityIdFormat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdentityIdFormat" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeIdentityIdFormatResult> describeIdentityIdFormatAsync(DescribeIdentityIdFormatRequest describeIdentityIdFormatRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeIdentityIdFormatRequest, DescribeIdentityIdFormatResult> asyncHandler);

    /**
     * <p>
     * Describes the specified attribute of the specified AMI. You can specify only one attribute at a time.
     * </p>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeImageAttributeRequest
     *        Contains the parameters for DescribeImageAttribute.
     * @return A Java Future containing the result of the DescribeImageAttribute operation returned by the service.
     * @sample AmazonEC2Async.DescribeImageAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageAttribute" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeImageAttributeResult> describeImageAttributeAsync(DescribeImageAttributeRequest describeImageAttributeRequest);

    /**
     * <p>
     * Describes the specified attribute of the specified AMI. You can specify only one attribute at a time.
     * </p>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeImageAttributeRequest
     *        Contains the parameters for DescribeImageAttribute.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeImageAttribute operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeImageAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageAttribute" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeImageAttributeResult> describeImageAttributeAsync(DescribeImageAttributeRequest describeImageAttributeRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeImageAttributeRequest, DescribeImageAttributeResult> asyncHandler);

    /**
     * <p>
     * Describes the specified images (AMIs, AKIs, and ARIs) available to you or all of the images available to you.
     * </p>
     * <p>
     * The images available to you include public images, private images that you own, and private images owned by other
     * Amazon Web Services accounts for which you have explicit launch permissions.
     * </p>
     * <p>
     * Recently deregistered images appear in the returned results for a short interval and then return empty results.
     * After all instances that reference a deregistered AMI are terminated, specifying the ID of the image will
     * eventually return an error indicating that the AMI ID cannot be found.
     * </p>
     * <important>
     * <p>
     * We strongly recommend using only paginated requests. Unpaginated requests are susceptible to throttling and
     * timeouts.
     * </p>
     * </important> <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeImagesRequest
     * @return A Java Future containing the result of the DescribeImages operation returned by the service.
     * @sample AmazonEC2Async.DescribeImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeImagesResult> describeImagesAsync(DescribeImagesRequest describeImagesRequest);

    /**
     * <p>
     * Describes the specified images (AMIs, AKIs, and ARIs) available to you or all of the images available to you.
     * </p>
     * <p>
     * The images available to you include public images, private images that you own, and private images owned by other
     * Amazon Web Services accounts for which you have explicit launch permissions.
     * </p>
     * <p>
     * Recently deregistered images appear in the returned results for a short interval and then return empty results.
     * After all instances that reference a deregistered AMI are terminated, specifying the ID of the image will
     * eventually return an error indicating that the AMI ID cannot be found.
     * </p>
     * <important>
     * <p>
     * We strongly recommend using only paginated requests. Unpaginated requests are susceptible to throttling and
     * timeouts.
     * </p>
     * </important> <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeImagesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeImages operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeImagesResult> describeImagesAsync(DescribeImagesRequest describeImagesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeImagesRequest, DescribeImagesResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeImages operation.
     *
     * @see #describeImagesAsync(DescribeImagesRequest)
     */
    java.util.concurrent.Future<DescribeImagesResult> describeImagesAsync();

    /**
     * Simplified method form for invoking the DescribeImages operation with an AsyncHandler.
     *
     * @see #describeImagesAsync(DescribeImagesRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeImagesResult> describeImagesAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeImagesRequest, DescribeImagesResult> asyncHandler);

    /**
     * <p>
     * Displays details about an import virtual machine or import snapshot tasks that are already created.
     * </p>
     * 
     * @param describeImportImageTasksRequest
     * @return A Java Future containing the result of the DescribeImportImageTasks operation returned by the service.
     * @sample AmazonEC2Async.DescribeImportImageTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasks" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeImportImageTasksResult> describeImportImageTasksAsync(DescribeImportImageTasksRequest describeImportImageTasksRequest);

    /**
     * <p>
     * Displays details about an import virtual machine or import snapshot tasks that are already created.
     * </p>
     * 
     * @param describeImportImageTasksRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeImportImageTasks operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeImportImageTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasks" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeImportImageTasksResult> describeImportImageTasksAsync(DescribeImportImageTasksRequest describeImportImageTasksRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeImportImageTasksRequest, DescribeImportImageTasksResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeImportImageTasks operation.
     *
     * @see #describeImportImageTasksAsync(DescribeImportImageTasksRequest)
     */
    java.util.concurrent.Future<DescribeImportImageTasksResult> describeImportImageTasksAsync();

    /**
     * Simplified method form for invoking the DescribeImportImageTasks operation with an AsyncHandler.
     *
     * @see #describeImportImageTasksAsync(DescribeImportImageTasksRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeImportImageTasksResult> describeImportImageTasksAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeImportImageTasksRequest, DescribeImportImageTasksResult> asyncHandler);

    /**
     * <p>
     * Describes your import snapshot tasks.
     * </p>
     * 
     * @param describeImportSnapshotTasksRequest
     * @return A Java Future containing the result of the DescribeImportSnapshotTasks operation returned by the service.
     * @sample AmazonEC2Async.DescribeImportSnapshotTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportSnapshotTasks"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeImportSnapshotTasksResult> describeImportSnapshotTasksAsync(
            DescribeImportSnapshotTasksRequest describeImportSnapshotTasksRequest);

    /**
     * <p>
     * Describes your import snapshot tasks.
     * </p>
     * 
     * @param describeImportSnapshotTasksRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeImportSnapshotTasks operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeImportSnapshotTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportSnapshotTasks"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeImportSnapshotTasksResult> describeImportSnapshotTasksAsync(
            DescribeImportSnapshotTasksRequest describeImportSnapshotTasksRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeImportSnapshotTasksRequest, DescribeImportSnapshotTasksResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeImportSnapshotTasks operation.
     *
     * @see #describeImportSnapshotTasksAsync(DescribeImportSnapshotTasksRequest)
     */
    java.util.concurrent.Future<DescribeImportSnapshotTasksResult> describeImportSnapshotTasksAsync();

    /**
     * Simplified method form for invoking the DescribeImportSnapshotTasks operation with an AsyncHandler.
     *
     * @see #describeImportSnapshotTasksAsync(DescribeImportSnapshotTasksRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeImportSnapshotTasksResult> describeImportSnapshotTasksAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeImportSnapshotTasksRequest, DescribeImportSnapshotTasksResult> asyncHandler);

    /**
     * <p>
     * Describes the specified attribute of the specified instance. You can specify only one attribute at a time. Valid
     * attribute values are: <code>instanceType</code> | <code>kernel</code> | <code>ramdisk</code> |
     * <code>userData</code> | <code>disableApiTermination</code> | <code>instanceInitiatedShutdownBehavior</code> |
     * <code>rootDeviceName</code> | <code>blockDeviceMapping</code> | <code>productCodes</code> |
     * <code>sourceDestCheck</code> | <code>groupSet</code> | <code>ebsOptimized</code> | <code>sriovNetSupport</code>
     * </p>
     * 
     * @param describeInstanceAttributeRequest
     * @return A Java Future containing the result of the DescribeInstanceAttribute operation returned by the service.
     * @sample AmazonEC2Async.DescribeInstanceAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstanceAttributeResult> describeInstanceAttributeAsync(
            DescribeInstanceAttributeRequest describeInstanceAttributeRequest);

    /**
     * <p>
     * Describes the specified attribute of the specified instance. You can specify only one attribute at a time. Valid
     * attribute values are: <code>instanceType</code> | <code>kernel</code> | <code>ramdisk</code> |
     * <code>userData</code> | <code>disableApiTermination</code> | <code>instanceInitiatedShutdownBehavior</code> |
     * <code>rootDeviceName</code> | <code>blockDeviceMapping</code> | <code>productCodes</code> |
     * <code>sourceDestCheck</code> | <code>groupSet</code> | <code>ebsOptimized</code> | <code>sriovNetSupport</code>
     * </p>
     * 
     * @param describeInstanceAttributeRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeInstanceAttribute operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeInstanceAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstanceAttributeResult> describeInstanceAttributeAsync(
            DescribeInstanceAttributeRequest describeInstanceAttributeRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeInstanceAttributeRequest, DescribeInstanceAttributeResult> asyncHandler);

    /**
     * <p>
     * Describes the specified EC2 Instance Connect Endpoints or all EC2 Instance Connect Endpoints.
     * </p>
     * 
     * @param describeInstanceConnectEndpointsRequest
     * @return A Java Future containing the result of the DescribeInstanceConnectEndpoints operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeInstanceConnectEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceConnectEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstanceConnectEndpointsResult> describeInstanceConnectEndpointsAsync(
            DescribeInstanceConnectEndpointsRequest describeInstanceConnectEndpointsRequest);

    /**
     * <p>
     * Describes the specified EC2 Instance Connect Endpoints or all EC2 Instance Connect Endpoints.
     * </p>
     * 
     * @param describeInstanceConnectEndpointsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeInstanceConnectEndpoints operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeInstanceConnectEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceConnectEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstanceConnectEndpointsResult> describeInstanceConnectEndpointsAsync(
            DescribeInstanceConnectEndpointsRequest describeInstanceConnectEndpointsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeInstanceConnectEndpointsRequest, DescribeInstanceConnectEndpointsResult> asyncHandler);

    /**
     * <p>
     * Describes the credit option for CPU usage of the specified burstable performance instances. The credit options
     * are <code>standard</code> and <code>unlimited</code>.
     * </p>
     * <p>
     * If you do not specify an instance ID, Amazon EC2 returns burstable performance instances with the
     * <code>unlimited</code> credit option, as well as instances that were previously configured as T2, T3, and T3a
     * with the <code>unlimited</code> credit option. For example, if you resize a T2 instance, while it is configured
     * as <code>unlimited</code>, to an M4 instance, Amazon EC2 returns the M4 instance.
     * </p>
     * <p>
     * If you specify one or more instance IDs, Amazon EC2 returns the credit option (<code>standard</code> or
     * <code>unlimited</code>) of those instances. If you specify an instance ID that is not valid, such as an instance
     * that is not a burstable performance instance, an error is returned.
     * </p>
     * <p>
     * Recently terminated instances might appear in the returned results. This interval is usually less than one hour.
     * </p>
     * <p>
     * If an Availability Zone is experiencing a service disruption and you specify instance IDs in the affected zone,
     * or do not specify any instance IDs at all, the call fails. If you specify only instance IDs in an unaffected
     * zone, the call works normally.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     * performance instances</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describeInstanceCreditSpecificationsRequest
     * @return A Java Future containing the result of the DescribeInstanceCreditSpecifications operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeInstanceCreditSpecifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceCreditSpecifications"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstanceCreditSpecificationsResult> describeInstanceCreditSpecificationsAsync(
            DescribeInstanceCreditSpecificationsRequest describeInstanceCreditSpecificationsRequest);

    /**
     * <p>
     * Describes the credit option for CPU usage of the specified burstable performance instances. The credit options
     * are <code>standard</code> and <code>unlimited</code>.
     * </p>
     * <p>
     * If you do not specify an instance ID, Amazon EC2 returns burstable performance instances with the
     * <code>unlimited</code> credit option, as well as instances that were previously configured as T2, T3, and T3a
     * with the <code>unlimited</code> credit option. For example, if you resize a T2 instance, while it is configured
     * as <code>unlimited</code>, to an M4 instance, Amazon EC2 returns the M4 instance.
     * </p>
     * <p>
     * If you specify one or more instance IDs, Amazon EC2 returns the credit option (<code>standard</code> or
     * <code>unlimited</code>) of those instances. If you specify an instance ID that is not valid, such as an instance
     * that is not a burstable performance instance, an error is returned.
     * </p>
     * <p>
     * Recently terminated instances might appear in the returned results. This interval is usually less than one hour.
     * </p>
     * <p>
     * If an Availability Zone is experiencing a service disruption and you specify instance IDs in the affected zone,
     * or do not specify any instance IDs at all, the call fails. If you specify only instance IDs in an unaffected
     * zone, the call works normally.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     * performance instances</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describeInstanceCreditSpecificationsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeInstanceCreditSpecifications operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeInstanceCreditSpecifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceCreditSpecifications"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstanceCreditSpecificationsResult> describeInstanceCreditSpecificationsAsync(
            DescribeInstanceCreditSpecificationsRequest describeInstanceCreditSpecificationsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeInstanceCreditSpecificationsRequest, DescribeInstanceCreditSpecificationsResult> asyncHandler);

    /**
     * <p>
     * Describes the tag keys that are registered to appear in scheduled event notifications for resources in the
     * current Region.
     * </p>
     * 
     * @param describeInstanceEventNotificationAttributesRequest
     * @return A Java Future containing the result of the DescribeInstanceEventNotificationAttributes operation returned
     *         by the service.
     * @sample AmazonEC2Async.DescribeInstanceEventNotificationAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceEventNotificationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstanceEventNotificationAttributesResult> describeInstanceEventNotificationAttributesAsync(
            DescribeInstanceEventNotificationAttributesRequest describeInstanceEventNotificationAttributesRequest);

    /**
     * <p>
     * Describes the tag keys that are registered to appear in scheduled event notifications for resources in the
     * current Region.
     * </p>
     * 
     * @param describeInstanceEventNotificationAttributesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeInstanceEventNotificationAttributes operation returned
     *         by the service.
     * @sample AmazonEC2AsyncHandler.DescribeInstanceEventNotificationAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceEventNotificationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstanceEventNotificationAttributesResult> describeInstanceEventNotificationAttributesAsync(
            DescribeInstanceEventNotificationAttributesRequest describeInstanceEventNotificationAttributesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeInstanceEventNotificationAttributesRequest, DescribeInstanceEventNotificationAttributesResult> asyncHandler);

    /**
     * <p>
     * Describes the specified event windows or all event windows.
     * </p>
     * <p>
     * If you specify event window IDs, the output includes information for only the specified event windows. If you
     * specify filters, the output includes information for only those event windows that meet the filter criteria. If
     * you do not specify event windows IDs or filters, the output includes information for all event windows, which can
     * affect performance. We recommend that you use pagination to ensure that the operation returns quickly and
     * successfully.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describeInstanceEventWindowsRequest
     *        Describe instance event windows by InstanceEventWindow.
     * @return A Java Future containing the result of the DescribeInstanceEventWindows operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeInstanceEventWindows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceEventWindows"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstanceEventWindowsResult> describeInstanceEventWindowsAsync(
            DescribeInstanceEventWindowsRequest describeInstanceEventWindowsRequest);

    /**
     * <p>
     * Describes the specified event windows or all event windows.
     * </p>
     * <p>
     * If you specify event window IDs, the output includes information for only the specified event windows. If you
     * specify filters, the output includes information for only those event windows that meet the filter criteria. If
     * you do not specify event windows IDs or filters, the output includes information for all event windows, which can
     * affect performance. We recommend that you use pagination to ensure that the operation returns quickly and
     * successfully.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html">Define
     * event windows for scheduled events</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describeInstanceEventWindowsRequest
     *        Describe instance event windows by InstanceEventWindow.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeInstanceEventWindows operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeInstanceEventWindows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceEventWindows"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstanceEventWindowsResult> describeInstanceEventWindowsAsync(
            DescribeInstanceEventWindowsRequest describeInstanceEventWindowsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeInstanceEventWindowsRequest, DescribeInstanceEventWindowsResult> asyncHandler);

    /**
     * <p>
     * Describes the status of the specified instances or all of your instances. By default, only running instances are
     * described, unless you specifically indicate to return the status of all instances.
     * </p>
     * <p>
     * Instance status includes the following components:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Status checks</b> - Amazon EC2 performs status checks on running EC2 instances to identify hardware and
     * software issues. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html">Status
     * checks for your instances</a> and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html">Troubleshoot instances
     * with failed status checks</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Scheduled events</b> - Amazon EC2 can schedule events (such as reboot, stop, or terminate) for your instances
     * related to hardware issues, software updates, or system maintenance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html">Scheduled
     * events for your instances</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Instance state</b> - You can manage your instances from the moment you launch them through their termination.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance lifecycle</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeInstanceStatusRequest
     * @return A Java Future containing the result of the DescribeInstanceStatus operation returned by the service.
     * @sample AmazonEC2Async.DescribeInstanceStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceStatus" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstanceStatusResult> describeInstanceStatusAsync(DescribeInstanceStatusRequest describeInstanceStatusRequest);

    /**
     * <p>
     * Describes the status of the specified instances or all of your instances. By default, only running instances are
     * described, unless you specifically indicate to return the status of all instances.
     * </p>
     * <p>
     * Instance status includes the following components:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Status checks</b> - Amazon EC2 performs status checks on running EC2 instances to identify hardware and
     * software issues. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html">Status
     * checks for your instances</a> and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html">Troubleshoot instances
     * with failed status checks</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Scheduled events</b> - Amazon EC2 can schedule events (such as reboot, stop, or terminate) for your instances
     * related to hardware issues, software updates, or system maintenance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html">Scheduled
     * events for your instances</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Instance state</b> - You can manage your instances from the moment you launch them through their termination.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html">Instance lifecycle</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeInstanceStatusRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeInstanceStatus operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeInstanceStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceStatus" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstanceStatusResult> describeInstanceStatusAsync(DescribeInstanceStatusRequest describeInstanceStatusRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeInstanceStatusRequest, DescribeInstanceStatusResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeInstanceStatus operation.
     *
     * @see #describeInstanceStatusAsync(DescribeInstanceStatusRequest)
     */
    java.util.concurrent.Future<DescribeInstanceStatusResult> describeInstanceStatusAsync();

    /**
     * Simplified method form for invoking the DescribeInstanceStatus operation with an AsyncHandler.
     *
     * @see #describeInstanceStatusAsync(DescribeInstanceStatusRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeInstanceStatusResult> describeInstanceStatusAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeInstanceStatusRequest, DescribeInstanceStatusResult> asyncHandler);

    /**
     * <p>
     * Describes a tree-based hierarchy that represents the physical host placement of your EC2 instances within an
     * Availability Zone or Local Zone. You can use this information to determine the relative proximity of your EC2
     * instances within the Amazon Web Services network to support your tightly coupled workloads.
     * </p>
     * <p class="title">
     * <b>Limitations</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Supported zones
     * </p>
     * <ul>
     * <li>
     * <p>
     * Availability Zone
     * </p>
     * </li>
     * <li>
     * <p>
     * Local Zone
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Supported instance types
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>hpc6a.48xlarge</code> | <code>hpc6id.32xlarge</code> | <code>hpc7a.12xlarge</code> |
     * <code>hpc7a.24xlarge</code> | <code>hpc7a.48xlarge</code> | <code>hpc7a.96xlarge</code> |
     * <code>hpc7g.4xlarge</code> | <code>hpc7g.8xlarge</code> | <code>hpc7g.16xlarge</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>p3dn.24xlarge</code> | <code>p4d.24xlarge</code> | <code>p4de.24xlarge</code> | <code>p5.48xlarge</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>trn1.2xlarge</code> | <code>trn1.32xlarge</code> | <code>trn1n.32xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-topology.html">Amazon EC2 instance
     * topology</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describeInstanceTopologyRequest
     * @return A Java Future containing the result of the DescribeInstanceTopology operation returned by the service.
     * @sample AmazonEC2Async.DescribeInstanceTopology
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTopology" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstanceTopologyResult> describeInstanceTopologyAsync(DescribeInstanceTopologyRequest describeInstanceTopologyRequest);

    /**
     * <p>
     * Describes a tree-based hierarchy that represents the physical host placement of your EC2 instances within an
     * Availability Zone or Local Zone. You can use this information to determine the relative proximity of your EC2
     * instances within the Amazon Web Services network to support your tightly coupled workloads.
     * </p>
     * <p class="title">
     * <b>Limitations</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Supported zones
     * </p>
     * <ul>
     * <li>
     * <p>
     * Availability Zone
     * </p>
     * </li>
     * <li>
     * <p>
     * Local Zone
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Supported instance types
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>hpc6a.48xlarge</code> | <code>hpc6id.32xlarge</code> | <code>hpc7a.12xlarge</code> |
     * <code>hpc7a.24xlarge</code> | <code>hpc7a.48xlarge</code> | <code>hpc7a.96xlarge</code> |
     * <code>hpc7g.4xlarge</code> | <code>hpc7g.8xlarge</code> | <code>hpc7g.16xlarge</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>p3dn.24xlarge</code> | <code>p4d.24xlarge</code> | <code>p4de.24xlarge</code> | <code>p5.48xlarge</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>trn1.2xlarge</code> | <code>trn1.32xlarge</code> | <code>trn1n.32xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-topology.html">Amazon EC2 instance
     * topology</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describeInstanceTopologyRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeInstanceTopology operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeInstanceTopology
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTopology" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstanceTopologyResult> describeInstanceTopologyAsync(DescribeInstanceTopologyRequest describeInstanceTopologyRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeInstanceTopologyRequest, DescribeInstanceTopologyResult> asyncHandler);

    /**
     * <p>
     * Lists the instance types that are offered for the specified location. If no location is specified, the default is
     * to list the instance types that are offered in the current Region.
     * </p>
     * 
     * @param describeInstanceTypeOfferingsRequest
     * @return A Java Future containing the result of the DescribeInstanceTypeOfferings operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeInstanceTypeOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstanceTypeOfferingsResult> describeInstanceTypeOfferingsAsync(
            DescribeInstanceTypeOfferingsRequest describeInstanceTypeOfferingsRequest);

    /**
     * <p>
     * Lists the instance types that are offered for the specified location. If no location is specified, the default is
     * to list the instance types that are offered in the current Region.
     * </p>
     * 
     * @param describeInstanceTypeOfferingsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeInstanceTypeOfferings operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeInstanceTypeOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstanceTypeOfferingsResult> describeInstanceTypeOfferingsAsync(
            DescribeInstanceTypeOfferingsRequest describeInstanceTypeOfferingsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeInstanceTypeOfferingsRequest, DescribeInstanceTypeOfferingsResult> asyncHandler);

    /**
     * <p>
     * Describes the specified instance types. By default, all instance types for the current Region are described.
     * Alternatively, you can filter the results.
     * </p>
     * 
     * @param describeInstanceTypesRequest
     * @return A Java Future containing the result of the DescribeInstanceTypes operation returned by the service.
     * @sample AmazonEC2Async.DescribeInstanceTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypes" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstanceTypesResult> describeInstanceTypesAsync(DescribeInstanceTypesRequest describeInstanceTypesRequest);

    /**
     * <p>
     * Describes the specified instance types. By default, all instance types for the current Region are described.
     * Alternatively, you can filter the results.
     * </p>
     * 
     * @param describeInstanceTypesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeInstanceTypes operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeInstanceTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypes" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstanceTypesResult> describeInstanceTypesAsync(DescribeInstanceTypesRequest describeInstanceTypesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeInstanceTypesRequest, DescribeInstanceTypesResult> asyncHandler);

    /**
     * <p>
     * Describes the specified instances or all instances.
     * </p>
     * <p>
     * If you specify instance IDs, the output includes information for only the specified instances. If you specify
     * filters, the output includes information for only those instances that meet the filter criteria. If you do not
     * specify instance IDs or filters, the output includes information for all instances, which can affect performance.
     * We recommend that you use pagination to ensure that the operation returns quickly and successfully.
     * </p>
     * <p>
     * If you specify an instance ID that is not valid, an error is returned. If you specify an instance that you do not
     * own, it is not included in the output.
     * </p>
     * <p>
     * Recently terminated instances might appear in the returned results. This interval is usually less than one hour.
     * </p>
     * <p>
     * If you describe instances in the rare case where an Availability Zone is experiencing a service disruption and
     * you specify instance IDs that are in the affected zone, or do not specify any instance IDs at all, the call
     * fails. If you describe instances and specify only instance IDs that are in an unaffected zone, the call works
     * normally.
     * </p>
     * <important>
     * <p>
     * We strongly recommend using only paginated requests. Unpaginated requests are susceptible to throttling and
     * timeouts.
     * </p>
     * </important> <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeInstancesRequest
     * @return A Java Future containing the result of the DescribeInstances operation returned by the service.
     * @sample AmazonEC2Async.DescribeInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstances" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstancesResult> describeInstancesAsync(DescribeInstancesRequest describeInstancesRequest);

    /**
     * <p>
     * Describes the specified instances or all instances.
     * </p>
     * <p>
     * If you specify instance IDs, the output includes information for only the specified instances. If you specify
     * filters, the output includes information for only those instances that meet the filter criteria. If you do not
     * specify instance IDs or filters, the output includes information for all instances, which can affect performance.
     * We recommend that you use pagination to ensure that the operation returns quickly and successfully.
     * </p>
     * <p>
     * If you specify an instance ID that is not valid, an error is returned. If you specify an instance that you do not
     * own, it is not included in the output.
     * </p>
     * <p>
     * Recently terminated instances might appear in the returned results. This interval is usually less than one hour.
     * </p>
     * <p>
     * If you describe instances in the rare case where an Availability Zone is experiencing a service disruption and
     * you specify instance IDs that are in the affected zone, or do not specify any instance IDs at all, the call
     * fails. If you describe instances and specify only instance IDs that are in an unaffected zone, the call works
     * normally.
     * </p>
     * <important>
     * <p>
     * We strongly recommend using only paginated requests. Unpaginated requests are susceptible to throttling and
     * timeouts.
     * </p>
     * </important> <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeInstancesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeInstances operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstances" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeInstancesResult> describeInstancesAsync(DescribeInstancesRequest describeInstancesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeInstancesRequest, DescribeInstancesResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeInstances operation.
     *
     * @see #describeInstancesAsync(DescribeInstancesRequest)
     */
    java.util.concurrent.Future<DescribeInstancesResult> describeInstancesAsync();

    /**
     * Simplified method form for invoking the DescribeInstances operation with an AsyncHandler.
     *
     * @see #describeInstancesAsync(DescribeInstancesRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeInstancesResult> describeInstancesAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeInstancesRequest, DescribeInstancesResult> asyncHandler);

    /**
     * <p>
     * Describes one or more of your internet gateways.
     * </p>
     * 
     * @param describeInternetGatewaysRequest
     * @return A Java Future containing the result of the DescribeInternetGateways operation returned by the service.
     * @sample AmazonEC2Async.DescribeInternetGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInternetGateways" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeInternetGatewaysResult> describeInternetGatewaysAsync(DescribeInternetGatewaysRequest describeInternetGatewaysRequest);

    /**
     * <p>
     * Describes one or more of your internet gateways.
     * </p>
     * 
     * @param describeInternetGatewaysRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeInternetGateways operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeInternetGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInternetGateways" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeInternetGatewaysResult> describeInternetGatewaysAsync(DescribeInternetGatewaysRequest describeInternetGatewaysRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeInternetGatewaysRequest, DescribeInternetGatewaysResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeInternetGateways operation.
     *
     * @see #describeInternetGatewaysAsync(DescribeInternetGatewaysRequest)
     */
    java.util.concurrent.Future<DescribeInternetGatewaysResult> describeInternetGatewaysAsync();

    /**
     * Simplified method form for invoking the DescribeInternetGateways operation with an AsyncHandler.
     *
     * @see #describeInternetGatewaysAsync(DescribeInternetGatewaysRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeInternetGatewaysResult> describeInternetGatewaysAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeInternetGatewaysRequest, DescribeInternetGatewaysResult> asyncHandler);

    /**
     * <p>
     * Describes your Autonomous System Numbers (ASNs), their provisioning statuses, and the BYOIP CIDRs with which they
     * are associated. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in
     * the <i>Amazon VPC IPAM guide</i>.
     * </p>
     * 
     * @param describeIpamByoasnRequest
     * @return A Java Future containing the result of the DescribeIpamByoasn operation returned by the service.
     * @sample AmazonEC2Async.DescribeIpamByoasn
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamByoasn" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeIpamByoasnResult> describeIpamByoasnAsync(DescribeIpamByoasnRequest describeIpamByoasnRequest);

    /**
     * <p>
     * Describes your Autonomous System Numbers (ASNs), their provisioning statuses, and the BYOIP CIDRs with which they
     * are associated. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html">Tutorial: Bring your ASN to IPAM</a> in
     * the <i>Amazon VPC IPAM guide</i>.
     * </p>
     * 
     * @param describeIpamByoasnRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeIpamByoasn operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeIpamByoasn
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamByoasn" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeIpamByoasnResult> describeIpamByoasnAsync(DescribeIpamByoasnRequest describeIpamByoasnRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeIpamByoasnRequest, DescribeIpamByoasnResult> asyncHandler);

    /**
     * <p>
     * Get information about your IPAM pools.
     * </p>
     * 
     * @param describeIpamPoolsRequest
     * @return A Java Future containing the result of the DescribeIpamPools operation returned by the service.
     * @sample AmazonEC2Async.DescribeIpamPools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamPools" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeIpamPoolsResult> describeIpamPoolsAsync(DescribeIpamPoolsRequest describeIpamPoolsRequest);

    /**
     * <p>
     * Get information about your IPAM pools.
     * </p>
     * 
     * @param describeIpamPoolsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeIpamPools operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeIpamPools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamPools" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeIpamPoolsResult> describeIpamPoolsAsync(DescribeIpamPoolsRequest describeIpamPoolsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeIpamPoolsRequest, DescribeIpamPoolsResult> asyncHandler);

    /**
     * <p>
     * Describes IPAM resource discoveries. A resource discovery is an IPAM component that enables IPAM to manage and
     * monitor resources that belong to the owning account.
     * </p>
     * 
     * @param describeIpamResourceDiscoveriesRequest
     * @return A Java Future containing the result of the DescribeIpamResourceDiscoveries operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeIpamResourceDiscoveries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamResourceDiscoveries"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeIpamResourceDiscoveriesResult> describeIpamResourceDiscoveriesAsync(
            DescribeIpamResourceDiscoveriesRequest describeIpamResourceDiscoveriesRequest);

    /**
     * <p>
     * Describes IPAM resource discoveries. A resource discovery is an IPAM component that enables IPAM to manage and
     * monitor resources that belong to the owning account.
     * </p>
     * 
     * @param describeIpamResourceDiscoveriesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeIpamResourceDiscoveries operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeIpamResourceDiscoveries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamResourceDiscoveries"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeIpamResourceDiscoveriesResult> describeIpamResourceDiscoveriesAsync(
            DescribeIpamResourceDiscoveriesRequest describeIpamResourceDiscoveriesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeIpamResourceDiscoveriesRequest, DescribeIpamResourceDiscoveriesResult> asyncHandler);

    /**
     * <p>
     * Describes resource discovery association with an Amazon VPC IPAM. An associated resource discovery is a resource
     * discovery that has been associated with an IPAM..
     * </p>
     * 
     * @param describeIpamResourceDiscoveryAssociationsRequest
     * @return A Java Future containing the result of the DescribeIpamResourceDiscoveryAssociations operation returned
     *         by the service.
     * @sample AmazonEC2Async.DescribeIpamResourceDiscoveryAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamResourceDiscoveryAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeIpamResourceDiscoveryAssociationsResult> describeIpamResourceDiscoveryAssociationsAsync(
            DescribeIpamResourceDiscoveryAssociationsRequest describeIpamResourceDiscoveryAssociationsRequest);

    /**
     * <p>
     * Describes resource discovery association with an Amazon VPC IPAM. An associated resource discovery is a resource
     * discovery that has been associated with an IPAM..
     * </p>
     * 
     * @param describeIpamResourceDiscoveryAssociationsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeIpamResourceDiscoveryAssociations operation returned
     *         by the service.
     * @sample AmazonEC2AsyncHandler.DescribeIpamResourceDiscoveryAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamResourceDiscoveryAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeIpamResourceDiscoveryAssociationsResult> describeIpamResourceDiscoveryAssociationsAsync(
            DescribeIpamResourceDiscoveryAssociationsRequest describeIpamResourceDiscoveryAssociationsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeIpamResourceDiscoveryAssociationsRequest, DescribeIpamResourceDiscoveryAssociationsResult> asyncHandler);

    /**
     * <p>
     * Get information about your IPAM scopes.
     * </p>
     * 
     * @param describeIpamScopesRequest
     * @return A Java Future containing the result of the DescribeIpamScopes operation returned by the service.
     * @sample AmazonEC2Async.DescribeIpamScopes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamScopes" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeIpamScopesResult> describeIpamScopesAsync(DescribeIpamScopesRequest describeIpamScopesRequest);

    /**
     * <p>
     * Get information about your IPAM scopes.
     * </p>
     * 
     * @param describeIpamScopesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeIpamScopes operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeIpamScopes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpamScopes" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeIpamScopesResult> describeIpamScopesAsync(DescribeIpamScopesRequest describeIpamScopesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeIpamScopesRequest, DescribeIpamScopesResult> asyncHandler);

    /**
     * <p>
     * Get information about your IPAM pools.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is
     * IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * 
     * @param describeIpamsRequest
     * @return A Java Future containing the result of the DescribeIpams operation returned by the service.
     * @sample AmazonEC2Async.DescribeIpams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpams" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeIpamsResult> describeIpamsAsync(DescribeIpamsRequest describeIpamsRequest);

    /**
     * <p>
     * Get information about your IPAM pools.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html">What is
     * IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.
     * </p>
     * 
     * @param describeIpamsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeIpams operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeIpams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpams" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeIpamsResult> describeIpamsAsync(DescribeIpamsRequest describeIpamsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeIpamsRequest, DescribeIpamsResult> asyncHandler);

    /**
     * <p>
     * Describes your IPv6 address pools.
     * </p>
     * 
     * @param describeIpv6PoolsRequest
     * @return A Java Future containing the result of the DescribeIpv6Pools operation returned by the service.
     * @sample AmazonEC2Async.DescribeIpv6Pools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpv6Pools" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeIpv6PoolsResult> describeIpv6PoolsAsync(DescribeIpv6PoolsRequest describeIpv6PoolsRequest);

    /**
     * <p>
     * Describes your IPv6 address pools.
     * </p>
     * 
     * @param describeIpv6PoolsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeIpv6Pools operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeIpv6Pools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpv6Pools" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeIpv6PoolsResult> describeIpv6PoolsAsync(DescribeIpv6PoolsRequest describeIpv6PoolsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeIpv6PoolsRequest, DescribeIpv6PoolsResult> asyncHandler);

    /**
     * <p>
     * Describes the specified key pairs or all of your key pairs.
     * </p>
     * <p>
     * For more information about key pairs, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param describeKeyPairsRequest
     * @return A Java Future containing the result of the DescribeKeyPairs operation returned by the service.
     * @sample AmazonEC2Async.DescribeKeyPairs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeKeyPairsResult> describeKeyPairsAsync(DescribeKeyPairsRequest describeKeyPairsRequest);

    /**
     * <p>
     * Describes the specified key pairs or all of your key pairs.
     * </p>
     * <p>
     * For more information about key pairs, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param describeKeyPairsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeKeyPairs operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeKeyPairs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeKeyPairsResult> describeKeyPairsAsync(DescribeKeyPairsRequest describeKeyPairsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeKeyPairsRequest, DescribeKeyPairsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeKeyPairs operation.
     *
     * @see #describeKeyPairsAsync(DescribeKeyPairsRequest)
     */
    java.util.concurrent.Future<DescribeKeyPairsResult> describeKeyPairsAsync();

    /**
     * Simplified method form for invoking the DescribeKeyPairs operation with an AsyncHandler.
     *
     * @see #describeKeyPairsAsync(DescribeKeyPairsRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeKeyPairsResult> describeKeyPairsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeKeyPairsRequest, DescribeKeyPairsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more versions of a specified launch template. You can describe all versions, individual
     * versions, or a range of versions. You can also describe all the latest versions or all the default versions of
     * all the launch templates in your account.
     * </p>
     * 
     * @param describeLaunchTemplateVersionsRequest
     * @return A Java Future containing the result of the DescribeLaunchTemplateVersions operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeLaunchTemplateVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeLaunchTemplateVersionsResult> describeLaunchTemplateVersionsAsync(
            DescribeLaunchTemplateVersionsRequest describeLaunchTemplateVersionsRequest);

    /**
     * <p>
     * Describes one or more versions of a specified launch template. You can describe all versions, individual
     * versions, or a range of versions. You can also describe all the latest versions or all the default versions of
     * all the launch templates in your account.
     * </p>
     * 
     * @param describeLaunchTemplateVersionsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeLaunchTemplateVersions operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeLaunchTemplateVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeLaunchTemplateVersionsResult> describeLaunchTemplateVersionsAsync(
            DescribeLaunchTemplateVersionsRequest describeLaunchTemplateVersionsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeLaunchTemplateVersionsRequest, DescribeLaunchTemplateVersionsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more launch templates.
     * </p>
     * 
     * @param describeLaunchTemplatesRequest
     * @return A Java Future containing the result of the DescribeLaunchTemplates operation returned by the service.
     * @sample AmazonEC2Async.DescribeLaunchTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeLaunchTemplatesResult> describeLaunchTemplatesAsync(DescribeLaunchTemplatesRequest describeLaunchTemplatesRequest);

    /**
     * <p>
     * Describes one or more launch templates.
     * </p>
     * 
     * @param describeLaunchTemplatesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeLaunchTemplates operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeLaunchTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeLaunchTemplatesResult> describeLaunchTemplatesAsync(DescribeLaunchTemplatesRequest describeLaunchTemplatesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeLaunchTemplatesRequest, DescribeLaunchTemplatesResult> asyncHandler);

    /**
     * <p>
     * Describes the associations between virtual interface groups and local gateway route tables.
     * </p>
     * 
     * @param describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
     * @return A Java Future containing the result of the
     *         DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations operation returned by the service.
     * @sample AmazonEC2Async.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult> describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsAsync(
            DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest);

    /**
     * <p>
     * Describes the associations between virtual interface groups and local gateway route tables.
     * </p>
     * 
     * @param describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the
     *         DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult> describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsAsync(
            DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest, DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult> asyncHandler);

    /**
     * <p>
     * Describes the specified associations between VPCs and local gateway route tables.
     * </p>
     * 
     * @param describeLocalGatewayRouteTableVpcAssociationsRequest
     * @return A Java Future containing the result of the DescribeLocalGatewayRouteTableVpcAssociations operation
     *         returned by the service.
     * @sample AmazonEC2Async.DescribeLocalGatewayRouteTableVpcAssociations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTableVpcAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeLocalGatewayRouteTableVpcAssociationsResult> describeLocalGatewayRouteTableVpcAssociationsAsync(
            DescribeLocalGatewayRouteTableVpcAssociationsRequest describeLocalGatewayRouteTableVpcAssociationsRequest);

    /**
     * <p>
     * Describes the specified associations between VPCs and local gateway route tables.
     * </p>
     * 
     * @param describeLocalGatewayRouteTableVpcAssociationsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeLocalGatewayRouteTableVpcAssociations operation
     *         returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeLocalGatewayRouteTableVpcAssociations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTableVpcAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeLocalGatewayRouteTableVpcAssociationsResult> describeLocalGatewayRouteTableVpcAssociationsAsync(
            DescribeLocalGatewayRouteTableVpcAssociationsRequest describeLocalGatewayRouteTableVpcAssociationsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeLocalGatewayRouteTableVpcAssociationsRequest, DescribeLocalGatewayRouteTableVpcAssociationsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more local gateway route tables. By default, all local gateway route tables are described.
     * Alternatively, you can filter the results.
     * </p>
     * 
     * @param describeLocalGatewayRouteTablesRequest
     * @return A Java Future containing the result of the DescribeLocalGatewayRouteTables operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeLocalGatewayRouteTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTables"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeLocalGatewayRouteTablesResult> describeLocalGatewayRouteTablesAsync(
            DescribeLocalGatewayRouteTablesRequest describeLocalGatewayRouteTablesRequest);

    /**
     * <p>
     * Describes one or more local gateway route tables. By default, all local gateway route tables are described.
     * Alternatively, you can filter the results.
     * </p>
     * 
     * @param describeLocalGatewayRouteTablesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeLocalGatewayRouteTables operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeLocalGatewayRouteTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTables"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeLocalGatewayRouteTablesResult> describeLocalGatewayRouteTablesAsync(
            DescribeLocalGatewayRouteTablesRequest describeLocalGatewayRouteTablesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeLocalGatewayRouteTablesRequest, DescribeLocalGatewayRouteTablesResult> asyncHandler);

    /**
     * <p>
     * Describes the specified local gateway virtual interface groups.
     * </p>
     * 
     * @param describeLocalGatewayVirtualInterfaceGroupsRequest
     * @return A Java Future containing the result of the DescribeLocalGatewayVirtualInterfaceGroups operation returned
     *         by the service.
     * @sample AmazonEC2Async.DescribeLocalGatewayVirtualInterfaceGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayVirtualInterfaceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeLocalGatewayVirtualInterfaceGroupsResult> describeLocalGatewayVirtualInterfaceGroupsAsync(
            DescribeLocalGatewayVirtualInterfaceGroupsRequest describeLocalGatewayVirtualInterfaceGroupsRequest);

    /**
     * <p>
     * Describes the specified local gateway virtual interface groups.
     * </p>
     * 
     * @param describeLocalGatewayVirtualInterfaceGroupsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeLocalGatewayVirtualInterfaceGroups operation returned
     *         by the service.
     * @sample AmazonEC2AsyncHandler.DescribeLocalGatewayVirtualInterfaceGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayVirtualInterfaceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeLocalGatewayVirtualInterfaceGroupsResult> describeLocalGatewayVirtualInterfaceGroupsAsync(
            DescribeLocalGatewayVirtualInterfaceGroupsRequest describeLocalGatewayVirtualInterfaceGroupsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeLocalGatewayVirtualInterfaceGroupsRequest, DescribeLocalGatewayVirtualInterfaceGroupsResult> asyncHandler);

    /**
     * <p>
     * Describes the specified local gateway virtual interfaces.
     * </p>
     * 
     * @param describeLocalGatewayVirtualInterfacesRequest
     * @return A Java Future containing the result of the DescribeLocalGatewayVirtualInterfaces operation returned by
     *         the service.
     * @sample AmazonEC2Async.DescribeLocalGatewayVirtualInterfaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayVirtualInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeLocalGatewayVirtualInterfacesResult> describeLocalGatewayVirtualInterfacesAsync(
            DescribeLocalGatewayVirtualInterfacesRequest describeLocalGatewayVirtualInterfacesRequest);

    /**
     * <p>
     * Describes the specified local gateway virtual interfaces.
     * </p>
     * 
     * @param describeLocalGatewayVirtualInterfacesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeLocalGatewayVirtualInterfaces operation returned by
     *         the service.
     * @sample AmazonEC2AsyncHandler.DescribeLocalGatewayVirtualInterfaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayVirtualInterfaces"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeLocalGatewayVirtualInterfacesResult> describeLocalGatewayVirtualInterfacesAsync(
            DescribeLocalGatewayVirtualInterfacesRequest describeLocalGatewayVirtualInterfacesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeLocalGatewayVirtualInterfacesRequest, DescribeLocalGatewayVirtualInterfacesResult> asyncHandler);

    /**
     * <p>
     * Describes one or more local gateways. By default, all local gateways are described. Alternatively, you can filter
     * the results.
     * </p>
     * 
     * @param describeLocalGatewaysRequest
     * @return A Java Future containing the result of the DescribeLocalGateways operation returned by the service.
     * @sample AmazonEC2Async.DescribeLocalGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGateways" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeLocalGatewaysResult> describeLocalGatewaysAsync(DescribeLocalGatewaysRequest describeLocalGatewaysRequest);

    /**
     * <p>
     * Describes one or more local gateways. By default, all local gateways are described. Alternatively, you can filter
     * the results.
     * </p>
     * 
     * @param describeLocalGatewaysRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeLocalGateways operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeLocalGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGateways" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeLocalGatewaysResult> describeLocalGatewaysAsync(DescribeLocalGatewaysRequest describeLocalGatewaysRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeLocalGatewaysRequest, DescribeLocalGatewaysResult> asyncHandler);

    /**
     * <p>
     * Describes the lock status for a snapshot.
     * </p>
     * 
     * @param describeLockedSnapshotsRequest
     * @return A Java Future containing the result of the DescribeLockedSnapshots operation returned by the service.
     * @sample AmazonEC2Async.DescribeLockedSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLockedSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeLockedSnapshotsResult> describeLockedSnapshotsAsync(DescribeLockedSnapshotsRequest describeLockedSnapshotsRequest);

    /**
     * <p>
     * Describes the lock status for a snapshot.
     * </p>
     * 
     * @param describeLockedSnapshotsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeLockedSnapshots operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeLockedSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLockedSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeLockedSnapshotsResult> describeLockedSnapshotsAsync(DescribeLockedSnapshotsRequest describeLockedSnapshotsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeLockedSnapshotsRequest, DescribeLockedSnapshotsResult> asyncHandler);

    /**
     * <p>
     * Describes the specified EC2 Mac Dedicated Host or all of your EC2 Mac Dedicated Hosts.
     * </p>
     * 
     * @param describeMacHostsRequest
     * @return A Java Future containing the result of the DescribeMacHosts operation returned by the service.
     * @sample AmazonEC2Async.DescribeMacHosts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeMacHosts" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeMacHostsResult> describeMacHostsAsync(DescribeMacHostsRequest describeMacHostsRequest);

    /**
     * <p>
     * Describes the specified EC2 Mac Dedicated Host or all of your EC2 Mac Dedicated Hosts.
     * </p>
     * 
     * @param describeMacHostsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeMacHosts operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeMacHosts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeMacHosts" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeMacHostsResult> describeMacHostsAsync(DescribeMacHostsRequest describeMacHostsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeMacHostsRequest, DescribeMacHostsResult> asyncHandler);

    /**
     * <p>
     * Describes your managed prefix lists and any Amazon Web Services-managed prefix lists.
     * </p>
     * <p>
     * To view the entries for your prefix list, use <a>GetManagedPrefixListEntries</a>.
     * </p>
     * 
     * @param describeManagedPrefixListsRequest
     * @return A Java Future containing the result of the DescribeManagedPrefixLists operation returned by the service.
     * @sample AmazonEC2Async.DescribeManagedPrefixLists
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeManagedPrefixLists" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeManagedPrefixListsResult> describeManagedPrefixListsAsync(
            DescribeManagedPrefixListsRequest describeManagedPrefixListsRequest);

    /**
     * <p>
     * Describes your managed prefix lists and any Amazon Web Services-managed prefix lists.
     * </p>
     * <p>
     * To view the entries for your prefix list, use <a>GetManagedPrefixListEntries</a>.
     * </p>
     * 
     * @param describeManagedPrefixListsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeManagedPrefixLists operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeManagedPrefixLists
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeManagedPrefixLists" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeManagedPrefixListsResult> describeManagedPrefixListsAsync(
            DescribeManagedPrefixListsRequest describeManagedPrefixListsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeManagedPrefixListsRequest, DescribeManagedPrefixListsResult> asyncHandler);

    /**
     * <note>
     * <p>
     * This action is deprecated.
     * </p>
     * </note>
     * <p>
     * Describes your Elastic IP addresses that are being moved from or being restored to the EC2-Classic platform. This
     * request does not return information about any other Elastic IP addresses in your account.
     * </p>
     * 
     * @param describeMovingAddressesRequest
     * @return A Java Future containing the result of the DescribeMovingAddresses operation returned by the service.
     * @sample AmazonEC2Async.DescribeMovingAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeMovingAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeMovingAddressesResult> describeMovingAddressesAsync(DescribeMovingAddressesRequest describeMovingAddressesRequest);

    /**
     * <note>
     * <p>
     * This action is deprecated.
     * </p>
     * </note>
     * <p>
     * Describes your Elastic IP addresses that are being moved from or being restored to the EC2-Classic platform. This
     * request does not return information about any other Elastic IP addresses in your account.
     * </p>
     * 
     * @param describeMovingAddressesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeMovingAddresses operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeMovingAddresses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeMovingAddresses" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeMovingAddressesResult> describeMovingAddressesAsync(DescribeMovingAddressesRequest describeMovingAddressesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeMovingAddressesRequest, DescribeMovingAddressesResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeMovingAddresses operation.
     *
     * @see #describeMovingAddressesAsync(DescribeMovingAddressesRequest)
     */
    java.util.concurrent.Future<DescribeMovingAddressesResult> describeMovingAddressesAsync();

    /**
     * Simplified method form for invoking the DescribeMovingAddresses operation with an AsyncHandler.
     *
     * @see #describeMovingAddressesAsync(DescribeMovingAddressesRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeMovingAddressesResult> describeMovingAddressesAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeMovingAddressesRequest, DescribeMovingAddressesResult> asyncHandler);

    /**
     * <p>
     * Describes one or more of your NAT gateways.
     * </p>
     * 
     * @param describeNatGatewaysRequest
     * @return A Java Future containing the result of the DescribeNatGateways operation returned by the service.
     * @sample AmazonEC2Async.DescribeNatGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNatGateways" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeNatGatewaysResult> describeNatGatewaysAsync(DescribeNatGatewaysRequest describeNatGatewaysRequest);

    /**
     * <p>
     * Describes one or more of your NAT gateways.
     * </p>
     * 
     * @param describeNatGatewaysRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeNatGateways operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeNatGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNatGateways" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeNatGatewaysResult> describeNatGatewaysAsync(DescribeNatGatewaysRequest describeNatGatewaysRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeNatGatewaysRequest, DescribeNatGatewaysResult> asyncHandler);

    /**
     * <p>
     * Describes one or more of your network ACLs.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Network ACLs</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     * 
     * @param describeNetworkAclsRequest
     * @return A Java Future containing the result of the DescribeNetworkAcls operation returned by the service.
     * @sample AmazonEC2Async.DescribeNetworkAcls
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkAcls" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeNetworkAclsResult> describeNetworkAclsAsync(DescribeNetworkAclsRequest describeNetworkAclsRequest);

    /**
     * <p>
     * Describes one or more of your network ACLs.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html">Network ACLs</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     * 
     * @param describeNetworkAclsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeNetworkAcls operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeNetworkAcls
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkAcls" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeNetworkAclsResult> describeNetworkAclsAsync(DescribeNetworkAclsRequest describeNetworkAclsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeNetworkAclsRequest, DescribeNetworkAclsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeNetworkAcls operation.
     *
     * @see #describeNetworkAclsAsync(DescribeNetworkAclsRequest)
     */
    java.util.concurrent.Future<DescribeNetworkAclsResult> describeNetworkAclsAsync();

    /**
     * Simplified method form for invoking the DescribeNetworkAcls operation with an AsyncHandler.
     *
     * @see #describeNetworkAclsAsync(DescribeNetworkAclsRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeNetworkAclsResult> describeNetworkAclsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeNetworkAclsRequest, DescribeNetworkAclsResult> asyncHandler);

    /**
     * <p>
     * Describes the specified Network Access Scope analyses.
     * </p>
     * 
     * @param describeNetworkInsightsAccessScopeAnalysesRequest
     * @return A Java Future containing the result of the DescribeNetworkInsightsAccessScopeAnalyses operation returned
     *         by the service.
     * @sample AmazonEC2Async.DescribeNetworkInsightsAccessScopeAnalyses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInsightsAccessScopeAnalyses"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeNetworkInsightsAccessScopeAnalysesResult> describeNetworkInsightsAccessScopeAnalysesAsync(
            DescribeNetworkInsightsAccessScopeAnalysesRequest describeNetworkInsightsAccessScopeAnalysesRequest);

    /**
     * <p>
     * Describes the specified Network Access Scope analyses.
     * </p>
     * 
     * @param describeNetworkInsightsAccessScopeAnalysesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeNetworkInsightsAccessScopeAnalyses operation returned
     *         by the service.
     * @sample AmazonEC2AsyncHandler.DescribeNetworkInsightsAccessScopeAnalyses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInsightsAccessScopeAnalyses"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeNetworkInsightsAccessScopeAnalysesResult> describeNetworkInsightsAccessScopeAnalysesAsync(
            DescribeNetworkInsightsAccessScopeAnalysesRequest describeNetworkInsightsAccessScopeAnalysesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeNetworkInsightsAccessScopeAnalysesRequest, DescribeNetworkInsightsAccessScopeAnalysesResult> asyncHandler);

    /**
     * <p>
     * Describes the specified Network Access Scopes.
     * </p>
     * 
     * @param describeNetworkInsightsAccessScopesRequest
     * @return A Java Future containing the result of the DescribeNetworkInsightsAccessScopes operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeNetworkInsightsAccessScopes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInsightsAccessScopes"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeNetworkInsightsAccessScopesResult> describeNetworkInsightsAccessScopesAsync(
            DescribeNetworkInsightsAccessScopesRequest describeNetworkInsightsAccessScopesRequest);

    /**
     * <p>
     * Describes the specified Network Access Scopes.
     * </p>
     * 
     * @param describeNetworkInsightsAccessScopesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeNetworkInsightsAccessScopes operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeNetworkInsightsAccessScopes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInsightsAccessScopes"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeNetworkInsightsAccessScopesResult> describeNetworkInsightsAccessScopesAsync(
            DescribeNetworkInsightsAccessScopesRequest describeNetworkInsightsAccessScopesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeNetworkInsightsAccessScopesRequest, DescribeNetworkInsightsAccessScopesResult> asyncHandler);

    /**
     * <p>
     * Describes one or more of your network insights analyses.
     * </p>
     * 
     * @param describeNetworkInsightsAnalysesRequest
     * @return A Java Future containing the result of the DescribeNetworkInsightsAnalyses operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeNetworkInsightsAnalyses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInsightsAnalyses"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeNetworkInsightsAnalysesResult> describeNetworkInsightsAnalysesAsync(
            DescribeNetworkInsightsAnalysesRequest describeNetworkInsightsAnalysesRequest);

    /**
     * <p>
     * Describes one or more of your network insights analyses.
     * </p>
     * 
     * @param describeNetworkInsightsAnalysesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeNetworkInsightsAnalyses operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeNetworkInsightsAnalyses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInsightsAnalyses"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeNetworkInsightsAnalysesResult> describeNetworkInsightsAnalysesAsync(
            DescribeNetworkInsightsAnalysesRequest describeNetworkInsightsAnalysesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeNetworkInsightsAnalysesRequest, DescribeNetworkInsightsAnalysesResult> asyncHandler);

    /**
     * <p>
     * Describes one or more of your paths.
     * </p>
     * 
     * @param describeNetworkInsightsPathsRequest
     * @return A Java Future containing the result of the DescribeNetworkInsightsPaths operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeNetworkInsightsPaths
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInsightsPaths"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeNetworkInsightsPathsResult> describeNetworkInsightsPathsAsync(
            DescribeNetworkInsightsPathsRequest describeNetworkInsightsPathsRequest);

    /**
     * <p>
     * Describes one or more of your paths.
     * </p>
     * 
     * @param describeNetworkInsightsPathsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeNetworkInsightsPaths operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeNetworkInsightsPaths
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInsightsPaths"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeNetworkInsightsPathsResult> describeNetworkInsightsPathsAsync(
            DescribeNetworkInsightsPathsRequest describeNetworkInsightsPathsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeNetworkInsightsPathsRequest, DescribeNetworkInsightsPathsResult> asyncHandler);

    /**
     * <p>
     * Describes a network interface attribute. You can specify only one attribute at a time.
     * </p>
     * 
     * @param describeNetworkInterfaceAttributeRequest
     *        Contains the parameters for DescribeNetworkInterfaceAttribute.
     * @return A Java Future containing the result of the DescribeNetworkInterfaceAttribute operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeNetworkInterfaceAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaceAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeNetworkInterfaceAttributeResult> describeNetworkInterfaceAttributeAsync(
            DescribeNetworkInterfaceAttributeRequest describeNetworkInterfaceAttributeRequest);

    /**
     * <p>
     * Describes a network interface attribute. You can specify only one attribute at a time.
     * </p>
     * 
     * @param describeNetworkInterfaceAttributeRequest
     *        Contains the parameters for DescribeNetworkInterfaceAttribute.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeNetworkInterfaceAttribute operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeNetworkInterfaceAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaceAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeNetworkInterfaceAttributeResult> describeNetworkInterfaceAttributeAsync(
            DescribeNetworkInterfaceAttributeRequest describeNetworkInterfaceAttributeRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeNetworkInterfaceAttributeRequest, DescribeNetworkInterfaceAttributeResult> asyncHandler);

    /**
     * <p>
     * Describes the permissions for your network interfaces.
     * </p>
     * 
     * @param describeNetworkInterfacePermissionsRequest
     *        Contains the parameters for DescribeNetworkInterfacePermissions.
     * @return A Java Future containing the result of the DescribeNetworkInterfacePermissions operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeNetworkInterfacePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfacePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeNetworkInterfacePermissionsResult> describeNetworkInterfacePermissionsAsync(
            DescribeNetworkInterfacePermissionsRequest describeNetworkInterfacePermissionsRequest);

    /**
     * <p>
     * Describes the permissions for your network interfaces.
     * </p>
     * 
     * @param describeNetworkInterfacePermissionsRequest
     *        Contains the parameters for DescribeNetworkInterfacePermissions.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeNetworkInterfacePermissions operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeNetworkInterfacePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfacePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeNetworkInterfacePermissionsResult> describeNetworkInterfacePermissionsAsync(
            DescribeNetworkInterfacePermissionsRequest describeNetworkInterfacePermissionsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeNetworkInterfacePermissionsRequest, DescribeNetworkInterfacePermissionsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more of your network interfaces.
     * </p>
     * <p>
     * If you have a large number of network interfaces, the operation fails unless you use pagination or one of the
     * following filters: <code>group-id</code>, <code>mac-address</code>, <code>private-dns-name</code>,
     * <code>private-ip-address</code>, <code>private-dns-name</code>, <code>subnet-id</code>, or <code>vpc-id</code>.
     * </p>
     * <important>
     * <p>
     * We strongly recommend using only paginated requests. Unpaginated requests are susceptible to throttling and
     * timeouts.
     * </p>
     * </important>
     * 
     * @param describeNetworkInterfacesRequest
     *        Contains the parameters for DescribeNetworkInterfaces.
     * @return A Java Future containing the result of the DescribeNetworkInterfaces operation returned by the service.
     * @sample AmazonEC2Async.DescribeNetworkInterfaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaces" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeNetworkInterfacesResult> describeNetworkInterfacesAsync(
            DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest);

    /**
     * <p>
     * Describes one or more of your network interfaces.
     * </p>
     * <p>
     * If you have a large number of network interfaces, the operation fails unless you use pagination or one of the
     * following filters: <code>group-id</code>, <code>mac-address</code>, <code>private-dns-name</code>,
     * <code>private-ip-address</code>, <code>private-dns-name</code>, <code>subnet-id</code>, or <code>vpc-id</code>.
     * </p>
     * <important>
     * <p>
     * We strongly recommend using only paginated requests. Unpaginated requests are susceptible to throttling and
     * timeouts.
     * </p>
     * </important>
     * 
     * @param describeNetworkInterfacesRequest
     *        Contains the parameters for DescribeNetworkInterfaces.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeNetworkInterfaces operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeNetworkInterfaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaces" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeNetworkInterfacesResult> describeNetworkInterfacesAsync(
            DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeNetworkInterfacesRequest, DescribeNetworkInterfacesResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeNetworkInterfaces operation.
     *
     * @see #describeNetworkInterfacesAsync(DescribeNetworkInterfacesRequest)
     */
    java.util.concurrent.Future<DescribeNetworkInterfacesResult> describeNetworkInterfacesAsync();

    /**
     * Simplified method form for invoking the DescribeNetworkInterfaces operation with an AsyncHandler.
     *
     * @see #describeNetworkInterfacesAsync(DescribeNetworkInterfacesRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeNetworkInterfacesResult> describeNetworkInterfacesAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeNetworkInterfacesRequest, DescribeNetworkInterfacesResult> asyncHandler);

    /**
     * <p>
     * Describes the specified placement groups or all of your placement groups. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describePlacementGroupsRequest
     * @return A Java Future containing the result of the DescribePlacementGroups operation returned by the service.
     * @sample AmazonEC2Async.DescribePlacementGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePlacementGroups" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribePlacementGroupsResult> describePlacementGroupsAsync(DescribePlacementGroupsRequest describePlacementGroupsRequest);

    /**
     * <p>
     * Describes the specified placement groups or all of your placement groups. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describePlacementGroupsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribePlacementGroups operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribePlacementGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePlacementGroups" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribePlacementGroupsResult> describePlacementGroupsAsync(DescribePlacementGroupsRequest describePlacementGroupsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribePlacementGroupsRequest, DescribePlacementGroupsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribePlacementGroups operation.
     *
     * @see #describePlacementGroupsAsync(DescribePlacementGroupsRequest)
     */
    java.util.concurrent.Future<DescribePlacementGroupsResult> describePlacementGroupsAsync();

    /**
     * Simplified method form for invoking the DescribePlacementGroups operation with an AsyncHandler.
     *
     * @see #describePlacementGroupsAsync(DescribePlacementGroupsRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribePlacementGroupsResult> describePlacementGroupsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribePlacementGroupsRequest, DescribePlacementGroupsResult> asyncHandler);

    /**
     * <p>
     * Describes available Amazon Web Services services in a prefix list format, which includes the prefix list name and
     * prefix list ID of the service and the IP address range for the service.
     * </p>
     * <p>
     * We recommend that you use <a>DescribeManagedPrefixLists</a> instead.
     * </p>
     * 
     * @param describePrefixListsRequest
     * @return A Java Future containing the result of the DescribePrefixLists operation returned by the service.
     * @sample AmazonEC2Async.DescribePrefixLists
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrefixLists" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribePrefixListsResult> describePrefixListsAsync(DescribePrefixListsRequest describePrefixListsRequest);

    /**
     * <p>
     * Describes available Amazon Web Services services in a prefix list format, which includes the prefix list name and
     * prefix list ID of the service and the IP address range for the service.
     * </p>
     * <p>
     * We recommend that you use <a>DescribeManagedPrefixLists</a> instead.
     * </p>
     * 
     * @param describePrefixListsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribePrefixLists operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribePrefixLists
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrefixLists" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribePrefixListsResult> describePrefixListsAsync(DescribePrefixListsRequest describePrefixListsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribePrefixListsRequest, DescribePrefixListsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribePrefixLists operation.
     *
     * @see #describePrefixListsAsync(DescribePrefixListsRequest)
     */
    java.util.concurrent.Future<DescribePrefixListsResult> describePrefixListsAsync();

    /**
     * Simplified method form for invoking the DescribePrefixLists operation with an AsyncHandler.
     *
     * @see #describePrefixListsAsync(DescribePrefixListsRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribePrefixListsResult> describePrefixListsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribePrefixListsRequest, DescribePrefixListsResult> asyncHandler);

    /**
     * <p>
     * Describes the ID format settings for the root user and all IAM roles and IAM users that have explicitly specified
     * a longer ID (17-character ID) preference.
     * </p>
     * <p>
     * By default, all IAM roles and IAM users default to the same ID settings as the root user, unless they explicitly
     * override the settings. This request is useful for identifying those IAM users and IAM roles that have overridden
     * the default ID settings.
     * </p>
     * <p>
     * The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> |
     * <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> |
     * <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     * <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     * <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code>
     * | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> |
     * <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code>
     * | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> |
     * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
     * <code>vpn-connection</code> | <code>vpn-gateway</code>.
     * </p>
     * 
     * @param describePrincipalIdFormatRequest
     * @return A Java Future containing the result of the DescribePrincipalIdFormat operation returned by the service.
     * @sample AmazonEC2Async.DescribePrincipalIdFormat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrincipalIdFormat" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribePrincipalIdFormatResult> describePrincipalIdFormatAsync(
            DescribePrincipalIdFormatRequest describePrincipalIdFormatRequest);

    /**
     * <p>
     * Describes the ID format settings for the root user and all IAM roles and IAM users that have explicitly specified
     * a longer ID (17-character ID) preference.
     * </p>
     * <p>
     * By default, all IAM roles and IAM users default to the same ID settings as the root user, unless they explicitly
     * override the settings. This request is useful for identifying those IAM users and IAM roles that have overridden
     * the default ID settings.
     * </p>
     * <p>
     * The following resource types support longer IDs: <code>bundle</code> | <code>conversion-task</code> |
     * <code>customer-gateway</code> | <code>dhcp-options</code> | <code>elastic-ip-allocation</code> |
     * <code>elastic-ip-association</code> | <code>export-task</code> | <code>flow-log</code> | <code>image</code> |
     * <code>import-task</code> | <code>instance</code> | <code>internet-gateway</code> | <code>network-acl</code> |
     * <code>network-acl-association</code> | <code>network-interface</code> | <code>network-interface-attachment</code>
     * | <code>prefix-list</code> | <code>reservation</code> | <code>route-table</code> |
     * <code>route-table-association</code> | <code>security-group</code> | <code>snapshot</code> | <code>subnet</code>
     * | <code>subnet-cidr-block-association</code> | <code>volume</code> | <code>vpc</code> |
     * <code>vpc-cidr-block-association</code> | <code>vpc-endpoint</code> | <code>vpc-peering-connection</code> |
     * <code>vpn-connection</code> | <code>vpn-gateway</code>.
     * </p>
     * 
     * @param describePrincipalIdFormatRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribePrincipalIdFormat operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribePrincipalIdFormat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrincipalIdFormat" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribePrincipalIdFormatResult> describePrincipalIdFormatAsync(
            DescribePrincipalIdFormatRequest describePrincipalIdFormatRequest,
            com.amazonaws.handlers.AsyncHandler<DescribePrincipalIdFormatRequest, DescribePrincipalIdFormatResult> asyncHandler);

    /**
     * <p>
     * Describes the specified IPv4 address pools.
     * </p>
     * 
     * @param describePublicIpv4PoolsRequest
     * @return A Java Future containing the result of the DescribePublicIpv4Pools operation returned by the service.
     * @sample AmazonEC2Async.DescribePublicIpv4Pools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePublicIpv4Pools" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribePublicIpv4PoolsResult> describePublicIpv4PoolsAsync(DescribePublicIpv4PoolsRequest describePublicIpv4PoolsRequest);

    /**
     * <p>
     * Describes the specified IPv4 address pools.
     * </p>
     * 
     * @param describePublicIpv4PoolsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribePublicIpv4Pools operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribePublicIpv4Pools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePublicIpv4Pools" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribePublicIpv4PoolsResult> describePublicIpv4PoolsAsync(DescribePublicIpv4PoolsRequest describePublicIpv4PoolsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribePublicIpv4PoolsRequest, DescribePublicIpv4PoolsResult> asyncHandler);

    /**
     * <p>
     * Describes the Regions that are enabled for your account, or all Regions.
     * </p>
     * <p>
     * For a list of the Regions supported by Amazon EC2, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/ec2-service.html"> Amazon Elastic Compute Cloud endpoints and
     * quotas</a>.
     * </p>
     * <p>
     * For information about enabling and disabling Regions for your account, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html">Managing Amazon Web Services Regions</a>
     * in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeRegionsRequest
     * @return A Java Future containing the result of the DescribeRegions operation returned by the service.
     * @sample AmazonEC2Async.DescribeRegions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRegions" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeRegionsResult> describeRegionsAsync(DescribeRegionsRequest describeRegionsRequest);

    /**
     * <p>
     * Describes the Regions that are enabled for your account, or all Regions.
     * </p>
     * <p>
     * For a list of the Regions supported by Amazon EC2, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/ec2-service.html"> Amazon Elastic Compute Cloud endpoints and
     * quotas</a>.
     * </p>
     * <p>
     * For information about enabling and disabling Regions for your account, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html">Managing Amazon Web Services Regions</a>
     * in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeRegionsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeRegions operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeRegions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRegions" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeRegionsResult> describeRegionsAsync(DescribeRegionsRequest describeRegionsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeRegionsRequest, DescribeRegionsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeRegions operation.
     *
     * @see #describeRegionsAsync(DescribeRegionsRequest)
     */
    java.util.concurrent.Future<DescribeRegionsResult> describeRegionsAsync();

    /**
     * Simplified method form for invoking the DescribeRegions operation with an AsyncHandler.
     *
     * @see #describeRegionsAsync(DescribeRegionsRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeRegionsResult> describeRegionsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeRegionsRequest, DescribeRegionsResult> asyncHandler);

    /**
     * <p>
     * Describes a root volume replacement task. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/replace-root.html">Replace a root volume</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param describeReplaceRootVolumeTasksRequest
     * @return A Java Future containing the result of the DescribeReplaceRootVolumeTasks operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeReplaceRootVolumeTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReplaceRootVolumeTasks"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeReplaceRootVolumeTasksResult> describeReplaceRootVolumeTasksAsync(
            DescribeReplaceRootVolumeTasksRequest describeReplaceRootVolumeTasksRequest);

    /**
     * <p>
     * Describes a root volume replacement task. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/replace-root.html">Replace a root volume</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @param describeReplaceRootVolumeTasksRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeReplaceRootVolumeTasks operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeReplaceRootVolumeTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReplaceRootVolumeTasks"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeReplaceRootVolumeTasksResult> describeReplaceRootVolumeTasksAsync(
            DescribeReplaceRootVolumeTasksRequest describeReplaceRootVolumeTasksRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeReplaceRootVolumeTasksRequest, DescribeReplaceRootVolumeTasksResult> asyncHandler);

    /**
     * <p>
     * Describes one or more of the Reserved Instances that you purchased.
     * </p>
     * <p>
     * For more information about Reserved Instances, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html">Reserved
     * Instances</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeReservedInstancesRequest
     *        Contains the parameters for DescribeReservedInstances.
     * @return A Java Future containing the result of the DescribeReservedInstances operation returned by the service.
     * @sample AmazonEC2Async.DescribeReservedInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstances" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeReservedInstancesResult> describeReservedInstancesAsync(
            DescribeReservedInstancesRequest describeReservedInstancesRequest);

    /**
     * <p>
     * Describes one or more of the Reserved Instances that you purchased.
     * </p>
     * <p>
     * For more information about Reserved Instances, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html">Reserved
     * Instances</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeReservedInstancesRequest
     *        Contains the parameters for DescribeReservedInstances.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeReservedInstances operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeReservedInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstances" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeReservedInstancesResult> describeReservedInstancesAsync(
            DescribeReservedInstancesRequest describeReservedInstancesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeReservedInstancesRequest, DescribeReservedInstancesResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeReservedInstances operation.
     *
     * @see #describeReservedInstancesAsync(DescribeReservedInstancesRequest)
     */
    java.util.concurrent.Future<DescribeReservedInstancesResult> describeReservedInstancesAsync();

    /**
     * Simplified method form for invoking the DescribeReservedInstances operation with an AsyncHandler.
     *
     * @see #describeReservedInstancesAsync(DescribeReservedInstancesRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeReservedInstancesResult> describeReservedInstancesAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeReservedInstancesRequest, DescribeReservedInstancesResult> asyncHandler);

    /**
     * <p>
     * Describes your account's Reserved Instance listings in the Reserved Instance Marketplace.
     * </p>
     * <p>
     * The Reserved Instance Marketplace matches sellers who want to resell Reserved Instance capacity that they no
     * longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the
     * Reserved Instance Marketplace work like any other Reserved Instances.
     * </p>
     * <p>
     * As a seller, you choose to list some or all of your Reserved Instances, and you specify the upfront price to
     * receive for them. Your Reserved Instances are then listed in the Reserved Instance Marketplace and are available
     * for purchase.
     * </p>
     * <p>
     * As a buyer, you specify the configuration of the Reserved Instance to purchase, and the Marketplace matches what
     * you're searching for with what's available. The Marketplace first sells the lowest priced Reserved Instances to
     * you, and continues to sell available Reserved Instance listings to you until your demand is met. You are charged
     * based on the total price of all of the listings that you purchase.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeReservedInstancesListingsRequest
     *        Contains the parameters for DescribeReservedInstancesListings.
     * @return A Java Future containing the result of the DescribeReservedInstancesListings operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeReservedInstancesListings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesListings"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeReservedInstancesListingsResult> describeReservedInstancesListingsAsync(
            DescribeReservedInstancesListingsRequest describeReservedInstancesListingsRequest);

    /**
     * <p>
     * Describes your account's Reserved Instance listings in the Reserved Instance Marketplace.
     * </p>
     * <p>
     * The Reserved Instance Marketplace matches sellers who want to resell Reserved Instance capacity that they no
     * longer need with buyers who want to purchase additional capacity. Reserved Instances bought and sold through the
     * Reserved Instance Marketplace work like any other Reserved Instances.
     * </p>
     * <p>
     * As a seller, you choose to list some or all of your Reserved Instances, and you specify the upfront price to
     * receive for them. Your Reserved Instances are then listed in the Reserved Instance Marketplace and are available
     * for purchase.
     * </p>
     * <p>
     * As a buyer, you specify the configuration of the Reserved Instance to purchase, and the Marketplace matches what
     * you're searching for with what's available. The Marketplace first sells the lowest priced Reserved Instances to
     * you, and continues to sell available Reserved Instance listings to you until your demand is met. You are charged
     * based on the total price of all of the listings that you purchase.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeReservedInstancesListingsRequest
     *        Contains the parameters for DescribeReservedInstancesListings.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeReservedInstancesListings operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeReservedInstancesListings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesListings"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeReservedInstancesListingsResult> describeReservedInstancesListingsAsync(
            DescribeReservedInstancesListingsRequest describeReservedInstancesListingsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeReservedInstancesListingsRequest, DescribeReservedInstancesListingsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeReservedInstancesListings operation.
     *
     * @see #describeReservedInstancesListingsAsync(DescribeReservedInstancesListingsRequest)
     */
    java.util.concurrent.Future<DescribeReservedInstancesListingsResult> describeReservedInstancesListingsAsync();

    /**
     * Simplified method form for invoking the DescribeReservedInstancesListings operation with an AsyncHandler.
     *
     * @see #describeReservedInstancesListingsAsync(DescribeReservedInstancesListingsRequest,
     *      com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeReservedInstancesListingsResult> describeReservedInstancesListingsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeReservedInstancesListingsRequest, DescribeReservedInstancesListingsResult> asyncHandler);

    /**
     * <p>
     * Describes the modifications made to your Reserved Instances. If no parameter is specified, information about all
     * your Reserved Instances modification requests is returned. If a modification ID is specified, only information
     * about the specific modification is returned.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modifying Reserved Instances</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeReservedInstancesModificationsRequest
     *        Contains the parameters for DescribeReservedInstancesModifications.
     * @return A Java Future containing the result of the DescribeReservedInstancesModifications operation returned by
     *         the service.
     * @sample AmazonEC2Async.DescribeReservedInstancesModifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesModifications"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeReservedInstancesModificationsResult> describeReservedInstancesModificationsAsync(
            DescribeReservedInstancesModificationsRequest describeReservedInstancesModificationsRequest);

    /**
     * <p>
     * Describes the modifications made to your Reserved Instances. If no parameter is specified, information about all
     * your Reserved Instances modification requests is returned. If a modification ID is specified, only information
     * about the specific modification is returned.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modifying Reserved Instances</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeReservedInstancesModificationsRequest
     *        Contains the parameters for DescribeReservedInstancesModifications.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeReservedInstancesModifications operation returned by
     *         the service.
     * @sample AmazonEC2AsyncHandler.DescribeReservedInstancesModifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesModifications"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeReservedInstancesModificationsResult> describeReservedInstancesModificationsAsync(
            DescribeReservedInstancesModificationsRequest describeReservedInstancesModificationsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeReservedInstancesModificationsRequest, DescribeReservedInstancesModificationsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeReservedInstancesModifications operation.
     *
     * @see #describeReservedInstancesModificationsAsync(DescribeReservedInstancesModificationsRequest)
     */
    java.util.concurrent.Future<DescribeReservedInstancesModificationsResult> describeReservedInstancesModificationsAsync();

    /**
     * Simplified method form for invoking the DescribeReservedInstancesModifications operation with an AsyncHandler.
     *
     * @see #describeReservedInstancesModificationsAsync(DescribeReservedInstancesModificationsRequest,
     *      com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeReservedInstancesModificationsResult> describeReservedInstancesModificationsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeReservedInstancesModificationsRequest, DescribeReservedInstancesModificationsResult> asyncHandler);

    /**
     * <p>
     * Describes Reserved Instance offerings that are available for purchase. With Reserved Instances, you purchase the
     * right to launch instances for a period of time. During that time period, you do not receive insufficient capacity
     * errors, and you pay a lower usage rate than the rate charged for On-Demand instances for the actual time used.
     * </p>
     * <p>
     * If you have listed your own Reserved Instances for sale in the Reserved Instance Marketplace, they will be
     * excluded from these results. This is to ensure that you do not purchase your own Reserved Instances.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeReservedInstancesOfferingsRequest
     *        Contains the parameters for DescribeReservedInstancesOfferings.
     * @return A Java Future containing the result of the DescribeReservedInstancesOfferings operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeReservedInstancesOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeReservedInstancesOfferingsResult> describeReservedInstancesOfferingsAsync(
            DescribeReservedInstancesOfferingsRequest describeReservedInstancesOfferingsRequest);

    /**
     * <p>
     * Describes Reserved Instance offerings that are available for purchase. With Reserved Instances, you purchase the
     * right to launch instances for a period of time. During that time period, you do not receive insufficient capacity
     * errors, and you pay a lower usage rate than the rate charged for On-Demand instances for the actual time used.
     * </p>
     * <p>
     * If you have listed your own Reserved Instances for sale in the Reserved Instance Marketplace, they will be
     * excluded from these results. This is to ensure that you do not purchase your own Reserved Instances.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html">Reserved Instance
     * Marketplace</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeReservedInstancesOfferingsRequest
     *        Contains the parameters for DescribeReservedInstancesOfferings.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeReservedInstancesOfferings operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeReservedInstancesOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeReservedInstancesOfferingsResult> describeReservedInstancesOfferingsAsync(
            DescribeReservedInstancesOfferingsRequest describeReservedInstancesOfferingsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeReservedInstancesOfferingsRequest, DescribeReservedInstancesOfferingsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeReservedInstancesOfferings operation.
     *
     * @see #describeReservedInstancesOfferingsAsync(DescribeReservedInstancesOfferingsRequest)
     */
    java.util.concurrent.Future<DescribeReservedInstancesOfferingsResult> describeReservedInstancesOfferingsAsync();

    /**
     * Simplified method form for invoking the DescribeReservedInstancesOfferings operation with an AsyncHandler.
     *
     * @see #describeReservedInstancesOfferingsAsync(DescribeReservedInstancesOfferingsRequest,
     *      com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeReservedInstancesOfferingsResult> describeReservedInstancesOfferingsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeReservedInstancesOfferingsRequest, DescribeReservedInstancesOfferingsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more of your route tables.
     * </p>
     * <p>
     * Each subnet in your VPC must be associated with a route table. If a subnet is not explicitly associated with any
     * route table, it is implicitly associated with the main route table. This command does not return the subnet ID
     * for implicit associations.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param describeRouteTablesRequest
     * @return A Java Future containing the result of the DescribeRouteTables operation returned by the service.
     * @sample AmazonEC2Async.DescribeRouteTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRouteTables" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeRouteTablesResult> describeRouteTablesAsync(DescribeRouteTablesRequest describeRouteTablesRequest);

    /**
     * <p>
     * Describes one or more of your route tables.
     * </p>
     * <p>
     * Each subnet in your VPC must be associated with a route table. If a subnet is not explicitly associated with any
     * route table, it is implicitly associated with the main route table. This command does not return the subnet ID
     * for implicit associations.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html">Route
     * tables</a> in the <i>Amazon VPC User Guide</i>.
     * </p>
     * 
     * @param describeRouteTablesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeRouteTables operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeRouteTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRouteTables" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeRouteTablesResult> describeRouteTablesAsync(DescribeRouteTablesRequest describeRouteTablesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeRouteTablesRequest, DescribeRouteTablesResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeRouteTables operation.
     *
     * @see #describeRouteTablesAsync(DescribeRouteTablesRequest)
     */
    java.util.concurrent.Future<DescribeRouteTablesResult> describeRouteTablesAsync();

    /**
     * Simplified method form for invoking the DescribeRouteTables operation with an AsyncHandler.
     *
     * @see #describeRouteTablesAsync(DescribeRouteTablesRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeRouteTablesResult> describeRouteTablesAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeRouteTablesRequest, DescribeRouteTablesResult> asyncHandler);

    /**
     * <p>
     * Finds available schedules that meet the specified criteria.
     * </p>
     * <p>
     * You can search for an available schedule no more than 3 months in advance. You must meet the minimum required
     * duration of 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule
     * is 24 hours, and the minimum monthly schedule is 100 hours.
     * </p>
     * <p>
     * After you find a schedule that meets your needs, call <a>PurchaseScheduledInstances</a> to purchase Scheduled
     * Instances with that schedule.
     * </p>
     * 
     * @param describeScheduledInstanceAvailabilityRequest
     *        Contains the parameters for DescribeScheduledInstanceAvailability.
     * @return A Java Future containing the result of the DescribeScheduledInstanceAvailability operation returned by
     *         the service.
     * @sample AmazonEC2Async.DescribeScheduledInstanceAvailability
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstanceAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeScheduledInstanceAvailabilityResult> describeScheduledInstanceAvailabilityAsync(
            DescribeScheduledInstanceAvailabilityRequest describeScheduledInstanceAvailabilityRequest);

    /**
     * <p>
     * Finds available schedules that meet the specified criteria.
     * </p>
     * <p>
     * You can search for an available schedule no more than 3 months in advance. You must meet the minimum required
     * duration of 1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum weekly schedule
     * is 24 hours, and the minimum monthly schedule is 100 hours.
     * </p>
     * <p>
     * After you find a schedule that meets your needs, call <a>PurchaseScheduledInstances</a> to purchase Scheduled
     * Instances with that schedule.
     * </p>
     * 
     * @param describeScheduledInstanceAvailabilityRequest
     *        Contains the parameters for DescribeScheduledInstanceAvailability.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeScheduledInstanceAvailability operation returned by
     *         the service.
     * @sample AmazonEC2AsyncHandler.DescribeScheduledInstanceAvailability
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstanceAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeScheduledInstanceAvailabilityResult> describeScheduledInstanceAvailabilityAsync(
            DescribeScheduledInstanceAvailabilityRequest describeScheduledInstanceAvailabilityRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeScheduledInstanceAvailabilityRequest, DescribeScheduledInstanceAvailabilityResult> asyncHandler);

    /**
     * <p>
     * Describes the specified Scheduled Instances or all your Scheduled Instances.
     * </p>
     * 
     * @param describeScheduledInstancesRequest
     *        Contains the parameters for DescribeScheduledInstances.
     * @return A Java Future containing the result of the DescribeScheduledInstances operation returned by the service.
     * @sample AmazonEC2Async.DescribeScheduledInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstances" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeScheduledInstancesResult> describeScheduledInstancesAsync(
            DescribeScheduledInstancesRequest describeScheduledInstancesRequest);

    /**
     * <p>
     * Describes the specified Scheduled Instances or all your Scheduled Instances.
     * </p>
     * 
     * @param describeScheduledInstancesRequest
     *        Contains the parameters for DescribeScheduledInstances.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeScheduledInstances operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeScheduledInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstances" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeScheduledInstancesResult> describeScheduledInstancesAsync(
            DescribeScheduledInstancesRequest describeScheduledInstancesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeScheduledInstancesRequest, DescribeScheduledInstancesResult> asyncHandler);

    /**
     * <p>
     * Describes the VPCs on the other side of a VPC peering connection that are referencing the security groups you've
     * specified in this request.
     * </p>
     * 
     * @param describeSecurityGroupReferencesRequest
     * @return A Java Future containing the result of the DescribeSecurityGroupReferences operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeSecurityGroupReferences
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroupReferences"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSecurityGroupReferencesResult> describeSecurityGroupReferencesAsync(
            DescribeSecurityGroupReferencesRequest describeSecurityGroupReferencesRequest);

    /**
     * <p>
     * Describes the VPCs on the other side of a VPC peering connection that are referencing the security groups you've
     * specified in this request.
     * </p>
     * 
     * @param describeSecurityGroupReferencesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeSecurityGroupReferences operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeSecurityGroupReferences
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroupReferences"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSecurityGroupReferencesResult> describeSecurityGroupReferencesAsync(
            DescribeSecurityGroupReferencesRequest describeSecurityGroupReferencesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeSecurityGroupReferencesRequest, DescribeSecurityGroupReferencesResult> asyncHandler);

    /**
     * <p>
     * Describes one or more of your security group rules.
     * </p>
     * 
     * @param describeSecurityGroupRulesRequest
     * @return A Java Future containing the result of the DescribeSecurityGroupRules operation returned by the service.
     * @sample AmazonEC2Async.DescribeSecurityGroupRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroupRules" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSecurityGroupRulesResult> describeSecurityGroupRulesAsync(
            DescribeSecurityGroupRulesRequest describeSecurityGroupRulesRequest);

    /**
     * <p>
     * Describes one or more of your security group rules.
     * </p>
     * 
     * @param describeSecurityGroupRulesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeSecurityGroupRules operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeSecurityGroupRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroupRules" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSecurityGroupRulesResult> describeSecurityGroupRulesAsync(
            DescribeSecurityGroupRulesRequest describeSecurityGroupRulesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeSecurityGroupRulesRequest, DescribeSecurityGroupRulesResult> asyncHandler);

    /**
     * <p>
     * Describes the specified security groups or all of your security groups.
     * </p>
     * 
     * @param describeSecurityGroupsRequest
     * @return A Java Future containing the result of the DescribeSecurityGroups operation returned by the service.
     * @sample AmazonEC2Async.DescribeSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroups" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeSecurityGroupsResult> describeSecurityGroupsAsync(DescribeSecurityGroupsRequest describeSecurityGroupsRequest);

    /**
     * <p>
     * Describes the specified security groups or all of your security groups.
     * </p>
     * 
     * @param describeSecurityGroupsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeSecurityGroups operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroups" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeSecurityGroupsResult> describeSecurityGroupsAsync(DescribeSecurityGroupsRequest describeSecurityGroupsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeSecurityGroupsRequest, DescribeSecurityGroupsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeSecurityGroups operation.
     *
     * @see #describeSecurityGroupsAsync(DescribeSecurityGroupsRequest)
     */
    java.util.concurrent.Future<DescribeSecurityGroupsResult> describeSecurityGroupsAsync();

    /**
     * Simplified method form for invoking the DescribeSecurityGroups operation with an AsyncHandler.
     *
     * @see #describeSecurityGroupsAsync(DescribeSecurityGroupsRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeSecurityGroupsResult> describeSecurityGroupsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeSecurityGroupsRequest, DescribeSecurityGroupsResult> asyncHandler);

    /**
     * <p>
     * Describes the specified attribute of the specified snapshot. You can specify only one attribute at a time.
     * </p>
     * <p>
     * For more information about EBS snapshots, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-snapshots.html">Amazon EBS snapshots</a> in the
     * <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param describeSnapshotAttributeRequest
     * @return A Java Future containing the result of the DescribeSnapshotAttribute operation returned by the service.
     * @sample AmazonEC2Async.DescribeSnapshotAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshotAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSnapshotAttributeResult> describeSnapshotAttributeAsync(
            DescribeSnapshotAttributeRequest describeSnapshotAttributeRequest);

    /**
     * <p>
     * Describes the specified attribute of the specified snapshot. You can specify only one attribute at a time.
     * </p>
     * <p>
     * For more information about EBS snapshots, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-snapshots.html">Amazon EBS snapshots</a> in the
     * <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param describeSnapshotAttributeRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeSnapshotAttribute operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeSnapshotAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshotAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSnapshotAttributeResult> describeSnapshotAttributeAsync(
            DescribeSnapshotAttributeRequest describeSnapshotAttributeRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeSnapshotAttributeRequest, DescribeSnapshotAttributeResult> asyncHandler);

    /**
     * <p>
     * Describes the storage tier status of one or more Amazon EBS snapshots.
     * </p>
     * 
     * @param describeSnapshotTierStatusRequest
     * @return A Java Future containing the result of the DescribeSnapshotTierStatus operation returned by the service.
     * @sample AmazonEC2Async.DescribeSnapshotTierStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshotTierStatus" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSnapshotTierStatusResult> describeSnapshotTierStatusAsync(
            DescribeSnapshotTierStatusRequest describeSnapshotTierStatusRequest);

    /**
     * <p>
     * Describes the storage tier status of one or more Amazon EBS snapshots.
     * </p>
     * 
     * @param describeSnapshotTierStatusRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeSnapshotTierStatus operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeSnapshotTierStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshotTierStatus" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSnapshotTierStatusResult> describeSnapshotTierStatusAsync(
            DescribeSnapshotTierStatusRequest describeSnapshotTierStatusRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeSnapshotTierStatusRequest, DescribeSnapshotTierStatusResult> asyncHandler);

    /**
     * <p>
     * Describes the specified EBS snapshots available to you or all of the EBS snapshots available to you.
     * </p>
     * <p>
     * The snapshots available to you include public snapshots, private snapshots that you own, and private snapshots
     * owned by other Amazon Web Services accounts for which you have explicit create volume permissions.
     * </p>
     * <p>
     * The create volume permissions fall into the following categories:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>public</i>: The owner of the snapshot granted create volume permissions for the snapshot to the
     * <code>all</code> group. All Amazon Web Services accounts have create volume permissions for these snapshots.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>explicit</i>: The owner of the snapshot granted create volume permissions to a specific Amazon Web Services
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>implicit</i>: An Amazon Web Services account has implicit create volume permissions for all snapshots it owns.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The list of snapshots returned can be filtered by specifying snapshot IDs, snapshot owners, or Amazon Web
     * Services accounts with create volume permissions. If no options are specified, Amazon EC2 returns all snapshots
     * for which you have create volume permissions.
     * </p>
     * <p>
     * If you specify one or more snapshot IDs, only snapshots that have the specified IDs are returned. If you specify
     * an invalid snapshot ID, an error is returned. If you specify a snapshot ID for which you do not have access, it
     * is not included in the returned results.
     * </p>
     * <p>
     * If you specify one or more snapshot owners using the <code>OwnerIds</code> option, only snapshots from the
     * specified owners and for which you have access are returned. The results can include the Amazon Web Services
     * account IDs of the specified owners, <code>amazon</code> for snapshots owned by Amazon, or <code>self</code> for
     * snapshots that you own.
     * </p>
     * <p>
     * If you specify a list of restorable users, only snapshots with create snapshot permissions for those users are
     * returned. You can specify Amazon Web Services account IDs (if you own the snapshots), <code>self</code> for
     * snapshots for which you own or have explicit permissions, or <code>all</code> for public snapshots.
     * </p>
     * <p>
     * If you are describing a long list of snapshots, we recommend that you paginate the output to make the list more
     * manageable. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.
     * </p>
     * <p>
     * To get the state of fast snapshot restores for a snapshot, use <a>DescribeFastSnapshotRestores</a>.
     * </p>
     * <p>
     * For more information about EBS snapshots, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-snapshots.html">Amazon EBS snapshots</a> in the
     * <i>Amazon EBS User Guide</i>.
     * </p>
     * <important>
     * <p>
     * We strongly recommend using only paginated requests. Unpaginated requests are susceptible to throttling and
     * timeouts.
     * </p>
     * </important>
     * 
     * @param describeSnapshotsRequest
     * @return A Java Future containing the result of the DescribeSnapshots operation returned by the service.
     * @sample AmazonEC2Async.DescribeSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeSnapshotsResult> describeSnapshotsAsync(DescribeSnapshotsRequest describeSnapshotsRequest);

    /**
     * <p>
     * Describes the specified EBS snapshots available to you or all of the EBS snapshots available to you.
     * </p>
     * <p>
     * The snapshots available to you include public snapshots, private snapshots that you own, and private snapshots
     * owned by other Amazon Web Services accounts for which you have explicit create volume permissions.
     * </p>
     * <p>
     * The create volume permissions fall into the following categories:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>public</i>: The owner of the snapshot granted create volume permissions for the snapshot to the
     * <code>all</code> group. All Amazon Web Services accounts have create volume permissions for these snapshots.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>explicit</i>: The owner of the snapshot granted create volume permissions to a specific Amazon Web Services
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>implicit</i>: An Amazon Web Services account has implicit create volume permissions for all snapshots it owns.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The list of snapshots returned can be filtered by specifying snapshot IDs, snapshot owners, or Amazon Web
     * Services accounts with create volume permissions. If no options are specified, Amazon EC2 returns all snapshots
     * for which you have create volume permissions.
     * </p>
     * <p>
     * If you specify one or more snapshot IDs, only snapshots that have the specified IDs are returned. If you specify
     * an invalid snapshot ID, an error is returned. If you specify a snapshot ID for which you do not have access, it
     * is not included in the returned results.
     * </p>
     * <p>
     * If you specify one or more snapshot owners using the <code>OwnerIds</code> option, only snapshots from the
     * specified owners and for which you have access are returned. The results can include the Amazon Web Services
     * account IDs of the specified owners, <code>amazon</code> for snapshots owned by Amazon, or <code>self</code> for
     * snapshots that you own.
     * </p>
     * <p>
     * If you specify a list of restorable users, only snapshots with create snapshot permissions for those users are
     * returned. You can specify Amazon Web Services account IDs (if you own the snapshots), <code>self</code> for
     * snapshots for which you own or have explicit permissions, or <code>all</code> for public snapshots.
     * </p>
     * <p>
     * If you are describing a long list of snapshots, we recommend that you paginate the output to make the list more
     * manageable. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.
     * </p>
     * <p>
     * To get the state of fast snapshot restores for a snapshot, use <a>DescribeFastSnapshotRestores</a>.
     * </p>
     * <p>
     * For more information about EBS snapshots, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-snapshots.html">Amazon EBS snapshots</a> in the
     * <i>Amazon EBS User Guide</i>.
     * </p>
     * <important>
     * <p>
     * We strongly recommend using only paginated requests. Unpaginated requests are susceptible to throttling and
     * timeouts.
     * </p>
     * </important>
     * 
     * @param describeSnapshotsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeSnapshots operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeSnapshotsResult> describeSnapshotsAsync(DescribeSnapshotsRequest describeSnapshotsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeSnapshotsRequest, DescribeSnapshotsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeSnapshots operation.
     *
     * @see #describeSnapshotsAsync(DescribeSnapshotsRequest)
     */
    java.util.concurrent.Future<DescribeSnapshotsResult> describeSnapshotsAsync();

    /**
     * Simplified method form for invoking the DescribeSnapshots operation with an AsyncHandler.
     *
     * @see #describeSnapshotsAsync(DescribeSnapshotsRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeSnapshotsResult> describeSnapshotsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeSnapshotsRequest, DescribeSnapshotsResult> asyncHandler);

    /**
     * <p>
     * Describes the data feed for Spot Instances. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance data feed</a> in
     * the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * 
     * @param describeSpotDatafeedSubscriptionRequest
     *        Contains the parameters for DescribeSpotDatafeedSubscription.
     * @return A Java Future containing the result of the DescribeSpotDatafeedSubscription operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeSpotDatafeedSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSpotDatafeedSubscriptionResult> describeSpotDatafeedSubscriptionAsync(
            DescribeSpotDatafeedSubscriptionRequest describeSpotDatafeedSubscriptionRequest);

    /**
     * <p>
     * Describes the data feed for Spot Instances. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html">Spot Instance data feed</a> in
     * the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * 
     * @param describeSpotDatafeedSubscriptionRequest
     *        Contains the parameters for DescribeSpotDatafeedSubscription.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeSpotDatafeedSubscription operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeSpotDatafeedSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotDatafeedSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSpotDatafeedSubscriptionResult> describeSpotDatafeedSubscriptionAsync(
            DescribeSpotDatafeedSubscriptionRequest describeSpotDatafeedSubscriptionRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeSpotDatafeedSubscriptionRequest, DescribeSpotDatafeedSubscriptionResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeSpotDatafeedSubscription operation.
     *
     * @see #describeSpotDatafeedSubscriptionAsync(DescribeSpotDatafeedSubscriptionRequest)
     */
    java.util.concurrent.Future<DescribeSpotDatafeedSubscriptionResult> describeSpotDatafeedSubscriptionAsync();

    /**
     * Simplified method form for invoking the DescribeSpotDatafeedSubscription operation with an AsyncHandler.
     *
     * @see #describeSpotDatafeedSubscriptionAsync(DescribeSpotDatafeedSubscriptionRequest,
     *      com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeSpotDatafeedSubscriptionResult> describeSpotDatafeedSubscriptionAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeSpotDatafeedSubscriptionRequest, DescribeSpotDatafeedSubscriptionResult> asyncHandler);

    /**
     * <p>
     * Describes the running instances for the specified Spot Fleet.
     * </p>
     * 
     * @param describeSpotFleetInstancesRequest
     *        Contains the parameters for DescribeSpotFleetInstances.
     * @return A Java Future containing the result of the DescribeSpotFleetInstances operation returned by the service.
     * @sample AmazonEC2Async.DescribeSpotFleetInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetInstances" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSpotFleetInstancesResult> describeSpotFleetInstancesAsync(
            DescribeSpotFleetInstancesRequest describeSpotFleetInstancesRequest);

    /**
     * <p>
     * Describes the running instances for the specified Spot Fleet.
     * </p>
     * 
     * @param describeSpotFleetInstancesRequest
     *        Contains the parameters for DescribeSpotFleetInstances.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeSpotFleetInstances operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeSpotFleetInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetInstances" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSpotFleetInstancesResult> describeSpotFleetInstancesAsync(
            DescribeSpotFleetInstancesRequest describeSpotFleetInstancesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeSpotFleetInstancesRequest, DescribeSpotFleetInstancesResult> asyncHandler);

    /**
     * <p>
     * Describes the events for the specified Spot Fleet request during the specified time.
     * </p>
     * <p>
     * Spot Fleet events are delayed by up to 30 seconds before they can be described. This ensures that you can query
     * by the last evaluated time and not miss a recorded event. Spot Fleet events are available for 48 hours.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/fleet-monitor.html">Monitor fleet events using Amazon
     * EventBridge</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describeSpotFleetRequestHistoryRequest
     *        Contains the parameters for DescribeSpotFleetRequestHistory.
     * @return A Java Future containing the result of the DescribeSpotFleetRequestHistory operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeSpotFleetRequestHistory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequestHistory"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSpotFleetRequestHistoryResult> describeSpotFleetRequestHistoryAsync(
            DescribeSpotFleetRequestHistoryRequest describeSpotFleetRequestHistoryRequest);

    /**
     * <p>
     * Describes the events for the specified Spot Fleet request during the specified time.
     * </p>
     * <p>
     * Spot Fleet events are delayed by up to 30 seconds before they can be described. This ensures that you can query
     * by the last evaluated time and not miss a recorded event. Spot Fleet events are available for 48 hours.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/fleet-monitor.html">Monitor fleet events using Amazon
     * EventBridge</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describeSpotFleetRequestHistoryRequest
     *        Contains the parameters for DescribeSpotFleetRequestHistory.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeSpotFleetRequestHistory operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeSpotFleetRequestHistory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequestHistory"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSpotFleetRequestHistoryResult> describeSpotFleetRequestHistoryAsync(
            DescribeSpotFleetRequestHistoryRequest describeSpotFleetRequestHistoryRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeSpotFleetRequestHistoryRequest, DescribeSpotFleetRequestHistoryResult> asyncHandler);

    /**
     * <p>
     * Describes your Spot Fleet requests.
     * </p>
     * <p>
     * Spot Fleet requests are deleted 48 hours after they are canceled and their instances are terminated.
     * </p>
     * 
     * @param describeSpotFleetRequestsRequest
     *        Contains the parameters for DescribeSpotFleetRequests.
     * @return A Java Future containing the result of the DescribeSpotFleetRequests operation returned by the service.
     * @sample AmazonEC2Async.DescribeSpotFleetRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequests" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSpotFleetRequestsResult> describeSpotFleetRequestsAsync(
            DescribeSpotFleetRequestsRequest describeSpotFleetRequestsRequest);

    /**
     * <p>
     * Describes your Spot Fleet requests.
     * </p>
     * <p>
     * Spot Fleet requests are deleted 48 hours after they are canceled and their instances are terminated.
     * </p>
     * 
     * @param describeSpotFleetRequestsRequest
     *        Contains the parameters for DescribeSpotFleetRequests.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeSpotFleetRequests operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeSpotFleetRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequests" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSpotFleetRequestsResult> describeSpotFleetRequestsAsync(
            DescribeSpotFleetRequestsRequest describeSpotFleetRequestsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeSpotFleetRequestsRequest, DescribeSpotFleetRequestsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeSpotFleetRequests operation.
     *
     * @see #describeSpotFleetRequestsAsync(DescribeSpotFleetRequestsRequest)
     */
    java.util.concurrent.Future<DescribeSpotFleetRequestsResult> describeSpotFleetRequestsAsync();

    /**
     * Simplified method form for invoking the DescribeSpotFleetRequests operation with an AsyncHandler.
     *
     * @see #describeSpotFleetRequestsAsync(DescribeSpotFleetRequestsRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeSpotFleetRequestsResult> describeSpotFleetRequestsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeSpotFleetRequestsRequest, DescribeSpotFleetRequestsResult> asyncHandler);

    /**
     * <p>
     * Describes the specified Spot Instance requests.
     * </p>
     * <p>
     * You can use <code>DescribeSpotInstanceRequests</code> to find a running Spot Instance by examining the response.
     * If the status of the Spot Instance is <code>fulfilled</code>, the instance ID appears in the response and
     * contains the identifier of the instance. Alternatively, you can use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances">DescribeInstances</a> with a
     * filter to look for instances where the instance lifecycle is <code>spot</code>.
     * </p>
     * <p>
     * We recommend that you set <code>MaxResults</code> to a value between 5 and 1000 to limit the number of items
     * returned. This paginates the output, which makes the list more manageable and returns the items faster. If the
     * list of items exceeds your <code>MaxResults</code> value, then that number of items is returned along with a
     * <code>NextToken</code> value that can be passed to a subsequent <code>DescribeSpotInstanceRequests</code> request
     * to retrieve the remaining items.
     * </p>
     * <p>
     * Spot Instance requests are deleted four hours after they are canceled and their instances are terminated.
     * </p>
     * 
     * @param describeSpotInstanceRequestsRequest
     *        Contains the parameters for DescribeSpotInstanceRequests.
     * @return A Java Future containing the result of the DescribeSpotInstanceRequests operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeSpotInstanceRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotInstanceRequests"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSpotInstanceRequestsResult> describeSpotInstanceRequestsAsync(
            DescribeSpotInstanceRequestsRequest describeSpotInstanceRequestsRequest);

    /**
     * <p>
     * Describes the specified Spot Instance requests.
     * </p>
     * <p>
     * You can use <code>DescribeSpotInstanceRequests</code> to find a running Spot Instance by examining the response.
     * If the status of the Spot Instance is <code>fulfilled</code>, the instance ID appears in the response and
     * contains the identifier of the instance. Alternatively, you can use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances">DescribeInstances</a> with a
     * filter to look for instances where the instance lifecycle is <code>spot</code>.
     * </p>
     * <p>
     * We recommend that you set <code>MaxResults</code> to a value between 5 and 1000 to limit the number of items
     * returned. This paginates the output, which makes the list more manageable and returns the items faster. If the
     * list of items exceeds your <code>MaxResults</code> value, then that number of items is returned along with a
     * <code>NextToken</code> value that can be passed to a subsequent <code>DescribeSpotInstanceRequests</code> request
     * to retrieve the remaining items.
     * </p>
     * <p>
     * Spot Instance requests are deleted four hours after they are canceled and their instances are terminated.
     * </p>
     * 
     * @param describeSpotInstanceRequestsRequest
     *        Contains the parameters for DescribeSpotInstanceRequests.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeSpotInstanceRequests operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeSpotInstanceRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotInstanceRequests"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSpotInstanceRequestsResult> describeSpotInstanceRequestsAsync(
            DescribeSpotInstanceRequestsRequest describeSpotInstanceRequestsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeSpotInstanceRequestsRequest, DescribeSpotInstanceRequestsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeSpotInstanceRequests operation.
     *
     * @see #describeSpotInstanceRequestsAsync(DescribeSpotInstanceRequestsRequest)
     */
    java.util.concurrent.Future<DescribeSpotInstanceRequestsResult> describeSpotInstanceRequestsAsync();

    /**
     * Simplified method form for invoking the DescribeSpotInstanceRequests operation with an AsyncHandler.
     *
     * @see #describeSpotInstanceRequestsAsync(DescribeSpotInstanceRequestsRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeSpotInstanceRequestsResult> describeSpotInstanceRequestsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeSpotInstanceRequestsRequest, DescribeSpotInstanceRequestsResult> asyncHandler);

    /**
     * <p>
     * Describes the Spot price history. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances-history.html">Spot Instance
     * pricing history</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * <p>
     * When you specify a start and end time, the operation returns the prices of the instance types within that time
     * range. It also returns the last price change before the start time, which is the effective price as of the start
     * time.
     * </p>
     * 
     * @param describeSpotPriceHistoryRequest
     *        Contains the parameters for DescribeSpotPriceHistory.
     * @return A Java Future containing the result of the DescribeSpotPriceHistory operation returned by the service.
     * @sample AmazonEC2Async.DescribeSpotPriceHistory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotPriceHistory" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSpotPriceHistoryResult> describeSpotPriceHistoryAsync(DescribeSpotPriceHistoryRequest describeSpotPriceHistoryRequest);

    /**
     * <p>
     * Describes the Spot price history. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances-history.html">Spot Instance
     * pricing history</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * <p>
     * When you specify a start and end time, the operation returns the prices of the instance types within that time
     * range. It also returns the last price change before the start time, which is the effective price as of the start
     * time.
     * </p>
     * 
     * @param describeSpotPriceHistoryRequest
     *        Contains the parameters for DescribeSpotPriceHistory.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeSpotPriceHistory operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeSpotPriceHistory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotPriceHistory" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeSpotPriceHistoryResult> describeSpotPriceHistoryAsync(DescribeSpotPriceHistoryRequest describeSpotPriceHistoryRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeSpotPriceHistoryRequest, DescribeSpotPriceHistoryResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeSpotPriceHistory operation.
     *
     * @see #describeSpotPriceHistoryAsync(DescribeSpotPriceHistoryRequest)
     */
    java.util.concurrent.Future<DescribeSpotPriceHistoryResult> describeSpotPriceHistoryAsync();

    /**
     * Simplified method form for invoking the DescribeSpotPriceHistory operation with an AsyncHandler.
     *
     * @see #describeSpotPriceHistoryAsync(DescribeSpotPriceHistoryRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeSpotPriceHistoryResult> describeSpotPriceHistoryAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeSpotPriceHistoryRequest, DescribeSpotPriceHistoryResult> asyncHandler);

    /**
     * <p>
     * Describes the stale security group rules for security groups in a specified VPC. Rules are stale when they
     * reference a deleted security group in the same VPC or peered VPC. Rules can also be stale if they reference a
     * security group in a peer VPC for which the VPC peering connection has been deleted.
     * </p>
     * 
     * @param describeStaleSecurityGroupsRequest
     * @return A Java Future containing the result of the DescribeStaleSecurityGroups operation returned by the service.
     * @sample AmazonEC2Async.DescribeStaleSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeStaleSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeStaleSecurityGroupsResult> describeStaleSecurityGroupsAsync(
            DescribeStaleSecurityGroupsRequest describeStaleSecurityGroupsRequest);

    /**
     * <p>
     * Describes the stale security group rules for security groups in a specified VPC. Rules are stale when they
     * reference a deleted security group in the same VPC or peered VPC. Rules can also be stale if they reference a
     * security group in a peer VPC for which the VPC peering connection has been deleted.
     * </p>
     * 
     * @param describeStaleSecurityGroupsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeStaleSecurityGroups operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeStaleSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeStaleSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeStaleSecurityGroupsResult> describeStaleSecurityGroupsAsync(
            DescribeStaleSecurityGroupsRequest describeStaleSecurityGroupsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeStaleSecurityGroupsRequest, DescribeStaleSecurityGroupsResult> asyncHandler);

    /**
     * <p>
     * Describes the progress of the AMI store tasks. You can describe the store tasks for specified AMIs. If you don't
     * specify the AMIs, you get a paginated list of store tasks from the last 31 days.
     * </p>
     * <p>
     * For each AMI task, the response indicates if the task is <code>InProgress</code>, <code>Completed</code>, or
     * <code>Failed</code>. For tasks <code>InProgress</code>, the response shows the estimated progress as a
     * percentage.
     * </p>
     * <p>
     * Tasks are listed in reverse chronological order. Currently, only tasks from the past 31 days can be viewed.
     * </p>
     * <p>
     * To use this API, you must have the required permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions
     * for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describeStoreImageTasksRequest
     * @return A Java Future containing the result of the DescribeStoreImageTasks operation returned by the service.
     * @sample AmazonEC2Async.DescribeStoreImageTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeStoreImageTasks" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeStoreImageTasksResult> describeStoreImageTasksAsync(DescribeStoreImageTasksRequest describeStoreImageTasksRequest);

    /**
     * <p>
     * Describes the progress of the AMI store tasks. You can describe the store tasks for specified AMIs. If you don't
     * specify the AMIs, you get a paginated list of store tasks from the last 31 days.
     * </p>
     * <p>
     * For each AMI task, the response indicates if the task is <code>InProgress</code>, <code>Completed</code>, or
     * <code>Failed</code>. For tasks <code>InProgress</code>, the response shows the estimated progress as a
     * percentage.
     * </p>
     * <p>
     * Tasks are listed in reverse chronological order. Currently, only tasks from the past 31 days can be viewed.
     * </p>
     * <p>
     * To use this API, you must have the required permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions">Permissions
     * for storing and restoring AMIs using Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html">Store and restore an AMI using
     * Amazon S3</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @param describeStoreImageTasksRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeStoreImageTasks operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeStoreImageTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeStoreImageTasks" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeStoreImageTasksResult> describeStoreImageTasksAsync(DescribeStoreImageTasksRequest describeStoreImageTasksRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeStoreImageTasksRequest, DescribeStoreImageTasksResult> asyncHandler);

    /**
     * <p>
     * Describes one or more of your subnets.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/configure-subnets.html">Subnets</a> in the <i>Amazon VPC
     * User Guide</i>.
     * </p>
     * 
     * @param describeSubnetsRequest
     * @return A Java Future containing the result of the DescribeSubnets operation returned by the service.
     * @sample AmazonEC2Async.DescribeSubnets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSubnets" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeSubnetsResult> describeSubnetsAsync(DescribeSubnetsRequest describeSubnetsRequest);

    /**
     * <p>
     * Describes one or more of your subnets.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/configure-subnets.html">Subnets</a> in the <i>Amazon VPC
     * User Guide</i>.
     * </p>
     * 
     * @param describeSubnetsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeSubnets operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeSubnets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSubnets" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeSubnetsResult> describeSubnetsAsync(DescribeSubnetsRequest describeSubnetsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeSubnetsRequest, DescribeSubnetsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeSubnets operation.
     *
     * @see #describeSubnetsAsync(DescribeSubnetsRequest)
     */
    java.util.concurrent.Future<DescribeSubnetsResult> describeSubnetsAsync();

    /**
     * Simplified method form for invoking the DescribeSubnets operation with an AsyncHandler.
     *
     * @see #describeSubnetsAsync(DescribeSubnetsRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeSubnetsResult> describeSubnetsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeSubnetsRequest, DescribeSubnetsResult> asyncHandler);

    /**
     * <p>
     * Describes the specified tags for your EC2 resources.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <important>
     * <p>
     * We strongly recommend using only paginated requests. Unpaginated requests are susceptible to throttling and
     * timeouts.
     * </p>
     * </important> <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeTagsRequest
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.
     * @sample AmazonEC2Async.DescribeTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeTagsResult> describeTagsAsync(DescribeTagsRequest describeTagsRequest);

    /**
     * <p>
     * Describes the specified tags for your EC2 resources.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <important>
     * <p>
     * We strongly recommend using only paginated requests. Unpaginated requests are susceptible to throttling and
     * timeouts.
     * </p>
     * </important> <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeTagsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeTagsResult> describeTagsAsync(DescribeTagsRequest describeTagsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeTags operation.
     *
     * @see #describeTagsAsync(DescribeTagsRequest)
     */
    java.util.concurrent.Future<DescribeTagsResult> describeTagsAsync();

    /**
     * Simplified method form for invoking the DescribeTags operation with an AsyncHandler.
     *
     * @see #describeTagsAsync(DescribeTagsRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeTagsResult> describeTagsAsync(com.amazonaws.handlers.AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more Traffic Mirror filters.
     * </p>
     * 
     * @param describeTrafficMirrorFiltersRequest
     * @return A Java Future containing the result of the DescribeTrafficMirrorFilters operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeTrafficMirrorFilters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTrafficMirrorFilters"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTrafficMirrorFiltersResult> describeTrafficMirrorFiltersAsync(
            DescribeTrafficMirrorFiltersRequest describeTrafficMirrorFiltersRequest);

    /**
     * <p>
     * Describes one or more Traffic Mirror filters.
     * </p>
     * 
     * @param describeTrafficMirrorFiltersRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeTrafficMirrorFilters operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeTrafficMirrorFilters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTrafficMirrorFilters"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTrafficMirrorFiltersResult> describeTrafficMirrorFiltersAsync(
            DescribeTrafficMirrorFiltersRequest describeTrafficMirrorFiltersRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeTrafficMirrorFiltersRequest, DescribeTrafficMirrorFiltersResult> asyncHandler);

    /**
     * <p>
     * Describes one or more Traffic Mirror sessions. By default, all Traffic Mirror sessions are described.
     * Alternatively, you can filter the results.
     * </p>
     * 
     * @param describeTrafficMirrorSessionsRequest
     * @return A Java Future containing the result of the DescribeTrafficMirrorSessions operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeTrafficMirrorSessions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTrafficMirrorSessions"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTrafficMirrorSessionsResult> describeTrafficMirrorSessionsAsync(
            DescribeTrafficMirrorSessionsRequest describeTrafficMirrorSessionsRequest);

    /**
     * <p>
     * Describes one or more Traffic Mirror sessions. By default, all Traffic Mirror sessions are described.
     * Alternatively, you can filter the results.
     * </p>
     * 
     * @param describeTrafficMirrorSessionsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeTrafficMirrorSessions operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeTrafficMirrorSessions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTrafficMirrorSessions"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTrafficMirrorSessionsResult> describeTrafficMirrorSessionsAsync(
            DescribeTrafficMirrorSessionsRequest describeTrafficMirrorSessionsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeTrafficMirrorSessionsRequest, DescribeTrafficMirrorSessionsResult> asyncHandler);

    /**
     * <p>
     * Information about one or more Traffic Mirror targets.
     * </p>
     * 
     * @param describeTrafficMirrorTargetsRequest
     * @return A Java Future containing the result of the DescribeTrafficMirrorTargets operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeTrafficMirrorTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTrafficMirrorTargets"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTrafficMirrorTargetsResult> describeTrafficMirrorTargetsAsync(
            DescribeTrafficMirrorTargetsRequest describeTrafficMirrorTargetsRequest);

    /**
     * <p>
     * Information about one or more Traffic Mirror targets.
     * </p>
     * 
     * @param describeTrafficMirrorTargetsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeTrafficMirrorTargets operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeTrafficMirrorTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTrafficMirrorTargets"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTrafficMirrorTargetsResult> describeTrafficMirrorTargetsAsync(
            DescribeTrafficMirrorTargetsRequest describeTrafficMirrorTargetsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeTrafficMirrorTargetsRequest, DescribeTrafficMirrorTargetsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more attachments between resources and transit gateways. By default, all attachments are
     * described. Alternatively, you can filter the results by attachment ID, attachment state, resource ID, or resource
     * owner.
     * </p>
     * 
     * @param describeTransitGatewayAttachmentsRequest
     * @return A Java Future containing the result of the DescribeTransitGatewayAttachments operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeTransitGatewayAttachments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewayAttachmentsResult> describeTransitGatewayAttachmentsAsync(
            DescribeTransitGatewayAttachmentsRequest describeTransitGatewayAttachmentsRequest);

    /**
     * <p>
     * Describes one or more attachments between resources and transit gateways. By default, all attachments are
     * described. Alternatively, you can filter the results by attachment ID, attachment state, resource ID, or resource
     * owner.
     * </p>
     * 
     * @param describeTransitGatewayAttachmentsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeTransitGatewayAttachments operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeTransitGatewayAttachments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewayAttachmentsResult> describeTransitGatewayAttachmentsAsync(
            DescribeTransitGatewayAttachmentsRequest describeTransitGatewayAttachmentsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeTransitGatewayAttachmentsRequest, DescribeTransitGatewayAttachmentsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more Connect peers.
     * </p>
     * 
     * @param describeTransitGatewayConnectPeersRequest
     * @return A Java Future containing the result of the DescribeTransitGatewayConnectPeers operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeTransitGatewayConnectPeers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayConnectPeers"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewayConnectPeersResult> describeTransitGatewayConnectPeersAsync(
            DescribeTransitGatewayConnectPeersRequest describeTransitGatewayConnectPeersRequest);

    /**
     * <p>
     * Describes one or more Connect peers.
     * </p>
     * 
     * @param describeTransitGatewayConnectPeersRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeTransitGatewayConnectPeers operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeTransitGatewayConnectPeers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayConnectPeers"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewayConnectPeersResult> describeTransitGatewayConnectPeersAsync(
            DescribeTransitGatewayConnectPeersRequest describeTransitGatewayConnectPeersRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeTransitGatewayConnectPeersRequest, DescribeTransitGatewayConnectPeersResult> asyncHandler);

    /**
     * <p>
     * Describes one or more Connect attachments.
     * </p>
     * 
     * @param describeTransitGatewayConnectsRequest
     * @return A Java Future containing the result of the DescribeTransitGatewayConnects operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeTransitGatewayConnects
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayConnects"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewayConnectsResult> describeTransitGatewayConnectsAsync(
            DescribeTransitGatewayConnectsRequest describeTransitGatewayConnectsRequest);

    /**
     * <p>
     * Describes one or more Connect attachments.
     * </p>
     * 
     * @param describeTransitGatewayConnectsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeTransitGatewayConnects operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeTransitGatewayConnects
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayConnects"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewayConnectsResult> describeTransitGatewayConnectsAsync(
            DescribeTransitGatewayConnectsRequest describeTransitGatewayConnectsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeTransitGatewayConnectsRequest, DescribeTransitGatewayConnectsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more transit gateway multicast domains.
     * </p>
     * 
     * @param describeTransitGatewayMulticastDomainsRequest
     * @return A Java Future containing the result of the DescribeTransitGatewayMulticastDomains operation returned by
     *         the service.
     * @sample AmazonEC2Async.DescribeTransitGatewayMulticastDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayMulticastDomains"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewayMulticastDomainsResult> describeTransitGatewayMulticastDomainsAsync(
            DescribeTransitGatewayMulticastDomainsRequest describeTransitGatewayMulticastDomainsRequest);

    /**
     * <p>
     * Describes one or more transit gateway multicast domains.
     * </p>
     * 
     * @param describeTransitGatewayMulticastDomainsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeTransitGatewayMulticastDomains operation returned by
     *         the service.
     * @sample AmazonEC2AsyncHandler.DescribeTransitGatewayMulticastDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayMulticastDomains"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewayMulticastDomainsResult> describeTransitGatewayMulticastDomainsAsync(
            DescribeTransitGatewayMulticastDomainsRequest describeTransitGatewayMulticastDomainsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeTransitGatewayMulticastDomainsRequest, DescribeTransitGatewayMulticastDomainsResult> asyncHandler);

    /**
     * <p>
     * Describes your transit gateway peering attachments.
     * </p>
     * 
     * @param describeTransitGatewayPeeringAttachmentsRequest
     * @return A Java Future containing the result of the DescribeTransitGatewayPeeringAttachments operation returned by
     *         the service.
     * @sample AmazonEC2Async.DescribeTransitGatewayPeeringAttachments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayPeeringAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewayPeeringAttachmentsResult> describeTransitGatewayPeeringAttachmentsAsync(
            DescribeTransitGatewayPeeringAttachmentsRequest describeTransitGatewayPeeringAttachmentsRequest);

    /**
     * <p>
     * Describes your transit gateway peering attachments.
     * </p>
     * 
     * @param describeTransitGatewayPeeringAttachmentsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeTransitGatewayPeeringAttachments operation returned by
     *         the service.
     * @sample AmazonEC2AsyncHandler.DescribeTransitGatewayPeeringAttachments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayPeeringAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewayPeeringAttachmentsResult> describeTransitGatewayPeeringAttachmentsAsync(
            DescribeTransitGatewayPeeringAttachmentsRequest describeTransitGatewayPeeringAttachmentsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeTransitGatewayPeeringAttachmentsRequest, DescribeTransitGatewayPeeringAttachmentsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more transit gateway route policy tables.
     * </p>
     * 
     * @param describeTransitGatewayPolicyTablesRequest
     * @return A Java Future containing the result of the DescribeTransitGatewayPolicyTables operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeTransitGatewayPolicyTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayPolicyTables"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewayPolicyTablesResult> describeTransitGatewayPolicyTablesAsync(
            DescribeTransitGatewayPolicyTablesRequest describeTransitGatewayPolicyTablesRequest);

    /**
     * <p>
     * Describes one or more transit gateway route policy tables.
     * </p>
     * 
     * @param describeTransitGatewayPolicyTablesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeTransitGatewayPolicyTables operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeTransitGatewayPolicyTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayPolicyTables"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewayPolicyTablesResult> describeTransitGatewayPolicyTablesAsync(
            DescribeTransitGatewayPolicyTablesRequest describeTransitGatewayPolicyTablesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeTransitGatewayPolicyTablesRequest, DescribeTransitGatewayPolicyTablesResult> asyncHandler);

    /**
     * <p>
     * Describes one or more transit gateway route table advertisements.
     * </p>
     * 
     * @param describeTransitGatewayRouteTableAnnouncementsRequest
     * @return A Java Future containing the result of the DescribeTransitGatewayRouteTableAnnouncements operation
     *         returned by the service.
     * @sample AmazonEC2Async.DescribeTransitGatewayRouteTableAnnouncements
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayRouteTableAnnouncements"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewayRouteTableAnnouncementsResult> describeTransitGatewayRouteTableAnnouncementsAsync(
            DescribeTransitGatewayRouteTableAnnouncementsRequest describeTransitGatewayRouteTableAnnouncementsRequest);

    /**
     * <p>
     * Describes one or more transit gateway route table advertisements.
     * </p>
     * 
     * @param describeTransitGatewayRouteTableAnnouncementsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeTransitGatewayRouteTableAnnouncements operation
     *         returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeTransitGatewayRouteTableAnnouncements
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayRouteTableAnnouncements"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewayRouteTableAnnouncementsResult> describeTransitGatewayRouteTableAnnouncementsAsync(
            DescribeTransitGatewayRouteTableAnnouncementsRequest describeTransitGatewayRouteTableAnnouncementsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeTransitGatewayRouteTableAnnouncementsRequest, DescribeTransitGatewayRouteTableAnnouncementsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more transit gateway route tables. By default, all transit gateway route tables are described.
     * Alternatively, you can filter the results.
     * </p>
     * 
     * @param describeTransitGatewayRouteTablesRequest
     * @return A Java Future containing the result of the DescribeTransitGatewayRouteTables operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeTransitGatewayRouteTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayRouteTables"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewayRouteTablesResult> describeTransitGatewayRouteTablesAsync(
            DescribeTransitGatewayRouteTablesRequest describeTransitGatewayRouteTablesRequest);

    /**
     * <p>
     * Describes one or more transit gateway route tables. By default, all transit gateway route tables are described.
     * Alternatively, you can filter the results.
     * </p>
     * 
     * @param describeTransitGatewayRouteTablesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeTransitGatewayRouteTables operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeTransitGatewayRouteTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayRouteTables"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewayRouteTablesResult> describeTransitGatewayRouteTablesAsync(
            DescribeTransitGatewayRouteTablesRequest describeTransitGatewayRouteTablesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeTransitGatewayRouteTablesRequest, DescribeTransitGatewayRouteTablesResult> asyncHandler);

    /**
     * <p>
     * Describes one or more VPC attachments. By default, all VPC attachments are described. Alternatively, you can
     * filter the results.
     * </p>
     * 
     * @param describeTransitGatewayVpcAttachmentsRequest
     * @return A Java Future containing the result of the DescribeTransitGatewayVpcAttachments operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeTransitGatewayVpcAttachments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayVpcAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewayVpcAttachmentsResult> describeTransitGatewayVpcAttachmentsAsync(
            DescribeTransitGatewayVpcAttachmentsRequest describeTransitGatewayVpcAttachmentsRequest);

    /**
     * <p>
     * Describes one or more VPC attachments. By default, all VPC attachments are described. Alternatively, you can
     * filter the results.
     * </p>
     * 
     * @param describeTransitGatewayVpcAttachmentsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeTransitGatewayVpcAttachments operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeTransitGatewayVpcAttachments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayVpcAttachments"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewayVpcAttachmentsResult> describeTransitGatewayVpcAttachmentsAsync(
            DescribeTransitGatewayVpcAttachmentsRequest describeTransitGatewayVpcAttachmentsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeTransitGatewayVpcAttachmentsRequest, DescribeTransitGatewayVpcAttachmentsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more transit gateways. By default, all transit gateways are described. Alternatively, you can
     * filter the results.
     * </p>
     * 
     * @param describeTransitGatewaysRequest
     * @return A Java Future containing the result of the DescribeTransitGateways operation returned by the service.
     * @sample AmazonEC2Async.DescribeTransitGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGateways" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewaysResult> describeTransitGatewaysAsync(DescribeTransitGatewaysRequest describeTransitGatewaysRequest);

    /**
     * <p>
     * Describes one or more transit gateways. By default, all transit gateways are described. Alternatively, you can
     * filter the results.
     * </p>
     * 
     * @param describeTransitGatewaysRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeTransitGateways operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeTransitGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGateways" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTransitGatewaysResult> describeTransitGatewaysAsync(DescribeTransitGatewaysRequest describeTransitGatewaysRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeTransitGatewaysRequest, DescribeTransitGatewaysResult> asyncHandler);

    /**
     * <p>
     * Describes one or more network interface trunk associations.
     * </p>
     * 
     * @param describeTrunkInterfaceAssociationsRequest
     * @return A Java Future containing the result of the DescribeTrunkInterfaceAssociations operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeTrunkInterfaceAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTrunkInterfaceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTrunkInterfaceAssociationsResult> describeTrunkInterfaceAssociationsAsync(
            DescribeTrunkInterfaceAssociationsRequest describeTrunkInterfaceAssociationsRequest);

    /**
     * <p>
     * Describes one or more network interface trunk associations.
     * </p>
     * 
     * @param describeTrunkInterfaceAssociationsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeTrunkInterfaceAssociations operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeTrunkInterfaceAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTrunkInterfaceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeTrunkInterfaceAssociationsResult> describeTrunkInterfaceAssociationsAsync(
            DescribeTrunkInterfaceAssociationsRequest describeTrunkInterfaceAssociationsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeTrunkInterfaceAssociationsRequest, DescribeTrunkInterfaceAssociationsResult> asyncHandler);

    /**
     * <p>
     * Describes the specified Amazon Web Services Verified Access endpoints.
     * </p>
     * 
     * @param describeVerifiedAccessEndpointsRequest
     * @return A Java Future containing the result of the DescribeVerifiedAccessEndpoints operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeVerifiedAccessEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVerifiedAccessEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVerifiedAccessEndpointsResult> describeVerifiedAccessEndpointsAsync(
            DescribeVerifiedAccessEndpointsRequest describeVerifiedAccessEndpointsRequest);

    /**
     * <p>
     * Describes the specified Amazon Web Services Verified Access endpoints.
     * </p>
     * 
     * @param describeVerifiedAccessEndpointsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVerifiedAccessEndpoints operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeVerifiedAccessEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVerifiedAccessEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVerifiedAccessEndpointsResult> describeVerifiedAccessEndpointsAsync(
            DescribeVerifiedAccessEndpointsRequest describeVerifiedAccessEndpointsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVerifiedAccessEndpointsRequest, DescribeVerifiedAccessEndpointsResult> asyncHandler);

    /**
     * <p>
     * Describes the specified Verified Access groups.
     * </p>
     * 
     * @param describeVerifiedAccessGroupsRequest
     * @return A Java Future containing the result of the DescribeVerifiedAccessGroups operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeVerifiedAccessGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVerifiedAccessGroups"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVerifiedAccessGroupsResult> describeVerifiedAccessGroupsAsync(
            DescribeVerifiedAccessGroupsRequest describeVerifiedAccessGroupsRequest);

    /**
     * <p>
     * Describes the specified Verified Access groups.
     * </p>
     * 
     * @param describeVerifiedAccessGroupsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVerifiedAccessGroups operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeVerifiedAccessGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVerifiedAccessGroups"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVerifiedAccessGroupsResult> describeVerifiedAccessGroupsAsync(
            DescribeVerifiedAccessGroupsRequest describeVerifiedAccessGroupsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVerifiedAccessGroupsRequest, DescribeVerifiedAccessGroupsResult> asyncHandler);

    /**
     * <p>
     * Describes the specified Amazon Web Services Verified Access instances.
     * </p>
     * 
     * @param describeVerifiedAccessInstanceLoggingConfigurationsRequest
     * @return A Java Future containing the result of the DescribeVerifiedAccessInstanceLoggingConfigurations operation
     *         returned by the service.
     * @sample AmazonEC2Async.DescribeVerifiedAccessInstanceLoggingConfigurations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVerifiedAccessInstanceLoggingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVerifiedAccessInstanceLoggingConfigurationsResult> describeVerifiedAccessInstanceLoggingConfigurationsAsync(
            DescribeVerifiedAccessInstanceLoggingConfigurationsRequest describeVerifiedAccessInstanceLoggingConfigurationsRequest);

    /**
     * <p>
     * Describes the specified Amazon Web Services Verified Access instances.
     * </p>
     * 
     * @param describeVerifiedAccessInstanceLoggingConfigurationsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVerifiedAccessInstanceLoggingConfigurations operation
     *         returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeVerifiedAccessInstanceLoggingConfigurations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVerifiedAccessInstanceLoggingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVerifiedAccessInstanceLoggingConfigurationsResult> describeVerifiedAccessInstanceLoggingConfigurationsAsync(
            DescribeVerifiedAccessInstanceLoggingConfigurationsRequest describeVerifiedAccessInstanceLoggingConfigurationsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVerifiedAccessInstanceLoggingConfigurationsRequest, DescribeVerifiedAccessInstanceLoggingConfigurationsResult> asyncHandler);

    /**
     * <p>
     * Describes the specified Amazon Web Services Verified Access instances.
     * </p>
     * 
     * @param describeVerifiedAccessInstancesRequest
     * @return A Java Future containing the result of the DescribeVerifiedAccessInstances operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeVerifiedAccessInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVerifiedAccessInstances"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVerifiedAccessInstancesResult> describeVerifiedAccessInstancesAsync(
            DescribeVerifiedAccessInstancesRequest describeVerifiedAccessInstancesRequest);

    /**
     * <p>
     * Describes the specified Amazon Web Services Verified Access instances.
     * </p>
     * 
     * @param describeVerifiedAccessInstancesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVerifiedAccessInstances operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeVerifiedAccessInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVerifiedAccessInstances"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVerifiedAccessInstancesResult> describeVerifiedAccessInstancesAsync(
            DescribeVerifiedAccessInstancesRequest describeVerifiedAccessInstancesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVerifiedAccessInstancesRequest, DescribeVerifiedAccessInstancesResult> asyncHandler);

    /**
     * <p>
     * Describes the specified Amazon Web Services Verified Access trust providers.
     * </p>
     * 
     * @param describeVerifiedAccessTrustProvidersRequest
     * @return A Java Future containing the result of the DescribeVerifiedAccessTrustProviders operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeVerifiedAccessTrustProviders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVerifiedAccessTrustProviders"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVerifiedAccessTrustProvidersResult> describeVerifiedAccessTrustProvidersAsync(
            DescribeVerifiedAccessTrustProvidersRequest describeVerifiedAccessTrustProvidersRequest);

    /**
     * <p>
     * Describes the specified Amazon Web Services Verified Access trust providers.
     * </p>
     * 
     * @param describeVerifiedAccessTrustProvidersRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVerifiedAccessTrustProviders operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeVerifiedAccessTrustProviders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVerifiedAccessTrustProviders"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVerifiedAccessTrustProvidersResult> describeVerifiedAccessTrustProvidersAsync(
            DescribeVerifiedAccessTrustProvidersRequest describeVerifiedAccessTrustProvidersRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVerifiedAccessTrustProvidersRequest, DescribeVerifiedAccessTrustProvidersResult> asyncHandler);

    /**
     * <p>
     * Describes the specified attribute of the specified volume. You can specify only one attribute at a time.
     * </p>
     * <p>
     * For more information about EBS volumes, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes.html">Amazon EBS volumes</a> in the <i>Amazon
     * EBS User Guide</i>.
     * </p>
     * 
     * @param describeVolumeAttributeRequest
     * @return A Java Future containing the result of the DescribeVolumeAttribute operation returned by the service.
     * @sample AmazonEC2Async.DescribeVolumeAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumeAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVolumeAttributeResult> describeVolumeAttributeAsync(DescribeVolumeAttributeRequest describeVolumeAttributeRequest);

    /**
     * <p>
     * Describes the specified attribute of the specified volume. You can specify only one attribute at a time.
     * </p>
     * <p>
     * For more information about EBS volumes, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes.html">Amazon EBS volumes</a> in the <i>Amazon
     * EBS User Guide</i>.
     * </p>
     * 
     * @param describeVolumeAttributeRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVolumeAttribute operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeVolumeAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumeAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVolumeAttributeResult> describeVolumeAttributeAsync(DescribeVolumeAttributeRequest describeVolumeAttributeRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVolumeAttributeRequest, DescribeVolumeAttributeResult> asyncHandler);

    /**
     * <p>
     * Describes the status of the specified volumes. Volume status provides the result of the checks performed on your
     * volumes to determine events that can impair the performance of your volumes. The performance of a volume can be
     * affected if an issue occurs on the volume's underlying host. If the volume's underlying host experiences a power
     * outage or system issue, after the system is restored, there could be data inconsistencies on the volume. Volume
     * events notify you if this occurs. Volume actions notify you if any action needs to be taken in response to the
     * event.
     * </p>
     * <p>
     * The <code>DescribeVolumeStatus</code> operation provides the following information about the specified volumes:
     * </p>
     * <p>
     * <i>Status</i>: Reflects the current status of the volume. The possible values are <code>ok</code>,
     * <code>impaired</code> , <code>warning</code>, or <code>insufficient-data</code>. If all checks pass, the overall
     * status of the volume is <code>ok</code>. If the check fails, the overall status is <code>impaired</code>. If the
     * status is <code>insufficient-data</code>, then the checks might still be taking place on your volume at the time.
     * We recommend that you retry the request. For more information about volume status, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-status.html">Monitor the status of your
     * volumes</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * <i>Events</i>: Reflect the cause of a volume status and might require you to take action. For example, if your
     * volume returns an <code>impaired</code> status, then the volume event might be
     * <code>potential-data-inconsistency</code>. This means that your volume has been affected by an issue with the
     * underlying host, has all I/O operations disabled, and might have inconsistent data.
     * </p>
     * <p>
     * <i>Actions</i>: Reflect the actions you might have to take in response to an event. For example, if the status of
     * the volume is <code>impaired</code> and the volume event shows <code>potential-data-inconsistency</code>, then
     * the action shows <code>enable-volume-io</code>. This means that you may want to enable the I/O operations for the
     * volume by calling the <a>EnableVolumeIO</a> action and then check the volume for data consistency.
     * </p>
     * <p>
     * Volume status is based on the volume status checks, and does not reflect the volume state. Therefore, volume
     * status does not indicate volumes in the <code>error</code> state (for example, when a volume is incapable of
     * accepting I/O.)
     * </p>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeVolumeStatusRequest
     * @return A Java Future containing the result of the DescribeVolumeStatus operation returned by the service.
     * @sample AmazonEC2Async.DescribeVolumeStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumeStatus" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeVolumeStatusResult> describeVolumeStatusAsync(DescribeVolumeStatusRequest describeVolumeStatusRequest);

    /**
     * <p>
     * Describes the status of the specified volumes. Volume status provides the result of the checks performed on your
     * volumes to determine events that can impair the performance of your volumes. The performance of a volume can be
     * affected if an issue occurs on the volume's underlying host. If the volume's underlying host experiences a power
     * outage or system issue, after the system is restored, there could be data inconsistencies on the volume. Volume
     * events notify you if this occurs. Volume actions notify you if any action needs to be taken in response to the
     * event.
     * </p>
     * <p>
     * The <code>DescribeVolumeStatus</code> operation provides the following information about the specified volumes:
     * </p>
     * <p>
     * <i>Status</i>: Reflects the current status of the volume. The possible values are <code>ok</code>,
     * <code>impaired</code> , <code>warning</code>, or <code>insufficient-data</code>. If all checks pass, the overall
     * status of the volume is <code>ok</code>. If the check fails, the overall status is <code>impaired</code>. If the
     * status is <code>insufficient-data</code>, then the checks might still be taking place on your volume at the time.
     * We recommend that you retry the request. For more information about volume status, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-status.html">Monitor the status of your
     * volumes</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * <p>
     * <i>Events</i>: Reflect the cause of a volume status and might require you to take action. For example, if your
     * volume returns an <code>impaired</code> status, then the volume event might be
     * <code>potential-data-inconsistency</code>. This means that your volume has been affected by an issue with the
     * underlying host, has all I/O operations disabled, and might have inconsistent data.
     * </p>
     * <p>
     * <i>Actions</i>: Reflect the actions you might have to take in response to an event. For example, if the status of
     * the volume is <code>impaired</code> and the volume event shows <code>potential-data-inconsistency</code>, then
     * the action shows <code>enable-volume-io</code>. This means that you may want to enable the I/O operations for the
     * volume by calling the <a>EnableVolumeIO</a> action and then check the volume for data consistency.
     * </p>
     * <p>
     * Volume status is based on the volume status checks, and does not reflect the volume state. Therefore, volume
     * status does not indicate volumes in the <code>error</code> state (for example, when a volume is incapable of
     * accepting I/O.)
     * </p>
     * <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeVolumeStatusRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVolumeStatus operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeVolumeStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumeStatus" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeVolumeStatusResult> describeVolumeStatusAsync(DescribeVolumeStatusRequest describeVolumeStatusRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVolumeStatusRequest, DescribeVolumeStatusResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeVolumeStatus operation.
     *
     * @see #describeVolumeStatusAsync(DescribeVolumeStatusRequest)
     */
    java.util.concurrent.Future<DescribeVolumeStatusResult> describeVolumeStatusAsync();

    /**
     * Simplified method form for invoking the DescribeVolumeStatus operation with an AsyncHandler.
     *
     * @see #describeVolumeStatusAsync(DescribeVolumeStatusRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeVolumeStatusResult> describeVolumeStatusAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeVolumeStatusRequest, DescribeVolumeStatusResult> asyncHandler);

    /**
     * <p>
     * Describes the specified EBS volumes or all of your EBS volumes.
     * </p>
     * <p>
     * If you are describing a long list of volumes, we recommend that you paginate the output to make the list more
     * manageable. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.
     * </p>
     * <p>
     * For more information about EBS volumes, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes.html">Amazon EBS volumes</a> in the <i>Amazon
     * EBS User Guide</i>.
     * </p>
     * <important>
     * <p>
     * We strongly recommend using only paginated requests. Unpaginated requests are susceptible to throttling and
     * timeouts.
     * </p>
     * </important> <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeVolumesRequest
     * @return A Java Future containing the result of the DescribeVolumes operation returned by the service.
     * @sample AmazonEC2Async.DescribeVolumes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumes" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeVolumesResult> describeVolumesAsync(DescribeVolumesRequest describeVolumesRequest);

    /**
     * <p>
     * Describes the specified EBS volumes or all of your EBS volumes.
     * </p>
     * <p>
     * If you are describing a long list of volumes, we recommend that you paginate the output to make the list more
     * manageable. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.
     * </p>
     * <p>
     * For more information about EBS volumes, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes.html">Amazon EBS volumes</a> in the <i>Amazon
     * EBS User Guide</i>.
     * </p>
     * <important>
     * <p>
     * We strongly recommend using only paginated requests. Unpaginated requests are susceptible to throttling and
     * timeouts.
     * </p>
     * </important> <note>
     * <p>
     * The order of the elements in the response, including those within nested structures, might vary. Applications
     * should not assume the elements appear in a particular order.
     * </p>
     * </note>
     * 
     * @param describeVolumesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVolumes operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeVolumes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumes" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeVolumesResult> describeVolumesAsync(DescribeVolumesRequest describeVolumesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVolumesRequest, DescribeVolumesResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeVolumes operation.
     *
     * @see #describeVolumesAsync(DescribeVolumesRequest)
     */
    java.util.concurrent.Future<DescribeVolumesResult> describeVolumesAsync();

    /**
     * Simplified method form for invoking the DescribeVolumes operation with an AsyncHandler.
     *
     * @see #describeVolumesAsync(DescribeVolumesRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeVolumesResult> describeVolumesAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeVolumesRequest, DescribeVolumesResult> asyncHandler);

    /**
     * <p>
     * Describes the most recent volume modification request for the specified EBS volumes.
     * </p>
     * <p>
     * If a volume has never been modified, some information in the output will be null. If a volume has been modified
     * more than once, the output includes only the most recent modification request.
     * </p>
     * <p>
     * You can also use CloudWatch Events to check the status of a modification to an EBS volume. For information about
     * CloudWatch Events, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/">Amazon
     * CloudWatch Events User Guide</a>. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-modifications.html">Monitor the progress
     * of volume modifications</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param describeVolumesModificationsRequest
     * @return A Java Future containing the result of the DescribeVolumesModifications operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeVolumesModifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumesModifications"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVolumesModificationsResult> describeVolumesModificationsAsync(
            DescribeVolumesModificationsRequest describeVolumesModificationsRequest);

    /**
     * <p>
     * Describes the most recent volume modification request for the specified EBS volumes.
     * </p>
     * <p>
     * If a volume has never been modified, some information in the output will be null. If a volume has been modified
     * more than once, the output includes only the most recent modification request.
     * </p>
     * <p>
     * You can also use CloudWatch Events to check the status of a modification to an EBS volume. For information about
     * CloudWatch Events, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/">Amazon
     * CloudWatch Events User Guide</a>. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/monitoring-volume-modifications.html">Monitor the progress
     * of volume modifications</a> in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param describeVolumesModificationsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVolumesModifications operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeVolumesModifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumesModifications"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVolumesModificationsResult> describeVolumesModificationsAsync(
            DescribeVolumesModificationsRequest describeVolumesModificationsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVolumesModificationsRequest, DescribeVolumesModificationsResult> asyncHandler);

    /**
     * <p>
     * Describes the specified attribute of the specified VPC. You can specify only one attribute at a time.
     * </p>
     * 
     * @param describeVpcAttributeRequest
     * @return A Java Future containing the result of the DescribeVpcAttribute operation returned by the service.
     * @sample AmazonEC2Async.DescribeVpcAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcAttribute" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcAttributeResult> describeVpcAttributeAsync(DescribeVpcAttributeRequest describeVpcAttributeRequest);

    /**
     * <p>
     * Describes the specified attribute of the specified VPC. You can specify only one attribute at a time.
     * </p>
     * 
     * @param describeVpcAttributeRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVpcAttribute operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeVpcAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcAttribute" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcAttributeResult> describeVpcAttributeAsync(DescribeVpcAttributeRequest describeVpcAttributeRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVpcAttributeRequest, DescribeVpcAttributeResult> asyncHandler);

    /**
     * <note>
     * <p>
     * This action is deprecated.
     * </p>
     * </note>
     * <p>
     * Describes the ClassicLink status of the specified VPCs.
     * </p>
     * 
     * @param describeVpcClassicLinkRequest
     * @return A Java Future containing the result of the DescribeVpcClassicLink operation returned by the service.
     * @sample AmazonEC2Async.DescribeVpcClassicLink
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcClassicLink" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcClassicLinkResult> describeVpcClassicLinkAsync(DescribeVpcClassicLinkRequest describeVpcClassicLinkRequest);

    /**
     * <note>
     * <p>
     * This action is deprecated.
     * </p>
     * </note>
     * <p>
     * Describes the ClassicLink status of the specified VPCs.
     * </p>
     * 
     * @param describeVpcClassicLinkRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVpcClassicLink operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeVpcClassicLink
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcClassicLink" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcClassicLinkResult> describeVpcClassicLinkAsync(DescribeVpcClassicLinkRequest describeVpcClassicLinkRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVpcClassicLinkRequest, DescribeVpcClassicLinkResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeVpcClassicLink operation.
     *
     * @see #describeVpcClassicLinkAsync(DescribeVpcClassicLinkRequest)
     */
    java.util.concurrent.Future<DescribeVpcClassicLinkResult> describeVpcClassicLinkAsync();

    /**
     * Simplified method form for invoking the DescribeVpcClassicLink operation with an AsyncHandler.
     *
     * @see #describeVpcClassicLinkAsync(DescribeVpcClassicLinkRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeVpcClassicLinkResult> describeVpcClassicLinkAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeVpcClassicLinkRequest, DescribeVpcClassicLinkResult> asyncHandler);

    /**
     * <note>
     * <p>
     * This action is deprecated.
     * </p>
     * </note>
     * <p>
     * Describes the ClassicLink DNS support status of one or more VPCs. If enabled, the DNS hostname of a linked
     * EC2-Classic instance resolves to its private IP address when addressed from an instance in the VPC to which it's
     * linked. Similarly, the DNS hostname of an instance in a VPC resolves to its private IP address when addressed
     * from a linked EC2-Classic instance.
     * </p>
     * 
     * @param describeVpcClassicLinkDnsSupportRequest
     * @return A Java Future containing the result of the DescribeVpcClassicLinkDnsSupport operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeVpcClassicLinkDnsSupport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcClassicLinkDnsSupport"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcClassicLinkDnsSupportResult> describeVpcClassicLinkDnsSupportAsync(
            DescribeVpcClassicLinkDnsSupportRequest describeVpcClassicLinkDnsSupportRequest);

    /**
     * <note>
     * <p>
     * This action is deprecated.
     * </p>
     * </note>
     * <p>
     * Describes the ClassicLink DNS support status of one or more VPCs. If enabled, the DNS hostname of a linked
     * EC2-Classic instance resolves to its private IP address when addressed from an instance in the VPC to which it's
     * linked. Similarly, the DNS hostname of an instance in a VPC resolves to its private IP address when addressed
     * from a linked EC2-Classic instance.
     * </p>
     * 
     * @param describeVpcClassicLinkDnsSupportRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVpcClassicLinkDnsSupport operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeVpcClassicLinkDnsSupport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcClassicLinkDnsSupport"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcClassicLinkDnsSupportResult> describeVpcClassicLinkDnsSupportAsync(
            DescribeVpcClassicLinkDnsSupportRequest describeVpcClassicLinkDnsSupportRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVpcClassicLinkDnsSupportRequest, DescribeVpcClassicLinkDnsSupportResult> asyncHandler);

    /**
     * <p>
     * Describes the connection notifications for VPC endpoints and VPC endpoint services.
     * </p>
     * 
     * @param describeVpcEndpointConnectionNotificationsRequest
     * @return A Java Future containing the result of the DescribeVpcEndpointConnectionNotifications operation returned
     *         by the service.
     * @sample AmazonEC2Async.DescribeVpcEndpointConnectionNotifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointConnectionNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcEndpointConnectionNotificationsResult> describeVpcEndpointConnectionNotificationsAsync(
            DescribeVpcEndpointConnectionNotificationsRequest describeVpcEndpointConnectionNotificationsRequest);

    /**
     * <p>
     * Describes the connection notifications for VPC endpoints and VPC endpoint services.
     * </p>
     * 
     * @param describeVpcEndpointConnectionNotificationsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVpcEndpointConnectionNotifications operation returned
     *         by the service.
     * @sample AmazonEC2AsyncHandler.DescribeVpcEndpointConnectionNotifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointConnectionNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcEndpointConnectionNotificationsResult> describeVpcEndpointConnectionNotificationsAsync(
            DescribeVpcEndpointConnectionNotificationsRequest describeVpcEndpointConnectionNotificationsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVpcEndpointConnectionNotificationsRequest, DescribeVpcEndpointConnectionNotificationsResult> asyncHandler);

    /**
     * <p>
     * Describes the VPC endpoint connections to your VPC endpoint services, including any endpoints that are pending
     * your acceptance.
     * </p>
     * 
     * @param describeVpcEndpointConnectionsRequest
     * @return A Java Future containing the result of the DescribeVpcEndpointConnections operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeVpcEndpointConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointConnections"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcEndpointConnectionsResult> describeVpcEndpointConnectionsAsync(
            DescribeVpcEndpointConnectionsRequest describeVpcEndpointConnectionsRequest);

    /**
     * <p>
     * Describes the VPC endpoint connections to your VPC endpoint services, including any endpoints that are pending
     * your acceptance.
     * </p>
     * 
     * @param describeVpcEndpointConnectionsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVpcEndpointConnections operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeVpcEndpointConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointConnections"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcEndpointConnectionsResult> describeVpcEndpointConnectionsAsync(
            DescribeVpcEndpointConnectionsRequest describeVpcEndpointConnectionsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVpcEndpointConnectionsRequest, DescribeVpcEndpointConnectionsResult> asyncHandler);

    /**
     * <p>
     * Describes the VPC endpoint service configurations in your account (your services).
     * </p>
     * 
     * @param describeVpcEndpointServiceConfigurationsRequest
     * @return A Java Future containing the result of the DescribeVpcEndpointServiceConfigurations operation returned by
     *         the service.
     * @sample AmazonEC2Async.DescribeVpcEndpointServiceConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointServiceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcEndpointServiceConfigurationsResult> describeVpcEndpointServiceConfigurationsAsync(
            DescribeVpcEndpointServiceConfigurationsRequest describeVpcEndpointServiceConfigurationsRequest);

    /**
     * <p>
     * Describes the VPC endpoint service configurations in your account (your services).
     * </p>
     * 
     * @param describeVpcEndpointServiceConfigurationsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVpcEndpointServiceConfigurations operation returned by
     *         the service.
     * @sample AmazonEC2AsyncHandler.DescribeVpcEndpointServiceConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointServiceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcEndpointServiceConfigurationsResult> describeVpcEndpointServiceConfigurationsAsync(
            DescribeVpcEndpointServiceConfigurationsRequest describeVpcEndpointServiceConfigurationsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVpcEndpointServiceConfigurationsRequest, DescribeVpcEndpointServiceConfigurationsResult> asyncHandler);

    /**
     * <p>
     * Describes the principals (service consumers) that are permitted to discover your VPC endpoint service.
     * </p>
     * 
     * @param describeVpcEndpointServicePermissionsRequest
     * @return A Java Future containing the result of the DescribeVpcEndpointServicePermissions operation returned by
     *         the service.
     * @sample AmazonEC2Async.DescribeVpcEndpointServicePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointServicePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcEndpointServicePermissionsResult> describeVpcEndpointServicePermissionsAsync(
            DescribeVpcEndpointServicePermissionsRequest describeVpcEndpointServicePermissionsRequest);

    /**
     * <p>
     * Describes the principals (service consumers) that are permitted to discover your VPC endpoint service.
     * </p>
     * 
     * @param describeVpcEndpointServicePermissionsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVpcEndpointServicePermissions operation returned by
     *         the service.
     * @sample AmazonEC2AsyncHandler.DescribeVpcEndpointServicePermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointServicePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcEndpointServicePermissionsResult> describeVpcEndpointServicePermissionsAsync(
            DescribeVpcEndpointServicePermissionsRequest describeVpcEndpointServicePermissionsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVpcEndpointServicePermissionsRequest, DescribeVpcEndpointServicePermissionsResult> asyncHandler);

    /**
     * <p>
     * Describes available services to which you can create a VPC endpoint.
     * </p>
     * <p>
     * When the service provider and the consumer have different accounts in multiple Availability Zones, and the
     * consumer views the VPC endpoint service information, the response only includes the common Availability Zones.
     * For example, when the service provider account uses <code>us-east-1a</code> and <code>us-east-1c</code> and the
     * consumer uses <code>us-east-1a</code> and <code>us-east-1b</code>, the response includes the VPC endpoint
     * services in the common Availability Zone, <code>us-east-1a</code>.
     * </p>
     * 
     * @param describeVpcEndpointServicesRequest
     * @return A Java Future containing the result of the DescribeVpcEndpointServices operation returned by the service.
     * @sample AmazonEC2Async.DescribeVpcEndpointServices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointServices"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcEndpointServicesResult> describeVpcEndpointServicesAsync(
            DescribeVpcEndpointServicesRequest describeVpcEndpointServicesRequest);

    /**
     * <p>
     * Describes available services to which you can create a VPC endpoint.
     * </p>
     * <p>
     * When the service provider and the consumer have different accounts in multiple Availability Zones, and the
     * consumer views the VPC endpoint service information, the response only includes the common Availability Zones.
     * For example, when the service provider account uses <code>us-east-1a</code> and <code>us-east-1c</code> and the
     * consumer uses <code>us-east-1a</code> and <code>us-east-1b</code>, the response includes the VPC endpoint
     * services in the common Availability Zone, <code>us-east-1a</code>.
     * </p>
     * 
     * @param describeVpcEndpointServicesRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVpcEndpointServices operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeVpcEndpointServices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointServices"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcEndpointServicesResult> describeVpcEndpointServicesAsync(
            DescribeVpcEndpointServicesRequest describeVpcEndpointServicesRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVpcEndpointServicesRequest, DescribeVpcEndpointServicesResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeVpcEndpointServices operation.
     *
     * @see #describeVpcEndpointServicesAsync(DescribeVpcEndpointServicesRequest)
     */
    java.util.concurrent.Future<DescribeVpcEndpointServicesResult> describeVpcEndpointServicesAsync();

    /**
     * Simplified method form for invoking the DescribeVpcEndpointServices operation with an AsyncHandler.
     *
     * @see #describeVpcEndpointServicesAsync(DescribeVpcEndpointServicesRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeVpcEndpointServicesResult> describeVpcEndpointServicesAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeVpcEndpointServicesRequest, DescribeVpcEndpointServicesResult> asyncHandler);

    /**
     * <p>
     * Describes your VPC endpoints.
     * </p>
     * 
     * @param describeVpcEndpointsRequest
     * @return A Java Future containing the result of the DescribeVpcEndpoints operation returned by the service.
     * @sample AmazonEC2Async.DescribeVpcEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcEndpointsResult> describeVpcEndpointsAsync(DescribeVpcEndpointsRequest describeVpcEndpointsRequest);

    /**
     * <p>
     * Describes your VPC endpoints.
     * </p>
     * 
     * @param describeVpcEndpointsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVpcEndpoints operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeVpcEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcEndpointsResult> describeVpcEndpointsAsync(DescribeVpcEndpointsRequest describeVpcEndpointsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVpcEndpointsRequest, DescribeVpcEndpointsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeVpcEndpoints operation.
     *
     * @see #describeVpcEndpointsAsync(DescribeVpcEndpointsRequest)
     */
    java.util.concurrent.Future<DescribeVpcEndpointsResult> describeVpcEndpointsAsync();

    /**
     * Simplified method form for invoking the DescribeVpcEndpoints operation with an AsyncHandler.
     *
     * @see #describeVpcEndpointsAsync(DescribeVpcEndpointsRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeVpcEndpointsResult> describeVpcEndpointsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeVpcEndpointsRequest, DescribeVpcEndpointsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more of your VPC peering connections.
     * </p>
     * 
     * @param describeVpcPeeringConnectionsRequest
     * @return A Java Future containing the result of the DescribeVpcPeeringConnections operation returned by the
     *         service.
     * @sample AmazonEC2Async.DescribeVpcPeeringConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcPeeringConnections"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcPeeringConnectionsResult> describeVpcPeeringConnectionsAsync(
            DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest);

    /**
     * <p>
     * Describes one or more of your VPC peering connections.
     * </p>
     * 
     * @param describeVpcPeeringConnectionsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVpcPeeringConnections operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DescribeVpcPeeringConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcPeeringConnections"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcPeeringConnectionsResult> describeVpcPeeringConnectionsAsync(
            DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVpcPeeringConnectionsRequest, DescribeVpcPeeringConnectionsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeVpcPeeringConnections operation.
     *
     * @see #describeVpcPeeringConnectionsAsync(DescribeVpcPeeringConnectionsRequest)
     */
    java.util.concurrent.Future<DescribeVpcPeeringConnectionsResult> describeVpcPeeringConnectionsAsync();

    /**
     * Simplified method form for invoking the DescribeVpcPeeringConnections operation with an AsyncHandler.
     *
     * @see #describeVpcPeeringConnectionsAsync(DescribeVpcPeeringConnectionsRequest,
     *      com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeVpcPeeringConnectionsResult> describeVpcPeeringConnectionsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeVpcPeeringConnectionsRequest, DescribeVpcPeeringConnectionsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more of your VPCs.
     * </p>
     * 
     * @param describeVpcsRequest
     * @return A Java Future containing the result of the DescribeVpcs operation returned by the service.
     * @sample AmazonEC2Async.DescribeVpcs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcs" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcsResult> describeVpcsAsync(DescribeVpcsRequest describeVpcsRequest);

    /**
     * <p>
     * Describes one or more of your VPCs.
     * </p>
     * 
     * @param describeVpcsRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVpcs operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeVpcs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcs" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpcsResult> describeVpcsAsync(DescribeVpcsRequest describeVpcsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVpcsRequest, DescribeVpcsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeVpcs operation.
     *
     * @see #describeVpcsAsync(DescribeVpcsRequest)
     */
    java.util.concurrent.Future<DescribeVpcsResult> describeVpcsAsync();

    /**
     * Simplified method form for invoking the DescribeVpcs operation with an AsyncHandler.
     *
     * @see #describeVpcsAsync(DescribeVpcsRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeVpcsResult> describeVpcsAsync(com.amazonaws.handlers.AsyncHandler<DescribeVpcsRequest, DescribeVpcsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more of your VPN connections.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * 
     * @param describeVpnConnectionsRequest
     *        Contains the parameters for DescribeVpnConnections.
     * @return A Java Future containing the result of the DescribeVpnConnections operation returned by the service.
     * @sample AmazonEC2Async.DescribeVpnConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpnConnections" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpnConnectionsResult> describeVpnConnectionsAsync(DescribeVpnConnectionsRequest describeVpnConnectionsRequest);

    /**
     * <p>
     * Describes one or more of your VPN connections.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * 
     * @param describeVpnConnectionsRequest
     *        Contains the parameters for DescribeVpnConnections.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVpnConnections operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeVpnConnections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpnConnections" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpnConnectionsResult> describeVpnConnectionsAsync(DescribeVpnConnectionsRequest describeVpnConnectionsRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVpnConnectionsRequest, DescribeVpnConnectionsResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeVpnConnections operation.
     *
     * @see #describeVpnConnectionsAsync(DescribeVpnConnectionsRequest)
     */
    java.util.concurrent.Future<DescribeVpnConnectionsResult> describeVpnConnectionsAsync();

    /**
     * Simplified method form for invoking the DescribeVpnConnections operation with an AsyncHandler.
     *
     * @see #describeVpnConnectionsAsync(DescribeVpnConnectionsRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeVpnConnectionsResult> describeVpnConnectionsAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeVpnConnectionsRequest, DescribeVpnConnectionsResult> asyncHandler);

    /**
     * <p>
     * Describes one or more of your virtual private gateways.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * 
     * @param describeVpnGatewaysRequest
     *        Contains the parameters for DescribeVpnGateways.
     * @return A Java Future containing the result of the DescribeVpnGateways operation returned by the service.
     * @sample AmazonEC2Async.DescribeVpnGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpnGateways" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpnGatewaysResult> describeVpnGatewaysAsync(DescribeVpnGatewaysRequest describeVpnGatewaysRequest);

    /**
     * <p>
     * Describes one or more of your virtual private gateways.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">Amazon Web
     * Services Site-to-Site VPN</a> in the <i>Amazon Web Services Site-to-Site VPN User Guide</i>.
     * </p>
     * 
     * @param describeVpnGatewaysRequest
     *        Contains the parameters for DescribeVpnGateways.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DescribeVpnGateways operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DescribeVpnGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpnGateways" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DescribeVpnGatewaysResult> describeVpnGatewaysAsync(DescribeVpnGatewaysRequest describeVpnGatewaysRequest,
            com.amazonaws.handlers.AsyncHandler<DescribeVpnGatewaysRequest, DescribeVpnGatewaysResult> asyncHandler);

    /**
     * Simplified method form for invoking the DescribeVpnGateways operation.
     *
     * @see #describeVpnGatewaysAsync(DescribeVpnGatewaysRequest)
     */
    java.util.concurrent.Future<DescribeVpnGatewaysResult> describeVpnGatewaysAsync();

    /**
     * Simplified method form for invoking the DescribeVpnGateways operation with an AsyncHandler.
     *
     * @see #describeVpnGatewaysAsync(DescribeVpnGatewaysRequest, com.amazonaws.handlers.AsyncHandler)
     */
    java.util.concurrent.Future<DescribeVpnGatewaysResult> describeVpnGatewaysAsync(
            com.amazonaws.handlers.AsyncHandler<DescribeVpnGatewaysRequest, DescribeVpnGatewaysResult> asyncHandler);

    /**
     * <note>
     * <p>
     * This action is deprecated.
     * </p>
     * </note>
     * <p>
     * Unlinks (detaches) a linked EC2-Classic instance from a VPC. After the instance has been unlinked, the VPC
     * security groups are no longer associated with it. An instance is automatically unlinked from a VPC when it's
     * stopped.
     * </p>
     * 
     * @param detachClassicLinkVpcRequest
     * @return A Java Future containing the result of the DetachClassicLinkVpc operation returned by the service.
     * @sample AmazonEC2Async.DetachClassicLinkVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachClassicLinkVpc" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DetachClassicLinkVpcResult> detachClassicLinkVpcAsync(DetachClassicLinkVpcRequest detachClassicLinkVpcRequest);

    /**
     * <note>
     * <p>
     * This action is deprecated.
     * </p>
     * </note>
     * <p>
     * Unlinks (detaches) a linked EC2-Classic instance from a VPC. After the instance has been unlinked, the VPC
     * security groups are no longer associated with it. An instance is automatically unlinked from a VPC when it's
     * stopped.
     * </p>
     * 
     * @param detachClassicLinkVpcRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DetachClassicLinkVpc operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DetachClassicLinkVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachClassicLinkVpc" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DetachClassicLinkVpcResult> detachClassicLinkVpcAsync(DetachClassicLinkVpcRequest detachClassicLinkVpcRequest,
            com.amazonaws.handlers.AsyncHandler<DetachClassicLinkVpcRequest, DetachClassicLinkVpcResult> asyncHandler);

    /**
     * <p>
     * Detaches an internet gateway from a VPC, disabling connectivity between the internet and the VPC. The VPC must
     * not contain any running instances with Elastic IP addresses or public IPv4 addresses.
     * </p>
     * 
     * @param detachInternetGatewayRequest
     * @return A Java Future containing the result of the DetachInternetGateway operation returned by the service.
     * @sample AmazonEC2Async.DetachInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DetachInternetGatewayResult> detachInternetGatewayAsync(DetachInternetGatewayRequest detachInternetGatewayRequest);

    /**
     * <p>
     * Detaches an internet gateway from a VPC, disabling connectivity between the internet and the VPC. The VPC must
     * not contain any running instances with Elastic IP addresses or public IPv4 addresses.
     * </p>
     * 
     * @param detachInternetGatewayRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DetachInternetGateway operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DetachInternetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachInternetGateway" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DetachInternetGatewayResult> detachInternetGatewayAsync(DetachInternetGatewayRequest detachInternetGatewayRequest,
            com.amazonaws.handlers.AsyncHandler<DetachInternetGatewayRequest, DetachInternetGatewayResult> asyncHandler);

    /**
     * <p>
     * Detaches a network interface from an instance.
     * </p>
     * 
     * @param detachNetworkInterfaceRequest
     *        Contains the parameters for DetachNetworkInterface.
     * @return A Java Future containing the result of the DetachNetworkInterface operation returned by the service.
     * @sample AmazonEC2Async.DetachNetworkInterface
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachNetworkInterface" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DetachNetworkInterfaceResult> detachNetworkInterfaceAsync(DetachNetworkInterfaceRequest detachNetworkInterfaceRequest);

    /**
     * <p>
     * Detaches a network interface from an instance.
     * </p>
     * 
     * @param detachNetworkInterfaceRequest
     *        Contains the parameters for DetachNetworkInterface.
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DetachNetworkInterface operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DetachNetworkInterface
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachNetworkInterface" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DetachNetworkInterfaceResult> detachNetworkInterfaceAsync(DetachNetworkInterfaceRequest detachNetworkInterfaceRequest,
            com.amazonaws.handlers.AsyncHandler<DetachNetworkInterfaceRequest, DetachNetworkInterfaceResult> asyncHandler);

    /**
     * <p>
     * Detaches the specified Amazon Web Services Verified Access trust provider from the specified Amazon Web Services
     * Verified Access instance.
     * </p>
     * 
     * @param detachVerifiedAccessTrustProviderRequest
     * @return A Java Future containing the result of the DetachVerifiedAccessTrustProvider operation returned by the
     *         service.
     * @sample AmazonEC2Async.DetachVerifiedAccessTrustProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachVerifiedAccessTrustProvider"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DetachVerifiedAccessTrustProviderResult> detachVerifiedAccessTrustProviderAsync(
            DetachVerifiedAccessTrustProviderRequest detachVerifiedAccessTrustProviderRequest);

    /**
     * <p>
     * Detaches the specified Amazon Web Services Verified Access trust provider from the specified Amazon Web Services
     * Verified Access instance.
     * </p>
     * 
     * @param detachVerifiedAccessTrustProviderRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DetachVerifiedAccessTrustProvider operation returned by the
     *         service.
     * @sample AmazonEC2AsyncHandler.DetachVerifiedAccessTrustProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachVerifiedAccessTrustProvider"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<DetachVerifiedAccessTrustProviderResult> detachVerifiedAccessTrustProviderAsync(
            DetachVerifiedAccessTrustProviderRequest detachVerifiedAccessTrustProviderRequest,
            com.amazonaws.handlers.AsyncHandler<DetachVerifiedAccessTrustProviderRequest, DetachVerifiedAccessTrustProviderResult> asyncHandler);

    /**
     * <p>
     * Detaches an EBS volume from an instance. Make sure to unmount any file systems on the device within your
     * operating system before detaching the volume. Failure to do so can result in the volume becoming stuck in the
     * <code>busy</code> state while detaching. If this happens, detachment can be delayed indefinitely until you
     * unmount the volume, force detachment, reboot the instance, or all three. If an EBS volume is the root device of
     * an instance, it can't be detached while the instance is running. To detach the root volume, stop the instance
     * first.
     * </p>
     * <p>
     * When a volume with an Amazon Web Services Marketplace product code is detached from an instance, the product code
     * is no longer associated with the instance.
     * </p>
     * <p>
     * You can't detach or force detach volumes that are attached to Amazon ECS or Fargate tasks. Attempting to do this
     * results in the <code>UnsupportedOperationException</code> exception with the
     * <code>Unable to detach volume attached to ECS tasks</code> error message.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-detaching-volume.html">Detach an Amazon EBS volume</a>
     * in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param detachVolumeRequest
     * @return A Java Future containing the result of the DetachVolume operation returned by the service.
     * @sample AmazonEC2Async.DetachVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachVolume" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DetachVolumeResult> detachVolumeAsync(DetachVolumeRequest detachVolumeRequest);

    /**
     * <p>
     * Detaches an EBS volume from an instance. Make sure to unmount any file systems on the device within your
     * operating system before detaching the volume. Failure to do so can result in the volume becoming stuck in the
     * <code>busy</code> state while detaching. If this happens, detachment can be delayed indefinitely until you
     * unmount the volume, force detachment, reboot the instance, or all three. If an EBS volume is the root device of
     * an instance, it can't be detached while the instance is running. To detach the root volume, stop the instance
     * first.
     * </p>
     * <p>
     * When a volume with an Amazon Web Services Marketplace product code is detached from an instance, the product code
     * is no longer associated with the instance.
     * </p>
     * <p>
     * You can't detach or force detach volumes that are attached to Amazon ECS or Fargate tasks. Attempting to do this
     * results in the <code>UnsupportedOperationException</code> exception with the
     * <code>Unable to detach volume attached to ECS tasks</code> error message.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-detaching-volume.html">Detach an Amazon EBS volume</a>
     * in the <i>Amazon EBS User Guide</i>.
     * </p>
     * 
     * @param detachVolumeRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the DetachVolume operation returned by the service.
     * @sample AmazonEC2AsyncHandler.DetachVolume
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachVolume" target="_top">AWS API
     *      Documentation</a>
     */
    java.util.concurrent.Future<DetachVolumeResult> detachVolumeAsync(DetachVolumeRequest detachVolumeRequest,
            com.amazonaws.handlers.AsyncHandler<DetachVolumeRequest, DetachVolumeResult> asyncHandler);

    /**
     * <p>
     * Detaches a virtual private gateway from a VPC. You do this if you're planning to turn off the VPC and not use it
     * anymore. You can confirm a virtual private gateway has been completely detached from a VPC by describing the
     * virtual private gateway (any attachments to the virtual private gateway are also described).
     * </p>
     * <p>
     * You must wait for the attachment's state to switch to <code>detached