/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ClientConnectOptions;
import com.amazonaws.services.ec2.model.ClientLoginBannerOptions;
import com.amazonaws.services.ec2.model.ConnectionLogOptions;
import com.amazonaws.services.ec2.model.DnsServersOptionsModifyStructure;
import com.amazonaws.services.ec2.model.ModifyClientVpnEndpointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyClientVpnEndpointRequestMarshaller
implements Marshaller<Request<ModifyClientVpnEndpointRequest>, ModifyClientVpnEndpointRequest> {
    public Request<ModifyClientVpnEndpointRequest> marshall(ModifyClientVpnEndpointRequest modifyClientVpnEndpointRequest) {
        ClientLoginBannerOptions clientLoginBannerOptions;
        ClientConnectOptions clientConnectOptions;
        SdkInternalList modifyClientVpnEndpointRequestSecurityGroupIdsList;
        DnsServersOptionsModifyStructure dnsServers;
        ConnectionLogOptions connectionLogOptions;
        if (modifyClientVpnEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyClientVpnEndpointRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyClientVpnEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyClientVpnEndpointRequest.getClientVpnEndpointId() != null) {
            request.addParameter("ClientVpnEndpointId", StringUtils.fromString((String)modifyClientVpnEndpointRequest.getClientVpnEndpointId()));
        }
        if (modifyClientVpnEndpointRequest.getServerCertificateArn() != null) {
            request.addParameter("ServerCertificateArn", StringUtils.fromString((String)modifyClientVpnEndpointRequest.getServerCertificateArn()));
        }
        if ((connectionLogOptions = modifyClientVpnEndpointRequest.getConnectionLogOptions()) != null) {
            if (connectionLogOptions.getEnabled() != null) {
                request.addParameter("ConnectionLogOptions.Enabled", StringUtils.fromBoolean((Boolean)connectionLogOptions.getEnabled()));
            }
            if (connectionLogOptions.getCloudwatchLogGroup() != null) {
                request.addParameter("ConnectionLogOptions.CloudwatchLogGroup", StringUtils.fromString((String)connectionLogOptions.getCloudwatchLogGroup()));
            }
            if (connectionLogOptions.getCloudwatchLogStream() != null) {
                request.addParameter("ConnectionLogOptions.CloudwatchLogStream", StringUtils.fromString((String)connectionLogOptions.getCloudwatchLogStream()));
            }
        }
        if ((dnsServers = modifyClientVpnEndpointRequest.getDnsServers()) != null) {
            SdkInternalList dnsServersOptionsModifyStructureCustomDnsServersList = (SdkInternalList)dnsServers.getCustomDnsServers();
            if (!dnsServersOptionsModifyStructureCustomDnsServersList.isEmpty() || !dnsServersOptionsModifyStructureCustomDnsServersList.isAutoConstruct()) {
                int customDnsServersListIndex = 1;
                for (String dnsServersOptionsModifyStructureCustomDnsServersListValue : dnsServersOptionsModifyStructureCustomDnsServersList) {
                    if (dnsServersOptionsModifyStructureCustomDnsServersListValue != null) {
                        request.addParameter("DnsServers.CustomDnsServers." + customDnsServersListIndex, StringUtils.fromString((String)dnsServersOptionsModifyStructureCustomDnsServersListValue));
                    }
                    ++customDnsServersListIndex;
                }
            }
            if (dnsServers.getEnabled() != null) {
                request.addParameter("DnsServers.Enabled", StringUtils.fromBoolean((Boolean)dnsServers.getEnabled()));
            }
        }
        if (modifyClientVpnEndpointRequest.getVpnPort() != null) {
            request.addParameter("VpnPort", StringUtils.fromInteger((Integer)modifyClientVpnEndpointRequest.getVpnPort()));
        }
        if (modifyClientVpnEndpointRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)modifyClientVpnEndpointRequest.getDescription()));
        }
        if (modifyClientVpnEndpointRequest.getSplitTunnel() != null) {
            request.addParameter("SplitTunnel", StringUtils.fromBoolean((Boolean)modifyClientVpnEndpointRequest.getSplitTunnel()));
        }
        if (!(modifyClientVpnEndpointRequestSecurityGroupIdsList = (SdkInternalList)modifyClientVpnEndpointRequest.getSecurityGroupIds()).isEmpty() || !modifyClientVpnEndpointRequestSecurityGroupIdsList.isAutoConstruct()) {
            int securityGroupIdsListIndex = 1;
            for (String modifyClientVpnEndpointRequestSecurityGroupIdsListValue : modifyClientVpnEndpointRequestSecurityGroupIdsList) {
                if (modifyClientVpnEndpointRequestSecurityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)modifyClientVpnEndpointRequestSecurityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (modifyClientVpnEndpointRequest.getVpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)modifyClientVpnEndpointRequest.getVpcId()));
        }
        if (modifyClientVpnEndpointRequest.getSelfServicePortal() != null) {
            request.addParameter("SelfServicePortal", StringUtils.fromString((String)modifyClientVpnEndpointRequest.getSelfServicePortal()));
        }
        if ((clientConnectOptions = modifyClientVpnEndpointRequest.getClientConnectOptions()) != null) {
            if (clientConnectOptions.getEnabled() != null) {
                request.addParameter("ClientConnectOptions.Enabled", StringUtils.fromBoolean((Boolean)clientConnectOptions.getEnabled()));
            }
            if (clientConnectOptions.getLambdaFunctionArn() != null) {
                request.addParameter("ClientConnectOptions.LambdaFunctionArn", StringUtils.fromString((String)clientConnectOptions.getLambdaFunctionArn()));
            }
        }
        if (modifyClientVpnEndpointRequest.getSessionTimeoutHours() != null) {
            request.addParameter("SessionTimeoutHours", StringUtils.fromInteger((Integer)modifyClientVpnEndpointRequest.getSessionTimeoutHours()));
        }
        if ((clientLoginBannerOptions = modifyClientVpnEndpointRequest.getClientLoginBannerOptions()) != null) {
            if (clientLoginBannerOptions.getEnabled() != null) {
                request.addParameter("ClientLoginBannerOptions.Enabled", StringUtils.fromBoolean((Boolean)clientLoginBannerOptions.getEnabled()));
            }
            if (clientLoginBannerOptions.getBannerText() != null) {
                request.addParameter("ClientLoginBannerOptions.BannerText", StringUtils.fromString((String)clientLoginBannerOptions.getBannerText()));
            }
        }
        return request;
    }
}

