/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.CopySnapshotRequestMarshaller;
import java.io.Serializable;

public class CopySnapshotRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CopySnapshotRequest> {
    private String sourceRegion;
    private String sourceSnapshotId;
    private String description;
    private String destinationRegion;
    private String presignedUrl;

    public String getSourceRegion() {
        return this.sourceRegion;
    }

    public void setSourceRegion(String sourceRegion) {
        this.sourceRegion = sourceRegion;
    }

    public CopySnapshotRequest withSourceRegion(String sourceRegion) {
        this.sourceRegion = sourceRegion;
        return this;
    }

    public String getSourceSnapshotId() {
        return this.sourceSnapshotId;
    }

    public void setSourceSnapshotId(String sourceSnapshotId) {
        this.sourceSnapshotId = sourceSnapshotId;
    }

    public CopySnapshotRequest withSourceSnapshotId(String sourceSnapshotId) {
        this.sourceSnapshotId = sourceSnapshotId;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CopySnapshotRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDestinationRegion() {
        return this.destinationRegion;
    }

    public void setDestinationRegion(String destinationRegion) {
        this.destinationRegion = destinationRegion;
    }

    public CopySnapshotRequest withDestinationRegion(String destinationRegion) {
        this.destinationRegion = destinationRegion;
        return this;
    }

    public String getPresignedUrl() {
        return this.presignedUrl;
    }

    public void setPresignedUrl(String presignedUrl) {
        this.presignedUrl = presignedUrl;
    }

    public CopySnapshotRequest withPresignedUrl(String presignedUrl) {
        this.presignedUrl = presignedUrl;
        return this;
    }

    @Override
    public Request<CopySnapshotRequest> getDryRunRequest() {
        Request<CopySnapshotRequest> request = new CopySnapshotRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceRegion() != null) {
            sb.append("SourceRegion: " + this.getSourceRegion() + ",");
        }
        if (this.getSourceSnapshotId() != null) {
            sb.append("SourceSnapshotId: " + this.getSourceSnapshotId() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getDestinationRegion() != null) {
            sb.append("DestinationRegion: " + this.getDestinationRegion() + ",");
        }
        if (this.getPresignedUrl() != null) {
            sb.append("PresignedUrl: " + this.getPresignedUrl());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceRegion() == null ? 0 : this.getSourceRegion().hashCode());
        hashCode = 31 * hashCode + (this.getSourceSnapshotId() == null ? 0 : this.getSourceSnapshotId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationRegion() == null ? 0 : this.getDestinationRegion().hashCode());
        hashCode = 31 * hashCode + (this.getPresignedUrl() == null ? 0 : this.getPresignedUrl().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySnapshotRequest)) {
            return false;
        }
        CopySnapshotRequest other = (CopySnapshotRequest)obj;
        if (other.getSourceRegion() == null ^ this.getSourceRegion() == null) {
            return false;
        }
        if (other.getSourceRegion() != null && !other.getSourceRegion().equals(this.getSourceRegion())) {
            return false;
        }
        if (other.getSourceSnapshotId() == null ^ this.getSourceSnapshotId() == null) {
            return false;
        }
        if (other.getSourceSnapshotId() != null && !other.getSourceSnapshotId().equals(this.getSourceSnapshotId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDestinationRegion() == null ^ this.getDestinationRegion() == null) {
            return false;
        }
        if (other.getDestinationRegion() != null && !other.getDestinationRegion().equals(this.getDestinationRegion())) {
            return false;
        }
        if (other.getPresignedUrl() == null ^ this.getPresignedUrl() == null) {
            return false;
        }
        return other.getPresignedUrl() == null || other.getPresignedUrl().equals(this.getPresignedUrl());
    }

    public CopySnapshotRequest clone() {
        return (CopySnapshotRequest)super.clone();
    }
}

