/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ecr.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The scanning configuration for a private registry.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/RegistryScanningConfiguration" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RegistryScanningConfiguration implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The type of scanning configured for the registry.
     * </p>
     */
    private String scanType;
    /**
     * <p>
     * The scanning rules associated with the registry.
     * </p>
     */
    private java.util.List<RegistryScanningRule> rules;

    /**
     * <p>
     * The type of scanning configured for the registry.
     * </p>
     * 
     * @param scanType
     *        The type of scanning configured for the registry.
     * @see ScanType
     */

    public void setScanType(String scanType) {
        this.scanType = scanType;
    }

    /**
     * <p>
     * The type of scanning configured for the registry.
     * </p>
     * 
     * @return The type of scanning configured for the registry.
     * @see ScanType
     */

    public String getScanType() {
        return this.scanType;
    }

    /**
     * <p>
     * The type of scanning configured for the registry.
     * </p>
     * 
     * @param scanType
     *        The type of scanning configured for the registry.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ScanType
     */

    public RegistryScanningConfiguration withScanType(String scanType) {
        setScanType(scanType);
        return this;
    }

    /**
     * <p>
     * The type of scanning configured for the registry.
     * </p>
     * 
     * @param scanType
     *        The type of scanning configured for the registry.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ScanType
     */

    public RegistryScanningConfiguration withScanType(ScanType scanType) {
        this.scanType = scanType.toString();
        return this;
    }

    /**
     * <p>
     * The scanning rules associated with the registry.
     * </p>
     * 
     * @return The scanning rules associated with the registry.
     */

    public java.util.List<RegistryScanningRule> getRules() {
        return rules;
    }

    /**
     * <p>
     * The scanning rules associated with the registry.
     * </p>
     * 
     * @param rules
     *        The scanning rules associated with the registry.
     */

    public void setRules(java.util.Collection<RegistryScanningRule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }

        this.rules = new java.util.ArrayList<RegistryScanningRule>(rules);
    }

    /**
     * <p>
     * The scanning rules associated with the registry.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setRules(java.util.Collection)} or {@link #withRules(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param rules
     *        The scanning rules associated with the registry.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RegistryScanningConfiguration withRules(RegistryScanningRule... rules) {
        if (this.rules == null) {
            setRules(new java.util.ArrayList<RegistryScanningRule>(rules.length));
        }
        for (RegistryScanningRule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The scanning rules associated with the registry.
     * </p>
     * 
     * @param rules
     *        The scanning rules associated with the registry.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RegistryScanningConfiguration withRules(java.util.Collection<RegistryScanningRule> rules) {
        setRules(rules);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getScanType() != null)
            sb.append("ScanType: ").append(getScanType()).append(",");
        if (getRules() != null)
            sb.append("Rules: ").append(getRules());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RegistryScanningConfiguration == false)
            return false;
        RegistryScanningConfiguration other = (RegistryScanningConfiguration) obj;
        if (other.getScanType() == null ^ this.getScanType() == null)
            return false;
        if (other.getScanType() != null && other.getScanType().equals(this.getScanType()) == false)
            return false;
        if (other.getRules() == null ^ this.getRules() == null)
            return false;
        if (other.getRules() != null && other.getRules().equals(this.getRules()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getScanType() == null) ? 0 : getScanType().hashCode());
        hashCode = prime * hashCode + ((getRules() == null) ? 0 : getRules().hashCode());
        return hashCode;
    }

    @Override
    public RegistryScanningConfiguration clone() {
        try {
            return (RegistryScanningConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.ecr.model.transform.RegistryScanningConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
