/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecrpublic.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecrpublic.model.RegistryAlias;
import com.amazonaws.services.ecrpublic.model.transform.RegistryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Registry
implements Serializable,
Cloneable,
StructuredPojo {
    private String registryId;
    private String registryArn;
    private String registryUri;
    private Boolean verified;
    private List<RegistryAlias> aliases;

    public void setRegistryId(String registryId) {
        this.registryId = registryId;
    }

    public String getRegistryId() {
        return this.registryId;
    }

    public Registry withRegistryId(String registryId) {
        this.setRegistryId(registryId);
        return this;
    }

    public void setRegistryArn(String registryArn) {
        this.registryArn = registryArn;
    }

    public String getRegistryArn() {
        return this.registryArn;
    }

    public Registry withRegistryArn(String registryArn) {
        this.setRegistryArn(registryArn);
        return this;
    }

    public void setRegistryUri(String registryUri) {
        this.registryUri = registryUri;
    }

    public String getRegistryUri() {
        return this.registryUri;
    }

    public Registry withRegistryUri(String registryUri) {
        this.setRegistryUri(registryUri);
        return this;
    }

    public void setVerified(Boolean verified) {
        this.verified = verified;
    }

    public Boolean getVerified() {
        return this.verified;
    }

    public Registry withVerified(Boolean verified) {
        this.setVerified(verified);
        return this;
    }

    public Boolean isVerified() {
        return this.verified;
    }

    public List<RegistryAlias> getAliases() {
        return this.aliases;
    }

    public void setAliases(Collection<RegistryAlias> aliases) {
        if (aliases == null) {
            this.aliases = null;
            return;
        }
        this.aliases = new ArrayList<RegistryAlias>(aliases);
    }

    public Registry withAliases(RegistryAlias ... aliases) {
        if (this.aliases == null) {
            this.setAliases(new ArrayList<RegistryAlias>(aliases.length));
        }
        for (RegistryAlias ele : aliases) {
            this.aliases.add(ele);
        }
        return this;
    }

    public Registry withAliases(Collection<RegistryAlias> aliases) {
        this.setAliases(aliases);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRegistryId() != null) {
            sb.append("RegistryId: ").append(this.getRegistryId()).append(",");
        }
        if (this.getRegistryArn() != null) {
            sb.append("RegistryArn: ").append(this.getRegistryArn()).append(",");
        }
        if (this.getRegistryUri() != null) {
            sb.append("RegistryUri: ").append(this.getRegistryUri()).append(",");
        }
        if (this.getVerified() != null) {
            sb.append("Verified: ").append(this.getVerified()).append(",");
        }
        if (this.getAliases() != null) {
            sb.append("Aliases: ").append(this.getAliases());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Registry)) {
            return false;
        }
        Registry other = (Registry)obj;
        if (other.getRegistryId() == null ^ this.getRegistryId() == null) {
            return false;
        }
        if (other.getRegistryId() != null && !other.getRegistryId().equals(this.getRegistryId())) {
            return false;
        }
        if (other.getRegistryArn() == null ^ this.getRegistryArn() == null) {
            return false;
        }
        if (other.getRegistryArn() != null && !other.getRegistryArn().equals(this.getRegistryArn())) {
            return false;
        }
        if (other.getRegistryUri() == null ^ this.getRegistryUri() == null) {
            return false;
        }
        if (other.getRegistryUri() != null && !other.getRegistryUri().equals(this.getRegistryUri())) {
            return false;
        }
        if (other.getVerified() == null ^ this.getVerified() == null) {
            return false;
        }
        if (other.getVerified() != null && !other.getVerified().equals(this.getVerified())) {
            return false;
        }
        if (other.getAliases() == null ^ this.getAliases() == null) {
            return false;
        }
        return other.getAliases() == null || other.getAliases().equals(this.getAliases());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRegistryId() == null ? 0 : this.getRegistryId().hashCode());
        hashCode = 31 * hashCode + (this.getRegistryArn() == null ? 0 : this.getRegistryArn().hashCode());
        hashCode = 31 * hashCode + (this.getRegistryUri() == null ? 0 : this.getRegistryUri().hashCode());
        hashCode = 31 * hashCode + (this.getVerified() == null ? 0 : this.getVerified().hashCode());
        hashCode = 31 * hashCode + (this.getAliases() == null ? 0 : this.getAliases().hashCode());
        return hashCode;
    }

    public Registry clone() {
        try {
            return (Registry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RegistryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

