/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecrpublic.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecrpublic.model.transform.RepositoryCatalogDataInputMarshaller;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RepositoryCatalogDataInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String description;
    private List<String> architectures;
    private List<String> operatingSystems;
    private ByteBuffer logoImageBlob;
    private String aboutText;
    private String usageText;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public RepositoryCatalogDataInput withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getArchitectures() {
        return this.architectures;
    }

    public void setArchitectures(Collection<String> architectures) {
        if (architectures == null) {
            this.architectures = null;
            return;
        }
        this.architectures = new ArrayList<String>(architectures);
    }

    public RepositoryCatalogDataInput withArchitectures(String ... architectures) {
        if (this.architectures == null) {
            this.setArchitectures(new ArrayList<String>(architectures.length));
        }
        for (String ele : architectures) {
            this.architectures.add(ele);
        }
        return this;
    }

    public RepositoryCatalogDataInput withArchitectures(Collection<String> architectures) {
        this.setArchitectures(architectures);
        return this;
    }

    public List<String> getOperatingSystems() {
        return this.operatingSystems;
    }

    public void setOperatingSystems(Collection<String> operatingSystems) {
        if (operatingSystems == null) {
            this.operatingSystems = null;
            return;
        }
        this.operatingSystems = new ArrayList<String>(operatingSystems);
    }

    public RepositoryCatalogDataInput withOperatingSystems(String ... operatingSystems) {
        if (this.operatingSystems == null) {
            this.setOperatingSystems(new ArrayList<String>(operatingSystems.length));
        }
        for (String ele : operatingSystems) {
            this.operatingSystems.add(ele);
        }
        return this;
    }

    public RepositoryCatalogDataInput withOperatingSystems(Collection<String> operatingSystems) {
        this.setOperatingSystems(operatingSystems);
        return this;
    }

    public void setLogoImageBlob(ByteBuffer logoImageBlob) {
        this.logoImageBlob = logoImageBlob;
    }

    public ByteBuffer getLogoImageBlob() {
        return this.logoImageBlob;
    }

    public RepositoryCatalogDataInput withLogoImageBlob(ByteBuffer logoImageBlob) {
        this.setLogoImageBlob(logoImageBlob);
        return this;
    }

    public void setAboutText(String aboutText) {
        this.aboutText = aboutText;
    }

    public String getAboutText() {
        return this.aboutText;
    }

    public RepositoryCatalogDataInput withAboutText(String aboutText) {
        this.setAboutText(aboutText);
        return this;
    }

    public void setUsageText(String usageText) {
        this.usageText = usageText;
    }

    public String getUsageText() {
        return this.usageText;
    }

    public RepositoryCatalogDataInput withUsageText(String usageText) {
        this.setUsageText(usageText);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getArchitectures() != null) {
            sb.append("Architectures: ").append(this.getArchitectures()).append(",");
        }
        if (this.getOperatingSystems() != null) {
            sb.append("OperatingSystems: ").append(this.getOperatingSystems()).append(",");
        }
        if (this.getLogoImageBlob() != null) {
            sb.append("LogoImageBlob: ").append(this.getLogoImageBlob()).append(",");
        }
        if (this.getAboutText() != null) {
            sb.append("AboutText: ").append(this.getAboutText()).append(",");
        }
        if (this.getUsageText() != null) {
            sb.append("UsageText: ").append(this.getUsageText());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryCatalogDataInput)) {
            return false;
        }
        RepositoryCatalogDataInput other = (RepositoryCatalogDataInput)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getArchitectures() == null ^ this.getArchitectures() == null) {
            return false;
        }
        if (other.getArchitectures() != null && !other.getArchitectures().equals(this.getArchitectures())) {
            return false;
        }
        if (other.getOperatingSystems() == null ^ this.getOperatingSystems() == null) {
            return false;
        }
        if (other.getOperatingSystems() != null && !other.getOperatingSystems().equals(this.getOperatingSystems())) {
            return false;
        }
        if (other.getLogoImageBlob() == null ^ this.getLogoImageBlob() == null) {
            return false;
        }
        if (other.getLogoImageBlob() != null && !other.getLogoImageBlob().equals(this.getLogoImageBlob())) {
            return false;
        }
        if (other.getAboutText() == null ^ this.getAboutText() == null) {
            return false;
        }
        if (other.getAboutText() != null && !other.getAboutText().equals(this.getAboutText())) {
            return false;
        }
        if (other.getUsageText() == null ^ this.getUsageText() == null) {
            return false;
        }
        return other.getUsageText() == null || other.getUsageText().equals(this.getUsageText());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getArchitectures() == null ? 0 : this.getArchitectures().hashCode());
        hashCode = 31 * hashCode + (this.getOperatingSystems() == null ? 0 : this.getOperatingSystems().hashCode());
        hashCode = 31 * hashCode + (this.getLogoImageBlob() == null ? 0 : this.getLogoImageBlob().hashCode());
        hashCode = 31 * hashCode + (this.getAboutText() == null ? 0 : this.getAboutText().hashCode());
        hashCode = 31 * hashCode + (this.getUsageText() == null ? 0 : this.getUsageText().hashCode());
        return hashCode;
    }

    public RepositoryCatalogDataInput clone() {
        try {
            return (RepositoryCatalogDataInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RepositoryCatalogDataInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

