/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.DescribeTasksRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeTasksRequestMarshaller
implements Marshaller<Request<DescribeTasksRequest>, DescribeTasksRequest> {
    public Request<DescribeTasksRequest> marshall(DescribeTasksRequest describeTasksRequest) {
        if (describeTasksRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeTasksRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.DescribeTasks");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList tasksList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (describeTasksRequest.getCluster() != null) {
                jsonGenerator.writeFieldName("cluster").writeValue(describeTasksRequest.getCluster());
            }
            if (!(tasksList = (SdkInternalList)describeTasksRequest.getTasks()).isEmpty() || !tasksList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("tasks");
                jsonGenerator.writeStartArray();
                for (String tasksListValue : tasksList) {
                    if (tasksListValue == null) continue;
                    jsonGenerator.writeValue(tasksListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

