/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.ContainerInstance;
import com.amazonaws.services.ecs.model.Failure;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeContainerInstancesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<ContainerInstance> containerInstances;
    private SdkInternalList<Failure> failures;

    public List<ContainerInstance> getContainerInstances() {
        if (this.containerInstances == null) {
            this.containerInstances = new SdkInternalList();
        }
        return this.containerInstances;
    }

    public void setContainerInstances(Collection<ContainerInstance> containerInstances) {
        if (containerInstances == null) {
            this.containerInstances = null;
            return;
        }
        this.containerInstances = new SdkInternalList(containerInstances);
    }

    public DescribeContainerInstancesResult withContainerInstances(ContainerInstance ... containerInstances) {
        if (this.containerInstances == null) {
            this.setContainerInstances((Collection<ContainerInstance>)new SdkInternalList(containerInstances.length));
        }
        for (ContainerInstance ele : containerInstances) {
            this.containerInstances.add((Object)ele);
        }
        return this;
    }

    public DescribeContainerInstancesResult withContainerInstances(Collection<ContainerInstance> containerInstances) {
        this.setContainerInstances(containerInstances);
        return this;
    }

    public List<Failure> getFailures() {
        if (this.failures == null) {
            this.failures = new SdkInternalList();
        }
        return this.failures;
    }

    public void setFailures(Collection<Failure> failures) {
        if (failures == null) {
            this.failures = null;
            return;
        }
        this.failures = new SdkInternalList(failures);
    }

    public DescribeContainerInstancesResult withFailures(Failure ... failures) {
        if (this.failures == null) {
            this.setFailures((Collection<Failure>)new SdkInternalList(failures.length));
        }
        for (Failure ele : failures) {
            this.failures.add((Object)ele);
        }
        return this;
    }

    public DescribeContainerInstancesResult withFailures(Collection<Failure> failures) {
        this.setFailures(failures);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerInstances() != null) {
            sb.append("ContainerInstances: ").append(this.getContainerInstances()).append(",");
        }
        if (this.getFailures() != null) {
            sb.append("Failures: ").append(this.getFailures());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContainerInstancesResult)) {
            return false;
        }
        DescribeContainerInstancesResult other = (DescribeContainerInstancesResult)obj;
        if (other.getContainerInstances() == null ^ this.getContainerInstances() == null) {
            return false;
        }
        if (other.getContainerInstances() != null && !other.getContainerInstances().equals(this.getContainerInstances())) {
            return false;
        }
        if (other.getFailures() == null ^ this.getFailures() == null) {
            return false;
        }
        return other.getFailures() == null || other.getFailures().equals(this.getFailures());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerInstances() == null ? 0 : this.getContainerInstances().hashCode());
        hashCode = 31 * hashCode + (this.getFailures() == null ? 0 : this.getFailures().hashCode());
        return hashCode;
    }

    public DescribeContainerInstancesResult clone() {
        try {
            return (DescribeContainerInstancesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

