/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.ClusterField;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeClustersRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalList<String> clusters;
    private SdkInternalList<String> include;

    public List<String> getClusters() {
        if (this.clusters == null) {
            this.clusters = new SdkInternalList();
        }
        return this.clusters;
    }

    public void setClusters(Collection<String> clusters) {
        if (clusters == null) {
            this.clusters = null;
            return;
        }
        this.clusters = new SdkInternalList(clusters);
    }

    public DescribeClustersRequest withClusters(String ... clusters) {
        if (this.clusters == null) {
            this.setClusters((Collection<String>)new SdkInternalList(clusters.length));
        }
        for (String ele : clusters) {
            this.clusters.add((Object)ele);
        }
        return this;
    }

    public DescribeClustersRequest withClusters(Collection<String> clusters) {
        this.setClusters(clusters);
        return this;
    }

    public List<String> getInclude() {
        if (this.include == null) {
            this.include = new SdkInternalList();
        }
        return this.include;
    }

    public void setInclude(Collection<String> include) {
        if (include == null) {
            this.include = null;
            return;
        }
        this.include = new SdkInternalList(include);
    }

    public DescribeClustersRequest withInclude(String ... include) {
        if (this.include == null) {
            this.setInclude((Collection<String>)new SdkInternalList(include.length));
        }
        for (String ele : include) {
            this.include.add((Object)ele);
        }
        return this;
    }

    public DescribeClustersRequest withInclude(Collection<String> include) {
        this.setInclude(include);
        return this;
    }

    public DescribeClustersRequest withInclude(ClusterField ... include) {
        SdkInternalList includeCopy = new SdkInternalList(include.length);
        for (ClusterField value : include) {
            includeCopy.add((Object)value.toString());
        }
        if (this.getInclude() == null) {
            this.setInclude((Collection<String>)includeCopy);
        } else {
            this.getInclude().addAll((Collection<String>)includeCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusters() != null) {
            sb.append("Clusters: ").append(this.getClusters()).append(",");
        }
        if (this.getInclude() != null) {
            sb.append("Include: ").append(this.getInclude());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClustersRequest)) {
            return false;
        }
        DescribeClustersRequest other = (DescribeClustersRequest)obj;
        if (other.getClusters() == null ^ this.getClusters() == null) {
            return false;
        }
        if (other.getClusters() != null && !other.getClusters().equals(this.getClusters())) {
            return false;
        }
        if (other.getInclude() == null ^ this.getInclude() == null) {
            return false;
        }
        return other.getInclude() == null || other.getInclude().equals(this.getInclude());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusters() == null ? 0 : this.getClusters().hashCode());
        hashCode = 31 * hashCode + (this.getInclude() == null ? 0 : this.getInclude().hashCode());
        return hashCode;
    }

    public DescribeClustersRequest clone() {
        return (DescribeClustersRequest)super.clone();
    }
}

