/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.VersionInfo;

public class VersionInfoJsonMarshaller {
    private static VersionInfoJsonMarshaller instance;

    public void marshall(VersionInfo versionInfo, StructuredJsonGenerator jsonGenerator) {
        if (versionInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (versionInfo.getAgentVersion() != null) {
                jsonGenerator.writeFieldName("agentVersion").writeValue(versionInfo.getAgentVersion());
            }
            if (versionInfo.getAgentHash() != null) {
                jsonGenerator.writeFieldName("agentHash").writeValue(versionInfo.getAgentHash());
            }
            if (versionInfo.getDockerVersion() != null) {
                jsonGenerator.writeFieldName("dockerVersion").writeValue(versionInfo.getDockerVersion());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static VersionInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new VersionInfoJsonMarshaller();
        }
        return instance;
    }
}

