/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.ContainerInstanceField;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeContainerInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private SdkInternalList<String> containerInstances;
    private SdkInternalList<String> include;

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public DescribeContainerInstancesRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public List<String> getContainerInstances() {
        if (this.containerInstances == null) {
            this.containerInstances = new SdkInternalList();
        }
        return this.containerInstances;
    }

    public void setContainerInstances(Collection<String> containerInstances) {
        if (containerInstances == null) {
            this.containerInstances = null;
            return;
        }
        this.containerInstances = new SdkInternalList(containerInstances);
    }

    public DescribeContainerInstancesRequest withContainerInstances(String ... containerInstances) {
        if (this.containerInstances == null) {
            this.setContainerInstances((Collection<String>)new SdkInternalList(containerInstances.length));
        }
        for (String ele : containerInstances) {
            this.containerInstances.add((Object)ele);
        }
        return this;
    }

    public DescribeContainerInstancesRequest withContainerInstances(Collection<String> containerInstances) {
        this.setContainerInstances(containerInstances);
        return this;
    }

    public List<String> getInclude() {
        if (this.include == null) {
            this.include = new SdkInternalList();
        }
        return this.include;
    }

    public void setInclude(Collection<String> include) {
        if (include == null) {
            this.include = null;
            return;
        }
        this.include = new SdkInternalList(include);
    }

    public DescribeContainerInstancesRequest withInclude(String ... include) {
        if (this.include == null) {
            this.setInclude((Collection<String>)new SdkInternalList(include.length));
        }
        for (String ele : include) {
            this.include.add((Object)ele);
        }
        return this;
    }

    public DescribeContainerInstancesRequest withInclude(Collection<String> include) {
        this.setInclude(include);
        return this;
    }

    public DescribeContainerInstancesRequest withInclude(ContainerInstanceField ... include) {
        SdkInternalList includeCopy = new SdkInternalList(include.length);
        for (ContainerInstanceField value : include) {
            includeCopy.add((Object)value.toString());
        }
        if (this.getInclude() == null) {
            this.setInclude((Collection<String>)includeCopy);
        } else {
            this.getInclude().addAll((Collection<String>)includeCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: ").append(this.getCluster()).append(",");
        }
        if (this.getContainerInstances() != null) {
            sb.append("ContainerInstances: ").append(this.getContainerInstances()).append(",");
        }
        if (this.getInclude() != null) {
            sb.append("Include: ").append(this.getInclude());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContainerInstancesRequest)) {
            return false;
        }
        DescribeContainerInstancesRequest other = (DescribeContainerInstancesRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getContainerInstances() == null ^ this.getContainerInstances() == null) {
            return false;
        }
        if (other.getContainerInstances() != null && !other.getContainerInstances().equals(this.getContainerInstances())) {
            return false;
        }
        if (other.getInclude() == null ^ this.getInclude() == null) {
            return false;
        }
        return other.getInclude() == null || other.getInclude().equals(this.getInclude());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getContainerInstances() == null ? 0 : this.getContainerInstances().hashCode());
        hashCode = 31 * hashCode + (this.getInclude() == null ? 0 : this.getInclude().hashCode());
        return hashCode;
    }

    public DescribeContainerInstancesRequest clone() {
        return (DescribeContainerInstancesRequest)super.clone();
    }
}

