/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.ClusterConfiguration;
import com.amazonaws.services.ecs.model.ClusterServiceConnectDefaultsRequest;
import com.amazonaws.services.ecs.model.ClusterSetting;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpdateClusterRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private SdkInternalList<ClusterSetting> settings;
    private ClusterConfiguration configuration;
    private ClusterServiceConnectDefaultsRequest serviceConnectDefaults;

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public UpdateClusterRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public List<ClusterSetting> getSettings() {
        if (this.settings == null) {
            this.settings = new SdkInternalList();
        }
        return this.settings;
    }

    public void setSettings(Collection<ClusterSetting> settings) {
        if (settings == null) {
            this.settings = null;
            return;
        }
        this.settings = new SdkInternalList(settings);
    }

    public UpdateClusterRequest withSettings(ClusterSetting ... settings) {
        if (this.settings == null) {
            this.setSettings((Collection<ClusterSetting>)new SdkInternalList(settings.length));
        }
        for (ClusterSetting ele : settings) {
            this.settings.add((Object)ele);
        }
        return this;
    }

    public UpdateClusterRequest withSettings(Collection<ClusterSetting> settings) {
        this.setSettings(settings);
        return this;
    }

    public void setConfiguration(ClusterConfiguration configuration) {
        this.configuration = configuration;
    }

    public ClusterConfiguration getConfiguration() {
        return this.configuration;
    }

    public UpdateClusterRequest withConfiguration(ClusterConfiguration configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public void setServiceConnectDefaults(ClusterServiceConnectDefaultsRequest serviceConnectDefaults) {
        this.serviceConnectDefaults = serviceConnectDefaults;
    }

    public ClusterServiceConnectDefaultsRequest getServiceConnectDefaults() {
        return this.serviceConnectDefaults;
    }

    public UpdateClusterRequest withServiceConnectDefaults(ClusterServiceConnectDefaultsRequest serviceConnectDefaults) {
        this.setServiceConnectDefaults(serviceConnectDefaults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: ").append(this.getCluster()).append(",");
        }
        if (this.getSettings() != null) {
            sb.append("Settings: ").append(this.getSettings()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getServiceConnectDefaults() != null) {
            sb.append("ServiceConnectDefaults: ").append(this.getServiceConnectDefaults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterRequest)) {
            return false;
        }
        UpdateClusterRequest other = (UpdateClusterRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getSettings() == null ^ this.getSettings() == null) {
            return false;
        }
        if (other.getSettings() != null && !other.getSettings().equals(this.getSettings())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getServiceConnectDefaults() == null ^ this.getServiceConnectDefaults() == null) {
            return false;
        }
        return other.getServiceConnectDefaults() == null || other.getServiceConnectDefaults().equals(this.getServiceConnectDefaults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getSettings() == null ? 0 : this.getSettings().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getServiceConnectDefaults() == null ? 0 : this.getServiceConnectDefaults().hashCode());
        return hashCode;
    }

    public UpdateClusterRequest clone() {
        return (UpdateClusterRequest)super.clone();
    }
}

