/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.elasticfilesystem.AmazonElasticFileSystemAsync;
import com.amazonaws.services.elasticfilesystem.AmazonElasticFileSystemAsyncClientBuilder;
import com.amazonaws.services.elasticfilesystem.AmazonElasticFileSystemClient;
import com.amazonaws.services.elasticfilesystem.model.CreateFileSystemRequest;
import com.amazonaws.services.elasticfilesystem.model.CreateFileSystemResult;
import com.amazonaws.services.elasticfilesystem.model.CreateMountTargetRequest;
import com.amazonaws.services.elasticfilesystem.model.CreateMountTargetResult;
import com.amazonaws.services.elasticfilesystem.model.CreateTagsRequest;
import com.amazonaws.services.elasticfilesystem.model.CreateTagsResult;
import com.amazonaws.services.elasticfilesystem.model.DeleteFileSystemRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteFileSystemResult;
import com.amazonaws.services.elasticfilesystem.model.DeleteMountTargetRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteMountTargetResult;
import com.amazonaws.services.elasticfilesystem.model.DeleteTagsRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteTagsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeFileSystemsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeFileSystemsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeLifecycleConfigurationRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeLifecycleConfigurationResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetSecurityGroupsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetSecurityGroupsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeTagsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeTagsResult;
import com.amazonaws.services.elasticfilesystem.model.ModifyMountTargetSecurityGroupsRequest;
import com.amazonaws.services.elasticfilesystem.model.ModifyMountTargetSecurityGroupsResult;
import com.amazonaws.services.elasticfilesystem.model.PutLifecycleConfigurationRequest;
import com.amazonaws.services.elasticfilesystem.model.PutLifecycleConfigurationResult;
import com.amazonaws.services.elasticfilesystem.model.UpdateFileSystemRequest;
import com.amazonaws.services.elasticfilesystem.model.UpdateFileSystemResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonElasticFileSystemAsyncClient
extends AmazonElasticFileSystemClient
implements AmazonElasticFileSystemAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonElasticFileSystemAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonElasticFileSystemAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonElasticFileSystemAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonElasticFileSystemAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonElasticFileSystemAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonElasticFileSystemAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonElasticFileSystemAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonElasticFileSystemAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonElasticFileSystemAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonElasticFileSystemAsyncClientBuilder asyncBuilder() {
        return AmazonElasticFileSystemAsyncClientBuilder.standard();
    }

    AmazonElasticFileSystemAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateFileSystemResult> createFileSystemAsync(CreateFileSystemRequest request) {
        return this.createFileSystemAsync(request, null);
    }

    @Override
    public Future<CreateFileSystemResult> createFileSystemAsync(CreateFileSystemRequest request, final AsyncHandler<CreateFileSystemRequest, CreateFileSystemResult> asyncHandler) {
        final CreateFileSystemRequest finalRequest = (CreateFileSystemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFileSystemResult>(){

            @Override
            public CreateFileSystemResult call() throws Exception {
                CreateFileSystemResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeCreateFileSystem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateMountTargetResult> createMountTargetAsync(CreateMountTargetRequest request) {
        return this.createMountTargetAsync(request, null);
    }

    @Override
    public Future<CreateMountTargetResult> createMountTargetAsync(CreateMountTargetRequest request, final AsyncHandler<CreateMountTargetRequest, CreateMountTargetResult> asyncHandler) {
        final CreateMountTargetRequest finalRequest = (CreateMountTargetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMountTargetResult>(){

            @Override
            public CreateMountTargetResult call() throws Exception {
                CreateMountTargetResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeCreateMountTarget(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTagsResult> createTagsAsync(CreateTagsRequest request) {
        return this.createTagsAsync(request, null);
    }

    @Override
    public Future<CreateTagsResult> createTagsAsync(CreateTagsRequest request, final AsyncHandler<CreateTagsRequest, CreateTagsResult> asyncHandler) {
        final CreateTagsRequest finalRequest = (CreateTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTagsResult>(){

            @Override
            public CreateTagsResult call() throws Exception {
                CreateTagsResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeCreateTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFileSystemResult> deleteFileSystemAsync(DeleteFileSystemRequest request) {
        return this.deleteFileSystemAsync(request, null);
    }

    @Override
    public Future<DeleteFileSystemResult> deleteFileSystemAsync(DeleteFileSystemRequest request, final AsyncHandler<DeleteFileSystemRequest, DeleteFileSystemResult> asyncHandler) {
        final DeleteFileSystemRequest finalRequest = (DeleteFileSystemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFileSystemResult>(){

            @Override
            public DeleteFileSystemResult call() throws Exception {
                DeleteFileSystemResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDeleteFileSystem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMountTargetResult> deleteMountTargetAsync(DeleteMountTargetRequest request) {
        return this.deleteMountTargetAsync(request, null);
    }

    @Override
    public Future<DeleteMountTargetResult> deleteMountTargetAsync(DeleteMountTargetRequest request, final AsyncHandler<DeleteMountTargetRequest, DeleteMountTargetResult> asyncHandler) {
        final DeleteMountTargetRequest finalRequest = (DeleteMountTargetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMountTargetResult>(){

            @Override
            public DeleteMountTargetResult call() throws Exception {
                DeleteMountTargetResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDeleteMountTarget(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request) {
        return this.deleteTagsAsync(request, null);
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request, final AsyncHandler<DeleteTagsRequest, DeleteTagsResult> asyncHandler) {
        final DeleteTagsRequest finalRequest = (DeleteTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTagsResult>(){

            @Override
            public DeleteTagsResult call() throws Exception {
                DeleteTagsResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDeleteTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFileSystemsResult> describeFileSystemsAsync(DescribeFileSystemsRequest request) {
        return this.describeFileSystemsAsync(request, null);
    }

    @Override
    public Future<DescribeFileSystemsResult> describeFileSystemsAsync(DescribeFileSystemsRequest request, final AsyncHandler<DescribeFileSystemsRequest, DescribeFileSystemsResult> asyncHandler) {
        final DescribeFileSystemsRequest finalRequest = (DescribeFileSystemsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFileSystemsResult>(){

            @Override
            public DescribeFileSystemsResult call() throws Exception {
                DescribeFileSystemsResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDescribeFileSystems(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFileSystemsResult> describeFileSystemsAsync() {
        return this.describeFileSystemsAsync(new DescribeFileSystemsRequest());
    }

    @Override
    public Future<DescribeFileSystemsResult> describeFileSystemsAsync(AsyncHandler<DescribeFileSystemsRequest, DescribeFileSystemsResult> asyncHandler) {
        return this.describeFileSystemsAsync(new DescribeFileSystemsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeLifecycleConfigurationResult> describeLifecycleConfigurationAsync(DescribeLifecycleConfigurationRequest request) {
        return this.describeLifecycleConfigurationAsync(request, null);
    }

    @Override
    public Future<DescribeLifecycleConfigurationResult> describeLifecycleConfigurationAsync(DescribeLifecycleConfigurationRequest request, final AsyncHandler<DescribeLifecycleConfigurationRequest, DescribeLifecycleConfigurationResult> asyncHandler) {
        final DescribeLifecycleConfigurationRequest finalRequest = (DescribeLifecycleConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeLifecycleConfigurationResult>(){

            @Override
            public DescribeLifecycleConfigurationResult call() throws Exception {
                DescribeLifecycleConfigurationResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDescribeLifecycleConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeMountTargetSecurityGroupsResult> describeMountTargetSecurityGroupsAsync(DescribeMountTargetSecurityGroupsRequest request) {
        return this.describeMountTargetSecurityGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeMountTargetSecurityGroupsResult> describeMountTargetSecurityGroupsAsync(DescribeMountTargetSecurityGroupsRequest request, final AsyncHandler<DescribeMountTargetSecurityGroupsRequest, DescribeMountTargetSecurityGroupsResult> asyncHandler) {
        final DescribeMountTargetSecurityGroupsRequest finalRequest = (DescribeMountTargetSecurityGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeMountTargetSecurityGroupsResult>(){

            @Override
            public DescribeMountTargetSecurityGroupsResult call() throws Exception {
                DescribeMountTargetSecurityGroupsResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDescribeMountTargetSecurityGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeMountTargetsResult> describeMountTargetsAsync(DescribeMountTargetsRequest request) {
        return this.describeMountTargetsAsync(request, null);
    }

    @Override
    public Future<DescribeMountTargetsResult> describeMountTargetsAsync(DescribeMountTargetsRequest request, final AsyncHandler<DescribeMountTargetsRequest, DescribeMountTargetsResult> asyncHandler) {
        final DescribeMountTargetsRequest finalRequest = (DescribeMountTargetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeMountTargetsResult>(){

            @Override
            public DescribeMountTargetsResult call() throws Exception {
                DescribeMountTargetsResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDescribeMountTargets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(DescribeTagsRequest request) {
        return this.describeTagsAsync(request, null);
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(DescribeTagsRequest request, final AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler) {
        final DescribeTagsRequest finalRequest = (DescribeTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                DescribeTagsResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeDescribeTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ModifyMountTargetSecurityGroupsResult> modifyMountTargetSecurityGroupsAsync(ModifyMountTargetSecurityGroupsRequest request) {
        return this.modifyMountTargetSecurityGroupsAsync(request, null);
    }

    @Override
    public Future<ModifyMountTargetSecurityGroupsResult> modifyMountTargetSecurityGroupsAsync(ModifyMountTargetSecurityGroupsRequest request, final AsyncHandler<ModifyMountTargetSecurityGroupsRequest, ModifyMountTargetSecurityGroupsResult> asyncHandler) {
        final ModifyMountTargetSecurityGroupsRequest finalRequest = (ModifyMountTargetSecurityGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ModifyMountTargetSecurityGroupsResult>(){

            @Override
            public ModifyMountTargetSecurityGroupsResult call() throws Exception {
                ModifyMountTargetSecurityGroupsResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeModifyMountTargetSecurityGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutLifecycleConfigurationResult> putLifecycleConfigurationAsync(PutLifecycleConfigurationRequest request) {
        return this.putLifecycleConfigurationAsync(request, null);
    }

    @Override
    public Future<PutLifecycleConfigurationResult> putLifecycleConfigurationAsync(PutLifecycleConfigurationRequest request, final AsyncHandler<PutLifecycleConfigurationRequest, PutLifecycleConfigurationResult> asyncHandler) {
        final PutLifecycleConfigurationRequest finalRequest = (PutLifecycleConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutLifecycleConfigurationResult>(){

            @Override
            public PutLifecycleConfigurationResult call() throws Exception {
                PutLifecycleConfigurationResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executePutLifecycleConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFileSystemResult> updateFileSystemAsync(UpdateFileSystemRequest request) {
        return this.updateFileSystemAsync(request, null);
    }

    @Override
    public Future<UpdateFileSystemResult> updateFileSystemAsync(UpdateFileSystemRequest request, final AsyncHandler<UpdateFileSystemRequest, UpdateFileSystemResult> asyncHandler) {
        final UpdateFileSystemRequest finalRequest = (UpdateFileSystemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFileSystemResult>(){

            @Override
            public UpdateFileSystemResult call() throws Exception {
                UpdateFileSystemResult result = null;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.executeUpdateFileSystem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

