/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.eks.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListAccessPolicies" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListAccessPoliciesResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The list of available access policies. You can't view the contents of an access policy using the API. To view the
     * contents, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions">Access
     * policy permissions</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     */
    private java.util.List<AccessPolicy> accessPolicies;
    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was
     * used and the results exceeded the value of that parameter. Pagination continues from the end of the previous
     * results that returned the <code>nextToken</code> value. This value is null when there are no more results to
     * return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     */
    private String nextToken;

    /**
     * <p>
     * The list of available access policies. You can't view the contents of an access policy using the API. To view the
     * contents, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions">Access
     * policy permissions</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     * 
     * @return The list of available access policies. You can't view the contents of an access policy using the API. To
     *         view the contents, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions"
     *         >Access policy permissions</a> in the <i>Amazon EKS User Guide</i>.
     */

    public java.util.List<AccessPolicy> getAccessPolicies() {
        return accessPolicies;
    }

    /**
     * <p>
     * The list of available access policies. You can't view the contents of an access policy using the API. To view the
     * contents, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions">Access
     * policy permissions</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     * 
     * @param accessPolicies
     *        The list of available access policies. You can't view the contents of an access policy using the API. To
     *        view the contents, see <a
     *        href="https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions"
     *        >Access policy permissions</a> in the <i>Amazon EKS User Guide</i>.
     */

    public void setAccessPolicies(java.util.Collection<AccessPolicy> accessPolicies) {
        if (accessPolicies == null) {
            this.accessPolicies = null;
            return;
        }

        this.accessPolicies = new java.util.ArrayList<AccessPolicy>(accessPolicies);
    }

    /**
     * <p>
     * The list of available access policies. You can't view the contents of an access policy using the API. To view the
     * contents, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions">Access
     * policy permissions</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAccessPolicies(java.util.Collection)} or {@link #withAccessPolicies(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param accessPolicies
     *        The list of available access policies. You can't view the contents of an access policy using the API. To
     *        view the contents, see <a
     *        href="https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions"
     *        >Access policy permissions</a> in the <i>Amazon EKS User Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListAccessPoliciesResult withAccessPolicies(AccessPolicy... accessPolicies) {
        if (this.accessPolicies == null) {
            setAccessPolicies(new java.util.ArrayList<AccessPolicy>(accessPolicies.length));
        }
        for (AccessPolicy ele : accessPolicies) {
            this.accessPolicies.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The list of available access policies. You can't view the contents of an access policy using the API. To view the
     * contents, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions">Access
     * policy permissions</a> in the <i>Amazon EKS User Guide</i>.
     * </p>
     * 
     * @param accessPolicies
     *        The list of available access policies. You can't view the contents of an access policy using the API. To
     *        view the contents, see <a
     *        href="https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions"
     *        >Access policy permissions</a> in the <i>Amazon EKS User Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListAccessPoliciesResult withAccessPolicies(java.util.Collection<AccessPolicy> accessPolicies) {
        setAccessPolicies(accessPolicies);
        return this;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was
     * used and the results exceeded the value of that parameter. Pagination continues from the end of the previous
     * results that returned the <code>nextToken</code> value. This value is null when there are no more results to
     * return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @param nextToken
     *        The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code>
     *        was used and the results exceeded the value of that parameter. Pagination continues from the end of the
     *        previous results that returned the <code>nextToken</code> value. This value is null when there are no more
     *        results to return.</p> <note>
     *        <p>
     *        This token should be treated as an opaque identifier that is used only to retrieve the next items in a
     *        list and not for other programmatic purposes.
     *        </p>
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was
     * used and the results exceeded the value of that parameter. Pagination continues from the end of the previous
     * results that returned the <code>nextToken</code> value. This value is null when there are no more results to
     * return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated request, where
     *         <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     *         continues from the end of the previous results that returned the <code>nextToken</code> value. This value
     *         is null when there are no more results to return.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is used only to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code> was
     * used and the results exceeded the value of that parameter. Pagination continues from the end of the previous
     * results that returned the <code>nextToken</code> value. This value is null when there are no more results to
     * return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @param nextToken
     *        The <code>nextToken</code> value returned from a previous paginated request, where <code>maxResults</code>
     *        was used and the results exceeded the value of that parameter. Pagination continues from the end of the
     *        previous results that returned the <code>nextToken</code> value. This value is null when there are no more
     *        results to return.</p> <note>
     *        <p>
     *        This token should be treated as an opaque identifier that is used only to retrieve the next items in a
     *        list and not for other programmatic purposes.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListAccessPoliciesResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAccessPolicies() != null)
            sb.append("AccessPolicies: ").append(getAccessPolicies()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListAccessPoliciesResult == false)
            return false;
        ListAccessPoliciesResult other = (ListAccessPoliciesResult) obj;
        if (other.getAccessPolicies() == null ^ this.getAccessPolicies() == null)
            return false;
        if (other.getAccessPolicies() != null && other.getAccessPolicies().equals(this.getAccessPolicies()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAccessPolicies() == null) ? 0 : getAccessPolicies().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListAccessPoliciesResult clone() {
        try {
            return (ListAccessPoliciesResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
