/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eksauth;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.eksauth.AmazonEKSAuthAsync;
import com.amazonaws.services.eksauth.AmazonEKSAuthAsyncClientBuilder;
import com.amazonaws.services.eksauth.AmazonEKSAuthClient;
import com.amazonaws.services.eksauth.model.AssumeRoleForPodIdentityRequest;
import com.amazonaws.services.eksauth.model.AssumeRoleForPodIdentityResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonEKSAuthAsyncClient
extends AmazonEKSAuthClient
implements AmazonEKSAuthAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonEKSAuthAsyncClientBuilder asyncBuilder() {
        return AmazonEKSAuthAsyncClientBuilder.standard();
    }

    AmazonEKSAuthAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonEKSAuthAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssumeRoleForPodIdentityResult> assumeRoleForPodIdentityAsync(AssumeRoleForPodIdentityRequest request) {
        return this.assumeRoleForPodIdentityAsync(request, null);
    }

    @Override
    public Future<AssumeRoleForPodIdentityResult> assumeRoleForPodIdentityAsync(AssumeRoleForPodIdentityRequest request, final AsyncHandler<AssumeRoleForPodIdentityRequest, AssumeRoleForPodIdentityResult> asyncHandler) {
        final AssumeRoleForPodIdentityRequest finalRequest = (AssumeRoleForPodIdentityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssumeRoleForPodIdentityResult>(){

            @Override
            public AssumeRoleForPodIdentityResult call() throws Exception {
                AssumeRoleForPodIdentityResult result = null;
                try {
                    result = AmazonEKSAuthAsyncClient.this.executeAssumeRoleForPodIdentity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

