/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.ConfigureShard;
import com.amazonaws.services.elasticache.model.IncreaseReplicaCountRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class IncreaseReplicaCountRequestMarshaller
implements Marshaller<Request<IncreaseReplicaCountRequest>, IncreaseReplicaCountRequest> {
    public Request<IncreaseReplicaCountRequest> marshall(IncreaseReplicaCountRequest increaseReplicaCountRequest) {
        if (increaseReplicaCountRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)increaseReplicaCountRequest, "AmazonElastiCache");
        request.addParameter("Action", "IncreaseReplicaCount");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (increaseReplicaCountRequest.getReplicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)increaseReplicaCountRequest.getReplicationGroupId()));
        }
        if (increaseReplicaCountRequest.getNewReplicaCount() != null) {
            request.addParameter("NewReplicaCount", StringUtils.fromInteger((Integer)increaseReplicaCountRequest.getNewReplicaCount()));
        }
        if (!increaseReplicaCountRequest.getReplicaConfiguration().isEmpty() || !((SdkInternalList)increaseReplicaCountRequest.getReplicaConfiguration()).isAutoConstruct()) {
            SdkInternalList replicaConfigurationList = (SdkInternalList)increaseReplicaCountRequest.getReplicaConfiguration();
            int replicaConfigurationListIndex = 1;
            for (ConfigureShard replicaConfigurationListValue : replicaConfigurationList) {
                if (replicaConfigurationListValue.getNodeGroupId() != null) {
                    request.addParameter("ReplicaConfiguration.ConfigureShard." + replicaConfigurationListIndex + ".NodeGroupId", StringUtils.fromString((String)replicaConfigurationListValue.getNodeGroupId()));
                }
                if (replicaConfigurationListValue.getNewReplicaCount() != null) {
                    request.addParameter("ReplicaConfiguration.ConfigureShard." + replicaConfigurationListIndex + ".NewReplicaCount", StringUtils.fromInteger((Integer)replicaConfigurationListValue.getNewReplicaCount()));
                }
                if (!replicaConfigurationListValue.getPreferredAvailabilityZones().isEmpty() || !((SdkInternalList)replicaConfigurationListValue.getPreferredAvailabilityZones()).isAutoConstruct()) {
                    SdkInternalList preferredAvailabilityZonesList = (SdkInternalList)replicaConfigurationListValue.getPreferredAvailabilityZones();
                    int preferredAvailabilityZonesListIndex = 1;
                    for (String preferredAvailabilityZonesListValue : preferredAvailabilityZonesList) {
                        if (preferredAvailabilityZonesListValue != null) {
                            request.addParameter("ReplicaConfiguration.ConfigureShard." + replicaConfigurationListIndex + ".PreferredAvailabilityZones.PreferredAvailabilityZone." + preferredAvailabilityZonesListIndex, StringUtils.fromString((String)preferredAvailabilityZonesListValue));
                        }
                        ++preferredAvailabilityZonesListIndex;
                    }
                }
                if (!replicaConfigurationListValue.getPreferredOutpostArns().isEmpty() || !((SdkInternalList)replicaConfigurationListValue.getPreferredOutpostArns()).isAutoConstruct()) {
                    SdkInternalList preferredOutpostArnsList = (SdkInternalList)replicaConfigurationListValue.getPreferredOutpostArns();
                    int preferredOutpostArnsListIndex = 1;
                    for (String preferredOutpostArnsListValue : preferredOutpostArnsList) {
                        if (preferredOutpostArnsListValue != null) {
                            request.addParameter("ReplicaConfiguration.ConfigureShard." + replicaConfigurationListIndex + ".PreferredOutpostArns.PreferredOutpostArn." + preferredOutpostArnsListIndex, StringUtils.fromString((String)preferredOutpostArnsListValue));
                        }
                        ++preferredOutpostArnsListIndex;
                    }
                }
                ++replicaConfigurationListIndex;
            }
        }
        if (increaseReplicaCountRequest.getApplyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean((Boolean)increaseReplicaCountRequest.getApplyImmediately()));
        }
        return request;
    }
}

