/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.services.elasticache.model.CacheSecurityGroup;
import com.amazonaws.services.elasticache.model.EC2SecurityGroup;
import com.amazonaws.services.elasticache.model.transform.EC2SecurityGroupStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class CacheSecurityGroupStaxUnmarshaller
implements Unmarshaller<CacheSecurityGroup, StaxUnmarshallerContext> {
    private static CacheSecurityGroupStaxUnmarshaller instance;

    public CacheSecurityGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        CacheSecurityGroup cacheSecurityGroup = new CacheSecurityGroup();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return cacheSecurityGroup;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("OwnerId", targetDepth)) {
                    cacheSecurityGroup.setOwnerId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheSecurityGroupName", targetDepth)) {
                    cacheSecurityGroup.setCacheSecurityGroupName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    cacheSecurityGroup.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EC2SecurityGroups", targetDepth)) {
                    cacheSecurityGroup.withEC2SecurityGroups(new ArrayList<EC2SecurityGroup>());
                    continue;
                }
                if (context.testExpression("EC2SecurityGroups/EC2SecurityGroup", targetDepth)) {
                    cacheSecurityGroup.withEC2SecurityGroups(EC2SecurityGroupStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ARN", targetDepth)) continue;
                cacheSecurityGroup.setARN(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return cacheSecurityGroup;
    }

    public static CacheSecurityGroupStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CacheSecurityGroupStaxUnmarshaller();
        }
        return instance;
    }
}

