/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.CacheNode;
import com.amazonaws.services.elasticache.model.CacheParameterGroupStatus;
import com.amazonaws.services.elasticache.model.CacheSecurityGroupMembership;
import com.amazonaws.services.elasticache.model.Endpoint;
import com.amazonaws.services.elasticache.model.IpDiscovery;
import com.amazonaws.services.elasticache.model.LogDeliveryConfiguration;
import com.amazonaws.services.elasticache.model.NetworkType;
import com.amazonaws.services.elasticache.model.NotificationConfiguration;
import com.amazonaws.services.elasticache.model.PendingModifiedValues;
import com.amazonaws.services.elasticache.model.SecurityGroupMembership;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class CacheCluster
implements Serializable,
Cloneable {
    private String cacheClusterId;
    private Endpoint configurationEndpoint;
    private String clientDownloadLandingPage;
    private String cacheNodeType;
    private String engine;
    private String engineVersion;
    private String cacheClusterStatus;
    private Integer numCacheNodes;
    private String preferredAvailabilityZone;
    private String preferredOutpostArn;
    private Date cacheClusterCreateTime;
    private String preferredMaintenanceWindow;
    private PendingModifiedValues pendingModifiedValues;
    private NotificationConfiguration notificationConfiguration;
    private SdkInternalList<CacheSecurityGroupMembership> cacheSecurityGroups;
    private CacheParameterGroupStatus cacheParameterGroup;
    private String cacheSubnetGroupName;
    private SdkInternalList<CacheNode> cacheNodes;
    private Boolean autoMinorVersionUpgrade;
    private SdkInternalList<SecurityGroupMembership> securityGroups;
    private String replicationGroupId;
    private Integer snapshotRetentionLimit;
    private String snapshotWindow;
    private Boolean authTokenEnabled;
    private Date authTokenLastModifiedDate;
    private Boolean transitEncryptionEnabled;
    private Boolean atRestEncryptionEnabled;
    private String aRN;
    private Boolean replicationGroupLogDeliveryEnabled;
    private SdkInternalList<LogDeliveryConfiguration> logDeliveryConfigurations;
    private String networkType;
    private String ipDiscovery;

    public void setCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
    }

    public String getCacheClusterId() {
        return this.cacheClusterId;
    }

    public CacheCluster withCacheClusterId(String cacheClusterId) {
        this.setCacheClusterId(cacheClusterId);
        return this;
    }

    public void setConfigurationEndpoint(Endpoint configurationEndpoint) {
        this.configurationEndpoint = configurationEndpoint;
    }

    public Endpoint getConfigurationEndpoint() {
        return this.configurationEndpoint;
    }

    public CacheCluster withConfigurationEndpoint(Endpoint configurationEndpoint) {
        this.setConfigurationEndpoint(configurationEndpoint);
        return this;
    }

    public void setClientDownloadLandingPage(String clientDownloadLandingPage) {
        this.clientDownloadLandingPage = clientDownloadLandingPage;
    }

    public String getClientDownloadLandingPage() {
        return this.clientDownloadLandingPage;
    }

    public CacheCluster withClientDownloadLandingPage(String clientDownloadLandingPage) {
        this.setClientDownloadLandingPage(clientDownloadLandingPage);
        return this;
    }

    public void setCacheNodeType(String cacheNodeType) {
        this.cacheNodeType = cacheNodeType;
    }

    public String getCacheNodeType() {
        return this.cacheNodeType;
    }

    public CacheCluster withCacheNodeType(String cacheNodeType) {
        this.setCacheNodeType(cacheNodeType);
        return this;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getEngine() {
        return this.engine;
    }

    public CacheCluster withEngine(String engine) {
        this.setEngine(engine);
        return this;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public CacheCluster withEngineVersion(String engineVersion) {
        this.setEngineVersion(engineVersion);
        return this;
    }

    public void setCacheClusterStatus(String cacheClusterStatus) {
        this.cacheClusterStatus = cacheClusterStatus;
    }

    public String getCacheClusterStatus() {
        return this.cacheClusterStatus;
    }

    public CacheCluster withCacheClusterStatus(String cacheClusterStatus) {
        this.setCacheClusterStatus(cacheClusterStatus);
        return this;
    }

    public void setNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
    }

    public Integer getNumCacheNodes() {
        return this.numCacheNodes;
    }

    public CacheCluster withNumCacheNodes(Integer numCacheNodes) {
        this.setNumCacheNodes(numCacheNodes);
        return this;
    }

    public void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
        this.preferredAvailabilityZone = preferredAvailabilityZone;
    }

    public String getPreferredAvailabilityZone() {
        return this.preferredAvailabilityZone;
    }

    public CacheCluster withPreferredAvailabilityZone(String preferredAvailabilityZone) {
        this.setPreferredAvailabilityZone(preferredAvailabilityZone);
        return this;
    }

    public void setPreferredOutpostArn(String preferredOutpostArn) {
        this.preferredOutpostArn = preferredOutpostArn;
    }

    public String getPreferredOutpostArn() {
        return this.preferredOutpostArn;
    }

    public CacheCluster withPreferredOutpostArn(String preferredOutpostArn) {
        this.setPreferredOutpostArn(preferredOutpostArn);
        return this;
    }

    public void setCacheClusterCreateTime(Date cacheClusterCreateTime) {
        this.cacheClusterCreateTime = cacheClusterCreateTime;
    }

    public Date getCacheClusterCreateTime() {
        return this.cacheClusterCreateTime;
    }

    public CacheCluster withCacheClusterCreateTime(Date cacheClusterCreateTime) {
        this.setCacheClusterCreateTime(cacheClusterCreateTime);
        return this;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public CacheCluster withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.setPreferredMaintenanceWindow(preferredMaintenanceWindow);
        return this;
    }

    public void setPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
    }

    public PendingModifiedValues getPendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public CacheCluster withPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.setPendingModifiedValues(pendingModifiedValues);
        return this;
    }

    public void setNotificationConfiguration(NotificationConfiguration notificationConfiguration) {
        this.notificationConfiguration = notificationConfiguration;
    }

    public NotificationConfiguration getNotificationConfiguration() {
        return this.notificationConfiguration;
    }

    public CacheCluster withNotificationConfiguration(NotificationConfiguration notificationConfiguration) {
        this.setNotificationConfiguration(notificationConfiguration);
        return this;
    }

    public List<CacheSecurityGroupMembership> getCacheSecurityGroups() {
        if (this.cacheSecurityGroups == null) {
            this.cacheSecurityGroups = new SdkInternalList();
        }
        return this.cacheSecurityGroups;
    }

    public void setCacheSecurityGroups(Collection<CacheSecurityGroupMembership> cacheSecurityGroups) {
        if (cacheSecurityGroups == null) {
            this.cacheSecurityGroups = null;
            return;
        }
        this.cacheSecurityGroups = new SdkInternalList(cacheSecurityGroups);
    }

    public CacheCluster withCacheSecurityGroups(CacheSecurityGroupMembership ... cacheSecurityGroups) {
        if (this.cacheSecurityGroups == null) {
            this.setCacheSecurityGroups((Collection<CacheSecurityGroupMembership>)new SdkInternalList(cacheSecurityGroups.length));
        }
        for (CacheSecurityGroupMembership ele : cacheSecurityGroups) {
            this.cacheSecurityGroups.add((Object)ele);
        }
        return this;
    }

    public CacheCluster withCacheSecurityGroups(Collection<CacheSecurityGroupMembership> cacheSecurityGroups) {
        this.setCacheSecurityGroups(cacheSecurityGroups);
        return this;
    }

    public void setCacheParameterGroup(CacheParameterGroupStatus cacheParameterGroup) {
        this.cacheParameterGroup = cacheParameterGroup;
    }

    public CacheParameterGroupStatus getCacheParameterGroup() {
        return this.cacheParameterGroup;
    }

    public CacheCluster withCacheParameterGroup(CacheParameterGroupStatus cacheParameterGroup) {
        this.setCacheParameterGroup(cacheParameterGroup);
        return this;
    }

    public void setCacheSubnetGroupName(String cacheSubnetGroupName) {
        this.cacheSubnetGroupName = cacheSubnetGroupName;
    }

    public String getCacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public CacheCluster withCacheSubnetGroupName(String cacheSubnetGroupName) {
        this.setCacheSubnetGroupName(cacheSubnetGroupName);
        return this;
    }

    public List<CacheNode> getCacheNodes() {
        if (this.cacheNodes == null) {
            this.cacheNodes = new SdkInternalList();
        }
        return this.cacheNodes;
    }

    public void setCacheNodes(Collection<CacheNode> cacheNodes) {
        if (cacheNodes == null) {
            this.cacheNodes = null;
            return;
        }
        this.cacheNodes = new SdkInternalList(cacheNodes);
    }

    public CacheCluster withCacheNodes(CacheNode ... cacheNodes) {
        if (this.cacheNodes == null) {
            this.setCacheNodes((Collection<CacheNode>)new SdkInternalList(cacheNodes.length));
        }
        for (CacheNode ele : cacheNodes) {
            this.cacheNodes.add((Object)ele);
        }
        return this;
    }

    public CacheCluster withCacheNodes(Collection<CacheNode> cacheNodes) {
        this.setCacheNodes(cacheNodes);
        return this;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public CacheCluster withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.setAutoMinorVersionUpgrade(autoMinorVersionUpgrade);
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public List<SecurityGroupMembership> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new SdkInternalList();
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<SecurityGroupMembership> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new SdkInternalList(securityGroups);
    }

    public CacheCluster withSecurityGroups(SecurityGroupMembership ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups((Collection<SecurityGroupMembership>)new SdkInternalList(securityGroups.length));
        }
        for (SecurityGroupMembership ele : securityGroups) {
            this.securityGroups.add((Object)ele);
        }
        return this;
    }

    public CacheCluster withSecurityGroups(Collection<SecurityGroupMembership> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public void setReplicationGroupId(String replicationGroupId) {
        this.replicationGroupId = replicationGroupId;
    }

    public String getReplicationGroupId() {
        return this.replicationGroupId;
    }

    public CacheCluster withReplicationGroupId(String replicationGroupId) {
        this.setReplicationGroupId(replicationGroupId);
        return this;
    }

    public void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.snapshotRetentionLimit = snapshotRetentionLimit;
    }

    public Integer getSnapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public CacheCluster withSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.setSnapshotRetentionLimit(snapshotRetentionLimit);
        return this;
    }

    public void setSnapshotWindow(String snapshotWindow) {
        this.snapshotWindow = snapshotWindow;
    }

    public String getSnapshotWindow() {
        return this.snapshotWindow;
    }

    public CacheCluster withSnapshotWindow(String snapshotWindow) {
        this.setSnapshotWindow(snapshotWindow);
        return this;
    }

    public void setAuthTokenEnabled(Boolean authTokenEnabled) {
        this.authTokenEnabled = authTokenEnabled;
    }

    public Boolean getAuthTokenEnabled() {
        return this.authTokenEnabled;
    }

    public CacheCluster withAuthTokenEnabled(Boolean authTokenEnabled) {
        this.setAuthTokenEnabled(authTokenEnabled);
        return this;
    }

    public Boolean isAuthTokenEnabled() {
        return this.authTokenEnabled;
    }

    public void setAuthTokenLastModifiedDate(Date authTokenLastModifiedDate) {
        this.authTokenLastModifiedDate = authTokenLastModifiedDate;
    }

    public Date getAuthTokenLastModifiedDate() {
        return this.authTokenLastModifiedDate;
    }

    public CacheCluster withAuthTokenLastModifiedDate(Date authTokenLastModifiedDate) {
        this.setAuthTokenLastModifiedDate(authTokenLastModifiedDate);
        return this;
    }

    public void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
        this.transitEncryptionEnabled = transitEncryptionEnabled;
    }

    public Boolean getTransitEncryptionEnabled() {
        return this.transitEncryptionEnabled;
    }

    public CacheCluster withTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
        this.setTransitEncryptionEnabled(transitEncryptionEnabled);
        return this;
    }

    public Boolean isTransitEncryptionEnabled() {
        return this.transitEncryptionEnabled;
    }

    public void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
        this.atRestEncryptionEnabled = atRestEncryptionEnabled;
    }

    public Boolean getAtRestEncryptionEnabled() {
        return this.atRestEncryptionEnabled;
    }

    public CacheCluster withAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
        this.setAtRestEncryptionEnabled(atRestEncryptionEnabled);
        return this;
    }

    public Boolean isAtRestEncryptionEnabled() {
        return this.atRestEncryptionEnabled;
    }

    public void setARN(String aRN) {
        this.aRN = aRN;
    }

    public String getARN() {
        return this.aRN;
    }

    public CacheCluster withARN(String aRN) {
        this.setARN(aRN);
        return this;
    }

    public void setReplicationGroupLogDeliveryEnabled(Boolean replicationGroupLogDeliveryEnabled) {
        this.replicationGroupLogDeliveryEnabled = replicationGroupLogDeliveryEnabled;
    }

    public Boolean getReplicationGroupLogDeliveryEnabled() {
        return this.replicationGroupLogDeliveryEnabled;
    }

    public CacheCluster withReplicationGroupLogDeliveryEnabled(Boolean replicationGroupLogDeliveryEnabled) {
        this.setReplicationGroupLogDeliveryEnabled(replicationGroupLogDeliveryEnabled);
        return this;
    }

    public Boolean isReplicationGroupLogDeliveryEnabled() {
        return this.replicationGroupLogDeliveryEnabled;
    }

    public List<LogDeliveryConfiguration> getLogDeliveryConfigurations() {
        if (this.logDeliveryConfigurations == null) {
            this.logDeliveryConfigurations = new SdkInternalList();
        }
        return this.logDeliveryConfigurations;
    }

    public void setLogDeliveryConfigurations(Collection<LogDeliveryConfiguration> logDeliveryConfigurations) {
        if (logDeliveryConfigurations == null) {
            this.logDeliveryConfigurations = null;
            return;
        }
        this.logDeliveryConfigurations = new SdkInternalList(logDeliveryConfigurations);
    }

    public CacheCluster withLogDeliveryConfigurations(LogDeliveryConfiguration ... logDeliveryConfigurations) {
        if (this.logDeliveryConfigurations == null) {
            this.setLogDeliveryConfigurations((Collection<LogDeliveryConfiguration>)new SdkInternalList(logDeliveryConfigurations.length));
        }
        for (LogDeliveryConfiguration ele : logDeliveryConfigurations) {
            this.logDeliveryConfigurations.add((Object)ele);
        }
        return this;
    }

    public CacheCluster withLogDeliveryConfigurations(Collection<LogDeliveryConfiguration> logDeliveryConfigurations) {
        this.setLogDeliveryConfigurations(logDeliveryConfigurations);
        return this;
    }

    public void setNetworkType(String networkType) {
        this.networkType = networkType;
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public CacheCluster withNetworkType(String networkType) {
        this.setNetworkType(networkType);
        return this;
    }

    public CacheCluster withNetworkType(NetworkType networkType) {
        this.networkType = networkType.toString();
        return this;
    }

    public void setIpDiscovery(String ipDiscovery) {
        this.ipDiscovery = ipDiscovery;
    }

    public String getIpDiscovery() {
        return this.ipDiscovery;
    }

    public CacheCluster withIpDiscovery(String ipDiscovery) {
        this.setIpDiscovery(ipDiscovery);
        return this;
    }

    public CacheCluster withIpDiscovery(IpDiscovery ipDiscovery) {
        this.ipDiscovery = ipDiscovery.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCacheClusterId() != null) {
            sb.append("CacheClusterId: ").append(this.getCacheClusterId()).append(",");
        }
        if (this.getConfigurationEndpoint() != null) {
            sb.append("ConfigurationEndpoint: ").append(this.getConfigurationEndpoint()).append(",");
        }
        if (this.getClientDownloadLandingPage() != null) {
            sb.append("ClientDownloadLandingPage: ").append(this.getClientDownloadLandingPage()).append(",");
        }
        if (this.getCacheNodeType() != null) {
            sb.append("CacheNodeType: ").append(this.getCacheNodeType()).append(",");
        }
        if (this.getEngine() != null) {
            sb.append("Engine: ").append(this.getEngine()).append(",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: ").append(this.getEngineVersion()).append(",");
        }
        if (this.getCacheClusterStatus() != null) {
            sb.append("CacheClusterStatus: ").append(this.getCacheClusterStatus()).append(",");
        }
        if (this.getNumCacheNodes() != null) {
            sb.append("NumCacheNodes: ").append(this.getNumCacheNodes()).append(",");
        }
        if (this.getPreferredAvailabilityZone() != null) {
            sb.append("PreferredAvailabilityZone: ").append(this.getPreferredAvailabilityZone()).append(",");
        }
        if (this.getPreferredOutpostArn() != null) {
            sb.append("PreferredOutpostArn: ").append(this.getPreferredOutpostArn()).append(",");
        }
        if (this.getCacheClusterCreateTime() != null) {
            sb.append("CacheClusterCreateTime: ").append(this.getCacheClusterCreateTime()).append(",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.getPreferredMaintenanceWindow()).append(",");
        }
        if (this.getPendingModifiedValues() != null) {
            sb.append("PendingModifiedValues: ").append(this.getPendingModifiedValues()).append(",");
        }
        if (this.getNotificationConfiguration() != null) {
            sb.append("NotificationConfiguration: ").append(this.getNotificationConfiguration()).append(",");
        }
        if (this.getCacheSecurityGroups() != null) {
            sb.append("CacheSecurityGroups: ").append(this.getCacheSecurityGroups()).append(",");
        }
        if (this.getCacheParameterGroup() != null) {
            sb.append("CacheParameterGroup: ").append(this.getCacheParameterGroup()).append(",");
        }
        if (this.getCacheSubnetGroupName() != null) {
            sb.append("CacheSubnetGroupName: ").append(this.getCacheSubnetGroupName()).append(",");
        }
        if (this.getCacheNodes() != null) {
            sb.append("CacheNodes: ").append(this.getCacheNodes()).append(",");
        }
        if (this.getAutoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: ").append(this.getAutoMinorVersionUpgrade()).append(",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups()).append(",");
        }
        if (this.getReplicationGroupId() != null) {
            sb.append("ReplicationGroupId: ").append(this.getReplicationGroupId()).append(",");
        }
        if (this.getSnapshotRetentionLimit() != null) {
            sb.append("SnapshotRetentionLimit: ").append(this.getSnapshotRetentionLimit()).append(",");
        }
        if (this.getSnapshotWindow() != null) {
            sb.append("SnapshotWindow: ").append(this.getSnapshotWindow()).append(",");
        }
        if (this.getAuthTokenEnabled() != null) {
            sb.append("AuthTokenEnabled: ").append(this.getAuthTokenEnabled()).append(",");
        }
        if (this.getAuthTokenLastModifiedDate() != null) {
            sb.append("AuthTokenLastModifiedDate: ").append(this.getAuthTokenLastModifiedDate()).append(",");
        }
        if (this.getTransitEncryptionEnabled() != null) {
            sb.append("TransitEncryptionEnabled: ").append(this.getTransitEncryptionEnabled()).append(",");
        }
        if (this.getAtRestEncryptionEnabled() != null) {
            sb.append("AtRestEncryptionEnabled: ").append(this.getAtRestEncryptionEnabled()).append(",");
        }
        if (this.getARN() != null) {
            sb.append("ARN: ").append(this.getARN()).append(",");
        }
        if (this.getReplicationGroupLogDeliveryEnabled() != null) {
            sb.append("ReplicationGroupLogDeliveryEnabled: ").append(this.getReplicationGroupLogDeliveryEnabled()).append(",");
        }
        if (this.getLogDeliveryConfigurations() != null) {
            sb.append("LogDeliveryConfigurations: ").append(this.getLogDeliveryConfigurations()).append(",");
        }
        if (this.getNetworkType() != null) {
            sb.append("NetworkType: ").append(this.getNetworkType()).append(",");
        }
        if (this.getIpDiscovery() != null) {
            sb.append("IpDiscovery: ").append(this.getIpDiscovery());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheCluster)) {
            return false;
        }
        CacheCluster other = (CacheCluster)obj;
        if (other.getCacheClusterId() == null ^ this.getCacheClusterId() == null) {
            return false;
        }
        if (other.getCacheClusterId() != null && !other.getCacheClusterId().equals(this.getCacheClusterId())) {
            return false;
        }
        if (other.getConfigurationEndpoint() == null ^ this.getConfigurationEndpoint() == null) {
            return false;
        }
        if (other.getConfigurationEndpoint() != null && !other.getConfigurationEndpoint().equals(this.getConfigurationEndpoint())) {
            return false;
        }
        if (other.getClientDownloadLandingPage() == null ^ this.getClientDownloadLandingPage() == null) {
            return false;
        }
        if (other.getClientDownloadLandingPage() != null && !other.getClientDownloadLandingPage().equals(this.getClientDownloadLandingPage())) {
            return false;
        }
        if (other.getCacheNodeType() == null ^ this.getCacheNodeType() == null) {
            return false;
        }
        if (other.getCacheNodeType() != null && !other.getCacheNodeType().equals(this.getCacheNodeType())) {
            return false;
        }
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getCacheClusterStatus() == null ^ this.getCacheClusterStatus() == null) {
            return false;
        }
        if (other.getCacheClusterStatus() != null && !other.getCacheClusterStatus().equals(this.getCacheClusterStatus())) {
            return false;
        }
        if (other.getNumCacheNodes() == null ^ this.getNumCacheNodes() == null) {
            return false;
        }
        if (other.getNumCacheNodes() != null && !other.getNumCacheNodes().equals(this.getNumCacheNodes())) {
            return false;
        }
        if (other.getPreferredAvailabilityZone() == null ^ this.getPreferredAvailabilityZone() == null) {
            return false;
        }
        if (other.getPreferredAvailabilityZone() != null && !other.getPreferredAvailabilityZone().equals(this.getPreferredAvailabilityZone())) {
            return false;
        }
        if (other.getPreferredOutpostArn() == null ^ this.getPreferredOutpostArn() == null) {
            return false;
        }
        if (other.getPreferredOutpostArn() != null && !other.getPreferredOutpostArn().equals(this.getPreferredOutpostArn())) {
            return false;
        }
        if (other.getCacheClusterCreateTime() == null ^ this.getCacheClusterCreateTime() == null) {
            return false;
        }
        if (other.getCacheClusterCreateTime() != null && !other.getCacheClusterCreateTime().equals(this.getCacheClusterCreateTime())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getPendingModifiedValues() == null ^ this.getPendingModifiedValues() == null) {
            return false;
        }
        if (other.getPendingModifiedValues() != null && !other.getPendingModifiedValues().equals(this.getPendingModifiedValues())) {
            return false;
        }
        if (other.getNotificationConfiguration() == null ^ this.getNotificationConfiguration() == null) {
            return false;
        }
        if (other.getNotificationConfiguration() != null && !other.getNotificationConfiguration().equals(this.getNotificationConfiguration())) {
            return false;
        }
        if (other.getCacheSecurityGroups() == null ^ this.getCacheSecurityGroups() == null) {
            return false;
        }
        if (other.getCacheSecurityGroups() != null && !other.getCacheSecurityGroups().equals(this.getCacheSecurityGroups())) {
            return false;
        }
        if (other.getCacheParameterGroup() == null ^ this.getCacheParameterGroup() == null) {
            return false;
        }
        if (other.getCacheParameterGroup() != null && !other.getCacheParameterGroup().equals(this.getCacheParameterGroup())) {
            return false;
        }
        if (other.getCacheSubnetGroupName() == null ^ this.getCacheSubnetGroupName() == null) {
            return false;
        }
        if (other.getCacheSubnetGroupName() != null && !other.getCacheSubnetGroupName().equals(this.getCacheSubnetGroupName())) {
            return false;
        }
        if (other.getCacheNodes() == null ^ this.getCacheNodes() == null) {
            return false;
        }
        if (other.getCacheNodes() != null && !other.getCacheNodes().equals(this.getCacheNodes())) {
            return false;
        }
        if (other.getAutoMinorVersionUpgrade() == null ^ this.getAutoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.getAutoMinorVersionUpgrade() != null && !other.getAutoMinorVersionUpgrade().equals(this.getAutoMinorVersionUpgrade())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getReplicationGroupId() == null ^ this.getReplicationGroupId() == null) {
            return false;
        }
        if (other.getReplicationGroupId() != null && !other.getReplicationGroupId().equals(this.getReplicationGroupId())) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() == null ^ this.getSnapshotRetentionLimit() == null) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() != null && !other.getSnapshotRetentionLimit().equals(this.getSnapshotRetentionLimit())) {
            return false;
        }
        if (other.getSnapshotWindow() == null ^ this.getSnapshotWindow() == null) {
            return false;
        }
        if (other.getSnapshotWindow() != null && !other.getSnapshotWindow().equals(this.getSnapshotWindow())) {
            return false;
        }
        if (other.getAuthTokenEnabled() == null ^ this.getAuthTokenEnabled() == null) {
            return false;
        }
        if (other.getAuthTokenEnabled() != null && !other.getAuthTokenEnabled().equals(this.getAuthTokenEnabled())) {
            return false;
        }
        if (other.getAuthTokenLastModifiedDate() == null ^ this.getAuthTokenLastModifiedDate() == null) {
            return false;
        }
        if (other.getAuthTokenLastModifiedDate() != null && !other.getAuthTokenLastModifiedDate().equals(this.getAuthTokenLastModifiedDate())) {
            return false;
        }
        if (other.getTransitEncryptionEnabled() == null ^ this.getTransitEncryptionEnabled() == null) {
            return false;
        }
        if (other.getTransitEncryptionEnabled() != null && !other.getTransitEncryptionEnabled().equals(this.getTransitEncryptionEnabled())) {
            return false;
        }
        if (other.getAtRestEncryptionEnabled() == null ^ this.getAtRestEncryptionEnabled() == null) {
            return false;
        }
        if (other.getAtRestEncryptionEnabled() != null && !other.getAtRestEncryptionEnabled().equals(this.getAtRestEncryptionEnabled())) {
            return false;
        }
        if (other.getARN() == null ^ this.getARN() == null) {
            return false;
        }
        if (other.getARN() != null && !other.getARN().equals(this.getARN())) {
            return false;
        }
        if (other.getReplicationGroupLogDeliveryEnabled() == null ^ this.getReplicationGroupLogDeliveryEnabled() == null) {
            return false;
        }
        if (other.getReplicationGroupLogDeliveryEnabled() != null && !other.getReplicationGroupLogDeliveryEnabled().equals(this.getReplicationGroupLogDeliveryEnabled())) {
            return false;
        }
        if (other.getLogDeliveryConfigurations() == null ^ this.getLogDeliveryConfigurations() == null) {
            return false;
        }
        if (other.getLogDeliveryConfigurations() != null && !other.getLogDeliveryConfigurations().equals(this.getLogDeliveryConfigurations())) {
            return false;
        }
        if (other.getNetworkType() == null ^ this.getNetworkType() == null) {
            return false;
        }
        if (other.getNetworkType() != null && !other.getNetworkType().equals(this.getNetworkType())) {
            return false;
        }
        if (other.getIpDiscovery() == null ^ this.getIpDiscovery() == null) {
            return false;
        }
        return other.getIpDiscovery() == null || other.getIpDiscovery().equals(this.getIpDiscovery());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCacheClusterId() == null ? 0 : this.getCacheClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurationEndpoint() == null ? 0 : this.getConfigurationEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getClientDownloadLandingPage() == null ? 0 : this.getClientDownloadLandingPage().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNodeType() == null ? 0 : this.getCacheNodeType().hashCode());
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getCacheClusterStatus() == null ? 0 : this.getCacheClusterStatus().hashCode());
        hashCode = 31 * hashCode + (this.getNumCacheNodes() == null ? 0 : this.getNumCacheNodes().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredAvailabilityZone() == null ? 0 : this.getPreferredAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredOutpostArn() == null ? 0 : this.getPreferredOutpostArn().hashCode());
        hashCode = 31 * hashCode + (this.getCacheClusterCreateTime() == null ? 0 : this.getCacheClusterCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getPendingModifiedValues() == null ? 0 : this.getPendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationConfiguration() == null ? 0 : this.getNotificationConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getCacheSecurityGroups() == null ? 0 : this.getCacheSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getCacheParameterGroup() == null ? 0 : this.getCacheParameterGroup().hashCode());
        hashCode = 31 * hashCode + (this.getCacheSubnetGroupName() == null ? 0 : this.getCacheSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNodes() == null ? 0 : this.getCacheNodes().hashCode());
        hashCode = 31 * hashCode + (this.getAutoMinorVersionUpgrade() == null ? 0 : this.getAutoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationGroupId() == null ? 0 : this.getReplicationGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotRetentionLimit() == null ? 0 : this.getSnapshotRetentionLimit().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotWindow() == null ? 0 : this.getSnapshotWindow().hashCode());
        hashCode = 31 * hashCode + (this.getAuthTokenEnabled() == null ? 0 : this.getAuthTokenEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getAuthTokenLastModifiedDate() == null ? 0 : this.getAuthTokenLastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.getTransitEncryptionEnabled() == null ? 0 : this.getTransitEncryptionEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getAtRestEncryptionEnabled() == null ? 0 : this.getAtRestEncryptionEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getARN() == null ? 0 : this.getARN().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationGroupLogDeliveryEnabled() == null ? 0 : this.getReplicationGroupLogDeliveryEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getLogDeliveryConfigurations() == null ? 0 : this.getLogDeliveryConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkType() == null ? 0 : this.getNetworkType().hashCode());
        hashCode = 31 * hashCode + (this.getIpDiscovery() == null ? 0 : this.getIpDiscovery().hashCode());
        return hashCode;
    }

    public CacheCluster clone() {
        try {
            return (CacheCluster)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

