/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.elasticache.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * Represents the input of a <code>CreateReplicationGroup</code> operation.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateReplicationGroup" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateReplicationGroupRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The replication group identifier. This parameter is stored as a lowercase string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A name must contain from 1 to 40 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * A name cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     */
    private String replicationGroupId;
    /**
     * <p>
     * A user-created description for the replication group.
     * </p>
     */
    private String replicationGroupDescription;
    /**
     * <p>
     * The name of the Global datastore
     * </p>
     */
    private String globalReplicationGroupId;
    /**
     * <p>
     * The identifier of the cluster that serves as the primary for this replication group. This cluster must already
     * exist and have a status of <code>available</code>.
     * </p>
     * <p>
     * This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or
     * <code>ReplicasPerNodeGroup</code> is specified.
     * </p>
     */
    private String primaryClusterId;
    /**
     * <p>
     * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary
     * fails.
     * </p>
     * <p>
     * <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.
     * </p>
     * <p>
     * Default: false
     * </p>
     */
    private Boolean automaticFailoverEnabled;
    /**
     * <p>
     * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime:
     * Multi-AZ</a>.
     * </p>
     */
    private Boolean multiAZEnabled;
    /**
     * <p>
     * The number of clusters this replication group initially has.
     * </p>
     * <p>
     * This parameter is not used if there is more than one node group (shard). You should use
     * <code>ReplicasPerNodeGroup</code> instead.
     * </p>
     * <p>
     * If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at least 2. If
     * <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will default to 1),
     * or you can explicitly set it to a value between 2 and 6.
     * </p>
     * <p>
     * The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
     * </p>
     */
    private Integer numCacheClusters;
    /**
     * <p>
     * A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the
     * Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in
     * the first AZ in the list.
     * </p>
     * <p>
     * This parameter is not used if there is more than one node group (shard). You should use
     * <code>NodeGroupConfiguration</code> instead.
     * </p>
     * <note>
     * <p>
     * If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in
     * Availability Zones associated with the subnets in the selected subnet group.
     * </p>
     * <p>
     * The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
     * </p>
     * </note>
     * <p>
     * Default: system chosen Availability Zones.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<String> preferredCacheClusterAZs;
    /**
     * <p>
     * An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled)
     * replication group. For Redis (cluster mode disabled) either omit this parameter or set it to 1.
     * </p>
     * <p>
     * Default: 1
     * </p>
     */
    private Integer numNodeGroups;
    /**
     * <p>
     * An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values are 0
     * to 5.
     * </p>
     */
    private Integer replicasPerNodeGroup;
    /**
     * <p>
     * A list of node group (shard) configuration options. Each node group (shard) configuration has the following
     * members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>, <code>ReplicaCount</code>,
     * and <code>Slots</code>.
     * </p>
     * <p>
     * If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you can
     * use this parameter to individually configure each node group (shard), or you can omit this parameter. However, it
     * is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file. You must configure each node
     * group (shard) using this parameter because you must specify the slots for each node group.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<NodeGroupConfiguration> nodeGroupConfiguration;
    /**
     * <p>
     * The compute and memory capacity of the nodes in the node group (shard).
     * </p>
     * <p>
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide
     * more memory and computational power at lower cost when compared to their equivalent previous generation
     * counterparts.
     * </p>
     * <ul>
     * <li>
     * <p>
     * General purpose:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>,
     * <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>,
     * <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code>
     * </p>
     * <note>
     * <p>
     * For region availability, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     * >Supported Node Types</a>
     * </p>
     * </note>
     * <p>
     * <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version
     * 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>,
     * <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>,
     * <code>cache.m6g.16xlarge</code>
     * </p>
     * <p>
     * <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>,
     * <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code>
     * </p>
     * <p>
     * <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>,
     * <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
     * </p>
     * <p>
     * <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16
     * onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code>
     * </p>
     * <p>
     * <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code>
     * </p>
     * <p>
     * <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>T1 node types:</b> <code>cache.t1.micro</code>
     * </p>
     * <p>
     * <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>,
     * <code>cache.m1.xlarge</code>
     * </p>
     * <p>
     * <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>,
     * <code>cache.m3.2xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Compute optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>C1 node types:</b> <code>cache.c1.xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Memory optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>,
     * <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>,
     * <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code>
     * </p>
     * <note>
     * <p>
     * For region availability, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     * >Supported Node Types</a>
     * </p>
     * </note>
     * <p>
     * <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version
     * 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>,
     * <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>,
     * <code>cache.r6g.16xlarge</code>
     * </p>
     * <p>
     * <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>,
     * <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code>
     * </p>
     * <p>
     * <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>,
     * <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code>
     * </p>
     * <p>
     * <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>,
     * <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * <b>Additional node type info</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All current generation instance types are created in Amazon VPC by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis append-only files (AOF) are not supported for T1 or T2 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis Multi-AZ with automatic failover is not supported on T1 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis
     * version 2.8.22 and later.
     * </p>
     * </li>
     * </ul>
     */
    private String cacheNodeType;
    /**
     * <p>
     * The name of the cache engine to be used for the clusters in this replication group. The value must be set to
     * <code>Redis</code>.
     * </p>
     */
    private String engine;
    /**
     * <p>
     * The version number of the cache engine to be used for the clusters in this replication group. To view the
     * supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.
     * </p>
     * <p>
     * <b>Important:</b> You can upgrade to a newer engine version (see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting
     * a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade to an earlier
     * engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication
     * group and create it anew with the earlier engine version.
     * </p>
     */
    private String engineVersion;
    /**
     * <p>
     * The name of the parameter group to associate with this replication group. If this argument is omitted, the
     * default cache parameter group for the specified engine is used.
     * </p>
     * <p>
     * If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter
     * group, we recommend that you specify the parameter group by name.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a Redis (cluster mode disabled) replication group, use
     * <code>CacheParameterGroupName=default.redis3.2</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a Redis (cluster mode enabled) replication group, use
     * <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.
     * </p>
     * </li>
     * </ul>
     */
    private String cacheParameterGroupName;
    /**
     * <p>
     * The name of the cache subnet group to be used for the replication group.
     * </p>
     * <important>
     * <p>
     * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start
     * creating a cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet
     * Groups</a>.
     * </p>
     * </important>
     */
    private String cacheSubnetGroupName;
    /**
     * <p>
     * A list of cache security group names to associate with this replication group.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<String> cacheSecurityGroupNames;
    /**
     * <p>
     * One or more Amazon VPC security groups associated with this replication group.
     * </p>
     * <p>
     * Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon
     * VPC).
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<String> securityGroupIds;
    /**
     * <p>
     * A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=
     * <code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=
     * <code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
     * <code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<Tag> tags;
    /**
     * <p>
     * A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3.
     * The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot
     * contain any commas. The new replication group will have the number of node groups (console: shards) specified by
     * the parameter <i>NumNodeGroups</i> or the number of node groups configured by <i>NodeGroupConfiguration</i>
     * regardless of the number of ARNs specified here.
     * </p>
     * <p>
     * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<String> snapshotArns;
    /**
     * <p>
     * The name of a snapshot from which to restore data into the new replication group. The snapshot status changes to
     * <code>restoring</code> while the new replication group is being created.
     * </p>
     */
    private String snapshotName;
    /**
     * <p>
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range
     * in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * </p>
     * <p>
     * Valid values for <code>ddd</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sun</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mon</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tue</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>wed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>thu</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fri</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sat</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>sun:23:00-mon:01:30</code>
     * </p>
     */
    private String preferredMaintenanceWindow;
    /**
     * <p>
     * The port number on which each member of the replication group accepts connections.
     * </p>
     */
    private Integer port;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are
     * sent.
     * </p>
     * <note>
     * <p>
     * The Amazon SNS topic owner must be the same as the cluster owner.
     * </p>
     * </note>
     */
    private String notificationTopicArn;
    /**
     * <p>
     *  If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the
     * next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
     * </p>
     */
    private Boolean autoMinorVersionUpgrade;
    /**
     * <p>
     * The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you
     * set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being
     * deleted.
     * </p>
     * <p>
     * Default: 0 (i.e., automatic backups are disabled for this cluster).
     * </p>
     */
    private Integer snapshotRetentionLimit;
    /**
     * <p>
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
     * </p>
     * <p>
     * Example: <code>05:00-09:00</code>
     * </p>
     * <p>
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     * </p>
     */
    private String snapshotWindow;
    /**
     * <p>
     * <b>Reserved parameter.</b> The password used to access a password protected server.
     * </p>
     * <p>
     * <code>AuthToken</code> can be specified only on replication groups where <code>TransitEncryptionEnabled</code> is
     * <code>true</code>.
     * </p>
     * <important>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     * <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     * </p>
     * </important>
     * <p>
     * Password constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be only printable ASCII characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 16 characters and no more than 128 characters in length.
     * </p>
     * </li>
     * <li>
     * <p>
     * The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special
     * characters cannot be used in the AUTH token.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
     * http://redis.io/commands/AUTH.
     * </p>
     */
    private String authToken;
    /**
     * <p>
     * A flag that enables in-transit encryption when set to <code>true</code>.
     * </p>
     * <p>
     * This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the
     * <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is being
     * created in an Amazon VPC.
     * </p>
     * <p>
     * If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * <important>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     * <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     * </p>
     * </important>
     */
    private Boolean transitEncryptionEnabled;
    /**
     * <p>
     * A flag that enables encryption at rest when set to <code>true</code>.
     * </p>
     * <p>
     * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To
     * enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to
     * <code>true</code> when you create the replication group.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     */
    private Boolean atRestEncryptionEnabled;
    /**
     * <p>
     * The ID of the KMS key used to encrypt the disk in the cluster.
     * </p>
     */
    private String kmsKeyId;
    /**
     * <p>
     * The user group to associate with the replication group.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<String> userGroupIds;
    /**
     * <p>
     * Specifies the destination, format and type of the logs.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<LogDeliveryConfigurationRequest> logDeliveryConfigurations;
    /**
     * <p>
     * Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This
     * parameter must be set to true when using r6gd nodes. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
     * </p>
     */
    private Boolean dataTieringEnabled;
    /**
     * <p>
     * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for workloads
     * using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a
     * href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     */
    private String networkType;
    /**
     * <p>
     * The network type you choose when creating a replication group, either <code>ipv4</code> | <code>ipv6</code>. IPv6
     * is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all
     * instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     */
    private String ipDiscovery;
    /**
     * <p>
     * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * </p>
     * <p>
     * When setting <code>TransitEncryptionEnabled</code> to <code>true</code>, you can set your
     * <code>TransitEncryptionMode</code> to <code>preferred</code> in the same request, to allow both encrypted and
     * unencrypted connections at the same time. Once you migrate all your Redis clients to use encrypted connections
     * you can modify the value to <code>required</code> to allow encrypted connections only.
     * </p>
     * <p>
     * Setting <code>TransitEncryptionMode</code> to <code>required</code> is a two-step process that requires you to
     * first set the <code>TransitEncryptionMode</code> to <code>preferred</code>, after that you can set
     * <code>TransitEncryptionMode</code> to <code>required</code>.
     * </p>
     * <p>
     * This process will not trigger the replacement of the replication group.
     * </p>
     */
    private String transitEncryptionMode;
    /**
     * <p>
     * Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to
     * Compatible. Compatible mode allows your Redis clients to connect using both cluster mode enabled and cluster mode
     * disabled. After you migrate all Redis clients to use cluster mode enabled, you can then complete cluster mode
     * configuration and set the cluster mode to Enabled.
     * </p>
     */
    private String clusterMode;
    /**
     * <p>
     * The name of the snapshot used to create a replication group. Available for Redis only.
     * </p>
     */
    private String serverlessCacheSnapshotName;

    /**
     * <p>
     * The replication group identifier. This parameter is stored as a lowercase string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A name must contain from 1 to 40 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * A name cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * 
     * @param replicationGroupId
     *        The replication group identifier. This parameter is stored as a lowercase string.</p>
     *        <p>
     *        Constraints:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        A name must contain from 1 to 40 alphanumeric characters or hyphens.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The first character must be a letter.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        A name cannot end with a hyphen or contain two consecutive hyphens.
     *        </p>
     *        </li>
     */

    public void setReplicationGroupId(String replicationGroupId) {
        this.replicationGroupId = replicationGroupId;
    }

    /**
     * <p>
     * The replication group identifier. This parameter is stored as a lowercase string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A name must contain from 1 to 40 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * A name cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The replication group identifier. This parameter is stored as a lowercase string.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A name must contain from 1 to 40 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A name cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     */

    public String getReplicationGroupId() {
        return this.replicationGroupId;
    }

    /**
     * <p>
     * The replication group identifier. This parameter is stored as a lowercase string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A name must contain from 1 to 40 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * A name cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * 
     * @param replicationGroupId
     *        The replication group identifier. This parameter is stored as a lowercase string.</p>
     *        <p>
     *        Constraints:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        A name must contain from 1 to 40 alphanumeric characters or hyphens.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The first character must be a letter.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        A name cannot end with a hyphen or contain two consecutive hyphens.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withReplicationGroupId(String replicationGroupId) {
        setReplicationGroupId(replicationGroupId);
        return this;
    }

    /**
     * <p>
     * A user-created description for the replication group.
     * </p>
     * 
     * @param replicationGroupDescription
     *        A user-created description for the replication group.
     */

    public void setReplicationGroupDescription(String replicationGroupDescription) {
        this.replicationGroupDescription = replicationGroupDescription;
    }

    /**
     * <p>
     * A user-created description for the replication group.
     * </p>
     * 
     * @return A user-created description for the replication group.
     */

    public String getReplicationGroupDescription() {
        return this.replicationGroupDescription;
    }

    /**
     * <p>
     * A user-created description for the replication group.
     * </p>
     * 
     * @param replicationGroupDescription
     *        A user-created description for the replication group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withReplicationGroupDescription(String replicationGroupDescription) {
        setReplicationGroupDescription(replicationGroupDescription);
        return this;
    }

    /**
     * <p>
     * The name of the Global datastore
     * </p>
     * 
     * @param globalReplicationGroupId
     *        The name of the Global datastore
     */

    public void setGlobalReplicationGroupId(String globalReplicationGroupId) {
        this.globalReplicationGroupId = globalReplicationGroupId;
    }

    /**
     * <p>
     * The name of the Global datastore
     * </p>
     * 
     * @return The name of the Global datastore
     */

    public String getGlobalReplicationGroupId() {
        return this.globalReplicationGroupId;
    }

    /**
     * <p>
     * The name of the Global datastore
     * </p>
     * 
     * @param globalReplicationGroupId
     *        The name of the Global datastore
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withGlobalReplicationGroupId(String globalReplicationGroupId) {
        setGlobalReplicationGroupId(globalReplicationGroupId);
        return this;
    }

    /**
     * <p>
     * The identifier of the cluster that serves as the primary for this replication group. This cluster must already
     * exist and have a status of <code>available</code>.
     * </p>
     * <p>
     * This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or
     * <code>ReplicasPerNodeGroup</code> is specified.
     * </p>
     * 
     * @param primaryClusterId
     *        The identifier of the cluster that serves as the primary for this replication group. This cluster must
     *        already exist and have a status of <code>available</code>.</p>
     *        <p>
     *        This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or
     *        <code>ReplicasPerNodeGroup</code> is specified.
     */

    public void setPrimaryClusterId(String primaryClusterId) {
        this.primaryClusterId = primaryClusterId;
    }

    /**
     * <p>
     * The identifier of the cluster that serves as the primary for this replication group. This cluster must already
     * exist and have a status of <code>available</code>.
     * </p>
     * <p>
     * This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or
     * <code>ReplicasPerNodeGroup</code> is specified.
     * </p>
     * 
     * @return The identifier of the cluster that serves as the primary for this replication group. This cluster must
     *         already exist and have a status of <code>available</code>.</p>
     *         <p>
     *         This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or
     *         <code>ReplicasPerNodeGroup</code> is specified.
     */

    public String getPrimaryClusterId() {
        return this.primaryClusterId;
    }

    /**
     * <p>
     * The identifier of the cluster that serves as the primary for this replication group. This cluster must already
     * exist and have a status of <code>available</code>.
     * </p>
     * <p>
     * This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or
     * <code>ReplicasPerNodeGroup</code> is specified.
     * </p>
     * 
     * @param primaryClusterId
     *        The identifier of the cluster that serves as the primary for this replication group. This cluster must
     *        already exist and have a status of <code>available</code>.</p>
     *        <p>
     *        This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or
     *        <code>ReplicasPerNodeGroup</code> is specified.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withPrimaryClusterId(String primaryClusterId) {
        setPrimaryClusterId(primaryClusterId);
        return this;
    }

    /**
     * <p>
     * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary
     * fails.
     * </p>
     * <p>
     * <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @param automaticFailoverEnabled
     *        Specifies whether a read-only replica is automatically promoted to read/write primary if the existing
     *        primary fails.</p>
     *        <p>
     *        <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.
     *        </p>
     *        <p>
     *        Default: false
     */

    public void setAutomaticFailoverEnabled(Boolean automaticFailoverEnabled) {
        this.automaticFailoverEnabled = automaticFailoverEnabled;
    }

    /**
     * <p>
     * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary
     * fails.
     * </p>
     * <p>
     * <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return Specifies whether a read-only replica is automatically promoted to read/write primary if the existing
     *         primary fails.</p>
     *         <p>
     *         <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication
     *         groups.
     *         </p>
     *         <p>
     *         Default: false
     */

    public Boolean getAutomaticFailoverEnabled() {
        return this.automaticFailoverEnabled;
    }

    /**
     * <p>
     * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary
     * fails.
     * </p>
     * <p>
     * <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @param automaticFailoverEnabled
     *        Specifies whether a read-only replica is automatically promoted to read/write primary if the existing
     *        primary fails.</p>
     *        <p>
     *        <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.
     *        </p>
     *        <p>
     *        Default: false
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withAutomaticFailoverEnabled(Boolean automaticFailoverEnabled) {
        setAutomaticFailoverEnabled(automaticFailoverEnabled);
        return this;
    }

    /**
     * <p>
     * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary
     * fails.
     * </p>
     * <p>
     * <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication groups.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return Specifies whether a read-only replica is automatically promoted to read/write primary if the existing
     *         primary fails.</p>
     *         <p>
     *         <code>AutomaticFailoverEnabled</code> must be enabled for Redis (cluster mode enabled) replication
     *         groups.
     *         </p>
     *         <p>
     *         Default: false
     */

    public Boolean isAutomaticFailoverEnabled() {
        return this.automaticFailoverEnabled;
    }

    /**
     * <p>
     * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime:
     * Multi-AZ</a>.
     * </p>
     * 
     * @param multiAZEnabled
     *        A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a
     *        href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime:
     *        Multi-AZ</a>.
     */

    public void setMultiAZEnabled(Boolean multiAZEnabled) {
        this.multiAZEnabled = multiAZEnabled;
    }

    /**
     * <p>
     * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime:
     * Multi-AZ</a>.
     * </p>
     * 
     * @return A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime:
     *         Multi-AZ</a>.
     */

    public Boolean getMultiAZEnabled() {
        return this.multiAZEnabled;
    }

    /**
     * <p>
     * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime:
     * Multi-AZ</a>.
     * </p>
     * 
     * @param multiAZEnabled
     *        A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a
     *        href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime:
     *        Multi-AZ</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withMultiAZEnabled(Boolean multiAZEnabled) {
        setMultiAZEnabled(multiAZEnabled);
        return this;
    }

    /**
     * <p>
     * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime:
     * Multi-AZ</a>.
     * </p>
     * 
     * @return A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime:
     *         Multi-AZ</a>.
     */

    public Boolean isMultiAZEnabled() {
        return this.multiAZEnabled;
    }

    /**
     * <p>
     * The number of clusters this replication group initially has.
     * </p>
     * <p>
     * This parameter is not used if there is more than one node group (shard). You should use
     * <code>ReplicasPerNodeGroup</code> instead.
     * </p>
     * <p>
     * If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at least 2. If
     * <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will default to 1),
     * or you can explicitly set it to a value between 2 and 6.
     * </p>
     * <p>
     * The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
     * </p>
     * 
     * @param numCacheClusters
     *        The number of clusters this replication group initially has.</p>
     *        <p>
     *        This parameter is not used if there is more than one node group (shard). You should use
     *        <code>ReplicasPerNodeGroup</code> instead.
     *        </p>
     *        <p>
     *        If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at
     *        least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it
     *        will default to 1), or you can explicitly set it to a value between 2 and 6.
     *        </p>
     *        <p>
     *        The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
     */

    public void setNumCacheClusters(Integer numCacheClusters) {
        this.numCacheClusters = numCacheClusters;
    }

    /**
     * <p>
     * The number of clusters this replication group initially has.
     * </p>
     * <p>
     * This parameter is not used if there is more than one node group (shard). You should use
     * <code>ReplicasPerNodeGroup</code> instead.
     * </p>
     * <p>
     * If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at least 2. If
     * <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will default to 1),
     * or you can explicitly set it to a value between 2 and 6.
     * </p>
     * <p>
     * The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
     * </p>
     * 
     * @return The number of clusters this replication group initially has.</p>
     *         <p>
     *         This parameter is not used if there is more than one node group (shard). You should use
     *         <code>ReplicasPerNodeGroup</code> instead.
     *         </p>
     *         <p>
     *         If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at
     *         least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it
     *         will default to 1), or you can explicitly set it to a value between 2 and 6.
     *         </p>
     *         <p>
     *         The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
     */

    public Integer getNumCacheClusters() {
        return this.numCacheClusters;
    }

    /**
     * <p>
     * The number of clusters this replication group initially has.
     * </p>
     * <p>
     * This parameter is not used if there is more than one node group (shard). You should use
     * <code>ReplicasPerNodeGroup</code> instead.
     * </p>
     * <p>
     * If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at least 2. If
     * <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will default to 1),
     * or you can explicitly set it to a value between 2 and 6.
     * </p>
     * <p>
     * The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
     * </p>
     * 
     * @param numCacheClusters
     *        The number of clusters this replication group initially has.</p>
     *        <p>
     *        This parameter is not used if there is more than one node group (shard). You should use
     *        <code>ReplicasPerNodeGroup</code> instead.
     *        </p>
     *        <p>
     *        If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at
     *        least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it
     *        will default to 1), or you can explicitly set it to a value between 2 and 6.
     *        </p>
     *        <p>
     *        The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withNumCacheClusters(Integer numCacheClusters) {
        setNumCacheClusters(numCacheClusters);
        return this;
    }

    /**
     * <p>
     * A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the
     * Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in
     * the first AZ in the list.
     * </p>
     * <p>
     * This parameter is not used if there is more than one node group (shard). You should use
     * <code>NodeGroupConfiguration</code> instead.
     * </p>
     * <note>
     * <p>
     * If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in
     * Availability Zones associated with the subnets in the selected subnet group.
     * </p>
     * <p>
     * The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
     * </p>
     * </note>
     * <p>
     * Default: system chosen Availability Zones.
     * </p>
     * 
     * @return A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the
     *         Availability Zones in the list is the order in which clusters are allocated. The primary cluster is
     *         created in the first AZ in the list.</p>
     *         <p>
     *         This parameter is not used if there is more than one node group (shard). You should use
     *         <code>NodeGroupConfiguration</code> instead.
     *         </p>
     *         <note>
     *         <p>
     *         If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters
     *         in Availability Zones associated with the subnets in the selected subnet group.
     *         </p>
     *         <p>
     *         The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
     *         </p>
     *         </note>
     *         <p>
     *         Default: system chosen Availability Zones.
     */

    public java.util.List<String> getPreferredCacheClusterAZs() {
        if (preferredCacheClusterAZs == null) {
            preferredCacheClusterAZs = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return preferredCacheClusterAZs;
    }

    /**
     * <p>
     * A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the
     * Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in
     * the first AZ in the list.
     * </p>
     * <p>
     * This parameter is not used if there is more than one node group (shard). You should use
     * <code>NodeGroupConfiguration</code> instead.
     * </p>
     * <note>
     * <p>
     * If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in
     * Availability Zones associated with the subnets in the selected subnet group.
     * </p>
     * <p>
     * The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
     * </p>
     * </note>
     * <p>
     * Default: system chosen Availability Zones.
     * </p>
     * 
     * @param preferredCacheClusterAZs
     *        A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the
     *        Availability Zones in the list is the order in which clusters are allocated. The primary cluster is
     *        created in the first AZ in the list.</p>
     *        <p>
     *        This parameter is not used if there is more than one node group (shard). You should use
     *        <code>NodeGroupConfiguration</code> instead.
     *        </p>
     *        <note>
     *        <p>
     *        If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in
     *        Availability Zones associated with the subnets in the selected subnet group.
     *        </p>
     *        <p>
     *        The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
     *        </p>
     *        </note>
     *        <p>
     *        Default: system chosen Availability Zones.
     */

    public void setPreferredCacheClusterAZs(java.util.Collection<String> preferredCacheClusterAZs) {
        if (preferredCacheClusterAZs == null) {
            this.preferredCacheClusterAZs = null;
            return;
        }

        this.preferredCacheClusterAZs = new com.amazonaws.internal.SdkInternalList<String>(preferredCacheClusterAZs);
    }

    /**
     * <p>
     * A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the
     * Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in
     * the first AZ in the list.
     * </p>
     * <p>
     * This parameter is not used if there is more than one node group (shard). You should use
     * <code>NodeGroupConfiguration</code> instead.
     * </p>
     * <note>
     * <p>
     * If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in
     * Availability Zones associated with the subnets in the selected subnet group.
     * </p>
     * <p>
     * The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
     * </p>
     * </note>
     * <p>
     * Default: system chosen Availability Zones.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setPreferredCacheClusterAZs(java.util.Collection)} or
     * {@link #withPreferredCacheClusterAZs(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param preferredCacheClusterAZs
     *        A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the
     *        Availability Zones in the list is the order in which clusters are allocated. The primary cluster is
     *        created in the first AZ in the list.</p>
     *        <p>
     *        This parameter is not used if there is more than one node group (shard). You should use
     *        <code>NodeGroupConfiguration</code> instead.
     *        </p>
     *        <note>
     *        <p>
     *        If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in
     *        Availability Zones associated with the subnets in the selected subnet group.
     *        </p>
     *        <p>
     *        The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
     *        </p>
     *        </note>
     *        <p>
     *        Default: system chosen Availability Zones.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withPreferredCacheClusterAZs(String... preferredCacheClusterAZs) {
        if (this.preferredCacheClusterAZs == null) {
            setPreferredCacheClusterAZs(new com.amazonaws.internal.SdkInternalList<String>(preferredCacheClusterAZs.length));
        }
        for (String ele : preferredCacheClusterAZs) {
            this.preferredCacheClusterAZs.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the
     * Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in
     * the first AZ in the list.
     * </p>
     * <p>
     * This parameter is not used if there is more than one node group (shard). You should use
     * <code>NodeGroupConfiguration</code> instead.
     * </p>
     * <note>
     * <p>
     * If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in
     * Availability Zones associated with the subnets in the selected subnet group.
     * </p>
     * <p>
     * The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
     * </p>
     * </note>
     * <p>
     * Default: system chosen Availability Zones.
     * </p>
     * 
     * @param preferredCacheClusterAZs
     *        A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the
     *        Availability Zones in the list is the order in which clusters are allocated. The primary cluster is
     *        created in the first AZ in the list.</p>
     *        <p>
     *        This parameter is not used if there is more than one node group (shard). You should use
     *        <code>NodeGroupConfiguration</code> instead.
     *        </p>
     *        <note>
     *        <p>
     *        If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in
     *        Availability Zones associated with the subnets in the selected subnet group.
     *        </p>
     *        <p>
     *        The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.
     *        </p>
     *        </note>
     *        <p>
     *        Default: system chosen Availability Zones.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withPreferredCacheClusterAZs(java.util.Collection<String> preferredCacheClusterAZs) {
        setPreferredCacheClusterAZs(preferredCacheClusterAZs);
        return this;
    }

    /**
     * <p>
     * An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled)
     * replication group. For Redis (cluster mode disabled) either omit this parameter or set it to 1.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * 
     * @param numNodeGroups
     *        An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode
     *        enabled) replication group. For Redis (cluster mode disabled) either omit this parameter or set it to
     *        1.</p>
     *        <p>
     *        Default: 1
     */

    public void setNumNodeGroups(Integer numNodeGroups) {
        this.numNodeGroups = numNodeGroups;
    }

    /**
     * <p>
     * An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled)
     * replication group. For Redis (cluster mode disabled) either omit this parameter or set it to 1.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * 
     * @return An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode
     *         enabled) replication group. For Redis (cluster mode disabled) either omit this parameter or set it to
     *         1.</p>
     *         <p>
     *         Default: 1
     */

    public Integer getNumNodeGroups() {
        return this.numNodeGroups;
    }

    /**
     * <p>
     * An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled)
     * replication group. For Redis (cluster mode disabled) either omit this parameter or set it to 1.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * 
     * @param numNodeGroups
     *        An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode
     *        enabled) replication group. For Redis (cluster mode disabled) either omit this parameter or set it to
     *        1.</p>
     *        <p>
     *        Default: 1
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withNumNodeGroups(Integer numNodeGroups) {
        setNumNodeGroups(numNodeGroups);
        return this;
    }

    /**
     * <p>
     * An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values are 0
     * to 5.
     * </p>
     * 
     * @param replicasPerNodeGroup
     *        An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values
     *        are 0 to 5.
     */

    public void setReplicasPerNodeGroup(Integer replicasPerNodeGroup) {
        this.replicasPerNodeGroup = replicasPerNodeGroup;
    }

    /**
     * <p>
     * An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values are 0
     * to 5.
     * </p>
     * 
     * @return An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values
     *         are 0 to 5.
     */

    public Integer getReplicasPerNodeGroup() {
        return this.replicasPerNodeGroup;
    }

    /**
     * <p>
     * An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values are 0
     * to 5.
     * </p>
     * 
     * @param replicasPerNodeGroup
     *        An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values
     *        are 0 to 5.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withReplicasPerNodeGroup(Integer replicasPerNodeGroup) {
        setReplicasPerNodeGroup(replicasPerNodeGroup);
        return this;
    }

    /**
     * <p>
     * A list of node group (shard) configuration options. Each node group (shard) configuration has the following
     * members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>, <code>ReplicaCount</code>,
     * and <code>Slots</code>.
     * </p>
     * <p>
     * If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you can
     * use this parameter to individually configure each node group (shard), or you can omit this parameter. However, it
     * is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file. You must configure each node
     * group (shard) using this parameter because you must specify the slots for each node group.
     * </p>
     * 
     * @return A list of node group (shard) configuration options. Each node group (shard) configuration has the
     *         following members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>,
     *         <code>ReplicaCount</code>, and <code>Slots</code>.</p>
     *         <p>
     *         If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group,
     *         you can use this parameter to individually configure each node group (shard), or you can omit this
     *         parameter. However, it is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb
     *         file. You must configure each node group (shard) using this parameter because you must specify the slots
     *         for each node group.
     */

    public java.util.List<NodeGroupConfiguration> getNodeGroupConfiguration() {
        if (nodeGroupConfiguration == null) {
            nodeGroupConfiguration = new com.amazonaws.internal.SdkInternalList<NodeGroupConfiguration>();
        }
        return nodeGroupConfiguration;
    }

    /**
     * <p>
     * A list of node group (shard) configuration options. Each node group (shard) configuration has the following
     * members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>, <code>ReplicaCount</code>,
     * and <code>Slots</code>.
     * </p>
     * <p>
     * If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you can
     * use this parameter to individually configure each node group (shard), or you can omit this parameter. However, it
     * is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file. You must configure each node
     * group (shard) using this parameter because you must specify the slots for each node group.
     * </p>
     * 
     * @param nodeGroupConfiguration
     *        A list of node group (shard) configuration options. Each node group (shard) configuration has the
     *        following members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>,
     *        <code>ReplicaCount</code>, and <code>Slots</code>.</p>
     *        <p>
     *        If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group,
     *        you can use this parameter to individually configure each node group (shard), or you can omit this
     *        parameter. However, it is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file.
     *        You must configure each node group (shard) using this parameter because you must specify the slots for
     *        each node group.
     */

    public void setNodeGroupConfiguration(java.util.Collection<NodeGroupConfiguration> nodeGroupConfiguration) {
        if (nodeGroupConfiguration == null) {
            this.nodeGroupConfiguration = null;
            return;
        }

        this.nodeGroupConfiguration = new com.amazonaws.internal.SdkInternalList<NodeGroupConfiguration>(nodeGroupConfiguration);
    }

    /**
     * <p>
     * A list of node group (shard) configuration options. Each node group (shard) configuration has the following
     * members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>, <code>ReplicaCount</code>,
     * and <code>Slots</code>.
     * </p>
     * <p>
     * If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you can
     * use this parameter to individually configure each node group (shard), or you can omit this parameter. However, it
     * is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file. You must configure each node
     * group (shard) using this parameter because you must specify the slots for each node group.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setNodeGroupConfiguration(java.util.Collection)} or
     * {@link #withNodeGroupConfiguration(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param nodeGroupConfiguration
     *        A list of node group (shard) configuration options. Each node group (shard) configuration has the
     *        following members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>,
     *        <code>ReplicaCount</code>, and <code>Slots</code>.</p>
     *        <p>
     *        If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group,
     *        you can use this parameter to individually configure each node group (shard), or you can omit this
     *        parameter. However, it is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file.
     *        You must configure each node group (shard) using this parameter because you must specify the slots for
     *        each node group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withNodeGroupConfiguration(NodeGroupConfiguration... nodeGroupConfiguration) {
        if (this.nodeGroupConfiguration == null) {
            setNodeGroupConfiguration(new com.amazonaws.internal.SdkInternalList<NodeGroupConfiguration>(nodeGroupConfiguration.length));
        }
        for (NodeGroupConfiguration ele : nodeGroupConfiguration) {
            this.nodeGroupConfiguration.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of node group (shard) configuration options. Each node group (shard) configuration has the following
     * members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>, <code>ReplicaCount</code>,
     * and <code>Slots</code>.
     * </p>
     * <p>
     * If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you can
     * use this parameter to individually configure each node group (shard), or you can omit this parameter. However, it
     * is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file. You must configure each node
     * group (shard) using this parameter because you must specify the slots for each node group.
     * </p>
     * 
     * @param nodeGroupConfiguration
     *        A list of node group (shard) configuration options. Each node group (shard) configuration has the
     *        following members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>,
     *        <code>ReplicaCount</code>, and <code>Slots</code>.</p>
     *        <p>
     *        If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group,
     *        you can use this parameter to individually configure each node group (shard), or you can omit this
     *        parameter. However, it is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file.
     *        You must configure each node group (shard) using this parameter because you must specify the slots for
     *        each node group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withNodeGroupConfiguration(java.util.Collection<NodeGroupConfiguration> nodeGroupConfiguration) {
        setNodeGroupConfiguration(nodeGroupConfiguration);
        return this;
    }

    /**
     * <p>
     * The compute and memory capacity of the nodes in the node group (shard).
     * </p>
     * <p>
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide
     * more memory and computational power at lower cost when compared to their equivalent previous generation
     * counterparts.
     * </p>
     * <ul>
     * <li>
     * <p>
     * General purpose:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>,
     * <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>,
     * <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code>
     * </p>
     * <note>
     * <p>
     * For region availability, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     * >Supported Node Types</a>
     * </p>
     * </note>
     * <p>
     * <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version
     * 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>,
     * <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>,
     * <code>cache.m6g.16xlarge</code>
     * </p>
     * <p>
     * <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>,
     * <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code>
     * </p>
     * <p>
     * <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>,
     * <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
     * </p>
     * <p>
     * <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16
     * onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code>
     * </p>
     * <p>
     * <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code>
     * </p>
     * <p>
     * <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>T1 node types:</b> <code>cache.t1.micro</code>
     * </p>
     * <p>
     * <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>,
     * <code>cache.m1.xlarge</code>
     * </p>
     * <p>
     * <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>,
     * <code>cache.m3.2xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Compute optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>C1 node types:</b> <code>cache.c1.xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Memory optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>,
     * <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>,
     * <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code>
     * </p>
     * <note>
     * <p>
     * For region availability, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     * >Supported Node Types</a>
     * </p>
     * </note>
     * <p>
     * <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version
     * 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>,
     * <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>,
     * <code>cache.r6g.16xlarge</code>
     * </p>
     * <p>
     * <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>,
     * <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code>
     * </p>
     * <p>
     * <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>,
     * <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code>
     * </p>
     * <p>
     * <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>,
     * <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * <b>Additional node type info</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All current generation instance types are created in Amazon VPC by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis append-only files (AOF) are not supported for T1 or T2 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis Multi-AZ with automatic failover is not supported on T1 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis
     * version 2.8.22 and later.
     * </p>
     * </li>
     * </ul>
     * 
     * @param cacheNodeType
     *        The compute and memory capacity of the nodes in the node group (shard).</p>
     *        <p>
     *        The following node types are supported by ElastiCache. Generally speaking, the current generation types
     *        provide more memory and computational power at lower cost when compared to their equivalent previous
     *        generation counterparts.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        General purpose:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Current generation:
     *        </p>
     *        <p>
     *        <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>,
     *        <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>,
     *        <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code>
     *        </p>
     *        <note>
     *        <p>
     *        For region availability, see <a href=
     *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     *        >Supported Node Types</a>
     *        </p>
     *        </note>
     *        <p>
     *        <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine
     *        version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>,
     *        <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>,
     *        <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code>
     *        </p>
     *        <p>
     *        <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
     *        <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
     *        <code>cache.m5.24xlarge</code>
     *        </p>
     *        <p>
     *        <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
     *        <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
     *        </p>
     *        <p>
     *        <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version
     *        1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code>
     *        </p>
     *        <p>
     *        <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>,
     *        <code>cache.t3.medium</code>
     *        </p>
     *        <p>
     *        <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>,
     *        <code>cache.t2.medium</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *        is not supported for these types.)
     *        </p>
     *        <p>
     *        <b>T1 node types:</b> <code>cache.t1.micro</code>
     *        </p>
     *        <p>
     *        <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>,
     *        <code>cache.m1.large</code>, <code>cache.m1.xlarge</code>
     *        </p>
     *        <p>
     *        <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>,
     *        <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        Compute optimized:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *        is not supported for these types.)
     *        </p>
     *        <p>
     *        <b>C1 node types:</b> <code>cache.c1.xlarge</code>
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        Memory optimized:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Current generation:
     *        </p>
     *        <p>
     *        <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>,
     *        <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>,
     *        <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code>
     *        </p>
     *        <note>
     *        <p>
     *        For region availability, see <a href=
     *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     *        >Supported Node Types</a>
     *        </p>
     *        </note>
     *        <p>
     *        <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine
     *        version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>,
     *        <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>,
     *        <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code>
     *        </p>
     *        <p>
     *        <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
     *        <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
     *        <code>cache.r5.24xlarge</code>
     *        </p>
     *        <p>
     *        <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
     *        <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
     *        <code>cache.r4.16xlarge</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *        is not supported for these types.)
     *        </p>
     *        <p>
     *        <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
     *        <code>cache.m2.4xlarge</code>
     *        </p>
     *        <p>
     *        <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
     *        <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        </ul>
     *        <p>
     *        <b>Additional node type info</b>
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        All current generation instance types are created in Amazon VPC by default.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Redis append-only files (AOF) are not supported for T1 or T2 instances.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Redis Multi-AZ with automatic failover is not supported on T1 instances.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on
     *        Redis version 2.8.22 and later.
     *        </p>
     *        </li>
     */

    public void setCacheNodeType(String cacheNodeType) {
        this.cacheNodeType = cacheNodeType;
    }

    /**
     * <p>
     * The compute and memory capacity of the nodes in the node group (shard).
     * </p>
     * <p>
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide
     * more memory and computational power at lower cost when compared to their equivalent previous generation
     * counterparts.
     * </p>
     * <ul>
     * <li>
     * <p>
     * General purpose:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>,
     * <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>,
     * <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code>
     * </p>
     * <note>
     * <p>
     * For region availability, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     * >Supported Node Types</a>
     * </p>
     * </note>
     * <p>
     * <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version
     * 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>,
     * <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>,
     * <code>cache.m6g.16xlarge</code>
     * </p>
     * <p>
     * <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>,
     * <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code>
     * </p>
     * <p>
     * <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>,
     * <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
     * </p>
     * <p>
     * <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16
     * onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code>
     * </p>
     * <p>
     * <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code>
     * </p>
     * <p>
     * <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>T1 node types:</b> <code>cache.t1.micro</code>
     * </p>
     * <p>
     * <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>,
     * <code>cache.m1.xlarge</code>
     * </p>
     * <p>
     * <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>,
     * <code>cache.m3.2xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Compute optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>C1 node types:</b> <code>cache.c1.xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Memory optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>,
     * <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>,
     * <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code>
     * </p>
     * <note>
     * <p>
     * For region availability, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     * >Supported Node Types</a>
     * </p>
     * </note>
     * <p>
     * <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version
     * 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>,
     * <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>,
     * <code>cache.r6g.16xlarge</code>
     * </p>
     * <p>
     * <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>,
     * <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code>
     * </p>
     * <p>
     * <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>,
     * <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code>
     * </p>
     * <p>
     * <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>,
     * <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * <b>Additional node type info</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All current generation instance types are created in Amazon VPC by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis append-only files (AOF) are not supported for T1 or T2 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis Multi-AZ with automatic failover is not supported on T1 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis
     * version 2.8.22 and later.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The compute and memory capacity of the nodes in the node group (shard).</p>
     *         <p>
     *         The following node types are supported by ElastiCache. Generally speaking, the current generation types
     *         provide more memory and computational power at lower cost when compared to their equivalent previous
     *         generation counterparts.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         General purpose:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Current generation:
     *         </p>
     *         <p>
     *         <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>,
     *         <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>,
     *         <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code>
     *         </p>
     *         <note>
     *         <p>
     *         For region availability, see <a href=
     *         "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     *         >Supported Node Types</a>
     *         </p>
     *         </note>
     *         <p>
     *         <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine
     *         version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>,
     *         <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>,
     *         <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code>
     *         </p>
     *         <p>
     *         <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
     *         <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
     *         <code>cache.m5.24xlarge</code>
     *         </p>
     *         <p>
     *         <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
     *         <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
     *         </p>
     *         <p>
     *         <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version
     *         1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code>
     *         </p>
     *         <p>
     *         <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>,
     *         <code>cache.t3.medium</code>
     *         </p>
     *         <p>
     *         <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>,
     *         <code>cache.t2.medium</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *         is not supported for these types.)
     *         </p>
     *         <p>
     *         <b>T1 node types:</b> <code>cache.t1.micro</code>
     *         </p>
     *         <p>
     *         <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>,
     *         <code>cache.m1.large</code>, <code>cache.m1.xlarge</code>
     *         </p>
     *         <p>
     *         <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>,
     *         <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Compute optimized:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *         is not supported for these types.)
     *         </p>
     *         <p>
     *         <b>C1 node types:</b> <code>cache.c1.xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Memory optimized:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Current generation:
     *         </p>
     *         <p>
     *         <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>,
     *         <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>,
     *         <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code>
     *         </p>
     *         <note>
     *         <p>
     *         For region availability, see <a href=
     *         "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     *         >Supported Node Types</a>
     *         </p>
     *         </note>
     *         <p>
     *         <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine
     *         version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>,
     *         <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>,
     *         <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code>
     *         </p>
     *         <p>
     *         <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
     *         <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
     *         <code>cache.r5.24xlarge</code>
     *         </p>
     *         <p>
     *         <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
     *         <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
     *         <code>cache.r4.16xlarge</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *         is not supported for these types.)
     *         </p>
     *         <p>
     *         <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
     *         <code>cache.m2.4xlarge</code>
     *         </p>
     *         <p>
     *         <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
     *         <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Additional node type info</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         All current generation instance types are created in Amazon VPC by default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis append-only files (AOF) are not supported for T1 or T2 instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis Multi-AZ with automatic failover is not supported on T1 instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on
     *         Redis version 2.8.22 and later.
     *         </p>
     *         </li>
     */

    public String getCacheNodeType() {
        return this.cacheNodeType;
    }

    /**
     * <p>
     * The compute and memory capacity of the nodes in the node group (shard).
     * </p>
     * <p>
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide
     * more memory and computational power at lower cost when compared to their equivalent previous generation
     * counterparts.
     * </p>
     * <ul>
     * <li>
     * <p>
     * General purpose:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>,
     * <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>,
     * <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code>
     * </p>
     * <note>
     * <p>
     * For region availability, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     * >Supported Node Types</a>
     * </p>
     * </note>
     * <p>
     * <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version
     * 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>,
     * <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>,
     * <code>cache.m6g.16xlarge</code>
     * </p>
     * <p>
     * <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>,
     * <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code>
     * </p>
     * <p>
     * <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>,
     * <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
     * </p>
     * <p>
     * <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16
     * onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code>
     * </p>
     * <p>
     * <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code>
     * </p>
     * <p>
     * <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>T1 node types:</b> <code>cache.t1.micro</code>
     * </p>
     * <p>
     * <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>,
     * <code>cache.m1.xlarge</code>
     * </p>
     * <p>
     * <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>,
     * <code>cache.m3.2xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Compute optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>C1 node types:</b> <code>cache.c1.xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Memory optimized:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Current generation:
     * </p>
     * <p>
     * <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>,
     * <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>,
     * <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code>
     * </p>
     * <note>
     * <p>
     * For region availability, see <a href=
     * "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     * >Supported Node Types</a>
     * </p>
     * </note>
     * <p>
     * <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine version
     * 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>,
     * <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>,
     * <code>cache.r6g.16xlarge</code>
     * </p>
     * <p>
     * <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>,
     * <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code>
     * </p>
     * <p>
     * <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>,
     * <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not
     * supported for these types.)
     * </p>
     * <p>
     * <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code>
     * </p>
     * <p>
     * <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>,
     * <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * <b>Additional node type info</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * All current generation instance types are created in Amazon VPC by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis append-only files (AOF) are not supported for T1 or T2 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis Multi-AZ with automatic failover is not supported on T1 instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis
     * version 2.8.22 and later.
     * </p>
     * </li>
     * </ul>
     * 
     * @param cacheNodeType
     *        The compute and memory capacity of the nodes in the node group (shard).</p>
     *        <p>
     *        The following node types are supported by ElastiCache. Generally speaking, the current generation types
     *        provide more memory and computational power at lower cost when compared to their equivalent previous
     *        generation counterparts.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        General purpose:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Current generation:
     *        </p>
     *        <p>
     *        <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>,
     *        <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>,
     *        <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code>
     *        </p>
     *        <note>
     *        <p>
     *        For region availability, see <a href=
     *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     *        >Supported Node Types</a>
     *        </p>
     *        </note>
     *        <p>
     *        <b>M6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine
     *        version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>,
     *        <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>,
     *        <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code>
     *        </p>
     *        <p>
     *        <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>,
     *        <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>,
     *        <code>cache.m5.24xlarge</code>
     *        </p>
     *        <p>
     *        <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>,
     *        <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code>
     *        </p>
     *        <p>
     *        <b>T4g node types</b> (available only for Redis engine version 5.0.6 onward and Memcached engine version
     *        1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code>
     *        </p>
     *        <p>
     *        <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>,
     *        <code>cache.t3.medium</code>
     *        </p>
     *        <p>
     *        <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>,
     *        <code>cache.t2.medium</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *        is not supported for these types.)
     *        </p>
     *        <p>
     *        <b>T1 node types:</b> <code>cache.t1.micro</code>
     *        </p>
     *        <p>
     *        <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>,
     *        <code>cache.m1.large</code>, <code>cache.m1.xlarge</code>
     *        </p>
     *        <p>
     *        <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>,
     *        <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code>
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        Compute optimized:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *        is not supported for these types.)
     *        </p>
     *        <p>
     *        <b>C1 node types:</b> <code>cache.c1.xlarge</code>
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        <li>
     *        <p>
     *        Memory optimized:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Current generation:
     *        </p>
     *        <p>
     *        <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>,
     *        <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>,
     *        <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code>
     *        </p>
     *        <note>
     *        <p>
     *        For region availability, see <a href=
     *        "https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion"
     *        >Supported Node Types</a>
     *        </p>
     *        </note>
     *        <p>
     *        <b>R6g node types</b> (available only for Redis engine version 5.0.6 onward and for Memcached engine
     *        version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>,
     *        <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>,
     *        <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code>
     *        </p>
     *        <p>
     *        <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>,
     *        <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>,
     *        <code>cache.r5.24xlarge</code>
     *        </p>
     *        <p>
     *        <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>,
     *        <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>,
     *        <code>cache.r4.16xlarge</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters
     *        is not supported for these types.)
     *        </p>
     *        <p>
     *        <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>,
     *        <code>cache.m2.4xlarge</code>
     *        </p>
     *        <p>
     *        <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>,
     *        <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code>
     *        </p>
     *        </li>
     *        </ul>
     *        </li>
     *        </ul>
     *        <p>
     *        <b>Additional node type info</b>
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        All current generation instance types are created in Amazon VPC by default.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Redis append-only files (AOF) are not supported for T1 or T2 instances.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Redis Multi-AZ with automatic failover is not supported on T1 instances.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on
     *        Redis version 2.8.22 and later.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withCacheNodeType(String cacheNodeType) {
        setCacheNodeType(cacheNodeType);
        return this;
    }

    /**
     * <p>
     * The name of the cache engine to be used for the clusters in this replication group. The value must be set to
     * <code>Redis</code>.
     * </p>
     * 
     * @param engine
     *        The name of the cache engine to be used for the clusters in this replication group. The value must be set
     *        to <code>Redis</code>.
     */

    public void setEngine(String engine) {
        this.engine = engine;
    }

    /**
     * <p>
     * The name of the cache engine to be used for the clusters in this replication group. The value must be set to
     * <code>Redis</code>.
     * </p>
     * 
     * @return The name of the cache engine to be used for the clusters in this replication group. The value must be set
     *         to <code>Redis</code>.
     */

    public String getEngine() {
        return this.engine;
    }

    /**
     * <p>
     * The name of the cache engine to be used for the clusters in this replication group. The value must be set to
     * <code>Redis</code>.
     * </p>
     * 
     * @param engine
     *        The name of the cache engine to be used for the clusters in this replication group. The value must be set
     *        to <code>Redis</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withEngine(String engine) {
        setEngine(engine);
        return this;
    }

    /**
     * <p>
     * The version number of the cache engine to be used for the clusters in this replication group. To view the
     * supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.
     * </p>
     * <p>
     * <b>Important:</b> You can upgrade to a newer engine version (see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting
     * a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade to an earlier
     * engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication
     * group and create it anew with the earlier engine version.
     * </p>
     * 
     * @param engineVersion
     *        The version number of the cache engine to be used for the clusters in this replication group. To view the
     *        supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.</p>
     *        <p>
     *        <b>Important:</b> You can upgrade to a newer engine version (see <a
     *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
     *        >Selecting a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade
     *        to an earlier engine version. If you want to use an earlier engine version, you must delete the existing
     *        cluster or replication group and create it anew with the earlier engine version.
     */

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    /**
     * <p>
     * The version number of the cache engine to be used for the clusters in this replication group. To view the
     * supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.
     * </p>
     * <p>
     * <b>Important:</b> You can upgrade to a newer engine version (see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting
     * a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade to an earlier
     * engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication
     * group and create it anew with the earlier engine version.
     * </p>
     * 
     * @return The version number of the cache engine to be used for the clusters in this replication group. To view the
     *         supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.</p>
     *         <p>
     *         <b>Important:</b> You can upgrade to a newer engine version (see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
     *         >Selecting a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade
     *         to an earlier engine version. If you want to use an earlier engine version, you must delete the existing
     *         cluster or replication group and create it anew with the earlier engine version.
     */

    public String getEngineVersion() {
        return this.engineVersion;
    }

    /**
     * <p>
     * The version number of the cache engine to be used for the clusters in this replication group. To view the
     * supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.
     * </p>
     * <p>
     * <b>Important:</b> You can upgrade to a newer engine version (see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting
     * a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade to an earlier
     * engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication
     * group and create it anew with the earlier engine version.
     * </p>
     * 
     * @param engineVersion
     *        The version number of the cache engine to be used for the clusters in this replication group. To view the
     *        supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.</p>
     *        <p>
     *        <b>Important:</b> You can upgrade to a newer engine version (see <a
     *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement"
     *        >Selecting a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade
     *        to an earlier engine version. If you want to use an earlier engine version, you must delete the existing
     *        cluster or replication group and create it anew with the earlier engine version.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withEngineVersion(String engineVersion) {
        setEngineVersion(engineVersion);
        return this;
    }

    /**
     * <p>
     * The name of the parameter group to associate with this replication group. If this argument is omitted, the
     * default cache parameter group for the specified engine is used.
     * </p>
     * <p>
     * If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter
     * group, we recommend that you specify the parameter group by name.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a Redis (cluster mode disabled) replication group, use
     * <code>CacheParameterGroupName=default.redis3.2</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a Redis (cluster mode enabled) replication group, use
     * <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param cacheParameterGroupName
     *        The name of the parameter group to associate with this replication group. If this argument is omitted, the
     *        default cache parameter group for the specified engine is used.</p>
     *        <p>
     *        If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default
     *        parameter group, we recommend that you specify the parameter group by name.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        To create a Redis (cluster mode disabled) replication group, use
     *        <code>CacheParameterGroupName=default.redis3.2</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        To create a Redis (cluster mode enabled) replication group, use
     *        <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.
     *        </p>
     *        </li>
     */

    public void setCacheParameterGroupName(String cacheParameterGroupName) {
        this.cacheParameterGroupName = cacheParameterGroupName;
    }

    /**
     * <p>
     * The name of the parameter group to associate with this replication group. If this argument is omitted, the
     * default cache parameter group for the specified engine is used.
     * </p>
     * <p>
     * If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter
     * group, we recommend that you specify the parameter group by name.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a Redis (cluster mode disabled) replication group, use
     * <code>CacheParameterGroupName=default.redis3.2</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a Redis (cluster mode enabled) replication group, use
     * <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the parameter group to associate with this replication group. If this argument is omitted,
     *         the default cache parameter group for the specified engine is used.</p>
     *         <p>
     *         If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default
     *         parameter group, we recommend that you specify the parameter group by name.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To create a Redis (cluster mode disabled) replication group, use
     *         <code>CacheParameterGroupName=default.redis3.2</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To create a Redis (cluster mode enabled) replication group, use
     *         <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.
     *         </p>
     *         </li>
     */

    public String getCacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    /**
     * <p>
     * The name of the parameter group to associate with this replication group. If this argument is omitted, the
     * default cache parameter group for the specified engine is used.
     * </p>
     * <p>
     * If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter
     * group, we recommend that you specify the parameter group by name.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a Redis (cluster mode disabled) replication group, use
     * <code>CacheParameterGroupName=default.redis3.2</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a Redis (cluster mode enabled) replication group, use
     * <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param cacheParameterGroupName
     *        The name of the parameter group to associate with this replication group. If this argument is omitted, the
     *        default cache parameter group for the specified engine is used.</p>
     *        <p>
     *        If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default
     *        parameter group, we recommend that you specify the parameter group by name.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        To create a Redis (cluster mode disabled) replication group, use
     *        <code>CacheParameterGroupName=default.redis3.2</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        To create a Redis (cluster mode enabled) replication group, use
     *        <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withCacheParameterGroupName(String cacheParameterGroupName) {
        setCacheParameterGroupName(cacheParameterGroupName);
        return this;
    }

    /**
     * <p>
     * The name of the cache subnet group to be used for the replication group.
     * </p>
     * <important>
     * <p>
     * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start
     * creating a cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet
     * Groups</a>.
     * </p>
     * </important>
     * 
     * @param cacheSubnetGroupName
     *        The name of the cache subnet group to be used for the replication group.</p> <important>
     *        <p>
     *        If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you
     *        start creating a cluster. For more information, see <a
     *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet
     *        Groups</a>.
     *        </p>
     */

    public void setCacheSubnetGroupName(String cacheSubnetGroupName) {
        this.cacheSubnetGroupName = cacheSubnetGroupName;
    }

    /**
     * <p>
     * The name of the cache subnet group to be used for the replication group.
     * </p>
     * <important>
     * <p>
     * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start
     * creating a cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet
     * Groups</a>.
     * </p>
     * </important>
     * 
     * @return The name of the cache subnet group to be used for the replication group.</p> <important>
     *         <p>
     *         If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you
     *         start creating a cluster. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet
     *         Groups</a>.
     *         </p>
     */

    public String getCacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    /**
     * <p>
     * The name of the cache subnet group to be used for the replication group.
     * </p>
     * <important>
     * <p>
     * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start
     * creating a cluster. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet
     * Groups</a>.
     * </p>
     * </important>
     * 
     * @param cacheSubnetGroupName
     *        The name of the cache subnet group to be used for the replication group.</p> <important>
     *        <p>
     *        If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you
     *        start creating a cluster. For more information, see <a
     *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet
     *        Groups</a>.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withCacheSubnetGroupName(String cacheSubnetGroupName) {
        setCacheSubnetGroupName(cacheSubnetGroupName);
        return this;
    }

    /**
     * <p>
     * A list of cache security group names to associate with this replication group.
     * </p>
     * 
     * @return A list of cache security group names to associate with this replication group.
     */

    public java.util.List<String> getCacheSecurityGroupNames() {
        if (cacheSecurityGroupNames == null) {
            cacheSecurityGroupNames = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return cacheSecurityGroupNames;
    }

    /**
     * <p>
     * A list of cache security group names to associate with this replication group.
     * </p>
     * 
     * @param cacheSecurityGroupNames
     *        A list of cache security group names to associate with this replication group.
     */

    public void setCacheSecurityGroupNames(java.util.Collection<String> cacheSecurityGroupNames) {
        if (cacheSecurityGroupNames == null) {
            this.cacheSecurityGroupNames = null;
            return;
        }

        this.cacheSecurityGroupNames = new com.amazonaws.internal.SdkInternalList<String>(cacheSecurityGroupNames);
    }

    /**
     * <p>
     * A list of cache security group names to associate with this replication group.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setCacheSecurityGroupNames(java.util.Collection)} or
     * {@link #withCacheSecurityGroupNames(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param cacheSecurityGroupNames
     *        A list of cache security group names to associate with this replication group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withCacheSecurityGroupNames(String... cacheSecurityGroupNames) {
        if (this.cacheSecurityGroupNames == null) {
            setCacheSecurityGroupNames(new com.amazonaws.internal.SdkInternalList<String>(cacheSecurityGroupNames.length));
        }
        for (String ele : cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of cache security group names to associate with this replication group.
     * </p>
     * 
     * @param cacheSecurityGroupNames
     *        A list of cache security group names to associate with this replication group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withCacheSecurityGroupNames(java.util.Collection<String> cacheSecurityGroupNames) {
        setCacheSecurityGroupNames(cacheSecurityGroupNames);
        return this;
    }

    /**
     * <p>
     * One or more Amazon VPC security groups associated with this replication group.
     * </p>
     * <p>
     * Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon
     * VPC).
     * </p>
     * 
     * @return One or more Amazon VPC security groups associated with this replication group.</p>
     *         <p>
     *         Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud
     *         (Amazon VPC).
     */

    public java.util.List<String> getSecurityGroupIds() {
        if (securityGroupIds == null) {
            securityGroupIds = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return securityGroupIds;
    }

    /**
     * <p>
     * One or more Amazon VPC security groups associated with this replication group.
     * </p>
     * <p>
     * Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon
     * VPC).
     * </p>
     * 
     * @param securityGroupIds
     *        One or more Amazon VPC security groups associated with this replication group.</p>
     *        <p>
     *        Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud
     *        (Amazon VPC).
     */

    public void setSecurityGroupIds(java.util.Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }

        this.securityGroupIds = new com.amazonaws.internal.SdkInternalList<String>(securityGroupIds);
    }

    /**
     * <p>
     * One or more Amazon VPC security groups associated with this replication group.
     * </p>
     * <p>
     * Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon
     * VPC).
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSecurityGroupIds(java.util.Collection)} or {@link #withSecurityGroupIds(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param securityGroupIds
     *        One or more Amazon VPC security groups associated with this replication group.</p>
     *        <p>
     *        Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud
     *        (Amazon VPC).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withSecurityGroupIds(String... securityGroupIds) {
        if (this.securityGroupIds == null) {
            setSecurityGroupIds(new com.amazonaws.internal.SdkInternalList<String>(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * One or more Amazon VPC security groups associated with this replication group.
     * </p>
     * <p>
     * Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon
     * VPC).
     * </p>
     * 
     * @param securityGroupIds
     *        One or more Amazon VPC security groups associated with this replication group.</p>
     *        <p>
     *        Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud
     *        (Amazon VPC).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withSecurityGroupIds(java.util.Collection<String> securityGroupIds) {
        setSecurityGroupIds(securityGroupIds);
        return this;
    }

    /**
     * <p>
     * A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=
     * <code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=
     * <code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
     * <code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.
     * </p>
     * 
     * @return A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=
     *         <code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=
     *         <code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
     *         <code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.
     */

    public java.util.List<Tag> getTags() {
        if (tags == null) {
            tags = new com.amazonaws.internal.SdkInternalList<Tag>();
        }
        return tags;
    }

    /**
     * <p>
     * A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=
     * <code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=
     * <code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
     * <code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.
     * </p>
     * 
     * @param tags
     *        A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=
     *        <code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=
     *        <code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
     *        <code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new com.amazonaws.internal.SdkInternalList<Tag>(tags);
    }

    /**
     * <p>
     * A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=
     * <code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=
     * <code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
     * <code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=
     *        <code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=
     *        <code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
     *        <code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new com.amazonaws.internal.SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=
     * <code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=
     * <code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
     * <code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.
     * </p>
     * 
     * @param tags
     *        A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=
     *        <code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=
     *        <code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=
     *        <code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * <p>
     * A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3.
     * The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot
     * contain any commas. The new replication group will have the number of node groups (console: shards) specified by
     * the parameter <i>NumNodeGroups</i> or the number of node groups configured by <i>NodeGroupConfiguration</i>
     * regardless of the number of ARNs specified here.
     * </p>
     * <p>
     * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     * </p>
     * 
     * @return A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in
     *         Amazon S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name
     *         in the ARN cannot contain any commas. The new replication group will have the number of node groups
     *         (console: shards) specified by the parameter <i>NumNodeGroups</i> or the number of node groups configured
     *         by <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.</p>
     *         <p>
     *         Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     */

    public java.util.List<String> getSnapshotArns() {
        if (snapshotArns == null) {
            snapshotArns = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return snapshotArns;
    }

    /**
     * <p>
     * A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3.
     * The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot
     * contain any commas. The new replication group will have the number of node groups (console: shards) specified by
     * the parameter <i>NumNodeGroups</i> or the number of node groups configured by <i>NodeGroupConfiguration</i>
     * regardless of the number of ARNs specified here.
     * </p>
     * <p>
     * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     * </p>
     * 
     * @param snapshotArns
     *        A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon
     *        S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name in the
     *        ARN cannot contain any commas. The new replication group will have the number of node groups (console:
     *        shards) specified by the parameter <i>NumNodeGroups</i> or the number of node groups configured by
     *        <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.</p>
     *        <p>
     *        Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     */

    public void setSnapshotArns(java.util.Collection<String> snapshotArns) {
        if (snapshotArns == null) {
            this.snapshotArns = null;
            return;
        }

        this.snapshotArns = new com.amazonaws.internal.SdkInternalList<String>(snapshotArns);
    }

    /**
     * <p>
     * A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3.
     * The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot
     * contain any commas. The new replication group will have the number of node groups (console: shards) specified by
     * the parameter <i>NumNodeGroups</i> or the number of node groups configured by <i>NodeGroupConfiguration</i>
     * regardless of the number of ARNs specified here.
     * </p>
     * <p>
     * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSnapshotArns(java.util.Collection)} or {@link #withSnapshotArns(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param snapshotArns
     *        A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon
     *        S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name in the
     *        ARN cannot contain any commas. The new replication group will have the number of node groups (console:
     *        shards) specified by the parameter <i>NumNodeGroups</i> or the number of node groups configured by
     *        <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.</p>
     *        <p>
     *        Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withSnapshotArns(String... snapshotArns) {
        if (this.snapshotArns == null) {
            setSnapshotArns(new com.amazonaws.internal.SdkInternalList<String>(snapshotArns.length));
        }
        for (String ele : snapshotArns) {
            this.snapshotArns.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3.
     * The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot
     * contain any commas. The new replication group will have the number of node groups (console: shards) specified by
     * the parameter <i>NumNodeGroups</i> or the number of node groups configured by <i>NodeGroupConfiguration</i>
     * regardless of the number of ARNs specified here.
     * </p>
     * <p>
     * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     * </p>
     * 
     * @param snapshotArns
     *        A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon
     *        S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name in the
     *        ARN cannot contain any commas. The new replication group will have the number of node groups (console:
     *        shards) specified by the parameter <i>NumNodeGroups</i> or the number of node groups configured by
     *        <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.</p>
     *        <p>
     *        Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withSnapshotArns(java.util.Collection<String> snapshotArns) {
        setSnapshotArns(snapshotArns);
        return this;
    }

    /**
     * <p>
     * The name of a snapshot from which to restore data into the new replication group. The snapshot status changes to
     * <code>restoring</code> while the new replication group is being created.
     * </p>
     * 
     * @param snapshotName
     *        The name of a snapshot from which to restore data into the new replication group. The snapshot status
     *        changes to <code>restoring</code> while the new replication group is being created.
     */

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    /**
     * <p>
     * The name of a snapshot from which to restore data into the new replication group. The snapshot status changes to
     * <code>restoring</code> while the new replication group is being created.
     * </p>
     * 
     * @return The name of a snapshot from which to restore data into the new replication group. The snapshot status
     *         changes to <code>restoring</code> while the new replication group is being created.
     */

    public String getSnapshotName() {
        return this.snapshotName;
    }

    /**
     * <p>
     * The name of a snapshot from which to restore data into the new replication group. The snapshot status changes to
     * <code>restoring</code> while the new replication group is being created.
     * </p>
     * 
     * @param snapshotName
     *        The name of a snapshot from which to restore data into the new replication group. The snapshot status
     *        changes to <code>restoring</code> while the new replication group is being created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withSnapshotName(String snapshotName) {
        setSnapshotName(snapshotName);
        return this;
    }

    /**
     * <p>
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range
     * in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * </p>
     * <p>
     * Valid values for <code>ddd</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sun</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mon</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tue</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>wed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>thu</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fri</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sat</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>sun:23:00-mon:01:30</code>
     * </p>
     * 
     * @param preferredMaintenanceWindow
     *        Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a
     *        range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
     *        period.</p>
     *        <p>
     *        Valid values for <code>ddd</code> are:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>sun</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>mon</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>tue</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>wed</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>thu</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>fri</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>sat</code>
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        Example: <code>sun:23:00-mon:01:30</code>
     */

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    /**
     * <p>
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range
     * in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * </p>
     * <p>
     * Valid values for <code>ddd</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sun</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mon</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tue</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>wed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>thu</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fri</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sat</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>sun:23:00-mon:01:30</code>
     * </p>
     * 
     * @return Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as
     *         a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60
     *         minute period.</p>
     *         <p>
     *         Valid values for <code>ddd</code> are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sun</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mon</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tue</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>wed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>thu</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fri</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sat</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>sun:23:00-mon:01:30</code>
     */

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    /**
     * <p>
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range
     * in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * </p>
     * <p>
     * Valid values for <code>ddd</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sun</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mon</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tue</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>wed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>thu</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fri</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sat</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>sun:23:00-mon:01:30</code>
     * </p>
     * 
     * @param preferredMaintenanceWindow
     *        Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a
     *        range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute
     *        period.</p>
     *        <p>
     *        Valid values for <code>ddd</code> are:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>sun</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>mon</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>tue</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>wed</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>thu</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>fri</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>sat</code>
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        Example: <code>sun:23:00-mon:01:30</code>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        setPreferredMaintenanceWindow(preferredMaintenanceWindow);
        return this;
    }

    /**
     * <p>
     * The port number on which each member of the replication group accepts connections.
     * </p>
     * 
     * @param port
     *        The port number on which each member of the replication group accepts connections.
     */

    public void setPort(Integer port) {
        this.port = port;
    }

    /**
     * <p>
     * The port number on which each member of the replication group accepts connections.
     * </p>
     * 
     * @return The port number on which each member of the replication group accepts connections.
     */

    public Integer getPort() {
        return this.port;
    }

    /**
     * <p>
     * The port number on which each member of the replication group accepts connections.
     * </p>
     * 
     * @param port
     *        The port number on which each member of the replication group accepts connections.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withPort(Integer port) {
        setPort(port);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are
     * sent.
     * </p>
     * <note>
     * <p>
     * The Amazon SNS topic owner must be the same as the cluster owner.
     * </p>
     * </note>
     * 
     * @param notificationTopicArn
     *        The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which
     *        notifications are sent.</p> <note>
     *        <p>
     *        The Amazon SNS topic owner must be the same as the cluster owner.
     *        </p>
     */

    public void setNotificationTopicArn(String notificationTopicArn) {
        this.notificationTopicArn = notificationTopicArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are
     * sent.
     * </p>
     * <note>
     * <p>
     * The Amazon SNS topic owner must be the same as the cluster owner.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which
     *         notifications are sent.</p> <note>
     *         <p>
     *         The Amazon SNS topic owner must be the same as the cluster owner.
     *         </p>
     */

    public String getNotificationTopicArn() {
        return this.notificationTopicArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are
     * sent.
     * </p>
     * <note>
     * <p>
     * The Amazon SNS topic owner must be the same as the cluster owner.
     * </p>
     * </note>
     * 
     * @param notificationTopicArn
     *        The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which
     *        notifications are sent.</p> <note>
     *        <p>
     *        The Amazon SNS topic owner must be the same as the cluster owner.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withNotificationTopicArn(String notificationTopicArn) {
        setNotificationTopicArn(notificationTopicArn);
        return this;
    }

    /**
     * <p>
     *  If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the
     * next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
     * </p>
     * 
     * @param autoMinorVersionUpgrade
     *         If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to
     *        the next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
     */

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    /**
     * <p>
     *  If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the
     * next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
     * </p>
     * 
     * @return  If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to
     *         the next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
     */

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    /**
     * <p>
     *  If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the
     * next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
     * </p>
     * 
     * @param autoMinorVersionUpgrade
     *         If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to
     *        the next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        setAutoMinorVersionUpgrade(autoMinorVersionUpgrade);
        return this;
    }

    /**
     * <p>
     *  If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the
     * next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
     * </p>
     * 
     * @return  If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to
     *         the next auto minor version upgrade campaign. This parameter is disabled for previous versions. 
     */

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you
     * set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being
     * deleted.
     * </p>
     * <p>
     * Default: 0 (i.e., automatic backups are disabled for this cluster).
     * </p>
     * 
     * @param snapshotRetentionLimit
     *        The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if
     *        you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days
     *        before being deleted.</p>
     *        <p>
     *        Default: 0 (i.e., automatic backups are disabled for this cluster).
     */

    public void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.snapshotRetentionLimit = snapshotRetentionLimit;
    }

    /**
     * <p>
     * The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you
     * set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being
     * deleted.
     * </p>
     * <p>
     * Default: 0 (i.e., automatic backups are disabled for this cluster).
     * </p>
     * 
     * @return The number of days for which ElastiCache retains automatic snapshots before deleting them. For example,
     *         if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5
     *         days before being deleted.</p>
     *         <p>
     *         Default: 0 (i.e., automatic backups are disabled for this cluster).
     */

    public Integer getSnapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    /**
     * <p>
     * The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you
     * set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being
     * deleted.
     * </p>
     * <p>
     * Default: 0 (i.e., automatic backups are disabled for this cluster).
     * </p>
     * 
     * @param snapshotRetentionLimit
     *        The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if
     *        you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days
     *        before being deleted.</p>
     *        <p>
     *        Default: 0 (i.e., automatic backups are disabled for this cluster).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        setSnapshotRetentionLimit(snapshotRetentionLimit);
        return this;
    }

    /**
     * <p>
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
     * </p>
     * <p>
     * Example: <code>05:00-09:00</code>
     * </p>
     * <p>
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     * </p>
     * 
     * @param snapshotWindow
     *        The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group
     *        (shard).</p>
     *        <p>
     *        Example: <code>05:00-09:00</code>
     *        </p>
     *        <p>
     *        If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     */

    public void setSnapshotWindow(String snapshotWindow) {
        this.snapshotWindow = snapshotWindow;
    }

    /**
     * <p>
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
     * </p>
     * <p>
     * Example: <code>05:00-09:00</code>
     * </p>
     * <p>
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     * </p>
     * 
     * @return The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group
     *         (shard).</p>
     *         <p>
     *         Example: <code>05:00-09:00</code>
     *         </p>
     *         <p>
     *         If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     */

    public String getSnapshotWindow() {
        return this.snapshotWindow;
    }

    /**
     * <p>
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
     * </p>
     * <p>
     * Example: <code>05:00-09:00</code>
     * </p>
     * <p>
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     * </p>
     * 
     * @param snapshotWindow
     *        The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group
     *        (shard).</p>
     *        <p>
     *        Example: <code>05:00-09:00</code>
     *        </p>
     *        <p>
     *        If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withSnapshotWindow(String snapshotWindow) {
        setSnapshotWindow(snapshotWindow);
        return this;
    }

    /**
     * <p>
     * <b>Reserved parameter.</b> The password used to access a password protected server.
     * </p>
     * <p>
     * <code>AuthToken</code> can be specified only on replication groups where <code>TransitEncryptionEnabled</code> is
     * <code>true</code>.
     * </p>
     * <important>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     * <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     * </p>
     * </important>
     * <p>
     * Password constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be only printable ASCII characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 16 characters and no more than 128 characters in length.
     * </p>
     * </li>
     * <li>
     * <p>
     * The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special
     * characters cannot be used in the AUTH token.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
     * http://redis.io/commands/AUTH.
     * </p>
     * 
     * @param authToken
     *        <b>Reserved parameter.</b> The password used to access a password protected server.</p>
     *        <p>
     *        <code>AuthToken</code> can be specified only on replication groups where
     *        <code>TransitEncryptionEnabled</code> is <code>true</code>.
     *        </p>
     *        <important>
     *        <p>
     *        For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     *        <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     *        </p>
     *        </important>
     *        <p>
     *        Password constraints:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Must be only printable ASCII characters.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Must be at least 16 characters and no more than 128 characters in length.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable
     *        special characters cannot be used in the AUTH token.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
     *        http://redis.io/commands/AUTH.
     */

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    /**
     * <p>
     * <b>Reserved parameter.</b> The password used to access a password protected server.
     * </p>
     * <p>
     * <code>AuthToken</code> can be specified only on replication groups where <code>TransitEncryptionEnabled</code> is
     * <code>true</code>.
     * </p>
     * <important>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     * <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     * </p>
     * </important>
     * <p>
     * Password constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be only printable ASCII characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 16 characters and no more than 128 characters in length.
     * </p>
     * </li>
     * <li>
     * <p>
     * The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special
     * characters cannot be used in the AUTH token.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
     * http://redis.io/commands/AUTH.
     * </p>
     * 
     * @return <b>Reserved parameter.</b> The password used to access a password protected server.</p>
     *         <p>
     *         <code>AuthToken</code> can be specified only on replication groups where
     *         <code>TransitEncryptionEnabled</code> is <code>true</code>.
     *         </p>
     *         <important>
     *         <p>
     *         For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     *         <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     *         </p>
     *         </important>
     *         <p>
     *         Password constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be only printable ASCII characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 16 characters and no more than 128 characters in length.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable
     *         special characters cannot be used in the AUTH token.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
     *         http://redis.io/commands/AUTH.
     */

    public String getAuthToken() {
        return this.authToken;
    }

    /**
     * <p>
     * <b>Reserved parameter.</b> The password used to access a password protected server.
     * </p>
     * <p>
     * <code>AuthToken</code> can be specified only on replication groups where <code>TransitEncryptionEnabled</code> is
     * <code>true</code>.
     * </p>
     * <important>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     * <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     * </p>
     * </important>
     * <p>
     * Password constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be only printable ASCII characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 16 characters and no more than 128 characters in length.
     * </p>
     * </li>
     * <li>
     * <p>
     * The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special
     * characters cannot be used in the AUTH token.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
     * http://redis.io/commands/AUTH.
     * </p>
     * 
     * @param authToken
     *        <b>Reserved parameter.</b> The password used to access a password protected server.</p>
     *        <p>
     *        <code>AuthToken</code> can be specified only on replication groups where
     *        <code>TransitEncryptionEnabled</code> is <code>true</code>.
     *        </p>
     *        <important>
     *        <p>
     *        For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     *        <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     *        </p>
     *        </important>
     *        <p>
     *        Password constraints:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Must be only printable ASCII characters.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Must be at least 16 characters and no more than 128 characters in length.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable
     *        special characters cannot be used in the AUTH token.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at
     *        http://redis.io/commands/AUTH.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withAuthToken(String authToken) {
        setAuthToken(authToken);
        return this;
    }

    /**
     * <p>
     * A flag that enables in-transit encryption when set to <code>true</code>.
     * </p>
     * <p>
     * This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the
     * <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is being
     * created in an Amazon VPC.
     * </p>
     * <p>
     * If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * <important>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     * <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     * </p>
     * </important>
     * 
     * @param transitEncryptionEnabled
     *        A flag that enables in-transit encryption when set to <code>true</code>.</p>
     *        <p>
     *        This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the
     *        <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is
     *        being created in an Amazon VPC.
     *        </p>
     *        <p>
     *        If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.
     *        </p>
     *        <p>
     *        <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     *        <code>3.2.6</code>, <code>4.x</code> or later.
     *        </p>
     *        <p>
     *        Default: <code>false</code>
     *        </p>
     *        <important>
     *        <p>
     *        For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     *        <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     *        </p>
     */

    public void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
        this.transitEncryptionEnabled = transitEncryptionEnabled;
    }

    /**
     * <p>
     * A flag that enables in-transit encryption when set to <code>true</code>.
     * </p>
     * <p>
     * This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the
     * <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is being
     * created in an Amazon VPC.
     * </p>
     * <p>
     * If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * <important>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     * <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     * </p>
     * </important>
     * 
     * @return A flag that enables in-transit encryption when set to <code>true</code>.</p>
     *         <p>
     *         This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the
     *         <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is
     *         being created in an Amazon VPC.
     *         </p>
     *         <p>
     *         If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.
     *         </p>
     *         <p>
     *         <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     *         <code>3.2.6</code>, <code>4.x</code> or later.
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     *         </p>
     *         <important>
     *         <p>
     *         For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     *         <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     *         </p>
     */

    public Boolean getTransitEncryptionEnabled() {
        return this.transitEncryptionEnabled;
    }

    /**
     * <p>
     * A flag that enables in-transit encryption when set to <code>true</code>.
     * </p>
     * <p>
     * This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the
     * <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is being
     * created in an Amazon VPC.
     * </p>
     * <p>
     * If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * <important>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     * <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     * </p>
     * </important>
     * 
     * @param transitEncryptionEnabled
     *        A flag that enables in-transit encryption when set to <code>true</code>.</p>
     *        <p>
     *        This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the
     *        <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is
     *        being created in an Amazon VPC.
     *        </p>
     *        <p>
     *        If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.
     *        </p>
     *        <p>
     *        <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     *        <code>3.2.6</code>, <code>4.x</code> or later.
     *        </p>
     *        <p>
     *        Default: <code>false</code>
     *        </p>
     *        <important>
     *        <p>
     *        For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     *        <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
        setTransitEncryptionEnabled(transitEncryptionEnabled);
        return this;
    }

    /**
     * <p>
     * A flag that enables in-transit encryption when set to <code>true</code>.
     * </p>
     * <p>
     * This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the
     * <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is being
     * created in an Amazon VPC.
     * </p>
     * <p>
     * If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * <important>
     * <p>
     * For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     * <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     * </p>
     * </important>
     * 
     * @return A flag that enables in-transit encryption when set to <code>true</code>.</p>
     *         <p>
     *         This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the
     *         <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is
     *         being created in an Amazon VPC.
     *         </p>
     *         <p>
     *         If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.
     *         </p>
     *         <p>
     *         <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     *         <code>3.2.6</code>, <code>4.x</code> or later.
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     *         </p>
     *         <important>
     *         <p>
     *         For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an
     *         <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.
     *         </p>
     */

    public Boolean isTransitEncryptionEnabled() {
        return this.transitEncryptionEnabled;
    }

    /**
     * <p>
     * A flag that enables encryption at rest when set to <code>true</code>.
     * </p>
     * <p>
     * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To
     * enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to
     * <code>true</code> when you create the replication group.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @param atRestEncryptionEnabled
     *        A flag that enables encryption at rest when set to <code>true</code>.</p>
     *        <p>
     *        You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is
     *        created. To enable encryption at rest on a replication group you must set
     *        <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group.
     *        </p>
     *        <p>
     *        <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     *        <code>3.2.6</code>, <code>4.x</code> or later.
     *        </p>
     *        <p>
     *        Default: <code>false</code>
     */

    public void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
        this.atRestEncryptionEnabled = atRestEncryptionEnabled;
    }

    /**
     * <p>
     * A flag that enables encryption at rest when set to <code>true</code>.
     * </p>
     * <p>
     * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To
     * enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to
     * <code>true</code> when you create the replication group.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return A flag that enables encryption at rest when set to <code>true</code>.</p>
     *         <p>
     *         You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is
     *         created. To enable encryption at rest on a replication group you must set
     *         <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group.
     *         </p>
     *         <p>
     *         <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     *         <code>3.2.6</code>, <code>4.x</code> or later.
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     */

    public Boolean getAtRestEncryptionEnabled() {
        return this.atRestEncryptionEnabled;
    }

    /**
     * <p>
     * A flag that enables encryption at rest when set to <code>true</code>.
     * </p>
     * <p>
     * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To
     * enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to
     * <code>true</code> when you create the replication group.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @param atRestEncryptionEnabled
     *        A flag that enables encryption at rest when set to <code>true</code>.</p>
     *        <p>
     *        You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is
     *        created. To enable encryption at rest on a replication group you must set
     *        <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group.
     *        </p>
     *        <p>
     *        <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     *        <code>3.2.6</code>, <code>4.x</code> or later.
     *        </p>
     *        <p>
     *        Default: <code>false</code>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
        setAtRestEncryptionEnabled(atRestEncryptionEnabled);
        return this;
    }

    /**
     * <p>
     * A flag that enables encryption at rest when set to <code>true</code>.
     * </p>
     * <p>
     * You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To
     * enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to
     * <code>true</code> when you create the replication group.
     * </p>
     * <p>
     * <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     * <code>3.2.6</code>, <code>4.x</code> or later.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return A flag that enables encryption at rest when set to <code>true</code>.</p>
     *         <p>
     *         You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is
     *         created. To enable encryption at rest on a replication group you must set
     *         <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group.
     *         </p>
     *         <p>
     *         <b>Required:</b> Only available when creating a replication group in an Amazon VPC using redis version
     *         <code>3.2.6</code>, <code>4.x</code> or later.
     *         </p>
     *         <p>
     *         Default: <code>false</code>
     */

    public Boolean isAtRestEncryptionEnabled() {
        return this.atRestEncryptionEnabled;
    }

    /**
     * <p>
     * The ID of the KMS key used to encrypt the disk in the cluster.
     * </p>
     * 
     * @param kmsKeyId
     *        The ID of the KMS key used to encrypt the disk in the cluster.
     */

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    /**
     * <p>
     * The ID of the KMS key used to encrypt the disk in the cluster.
     * </p>
     * 
     * @return The ID of the KMS key used to encrypt the disk in the cluster.
     */

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    /**
     * <p>
     * The ID of the KMS key used to encrypt the disk in the cluster.
     * </p>
     * 
     * @param kmsKeyId
     *        The ID of the KMS key used to encrypt the disk in the cluster.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withKmsKeyId(String kmsKeyId) {
        setKmsKeyId(kmsKeyId);
        return this;
    }

    /**
     * <p>
     * The user group to associate with the replication group.
     * </p>
     * 
     * @return The user group to associate with the replication group.
     */

    public java.util.List<String> getUserGroupIds() {
        if (userGroupIds == null) {
            userGroupIds = new com.amazonaws.internal.SdkInternalList<String>();
        }
        return userGroupIds;
    }

    /**
     * <p>
     * The user group to associate with the replication group.
     * </p>
     * 
     * @param userGroupIds
     *        The user group to associate with the replication group.
     */

    public void setUserGroupIds(java.util.Collection<String> userGroupIds) {
        if (userGroupIds == null) {
            this.userGroupIds = null;
            return;
        }

        this.userGroupIds = new com.amazonaws.internal.SdkInternalList<String>(userGroupIds);
    }

    /**
     * <p>
     * The user group to associate with the replication group.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setUserGroupIds(java.util.Collection)} or {@link #withUserGroupIds(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param userGroupIds
     *        The user group to associate with the replication group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withUserGroupIds(String... userGroupIds) {
        if (this.userGroupIds == null) {
            setUserGroupIds(new com.amazonaws.internal.SdkInternalList<String>(userGroupIds.length));
        }
        for (String ele : userGroupIds) {
            this.userGroupIds.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The user group to associate with the replication group.
     * </p>
     * 
     * @param userGroupIds
     *        The user group to associate with the replication group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withUserGroupIds(java.util.Collection<String> userGroupIds) {
        setUserGroupIds(userGroupIds);
        return this;
    }

    /**
     * <p>
     * Specifies the destination, format and type of the logs.
     * </p>
     * 
     * @return Specifies the destination, format and type of the logs.
     */

    public java.util.List<LogDeliveryConfigurationRequest> getLogDeliveryConfigurations() {
        if (logDeliveryConfigurations == null) {
            logDeliveryConfigurations = new com.amazonaws.internal.SdkInternalList<LogDeliveryConfigurationRequest>();
        }
        return logDeliveryConfigurations;
    }

    /**
     * <p>
     * Specifies the destination, format and type of the logs.
     * </p>
     * 
     * @param logDeliveryConfigurations
     *        Specifies the destination, format and type of the logs.
     */

    public void setLogDeliveryConfigurations(java.util.Collection<LogDeliveryConfigurationRequest> logDeliveryConfigurations) {
        if (logDeliveryConfigurations == null) {
            this.logDeliveryConfigurations = null;
            return;
        }

        this.logDeliveryConfigurations = new com.amazonaws.internal.SdkInternalList<LogDeliveryConfigurationRequest>(logDeliveryConfigurations);
    }

    /**
     * <p>
     * Specifies the destination, format and type of the logs.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setLogDeliveryConfigurations(java.util.Collection)} or
     * {@link #withLogDeliveryConfigurations(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param logDeliveryConfigurations
     *        Specifies the destination, format and type of the logs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withLogDeliveryConfigurations(LogDeliveryConfigurationRequest... logDeliveryConfigurations) {
        if (this.logDeliveryConfigurations == null) {
            setLogDeliveryConfigurations(new com.amazonaws.internal.SdkInternalList<LogDeliveryConfigurationRequest>(logDeliveryConfigurations.length));
        }
        for (LogDeliveryConfigurationRequest ele : logDeliveryConfigurations) {
            this.logDeliveryConfigurations.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Specifies the destination, format and type of the logs.
     * </p>
     * 
     * @param logDeliveryConfigurations
     *        Specifies the destination, format and type of the logs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withLogDeliveryConfigurations(java.util.Collection<LogDeliveryConfigurationRequest> logDeliveryConfigurations) {
        setLogDeliveryConfigurations(logDeliveryConfigurations);
        return this;
    }

    /**
     * <p>
     * Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This
     * parameter must be set to true when using r6gd nodes. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
     * </p>
     * 
     * @param dataTieringEnabled
     *        Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This
     *        parameter must be set to true when using r6gd nodes. For more information, see <a
     *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
     */

    public void setDataTieringEnabled(Boolean dataTieringEnabled) {
        this.dataTieringEnabled = dataTieringEnabled;
    }

    /**
     * <p>
     * Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This
     * parameter must be set to true when using r6gd nodes. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
     * </p>
     * 
     * @return Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type.
     *         This parameter must be set to true when using r6gd nodes. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
     */

    public Boolean getDataTieringEnabled() {
        return this.dataTieringEnabled;
    }

    /**
     * <p>
     * Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This
     * parameter must be set to true when using r6gd nodes. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
     * </p>
     * 
     * @param dataTieringEnabled
     *        Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This
     *        parameter must be set to true when using r6gd nodes. For more information, see <a
     *        href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withDataTieringEnabled(Boolean dataTieringEnabled) {
        setDataTieringEnabled(dataTieringEnabled);
        return this;
    }

    /**
     * <p>
     * Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This
     * parameter must be set to true when using r6gd nodes. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
     * </p>
     * 
     * @return Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type.
     *         This parameter must be set to true when using r6gd nodes. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.
     */

    public Boolean isDataTieringEnabled() {
        return this.dataTieringEnabled;
    }

    /**
     * <p>
     * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for workloads
     * using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a
     * href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * 
     * @param networkType
     *        Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
     *        workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built
     *        on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * @see NetworkType
     */

    public void setNetworkType(String networkType) {
        this.networkType = networkType;
    }

    /**
     * <p>
     * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for workloads
     * using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a
     * href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * 
     * @return Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
     *         workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built
     *         on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * @see NetworkType
     */

    public String getNetworkType() {
        return this.networkType;
    }

    /**
     * <p>
     * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for workloads
     * using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a
     * href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * 
     * @param networkType
     *        Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
     *        workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built
     *        on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see NetworkType
     */

    public CreateReplicationGroupRequest withNetworkType(String networkType) {
        setNetworkType(networkType);
        return this;
    }

    /**
     * <p>
     * Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for workloads
     * using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a
     * href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * 
     * @param networkType
     *        Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for
     *        workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built
     *        on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see NetworkType
     */

    public CreateReplicationGroupRequest withNetworkType(NetworkType networkType) {
        this.networkType = networkType.toString();
        return this;
    }

    /**
     * <p>
     * The network type you choose when creating a replication group, either <code>ipv4</code> | <code>ipv6</code>. IPv6
     * is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all
     * instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * 
     * @param ipDiscovery
     *        The network type you choose when creating a replication group, either <code>ipv4</code> |
     *        <code>ipv6</code>. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached
     *        engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro
     *        system</a>.
     * @see IpDiscovery
     */

    public void setIpDiscovery(String ipDiscovery) {
        this.ipDiscovery = ipDiscovery;
    }

    /**
     * <p>
     * The network type you choose when creating a replication group, either <code>ipv4</code> | <code>ipv6</code>. IPv6
     * is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all
     * instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * 
     * @return The network type you choose when creating a replication group, either <code>ipv4</code> |
     *         <code>ipv6</code>. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached
     *         engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro
     *         system</a>.
     * @see IpDiscovery
     */

    public String getIpDiscovery() {
        return this.ipDiscovery;
    }

    /**
     * <p>
     * The network type you choose when creating a replication group, either <code>ipv4</code> | <code>ipv6</code>. IPv6
     * is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all
     * instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * 
     * @param ipDiscovery
     *        The network type you choose when creating a replication group, either <code>ipv4</code> |
     *        <code>ipv6</code>. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached
     *        engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro
     *        system</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see IpDiscovery
     */

    public CreateReplicationGroupRequest withIpDiscovery(String ipDiscovery) {
        setIpDiscovery(ipDiscovery);
        return this;
    }

    /**
     * <p>
     * The network type you choose when creating a replication group, either <code>ipv4</code> | <code>ipv6</code>. IPv6
     * is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all
     * instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.
     * </p>
     * 
     * @param ipDiscovery
     *        The network type you choose when creating a replication group, either <code>ipv4</code> |
     *        <code>ipv6</code>. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached
     *        engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro
     *        system</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see IpDiscovery
     */

    public CreateReplicationGroupRequest withIpDiscovery(IpDiscovery ipDiscovery) {
        this.ipDiscovery = ipDiscovery.toString();
        return this;
    }

    /**
     * <p>
     * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * </p>
     * <p>
     * When setting <code>TransitEncryptionEnabled</code> to <code>true</code>, you can set your
     * <code>TransitEncryptionMode</code> to <code>preferred</code> in the same request, to allow both encrypted and
     * unencrypted connections at the same time. Once you migrate all your Redis clients to use encrypted connections
     * you can modify the value to <code>required</code> to allow encrypted connections only.
     * </p>
     * <p>
     * Setting <code>TransitEncryptionMode</code> to <code>required</code> is a two-step process that requires you to
     * first set the <code>TransitEncryptionMode</code> to <code>preferred</code>, after that you can set
     * <code>TransitEncryptionMode</code> to <code>required</code>.
     * </p>
     * <p>
     * This process will not trigger the replacement of the replication group.
     * </p>
     * 
     * @param transitEncryptionMode
     *        A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.</p>
     *        <p>
     *        When setting <code>TransitEncryptionEnabled</code> to <code>true</code>, you can set your
     *        <code>TransitEncryptionMode</code> to <code>preferred</code> in the same request, to allow both encrypted
     *        and unencrypted connections at the same time. Once you migrate all your Redis clients to use encrypted
     *        connections you can modify the value to <code>required</code> to allow encrypted connections only.
     *        </p>
     *        <p>
     *        Setting <code>TransitEncryptionMode</code> to <code>required</code> is a two-step process that requires
     *        you to first set the <code>TransitEncryptionMode</code> to <code>preferred</code>, after that you can set
     *        <code>TransitEncryptionMode</code> to <code>required</code>.
     *        </p>
     *        <p>
     *        This process will not trigger the replacement of the replication group.
     * @see TransitEncryptionMode
     */

    public void setTransitEncryptionMode(String transitEncryptionMode) {
        this.transitEncryptionMode = transitEncryptionMode;
    }

    /**
     * <p>
     * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * </p>
     * <p>
     * When setting <code>TransitEncryptionEnabled</code> to <code>true</code>, you can set your
     * <code>TransitEncryptionMode</code> to <code>preferred</code> in the same request, to allow both encrypted and
     * unencrypted connections at the same time. Once you migrate all your Redis clients to use encrypted connections
     * you can modify the value to <code>required</code> to allow encrypted connections only.
     * </p>
     * <p>
     * Setting <code>TransitEncryptionMode</code> to <code>required</code> is a two-step process that requires you to
     * first set the <code>TransitEncryptionMode</code> to <code>preferred</code>, after that you can set
     * <code>TransitEncryptionMode</code> to <code>required</code>.
     * </p>
     * <p>
     * This process will not trigger the replacement of the replication group.
     * </p>
     * 
     * @return A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.</p>
     *         <p>
     *         When setting <code>TransitEncryptionEnabled</code> to <code>true</code>, you can set your
     *         <code>TransitEncryptionMode</code> to <code>preferred</code> in the same request, to allow both encrypted
     *         and unencrypted connections at the same time. Once you migrate all your Redis clients to use encrypted
     *         connections you can modify the value to <code>required</code> to allow encrypted connections only.
     *         </p>
     *         <p>
     *         Setting <code>TransitEncryptionMode</code> to <code>required</code> is a two-step process that requires
     *         you to first set the <code>TransitEncryptionMode</code> to <code>preferred</code>, after that you can set
     *         <code>TransitEncryptionMode</code> to <code>required</code>.
     *         </p>
     *         <p>
     *         This process will not trigger the replacement of the replication group.
     * @see TransitEncryptionMode
     */

    public String getTransitEncryptionMode() {
        return this.transitEncryptionMode;
    }

    /**
     * <p>
     * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * </p>
     * <p>
     * When setting <code>TransitEncryptionEnabled</code> to <code>true</code>, you can set your
     * <code>TransitEncryptionMode</code> to <code>preferred</code> in the same request, to allow both encrypted and
     * unencrypted connections at the same time. Once you migrate all your Redis clients to use encrypted connections
     * you can modify the value to <code>required</code> to allow encrypted connections only.
     * </p>
     * <p>
     * Setting <code>TransitEncryptionMode</code> to <code>required</code> is a two-step process that requires you to
     * first set the <code>TransitEncryptionMode</code> to <code>preferred</code>, after that you can set
     * <code>TransitEncryptionMode</code> to <code>required</code>.
     * </p>
     * <p>
     * This process will not trigger the replacement of the replication group.
     * </p>
     * 
     * @param transitEncryptionMode
     *        A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.</p>
     *        <p>
     *        When setting <code>TransitEncryptionEnabled</code> to <code>true</code>, you can set your
     *        <code>TransitEncryptionMode</code> to <code>preferred</code> in the same request, to allow both encrypted
     *        and unencrypted connections at the same time. Once you migrate all your Redis clients to use encrypted
     *        connections you can modify the value to <code>required</code> to allow encrypted connections only.
     *        </p>
     *        <p>
     *        Setting <code>TransitEncryptionMode</code> to <code>required</code> is a two-step process that requires
     *        you to first set the <code>TransitEncryptionMode</code> to <code>preferred</code>, after that you can set
     *        <code>TransitEncryptionMode</code> to <code>required</code>.
     *        </p>
     *        <p>
     *        This process will not trigger the replacement of the replication group.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TransitEncryptionMode
     */

    public CreateReplicationGroupRequest withTransitEncryptionMode(String transitEncryptionMode) {
        setTransitEncryptionMode(transitEncryptionMode);
        return this;
    }

    /**
     * <p>
     * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     * </p>
     * <p>
     * When setting <code>TransitEncryptionEnabled</code> to <code>true</code>, you can set your
     * <code>TransitEncryptionMode</code> to <code>preferred</code> in the same request, to allow both encrypted and
     * unencrypted connections at the same time. Once you migrate all your Redis clients to use encrypted connections
     * you can modify the value to <code>required</code> to allow encrypted connections only.
     * </p>
     * <p>
     * Setting <code>TransitEncryptionMode</code> to <code>required</code> is a two-step process that requires you to
     * first set the <code>TransitEncryptionMode</code> to <code>preferred</code>, after that you can set
     * <code>TransitEncryptionMode</code> to <code>required</code>.
     * </p>
     * <p>
     * This process will not trigger the replacement of the replication group.
     * </p>
     * 
     * @param transitEncryptionMode
     *        A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.</p>
     *        <p>
     *        When setting <code>TransitEncryptionEnabled</code> to <code>true</code>, you can set your
     *        <code>TransitEncryptionMode</code> to <code>preferred</code> in the same request, to allow both encrypted
     *        and unencrypted connections at the same time. Once you migrate all your Redis clients to use encrypted
     *        connections you can modify the value to <code>required</code> to allow encrypted connections only.
     *        </p>
     *        <p>
     *        Setting <code>TransitEncryptionMode</code> to <code>required</code> is a two-step process that requires
     *        you to first set the <code>TransitEncryptionMode</code> to <code>preferred</code>, after that you can set
     *        <code>TransitEncryptionMode</code> to <code>required</code>.
     *        </p>
     *        <p>
     *        This process will not trigger the replacement of the replication group.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TransitEncryptionMode
     */

    public CreateReplicationGroupRequest withTransitEncryptionMode(TransitEncryptionMode transitEncryptionMode) {
        this.transitEncryptionMode = transitEncryptionMode.toString();
        return this;
    }

    /**
     * <p>
     * Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to
     * Compatible. Compatible mode allows your Redis clients to connect using both cluster mode enabled and cluster mode
     * disabled. After you migrate all Redis clients to use cluster mode enabled, you can then complete cluster mode
     * configuration and set the cluster mode to Enabled.
     * </p>
     * 
     * @param clusterMode
     *        Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode
     *        to Compatible. Compatible mode allows your Redis clients to connect using both cluster mode enabled and
     *        cluster mode disabled. After you migrate all Redis clients to use cluster mode enabled, you can then
     *        complete cluster mode configuration and set the cluster mode to Enabled.
     * @see ClusterMode
     */

    public void setClusterMode(String clusterMode) {
        this.clusterMode = clusterMode;
    }

    /**
     * <p>
     * Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to
     * Compatible. Compatible mode allows your Redis clients to connect using both cluster mode enabled and cluster mode
     * disabled. After you migrate all Redis clients to use cluster mode enabled, you can then complete cluster mode
     * configuration and set the cluster mode to Enabled.
     * </p>
     * 
     * @return Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode
     *         to Compatible. Compatible mode allows your Redis clients to connect using both cluster mode enabled and
     *         cluster mode disabled. After you migrate all Redis clients to use cluster mode enabled, you can then
     *         complete cluster mode configuration and set the cluster mode to Enabled.
     * @see ClusterMode
     */

    public String getClusterMode() {
        return this.clusterMode;
    }

    /**
     * <p>
     * Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to
     * Compatible. Compatible mode allows your Redis clients to connect using both cluster mode enabled and cluster mode
     * disabled. After you migrate all Redis clients to use cluster mode enabled, you can then complete cluster mode
     * configuration and set the cluster mode to Enabled.
     * </p>
     * 
     * @param clusterMode
     *        Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode
     *        to Compatible. Compatible mode allows your Redis clients to connect using both cluster mode enabled and
     *        cluster mode disabled. After you migrate all Redis clients to use cluster mode enabled, you can then
     *        complete cluster mode configuration and set the cluster mode to Enabled.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ClusterMode
     */

    public CreateReplicationGroupRequest withClusterMode(String clusterMode) {
        setClusterMode(clusterMode);
        return this;
    }

    /**
     * <p>
     * Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to
     * Compatible. Compatible mode allows your Redis clients to connect using both cluster mode enabled and cluster mode
     * disabled. After you migrate all Redis clients to use cluster mode enabled, you can then complete cluster mode
     * configuration and set the cluster mode to Enabled.
     * </p>
     * 
     * @param clusterMode
     *        Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode
     *        to Compatible. Compatible mode allows your Redis clients to connect using both cluster mode enabled and
     *        cluster mode disabled. After you migrate all Redis clients to use cluster mode enabled, you can then
     *        complete cluster mode configuration and set the cluster mode to Enabled.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ClusterMode
     */

    public CreateReplicationGroupRequest withClusterMode(ClusterMode clusterMode) {
        this.clusterMode = clusterMode.toString();
        return this;
    }

    /**
     * <p>
     * The name of the snapshot used to create a replication group. Available for Redis only.
     * </p>
     * 
     * @param serverlessCacheSnapshotName
     *        The name of the snapshot used to create a replication group. Available for Redis only.
     */

    public void setServerlessCacheSnapshotName(String serverlessCacheSnapshotName) {
        this.serverlessCacheSnapshotName = serverlessCacheSnapshotName;
    }

    /**
     * <p>
     * The name of the snapshot used to create a replication group. Available for Redis only.
     * </p>
     * 
     * @return The name of the snapshot used to create a replication group. Available for Redis only.
     */

    public String getServerlessCacheSnapshotName() {
        return this.serverlessCacheSnapshotName;
    }

    /**
     * <p>
     * The name of the snapshot used to create a replication group. Available for Redis only.
     * </p>
     * 
     * @param serverlessCacheSnapshotName
     *        The name of the snapshot used to create a replication group. Available for Redis only.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateReplicationGroupRequest withServerlessCacheSnapshotName(String serverlessCacheSnapshotName) {
        setServerlessCacheSnapshotName(serverlessCacheSnapshotName);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getReplicationGroupId() != null)
            sb.append("ReplicationGroupId: ").append(getReplicationGroupId()).append(",");
        if (getReplicationGroupDescription() != null)
            sb.append("ReplicationGroupDescription: ").append(getReplicationGroupDescription()).append(",");
        if (getGlobalReplicationGroupId() != null)
            sb.append("GlobalReplicationGroupId: ").append(getGlobalReplicationGroupId()).append(",");
        if (getPrimaryClusterId() != null)
            sb.append("PrimaryClusterId: ").append(getPrimaryClusterId()).append(",");
        if (getAutomaticFailoverEnabled() != null)
            sb.append("AutomaticFailoverEnabled: ").append(getAutomaticFailoverEnabled()).append(",");
        if (getMultiAZEnabled() != null)
            sb.append("MultiAZEnabled: ").append(getMultiAZEnabled()).append(",");
        if (getNumCacheClusters() != null)
            sb.append("NumCacheClusters: ").append(getNumCacheClusters()).append(",");
        if (getPreferredCacheClusterAZs() != null)
            sb.append("PreferredCacheClusterAZs: ").append(getPreferredCacheClusterAZs()).append(",");
        if (getNumNodeGroups() != null)
            sb.append("NumNodeGroups: ").append(getNumNodeGroups()).append(",");
        if (getReplicasPerNodeGroup() != null)
            sb.append("ReplicasPerNodeGroup: ").append(getReplicasPerNodeGroup()).append(",");
        if (getNodeGroupConfiguration() != null)
            sb.append("NodeGroupConfiguration: ").append(getNodeGroupConfiguration()).append(",");
        if (getCacheNodeType() != null)
            sb.append("CacheNodeType: ").append(getCacheNodeType()).append(",");
        if (getEngine() != null)
            sb.append("Engine: ").append(getEngine()).append(",");
        if (getEngineVersion() != null)
            sb.append("EngineVersion: ").append(getEngineVersion()).append(",");
        if (getCacheParameterGroupName() != null)
            sb.append("CacheParameterGroupName: ").append(getCacheParameterGroupName()).append(",");
        if (getCacheSubnetGroupName() != null)
            sb.append("CacheSubnetGroupName: ").append(getCacheSubnetGroupName()).append(",");
        if (getCacheSecurityGroupNames() != null)
            sb.append("CacheSecurityGroupNames: ").append(getCacheSecurityGroupNames()).append(",");
        if (getSecurityGroupIds() != null)
            sb.append("SecurityGroupIds: ").append(getSecurityGroupIds()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getSnapshotArns() != null)
            sb.append("SnapshotArns: ").append(getSnapshotArns()).append(",");
        if (getSnapshotName() != null)
            sb.append("SnapshotName: ").append(getSnapshotName()).append(",");
        if (getPreferredMaintenanceWindow() != null)
            sb.append("PreferredMaintenanceWindow: ").append(getPreferredMaintenanceWindow()).append(",");
        if (getPort() != null)
            sb.append("Port: ").append(getPort()).append(",");
        if (getNotificationTopicArn() != null)
            sb.append("NotificationTopicArn: ").append(getNotificationTopicArn()).append(",");
        if (getAutoMinorVersionUpgrade() != null)
            sb.append("AutoMinorVersionUpgrade: ").append(getAutoMinorVersionUpgrade()).append(",");
        if (getSnapshotRetentionLimit() != null)
            sb.append("SnapshotRetentionLimit: ").append(getSnapshotRetentionLimit()).append(",");
        if (getSnapshotWindow() != null)
            sb.append("SnapshotWindow: ").append(getSnapshotWindow()).append(",");
        if (getAuthToken() != null)
            sb.append("AuthToken: ").append(getAuthToken()).append(",");
        if (getTransitEncryptionEnabled() != null)
            sb.append("TransitEncryptionEnabled: ").append(getTransitEncryptionEnabled()).append(",");
        if (getAtRestEncryptionEnabled() != null)
            sb.append("AtRestEncryptionEnabled: ").append(getAtRestEncryptionEnabled()).append(",");
        if (getKmsKeyId() != null)
            sb.append("KmsKeyId: ").append(getKmsKeyId()).append(",");
        if (getUserGroupIds() != null)
            sb.append("UserGroupIds: ").append(getUserGroupIds()).append(",");
        if (getLogDeliveryConfigurations() != null)
            sb.append("LogDeliveryConfigurations: ").append(getLogDeliveryConfigurations()).append(",");
        if (getDataTieringEnabled() != null)
            sb.append("DataTieringEnabled: ").append(getDataTieringEnabled()).append(",");
        if (getNetworkType() != null)
            sb.append("NetworkType: ").append(getNetworkType()).append(",");
        if (getIpDiscovery() != null)
            sb.append("IpDiscovery: ").append(getIpDiscovery()).append(",");
        if (getTransitEncryptionMode() != null)
            sb.append("TransitEncryptionMode: ").append(getTransitEncryptionMode()).append(",");
        if (getClusterMode() != null)
            sb.append("ClusterMode: ").append(getClusterMode()).append(",");
        if (getServerlessCacheSnapshotName() != null)
            sb.append("ServerlessCacheSnapshotName: ").append(getServerlessCacheSnapshotName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateReplicationGroupRequest == false)
            return false;
        CreateReplicationGroupRequest other = (CreateReplicationGroupRequest) obj;
        if (other.getReplicationGroupId() == null ^ this.getReplicationGroupId() == null)
            return false;
        if (other.getReplicationGroupId() != null && other.getReplicationGroupId().equals(this.getReplicationGroupId()) == false)
            return false;
        if (other.getReplicationGroupDescription() == null ^ this.getReplicationGroupDescription() == null)
            return false;
        if (other.getReplicationGroupDescription() != null && other.getReplicationGroupDescription().equals(this.getReplicationGroupDescription()) == false)
            return false;
        if (other.getGlobalReplicationGroupId() == null ^ this.getGlobalReplicationGroupId() == null)
            return false;
        if (other.getGlobalReplicationGroupId() != null && other.getGlobalReplicationGroupId().equals(this.getGlobalReplicationGroupId()) == false)
            return false;
        if (other.getPrimaryClusterId() == null ^ this.getPrimaryClusterId() == null)
            return false;
        if (other.getPrimaryClusterId() != null && other.getPrimaryClusterId().equals(this.getPrimaryClusterId()) == false)
            return false;
        if (other.getAutomaticFailoverEnabled() == null ^ this.getAutomaticFailoverEnabled() == null)
            return false;
        if (other.getAutomaticFailoverEnabled() != null && other.getAutomaticFailoverEnabled().equals(this.getAutomaticFailoverEnabled()) == false)
            return false;
        if (other.getMultiAZEnabled() == null ^ this.getMultiAZEnabled() == null)
            return false;
        if (other.getMultiAZEnabled() != null && other.getMultiAZEnabled().equals(this.getMultiAZEnabled()) == false)
            return false;
        if (other.getNumCacheClusters() == null ^ this.getNumCacheClusters() == null)
            return false;
        if (other.getNumCacheClusters() != null && other.getNumCacheClusters().equals(this.getNumCacheClusters()) == false)
            return false;
        if (other.getPreferredCacheClusterAZs() == null ^ this.getPreferredCacheClusterAZs() == null)
            return false;
        if (other.getPreferredCacheClusterAZs() != null && other.getPreferredCacheClusterAZs().equals(this.getPreferredCacheClusterAZs()) == false)
            return false;
        if (other.getNumNodeGroups() == null ^ this.getNumNodeGroups() == null)
            return false;
        if (other.getNumNodeGroups() != null && other.getNumNodeGroups().equals(this.getNumNodeGroups()) == false)
            return false;
        if (other.getReplicasPerNodeGroup() == null ^ this.getReplicasPerNodeGroup() == null)
            return false;
        if (other.getReplicasPerNodeGroup() != null && other.getReplicasPerNodeGroup().equals(this.getReplicasPerNodeGroup()) == false)
            return false;
        if (other.getNodeGroupConfiguration() == null ^ this.getNodeGroupConfiguration() == null)
            return false;
        if (other.getNodeGroupConfiguration() != null && other.getNodeGroupConfiguration().equals(this.getNodeGroupConfiguration()) == false)
            return false;
        if (other.getCacheNodeType() == null ^ this.getCacheNodeType() == null)
            return false;
        if (other.getCacheNodeType() != null && other.getCacheNodeType().equals(this.getCacheNodeType()) == false)
            return false;
        if (other.getEngine() == null ^ this.getEngine() == null)
            return false;
        if (other.getEngine() != null && other.getEngine().equals(this.getEngine()) == false)
            return false;
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null)
            return false;
        if (other.getEngineVersion() != null && other.getEngineVersion().equals(this.getEngineVersion()) == false)
            return false;
        if (other.getCacheParameterGroupName() == null ^ this.getCacheParameterGroupName() == null)
            return false;
        if (other.getCacheParameterGroupName() != null && other.getCacheParameterGroupName().equals(this.getCacheParameterGroupName()) == false)
            return false;
        if (other.getCacheSubnetGroupName() == null ^ this.getCacheSubnetGroupName() == null)
            return false;
        if (other.getCacheSubnetGroupName() != null && other.getCacheSubnetGroupName().equals(this.getCacheSubnetGroupName()) == false)
            return false;
        if (other.getCacheSecurityGroupNames() == null ^ this.getCacheSecurityGroupNames() == null)
            return false;
        if (other.getCacheSecurityGroupNames() != null && other.getCacheSecurityGroupNames().equals(this.getCacheSecurityGroupNames()) == false)
            return false;
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null)
            return false;
        if (other.getSecurityGroupIds() != null && other.getSecurityGroupIds().equals(this.getSecurityGroupIds()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getSnapshotArns() == null ^ this.getSnapshotArns() == null)
            return false;
        if (other.getSnapshotArns() != null && other.getSnapshotArns().equals(this.getSnapshotArns()) == false)
            return false;
        if (other.getSnapshotName() == null ^ this.getSnapshotName() == null)
            return false;
        if (other.getSnapshotName() != null && other.getSnapshotName().equals(this.getSnapshotName()) == false)
            return false;
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null)
            return false;
        if (other.getPreferredMaintenanceWindow() != null && other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow()) == false)
            return false;
        if (other.getPort() == null ^ this.getPort() == null)
            return false;
        if (other.getPort() != null && other.getPort().equals(this.getPort()) == false)
            return false;
        if (other.getNotificationTopicArn() == null ^ this.getNotificationTopicArn() == null)
            return false;
        if (other.getNotificationTopicArn() != null && other.getNotificationTopicArn().equals(this.getNotificationTopicArn()) == false)
            return false;
        if (other.getAutoMinorVersionUpgrade() == null ^ this.getAutoMinorVersionUpgrade() == null)
            return false;
        if (other.getAutoMinorVersionUpgrade() != null && other.getAutoMinorVersionUpgrade().equals(this.getAutoMinorVersionUpgrade()) == false)
            return false;
        if (other.getSnapshotRetentionLimit() == null ^ this.getSnapshotRetentionLimit() == null)
            return false;
        if (other.getSnapshotRetentionLimit() != null && other.getSnapshotRetentionLimit().equals(this.getSnapshotRetentionLimit()) == false)
            return false;
        if (other.getSnapshotWindow() == null ^ this.getSnapshotWindow() == null)
            return false;
        if (other.getSnapshotWindow() != null && other.getSnapshotWindow().equals(this.getSnapshotWindow()) == false)
            return false;
        if (other.getAuthToken() == null ^ this.getAuthToken() == null)
            return false;
        if (other.getAuthToken() != null && other.getAuthToken().equals(this.getAuthToken()) == false)
            return false;
        if (other.getTransitEncryptionEnabled() == null ^ this.getTransitEncryptionEnabled() == null)
            return false;
        if (other.getTransitEncryptionEnabled() != null && other.getTransitEncryptionEnabled().equals(this.getTransitEncryptionEnabled()) == false)
            return false;
        if (other.getAtRestEncryptionEnabled() == null ^ this.getAtRestEncryptionEnabled() == null)
            return false;
        if (other.getAtRestEncryptionEnabled() != null && other.getAtRestEncryptionEnabled().equals(this.getAtRestEncryptionEnabled()) == false)
            return false;
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null)
            return false;
        if (other.getKmsKeyId() != null && other.getKmsKeyId().equals(this.getKmsKeyId()) == false)
            return false;
        if (other.getUserGroupIds() == null ^ this.getUserGroupIds() == null)
            return false;
        if (other.getUserGroupIds() != null && other.getUserGroupIds().equals(this.getUserGroupIds()) == false)
            return false;
        if (other.getLogDeliveryConfigurations() == null ^ this.getLogDeliveryConfigurations() == null)
            return false;
        if (other.getLogDeliveryConfigurations() != null && other.getLogDeliveryConfigurations().equals(this.getLogDeliveryConfigurations()) == false)
            return false;
        if (other.getDataTieringEnabled() == null ^ this.getDataTieringEnabled() == null)
            return false;
        if (other.getDataTieringEnabled() != null && other.getDataTieringEnabled().equals(this.getDataTieringEnabled()) == false)
            return false;
        if (other.getNetworkType() == null ^ this.getNetworkType() == null)
            return false;
        if (other.getNetworkType() != null && other.getNetworkType().equals(this.getNetworkType()) == false)
            return false;
        if (other.getIpDiscovery() == null ^ this.getIpDiscovery() == null)
            return false;
        if (other.getIpDiscovery() != null && other.getIpDiscovery().equals(this.getIpDiscovery()) == false)
            return false;
        if (other.getTransitEncryptionMode() == null ^ this.getTransitEncryptionMode() == null)
            return false;
        if (other.getTransitEncryptionMode() != null && other.getTransitEncryptionMode().equals(this.getTransitEncryptionMode()) == false)
            return false;
        if (other.getClusterMode() == null ^ this.getClusterMode() == null)
            return false;
        if (other.getClusterMode() != null && other.getClusterMode().equals(this.getClusterMode()) == false)
            return false;
        if (other.getServerlessCacheSnapshotName() == null ^ this.getServerlessCacheSnapshotName() == null)
            return false;
        if (other.getServerlessCacheSnapshotName() != null && other.getServerlessCacheSnapshotName().equals(this.getServerlessCacheSnapshotName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getReplicationGroupId() == null) ? 0 : getReplicationGroupId().hashCode());
        hashCode = prime * hashCode + ((getReplicationGroupDescription() == null) ? 0 : getReplicationGroupDescription().hashCode());
        hashCode = prime * hashCode + ((getGlobalReplicationGroupId() == null) ? 0 : getGlobalReplicationGroupId().hashCode());
        hashCode = prime * hashCode + ((getPrimaryClusterId() == null) ? 0 : getPrimaryClusterId().hashCode());
        hashCode = prime * hashCode + ((getAutomaticFailoverEnabled() == null) ? 0 : getAutomaticFailoverEnabled().hashCode());
        hashCode = prime * hashCode + ((getMultiAZEnabled() == null) ? 0 : getMultiAZEnabled().hashCode());
        hashCode = prime * hashCode + ((getNumCacheClusters() == null) ? 0 : getNumCacheClusters().hashCode());
        hashCode = prime * hashCode + ((getPreferredCacheClusterAZs() == null) ? 0 : getPreferredCacheClusterAZs().hashCode());
        hashCode = prime * hashCode + ((getNumNodeGroups() == null) ? 0 : getNumNodeGroups().hashCode());
        hashCode = prime * hashCode + ((getReplicasPerNodeGroup() == null) ? 0 : getReplicasPerNodeGroup().hashCode());
        hashCode = prime * hashCode + ((getNodeGroupConfiguration() == null) ? 0 : getNodeGroupConfiguration().hashCode());
        hashCode = prime * hashCode + ((getCacheNodeType() == null) ? 0 : getCacheNodeType().hashCode());
        hashCode = prime * hashCode + ((getEngine() == null) ? 0 : getEngine().hashCode());
        hashCode = prime * hashCode + ((getEngineVersion() == null) ? 0 : getEngineVersion().hashCode());
        hashCode = prime * hashCode + ((getCacheParameterGroupName() == null) ? 0 : getCacheParameterGroupName().hashCode());
        hashCode = prime * hashCode + ((getCacheSubnetGroupName() == null) ? 0 : getCacheSubnetGroupName().hashCode());
        hashCode = prime * hashCode + ((getCacheSecurityGroupNames() == null) ? 0 : getCacheSecurityGroupNames().hashCode());
        hashCode = prime * hashCode + ((getSecurityGroupIds() == null) ? 0 : getSecurityGroupIds().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getSnapshotArns() == null) ? 0 : getSnapshotArns().hashCode());
        hashCode = prime * hashCode + ((getSnapshotName() == null) ? 0 : getSnapshotName().hashCode());
        hashCode = prime * hashCode + ((getPreferredMaintenanceWindow() == null) ? 0 : getPreferredMaintenanceWindow().hashCode());
        hashCode = prime * hashCode + ((getPort() == null) ? 0 : getPort().hashCode());
        hashCode = prime * hashCode + ((getNotificationTopicArn() == null) ? 0 : getNotificationTopicArn().hashCode());
        hashCode = prime * hashCode + ((getAutoMinorVersionUpgrade() == null) ? 0 : getAutoMinorVersionUpgrade().hashCode());
        hashCode = prime * hashCode + ((getSnapshotRetentionLimit() == null) ? 0 : getSnapshotRetentionLimit().hashCode());
        hashCode = prime * hashCode + ((getSnapshotWindow() == null) ? 0 : getSnapshotWindow().hashCode());
        hashCode = prime * hashCode + ((getAuthToken() == null) ? 0 : getAuthToken().hashCode());
        hashCode = prime * hashCode + ((getTransitEncryptionEnabled() == null) ? 0 : getTransitEncryptionEnabled().hashCode());
        hashCode = prime * hashCode + ((getAtRestEncryptionEnabled() == null) ? 0 : getAtRestEncryptionEnabled().hashCode());
        hashCode = prime * hashCode + ((getKmsKeyId() == null) ? 0 : getKmsKeyId().hashCode());
        hashCode = prime * hashCode + ((getUserGroupIds() == null) ? 0 : getUserGroupIds().hashCode());
        hashCode = prime * hashCode + ((getLogDeliveryConfigurations() == null) ? 0 : getLogDeliveryConfigurations().hashCode());
        hashCode = prime * hashCode + ((getDataTieringEnabled() == null) ? 0 : getDataTieringEnabled().hashCode());
        hashCode = prime * hashCode + ((getNetworkType() == null) ? 0 : getNetworkType().hashCode());
        hashCode = prime * hashCode + ((getIpDiscovery() == null) ? 0 : getIpDiscovery().hashCode());
        hashCode = prime * hashCode + ((getTransitEncryptionMode() == null) ? 0 : getTransitEncryptionMode().hashCode());
        hashCode = prime * hashCode + ((getClusterMode() == null) ? 0 : getClusterMode().hashCode());
        hashCode = prime * hashCode + ((getServerlessCacheSnapshotName() == null) ? 0 : getServerlessCacheSnapshotName().hashCode());
        return hashCode;
    }

    @Override
    public CreateReplicationGroupRequest clone() {
        return (CreateReplicationGroupRequest) super.clone();
    }

}
