/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class DescribeEnvironmentsRequestMarshaller
implements Marshaller<Request<DescribeEnvironmentsRequest>, DescribeEnvironmentsRequest> {
    public Request<DescribeEnvironmentsRequest> marshall(DescribeEnvironmentsRequest describeEnvironmentsRequest) {
        SdkInternalList environmentNamesList;
        SdkInternalList environmentIdsList;
        if (describeEnvironmentsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeEnvironmentsRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "DescribeEnvironments");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEnvironmentsRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)describeEnvironmentsRequest.getApplicationName()));
        }
        if (describeEnvironmentsRequest.getVersionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString((String)describeEnvironmentsRequest.getVersionLabel()));
        }
        if (!(environmentIdsList = (SdkInternalList)describeEnvironmentsRequest.getEnvironmentIds()).isEmpty() || !environmentIdsList.isAutoConstruct()) {
            int environmentIdsListIndex = 1;
            for (String environmentIdsListValue : environmentIdsList) {
                if (environmentIdsListValue != null) {
                    request.addParameter("EnvironmentIds.member." + environmentIdsListIndex, StringUtils.fromString((String)environmentIdsListValue));
                }
                ++environmentIdsListIndex;
            }
        }
        if (!(environmentNamesList = (SdkInternalList)describeEnvironmentsRequest.getEnvironmentNames()).isEmpty() || !environmentNamesList.isAutoConstruct()) {
            int environmentNamesListIndex = 1;
            for (String environmentNamesListValue : environmentNamesList) {
                if (environmentNamesListValue != null) {
                    request.addParameter("EnvironmentNames.member." + environmentNamesListIndex, StringUtils.fromString((String)environmentNamesListValue));
                }
                ++environmentNamesListIndex;
            }
        }
        if (describeEnvironmentsRequest.getIncludeDeleted() != null) {
            request.addParameter("IncludeDeleted", StringUtils.fromBoolean((Boolean)describeEnvironmentsRequest.getIncludeDeleted()));
        }
        if (describeEnvironmentsRequest.getIncludedDeletedBackTo() != null) {
            request.addParameter("IncludedDeletedBackTo", StringUtils.fromDate((Date)describeEnvironmentsRequest.getIncludedDeletedBackTo()));
        }
        if (describeEnvironmentsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeEnvironmentsRequest.getMaxRecords()));
        }
        if (describeEnvironmentsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeEnvironmentsRequest.getNextToken()));
        }
        return request;
    }
}

