/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.Instance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListInstancesResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<Instance> instances;
    private String marker;

    public List<Instance> getInstances() {
        if (this.instances == null) {
            this.instances = new ListWithAutoConstructFlag();
            this.instances.setAutoConstruct(true);
        }
        return this.instances;
    }

    public void setInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        ListWithAutoConstructFlag instancesCopy = new ListWithAutoConstructFlag(instances.size());
        instancesCopy.addAll(instances);
        this.instances = instancesCopy;
    }

    public ListInstancesResult withInstances(Instance ... instances) {
        if (this.getInstances() == null) {
            this.setInstances(new ArrayList<Instance>(instances.length));
        }
        for (Instance value : instances) {
            this.getInstances().add(value);
        }
        return this;
    }

    public ListInstancesResult withInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
        } else {
            ListWithAutoConstructFlag instancesCopy = new ListWithAutoConstructFlag(instances.size());
            instancesCopy.addAll(instances);
            this.instances = instancesCopy;
        }
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListInstancesResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstances() != null) {
            sb.append("Instances: " + this.getInstances() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstancesResult)) {
            return false;
        }
        ListInstancesResult other = (ListInstancesResult)obj;
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public ListInstancesResult clone() {
        try {
            return (ListInstancesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

