/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Application
implements Serializable,
Cloneable {
    private String name;
    private String version;
    private SdkInternalList<String> args;
    private SdkInternalMap<String, String> additionalInfo;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Application withName(String name) {
        this.setName(name);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public Application withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public List<String> getArgs() {
        if (this.args == null) {
            this.args = new SdkInternalList();
        }
        return this.args;
    }

    public void setArgs(Collection<String> args) {
        if (args == null) {
            this.args = null;
            return;
        }
        this.args = new SdkInternalList(args);
    }

    public Application withArgs(String ... args) {
        if (this.args == null) {
            this.setArgs((Collection<String>)new SdkInternalList(args.length));
        }
        for (String ele : args) {
            this.args.add((Object)ele);
        }
        return this;
    }

    public Application withArgs(Collection<String> args) {
        this.setArgs(args);
        return this;
    }

    public Map<String, String> getAdditionalInfo() {
        if (this.additionalInfo == null) {
            this.additionalInfo = new SdkInternalMap();
        }
        return this.additionalInfo;
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo == null ? null : new SdkInternalMap(additionalInfo);
    }

    public Application withAdditionalInfo(Map<String, String> additionalInfo) {
        this.setAdditionalInfo(additionalInfo);
        return this;
    }

    public Application addAdditionalInfoEntry(String key, String value) {
        if (null == this.additionalInfo) {
            this.additionalInfo = new SdkInternalMap();
        }
        if (this.additionalInfo.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalInfo.put((Object)key, (Object)value);
        return this;
    }

    public Application clearAdditionalInfoEntries() {
        this.additionalInfo = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: " + this.getVersion() + ",");
        }
        if (this.getArgs() != null) {
            sb.append("Args: " + this.getArgs() + ",");
        }
        if (this.getAdditionalInfo() != null) {
            sb.append("AdditionalInfo: " + this.getAdditionalInfo());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getArgs() == null ^ this.getArgs() == null) {
            return false;
        }
        if (other.getArgs() != null && !other.getArgs().equals(this.getArgs())) {
            return false;
        }
        if (other.getAdditionalInfo() == null ^ this.getAdditionalInfo() == null) {
            return false;
        }
        return other.getAdditionalInfo() == null || other.getAdditionalInfo().equals(this.getAdditionalInfo());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getArgs() == null ? 0 : this.getArgs().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalInfo() == null ? 0 : this.getAdditionalInfo().hashCode());
        return hashCode;
    }

    public Application clone() {
        try {
            return (Application)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

