/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.emrcontainers;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.emrcontainers.AmazonEMRContainers;
import com.amazonaws.services.emrcontainers.AmazonEMRContainersClientBuilder;
import com.amazonaws.services.emrcontainers.model.AmazonEMRContainersException;
import com.amazonaws.services.emrcontainers.model.CancelJobRunRequest;
import com.amazonaws.services.emrcontainers.model.CancelJobRunResult;
import com.amazonaws.services.emrcontainers.model.CreateManagedEndpointRequest;
import com.amazonaws.services.emrcontainers.model.CreateManagedEndpointResult;
import com.amazonaws.services.emrcontainers.model.CreateVirtualClusterRequest;
import com.amazonaws.services.emrcontainers.model.CreateVirtualClusterResult;
import com.amazonaws.services.emrcontainers.model.DeleteManagedEndpointRequest;
import com.amazonaws.services.emrcontainers.model.DeleteManagedEndpointResult;
import com.amazonaws.services.emrcontainers.model.DeleteVirtualClusterRequest;
import com.amazonaws.services.emrcontainers.model.DeleteVirtualClusterResult;
import com.amazonaws.services.emrcontainers.model.DescribeJobRunRequest;
import com.amazonaws.services.emrcontainers.model.DescribeJobRunResult;
import com.amazonaws.services.emrcontainers.model.DescribeManagedEndpointRequest;
import com.amazonaws.services.emrcontainers.model.DescribeManagedEndpointResult;
import com.amazonaws.services.emrcontainers.model.DescribeVirtualClusterRequest;
import com.amazonaws.services.emrcontainers.model.DescribeVirtualClusterResult;
import com.amazonaws.services.emrcontainers.model.ListJobRunsRequest;
import com.amazonaws.services.emrcontainers.model.ListJobRunsResult;
import com.amazonaws.services.emrcontainers.model.ListManagedEndpointsRequest;
import com.amazonaws.services.emrcontainers.model.ListManagedEndpointsResult;
import com.amazonaws.services.emrcontainers.model.ListTagsForResourceRequest;
import com.amazonaws.services.emrcontainers.model.ListTagsForResourceResult;
import com.amazonaws.services.emrcontainers.model.ListVirtualClustersRequest;
import com.amazonaws.services.emrcontainers.model.ListVirtualClustersResult;
import com.amazonaws.services.emrcontainers.model.StartJobRunRequest;
import com.amazonaws.services.emrcontainers.model.StartJobRunResult;
import com.amazonaws.services.emrcontainers.model.TagResourceRequest;
import com.amazonaws.services.emrcontainers.model.TagResourceResult;
import com.amazonaws.services.emrcontainers.model.UntagResourceRequest;
import com.amazonaws.services.emrcontainers.model.UntagResourceResult;
import com.amazonaws.services.emrcontainers.model.transform.CancelJobRunRequestProtocolMarshaller;
import com.amazonaws.services.emrcontainers.model.transform.CancelJobRunResultJsonUnmarshaller;
import com.amazonaws.services.emrcontainers.model.transform.CreateManagedEndpointRequestProtocolMarshaller;
import com.amazonaws.services.emrcontainers.model.transform.CreateManagedEndpointResultJsonUnmarshaller;
import com.amazonaws.services.emrcontainers.model.transform.CreateVirtualClusterRequestProtocolMarshaller;
import com.amazonaws.services.emrcontainers.model.transform.CreateVirtualClusterResultJsonUnmarshaller;
import com.amazonaws.services.emrcontainers.model.transform.DeleteManagedEndpointRequestProtocolMarshaller;
import com.amazonaws.services.emrcontainers.model.transform.DeleteManagedEndpointResultJsonUnmarshaller;
import com.amazonaws.services.emrcontainers.model.transform.DeleteVirtualClusterRequestProtocolMarshaller;
import com.amazonaws.services.emrcontainers.model.transform.DeleteVirtualClusterResultJsonUnmarshaller;
import com.amazonaws.services.emrcontainers.model.transform.DescribeJobRunRequestProtocolMarshaller;
import com.amazonaws.services.emrcontainers.model.transform.DescribeJobRunResultJsonUnmarshaller;
import com.amazonaws.services.emrcontainers.model.transform.DescribeManagedEndpointRequestProtocolMarshaller;
import com.amazonaws.services.emrcontainers.model.transform.DescribeManagedEndpointResultJsonUnmarshaller;
import com.amazonaws.services.emrcontainers.model.transform.DescribeVirtualClusterRequestProtocolMarshaller;
import com.amazonaws.services.emrcontainers.model.transform.DescribeVirtualClusterResultJsonUnmarshaller;
import com.amazonaws.services.emrcontainers.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.emrcontainers.model.transform.ListJobRunsRequestProtocolMarshaller;
import com.amazonaws.services.emrcontainers.model.transform.ListJobRunsResultJsonUnmarshaller;
import com.amazonaws.services.emrcontainers.model.transform.ListManagedEndpointsRequestProtocolMarshaller;
import com.amazonaws.services.emrcontainers.model.transform.ListManagedEndpointsResultJsonUnmarshaller;
import com.amazonaws.services.emrcontainers.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.emrcontainers.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.emrcontainers.model.transform.ListVirtualClustersRequestProtocolMarshaller;
import com.amazonaws.services.emrcontainers.model.transform.ListVirtualClustersResultJsonUnmarshaller;
import com.amazonaws.services.emrcontainers.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.emrcontainers.model.transform.StartJobRunRequestProtocolMarshaller;
import com.amazonaws.services.emrcontainers.model.transform.StartJobRunResultJsonUnmarshaller;
import com.amazonaws.services.emrcontainers.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.emrcontainers.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.emrcontainers.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.emrcontainers.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.emrcontainers.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonEMRContainersClient
extends AmazonWebServiceClient
implements AmazonEMRContainers {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonEMRContainers.class);
    private static final String DEFAULT_SIGNING_NAME = "emr-containers";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonEMRContainersException.class));

    public static AmazonEMRContainersClientBuilder builder() {
        return AmazonEMRContainersClientBuilder.standard();
    }

    AmazonEMRContainersClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonEMRContainersClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("emr-containers.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/emrcontainers/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/emrcontainers/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CancelJobRunResult cancelJobRun(CancelJobRunRequest request) {
        request = (CancelJobRunRequest)this.beforeClientExecution(request);
        return this.executeCancelJobRun(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelJobRunResult executeCancelJobRun(CancelJobRunRequest cancelJobRunRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelJobRunRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelJobRunRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelJobRunRequestProtocolMarshaller(protocolFactory).marshall((CancelJobRunRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelJobRunRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EMR containers");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelJobRun");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelJobRunResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelJobRunResult cancelJobRunResult = (CancelJobRunResult)response.getAwsResponse();
            return cancelJobRunResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateManagedEndpointResult createManagedEndpoint(CreateManagedEndpointRequest request) {
        request = (CreateManagedEndpointRequest)this.beforeClientExecution(request);
        return this.executeCreateManagedEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateManagedEndpointResult executeCreateManagedEndpoint(CreateManagedEndpointRequest createManagedEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createManagedEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateManagedEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateManagedEndpointRequestProtocolMarshaller(protocolFactory).marshall((CreateManagedEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)createManagedEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EMR containers");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateManagedEndpoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateManagedEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateManagedEndpointResult createManagedEndpointResult = (CreateManagedEndpointResult)response.getAwsResponse();
            return createManagedEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateVirtualClusterResult createVirtualCluster(CreateVirtualClusterRequest request) {
        request = (CreateVirtualClusterRequest)this.beforeClientExecution(request);
        return this.executeCreateVirtualCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateVirtualClusterResult executeCreateVirtualCluster(CreateVirtualClusterRequest createVirtualClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createVirtualClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateVirtualClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateVirtualClusterRequestProtocolMarshaller(protocolFactory).marshall((CreateVirtualClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)createVirtualClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EMR containers");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateVirtualCluster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateVirtualClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateVirtualClusterResult createVirtualClusterResult = (CreateVirtualClusterResult)response.getAwsResponse();
            return createVirtualClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteManagedEndpointResult deleteManagedEndpoint(DeleteManagedEndpointRequest request) {
        request = (DeleteManagedEndpointRequest)this.beforeClientExecution(request);
        return this.executeDeleteManagedEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteManagedEndpointResult executeDeleteManagedEndpoint(DeleteManagedEndpointRequest deleteManagedEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteManagedEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteManagedEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteManagedEndpointRequestProtocolMarshaller(protocolFactory).marshall((DeleteManagedEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteManagedEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EMR containers");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteManagedEndpoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteManagedEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteManagedEndpointResult deleteManagedEndpointResult = (DeleteManagedEndpointResult)response.getAwsResponse();
            return deleteManagedEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteVirtualClusterResult deleteVirtualCluster(DeleteVirtualClusterRequest request) {
        request = (DeleteVirtualClusterRequest)this.beforeClientExecution(request);
        return this.executeDeleteVirtualCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteVirtualClusterResult executeDeleteVirtualCluster(DeleteVirtualClusterRequest deleteVirtualClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteVirtualClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteVirtualClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteVirtualClusterRequestProtocolMarshaller(protocolFactory).marshall((DeleteVirtualClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteVirtualClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EMR containers");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteVirtualCluster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteVirtualClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteVirtualClusterResult deleteVirtualClusterResult = (DeleteVirtualClusterResult)response.getAwsResponse();
            return deleteVirtualClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeJobRunResult describeJobRun(DescribeJobRunRequest request) {
        request = (DescribeJobRunRequest)this.beforeClientExecution(request);
        return this.executeDescribeJobRun(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeJobRunResult executeDescribeJobRun(DescribeJobRunRequest describeJobRunRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeJobRunRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeJobRunRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeJobRunRequestProtocolMarshaller(protocolFactory).marshall((DescribeJobRunRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeJobRunRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EMR containers");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeJobRun");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeJobRunResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeJobRunResult describeJobRunResult = (DescribeJobRunResult)response.getAwsResponse();
            return describeJobRunResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeManagedEndpointResult describeManagedEndpoint(DescribeManagedEndpointRequest request) {
        request = (DescribeManagedEndpointRequest)this.beforeClientExecution(request);
        return this.executeDescribeManagedEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeManagedEndpointResult executeDescribeManagedEndpoint(DescribeManagedEndpointRequest describeManagedEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeManagedEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeManagedEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeManagedEndpointRequestProtocolMarshaller(protocolFactory).marshall((DescribeManagedEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeManagedEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EMR containers");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeManagedEndpoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeManagedEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeManagedEndpointResult describeManagedEndpointResult = (DescribeManagedEndpointResult)response.getAwsResponse();
            return describeManagedEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeVirtualClusterResult describeVirtualCluster(DescribeVirtualClusterRequest request) {
        request = (DescribeVirtualClusterRequest)this.beforeClientExecution(request);
        return this.executeDescribeVirtualCluster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeVirtualClusterResult executeDescribeVirtualCluster(DescribeVirtualClusterRequest describeVirtualClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeVirtualClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeVirtualClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeVirtualClusterRequestProtocolMarshaller(protocolFactory).marshall((DescribeVirtualClusterRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeVirtualClusterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EMR containers");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeVirtualCluster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeVirtualClusterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeVirtualClusterResult describeVirtualClusterResult = (DescribeVirtualClusterResult)response.getAwsResponse();
            return describeVirtualClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListJobRunsResult listJobRuns(ListJobRunsRequest request) {
        request = (ListJobRunsRequest)this.beforeClientExecution(request);
        return this.executeListJobRuns(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListJobRunsResult executeListJobRuns(ListJobRunsRequest listJobRunsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJobRunsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobRunsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobRunsRequestProtocolMarshaller(protocolFactory).marshall((ListJobRunsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listJobRunsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EMR containers");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListJobRuns");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListJobRunsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListJobRunsResult listJobRunsResult = (ListJobRunsResult)response.getAwsResponse();
            return listJobRunsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListManagedEndpointsResult listManagedEndpoints(ListManagedEndpointsRequest request) {
        request = (ListManagedEndpointsRequest)this.beforeClientExecution(request);
        return this.executeListManagedEndpoints(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListManagedEndpointsResult executeListManagedEndpoints(ListManagedEndpointsRequest listManagedEndpointsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listManagedEndpointsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListManagedEndpointsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListManagedEndpointsRequestProtocolMarshaller(protocolFactory).marshall((ListManagedEndpointsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listManagedEndpointsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EMR containers");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListManagedEndpoints");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListManagedEndpointsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListManagedEndpointsResult listManagedEndpointsResult = (ListManagedEndpointsResult)response.getAwsResponse();
            return listManagedEndpointsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EMR containers");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListVirtualClustersResult listVirtualClusters(ListVirtualClustersRequest request) {
        request = (ListVirtualClustersRequest)this.beforeClientExecution(request);
        return this.executeListVirtualClusters(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListVirtualClustersResult executeListVirtualClusters(ListVirtualClustersRequest listVirtualClustersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listVirtualClustersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListVirtualClustersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListVirtualClustersRequestProtocolMarshaller(protocolFactory).marshall((ListVirtualClustersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listVirtualClustersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EMR containers");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListVirtualClusters");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListVirtualClustersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListVirtualClustersResult listVirtualClustersResult = (ListVirtualClustersResult)response.getAwsResponse();
            return listVirtualClustersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartJobRunResult startJobRun(StartJobRunRequest request) {
        request = (StartJobRunRequest)this.beforeClientExecution(request);
        return this.executeStartJobRun(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartJobRunResult executeStartJobRun(StartJobRunRequest startJobRunRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startJobRunRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartJobRunRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartJobRunRequestProtocolMarshaller(protocolFactory).marshall((StartJobRunRequest)super.beforeMarshalling((AmazonWebServiceRequest)startJobRunRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EMR containers");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartJobRun");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartJobRunResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartJobRunResult startJobRunResult = (StartJobRunResult)response.getAwsResponse();
            return startJobRunResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EMR containers");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EMR containers");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

