/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspace.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.finspace.model.CodeConfiguration;

@SdkInternalApi
public class CodeConfigurationMarshaller {
    private static final MarshallingInfo<String> S3BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Bucket").build();
    private static final MarshallingInfo<String> S3KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Key").build();
    private static final MarshallingInfo<String> S3OBJECTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3ObjectVersion").build();
    private static final CodeConfigurationMarshaller instance = new CodeConfigurationMarshaller();

    public static CodeConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(CodeConfiguration codeConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (codeConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)codeConfiguration.getS3Bucket(), S3BUCKET_BINDING);
            protocolMarshaller.marshall((Object)codeConfiguration.getS3Key(), S3KEY_BINDING);
            protocolMarshaller.marshall((Object)codeConfiguration.getS3ObjectVersion(), S3OBJECTVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

