/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fis.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fis.model.ExperimentTemplateAction;
import com.amazonaws.services.fis.model.ExperimentTemplateExperimentOptions;
import com.amazonaws.services.fis.model.ExperimentTemplateLogConfiguration;
import com.amazonaws.services.fis.model.ExperimentTemplateStopCondition;
import com.amazonaws.services.fis.model.ExperimentTemplateTarget;
import com.amazonaws.services.fis.model.transform.ExperimentTemplateMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExperimentTemplate
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String description;
    private Map<String, ExperimentTemplateTarget> targets;
    private Map<String, ExperimentTemplateAction> actions;
    private List<ExperimentTemplateStopCondition> stopConditions;
    private Date creationTime;
    private Date lastUpdateTime;
    private String roleArn;
    private Map<String, String> tags;
    private ExperimentTemplateLogConfiguration logConfiguration;
    private ExperimentTemplateExperimentOptions experimentOptions;
    private Long targetAccountConfigurationsCount;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public ExperimentTemplate withId(String id) {
        this.setId(id);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ExperimentTemplate withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, ExperimentTemplateTarget> getTargets() {
        return this.targets;
    }

    public void setTargets(Map<String, ExperimentTemplateTarget> targets) {
        this.targets = targets;
    }

    public ExperimentTemplate withTargets(Map<String, ExperimentTemplateTarget> targets) {
        this.setTargets(targets);
        return this;
    }

    public ExperimentTemplate addTargetsEntry(String key, ExperimentTemplateTarget value) {
        if (null == this.targets) {
            this.targets = new HashMap<String, ExperimentTemplateTarget>();
        }
        if (this.targets.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.targets.put(key, value);
        return this;
    }

    public ExperimentTemplate clearTargetsEntries() {
        this.targets = null;
        return this;
    }

    public Map<String, ExperimentTemplateAction> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, ExperimentTemplateAction> actions) {
        this.actions = actions;
    }

    public ExperimentTemplate withActions(Map<String, ExperimentTemplateAction> actions) {
        this.setActions(actions);
        return this;
    }

    public ExperimentTemplate addActionsEntry(String key, ExperimentTemplateAction value) {
        if (null == this.actions) {
            this.actions = new HashMap<String, ExperimentTemplateAction>();
        }
        if (this.actions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.actions.put(key, value);
        return this;
    }

    public ExperimentTemplate clearActionsEntries() {
        this.actions = null;
        return this;
    }

    public List<ExperimentTemplateStopCondition> getStopConditions() {
        return this.stopConditions;
    }

    public void setStopConditions(Collection<ExperimentTemplateStopCondition> stopConditions) {
        if (stopConditions == null) {
            this.stopConditions = null;
            return;
        }
        this.stopConditions = new ArrayList<ExperimentTemplateStopCondition>(stopConditions);
    }

    public ExperimentTemplate withStopConditions(ExperimentTemplateStopCondition ... stopConditions) {
        if (this.stopConditions == null) {
            this.setStopConditions(new ArrayList<ExperimentTemplateStopCondition>(stopConditions.length));
        }
        for (ExperimentTemplateStopCondition ele : stopConditions) {
            this.stopConditions.add(ele);
        }
        return this;
    }

    public ExperimentTemplate withStopConditions(Collection<ExperimentTemplateStopCondition> stopConditions) {
        this.setStopConditions(stopConditions);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public ExperimentTemplate withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public ExperimentTemplate withLastUpdateTime(Date lastUpdateTime) {
        this.setLastUpdateTime(lastUpdateTime);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public ExperimentTemplate withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public ExperimentTemplate withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public ExperimentTemplate addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public ExperimentTemplate clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setLogConfiguration(ExperimentTemplateLogConfiguration logConfiguration) {
        this.logConfiguration = logConfiguration;
    }

    public ExperimentTemplateLogConfiguration getLogConfiguration() {
        return this.logConfiguration;
    }

    public ExperimentTemplate withLogConfiguration(ExperimentTemplateLogConfiguration logConfiguration) {
        this.setLogConfiguration(logConfiguration);
        return this;
    }

    public void setExperimentOptions(ExperimentTemplateExperimentOptions experimentOptions) {
        this.experimentOptions = experimentOptions;
    }

    public ExperimentTemplateExperimentOptions getExperimentOptions() {
        return this.experimentOptions;
    }

    public ExperimentTemplate withExperimentOptions(ExperimentTemplateExperimentOptions experimentOptions) {
        this.setExperimentOptions(experimentOptions);
        return this;
    }

    public void setTargetAccountConfigurationsCount(Long targetAccountConfigurationsCount) {
        this.targetAccountConfigurationsCount = targetAccountConfigurationsCount;
    }

    public Long getTargetAccountConfigurationsCount() {
        return this.targetAccountConfigurationsCount;
    }

    public ExperimentTemplate withTargetAccountConfigurationsCount(Long targetAccountConfigurationsCount) {
        this.setTargetAccountConfigurationsCount(targetAccountConfigurationsCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getStopConditions() != null) {
            sb.append("StopConditions: ").append(this.getStopConditions()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getLastUpdateTime() != null) {
            sb.append("LastUpdateTime: ").append(this.getLastUpdateTime()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getLogConfiguration() != null) {
            sb.append("LogConfiguration: ").append(this.getLogConfiguration()).append(",");
        }
        if (this.getExperimentOptions() != null) {
            sb.append("ExperimentOptions: ").append(this.getExperimentOptions()).append(",");
        }
        if (this.getTargetAccountConfigurationsCount() != null) {
            sb.append("TargetAccountConfigurationsCount: ").append(this.getTargetAccountConfigurationsCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentTemplate)) {
            return false;
        }
        ExperimentTemplate other = (ExperimentTemplate)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getStopConditions() == null ^ this.getStopConditions() == null) {
            return false;
        }
        if (other.getStopConditions() != null && !other.getStopConditions().equals(this.getStopConditions())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getLastUpdateTime() == null ^ this.getLastUpdateTime() == null) {
            return false;
        }
        if (other.getLastUpdateTime() != null && !other.getLastUpdateTime().equals(this.getLastUpdateTime())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getLogConfiguration() == null ^ this.getLogConfiguration() == null) {
            return false;
        }
        if (other.getLogConfiguration() != null && !other.getLogConfiguration().equals(this.getLogConfiguration())) {
            return false;
        }
        if (other.getExperimentOptions() == null ^ this.getExperimentOptions() == null) {
            return false;
        }
        if (other.getExperimentOptions() != null && !other.getExperimentOptions().equals(this.getExperimentOptions())) {
            return false;
        }
        if (other.getTargetAccountConfigurationsCount() == null ^ this.getTargetAccountConfigurationsCount() == null) {
            return false;
        }
        return other.getTargetAccountConfigurationsCount() == null || other.getTargetAccountConfigurationsCount().equals(this.getTargetAccountConfigurationsCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getStopConditions() == null ? 0 : this.getStopConditions().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdateTime() == null ? 0 : this.getLastUpdateTime().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getLogConfiguration() == null ? 0 : this.getLogConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getExperimentOptions() == null ? 0 : this.getExperimentOptions().hashCode());
        hashCode = 31 * hashCode + (this.getTargetAccountConfigurationsCount() == null ? 0 : this.getTargetAccountConfigurationsCount().hashCode());
        return hashCode;
    }

    public ExperimentTemplate clone() {
        try {
            return (ExperimentTemplate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExperimentTemplateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

