/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fis;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.fis.AWSFISAsync;
import com.amazonaws.services.fis.AWSFISAsyncClientBuilder;
import com.amazonaws.services.fis.AWSFISClient;
import com.amazonaws.services.fis.model.CreateExperimentTemplateRequest;
import com.amazonaws.services.fis.model.CreateExperimentTemplateResult;
import com.amazonaws.services.fis.model.CreateTargetAccountConfigurationRequest;
import com.amazonaws.services.fis.model.CreateTargetAccountConfigurationResult;
import com.amazonaws.services.fis.model.DeleteExperimentTemplateRequest;
import com.amazonaws.services.fis.model.DeleteExperimentTemplateResult;
import com.amazonaws.services.fis.model.DeleteTargetAccountConfigurationRequest;
import com.amazonaws.services.fis.model.DeleteTargetAccountConfigurationResult;
import com.amazonaws.services.fis.model.GetActionRequest;
import com.amazonaws.services.fis.model.GetActionResult;
import com.amazonaws.services.fis.model.GetExperimentRequest;
import com.amazonaws.services.fis.model.GetExperimentResult;
import com.amazonaws.services.fis.model.GetExperimentTargetAccountConfigurationRequest;
import com.amazonaws.services.fis.model.GetExperimentTargetAccountConfigurationResult;
import com.amazonaws.services.fis.model.GetExperimentTemplateRequest;
import com.amazonaws.services.fis.model.GetExperimentTemplateResult;
import com.amazonaws.services.fis.model.GetTargetAccountConfigurationRequest;
import com.amazonaws.services.fis.model.GetTargetAccountConfigurationResult;
import com.amazonaws.services.fis.model.GetTargetResourceTypeRequest;
import com.amazonaws.services.fis.model.GetTargetResourceTypeResult;
import com.amazonaws.services.fis.model.ListActionsRequest;
import com.amazonaws.services.fis.model.ListActionsResult;
import com.amazonaws.services.fis.model.ListExperimentResolvedTargetsRequest;
import com.amazonaws.services.fis.model.ListExperimentResolvedTargetsResult;
import com.amazonaws.services.fis.model.ListExperimentTargetAccountConfigurationsRequest;
import com.amazonaws.services.fis.model.ListExperimentTargetAccountConfigurationsResult;
import com.amazonaws.services.fis.model.ListExperimentTemplatesRequest;
import com.amazonaws.services.fis.model.ListExperimentTemplatesResult;
import com.amazonaws.services.fis.model.ListExperimentsRequest;
import com.amazonaws.services.fis.model.ListExperimentsResult;
import com.amazonaws.services.fis.model.ListTagsForResourceRequest;
import com.amazonaws.services.fis.model.ListTagsForResourceResult;
import com.amazonaws.services.fis.model.ListTargetAccountConfigurationsRequest;
import com.amazonaws.services.fis.model.ListTargetAccountConfigurationsResult;
import com.amazonaws.services.fis.model.ListTargetResourceTypesRequest;
import com.amazonaws.services.fis.model.ListTargetResourceTypesResult;
import com.amazonaws.services.fis.model.StartExperimentRequest;
import com.amazonaws.services.fis.model.StartExperimentResult;
import com.amazonaws.services.fis.model.StopExperimentRequest;
import com.amazonaws.services.fis.model.StopExperimentResult;
import com.amazonaws.services.fis.model.TagResourceRequest;
import com.amazonaws.services.fis.model.TagResourceResult;
import com.amazonaws.services.fis.model.UntagResourceRequest;
import com.amazonaws.services.fis.model.UntagResourceResult;
import com.amazonaws.services.fis.model.UpdateExperimentTemplateRequest;
import com.amazonaws.services.fis.model.UpdateExperimentTemplateResult;
import com.amazonaws.services.fis.model.UpdateTargetAccountConfigurationRequest;
import com.amazonaws.services.fis.model.UpdateTargetAccountConfigurationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSFISAsyncClient
extends AWSFISClient
implements AWSFISAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSFISAsyncClientBuilder asyncBuilder() {
        return AWSFISAsyncClientBuilder.standard();
    }

    AWSFISAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSFISAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateExperimentTemplateResult> createExperimentTemplateAsync(CreateExperimentTemplateRequest request) {
        return this.createExperimentTemplateAsync(request, null);
    }

    @Override
    public Future<CreateExperimentTemplateResult> createExperimentTemplateAsync(CreateExperimentTemplateRequest request, final AsyncHandler<CreateExperimentTemplateRequest, CreateExperimentTemplateResult> asyncHandler) {
        final CreateExperimentTemplateRequest finalRequest = (CreateExperimentTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateExperimentTemplateResult>(){

            @Override
            public CreateExperimentTemplateResult call() throws Exception {
                CreateExperimentTemplateResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeCreateExperimentTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTargetAccountConfigurationResult> createTargetAccountConfigurationAsync(CreateTargetAccountConfigurationRequest request) {
        return this.createTargetAccountConfigurationAsync(request, null);
    }

    @Override
    public Future<CreateTargetAccountConfigurationResult> createTargetAccountConfigurationAsync(CreateTargetAccountConfigurationRequest request, final AsyncHandler<CreateTargetAccountConfigurationRequest, CreateTargetAccountConfigurationResult> asyncHandler) {
        final CreateTargetAccountConfigurationRequest finalRequest = (CreateTargetAccountConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTargetAccountConfigurationResult>(){

            @Override
            public CreateTargetAccountConfigurationResult call() throws Exception {
                CreateTargetAccountConfigurationResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeCreateTargetAccountConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteExperimentTemplateResult> deleteExperimentTemplateAsync(DeleteExperimentTemplateRequest request) {
        return this.deleteExperimentTemplateAsync(request, null);
    }

    @Override
    public Future<DeleteExperimentTemplateResult> deleteExperimentTemplateAsync(DeleteExperimentTemplateRequest request, final AsyncHandler<DeleteExperimentTemplateRequest, DeleteExperimentTemplateResult> asyncHandler) {
        final DeleteExperimentTemplateRequest finalRequest = (DeleteExperimentTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteExperimentTemplateResult>(){

            @Override
            public DeleteExperimentTemplateResult call() throws Exception {
                DeleteExperimentTemplateResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeDeleteExperimentTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTargetAccountConfigurationResult> deleteTargetAccountConfigurationAsync(DeleteTargetAccountConfigurationRequest request) {
        return this.deleteTargetAccountConfigurationAsync(request, null);
    }

    @Override
    public Future<DeleteTargetAccountConfigurationResult> deleteTargetAccountConfigurationAsync(DeleteTargetAccountConfigurationRequest request, final AsyncHandler<DeleteTargetAccountConfigurationRequest, DeleteTargetAccountConfigurationResult> asyncHandler) {
        final DeleteTargetAccountConfigurationRequest finalRequest = (DeleteTargetAccountConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTargetAccountConfigurationResult>(){

            @Override
            public DeleteTargetAccountConfigurationResult call() throws Exception {
                DeleteTargetAccountConfigurationResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeDeleteTargetAccountConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetActionResult> getActionAsync(GetActionRequest request) {
        return this.getActionAsync(request, null);
    }

    @Override
    public Future<GetActionResult> getActionAsync(GetActionRequest request, final AsyncHandler<GetActionRequest, GetActionResult> asyncHandler) {
        final GetActionRequest finalRequest = (GetActionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetActionResult>(){

            @Override
            public GetActionResult call() throws Exception {
                GetActionResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeGetAction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetExperimentResult> getExperimentAsync(GetExperimentRequest request) {
        return this.getExperimentAsync(request, null);
    }

    @Override
    public Future<GetExperimentResult> getExperimentAsync(GetExperimentRequest request, final AsyncHandler<GetExperimentRequest, GetExperimentResult> asyncHandler) {
        final GetExperimentRequest finalRequest = (GetExperimentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetExperimentResult>(){

            @Override
            public GetExperimentResult call() throws Exception {
                GetExperimentResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeGetExperiment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetExperimentTargetAccountConfigurationResult> getExperimentTargetAccountConfigurationAsync(GetExperimentTargetAccountConfigurationRequest request) {
        return this.getExperimentTargetAccountConfigurationAsync(request, null);
    }

    @Override
    public Future<GetExperimentTargetAccountConfigurationResult> getExperimentTargetAccountConfigurationAsync(GetExperimentTargetAccountConfigurationRequest request, final AsyncHandler<GetExperimentTargetAccountConfigurationRequest, GetExperimentTargetAccountConfigurationResult> asyncHandler) {
        final GetExperimentTargetAccountConfigurationRequest finalRequest = (GetExperimentTargetAccountConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetExperimentTargetAccountConfigurationResult>(){

            @Override
            public GetExperimentTargetAccountConfigurationResult call() throws Exception {
                GetExperimentTargetAccountConfigurationResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeGetExperimentTargetAccountConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetExperimentTemplateResult> getExperimentTemplateAsync(GetExperimentTemplateRequest request) {
        return this.getExperimentTemplateAsync(request, null);
    }

    @Override
    public Future<GetExperimentTemplateResult> getExperimentTemplateAsync(GetExperimentTemplateRequest request, final AsyncHandler<GetExperimentTemplateRequest, GetExperimentTemplateResult> asyncHandler) {
        final GetExperimentTemplateRequest finalRequest = (GetExperimentTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetExperimentTemplateResult>(){

            @Override
            public GetExperimentTemplateResult call() throws Exception {
                GetExperimentTemplateResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeGetExperimentTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTargetAccountConfigurationResult> getTargetAccountConfigurationAsync(GetTargetAccountConfigurationRequest request) {
        return this.getTargetAccountConfigurationAsync(request, null);
    }

    @Override
    public Future<GetTargetAccountConfigurationResult> getTargetAccountConfigurationAsync(GetTargetAccountConfigurationRequest request, final AsyncHandler<GetTargetAccountConfigurationRequest, GetTargetAccountConfigurationResult> asyncHandler) {
        final GetTargetAccountConfigurationRequest finalRequest = (GetTargetAccountConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTargetAccountConfigurationResult>(){

            @Override
            public GetTargetAccountConfigurationResult call() throws Exception {
                GetTargetAccountConfigurationResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeGetTargetAccountConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTargetResourceTypeResult> getTargetResourceTypeAsync(GetTargetResourceTypeRequest request) {
        return this.getTargetResourceTypeAsync(request, null);
    }

    @Override
    public Future<GetTargetResourceTypeResult> getTargetResourceTypeAsync(GetTargetResourceTypeRequest request, final AsyncHandler<GetTargetResourceTypeRequest, GetTargetResourceTypeResult> asyncHandler) {
        final GetTargetResourceTypeRequest finalRequest = (GetTargetResourceTypeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTargetResourceTypeResult>(){

            @Override
            public GetTargetResourceTypeResult call() throws Exception {
                GetTargetResourceTypeResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeGetTargetResourceType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListActionsResult> listActionsAsync(ListActionsRequest request) {
        return this.listActionsAsync(request, null);
    }

    @Override
    public Future<ListActionsResult> listActionsAsync(ListActionsRequest request, final AsyncHandler<ListActionsRequest, ListActionsResult> asyncHandler) {
        final ListActionsRequest finalRequest = (ListActionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListActionsResult>(){

            @Override
            public ListActionsResult call() throws Exception {
                ListActionsResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeListActions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListExperimentResolvedTargetsResult> listExperimentResolvedTargetsAsync(ListExperimentResolvedTargetsRequest request) {
        return this.listExperimentResolvedTargetsAsync(request, null);
    }

    @Override
    public Future<ListExperimentResolvedTargetsResult> listExperimentResolvedTargetsAsync(ListExperimentResolvedTargetsRequest request, final AsyncHandler<ListExperimentResolvedTargetsRequest, ListExperimentResolvedTargetsResult> asyncHandler) {
        final ListExperimentResolvedTargetsRequest finalRequest = (ListExperimentResolvedTargetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListExperimentResolvedTargetsResult>(){

            @Override
            public ListExperimentResolvedTargetsResult call() throws Exception {
                ListExperimentResolvedTargetsResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeListExperimentResolvedTargets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListExperimentTargetAccountConfigurationsResult> listExperimentTargetAccountConfigurationsAsync(ListExperimentTargetAccountConfigurationsRequest request) {
        return this.listExperimentTargetAccountConfigurationsAsync(request, null);
    }

    @Override
    public Future<ListExperimentTargetAccountConfigurationsResult> listExperimentTargetAccountConfigurationsAsync(ListExperimentTargetAccountConfigurationsRequest request, final AsyncHandler<ListExperimentTargetAccountConfigurationsRequest, ListExperimentTargetAccountConfigurationsResult> asyncHandler) {
        final ListExperimentTargetAccountConfigurationsRequest finalRequest = (ListExperimentTargetAccountConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListExperimentTargetAccountConfigurationsResult>(){

            @Override
            public ListExperimentTargetAccountConfigurationsResult call() throws Exception {
                ListExperimentTargetAccountConfigurationsResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeListExperimentTargetAccountConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListExperimentTemplatesResult> listExperimentTemplatesAsync(ListExperimentTemplatesRequest request) {
        return this.listExperimentTemplatesAsync(request, null);
    }

    @Override
    public Future<ListExperimentTemplatesResult> listExperimentTemplatesAsync(ListExperimentTemplatesRequest request, final AsyncHandler<ListExperimentTemplatesRequest, ListExperimentTemplatesResult> asyncHandler) {
        final ListExperimentTemplatesRequest finalRequest = (ListExperimentTemplatesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListExperimentTemplatesResult>(){

            @Override
            public ListExperimentTemplatesResult call() throws Exception {
                ListExperimentTemplatesResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeListExperimentTemplates(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListExperimentsResult> listExperimentsAsync(ListExperimentsRequest request) {
        return this.listExperimentsAsync(request, null);
    }

    @Override
    public Future<ListExperimentsResult> listExperimentsAsync(ListExperimentsRequest request, final AsyncHandler<ListExperimentsRequest, ListExperimentsResult> asyncHandler) {
        final ListExperimentsRequest finalRequest = (ListExperimentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListExperimentsResult>(){

            @Override
            public ListExperimentsResult call() throws Exception {
                ListExperimentsResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeListExperiments(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTargetAccountConfigurationsResult> listTargetAccountConfigurationsAsync(ListTargetAccountConfigurationsRequest request) {
        return this.listTargetAccountConfigurationsAsync(request, null);
    }

    @Override
    public Future<ListTargetAccountConfigurationsResult> listTargetAccountConfigurationsAsync(ListTargetAccountConfigurationsRequest request, final AsyncHandler<ListTargetAccountConfigurationsRequest, ListTargetAccountConfigurationsResult> asyncHandler) {
        final ListTargetAccountConfigurationsRequest finalRequest = (ListTargetAccountConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTargetAccountConfigurationsResult>(){

            @Override
            public ListTargetAccountConfigurationsResult call() throws Exception {
                ListTargetAccountConfigurationsResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeListTargetAccountConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTargetResourceTypesResult> listTargetResourceTypesAsync(ListTargetResourceTypesRequest request) {
        return this.listTargetResourceTypesAsync(request, null);
    }

    @Override
    public Future<ListTargetResourceTypesResult> listTargetResourceTypesAsync(ListTargetResourceTypesRequest request, final AsyncHandler<ListTargetResourceTypesRequest, ListTargetResourceTypesResult> asyncHandler) {
        final ListTargetResourceTypesRequest finalRequest = (ListTargetResourceTypesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTargetResourceTypesResult>(){

            @Override
            public ListTargetResourceTypesResult call() throws Exception {
                ListTargetResourceTypesResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeListTargetResourceTypes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartExperimentResult> startExperimentAsync(StartExperimentRequest request) {
        return this.startExperimentAsync(request, null);
    }

    @Override
    public Future<StartExperimentResult> startExperimentAsync(StartExperimentRequest request, final AsyncHandler<StartExperimentRequest, StartExperimentResult> asyncHandler) {
        final StartExperimentRequest finalRequest = (StartExperimentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartExperimentResult>(){

            @Override
            public StartExperimentResult call() throws Exception {
                StartExperimentResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeStartExperiment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopExperimentResult> stopExperimentAsync(StopExperimentRequest request) {
        return this.stopExperimentAsync(request, null);
    }

    @Override
    public Future<StopExperimentResult> stopExperimentAsync(StopExperimentRequest request, final AsyncHandler<StopExperimentRequest, StopExperimentResult> asyncHandler) {
        final StopExperimentRequest finalRequest = (StopExperimentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopExperimentResult>(){

            @Override
            public StopExperimentResult call() throws Exception {
                StopExperimentResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeStopExperiment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateExperimentTemplateResult> updateExperimentTemplateAsync(UpdateExperimentTemplateRequest request) {
        return this.updateExperimentTemplateAsync(request, null);
    }

    @Override
    public Future<UpdateExperimentTemplateResult> updateExperimentTemplateAsync(UpdateExperimentTemplateRequest request, final AsyncHandler<UpdateExperimentTemplateRequest, UpdateExperimentTemplateResult> asyncHandler) {
        final UpdateExperimentTemplateRequest finalRequest = (UpdateExperimentTemplateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateExperimentTemplateResult>(){

            @Override
            public UpdateExperimentTemplateResult call() throws Exception {
                UpdateExperimentTemplateResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeUpdateExperimentTemplate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTargetAccountConfigurationResult> updateTargetAccountConfigurationAsync(UpdateTargetAccountConfigurationRequest request) {
        return this.updateTargetAccountConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateTargetAccountConfigurationResult> updateTargetAccountConfigurationAsync(UpdateTargetAccountConfigurationRequest request, final AsyncHandler<UpdateTargetAccountConfigurationRequest, UpdateTargetAccountConfigurationResult> asyncHandler) {
        final UpdateTargetAccountConfigurationRequest finalRequest = (UpdateTargetAccountConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateTargetAccountConfigurationResult>(){

            @Override
            public UpdateTargetAccountConfigurationResult call() throws Exception {
                UpdateTargetAccountConfigurationResult result = null;
                try {
                    result = AWSFISAsyncClient.this.executeUpdateTargetAccountConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

