/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.fis.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fis-2020-12-01/ListExperimentResolvedTargets" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListExperimentResolvedTargetsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * The resolved targets.
     * </p>
     */
    private java.util.List<ResolvedTarget> resolvedTargets;
    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * The resolved targets.
     * </p>
     * 
     * @return The resolved targets.
     */

    public java.util.List<ResolvedTarget> getResolvedTargets() {
        return resolvedTargets;
    }

    /**
     * <p>
     * The resolved targets.
     * </p>
     * 
     * @param resolvedTargets
     *        The resolved targets.
     */

    public void setResolvedTargets(java.util.Collection<ResolvedTarget> resolvedTargets) {
        if (resolvedTargets == null) {
            this.resolvedTargets = null;
            return;
        }

        this.resolvedTargets = new java.util.ArrayList<ResolvedTarget>(resolvedTargets);
    }

    /**
     * <p>
     * The resolved targets.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResolvedTargets(java.util.Collection)} or {@link #withResolvedTargets(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param resolvedTargets
     *        The resolved targets.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListExperimentResolvedTargetsResult withResolvedTargets(ResolvedTarget... resolvedTargets) {
        if (this.resolvedTargets == null) {
            setResolvedTargets(new java.util.ArrayList<ResolvedTarget>(resolvedTargets.length));
        }
        for (ResolvedTarget ele : resolvedTargets) {
            this.resolvedTargets.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The resolved targets.
     * </p>
     * 
     * @param resolvedTargets
     *        The resolved targets.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListExperimentResolvedTargetsResult withResolvedTargets(java.util.Collection<ResolvedTarget> resolvedTargets) {
        setResolvedTargets(resolvedTargets);
        return this;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @param nextToken
     *        The token to use to retrieve the next page of results. This value is null when there are no more results
     *        to return.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is null when there are no more results
     *         to return.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @param nextToken
     *        The token to use to retrieve the next page of results. This value is null when there are no more results
     *        to return.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListExperimentResolvedTargetsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getResolvedTargets() != null)
            sb.append("ResolvedTargets: ").append(getResolvedTargets()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListExperimentResolvedTargetsResult == false)
            return false;
        ListExperimentResolvedTargetsResult other = (ListExperimentResolvedTargetsResult) obj;
        if (other.getResolvedTargets() == null ^ this.getResolvedTargets() == null)
            return false;
        if (other.getResolvedTargets() != null && other.getResolvedTargets().equals(this.getResolvedTargets()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getResolvedTargets() == null) ? 0 : getResolvedTargets().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListExperimentResolvedTargetsResult clone() {
        try {
            return (ListExperimentResolvedTargetsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
