/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.forecast;

import javax.annotation.Generated;

import com.amazonaws.services.forecast.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonForecast}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonForecast implements AmazonForecast {

    protected AbstractAmazonForecast() {
    }

    @Override
    public CreateDatasetResult createDataset(CreateDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatasetGroupResult createDatasetGroup(CreateDatasetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatasetImportJobResult createDatasetImportJob(CreateDatasetImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateForecastResult createForecast(CreateForecastRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateForecastExportJobResult createForecastExportJob(CreateForecastExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePredictorResult createPredictor(CreatePredictorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePredictorBacktestExportJobResult createPredictorBacktestExportJob(CreatePredictorBacktestExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatasetResult deleteDataset(DeleteDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatasetGroupResult deleteDatasetGroup(DeleteDatasetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatasetImportJobResult deleteDatasetImportJob(DeleteDatasetImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteForecastResult deleteForecast(DeleteForecastRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteForecastExportJobResult deleteForecastExportJob(DeleteForecastExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePredictorResult deletePredictor(DeletePredictorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePredictorBacktestExportJobResult deletePredictorBacktestExportJob(DeletePredictorBacktestExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDatasetResult describeDataset(DescribeDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDatasetGroupResult describeDatasetGroup(DescribeDatasetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDatasetImportJobResult describeDatasetImportJob(DescribeDatasetImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeForecastResult describeForecast(DescribeForecastRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeForecastExportJobResult describeForecastExportJob(DescribeForecastExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePredictorResult describePredictor(DescribePredictorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePredictorBacktestExportJobResult describePredictorBacktestExportJob(DescribePredictorBacktestExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAccuracyMetricsResult getAccuracyMetrics(GetAccuracyMetricsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDatasetGroupsResult listDatasetGroups(ListDatasetGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDatasetImportJobsResult listDatasetImportJobs(ListDatasetImportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDatasetsResult listDatasets(ListDatasetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListForecastExportJobsResult listForecastExportJobs(ListForecastExportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListForecastsResult listForecasts(ListForecastsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPredictorBacktestExportJobsResult listPredictorBacktestExportJobs(ListPredictorBacktestExportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPredictorsResult listPredictors(ListPredictorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDatasetGroupResult updateDatasetGroup(UpdateDatasetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
