/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.forecast.model.Statistics;

@SdkInternalApi
public class StatisticsMarshaller {
    private static final MarshallingInfo<Integer> COUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Count").build();
    private static final MarshallingInfo<Integer> COUNTDISTINCT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CountDistinct").build();
    private static final MarshallingInfo<Integer> COUNTNULL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CountNull").build();
    private static final MarshallingInfo<Integer> COUNTNAN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CountNan").build();
    private static final MarshallingInfo<String> MIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Min").build();
    private static final MarshallingInfo<String> MAX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Max").build();
    private static final MarshallingInfo<Double> AVG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Avg").build();
    private static final MarshallingInfo<Double> STDDEV_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Stddev").build();
    private static final MarshallingInfo<Long> COUNTLONG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CountLong").build();
    private static final MarshallingInfo<Long> COUNTDISTINCTLONG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CountDistinctLong").build();
    private static final MarshallingInfo<Long> COUNTNULLLONG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CountNullLong").build();
    private static final MarshallingInfo<Long> COUNTNANLONG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CountNanLong").build();
    private static final StatisticsMarshaller instance = new StatisticsMarshaller();

    public static StatisticsMarshaller getInstance() {
        return instance;
    }

    public void marshall(Statistics statistics, ProtocolMarshaller protocolMarshaller) {
        if (statistics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)statistics.getCount(), COUNT_BINDING);
            protocolMarshaller.marshall((Object)statistics.getCountDistinct(), COUNTDISTINCT_BINDING);
            protocolMarshaller.marshall((Object)statistics.getCountNull(), COUNTNULL_BINDING);
            protocolMarshaller.marshall((Object)statistics.getCountNan(), COUNTNAN_BINDING);
            protocolMarshaller.marshall((Object)statistics.getMin(), MIN_BINDING);
            protocolMarshaller.marshall((Object)statistics.getMax(), MAX_BINDING);
            protocolMarshaller.marshall((Object)statistics.getAvg(), AVG_BINDING);
            protocolMarshaller.marshall((Object)statistics.getStddev(), STDDEV_BINDING);
            protocolMarshaller.marshall((Object)statistics.getCountLong(), COUNTLONG_BINDING);
            protocolMarshaller.marshall((Object)statistics.getCountDistinctLong(), COUNTDISTINCTLONG_BINDING);
            protocolMarshaller.marshall((Object)statistics.getCountNullLong(), COUNTNULLLONG_BINDING);
            protocolMarshaller.marshall((Object)statistics.getCountNanLong(), COUNTNANLONG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

