/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.frauddetector.model.ModelVersion;
import com.amazonaws.services.frauddetector.model.transform.ModelScoresMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ModelScores
implements Serializable,
Cloneable,
StructuredPojo {
    private ModelVersion modelVersion;
    private Map<String, Float> scores;

    public void setModelVersion(ModelVersion modelVersion) {
        this.modelVersion = modelVersion;
    }

    public ModelVersion getModelVersion() {
        return this.modelVersion;
    }

    public ModelScores withModelVersion(ModelVersion modelVersion) {
        this.setModelVersion(modelVersion);
        return this;
    }

    public Map<String, Float> getScores() {
        return this.scores;
    }

    public void setScores(Map<String, Float> scores) {
        this.scores = scores;
    }

    public ModelScores withScores(Map<String, Float> scores) {
        this.setScores(scores);
        return this;
    }

    public ModelScores addScoresEntry(String key, Float value) {
        if (null == this.scores) {
            this.scores = new HashMap<String, Float>();
        }
        if (this.scores.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.scores.put(key, value);
        return this;
    }

    public ModelScores clearScoresEntries() {
        this.scores = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getModelVersion() != null) {
            sb.append("ModelVersion: ").append(this.getModelVersion()).append(",");
        }
        if (this.getScores() != null) {
            sb.append("Scores: ").append(this.getScores());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelScores)) {
            return false;
        }
        ModelScores other = (ModelScores)obj;
        if (other.getModelVersion() == null ^ this.getModelVersion() == null) {
            return false;
        }
        if (other.getModelVersion() != null && !other.getModelVersion().equals(this.getModelVersion())) {
            return false;
        }
        if (other.getScores() == null ^ this.getScores() == null) {
            return false;
        }
        return other.getScores() == null || other.getScores().equals(this.getScores());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getModelVersion() == null ? 0 : this.getModelVersion().hashCode());
        hashCode = 31 * hashCode + (this.getScores() == null ? 0 : this.getScores().hashCode());
        return hashCode;
    }

    public ModelScores clone() {
        try {
            return (ModelScores)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ModelScoresMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

